/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.List;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.impl.AbstractSelect;
import org.jooq.impl.CombineOperator;

class Union<R extends Record>
extends AbstractSelect<R> {
    private static final long serialVersionUID = 7491446471677986172L;
    private final List<Select<? extends R>> queries = new ArrayList<Select<? extends R>>();
    private final CombineOperator operator;
    private final Clause[] clauses;

    Union(Configuration configuration, Select<R> query1, Select<? extends R> query2, CombineOperator operator) {
        super(configuration);
        this.queries.add(query1);
        this.queries.add(query2);
        this.operator = operator;
        switch (operator) {
            case EXCEPT: {
                this.clauses = new Clause[]{Clause.SELECT_EXCEPT};
                break;
            }
            case INTERSECT: {
                this.clauses = new Clause[]{Clause.SELECT_INTERSECT};
                break;
            }
            case UNION: {
                this.clauses = new Clause[]{Clause.SELECT_UNION};
                break;
            }
            case UNION_ALL: {
                this.clauses = new Clause[]{Clause.SELECT_UNION_ALL};
                break;
            }
            default: {
                throw new IllegalArgumentException("Operator not supported : " + (Object)((Object)operator));
            }
        }
    }

    @Override
    public final Class<? extends R> getRecordType() {
        return this.queries.get(0).getRecordType();
    }

    @Override
    public final List<Field<?>> getSelect() {
        return this.queries.get(0).getSelect();
    }

    @Override
    public final void accept(Context<?> ctx) {
        for (int i = 0; i < this.queries.size(); ++i) {
            if (i != 0) {
                ctx.formatSeparator().keyword(this.operator.toSQL(ctx.configuration().dialect())).formatSeparator();
            }
            this.wrappingParenthesis(ctx, "(");
            ctx.visit(this.queries.get(i));
            this.wrappingParenthesis(ctx, ")");
        }
    }

    private final void wrappingParenthesis(Context<?> ctx, String parenthesis) {
        switch (ctx.configuration().dialect()) {
            case DERBY: 
            case FIREBIRD: 
            case SQLITE: 
            case MARIADB: 
            case MYSQL: {
                return;
            }
        }
        if (")".equals(parenthesis)) {
            ctx.formatIndentEnd().formatNewLine();
        }
        ctx.sql(parenthesis);
        if ("(".equals(parenthesis)) {
            ctx.formatIndentStart().formatNewLine();
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return this.clauses;
    }

    @Override
    final boolean isForUpdate() {
        return false;
    }
}

