/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.domassign;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CombinedSelector;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.MatchCondition;
import cz.vutbr.web.css.MediaQuery;
import cz.vutbr.web.css.MediaSpec;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.Rule;
import cz.vutbr.web.css.RuleMedia;
import cz.vutbr.web.css.RuleSet;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.csskit.ElementUtil;
import cz.vutbr.web.domassign.Analyzer;
import cz.vutbr.web.domassign.AssignedDeclaration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class AnalyzerUtil {
    private static final Logger log = LoggerFactory.getLogger(AnalyzerUtil.class);

    public static Analyzer.OrderedRule[] getApplicableRules(List<StyleSheet> sheets, Element element, MediaSpec mediaspec) {
        Analyzer.Holder rules = new Analyzer.Holder();
        AnalyzerUtil.classifyAllSheets(sheets, rules, mediaspec);
        return AnalyzerUtil.getApplicableRules(element, rules);
    }

    public static NodeData getElementStyle(Element el, Selector.PseudoDeclaration pseudo, MatchCondition matchCond, Analyzer.OrderedRule[] applicableRules) {
        return AnalyzerUtil.makeNodeData(AnalyzerUtil.computeDeclarations(el, pseudo, applicableRules, matchCond));
    }

    private static Analyzer.OrderedRule[] getApplicableRules(Element e, Analyzer.Holder holder) {
        List<Analyzer.OrderedRule> nameRules;
        List<Analyzer.OrderedRule> idRules;
        HashSet<Analyzer.OrderedRule> candidates = new HashSet<Analyzer.OrderedRule>();
        for (String cname : ElementUtil.elementClasses(e)) {
            List<Analyzer.OrderedRule> classRules = holder.get(Analyzer.HolderItem.CLASS, cname.toLowerCase());
            if (classRules == null) continue;
            candidates.addAll(classRules);
        }
        log.trace("After CLASSes {} total candidates.", (Object)candidates.size());
        String id = ElementUtil.elementID(e);
        if (id != null && id.length() != 0 && (idRules = holder.get(Analyzer.HolderItem.ID, id.toLowerCase())) != null) {
            candidates.addAll(idRules);
        }
        log.trace("After IDs {} total candidates.", (Object)candidates.size());
        String name = ElementUtil.elementName(e);
        if (name != null && (nameRules = holder.get(Analyzer.HolderItem.ELEMENT, name.toLowerCase())) != null) {
            candidates.addAll(nameRules);
        }
        log.trace("After ELEMENTs {} total candidates.", (Object)candidates.size());
        candidates.addAll(holder.get(Analyzer.HolderItem.OTHER, null));
        int totalCandidates = candidates.size();
        log.debug("Totally {} candidates.", (Object)totalCandidates);
        Object[] clist = candidates.toArray(new Analyzer.OrderedRule[totalCandidates]);
        Arrays.sort(clist);
        log.trace("With values: {}", (Object)Arrays.toString(clist));
        return clist;
    }

    static NodeData makeNodeData(List<Declaration> decls) {
        NodeData main = CSSFactory.createNodeData();
        for (Declaration d : decls) {
            main.push(d);
        }
        return main;
    }

    static void classifyAllSheets(List<StyleSheet> sheets, Analyzer.Holder rules, MediaSpec mediaspec) {
        for (StyleSheet sheet : sheets) {
            AnalyzerUtil.classifyRules(sheet, mediaspec, rules);
        }
    }

    static boolean elementSelectorMatches(Selector s, Element e, MatchCondition matchCond) {
        return matchCond == null ? s.matches(e) : s.matches(e, matchCond);
    }

    private static boolean nodeSelectorMatches(Selector s, Node n, MatchCondition matchCond) {
        if (n.getNodeType() == 1) {
            Element e = (Element)n;
            return matchCond == null ? s.matches(e) : s.matches(e, matchCond);
        }
        return false;
    }

    static List<Declaration> computeDeclarations(Element e, Selector.PseudoDeclaration pseudo, Analyzer.OrderedRule[] clist, MatchCondition matchCond) {
        ArrayList<Declaration> eldecl = new ArrayList<Declaration>();
        for (Analyzer.OrderedRule orule : clist) {
            RuleSet rule = orule.getRule();
            StyleSheet sheet = rule.getStyleSheet();
            StyleSheet.Origin origin = sheet == null ? StyleSheet.Origin.AGENT : sheet.getOrigin();
            for (CombinedSelector s : rule.getSelectors()) {
                if (!AnalyzerUtil.matchSelector(s, e, matchCond)) {
                    log.trace("CombinedSelector \"{}\" NOT matched!", (Object)s);
                    continue;
                }
                log.trace("CombinedSelector \"{}\" matched", (Object)s);
                Selector.PseudoDeclaration psel = s.getPseudoElement();
                CombinedSelector.Specificity spec = s.computeSpecificity();
                if (psel != pseudo) continue;
                for (Declaration d : rule) {
                    eldecl.add(new AssignedDeclaration(d, spec, origin));
                }
            }
        }
        Collections.sort(eldecl);
        log.debug("Sorted {} declarations.", (Object)eldecl.size());
        log.trace("With values: {}", eldecl);
        return eldecl;
    }

    public static boolean hasPseudoSelector(Analyzer.OrderedRule[] rules, Element e, MatchCondition matchCond, Selector.PseudoDeclaration pd) {
        for (Analyzer.OrderedRule rule : rules) {
            for (CombinedSelector cs : rule.getRule().getSelectors()) {
                Selector lastSelector = (Selector)cs.get(cs.size() - 1);
                if (!lastSelector.hasPseudoDeclaration(pd)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPseudoSelectorForAncestor(Analyzer.OrderedRule[] rules, Element e, Element targetAncestor, MatchCondition matchCond, Selector.PseudoDeclaration pd) {
        for (Analyzer.OrderedRule rule : rules) {
            for (CombinedSelector cs : rule.getRule().getSelectors()) {
                if (!AnalyzerUtil.hasPseudoSelectorForAncestor(cs, e, targetAncestor, matchCond, pd)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean hasPseudoSelectorForAncestor(CombinedSelector sel, Element e, Element targetAncestor, MatchCondition matchCond, Selector.PseudoDeclaration pd) {
        boolean retval = false;
        Selector.Combinator combinator = null;
        Element current = e;
        for (int i = sel.size() - 1; i >= 0; --i) {
            Selector s = (Selector)sel.get(i);
            if (combinator == null) {
                retval = AnalyzerUtil.elementSelectorMatches(s, current, matchCond);
            } else if (combinator == Selector.Combinator.ADJACENT) {
                Node adjacent = current;
                while ((adjacent = adjacent.getPreviousSibling()) != null && adjacent.getNodeType() != 1) {
                }
                retval = false;
                if (adjacent != null && adjacent.getNodeType() == 1) {
                    current = (Element)adjacent;
                    retval = AnalyzerUtil.elementSelectorMatches(s, current, matchCond);
                }
            } else if (combinator == Selector.Combinator.PRECEDING) {
                Node preceding = current.getPreviousSibling();
                retval = false;
                do {
                    if (preceding == null) continue;
                    if (AnalyzerUtil.nodeSelectorMatches(s, preceding, matchCond)) {
                        current = (Element)preceding;
                        retval = true;
                        continue;
                    }
                    preceding = preceding.getPreviousSibling();
                } while (!retval && preceding != null);
            } else if (combinator == Selector.Combinator.DESCENDANT) {
                Node ancestor = current.getParentNode();
                retval = false;
                do {
                    if (ancestor == null) continue;
                    if (AnalyzerUtil.nodeSelectorMatches(s, ancestor, matchCond)) {
                        current = (Element)ancestor;
                        retval = true;
                        continue;
                    }
                    ancestor = ancestor.getParentNode();
                } while (!retval && ancestor != null);
            } else if (combinator == Selector.Combinator.CHILD) {
                Node parent = current.getParentNode();
                retval = false;
                if (parent != null && parent.getNodeType() == 1) {
                    current = (Element)parent;
                    retval = AnalyzerUtil.elementSelectorMatches(s, current, matchCond);
                }
            }
            combinator = s.getCombinator();
            if (!retval) break;
            if (current != targetAncestor) continue;
            return s.hasPseudoDeclaration(pd);
        }
        return false;
    }

    protected static boolean matchSelector(CombinedSelector sel, Element e, MatchCondition matchCond) {
        boolean retval = false;
        Selector.Combinator combinator = null;
        Element current = e;
        for (int i = sel.size() - 1; i >= 0; --i) {
            Selector s = (Selector)sel.get(i);
            log.trace("Iterating loop with selector {}, combinator {}", (Object)s, combinator);
            if (combinator == null) {
                retval = AnalyzerUtil.elementSelectorMatches(s, current, matchCond);
            } else if (combinator == Selector.Combinator.ADJACENT) {
                Node adjacent = current;
                while ((adjacent = adjacent.getPreviousSibling()) != null && adjacent.getNodeType() != 1) {
                }
                retval = false;
                if (adjacent != null && adjacent.getNodeType() == 1) {
                    current = (Element)adjacent;
                    retval = AnalyzerUtil.elementSelectorMatches(s, current, matchCond);
                }
            } else if (combinator == Selector.Combinator.PRECEDING) {
                Node preceding = current.getPreviousSibling();
                retval = false;
                do {
                    if (preceding == null) continue;
                    if (AnalyzerUtil.nodeSelectorMatches(s, preceding, matchCond)) {
                        current = (Element)preceding;
                        retval = true;
                        continue;
                    }
                    preceding = preceding.getPreviousSibling();
                } while (!retval && preceding != null);
            } else if (combinator == Selector.Combinator.DESCENDANT) {
                Node ancestor = current.getParentNode();
                retval = false;
                do {
                    if (ancestor == null) continue;
                    if (AnalyzerUtil.nodeSelectorMatches(s, ancestor, matchCond)) {
                        current = (Element)ancestor;
                        retval = true;
                        continue;
                    }
                    ancestor = ancestor.getParentNode();
                } while (!retval && ancestor != null);
            } else if (combinator == Selector.Combinator.CHILD) {
                Node parent = current.getParentNode();
                retval = false;
                if (parent != null && parent.getNodeType() == 1) {
                    current = (Element)parent;
                    retval = AnalyzerUtil.elementSelectorMatches(s, current, matchCond);
                }
            }
            combinator = s.getCombinator();
            if (!retval) break;
        }
        return retval;
    }

    private static List<Analyzer.HolderSelector> classifySelector(CombinedSelector selector) {
        ArrayList<Analyzer.HolderSelector> hs = new ArrayList<Analyzer.HolderSelector>();
        try {
            String id;
            String className;
            Selector last = selector.getLastSelector();
            String element = last.getElementName();
            if (element != null) {
                if ("*".equals(element)) {
                    hs.add(new Analyzer.HolderSelector(Analyzer.HolderItem.OTHER, null));
                } else {
                    hs.add(new Analyzer.HolderSelector(Analyzer.HolderItem.ELEMENT, element.toLowerCase()));
                }
            }
            if ((className = last.getClassName()) != null) {
                hs.add(new Analyzer.HolderSelector(Analyzer.HolderItem.CLASS, className.toLowerCase()));
            }
            if ((id = last.getIDName()) != null) {
                hs.add(new Analyzer.HolderSelector(Analyzer.HolderItem.ID, id.toLowerCase()));
            }
            if (hs.size() == 0) {
                hs.add(new Analyzer.HolderSelector(Analyzer.HolderItem.OTHER, null));
            }
            return hs;
        }
        catch (UnsupportedOperationException e) {
            log.error("CombinedSelector does not include any selector, this should not happen!");
            return Collections.emptyList();
        }
    }

    private static void insertClassified(Analyzer.Holder holder, List<Analyzer.HolderSelector> hs, RuleSet value, Counter orderCounter) {
        for (Analyzer.HolderSelector h : hs) {
            holder.insert(h.item, h.key, new Analyzer.OrderedRule(value, orderCounter.getAndIncrement()));
        }
    }

    private static void classifyRules(StyleSheet sheet, MediaSpec mediaspec, Analyzer.Holder rules) {
        Counter orderCounter = new Counter();
        for (Rule rule : sheet) {
            if (rule instanceof RuleSet) {
                RuleSet ruleset = (RuleSet)rule;
                for (CombinedSelector s : ruleset.getSelectors()) {
                    AnalyzerUtil.insertClassified(rules, AnalyzerUtil.classifySelector(s), ruleset, orderCounter);
                }
                continue;
            }
            if (!(rule instanceof RuleMedia)) continue;
            RuleMedia rulemedia = (RuleMedia)rule;
            boolean mediaValid = false;
            if (rulemedia.getMediaQueries() == null || rulemedia.getMediaQueries().isEmpty()) {
                mediaValid = mediaspec.matchesEmpty();
            } else {
                for (MediaQuery media : rulemedia.getMediaQueries()) {
                    if (!mediaspec.matches(media)) continue;
                    mediaValid = true;
                    break;
                }
            }
            if (!mediaValid) continue;
            for (RuleSet ruleset : rulemedia) {
                for (CombinedSelector s : ruleset.getSelectors()) {
                    AnalyzerUtil.insertClassified(rules, AnalyzerUtil.classifySelector(s), ruleset, orderCounter);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("For media \"{}\" we have {} rules", (Object)mediaspec, (Object)rules.contentCount());
            if (log.isTraceEnabled()) {
                log.trace("Detailed view: \n{}", (Object)rules);
            }
        }
    }

    private static class Counter {
        private int count = 0;

        private Counter() {
        }

        public int getAndIncrement() {
            return this.count++;
        }
    }
}

