/*
 * Decompiled with CFR 0.152.
 */
package co.uproot.css.domimpl;

import co.uproot.css.domimpl.CSSFontFaceRuleImpl;
import co.uproot.css.domimpl.CSSMediaRuleImpl;
import co.uproot.css.domimpl.CSSPageRuleImpl;
import co.uproot.css.domimpl.CSSStyleRuleImpl;
import co.uproot.css.domimpl.CSSUnknownRuleImpl;
import co.uproot.css.domimpl.JStyleSheetWrapper;
import cz.vutbr.web.css.RuleBlock;
import cz.vutbr.web.css.RuleFontFace;
import cz.vutbr.web.css.RuleMedia;
import cz.vutbr.web.css.RulePage;
import cz.vutbr.web.css.RuleSet;
import cz.vutbr.web.css.StyleSheet;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;

final class CSSRuleListImpl
implements CSSRuleList {
    protected final JStyleSheetWrapper parentStyleSheet;
    private final StyleSheet jSheet;

    CSSRuleListImpl(StyleSheet jSheet, JStyleSheetWrapper parentStyleSheet) {
        this.parentStyleSheet = parentStyleSheet;
        this.jSheet = jSheet;
    }

    @Override
    public int getLength() {
        return this.jSheet.size();
    }

    @Override
    public CSSRule item(int index) {
        try {
            RuleBlock ruleBlock = (RuleBlock)this.jSheet.asList().get(index);
            if (ruleBlock instanceof RuleSet) {
                RuleSet ruleSet = (RuleSet)ruleBlock;
                return new CSSStyleRuleImpl(ruleSet, this.parentStyleSheet);
            }
            if (ruleBlock instanceof RuleFontFace) {
                RuleFontFace ruleFontFace = (RuleFontFace)ruleBlock;
                return new CSSFontFaceRuleImpl(ruleFontFace, this.parentStyleSheet);
            }
            if (ruleBlock instanceof RulePage) {
                RulePage rulePage = (RulePage)ruleBlock;
                return new CSSPageRuleImpl(rulePage, this.parentStyleSheet);
            }
            if (ruleBlock instanceof RuleMedia) {
                RuleMedia mediaRule = (RuleMedia)ruleBlock;
                return new CSSMediaRuleImpl(mediaRule, this.parentStyleSheet);
            }
            return new CSSUnknownRuleImpl(this.parentStyleSheet);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }
}

