/*
 * Decompiled with CFR 0.152.
 */
package co.uproot.css.domimpl;

import co.uproot.css.domimpl.AbstractCSSRule;
import co.uproot.css.domimpl.CSSStyleDeclarationImpl;
import co.uproot.css.domimpl.CSSUtils;
import co.uproot.css.domimpl.JStyleSheetWrapper;
import cz.vutbr.web.css.CombinedSelector;
import cz.vutbr.web.css.RuleSet;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;

final class CSSStyleRuleImpl
extends AbstractCSSRule
implements CSSStyleRule {
    final RuleSet ruleSet;

    CSSStyleRuleImpl(RuleSet ruleSet, JStyleSheetWrapper containingStyleSheet) {
        super(containingStyleSheet);
        this.ruleSet = ruleSet;
    }

    @Override
    public short getType() {
        return 1;
    }

    @Override
    public String getCssText() {
        return this.ruleSet.toString();
    }

    @Override
    public String getSelectorText() {
        String selector = this.ruleSet.getSelectors().toString();
        return CSSUtils.removeBrackets(selector);
    }

    @Override
    public CSSStyleDeclaration getStyle() {
        return new CSSStyleDeclarationImpl(this.ruleSet.asList(), this);
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSelectorText(String selectorText) throws DOMException {
        List<CombinedSelector> combinedSelectors = CSSUtils.createCombinedSelectors(selectorText);
        this.ruleSet.getSelectors().clear();
        this.ruleSet.setSelectors(combinedSelectors);
        this.containingStyleSheet.informChanged();
    }

    public String toString() {
        return this.ruleSet.toString();
    }
}

