/*
 * Decompiled with CFR 0.152.
 */
package co.uproot.css.domimpl;

import co.uproot.css.domimpl.CSSRuleListImpl;
import co.uproot.css.domimpl.CSSUtils;
import co.uproot.css.domimpl.MediaListImpl;
import co.uproot.css.domimpl.StyleSheetBridge;
import co.uproot.css.domimpl.StyleSheetListImpl;
import cz.vutbr.web.css.RuleBlock;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;

public final class JStyleSheetWrapper
implements CSSStyleSheet {
    private volatile cz.vutbr.web.css.StyleSheet jStyleSheet;
    private final CSSStyleSheet parentStyleSheet;
    private final String mediaStr;
    private final StyleSheetBridge bridge;
    private volatile boolean disabled;
    private final String href;
    private Node ownerNode;
    private final String type;
    private final String title;

    JStyleSheetWrapper(cz.vutbr.web.css.StyleSheet jStyleSheet, String mediaStr, String href, Node ownerNode, CSSStyleSheet parentStyleSheet, String type, String title, StyleSheetBridge bridge) {
        this.jStyleSheet = jStyleSheet;
        this.mediaStr = mediaStr;
        this.href = href;
        this.bridge = bridge;
        this.ownerNode = ownerNode;
        this.type = type;
        this.title = title;
        this.parentStyleSheet = parentStyleSheet;
    }

    public JStyleSheetWrapper(cz.vutbr.web.css.StyleSheet jStyleSheet, String mediaStr, String href, CSSStyleSheet parentStyleSheet, StyleSheetBridge bridge) {
        this(jStyleSheet, mediaStr, href, null, parentStyleSheet, null, null, bridge);
    }

    public JStyleSheetWrapper(cz.vutbr.web.css.StyleSheet jStyleSheet, String mediaStr, String href, String type, String title, Node ownerNode, StyleSheetBridge bridge) {
        this(jStyleSheet, mediaStr, href, ownerNode, null, type, title, bridge);
    }

    @Override
    public boolean getDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        this.informChanged();
    }

    @Override
    public String getHref() {
        return this.href;
    }

    @Override
    public MediaList getMedia() {
        return new MediaListImpl(this.mediaStr, this);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Node getOwnerNode() {
        return this.ownerNode;
    }

    public void setOwnerNode(Node ownerNode) {
        this.ownerNode = ownerNode;
    }

    @Override
    public StyleSheet getParentStyleSheet() {
        return this.parentStyleSheet;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public CSSRule getOwnerRule() {
        throw new DOMException(9, "this operation is not supported");
    }

    @Override
    public CSSRuleList getCssRules() {
        if (this.jStyleSheet != null) {
            return new CSSRuleListImpl(this.jStyleSheet, this);
        }
        throw new DOMException(15, "A parameter or an operation is not supported by the underlying object");
    }

    @Override
    public int insertRule(String rule, int index) throws DOMException {
        cz.vutbr.web.css.StyleSheet jSheet = CSSUtils.parse(rule);
        if (jSheet.size() > 0) {
            this.jStyleSheet.add(index, (Object)((RuleBlock)jSheet.get(0)));
            this.bridge.notifyStyleSheetChanged(this);
            return index;
        }
        return -1;
    }

    @Override
    public void deleteRule(int index) throws DOMException {
        this.jStyleSheet.remove(index);
        this.bridge.notifyStyleSheetChanged(this);
    }

    public cz.vutbr.web.css.StyleSheet getJStyleSheet() {
        return this.jStyleSheet;
    }

    public void setJStyleSheet(cz.vutbr.web.css.StyleSheet jStyleSheet) {
        this.jStyleSheet = jStyleSheet;
    }

    protected void informChanged() {
        this.bridge.notifyStyleSheetChanged(this);
    }

    public static StyleSheetList getStyleSheets(StyleSheetBridge bridge) {
        return new StyleSheetListImpl(bridge);
    }
}

