/*
 * Decompiled with CFR 0.152.
 */
package co.uproot.css.domimpl;

import co.uproot.css.domimpl.JStyleSheetWrapper;
import cz.vutbr.web.css.MediaQuery;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.stylesheets.MediaList;

final class MediaListImpl
implements MediaList {
    private final JStyleSheetWrapper containingStyleSheet;
    private final List<String> mediaList;

    MediaListImpl(String mediaListStr, JStyleSheetWrapper containingStyleSheet) {
        this.mediaList = this.splitMediaList(mediaListStr);
        this.containingStyleSheet = containingStyleSheet;
    }

    MediaListImpl(List<MediaQuery> mediaQueries, JStyleSheetWrapper containingStyleSheet) {
        ArrayList<String> mediaList = new ArrayList<String>();
        for (MediaQuery mediaQuery : mediaQueries) {
            mediaList.add(mediaQuery.getType());
        }
        this.mediaList = mediaList;
        this.containingStyleSheet = containingStyleSheet;
    }

    @Override
    public String getMediaText() {
        return this.mediaList.toString();
    }

    @Override
    public void setMediaText(String mediaText) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLength() {
        return this.mediaList.size();
    }

    @Override
    public String item(int index) {
        return this.mediaList.get(index);
    }

    @Override
    public void deleteMedium(String oldMedium) throws DOMException {
        int index = this.mediaList.indexOf(oldMedium);
        this.mediaList.remove(index);
        this.containingStyleSheet.informChanged();
    }

    @Override
    public void appendMedium(String newMedium) throws DOMException {
        this.mediaList.add(newMedium);
        this.containingStyleSheet.informChanged();
    }

    private List<String> splitMediaList(String mediaListStr) {
        if (mediaListStr != null && mediaListStr.length() > 0) {
            String[] mediaArray = mediaListStr.split(",");
            ArrayList<String> mediaList = new ArrayList<String>();
            String[] stringArray = mediaArray;
            int n = mediaArray.length;
            int n2 = 0;
            while (n2 < n) {
                String media = stringArray[n2];
                mediaList.add(media);
                ++n2;
            }
            return mediaList;
        }
        return new ArrayList<String>();
    }

    public String toString() {
        return this.mediaList.toString();
    }
}

