# Upgrading To v1.1 From v1.0

## High Impact Changes

- [Updating Dependencies](#updating-dependencies)
- [Update Providers](#update-providers)
- [Add Config](#add-config)

## Medium Impact Changes

- [facades.Cache Add Methods](#facades-cache-add-methods)

## Low Impact Changes

- [Add facades.Auth](#add-facades-auth)

## Upgrade Guide

**Estimated Upgrade Time: 1 Minutes**

### Updating Dependencies

**Likelihood Of Impact: High**

Update dependencies in the `go.mod` file：

```go
github.com/goravel/framework v1.1.1
```

### Update Providers

**Likelihood Of Impact: High**

Add Auth Provider in the `config.app.go` file:

```go
"github.com/goravel/framework/auth"

"providers": []contracts.ServiceProvider{
  ...
  &mail.ServiceProvider{},
  &auth.ServiceProvider{},
  &providers.AppServiceProvider{},
  ...
}
```

### Add Config

**Likelihood Of Impact: High**

Add file in the `config` directory:

1. [auth.go](https://github.com/goravel/goravel/blob/v1.1.1/config/auth.go)
2. [jwt.go](https://github.com/goravel/goravel/blob/v1.1.1/config/jwt.go)

### Add facades.Cache methods

**Likelihood Of Impact: Medium**

Add methods：

1. [facades.Cache.GetBool](https://github.com/goravel/framework/blob/87c7fa9b95e45fcf4f88a502f1a1adc213527ae1/contracts/cache/store.go#L9)
2. [facades.Cache.GetInt](https://github.com/goravel/framework/blob/87c7fa9b95e45fcf4f88a502f1a1adc213527ae1/contracts/cache/store.go#L10)
3. [facades.Cache.GetString](https://github.com/goravel/framework/blob/87c7fa9b95e45fcf4f88a502f1a1adc213527ae1/contracts/cache/store.go#L11)

You need to implement the new three interfaces if you are using [Adding Custom Cache Drivers](https://github.com/goravel/docs/blob/master/digging-deeper/cache.md#adding-custom-cache-drivers).

### Add facades.Auth

**Likelihood Of Impact: Low**

Add Authentication [facades.Auth](../security/authentication.md)。

<CommentService/>