# Upgrading To v1.10 From v1.9

[[toc]]

## Exciting New Features 🎉

- [Add facades.Crypt(1.10.0)](#encryption)
- [Add facades.Hash(1.10.0)](#hashing)
- [Add Rate Limiting For Routing(1.10.0)](#add-rate-limiting-for-routing)

## Enhancements 🚀

- [Optimize HTTP startup mode(1.10.0)](#optimize-http-startup-mode)
- [Optimize GRPC startup mode(1.10.0)](#optimize-grpc-startup-mode)
- [Add configuration to control log output to console(1.10.0)](#add-configuration-to-control-log-output-to-console)
- [Request modify and add methods(1.10.0)](#request-modify-and-add-methods)
- [Queue support delayed dispatching(1.10.0)](#queue-support-delayed-dispatching)
- [The Connection in ORM supports set table prefix and singular(1.10.0)](#the-connection-in-orm-supports-set-table-prefix-and-singular)
- [Add docker-compose.yml file(1.10.0)](#add-docker-compose-yml-file)
- [Optimize Orm(1.10.0)](#optimize-orm)
- [Support multiple SQL in migration file(1.10.0)](#support-multiple-sql-in-migration-file)
- [Add minio driver for File Storage(1.10.0)](#add-minio-driver-for-file-storage)
- [contracts/http add status mapping of net/http(1.10.0)](#contracts-http-add-status-mapping-of-net-http)

## Breaking Changes 🛠

- [APP_KEY required(1.10.0)](#app-key-required)
- [Add ctx parameter to the methods under Form Request(1.10.0)](#add-ctx-parameter-to-the-methods-under-form-request)
- [facades.Auth.Parse adds payload returns(1.10.0)](#facades-auth-parse-add-payload-returns)
- [Some methods of Orm add new return values(1.10.0)](#some-methods-of-orm-add-new-return-values)

## Upgrade Guide

**Estimated Upgrade Time: 20 Minutes**

### Updating Dependencies

Update dependencies in the `go.mod` file:

```
go get -u github.com/goravel/framework@v1.10.0 && go mod tidy
```

### Encryption

Version: v1.10.0

Add `facades.Crypt`:

1. add `&crypt.ServiceProvider{}` to the `providers` item in the [config/app.go](https://github.com/goravel/goravel/blob/v1.10.x/config/app.go) file;

[For Detail](../security/encryption.md)

### Hashing

Version: v1.10.0

Add `facades.Hash`:

1. add `&hash.ServiceProvider{}` to the `providers` item in the [config/app.go](https://github.com/goravel/goravel/blob/v1.10.x/config/app.go) file;

2. Add [config/hashing.go](https://github.com/goravel/goravel/blob/v1.10.x/config/hashing.go) file;

[For Detail](../security/hashing.md)

### Add Rate Limiting For Routing

Version: v1.10.0

[For Detail](../the-basics/routing.md#Rate-Limiting)

### Optimize HTTP startup mode

Version: v1.10.0

1. Add `config/http.go` configuration, [For Detail](https://github.com/goravel/goravel/blob/v1.10.x/config/http.go);
2. The `facades.Route.Run` method no longer needs to pass parameters, by default use `http.host` and `http.port`(you don't need to modify the code, it's backward compatible);
3. The `facades.Route.RunTLS` method no longer needs to pass parameters, by default use `http.tls.host`, `http.tls.port`, `http.tls.ssl.cert` and `http.tls.ssl.key`, if you are using it, you need to modify the code;
4. Add `facades.Route.RunTLSWithCert` method, [For Detail](../the-basics/routing.md#start-server);
5. Move `app.url`, `app.host` to `http.url`, `http.host`;

### Optimize GRPC startup mode

Version: v1.10.0

The `facades.Grpc.Run` method no longer needs to pass parameters, by default use `grpc.host` and `grpc.port`(you don't need to modify the code, it's backward compatible);

### Add configuration to control log output to console

Version: v1.10.0

Add `print` configuration to `single`, `daily` channel in the `config/logging.go` file, it can control log output to console, [For Detail](https://github.com/goravel/goravel/blob/v1.10.x/config/logging.go);

### Request modify and add methods

Version: v1.10.0

1. The `Input` method is changed from only getting routing parameters to getting data according to the following order: `json`, `form`, `query`, `route`。Note: `json` can only get one-dimensional data, otherwise it will return empty;
2. Add `Route` method to replace the original `Input` method;
3. The default value of `Query` and `Form` methods are modified to be unnecessary;
4. Add methods as shown below:

| Method        | Action           |
| -----------  | -------------- |
| Route        | [Retrieving An Route Value](../the-basics/request.md#Retrieving-An-Input-Value)     |
| RouteInt        | [Retrieving An Route Value](../the-basics/request.md#Retrieving-An-Input-Value)     |
| RouteInt64        | [Retrieving An Route Value](../the-basics/request.md#Retrieving-An-Input-Value)     |
| QueryInt        | [Retrieving Input From The Query String](../the-basics/request.md#Retrieving-Input-From-The-Query-String)     |
| QueryInt64        | [Retrieving Input From The Query String](../the-basics/request.md#Retrieving-Input-From-The-Query-String)     |
| QueryBool        | [Retrieving Input From The Query String](../the-basics/request.md#Retrieving-Input-From-The-Query-String)     |
| InputInt        | [Retrieving An Input Value](../the-basics/request.md#Retrieving-An-Input-Value)     |
| InputInt64        | [Retrieving An Input Value](../the-basics/request.md#Retrieving-An-Input-Value)     |
| InputBool        | [Retrieving An Input Value](../the-basics/request.md#Retrieving-An-Input-Value)     |
| Json        | [Retrieving Json](../the-basics/request.md#Retrieving-Json)     |

### Queue support delayed dispatching

Version: v1.10.0

Add `Delay` method, [For Detail](../digging-deeper/queues.md#Delayed-Dispatching)

### The Connection in ORM supports set table prefix and singular

Version: v1.10.0

1. `Model` supports specify table name, [For Detail](../orm/getting-started.md#指定表名);
2. Add new keys to `connection` of `config/database.go`:

`prefix`: Set prefix for table name;
`singular`: Set the table name to use singular or plural;

[For Detail](https://github.com/goravel/goravel/blob/v1.10.x/config/database.go)

### Add docker-compose.yml file

Version: v1.10.0

You can quickly start the service with the following command:

```
docker-compose build
docker-compose up
```

### Optimize Orm

Version: v1.10.0

1. Add the following methods:

| Functions     | Action                                                  |
| ------------- | ------------------------------------------------------- |
| FirstOr | [Query or return data through callback](#Query-one-line)                     |
| FirstOrNew | [Retrieving Or New Models](#Retrieving-Or-Creating-Models)                     |
| FirstOrFail | [Not Found Error](#Not-Found-Error)                     |
| UpdateOrCreate       | [Update or create](#Update-or-create)                  |

2. An error was reported like this before, but now it's supported:

```go
query := facades.Orm.Query()
query = query.Where()
```

### Support multiple SQL in migration file

Version: v1.10.0

Previously, only one SQL statement was supported in the migration file, but now multiple statements are supported.

### Add minio driver for File Storage

Version: v1.10.0

Add minio configuration, [For Detail](https://github.com/goravel/goravel/blob/v1.10.x/config/filesystems.go).

### contracts/http add status mapping of net/http

Version: v1.10.0

You can use status codes such as `http.StatusOK` directly in controller without importing `net/http`.

[For Detail](https://github.com/goravel/framework/blob/v1.10.0/contracts/http/status.go)

### APP_KEY required

Version: v1.10.0

The `APP_KEY` in the `.env` file is changed to required, you can run command to generate the APP_KEY: `go run . artisan key:generate`.

### Add ctx parameter to the methods under Form Request

Version: v1.10.0

Add `ctx http.Context` parameter to the methods under Form Request: `Rules`, `Messages`, `Attributes`, `PrepareForValidation`, allows you to do more custom configurations.

[For Detail](../the-basics/validation.md#creating-form-requests)

### facades.Auth.Parse add payload returns

Version: v1.10.0

`err := facades.Auth.Parse(ctx, token)` change to `payload, err := facades.Auth.Parse(ctx, token)`, through `payload` you can get:

1. `Guard`: Current Guard;
2. `Key`: User flag;
3. `ExpireAt`: Expire time;
4. `IssuedAt`: Issued time;

[For Detail](../security/authentication.md#parse-token)

### Some methods of Orm add new return values

Version: v1.10.0

The following methods add `*Result` return value to get the number of affected rows: 

```go
res, err := query.Delete(&user)
res, err := query.Exec(fmt.Sprintf("DELETE FROM users where id = %d", user.ID))
res, err := query.ForceDelete(&User{})
res, err := query.Updates(User{Avatar: "avatar"})

// Affected rows
num := res.RowsAffected
```

<CommentService/>