# Upgrading To v1.11 From v1.10

[[toc]]

## v1.11.3

### Bug Fixes 🐛

- [The problem of process interruption caused by panic in Schedule](#the-problem-of-process-interruption-caused-by-panic-in-schedule)
- [The problem that DailyAt in Schedule will be executed every minute](#the-problem-that-dailyat-in-schedule-will-be-executed-every-minute)

## v1.11.2

### Bug Fixes 🐛

- [Fix the data error of using Request.Input() and Request.Bind() at the same time](#fix-the-data-error-of-using-request-input()-and-request-bind()-at-the-same-time)

## v1.11.1

### Exciting New Features 🎉

- [Route add resource routing](#route-add-resource-routing)
- [Request add new methods](#request-add-new-methods)
- [Storage add new methods](#storage-add-new-methods)
- [File add new methods](#file-add-new-methods)

### Bug Fixes 🐛

- [Fix the error of incorrect windows path for Filesystem](#fix-the-error-of-incorrect-windows-path-for-filesystem)
- [Fix the panic of the Header method for Request](#fix-the-panic-of-the-header-method-for-request)

## v1.11.0

## Exciting New Features 🎉

- [Orm add model events(1.11.0)](#orm-add-model-events)

## Enhancements 🚀

- [Cache add and optimize methods(1.11.0)](#cache-add-and-optimize-methods)
- [Route supports Fallback route(1.11.0)](#route-supports-fallback-route)
- [Orm adds new methods(1.11.0)](#orm-adds-new-methods)
- [Optimize facades.Config.Add()(1.11.0)](#optimize-facades-config-add)
- [Change Sqlite driver(1.11.0)](#change-sqlite-driver)
- [contracts/http add method mapping of net/http(1.11.0)](#contracts-http-add-method-mapping-of-net-http)

### Breaking Changes 🛠

- [Orm removes methods(1.11.0)](#_2-remove-deprecated-methods)

### Bug Fixes 🐛

- The problem that the hashing configuration does not take effect under some situations(1.11.0)
- Non-thread safety problems in RateLimiter(1.11.0)

## Upgrade Guide

Please upgrade the framework step by step according to the content in this section.

**Estimated Upgrade Time: 1 Minutes**

### Updating Dependencies

Update dependencies in the `go.mod` file:

```
go get -u github.com/goravel/framework@v1.11.0 && go mod tidy
```

```
go get -u github.com/goravel/framework@v1.11.0 && go mod tidy
```

### 2. Remove deprecated methods 

```
import (
  "github.com/goravel/framework/database"
  "github.com/goravel/framework/database/gorm"
)

// Deprecated
database.NewGormInstance()
// Replace with(Note: This method is not recommended, please try not to use it)
gorm.New()

// Deprecated
facades.Orm.Query().Updates()
// Replace with(Only modify the method name is fine, no need to modify the parameters)
facades.Orm.Query().Update()

// The Update method changes return value
// Before
err := facades.Orm.Query().Update()
// After
res, err := facades.Orm.Query().Update()
```

## New Content

This section does not involve code changes, only enhancements.

### Orm add model events

Version: v1.10.1

Orm models dispatch several events, allowing you to hook into the following moments in a model's lifecycle: `Retrieved`, `Creating`, `Created`, `Updating`, `Updated`, `Saving`, `Saved`, `Deleting`, `Deleted`, `ForceDeleting`, `ForceDeleted`.

[For Detail](../orm/getting-started.md#events)

### Cache add and optimize methods

Version: v1.10.1

#### New Methods

| Methods        | Action           |
| -----------  | -------------- |
| Decrement    | [Decrement](../digging-deeper/cache.md#incrementing--decrementing-values)     |
| Increment    | [Increment](../digging-deeper/cache.md#incrementing--decrementing-values)     |
| Lock         | [Atomic Locks](../digging-deeper/cache.md#atomic-locks)     |
| Store        | [Accessing Multiple Cache Stores](../digging-deeper/cache.md#accessing-multiple-cache-stores)     |

#### Optimize methods

`Get`, `GetBool`, `GetInt`, `GetInt64`, `GetString`, `Pull` no longer need to pass a default value(Backwards compatible).

### Route supports Fallback route

Version: v1.10.1

You may define a route that will be executed when no other route matches the incoming request.

```go
facades.Route.Fallback(func(ctx http.Context) http.Response {
  return ctx.Response().String(404, "not found")
})
```

### Orm adds new methods

Version: v1.10.1

| Method        | Action           |
| -----------  | -------------- |
| db.Raw    | [Raw Expressions](../orm/getting-started.md#raw-expressions)     |
| LockForUpdate    | [Pessimistic Locking](../orm/getting-started.md#pessimistic-locking)     |
| SharedLock    | [Pessimistic Locking](../orm/getting-started.md#pessimistic-locking)     |

### Optimize facades.Config.Add()

Version: v1.11.0

The `configuration` parameter of `facades.Config.Add()` changes to `any` from `map[string]any`, make configuration more flexible.

[For Detail](../getting-started/configuration.md#set-configuration)

### Change Sqlite driver

Because `github.com/mattn/go-sqlite3` requires `CGO` to be started, so replacing a third-party package that does not require `CGO`: `github.com/glebarez/go-sqlite`.

### contracts/http add method mapping of net/http

Version: v1.11.0

You can use `http.MethodGet` in controller directly, instead of import `net/http`.

[For Detail](https://github.com/goravel/framework/blob/v1.11.0/contracts/http/method.go)

### Route Add Resource Routing

Version: v1.11.1

```go
facades.Route.Resource("/resource", resourceController)
```

[For Detail](../the-basics/routing.md#resource-routing)

### Request Add New Methods

Version: v1.11.1

| Method        | Action           |
| -----------  | -------------- |
| All          | [Retrieving all input data](../the-basics/request.md#retrieving-all-input-data)     |
| Host         | [Retrieving the request HOST](../the-basics/request.md#retrieving-the-request-host)     |
| Queries      | [Retrieving input from the query string](../the-basics/request.md#retrieving-input-from-the-query-string)     |

About to be deprecated the  `Form`, `Json` methods, please use `Input` instead.

### Storage Add New Methods

Version: v1.11.1

| Method       | Action           |
| -----------  | -------------- |
| LastModified | [Get the last modified time of file](../digging-deeper/filesystem.md#file-metadata)     |
| MimeType     | [Get the mime type of file](../digging-deeper/filesystem.md#file-metadata)     |

### File Add New Methods

Version: v1.11.1

| Method       | Action           |
| -----------  | -------------- |
| LastModified | [Get the last modified time of file](../digging-deeper/filesystem.md#file-metadata)     |
| MimeType     | [Get the mime type of file](../digging-deeper/filesystem.md#file-metadata)     |
| Size     | [Get the size of file](../digging-deeper/filesystem.md#file-metadata)     |

### Fix The Error Of Incorrect Windows Path For Filesystem

Version: v1.11.1

There is a wrong slash in windows system.

### Fix The Panic Of The Header Method For Request

Version: v1.11.1

`ctx.Request().Header( key: "token")` will panic.

### Fix The Data Error Of Using Request.Input() And Request.Bind() At The Same Time

Version: v1.11.2

`Request.Input()` will clear `Request.Body`, if you use `Request.Bind()` after that, you will not be able to get the data correctly.

### The problem of process interruption caused by panic in Schedule

Version: v1.11.3

The Schedule process will interruption when occurring panic, all tasks wil lbe affected.

### The problem that DailyAt in Schedule will be executed every minute

Version: v1.11.3

Fix the problem that `DailyAt` will be executed every minute:

```go
func (kernel *Kernel) Schedule() []schedule.Event {
  return []schedule.Event{
    facades.Schedule.Call(func() {
      fmt.Print("1")
    }).DailyAt("18:00"),
  }
}
```

<CommentService/>
