# Upgrading To v1.12 From v1.11

## v1.12.6

### Bug Fixes 🐛

- [Fix The Problem Of JWT](#fix-the-problem-of-jwt)

## v1.12.5

### Bug Fixes 🐛

- [Fix The Problem Of facades.Orm().Query().Load()](#fix-the-problem-of-facades-orm-query-load)

## v1.12.4

### Bug Fixes 🐛

- [The Problem Of The Throttle Middleware Throw Panic](#the-problem-of-the-throttle-middleware-throw-panic)

## v1.12.3

### Bug Fixes 🐛

- [The Problem Of make:package Command Under Windows](#the-problem-of-make-package-command-under-windows)

## v1.12.2

### Bug Fixes 🐛

- [The Problem Of facades.Gate() Return nil](#the-problem-of-facades-gate-return-nil)

## v1.12.1

### Bug Fixes 🐛

- [The Panic Problem Caused By File Path Under Windows](#the-panic-problem-caused-by-file-path-under-windows)

## v1.12.0

### Exciting New Features 🎉

- [Service Container(1.12.0)](#service-container)
- [Package Development(1.12.0)](#package-development)
- [Add Carbon Module](#add-helpers-methods)

## Enhancements 🚀

- [Artisan Flag Adds New Methods](#artisan-flag-adds-new-methods)
- [Add Helpers Methods](#add-helpers-methods)
- [Upgrade Dependencies](#upgrade-dependencies)
- [Migration Adds New Methods](#migration-adds-new-methods)
- [Some `make` Commands Support Subdirectories](#some-make-commands-support-subdirectories)

## Breaking Changes 🛠

- [Modify The Calling Type Of Facades(1.12.0)](#_3-modify-facades)
- [Optimize Artisan Flag(1.12.0)](#_6-modify-flag-in-the-artisan-command-if-using)
- [Filesystem Module Cancels Default Support For S3, OSS, COS, Minio](#_7-filesystem-module-cancels-default-support-for-s3-oss-cos-minio)
- [Cache Module Cancels Default Support For Redis](#_8-cache-module-cancels-default-support-for-redis)
- [Change The Type Of CreatedAt, UpdatedAt In Model](#_9-change-the-type-of-createdat-updatedat-in-model)
- [Optimize The Rule Of Validation Module](#_10-optimize-the-rule-of-validation-module)

## Upgrade Guide

Please upgrade the framework step by step according to the content in this section.

**Estimated Upgrade Time: 30 Minutes**

### 1. Updating Dependencies

Update dependencies in the `go.mod` file:

```
go get -u github.com/goravel/framework@v1.12.0 && go mod tidy
```

There is an error after running `go mod tidy`, the error will be solved after performing the following upgrade steps.

### 2. Modify `bootstrap/app.go`

```go
// Before
app := foundation.Application{}

// After
app := foundation.NewApplication()
```

### 3. Modify facades.*

| Before        | After           |
| -----------  | -------------- |
| `facades.Artisan`    | `facades.Artisan()`     |
| `facades.Auth`    | `facades.Auth()`     |
| `facades.Cache`    | `facades.Cache()`     |
| `facades.Config`    | `facades.Config()`     |
| `facades.Crypt`    | `facades.Crypt()`     |
| `facades.Event`    | `facades.Event()`     |
| `facades.Gate`    | `facades.Gate()`     |
| `facades.Grpc`    | `facades.Grpc()`     |
| `facades.Hash`    | `facades.Hash()`     |
| `facades.Log`    | `facades.Log()`     |
| `facades.Mail`    | `facades.Mail()`     |
| `facades.Orm`    | `facades.Orm()`     |
| `facades.Queue`    | `facades.Queue()`     |
| `facades.RateLimiter`    | `facades.RateLimiter()`     |
| `facades.Route`    | `facades.Route()`     |
| `facades.Schedule`    | `facades.Schedule()`     |
| `facades.Storage`    | `facades.Storage()`     |
| `facades.Validation`    | `facades.Validation()`     |

### 4. Modify `app/providers/*` 

Add import for all files:

```go
import (
  "github.com/goravel/framework/contracts/foundation"
)
```

All of `Register`, `Boot` methods Add `app foundation.Application` input parameter:

```go
func (receiver *AppServiceProvider) Register(app foundation.Application) {}

func (receiver *AppServiceProvider) Boot(app foundation.Application) {}
```

### 5. Modify `app/config/app.go` 

Modify import: 

```go
// Before
"github.com/goravel/framework/contracts"

"providers": []contracts.ServiceProvider{

// After
"github.com/goravel/framework/contracts/foundation"

"providers": []foundation.ServiceProvider{
```

### 6. Modify Flag in the Artisan command(If using)

The items in the `[]command.Flag` add `&command.StringFlag` type:

```go
// Before
func (receiver *VendorPublishCommand) Extend() command.Extend {
  return command.Extend{
    Category: "test",
    Flags: []command.Flag{
      {
        Name: "test",
      },
    },
  }
}

// After
func (receiver *VendorPublishCommand) Extend() command.Extend {
  return command.Extend{
    Category: "test",
    Flags: []command.Flag{
      &command.StringFlag{
        Name: "test",
      },
    },
  }
}
```

### 7. Filesystem Module Cancels Default Support For S3, OSS, COS, Minio

In order to reduce the loading of unnecessary third packages, reduce package volume, and improve compilation efficiency, Goravel will gradually strip each module driver into an independent expansion packages. In this upgrade, the `Filesystem` module cancels the default support for `S3`, `OSS`, `COS`, `Minio` drivers, and transfers support to independent extension packages.

Removes keys in `config/filesystems.go::disks` except `local` and drivers which are using:

```go
// Modified
"disks": map[string]any{
  "local": map[string]any{
    "driver": "local",
    "root":   "storage/app",
    "url":    config.Env("APP_URL", "").(string) + "/storage",
  },
},
```

If you are using other drivers expect `local`, please refer to the corresponding driver documentation for installation:

| Driver       | Link           |
| -----------  | -------------- |
| S3           | [https://github.com/goravel/s3](https://github.com/goravel/s3)     |
| OSS          | [https://github.com/goravel/oss](https://github.com/goravel/oss)     |
| COS          | [https://github.com/goravel/cos](https://github.com/goravel/cos)     |
| Minio        | [https://github.com/goravel/minio](https://github.com/goravel/minio)     |

### 8. Cache Module Cancels Default Support For Redis

Remove the `redis` key in `config/cache.go::stores` if you are not using it:

```go
// Modified
"stores": map[string]any{
  "memory": map[string]any{
    "driver": "memory",
  },
},
```

If you are using the `redis` driver, please refer to the `redis` driver documentation for installation:

| Driver       | Link           |
| -----------  | -------------- |
| Redis        | [https://github.com/goravel/redis](https://github.com/goravel/redis)     |

### 9. Change The Type Of CreatedAt, UpdatedAt In Model(If using)

In order to make the time type more standard in API output, the type of `CreatedAt`, `UpdatedAt` in `Model` change to `carbon.DateTime` from `time.Time`. If you have additional processing for these two fields, you can get the original `time.Time` type through the `CreatedAt.ToStdTime()` method.

### 10. Optimize The Rule Of Validation Module(If using)

Check the zero value in the original validate rule, for example, if the rule is set to `date` and `required` is not set, and the field is empty or not passed, the validation module will prompt that field is required. After optimization, the validation module will passed the check, which is more intuitive to use. If you are using relevant validation, please ensure that the upgrade is as expected.

### 11. Install dependencies again

Run `go mod tidy`

## Function Introduction

### Service Container

Version: v1.12.0

All services in Goravel are registered in the service container, providing strong support for the package development, [For Detail](../architecutre-concepts/service-container.md)

### Package Development

Version: v1.12.0

Packages are the primary way of adding functionality to Goravel, can enrich the ecology of Goravel, [For Detail](../digging-deeper/package-development.md)

### Artisan Flag Adds New Methods

Version: v1.12.0

Add methods for Artisan module to get different types of `Flag`, [For Detail](../digging-deeper/artisan-console.md#options)

### Add Helpers Methods

Version: v1.12.0

Add `path` and `carbon` Helpers methods, you can easily get the path information and deal with time in project, [For Detail](../digging-deeper/helpers.md)。

### Upgrade Dependencies

Version: v1.12.0

To provide better feature support, the versions of all packages that Goravel depends on have been upgraded.

### Migration Adds New Methods

Version: v1.12.0

| Commands        | Action           |
| -----------     | -------------- |
| migrate:fresh   | Drop all tables and re-run all migrations     |
| migrate:refresh | Reset and re-run all migrations     |
| migrate:reset   | Rollback all database migrations     |
| migrate:status  | Show the status of each migration    |

### Some `make` Commands Support Subdirectories

Version: v1.12.0

| 命令                                 | 生成文件                              |
| ----------------------              | ------------------------------------ |
| make:policy User/AuthPolicy         | app/policies/User/auth_policy.go     |
| make:command Goravel/CleanCache     | app/console/commands/Goravel/clean_cache.go     |
| make:model User/Phone               | app/models/User/phone.go     |
| make:observer User/PhoneObserver    | app/observers/User/phone_observer.go     |
| make:event User/GoravelEvent        | app/events/User/goravel_event.go     |
| make:listener User/GoravelListen    | app/listeners/User/goravel_listen.go     |
| make:controller User/AuthController | app/http/controllers/User/auth_controller.go     |
| make:middleware User/Auth           | app/http/middleware/User/auth.go     |
| make:request User/Auth              | app/http/requests/User/auth.go     |
| make:job Goravel/Job                | app/jobs/Goravel/job.go    |
| make:rule User/Phone                | app/rules/User/phone.go     |

### The Panic Problem Caused By File Path Under Windows

Version: v1.12.1

Fix the panic problem caused by backslash when the `make` command automatically creates folders under Windows.

### The Problem Of facades.Gate() Return nil

Version: v1.12.2

Fix the problem of `facades.Gate()` return nil.

### The Problem Of make:package Command Under Windows

Version: v1.12.3

The file created by the `make:package` command has a wrong path under Windows.

### The Problem Of The Throttle Middleware Throw Panic

Version: v1.12.4

Fix the problem of the throttle middleware throw panic.

### Fix The Problem Of facades.Orm().Query().Load()

Version: v1.12.5

Fix the problem that `facades.Orm().Query().Load()` cannot load the model correctly in some cases.

### Fix The Problem Of JWT

Version: v1.12.6

Fix the problem that when the JWT Token is expired and invalid, the expiration error is returned, and the invalid error is expected to be returned first.
