# Upgrading To v1.13 From v1.12

### Exciting New Features 🎉

- [Seeding](#seeding)
- [Factories](#factories)
- [Testing](#testing)
- [Views](#views)

## Enhancements 🚀

- [Upgrade The Default Version Of Golang To 1.20](#upgrade-the-default-version-of-golang-to-1-20)
- [Task Scheduling Supports Scale Horizontally](#task-scheduling-supports-scale-horizontally)
- [Add Debug Methods](#add-debug-methods)
- [make:controller Command Adds Parameter](#make-controller-command-adds-parameter)
- [Add Status Method For Response](#add-status-method-for-response)
- [Add Sum and Cursor Methods For Orm](#add-sum-and-cursor-methods-for-orm)
- [The Route Module Supports Configure Driver](#the-route-module-supports-configure-driver)
- [Add InputArray And InputMap Methods For Request](#add-inputarray-and-inputmap-methods-for-request)
- [The Model Of Orm Supports Custom Connection](#the-model-of-orm-supports-custom-connection)
- [Add Cloudinary Driver For Filesystem](#add-cloudinary-driver-for-filesystem)
- [Add New Chain Methods For Log](#add-new-chain-methods-for-log)

### v1.13.4

- [The Service Startup Supports Environment Variables](#the-service-startup-supports-environment-variables)

## Breaking Changes 🛠

- [Remove The Global HTTP Middleware Loaded By Default](#_5-remove-the-global-http-middleware-loaded-by-default)
- [Optimize The Return of Controller](#_6-optimize-the-return-of-controller)
- [Change The Parameter Of The Group Method In facades.Route()](#_7-change-the-parameter-of-the-group-method-in-facades-route)
- [Optimize Remember And RememberForever Methods In facades.Cache()(If using)](#_8-optimize-remember-and-rememberforever-methods-in-facades-cache-if-using)
- [Change The Package Name Of access.NewAllowResponse and access.NewDenyResponse(If using)](#_9-change-the-package-name-of-access-newallowresponse-and-access-newdenyresponse-if-using)
- [Remove Deprecated Methods(If using)](#_10-remove-deprecated-methods-if-using)

### Bug Fixes 🐛

- [Fix facades.Auth().User()](#fix-facades-auth-user)
- [Fix Custom .env Path Does Not Take Effect In Some Cases](#fix-custom-env-path-does-not-take-effect-in-some-cases)
- [Fix Token Expires Immediately When ttl == 0 Is Set In JWT](#fix-token-expires-immediately-when-ttl-0-is-set-in-jwt)

#### v1.13.2

- [Fix facades.Storage().Url() Returns Wrong Path Under Windows](#fix-facades-storage-url-returns-wrong-path-under-windows)
- [Fix Abnormal Connection When The Postgres Password Is Empty](#fix-abnormal-connection-when-the-postgres-password-is-empty)
- [Fix The With Method Is Invalid When Using The Cursor Method Of Orm](#fix-the-with-method-is-invalid-when-using-the-cursor-method-of-orm)

#### v1.13.4

- [Fix The Validation Module Cant Verify The Route Params](#fix-the-validation-module-cant-verify-the-route-params)
- [Fix The Fiber Driver Cant Return File](#fix-the-fiber-driver-cant-return-file)
- [Fix The Global Middleware Of Fiber Driver Panic](#fix-the-global-middleware-of-fiber-driver-panic)
- [Fix The ContentType Setting of Fiber Driver Is Different From Gin Driver](#fix-the-contenttype-setting-of-fiber-driver-is-different-from-gin-driver)

#### v1.13.5

- [Fix The Connection Of Model Does Not Work](#fix-the-connection-of-model-does-not-work)
- [Fix The Error Of Mock Log](#fix-the-error-of-mock-log)

#### v1.13.6 v1.13.7

- [Fix The Problem Of Nonlinear Execution Of Query Chain](#fix-the-problem-of-nonlinear-execution-of-query-chain)

#### v1.13.8

- [Fix The Problem Of facades.Auth().Parse()](#fix-the-problem-of-facades-auth-parse)
- [Fix The Problem of facades.Orm().WithContext()](#fix-the-problem-of-facades-orm-withcontext)
- [The Queue Log Is Controlled By APP_DEBUG](#the-queue-log-is-controlled-by-app-debug)

#### v1.13.9

- [Fix The Problem Of The New Line Print Of Log Is Incorrect](#fix-the-problem-of-the-new-line-print-of-log-is-incorrect)
- [Fix The Problem Of The vendor:publish Commabnd Can Not Publish Directory](#fix-the-problem-of-the-vendor-publish-commabnd-can-not-publish-directory)

### v1.13.10

- [Fix The Traces Do Not Cleaned When Calling Log.Info After Log.Error](#fix-the-traces-do-not-cleaned-when-calling-log-info-after-log-error)
- [Fix The GetAttribute Of Orm Event Returns Error Data](#fix-the-getattribute-of-orm-event-returns-error-data)
- [Add ToSql, ToRawSql Methods For ORM](#add-tosql-torawsql-methods-for-orm)

## Upgrade Guide

Please upgrade the framework step by step according to the content in this section.

**Estimated Upgrade Time: 10 Minutes**

### 1. Updating Dependencies

Update dependencies in the `go.mod` file:

```
go get -u github.com/goravel/framework@v1.13.9 && go get -u github.com/goravel/gin
```

### 2. Add New Files

[tests](https://github.com/goravel/goravel/tree/v1.13.x/tests)

[database/seeders/database_seeder.go](https://github.com/goravel/goravel/tree/v1.13.x/database/seeders/database_seeder.go)

[app/providers/database_service_provider.go](https://github.com/goravel/goravel/tree/v1.13.x/app/providers/database_service_provider.go)

### 3. Register New Providers

Note the order:

```go
import (
  "github.com/goravel/framework/testing"
  "github.com/goravel/gin"
)

// config/app.go
"providers": []foundation.ServiceProvider{
  ...
  &validation.ServiceProvider{},
  // New
  &testing.ServiceProvider{}, 
  &providers.AppServiceProvider{},
  ...
  &providers.ValidationServiceProvider{},
  // New
  &providers.DatabaseServiceProvider{}, 
  // New
  &gin.ServiceProvider{}, 
}
```

### 4. Add Configuration

Modify [config/http.go](https://github.com/goravel/goravel/tree/v1.13.x/config/http.go)

```go
import (
  "github.com/goravel/framework/contracts/route"
  "github.com/goravel/framework/facades"
  ginfacades "github.com/goravel/gin/facades"
)

config.Add("http", map[string]any{
  // HTTP Driver
  "default": "gin",
  // HTTP Drivers
  "drivers": map[string]any{
    "gin": map[string]any{
      "route": func() (route.Route, error) {
        return ginfacades.Route("gin"), nil
      },
    },
  },
  ...
}
```

Modify [config/cors.go](https://github.com/goravel/goravel/tree/v1.13.x/config/cors.go)

```go
config.Add("cors", map[string]any{
  ...
  // New
  "paths":                []string{"*"}, 
  "allowed_methods":      []string{"*"},
  ...
}
```

### 5. Remove The Global HTTP Middleware Loaded By Default

1. The `tls` and `cors` middleware have been integrated into the default HTTP driver, therefore, `middleware.Cors()` and `middleware.Tls()` in the `app/http/kernel.go` file need to be removed.

2. The `facades.Route().GlobalMiddleware(http.Kernel{}.Middleware()...)` method in the `app/providers/route_service_provider.go` file moves to `Boot` from `Register`:

```go
package providers

...

type RouteServiceProvider struct {
}

func (receiver *RouteServiceProvider) Register(app foundation.Application) {
}

func (receiver *RouteServiceProvider) Boot(app foundation.Application) {
  //Add HTTP middleware
  facades.Route().GlobalMiddleware(http.Kernel{}.Middleware()...)

  receiver.configureRateLimiting()

  routes.Web()
}

func (receiver *RouteServiceProvider) configureRateLimiting() {

}
```

### 6. Optimize The Return of Controller

`Controller` adds return value `http.Response`, `ctx.Response()` can be return directly, there is no need to use `return` separately to make the logic smoother.

```go
// Before
func (r *UserController) Show(ctx http.Context) {
  ctx.Response().Success().Json(http.Json{
    "Hello": "Goravel",
  })
  return
}

// After
func (r *UserController) Show(ctx http.Context) http.Response {
  return ctx.Response().Success().Json(http.Json{
    "Hello": "Goravel",
  })
}
```

### 7. Change The Parameter Of The Group Method In facades.Route()

Change `route.Route` to `route.Router`：

```go
// Before
facades.Route().Group(func(route route.Route)

// After
facades.Route().Group(func(route route.Router)
```

### 8. Optimize Remember And RememberForever Methods In facades.Cache()(If using)

The type of `callback` changes to `func() (any, error)` from `func() any`:

```go
// Before
Remember(key string, ttl time.Duration, callback func() any) (any, error)
RememberForever(key string, callback func() any) (any, error)

// After
Remember(key string, ttl time.Duration, callback func() (any, error)) (any, error)
RememberForever(key string, callback func() (any, error)) (any, error)
```

### 9. Change The Package Name Of access.NewAllowResponse and access.NewDenyResponse(If using)

Change `/contracts/auth/access` to `/auth/access`:

```go
// Before
import "github.com/goravel/framework/contracts/auth/access"

access.NewAllowResponse()
access.NewDenyResponse()

// After
import "github.com/goravel/framework/auth/access"

access.NewAllowResponse()
access.NewDenyResponse()
```

### 10. Remove Deprecated Methods(If using)

1. Remove `ctx.Request().Form()` and `ctx.Request().Json()` methods, use the `ctx.Request().Input()` method instead;

2. Remove `GetLevel`, `GetTime`, `GetMessage` methods of `Log` custom driver, use `Level`, `Time`, `Message` methods instead;

3. Remove the `gorm.New` method, the method is used to obtain the `gorm` instance directly, it is no longer recommended. if necessary, use the `gorm.NewGormImpl` method instead;

## Function Introduction

### Seeding

Version: v1.13.1

[For Detail](../orm/seeding.md)

### Factories

Version: v1.13.1

[For Detail](../orm/factories.md)

### Testing

Version: v1.13.1

[For Detail](../testing/getting-started.md)

### Views

Version: v1.13.1

[For Detail](../the-basics/views.md)

### Upgrade The Default Version Of Golang To 1.20

Version: v1.13.1

Golang 1.18 and 1.19 have been discontinued and the framework has been upgraded to 1.20 accordingly, [for detail](https://endoflife.date/go). If you want to continue using 1.18 or 1.19, just modify the version number in `go.mod`, they are fully compatible at present.

### Task Scheduling Supports Scale Horizontally

Version: v1.13.1

[For Detail](../digging-deeper/task-scheduling.md#running-tasks-on-one-server)

### Add debug Methods

Version: v1.13.1

[For Detail](../digging-deeper/helpers.md#debug)

### make:controller Command Adds Parameter

Version: v1.13.1

The `make:controller` command adds `--resource` parameter, the CURD struct can be created easily:

```
go run . artisan make:controller --resource UserController
```

### Add Status method for Response

Version: v1.13.1

[For Detail](../the-basics/response.md#custom-code)

### Add Sum and Cursor methods for Orm

Version: v1.13.1

[For Detail](../orm/getting-started.md#facades-orm-query-facades-orm-transaction-available-functions)

### The Route Module Supports Configure Driver

Version: v1.13.1

Separate the original default driver Gin of the Route module into a package, it can be injected into Goravel by configuration. after this optimization, providers a convenient channel for injecting other HTTP packages into Goravel, currently two HTTP packages are officially supported:

| Driver          | Link           |
| -----------     | -------------- |
| Gin             | [https://github.com/goravel/gin](https://github.com/goravel/gin)     |
| Fiber           | [https://github.com/goravel/fiber](https://github.com/goravel/fiber)     |

### Add InputArray And InputMap Methods For Request

Version: v1.13.1

[For Detail](../the-basics/request.md#retrieving-an-input-value)

### The Model Of Orm Supports Custom Connection

Version: v1.13.1

[For Detail](../orm/getting-started.md#database-connections)

### Add Cloudinary Driver For Filesystem

Version: v1.13.1

[For Detail](https://github.com/goravel/cloudinary)

### Add New Chain Methods For Log

Version: v1.13.1

[For Detail](../the-basics/logging.md#chain-methods)

### Fix facades.Auth().User()

Version: v1.13.1

1. Fix the problem that no error throws if the user didn't exist when using the `facades.Auth().User(ctx, &user)` method.

2. Fix the problem that `user` can be found when the primary key isn't `int`;

### Fix Custom .env Path Does Not Take Effect In Some Cases

Version: v1.13.1

Fix the problem that custom .env path does not take effect in some cases.

### Fix Token Expires Immediately When ttl == 0 Is Set In JWT

Version: v1.13.1

Expect the token to never expire when `ttl == 0`.

### Fix facades.Storage().Url() Returns Wrong Path Under Windows

Version: v1.13.2

[Issue #263](https://github.com/goravel/goravel/issues/263)

### Fix Abnormal Connection When The Postgres Password Is Empty

Version: v1.13.2

[Issue #270](https://github.com/goravel/goravel/issues/270)

### Fix The With Method Is Invalid When Using The Cursor Method Of Orm

Version: v1.13.2

[Issue #253](https://github.com/goravel/goravel/issues/253)

### The Service Startup Supports Environment Variables

Version: v1.13.4

[Issue #265](https://github.com/goravel/goravel/issues/265)

### Fix The Validation Module Cant Verify The Route Params

goravel/gin: v1.1.6

goravel/fiber: v1.1.11

[Issue #294](https://github.com/goravel/goravel/issues/294)

### Fix The Fiber Driver Cant Return File

goravel/fiber: v1.1.11

[Issue #299](https://github.com/goravel/goravel/issues/299)

### Fix The Global Middleware Of Fiber Driver Panic

goravel/fiber: v1.1.11

[Issue #300](https://github.com/goravel/goravel/issues/300)

### Fix The ContentType Setting Of Fiber Driver Is Different From Gin Driver

goravel/fiber: v1.1.11

[Issue #296](https://github.com/goravel/goravel/issues/296)

### Fix The Connection Of Model Does Not Work

goravel/framework: v1.13.5

[Issue #312](https://github.com/goravel/goravel/issues/312)

### Fix The Error Of Mock Log

goravel/framework: v1.13.5

[Issue #320](https://github.com/goravel/goravel/issues/320)

### Fix The Problem Of Nonlinear Execution Of Query Chain

goravel/framework: v1.13.6 v1.13.7

[Issue #341](https://github.com/goravel/goravel/issues/341)

### Fix The Problem Of facades.Auth().Parse()

goravel/framework: v1.13.8

[Issue #388](https://github.com/goravel/goravel/issues/388)

### Fix The Problem of facades.Orm().WithContext()

goravel/framework: v1.13.8

[Issue #390](https://github.com/goravel/goravel/issues/390)

### The Queue Log Is Controlled By APP_DEBUG

goravel/framework: v1.13.8

The `Debug` and `Info` levels will not be print when `APP_DEBUG=false`

[Issue #389](https://github.com/goravel/goravel/issues/389)

### Fix The Problem Of The New Line Print Of Log Is Incorrect

goravel/framework: v1.13.9

[Issue #395](https://github.com/goravel/goravel/issues/395)

### Fix The Problem Of The vendor:publish Commabnd Can Not Publish Directory

goravel/framework: v1.13.9

[Issue #345](https://github.com/goravel/goravel/issues/345)

### Fix The Traces Do Not Cleaned When Calling Log.Info After Log.Error

goravel/framework: v1.13.10

[Issue #402](https://github.com/goravel/goravel/issues/402)

### Fix The GetAttribute Of Orm Event Returns Error Data

goravel/framework: v1.13.10

[Issue #405](https://github.com/goravel/goravel/issues/405)

### Add ToSql, ToRawSql Methods For ORM

goravel/framework: v1.13.10

[Issue #411](https://github.com/goravel/goravel/issues/411)
