# Upgrading To v1.14 From v1.13

### Exciting New Features 🎉

- [Localization](#localization)
- [Installer](#installer)
- [Cookie](#cookie)
- [Session](#session)

### Enhancements 🚀

- [Support for setting body_limit and header_limit in Gin and Fiber drivers](#support-for-setting-body-limit-and-header-limit-in-gin-and-fiber-drivers)
- [Log adds new methods](#log-adds-new-methods)
- [Orm adds new methods](#orm-adds-new-methods)
- [Console adds new methods](#console-adds-new-methods)
- [Response adds new methods](#response-adds-new-methods)
- [Add Build command](#add-build-command)
- [Add helper methods](#add-helper-methods)
- [Redis driver supports TLS](#redis-driver-supports-tls)

### Breaking Changes 🛠

- [Validation will not bind data if validation fails](#validation-will-not-bind-data-if-validation-fails)
- [Add new methods and modify methods for Testing module](#add-new-methods-and-modify-methods-for-testing-module)
- [Optimize the Queue method of Mail](#optimize-the-queue-method-of-mail)
- [Optimize the setting method of the Auth module ctx](#optimize-the-setting-method-of-the-auth-module-ctx)
- [Optimize the way of mock facades](#optimize-the-way-of-mock-facades)
- [Framework Orm model adds json tag](#framework-orm-model-adds-json-tag)

### Bug Fixes 🐛

## Upgrade Guide

Goravel v1.14 is developed and tested based on Golang 1.21, and generally compatible with other lower Golang versions. Please upgrade the framework step by step according to the content in this section.

**Estimated Upgrade Time: 10 Minutes**

### 1. Updating Dependencies

```
go get -u github.com/goravel/framework@v1.14.0

// If using gin
go get -u github.com/goravel/gin@v1.2.1

// If using fiber
go get -u github.com/goravel/fiber@v1.2.0

// If using redis
go get -u github.com/goravel/redis@v1.2.0

// If using s3
go get -u github.com/goravel/s3@v1.2.0

// If using oss
go get -u github.com/goravel/oss@v1.2.0

// If using cos
go get -u github.com/goravel/cos@v1.2.0

// If using minio
go get -u github.com/goravel/minio@v1.2.0

// If using cloudinay
go get -u github.com/goravel/cloudinary@v1.2.0

go mod tidy
```

### 2. Adding Configuration Items

1. `config/app.go` adds localization module configuration items:

```go
"locale": "en",
"fallback_locale": "en",
"providers": []foundation.ServiceProvider{
  ...
  &session.ServiceProvider{},
  &translation.ServiceProvider{},
  ...
}
```

2. If you want to use the `session` feature, add the [config/session.go](https://github.com/goravel/goravel/blob/master/config/session.go) file;

### 3. If using the Validation module

Confirm whether you are still trying to read the binding value even if the data validation fails. If so, you need to optimize the logic, because the value is empty after the upgrade. See: [Validation will not bind data if validation fails](#validation-will-not-bind-data-if-validation-fails).

### 4. If using the Testing module

Check whether using the `Clear`, `Image` methods, if so, need to modify accordingly: [Add new methods and modify methods for Testing module](#add-new-methods-and-modify-methods-for-testing-module)

### 5. if using the Mail module

Check whether using the `Queue` method, if so, need to modify accordingly: [Optimize the Queue method of Mail](#optimize-the-queue-method-of-mail)

### 6. If using the Auth module

Need to modify accordingly: [Optimize the setting method of the Auth module ctx](#optimize-the-setting-method-of-the-auth-module-ctx)

### 7. If using the mock facades

Need to modify accordingly: [Optimize the way of mock facades](#optimize-the-way-of-mock-facades)

### 8. If using the framework Orm model and returning data directly through the endpoint

Need to modify accordingly: [Framework Orm model adds json tag](#framework-orm-model-adds-json-tag)

## Feature Introduction

### Localization

Version: v1.14.0

[View Documentation](../digging-deeper/localization.md)

### Installer

Version: v1.14.0

The installer allows you to easily download and initialize a new Goravel project.

[View Documentation](http://github.com/goravel/installer)

### Cookie

Version: v1.14.0

[View Request Documentation](../the-basics/request.md#cookie)

[View Response Documentation](../the-basics/response.md#cookie)

### Session

Version: v1.14.0

[View Documentation](../the-basics/session.md)

### Support for setting body_limit and header_limit in Gin and Fiber drivers

Version: v1.14.0

HTTP drivers support setting body_limit to limit the body size, see: [goravel/gin](https://github.com/goravel/gin/blob/c9d7706a6a04c05c8c33af5c97877a1ad2ea6362/README.md?plain=1#L54) and [goravel/fiber](https://github.com/goravel/fiber/blob/aa63ab657cd2b371fcda4df0090a41226f6c0704/README.md?plain=1#L56).

### Log adds new methods

Version: v1.14.0

| Method | Descrpton |
| --- | --- |
| `Stack` | Use multiple channels at the same time |
| `Channel` | Specified a channel |
| `WithTrace` | Print trace |

[View Documentation](../the-basics/logging.md#write-to-a-specific-channel)

### Orm adds new methods

Version: v1.14.0

Add `WhereIn`, `OrWhereIn`, `OrWhereNotIn`, `WhereNotIn`, `WhereBetween`, `WhereNotBetween`, `WhereNull`, `OrWhereNull`, `OrderByDesc`, `OrderBy`, `InRandomOrder`, `Exists` methods.

### Console adds new methods

Version: v1.14.0

[View Documentation](../digging-deeper/artisan-console.md#prompting-for-input)

### Response adds new methods

Version: v1.14.0

[View documentation](../the-basics/response.md#no-content)

### Add Build command

Version: v1.14.0

The Goravel project can be compiled with the following command: `go run . artisan build`.

[View Documentation](../getting-started/compile.md#compile-command)

### Add helper methods

Version: v1.14.0

- [Str](../digging-deeper/strings.md)
- [Map](../digging-deeper/helpers.md#maps)
- [Color](../digging-deeper/color.md)
- [Convert](../digging-deeper/helpers.md#convert)
- [Collect](../digging-deeper/helpers.md#collect)

### Redis driver supports TLS

Version: v1.14.0

[View Documentation](https://github.com/goravel/redis)

### Validation will not bind data if validation fails

Version: v1.14.0

Previously, when calling the methods below, the `userRequest` still bound the value, even if an error was returned. After the upgrade, it will no longer bind.

```go
var userRequest requests.UserRequest
errors, err := ctx.Request().ValidateRequest(&userRequest)

// or
validator, err := validation.Make(***)
err = validator.Bind(&userRequest)
```

### Add new methods and modify methods for Testing module

Version: v1.14.0

1. Add [Fresh](../testing/getting-started.md#refresh-database) method;
2. Modify `Clear` method to [Stop](../testing/getting-started.md#uninstall-image) method;
3. The `Image` method adds `ExposedPorts` variable and remove `Timeout` variable;

```go
database, err := facades.Testing().Docker().Database()
database.Image(testingcontract.Image{
  Repository: "mysql",
  Tag:        "5.7",
  Env: []string{
    "MYSQL_ROOT_PASSWORD=123123",
    "MYSQL_DATABASE=goravel",
  },
  -- Timeout: 1000,
  ++ ExposedPorts: []string{"3306"},
})
```

### Optimize the Queue method of Mail

Version: v1.14.0

The input parameter of the `Queue` method changes from `queue *mail.Queue` to `queue ...mail.Queue`.

```diff
-- facades.Mail().Queue(nil)
++ facades.Mail().Queue()

-- facades.Mail().Queue(&mail.Queue{})
++ facades.Mail().Queue(mail.Queue{})
```

### Optimize the setting method of the Auth module ctx

Version: v1.14.0

Previously, when calling the `Parse`, `User`, `Login`, `LoginUsingID`, `Refresh`, `Logout` methods, you need to pass `ctx`. After the upgrade, you no longer need to pass `ctx`, you can directly set it in `facades.Auth(ctx)`.

```diff
-- facades.Auth().Parse(ctx, token)
++ facades.Auth(ctx).Parse(token)

-- facades.Auth().User(ctx, &user)
++ facades.Auth(ctx).User(&user)

-- facades.Auth().Login(ctx, &user)
++ facades.Auth(ctx).Login(&user)

-- facades.Auth().LoginUsingID(ctx, id)
++ facades.Auth(ctx).LoginUsingID(id)

-- facades.Auth().Refresh(ctx)
++ facades.Auth(ctx).Refresh()

-- facades.Auth().Logout(ctx)
++ facades.Auth(ctx).Logout()
```

### Optimize the way of mock facades

Version: v1.14.0

```diff
import github.com/goravel/framework/testing/mock

++ mockFactory := mock.Factory()

-- app := mock.App()
++ app := mockFactory.App()

-- artisan := mock.Artisan()
++ artisan := mockFactory.Artisan()

-- auth := mock.Auth()
++ auth := mockFactory.Auth()

-- artisan := mock.Artisan()
++ artisan := mockFactory.Artisan()

-- cache, driver, lock := mock.Cache()
++ cache := mockFactory.Cache()
++ driver := mockFactory.CacheDriver()
++ lock := mockFactory.CacheLock()

-- config := mock.Config()
++ config := mockFactory.Config()

-- crypt := mock.Crypt()
++ crypt := mockFactory.Crypt()

-- event, task := mock.Event()
++ event := mockFactory.Event()
++ event := mockFactory.EventTask()

-- gate := mock.Gate()
++ gate := mockFactory.Gate()

-- grpc := mock.Grpc()
++ grpc := mockFactory.Grpc()

-- hash := mock.Hash()
++ hash := mockFactory.Hash()

-- mock.Log()
++ mockFactory.Log()

-- mail := mock.Mail()
++ mail := mockFactory.Mail()

-- orm, query, transaction, association := mock.Orm()
++ orm := mockFactory.Orm()
++ query := mockFactory.OrmQuery()
++ transaction := mockFactory.OrmTransaction()
++ association := mockFactory.OrmAssociation()

-- queue, task := mock.Queue()
++ queue := mockFactory.Queue()
++ task := mockFactory.QueueTask()

-- rateLimiter := mock.RateLimiter()
++ rateLimiter := mockFactory.RateLimiter()

-- storage, driver, file := mock.Storage()
++ storage := mockFactory.Storage()
++ driver := mockFactory.StorageDriver()
++ file := mockFactory.StorageFile()

-- seeder := mock.Seeder()
++ seeder := mockFactory.Seeder()

-- validation, validator, errors := mock.Validation()
++ validation := mockFactory.Validation()
++ validator := mockFactory.ValidationValidator()
++ errors := mockFactory.ValidationErrors()

-- view := mock.View()
++ view := mockFactory.View()
```

### Framework Orm model adds json tag

Version: v1.14.0

If you are using the framework's Orm model and returning data directly through the endpoint, you need to create a new model according to the old and replace the old, or frontend needs to modify the field name according to the json tag.

```go
type Model struct {
	-- ID uint `gorm:"primaryKey"`
	++ ID uint `gorm:"primaryKey" json:"id"`
	Timestamps
}

type SoftDeletes struct {
	-- DeletedAt gorm.DeletedAt `gorm:"column:deleted_at"`
	++ DeletedAt gorm.DeletedAt `gorm:"column:deleted_at" json:"deleted_at"`
}

type Timestamps struct {
	-- CreatedAt carbon.DateTime `gorm:"autoCreateTime;column:created_at"`
	-- UpdatedAt carbon.DateTime `gorm:"autoUpdateTime;column:updated_at"`
	++ CreatedAt carbon.DateTime `gorm:"autoCreateTime;column:created_at" json:"created_at"`
	++ UpdatedAt carbon.DateTime `gorm:"autoUpdateTime;column:updated_at" json:"updated_at"`
}
```
