# Upgrading To v1.2 From v1.1

## High Impact Changes

- [Updating Dependencies](#updating-dependencies)
- [Auth support context](#auth-support-context)

## Upgrade Guide

**Estimated Upgrade Time: 1 Minutes**

### Updating Dependencies

**Likelihood Of Impact: High**

Update dependencies in the `go.mod` file：

```go
github.com/goravel/framework v1.2.1
```

### Auth Support Context

**Likelihood Of Impact: High**

```
// Old
facades.Auth.Parse(token string) error

// New
facades.Auth.Parse(ctx http.Context, token string) error
```

```
// Old
facades.Auth.User(ctx http.Context, user interface{}) error

// New
facades.Auth.User(ctx http.Context, user interface{}) error
```

```
// Old
facades.Auth.facades.Auth.Login(user interface{}) (token string, err error)

// New
facades.Auth.facades.Auth.Login(ctx http.Context, user interface{}) (token string, err error)
```

```
// Old
facades.Auth.LoginUsingID(id interface{}) (token string, err error)

// New
facades.Auth.LoginUsingID(ctx http.Context, id interface{}) (token string, err error)
```

```
// Old
facades.Auth.Refresh() (token string, err error)

// New
facades.Auth.Refresh(ctx http.Context) (token string, err error)
```

```
// Old
facades.Auth.Logout() error

// New
facades.Auth.Logout(ctx http.Context) error
```

For detail [facades.Auth](../security/authentication.md)。

<CommentService/>