# Upgrading To v1.4 From v1.3

[[toc]]

## High Impact Changes

- [Optimize Grpc Module](#optimize-grpc-module)
- [Optimize Route Register](#optimize-route-register)

## Low Impact Changes

- [Add http.Context Method](#add-http-context-method)
- [Add Request Method](#add-request-method)

## Upgrade Guide

**Estimated Upgrade Time: 1 Minutes**

### Updating Dependencies

**Likelihood Of Impact: High**

Update dependencies in the `go.mod` file:

```go
github.com/goravel/framework v1.4.0
```

### Optimize Grpc Module

**Likelihood Of Impact: High**

1. Add [app/grpc/kernel.go](https://github.com/goravel/goravel/blob/v1.4.0/app/grpc/kernel.go) file;
2. Add [app/grpc/interceptors](https://github.com/goravel/goravel/tree/v1.4.0/app/grpc/interceptors) folder;
3. Add [config/grpc.go](https://github.com/goravel/goravel/blob/v1.4.0/config/grpc.go) file;
4. Add [routes/grpc.go](https://github.com/goravel/goravel/blob/v1.4.0/routes/grpc.go) file;
3. Add register interceptor logic in [app/providers/grpc_service_provider.go](https://github.com/goravel/goravel/blob/v1.4.0/app/providers/grpc_service_provider.go);
4. Remove `grpc_host` in [config/app.go](https://github.com/goravel/goravel/blob/v1.4.0/config/app.go);

[For Detail](../the-basics/grpc.md)

### Optimize Route Register

**Likelihood Of Impact: High**

Move `routes.Web()` to `Boot()` from `Register()` in [app/providers/route_service_provider.go](https://github.com/goravel/goravel/blob/v1.4.0/app/providers/route_service_provider.go);

### Add http.Context Method

**Likelihood Of Impact: Low**

Add `ctx.Context()` Method.

[For Detail](../the-basics/request.md#get-context)

### Add Request Method

**Likelihood Of Impact: Low**

Add `ctx.Request().AbortWithStatusJson` method.

[For Detail](../the-basics/request.md#abort-request)

<CommentService/>