# Upgrading To v1.7 From v1.6

[[toc]]

## High Impact Changes

- [Add Validation Module(v1.7.0)](#add-validation-module)
- [Fix request template BUG(v1.7.1)](#fix-request-template-bug)
- [Fix Validation module BUG(v1.7.2)](#fix-Validation-module-big)
- [Fix Auth module BUG(v1.7.3)](#fix-auth-module-bug)

## Low Impact Changes

- [Optimize the queue name of the queue module(v1.7.2)](#optimize-the-queue-name-of-the-queue-module)

## Upgrade Guide

**Estimated Upgrade Time: 1 Minutes**

### Updating Dependencies

**Likelihood Of Impact: High**

Update dependencies in the `go.mod` file:

```go
github.com/goravel/framework v1.7.3
```

### Add Validation module

**Likelihood Of Impact: High**

Version: v1.7.0

1. Add [app/providers/validation_service_provider.go](https://github.com/goravel/goravel/blob/v1.7.0/app/providers/validation_service_provider.go) file;
3. Add `&validation.ServiceProvider{}`, `&providers.ValidationServiceProvider{},` to the `providers` item in the [config/app.go](https://github.com/goravel/goravel/blob/v1.7.0/config/app.go) file;

[For Detail](../the-basics/validation.md)

### Fix request template BUG

**Likelihood Of Impact: High**

Version: v1.7.1

1. Fix import path BUG of the request template that created by `go run . artisan make:request Test`;

### Fix Validation module BUG

**Likelihood Of Impact: High**

Version: v1.7.2

1. Fix the BUG that does not take effect when the `facades.Validation` module registers multiple custom Rule;

### Optimize the queue name of the queue module

**Likelihood Of Impact: Low**

Version: v1.7.2

1. Add a prefix to the queue name of the `facades.Queue` module during actual execution, in order to distinguish between multiple projects, the prefix rule: ${app_name}_queues:${queue};
2. Implicit optimization, you don't need to modify any code;

### Fix Auth module BUG

**Likelihood Of Impact: High**

Version: v1.7.3

1. Fix the BUG that calling `facades.Auth.User` method returns `Unknown column` error when the primary key of user table is `string` type;

<CommentService/>