# Upgrading To v1.8 From v1.7

[[toc]]

## Exciting New Features 🎉

- [Add model association for Orm(1.8.0)](#add-model-association-for-orm)

## Enhancements 🚀

- [Add methods for Request(1.8.0)](#add-methods-for-request)
- [Add methods for Response(1.8.0)](#add-methods-for-response)
- [Optimize database migrate(1.8.0)](#optimize-database-migrate)
- [Route supports HTTPS(1.8.3)](#route-supports-https)

## Breaking Changes 🛠

- [Optimize import order(1.8.0)](#optimize-import-order)
- [mock.Validator change name(1.8.0)](#mock-validator-change-Name)
- [support.Mysql change name(1.8.0)](#support-mysql-change-name)
- [database.NewGormInstance is about to be deprecated(1.8.0)](#database-newgorminstance-is-about-to-be-deprecated)

## Bug Fixes 🐛

- [Fix Orm concurrency safety issue(1.8.1)](#fix-Orm-concurrency-safety-issue)
- [Fix Mail module can't send mail by 25 and 465 ports(1.8.2)](#fix-mail-module-can-t-send-mail-by-25-and-465-ports)

## Upgrade Guide

**Estimated Upgrade Time: 1 Minutes**

### Updating Dependencies

Update dependencies in the `go.mod` file:

```
go get -u github.com/goravel/framework@v1.8.3
```

### Add model association for Orm

Version: v1.8.0

Add methods for Orm, to handle model association:

| Method       | Action                              |
| -----------  | --------------------------------- |
| Association  | [Association](../orm/relationships.md#querying-associations) |
| DB           | [Generic Database Interface sql.DB](../orm/getting-started.md#generic-database-interface-sqldb) |
| Load         | [Lazy Eager Loading](../orm/relationships.md#lazy-eager-loading) |
| LoadMissing  | [Lazy Eager Loading(not exist)](../orm/relationships.md#lazy-eager-loading)           |
| Omit         | [Omit associations](../orm/relationships.md#create-or-update-associations)     |
| With         | [Eager Loading](../orm/relationships.md#Eager-Loading)     |

### Add methods for Request

Version: v1.8.0

 Add methods for `ctx.Request()`, to enrich the format of `Query` parameters: 

| Method        | Action                              |
| -----------  | --------------------------------- |
| `QueryArray` | [Get the array parameters](../the-basics/request.md#Retrieving-Input-From-The-Query-String) |
| `QueryMap`   | [Get the map parameters](../the-basics/request.md#Retrieving-Input-From-The-Query-String) |

### Add-methods-for-Response

Version: v1.8.0

Add `Origin` method to `ctx.Response()`, you can get all  information of `Response` in the HTTP middleware.

[Detail](../the-basics/response.md#Get-Response)

### Optimize import order

Version: v1.8.0

The import order in the `bootstrap/app.go` file change to:

```go
package bootstrap

import (
  "github.com/goravel/framework/foundation"

  "goravel/config"
)
```

[The File](https://github.com/goravel/goravel/blob/v1.8.0/bootstrap/app.go)

### Optimize database migrate

Version: v1.8.0

Run the command that generate the migrate file: `go run . artisan make:migration create_users_table`, the corresponding migration file will be generated based on the default database driver currently in use(`facades.Config.GetString("database.default")`).

### mock.Validator Change Name

Version: v1.8.0

If you use `mock.Validator` to write unit tests, the following modifications are required:

```
import "github.com/goravel/framework/testing/mock"

mock.Validator

// Modify to

import "github.com/goravel/framework/testing/mock"

mock.Validation
```

[Detail](../testing/mock.md#Mock-facades.Validation)

### support.Mysql Change Name

Version: v1.8.0

If you use framework constants such as `support.Mysql` to judge the database driver, you need to make the following modifications:

```go
import "github.com/goravel/framework/database/support"

support.Mysql
support.Postgresql
support.Sqlite
support.Sqlserver

// Modify to

import "github.com/goravel/framework/contracts/database/orm"

orm.Mysql
orm.Postgresql
orm.Sqlite
orm.Sqlserver
```

The new constants such as `orm.Mysql` are of type `orm.Driver` and can be converted to a string type using the `orm.Mysql.String()` method.

### database.NewGormInstance is about to be deprecated

Version: v1.8.0

The `database.NewGormInstance` method will be deprecated in v1.9.0 version, it can be used in current version, if you use the method to get the `gorm` instance, the following modifications are required:

```go
import "github.com/goravel/framework/database"

gorm, err := database.NewGormInstance(connection)

// Modify to

import "github.com/goravel/framework/database/gorm"

gorm, err := gorm.New(connection)
```

### Fix Orm concurrency safety issue

Version: v1.8.1

When high concurrent access, reading `facades.Orm` for the first time may return nil.

### Fix Mail module can't send mail by 25 and 465 ports

Version: v1.8.2

You can send mail by 25, 465, 587 ports now.

### Route supports HTTPS

Version: v1.8.3

`facades.Route` Add `RunTLS` method，support start HTTPS server, [For Detail](../the-basics/routing.md#start-https-server).

<CommentService/>