# Upgrading To v1.9 From v1.8

[[toc]]

## Enhancements 🚀

- [Add database read-write separation(1.9.0)](#add-database-read-write-separation)
- [Add database pool configuration(1.9.0)](#add-database-pool-configuration)
- [Custom .env path(1.9.0)](#custom--env-path)
- [Cache add memory driver(1.9.0)](#cache-add-memory-driver)
- [Orm add Paginate method(1.9.0)](#orm-add-paginate-method)
- [Add make command(1.9.0)](#add-make-command)
- [Add new methods for Response(1.9.0)](#add-new-methods-for-Response)

## Breaking Changes 🛠

- [Add return for Request PrepareForValidation method(1.9.0)](#add-return-for-request-prepareforvalidation-method)

## Bug Fixes 🐛

- [File gets the wrong file type(1.9.0)](#file-gets-the-wrong-file-type)
- [Fix template error on make:event and make:listener command(1.9.0)](#fix-template-error-on-make-event-and-make-listener-command)
- [Fix some types cannot obtain suffixes when save file(1.9.1)](#fix-some-types-cannot-obtain-suffixes-when-save-file)

## Dependency Updates ⬆️

- build(deps): bump github.com/gin-gonic/gin from v1.7.3 to v1.8.2

## Upgrade Guide

**Estimated Upgrade Time: 10 Minutes**

### Updating Dependencies

Update dependencies in the `go.mod` file:

```
go get -u github.com/goravel/framework@v1.9.0
```

### Add database read-write separation

Version: v1.9.0

Database supports read-write separation，[For Detail](../orm/getting-started.md#read--write-connections).

### Add database pool configuration

Version: v1.9.0

Add pool configuration for the database configuration file: `config/database.go`, [For Detail](https://github.com/goravel/goravel/blob/v1.9.x/config/database.go).

### Custom .env path

Version: v1.9.0

```
// Develop
go run . --env=../.env

// Compiled
./main --env=../.env
```

### Cache add memory driver

Version: v1.9.0

`config/cache.go` add `memory` configuration：

```
"stores": map[string]any{
  // New
  "memory": map[string]any{
    "driver": "memory",
  },
},
```

[For Detail](https://github.com/goravel/goravel/blob/v1.9.x/config/cache.go)

### Orm add Paginate method

Version: v1.9.0

`facades.Orm` add `Paginate` method, [For detail](../orm/getting-started.md#Paginate).

### Add make command

Version: v1.9.0

```
// Create controller
go run . artisan make:controller UserController

// Create middleware
go run . artisan make:middleware Cors

// Create model
go run . artisan make:model User
```

### Add new methods for Response

Version: v1.9.0

| Method       | Action           |
| -----------  | -------------- |
| Data         | [Custom return](../the-basics/response.md#custom-return)     |
| Redirect     | [Redirect](../the-basics/response.md#redirect) |

### Add return for Request PrepareForValidation method

Version: v1.9.0

If you are using [PrepareForValidation method in Validation](../the-basics/validation.md#format-data-before-validation), please add a return value: `PrepareForValidation(data validation.Data) error`.

### File gets the wrong file type

Version: v1.9.0

Fix the problem that `.docx`, `.xlsx`, etc. are incorrectly identified as `.zip`.

### Fix template error on make:event and make:listener command

Version: v1.9.0

`import "github.com/goravel/framework/contracts/events"` 改为 `import "github.com/goravel/framework/contracts/event"`

### Fix some types cannot obtain suffixes when save file

Version: v1.9.1

Some types cannot obtain suffixes through the code shown below:

```go
file, err := ctx.Request().File()   
file.Store("upload")
```

<CommentService/>