# 从 v1.0 升级到 v1.1

[[toc]]

## 高影响变化

- [更新依赖](#更新依赖)
- [更新 Providers](#更新-providers)
- [新增 Config](#新增-config)

## 中影响变化

- [facades.Cache 新增方法](facades-cache-新增方法)

## 低影响变化

- [新增 facades.Auth](#新增-facades-auth)

## 升级指南

**预计升级时间：1 分钟**

### 更新依赖

**影响可能性：高**

`go.mod` 中更新依赖：

```go
github.com/goravel/framework v1.1.1
```

### 更新 Providers

**影响可能性：高**

`config.app.go` 中新增 Auth Provider：

```go
"github.com/goravel/framework/auth"

"providers": []contracts.ServiceProvider{
  ...
  &mail.ServiceProvider{},
  &auth.ServiceProvider{},
  &providers.AppServiceProvider{},
  ...
}
```

### 新增 Config

**影响可能性：高**

`config` 目录新增文件：

1. [auth.go](https://github.com/goravel/goravel/blob/v1.1.1/config/auth.go)
2. [jwt.go](https://github.com/goravel/goravel/blob/v1.1.1/config/jwt.go)

### facades.Cache 新增方法

**影响可能性：中**

新增方法：

1. [facades.Cache.GetBool](https://github.com/goravel/framework/blob/87c7fa9b95e45fcf4f88a502f1a1adc213527ae1/contracts/cache/store.go#L9)
2. [facades.Cache.GetInt](https://github.com/goravel/framework/blob/87c7fa9b95e45fcf4f88a502f1a1adc213527ae1/contracts/cache/store.go#L10)
3. [facades.Cache.GetString](https://github.com/goravel/framework/blob/87c7fa9b95e45fcf4f88a502f1a1adc213527ae1/contracts/cache/store.go#L11)

如果你使用了[自定义缓存驱动](https://github.com/goravel/docs/blob/master/zh/digging-deeper/cache.md#%E6%B7%BB%E5%8A%A0%E8%87%AA%E5%AE%9A%E4%B9%89%E7%BC%93%E5%AD%98%E9%A9%B1%E5%8A%A8)，则需要实现这三个接口。

### 新增 facades.Auth

**影响可能性：低**

新增用户验证功能 [facades.Auth](../security/authentication.md)。

<CommentService/>