# 从 v1.9 升级到 v1.10

[[toc]]

### 令人兴奋的新功能 🎉

- [新增 facades.Crypt(1.10.0)](#加密解密)
- [新增 facades.Hash(1.10.0)](#哈希)
- [新增路由限流器(1.10.0)](#新增路由限流器)

### 功能增强 🚀

- [优化 HTTP 启动方式(1.10.0)](#优化-http-启动方式)
- [优化 GPRC 启动方式(1.10.0)](#优化-grpc-启动方式)
- [增加控制日志输出到控制台的配置(1.10.0)](#增加控制日志输出到控制台的配置)
- [Request 修改、新增方法(1.10.0)](#request-修改、新增方法)
- [队列支持延迟调度(1.10.0)](#队列支持延迟调度)
- [ORM Connection 支持配置表名前缀与单复数(1.10.0)](#orm-connection-支持配置表名前缀与单复数)
- [新增 docker-compose.yml 文件(1.10.0)](#新增-docker-compose-yml-文件)
- [优化 Orm(1.10.0)](#优化-orm)
- [迁移文件中支持执行多条 SQL 语句(1.10.0)](#迁移文件中支持执行多条-sql-语句)
- [文件系统新增 minio 驱动(1.10.0)](#文件系统新增-minio-驱动)
- [contracts/http 增加 net/http 的 Status 映射(1.10.0)](#contracts-http-增加-net-http-的-status-映射)

### 破坏性变化 🛠

- [APP_KEY 必填(1.10.0)](#app-key-必填)
- [表单验证中方法新增 ctx 参数(1.10.0)](#表单验证中方法新增-ctx-参数)
- [facades.Auth.Parse 新增 payload 返回(1.10.0)](#facades-auth-parse-新增-payload-返回)
- [Orm 的部分方法新增返回值(1.10.0)](#orm-的部分方法新增返回值)

## 升级指南

**预计升级时间：20 分钟**

### 更新依赖

`go.mod` 中更新依赖：

```
go get -u github.com/goravel/framework@v1.10.1 && go mod tidy
```

### 加密解密

Version: v1.10.0

新增 `facades.Crypt`：

1. [config/app.go](https://github.com/goravel/goravel/blob/v1.10.x/config/app.go) 文件 `providers` 新增 `&crypt.ServiceProvider{},`。

[查看文档](../security/encryption.md)

### 哈希

Version: v1.10.0

新增 `facades.Hash`：

1. [config/app.go](https://github.com/goravel/goravel/blob/v1.10.x/config/app.go) 文件 `providers` 新增 `&hash.ServiceProvider{},`；

2. 新增 [config/hashing.go](https://github.com/goravel/goravel/blob/v1.10.x/config/hashing.go) 文件；

[查看文档](../security/hashing.md)

### 新增路由限流器

Version: v1.10.0

[查看文档](../the-basics/routing.md#速率限制)

### 优化 HTTP 启动方式

Version: v1.10.0

1. 新增 `config/http.go` 配置文件，[详见文件](https://github.com/goravel/goravel/blob/v1.10.x/config/http.go)；
2. `facades.Route.Run` 方法不再需要传参，默认读取 `http.host` 和 `http.port`（您无需修改代码，向下兼容）；
3. `facades.Route.RunTLS` 方法不再需要传参，默认读取 `http.tls.host`，`http.tls.port`，`http.tls.ssl.cert` 和 `http.tls.ssl.key`，如果用到，需修改代码；
4. 新增 `facades.Route.RunTLSWithCert` 方法，[详见文档](../the-basics/routing.md#启动服务器)；
5. 移动配置 `app.url`, `app.host` 到 `http.url`, `http.host`；

### 优化 GRPC 启动方式

Version: v1.10.0

`facades.Grpc.Run` 方法不再需要传参，默认读取 `grpc.host` 和 `grpc.port`（您无需修改代码，向下兼容）；

### 增加控制日志输出到控制台的配置

Version: v1.10.0

`config/logging.go` 文件中，`single`, `daily` channel 新增 `print` 配置，可以控制日志是否输出到控制台，[详见文件](https://github.com/goravel/goravel/blob/v1.10.x/config/logging.go)；

### Request 修改、新增方法

Version: v1.10.0

1. `Input` 方法由仅获取路由参数，修改为根据以下顺序获取数据：`json`, `form`, `query`, `route`。注意：`json` 只能获取一维数据，否则将返回空；
2. 新增 `Route` 方法替代原有 `Input` 方法功能；
3. `Query` 与 `Form` 方法默认值修改为不必填；
4. 新增以下方法：

| 方法名        | 作用           |
| -----------  | -------------- |
| Route        | [获取路由中的参数](../the-basics/request.md#获取路由中的参数)     |
| RouteInt        | [获取路由中的参数](../the-basics/request.md#获取路由中的参数)     |
| RouteInt64        | [获取路由中的参数](../the-basics/request.md#获取路由中的参数)     |
| QueryInt        | [获取路由传入的参数](../the-basics/request.md#获取路由传入的参数)     |
| QueryInt64        | [获取路由传入的参数](../the-basics/request.md#获取路由传入的参数)     |
| QueryBool        | [获取路由传入的参数](../the-basics/request.md#获取路由传入的参数)     |
| InputInt        | [获取路由传入的参数](../the-basics/request.md#获取路由传入的参数)     |
| InputInt64        | [获取路由传入的参数](../the-basics/request.md#获取路由传入的参数)     |
| InputBool        | [获取路由传入的参数](../the-basics/request.md#获取路由传入的参数)     |
| Json        | [获取路由传入的 Json](../the-basics/request.md#获取-json)     |

### 队列支持延迟调度

Version: v1.10.0

新增 `Delay` 方法，[详见文档](../digging-deeper/queues.md#延迟调度)

### ORM Connection 支持配置表名前缀与单复数

Version: v1.10.0

1. `Model` 支持指定表名，[详见文档](../orm/getting-started.md#指定表名)；
2. `config/database.go` 中的 `connection` 新增键值：

`prefix`：设置表名前缀；
`singular`：设置表名使用单数还是复数；

[详见文件](https://github.com/goravel/goravel/blob/v1.10.x/config/database.go)

### 新增 docker-compose.yml 文件

Version: v1.10.0

您现在可以使用以下命令快速启动服务：

```
docker-compose build
docker-compose up
```

### 优化 Orm

Version: v1.10.0

1. 新增以下方法：

| 方法名         | 作用                                    |
| ------------- | --------------------------------------- |
| FirstOr | [查询或通过回调返回一条数据](../orm/getting-started.md#查询一条数据)             |
| FirstOrCreate | [查询或创建模型](../orm/getting-started.md#查询或创建模型)             |
| FirstOrNew | [查询或实例化模型](../orm/getting-started.md#查询或创建模型)             |
| FirstOrFail | [未找到时抛出错误](../orm/getting-started.md#未找到时抛出错误)             |
| UpdateOrCreate       | [更新或创建一条数据](../orm/getting-started.md#更新或创建一条数据)

2. 之前这样写报错，现在支持：

```go
query := facades.Orm.Query()
query = query.Where()
```

### 迁移文件中支持执行多条 SQL 语句

Version: v1.10.0

之前迁移文件中仅支持执行一条 SQL 语句，现在支持多条。

### 文件系统新增 minio 驱动

Version: v1.10.0

新增 minio 配置，[详见文件](https://github.com/goravel/goravel/blob/v1.10.x/config/filesystems.go)。

### contracts/http 增加 net/http 的 Status 映射

Version: v1.10.0

可以在 controller 中直接使用 `http.StatusOK` 等状态码，而不需要再导入 `net/http`。

[详见文件](https://github.com/goravel/framework/blob/v1.10.0/contracts/http/status.go)

### APP_KEY 必填

Version: v1.10.0

`.env` 文件中 `APP_KEY` 修改为必填项，可以通过 `go run . artisan key:generate` 生成。

### 表单验证中方法新增 ctx 参数

Version: v1.10.0

表单验证的 `Rules`, `Messages`, `Attributes`, `PrepareForValidation` 方法，新增 `ctx http.Context` 传参，使您可以进行更加自定义的配置。

[详见文档](../the-basics/validation.md#创建表单请求验证)

### facades.Auth.Parse 新增 payload 返回

Version: v1.10.0

`err := facades.Auth.Parse(ctx, token)` 修改为 `payload, err := facades.Auth.Parse(ctx, token)`，通过 `payload` 您可以获取到：

1. `Guard`: 当前 Guard；
2. `Key`: 用户标识；
3. `ExpireAt`: 过期时间；
4. `IssuedAt`: 发行时间；

[详见文档](../security/authentication.md#解析-token)

### Orm 的部分方法新增返回值

Version: v1.10.0

以下方法新增 `*Result` 返回值，以获取影响行数：

```go
res, err := query.Delete(&user)
res, err := query.Exec(fmt.Sprintf("DELETE FROM users where id = %d", user.ID))
res, err := query.ForceDelete(&User{})
res, err := query.Updates(User{Avatar: "avatar"})

// 获取受影响行数
num := res.RowsAffected
```

### facades.Orm 新增模型事件

Version: v1.10.1

Orm 模型触发几个事件，允许你挂接到模型生命周期的如下节点：`Retrieved`、`Creating`、`Created`、`Updating`、`Updated`、`Saving`、`Saved`、`Deleting`、`Deleted`、`ForceDeleting`、`ForceDeleted`。事件允许您每当特定模型保存或更新数据库时执行代码。

[详见文档](../orm/getting-started.md#events)

### facades.Cache 新增、优化方法

Version: v1.10.1

| 方法名        | 作用           |
| -----------  | -------------- |
| Decrement    | [递减值](../digging-deeper/cache.md#递增--递减值)     |
| Increment    | [递增值](../digging-deeper/cache.md#递增--递减值)     |
| Lock         | [原子锁](../digging-deeper/cache.md#原子锁)     |
| Store        | [访问多个缓存存储](../digging-deeper/cache.md#可用的缓存驱动)     |

`Get`, `GetBool`, `GetInt`, `GetInt64`, `GetString`, `Pull` 方法不再需要传递默认值（向下兼容）。

### facades.Route 支持 Fallback 路由

Version: v1.10.1

您可以定义一个在没有其他路由匹配传入请求时将执行的路由。

```go
facades.Route.Fallback(func(ctx http.Context) http.Response {
  return ctx.Response().String(404, "not found")
})
```

### facades.Orm 支持原生表达式

Version: v1.10.1

可以使用 `db.Raw` 方法进行字段的更新：

```go
import "github.com/goravel/framework/database/db"

facades.Orm.Query().Model(&user).Update("age", db.Raw("age - ?", 1))
```

<CommentService/>