# 从 v1.10 升级到 v1.11

[[toc]]

## v1.11.3

### Bug 修复 🐛

- [Schedule 中 panic 导致进程中断的问题](#schedule-中-panic-导致进程中断的问题)
- [Schedule 中 DailyAt 每分钟都会执行的问题](#schedule-中-dailyat-每分钟都会执行的问题)

## v1.11.2

### Bug 修复 🐛

- [同时使用 Request.Input() 与 Request.Bind() 数据错误的问题](#同时使用-request-input()-与-request-bind()-方法数据错误的问题)

## v1.11.1

### 功能增强 🚀

- [Route 新增资源路由](#route-新增资源路由)
- [Request 新增方法](#request-新增方法)
- [Storage 新增方法](#storage-新增方法)
- [File 新增方法](#file-新增方法)

### Bug 修复 🐛

- [修复文件储存 windows 路径错误的问题](#修复文件储存-windows-路径错误的问题)
- [修复 Request 模块 Header panic 问题](修复-request-模块-header-panic-问题)

## v1.11.0

### 令人兴奋的新功能 🎉

- [Orm 新增模型事件(1.11.0)](#orm-新增模型事件)

### 功能增强 🚀

- [Cache 新增、优化方法(1.11.0)](#cache-新增、优化方法)
- [Route 支持 Fallback 路由(1.11.0)](#route-支持-fallback-路由)
- [Orm 新增方法(1.11.0)](#orm-新增方法)
- [优化 facades.Config.Add() 方法(1.11.0)](#优化-facades-config-add-方法)
- [修改 Sqlite 驱动(1.11.0)](#修改-sqlite-驱动)
- [contracts/http 增加 net/http 的 Method 映射(1.11.0)](#contracts-http-增加-net-http-的-method-映射)

### 破坏性变化 🛠

- [Orm 优化、移除方法(1.11.0)](#_2-优化、移除废弃的方法)

### Bug 修复 🐛

- Hash 配置在某种情况下不生效的问题(1.11.0)
- RateLimiter 非线程安全的问题(1.11.0)

## 升级指南

请根据本节内容，一步步进行框架升级。

**预计升级时间：1 分钟**

### 1. 更新依赖

`go.mod` 中更新依赖：

```
go get -u github.com/goravel/framework@v1.11.0 && go mod tidy
```

### 2. 优化、移除废弃的方法

```
import (
  "github.com/goravel/framework/database"
  "github.com/goravel/framework/database/gorm"
)

// 废弃
database.NewGormInstance()
// 替换为（注：该方法未推荐使用，请尽量不用）
gorm.New()

// 废弃
facades.Orm.Query().Updates()
// 替换为(只修改方法名即可，无需修改参数)
facades.Orm.Query().Update()

// Update 方法修改返回值
// 修改前
err := facades.Orm.Query().Update()
// 修改后
res, err := facades.Orm.Query().Update()
```

## 新增内容

本节内容不涉及到代码修改，只是功能增强。

### Orm 新增模型事件

Version: v1.11.0

Orm 模型触发几个事件，允许你挂接到模型生命周期的如下节点：`Retrieved`、`Creating`、`Created`、`Updating`、`Updated`、`Saving`、`Saved`、`Deleting`、`Deleted`、`ForceDeleting`、`ForceDeleted`。

[详见文档](../orm/getting-started.md#events)

### Cache 新增、优化方法

Version: v1.11.0

#### 新增方法

| 方法名        | 作用           |
| -----------  | -------------- |
| Decrement    | [递减值](../digging-deeper/cache.md#递增--递减值)     |
| Increment    | [递增值](../digging-deeper/cache.md#递增--递减值)     |
| Lock         | [原子锁](../digging-deeper/cache.md#原子锁)     |
| Store        | [访问多个缓存存储](../digging-deeper/cache.md#可用的缓存驱动)     |

#### 优化方法

`Get`, `GetBool`, `GetInt`, `GetInt64`, `GetString`, `Pull` 方法不再需要传递默认值（向下兼容）。

### Route 支持 Fallback 路由

Version: v1.11.0

您可以定义一个在没有其他路由匹配传入请求时将执行的路由。

```go
facades.Route.Fallback(func(ctx http.Context) http.Response {
  return ctx.Response().String(404, "not found")
})
```

### Orm 新增方法

Version: v1.11.0

| 方法名        | 作用           |
| -----------  | -------------- |
| db.Raw    | [原生表达式](../orm/getting-started.md#原生表达式)     |
| LockForUpdate    | [悲观锁](../orm/getting-started.md#悲观锁)     |
| SharedLock    | [悲观锁](../orm/getting-started.md#悲观锁)     |

### 优化 facades.Config.Add() 方法

Version: v1.11.0

`facades.Config.Add()` 方法 `configuration` 参数由 `map[string]any` 修改为 `any`，使设置更灵活。

[查看文档](../getting-started/configuration.md#设置配置值)

### 修改 Sqlite 驱动

因为 `github.com/mattn/go-sqlite3` 要求必须启动 `CGO`，因此替换了一个不强制要求 `CGO` 的第三方包：`github.com/glebarez/go-sqlite`。

### contracts/http 增加 net/http 的 Method 映射

Version: v1.11.0

可以在 controller 中直接使用 `http.MethodGet` 等，而不需要再导入 `net/http`。

[详见文件](https://github.com/goravel/framework/blob/v1.11.0/contracts/http/method.go)

### Route 新增资源路由

Version: v1.11.1

```go
facades.Route.Resource("/resource", resourceController)
```

[For Detail](../the-basics/routing.md#资源路由)

### Request 新增方法

Version: v1.11.1

| 方法名        | 作用           |
| -----------  | -------------- |
| All          | [获取所有输入数据](../the-basics/request.md#获取所有输入数据)     |
| Host         | [获取请求 Host](../the-basics/request.md#获取请求-host)     |
| Queries      | [获取所有查询字符串](../the-basics/request.md#获取路由传入的参数)     |

即将废弃 `Form`, `Json` 方法，请替换为 `Input`。

### Storage 新增方法

Version: v1.11.1

| 方法名        | 作用           |
| -----------  | -------------- |
| LastModified | [获取文件最后修改时间](../digging-deeper/filesystem.md#文件-Metadata-信息)     |
| MimeType     | [获取文件类型](../digging-deeper/filesystem.md#文件-Metadata-信息)     |

### File 新增方法

Version: v1.11.1

| 方法名        | 作用           |
| -----------  | -------------- |
| LastModified | [获取文件最后修改时间](../digging-deeper/filesystem.md#文件-Metadata-信息)     |
| MimeType     | [获取文件类型](../digging-deeper/filesystem.md#文件-Metadata-信息)     |
| Size     | [获取文件大小](../digging-deeper/filesystem.md#文件-Metadata-信息)     |

### 修复文件储存 windows 路径错误的问题

Version: v1.11.1

windows 系统中路径有斜线不对的问题。

### 修复 Request 模块 Header panic 问题

Version: v1.11.1

`ctx.Request().Header( key: "token")` 将会 panic。

### 同时使用 Request.Input() 与 Request.Bind() 方法数据错误的问题

Version: v1.11.2

由于使用 `Request.Input()` 方法会清空 `Request.Body`，之后再使用 `Request.Bind()`，将无法正确获取到数据。

### Schedule 中 panic 导致进程中断的问题

Version: v1.11.3

当 Schedule 中出现 panic，会导致进程中断，影响所有定时任务。

### Schedule 中 DailyAt 每分钟都会执行的问题

Version: v1.11.3

修复 `DailyAt` 每分钟都会执行的问题：

```go
func (kernel *Kernel) Schedule() []schedule.Event {
  return []schedule.Event{
    facades.Schedule.Call(func() {
      fmt.Print("1")
    }).DailyAt("18:00"),
  }
}
```

<CommentService/>
