# 从 v1.11 升级到 v1.12

## v1.12.6

### Bug 修复 🐛

- [修复 JWT 的问题](#修复-jwt-的问题)

## v1.12.5

### Bug 修复 🐛

- [修复 facades.Orm().Query().Load() 的问题](#修复-facades-orm-query-load-的问题)

## v1.12.4

### Bug 修复 🐛

- [throttle 中间件 panic 的问题](#throttle-中间件-panic-的问题)

## v1.12.3

### Bug 修复 🐛

- [Windows 下 make:package 命令的问题](#windows-下-make-package-命令的问题)

## v1.12.2

### Bug 修复 🐛

- [facades.Gate() 返回 nil 的问题](#facades-gate-返回-nil-的问题)

## v1.12.1

### Bug 修复 🐛

- [Windows 下因文件路径引发 panic 的问题](#windows-下因文件路径引发-panic-的问题)

## v1.12.0

### 令人兴奋的新功能 🎉

- [服务容器](#服务容器)
- [扩展包开发](#扩展包开发)
- [新增 Carbon 模块](#新增-helpers-方法)

### 功能增强 🚀

- [Artisan Flag 新增方法](#artisan-flag-新增方法)
- [新增 Helpers 方法](#新增-helpers-方法)
- [升级依赖](#升级依赖)
- [Migration 新增命令](#migration-新增命令)
- [部分 `make` 命令支持子文件夹](#部分-make-命令支持子文件夹)

### 破坏性变化 🛠

- [修改 facades 调用方式](#_3-修改-facades)
- [优化 Artisan Flag 参数格式](#_6-修改-artisan-命令中的-flag-如果用到)
- [Filesystem 模块取消对 S3, OSS, COS, Minio 驱动的默认支持](#_7-filesystem-模块取消对-s3-oss-cos-minio-驱动的默认支持)
- [Cache 模块取消对 Redis 驱动的默认支持](#_8-cache-模块取消对-redis-驱动的默认支持)
- [修改 Model 中 CreatedAt, UpdatedAt 的类型](#_9-修改-model-中-createdat-updatedat-的类型)
- [优化 Validation 模块的校验规则](#_10-优化-validation-模块的校验规则)

## 升级指南

请根据本节内容，一步步进行框架升级。

**预计升级时间：30 分钟**

### 1. 更新依赖

`go.mod` 中更新依赖：

```
go get -u github.com/goravel/framework@v1.12.0 && go mod tidy
```

`go mod tidy` 将会抛出一个错误，执行完下面升级步骤即可解决。

### 2. 修改 `bootstrap/app.go`

```go
// 修改前
app := foundation.Application{}

// 修改后
app := foundation.NewApplication()
```

### 3. 修改 facades.*

| 修改前        | 修改后           |
| -----------  | -------------- |
| `facades.Artisan`    | `facades.Artisan()`     |
| `facades.Auth`    | `facades.Auth()`     |
| `facades.Cache`    | `facades.Cache()`     |
| `facades.Config`    | `facades.Config()`     |
| `facades.Crypt`    | `facades.Crypt()`     |
| `facades.Event`    | `facades.Event()`     |
| `facades.Gate`    | `facades.Gate()`     |
| `facades.Grpc`    | `facades.Grpc()`     |
| `facades.Hash`    | `facades.Hash()`     |
| `facades.Log`    | `facades.Log()`     |
| `facades.Mail`    | `facades.Mail()`     |
| `facades.Orm`    | `facades.Orm()`     |
| `facades.Queue`    | `facades.Queue()`     |
| `facades.RateLimiter`    | `facades.RateLimiter()`     |
| `facades.Route`    | `facades.Route()`     |
| `facades.Schedule`    | `facades.Schedule()`     |
| `facades.Storage`    | `facades.Storage()`     |
| `facades.Validation`    | `facades.Validation()`     |

### 4. 修改 `app/providers/*` 

所有文件增加导入：

```go
import (
  "github.com/goravel/framework/contracts/foundation"
)
```

所有 `Register`, `Boot` 方法增加 `app foundation.Application` 入参：

```go
func (receiver *AppServiceProvider) Register(app foundation.Application) {}

func (receiver *AppServiceProvider) Boot(app foundation.Application) {}
```

### 5. 修改 `app/config/app.go` 

修改导入：

```go
// 修改前
"github.com/goravel/framework/contracts"

"providers": []contracts.ServiceProvider{

// 修改后
"github.com/goravel/framework/contracts/foundation"

"providers": []foundation.ServiceProvider{
```

### 6. 修改 Artisan 命令中的 Flag（如果用到）

为 `[]command.Flag` 中的项增加 `&command.StringFlag` 类型：

```go
// 修改前
func (receiver *VendorPublishCommand) Extend() command.Extend {
  return command.Extend{
    Category: "test",
    Flags: []command.Flag{
      {
        Name: "test",
      },
    },
  }
}

// 修改后
func (receiver *VendorPublishCommand) Extend() command.Extend {
  return command.Extend{
    Category: "test",
    Flags: []command.Flag{
      &command.StringFlag{
        Name: "test",
      },
    },
  }
}
```

### 7. Filesystem 模块取消对 S3, OSS, COS, Minio 驱动的默认支持

为减少加载不必要的第三方包，减小打包体积，提高编译效率，Goravel 将逐步剥离各模块驱动到独立扩展包。本次升级 Filesystem 模块取消对 `S3`, `OSS`, `COS`, `Minio` 驱动的默认支持，转由独立扩展包提供支持。

删除 `config/filesystems.go::disks` 中除 `local` 和正在使用的驱动以外的键：

```go
// 修改后
"disks": map[string]any{
  "local": map[string]any{
    "driver": "local",
    "root":   "storage/app",
    "url":    config.Env("APP_URL", "").(string) + "/storage",
  },
},
```

如果您用到了 `local` 以外的驱动，请参考对应驱动文档进行安装：

| 驱动          | 地址           |
| -----------  | -------------- |
| S3           | [https://github.com/goravel/s3](https://github.com/goravel/s3)     |
| OSS          | [https://github.com/goravel/oss](https://github.com/goravel/oss)     |
| COS          | [https://github.com/goravel/cos](https://github.com/goravel/cos)     |
| Minio        | [https://github.com/goravel/minio](https://github.com/goravel/minio)     |

### 8. Cache 模块取消对 Redis 驱动的默认支持

如果您没有使用 `redis` 驱动，删除 `config/cache.go::stores` 中的 `redis` 键：

```go
// 修改后
"stores": map[string]any{
  "memory": map[string]any{
    "driver": "memory",
  },
},
```

如果您用到了 `redis` 驱动，请参考文档进行安装：

| 驱动          | 地址           |
| -----------  | -------------- |
| Redis        | [https://github.com/goravel/redis](https://github.com/goravel/redis)     |

### 9. 修改 Model 中 CreatedAt, UpdatedAt 的类型

为了使时间类型在接口输出时更加标准，`CreatedAt`, `UpdatedAt` 类型由 `time.Time` 修改为 `carbon.DateTime`。如果您对这两个字段进行了额外处理，可以通过 `CreatedAt.ToStdTime()` 方法获取原有的 `time.Time` 类型。

### 10. 优化 Validation 模块的校验规则

原有校验规则中对零值进行校验，例如设置规则为 `date` 且没有设置 `required`，如果该字段为空或未传入，会提示该字段必填。优化后，将跳过校验，更符合使用直觉。如果您用到了相关校验，请确保升级后与预期一致。

### 11. 再次安装依赖

运行 `go mod tidy` 命令。

## 功能介绍

### 服务容器

Version: v1.12.0

Goravel 中所有服务都注册到服务容器当中，为第三方包的开发提供有力的支持，[详见文档](../architecutre-concepts/service-container.md)。

### 扩展包开发

Version: v1.12.0

包是向 Goravel 添加功能的主要方式，可以使 Goravel 的生态更加丰富，[详见文档](../digging-deeper/package-development.md)。

### Artisan Flag 新增方法

Version: v1.12.0

为 Artisan 模块新增获取不同类型 `Flag` 的方法，[详见文档](../digging-deeper/artisan-console.md#选项)。

### 新增 Helpers 方法

Version: v1.12.0

新增 `path`, `carbon` Helpers 方法，可以很方便的获取项目中的路径信息与进行时间处理，[详见文档](../digging-deeper/helpers.md)。

### 升级依赖

Version: v1.12.0

为提供更好的功能支持，升级了 Goravel 依赖的所有包的版本。

### Migration 新增命令

Version: v1.12.0

| 命令             | 作用           |
| -----------     | -------------- |
| migrate:fresh   | 删除所有表并重新运行所有迁移     |
| migrate:refresh | 回滚所有迁移并重新运行所有迁移     |
| migrate:reset   | 回滚所有迁移     |
| migrate:status  | 查询迁移状态    |

### 部分 `make` 命令支持子文件夹

Version: v1.12.0

| 命令                                 | 生成文件                              |
| ----------------------              | ------------------------------------ |
| make:policy User/AuthPolicy         | app/policies/User/auth_policy.go     |
| make:command Goravel/CleanCache     | app/console/commands/Goravel/clean_cache.go     |
| make:model User/Phone               | app/models/User/phone.go     |
| make:observer User/PhoneObserver    | app/observers/User/phone_observer.go     |
| make:event User/GoravelEvent        | app/events/User/goravel_event.go     |
| make:listener User/GoravelListen    | app/listeners/User/goravel_listen.go     |
| make:controller User/AuthController | app/http/controllers/User/auth_controller.go     |
| make:middleware User/Auth           | app/http/middleware/User/auth.go     |
| make:request User/Auth              | app/http/requests/User/auth.go     |
| make:job Goravel/Job                | app/jobs/Goravel/job.go    |
| make:rule User/Phone                | app/rules/User/phone.go     |

### Windows 下因文件路径引发 panic 的问题

Version: v1.12.1

修复 windows 下，`make` 命令自动创建文件夹时，由于反斜杠引发 panic 的问题。

### facades.Gate() 返回 nil 的问题

Version: v1.12.2

修复 facades.Gate() 返回 nil 的问题。

### Windows 下 make:package 命令的问题

Version: v1.12.3

修复 Windows 下 make:package 命令创建的文件中的路径错误的问题。

### throttle 中间件 panic 的问题

Version: v1.12.4

修复 throttle 中间件 panic 的问题。

### 修复 facades.Orm().Query().Load() 的问题

Version: v1.12.5

修复 `facades.Orm().Query().Load()` 某种情况下无法正确加载模型的问题。

### 修复 JWT 的问题

Version: v1.12.6

修复 JWT Token 过期且无效时，返回过期错误的问题，预期优先返回无效错误。
