# 从 v1.12 升级到 v1.13

### 令人兴奋的新功能 🎉

- [数据填充](#数据填充)
- [模型工厂](#模型工厂)
- [集成测试](#集成测试)
- [视图](#视图)

### 功能增强 🚀

- [Go 默认版本升级为 1.20](#go-默认版本升级为-1-20)
- [任务调度支持横向伸缩](#任务调度支持横向伸缩)
- [新增 debug 方法](#新增-debug-方法)
- [make:controller 命令新增参数](#make-controller-命令新增参数)
- [Response 新增 Status 方法](#response-新增-status-方法)
- [Orm 新增 Sum 和 Cursor 方法](#orm-新增-sum-和-cursor-方法)
- [Route 模块支持配置驱动](#route-模块支持配置驱动)
- [Request 新增 InputArray 和 InputMap 方法](#request-新增-inputarray-和-inputmap-方法)
- [Orm 模型支持自定义链接](#orm-模型支持自定义链接)
- [Filesystem 模块新增 Cloudinary 驱动](#filesystem-模块新增-cloudinary-驱动)
- [Log 新增链式方法](#log-新增链式方法)

#### v1.13.4

- [服务启动支持环境变量](#服务启动支持环境变量)

### 破坏性变化 🛠

- [移除默认加载的 HTTP 全局中间件](#_5-移除默认加载的-http-全局中间件)
- [优化 Controller 返回](#_6-优化-controller-返回)
- [修改 facades.Route() 中 Group 方法的入参](#_7-修改-facades-route-中-group-方法的入参)
- [优化 facades.Cache() 中 Remember 与 RememberForever 方法（如果用到）](#_8-修改-facades-cache-中-remember-与-rememberforever-方法-如果用到)
- [修改 access.NewAllowResponse 与 access.NewDenyResponse 包名（如果用到）](#_9-修改-access-newallowresponse-与-access-newdenyresponse-包名-如果用到)
- [移除废弃方法（如果用到）](#_10-移除废弃方法-如果用到)

### Bug 修复 🐛

- [修复 facades.Auth().User() 的问题](#修复-facades-auth-user-的问题)
- [修复自定义 .env 路由某些情况下不生效的问题](#修复自定义-env-路由某些情况下不生效的问题)
- [修复 JWT 中设置 ttl == 0 时 token 立即过期的问题](#修复-jwt-中设置-ttl-0-时-token-立即过期的问题)

#### v1.13.2

- [修复 facades.Storage().Url() 在 windows 系统下路径错误的问题](#修复-facades-storage-url-在-windows-系统下路径错误的问题)
- [修复 Postgres 密码为空时连接异常的问题](#修复-postgres-密码为空时连接异常的问题)
- [修复使用 Orm Cursor 方法时 With 方法无效的问题](#修复使用-orm-cursor-方法时-with-方法无效的问题)

#### v1.13.4

- [修复 validation 无法校验路由参数的问题](#修复-validation-无法校验路由参数的问题)
- [修复 Fiber 驱动无法返回文件的问题](#修复-fiber-驱动无法返回文件的问题)
- [修复 Fiber 驱动全局中间件 panic 的问题](#修复-fiber-全局中间件-panic-的问题)
- [修复 Fiber 驱动的 ContentType 设置与 Gin 驱动不同的问题](#修复-fiber-驱动的-contenttype-设置与-gin-驱动不同的问题)

#### v1.13.5

- [修复模型自定义链接不生效](#修复模型自定义链接不生效)
- [修复 Mock Log 报错](#修复-mock-log-报错)

#### v1.13.6 v1.13.7

- [修复队列任务链非线性执行的问题](#修复队列任务链非线性执行的问题)

#### v1.13.8

- [修复使用不同 Guard 多次调用 facades.Auth().Parse() 数据被覆盖的问题](#修复使用不同-guard-多次调用-facades-auth-parse-数据被覆盖的问题)
- [修复使用 facades.Orm().WithContext() 设置 ctx 无法被正确传达到 event.Context() 的问题](#修复使用-facades-orm-withcontext-设置-ctx-无法被正确传达到-event-context-的问题)
- [优化队列日志根据 APP_DEBUG 设置显示](#优化队列日志根据-app-debug-设置显示)

#### v1.13.9

- [修复 Log 换行错误的问题](#修复-log-换行错误的问题)
- [修复 vendor:publish 命令无法发布多层文件夹的问题](#修复-vendor-publish-命令无法发布多层文件夹的问题)

#### v1.13.10

- [修复 Log 中 traces 错误的问题](#修复-log-中-traces-错误的问题)
- [修复 orm event 中 GetAttribute 方法返回数据错误的问题](#修复-orm-event-中-getattribute-方法返回数据错误的问题)
- [ORM 新增 ToSql, ToRawSql 方法](#orm-新增-tosql-torawsql-方法)

## 升级指南

请根据本节内容，一步步进行框架升级。

**预计升级时间：10 分钟**

### 1. 更新依赖

`go.mod` 中更新依赖：

```
go get -u github.com/goravel/framework@v1.13.9 && go get -u github.com/goravel/gin
```

### 2. 新增文件

[tests](https://github.com/goravel/goravel/tree/v1.13.x/tests)

[database/seeders/database_seeder.go](https://github.com/goravel/goravel/tree/v1.13.x/database/seeders/database_seeder.go)

[app/providers/database_service_provider.go](https://github.com/goravel/goravel/tree/v1.13.x/app/providers/database_service_provider.go)

### 3. 注册新的 Provider

注意顺序：

```go
import (
  "github.com/goravel/framework/testing"
  "github.com/goravel/gin"
)

// config/app.go
"providers": []foundation.ServiceProvider{
  ...
  &validation.ServiceProvider{},
  // New
  &testing.ServiceProvider{}, 
  &providers.AppServiceProvider{},
  ...
  &providers.ValidationServiceProvider{},
  // New
  &providers.DatabaseServiceProvider{}, 
  // New
  &gin.ServiceProvider{}, 
}
```

### 4. 新增配置

修改 [config/http.go](https://github.com/goravel/goravel/tree/v1.13.x/config/http.go)

```go
import (
  "github.com/goravel/framework/contracts/route"
  "github.com/goravel/framework/facades"
  ginfacades "github.com/goravel/gin/facades"
)

config.Add("http", map[string]any{
  // HTTP Driver
  "default": "gin",
  // HTTP Drivers
  "drivers": map[string]any{
    "gin": map[string]any{
      "route": func() (route.Route, error) {
        return ginfacades.Route("gin"), nil
      },
    },
  },
  ...
}
```

修改 [config/cors.go](https://github.com/goravel/goravel/tree/v1.13.x/config/cors.go)

```go
config.Add("cors", map[string]any{
  ...
  // New
  "paths":                []string{"*"}, 
  "allowed_methods":      []string{"*"},
  ...
}
```

### 5. 移除默认加载的 HTTP 全局中间件

1. `tls` 与 `cors` 中间件已集成至默认 HTTP 驱动中，因此 `app/http/kernel.go` 文件中的 `middleware.Cors()` 与 `middleware.Tls()` 需被移除。

2. `app/providers/route_service_provider.go` 文件中 `facades.Route().GlobalMiddleware(http.Kernel{}.Middleware()...)` 方法从 `Register` 移动至 `Boot`:

```go
package providers

...

type RouteServiceProvider struct {
}

func (receiver *RouteServiceProvider) Register(app foundation.Application) {
}

func (receiver *RouteServiceProvider) Boot(app foundation.Application) {
  //Add HTTP middleware
  facades.Route().GlobalMiddleware(http.Kernel{}.Middleware()...)

  receiver.configureRateLimiting()

  routes.Web()
}

func (receiver *RouteServiceProvider) configureRateLimiting() {

}
```

### 6. 优化 Controller 返回

`Controller` 增加返回值 `http.Response`，`ctx.Response()` 可直接返回，不需要再单独 `return`，使逻辑更加流畅：

```go
// Before
func (r *UserController) Show(ctx http.Context) {
  ctx.Response().Success().Json(http.Json{
    "Hello": "Goravel",
  })
  return
}

// After
func (r *UserController) Show(ctx http.Context) http.Response {
  return ctx.Response().Success().Json(http.Json{
    "Hello": "Goravel",
  })
}
```

### 7. 修改 facades.Route() 中 Group 方法的入参

`route.Route` 修改为 `route.Router`：

```go
// Before
facades.Route().Group(func(route route.Route)

// After
facades.Route().Group(func(route route.Router)
```

### 8. 修改 facades.Cache() 中 Remember 与 RememberForever 方法（如果用到）

`callback` 类型由 `func() any` 修改为 `func() (any, error)`：

```go
// Before
Remember(key string, ttl time.Duration, callback func() any) (any, error)
RememberForever(key string, callback func() any) (any, error)

// After
Remember(key string, ttl time.Duration, callback func() (any, error)) (any, error)
RememberForever(key string, callback func() (any, error)) (any, error)
```

### 9. 修改 access.NewAllowResponse 与 access.NewDenyResponse 包名（如果用到）

由 `/contracts/auth/access` 修改为 `/auth/access`:

```go
// Before
import "github.com/goravel/framework/contracts/auth/access"

access.NewAllowResponse()
access.NewDenyResponse()

// After
import "github.com/goravel/framework/auth/access"

access.NewAllowResponse()
access.NewDenyResponse()
```

### 10. 移除废弃方法（如果用到）

1. 移除 `ctx.Request().Form()` 和 `ctx.Request().Json()` 方法，使用 `ctx.Request().Input()` 方法替代；

2. 移除 `Log` 自定义驱动的 `GetLevel`, `GetTime`, `GetMessage` 方法，使用 `Level`, `Time`, `Message` 方法替代；

3. 移除 `gorm.New` 方法，该方法用于直接获取 `gorm` 实例，已不推荐使用，如有必要，请使用 `gorm.NewGormImpl` 方法替代；

## 功能介绍

### 数据填充

Version: v1.13.1

[查看文档](../orm/seeding.md)

### 模型工厂

Version: v1.13.1

[查看文档](../orm/factories.md)

### 集成测试

Version: v1.13.1

[查看文档](../testing/getting-started.md)

### 视图

Version: v1.13.1

[查看文档](../the-basics/views.md)

### Go 默认版本升级为 1.20

Version: v1.13.1

go 1.18 和 1.19 已停止维护，框架相应升级到 1.20，[查看详情](https://endoflife.date/go)。如果想继续使用 1.18 和 1.19 版本，修改 `go.mod` 中的版本号即可，目前它们功能完全兼容。

### 任务调度支持横向伸缩

Version: v1.13.1

[查看文档](../digging-deeper/task-scheduling.md#任务只运行在一台服务器上)

### 新增 debug 方法

Version: v1.13.1

[查看文档](../digging-deeper/helpers.md#debug)

### make:controller 命令新增参数

Version: v1.13.1

`make:controller` 命令新增 `--resource` 参数，可以便捷的生成 CURD struct：

```
go run . artisan make:controller --resource UserController
```

### Response 新增 Status 方法

Version: v1.13.1

[查看文档](../the-basics/response.md#自定义-code)

### Orm 新增 Sum 和 Cursor 方法

Version: v1.13.1

[查看文档](../orm/getting-started.md#facades-orm-query-facades-orm-transaction-可用方法)

### Route 模块支持配置驱动

Version: v1.13.1

将 Route 模块原默认驱动 Gin 独立成包，通过配置的方式注入到 Goravel 中。本次优化后，为其他 HTTP 包注入到 Goravel 提供了便捷的通道，目前官方支持两个 HTTP 包：

| 驱动          | 地址           |
| -----------  | -------------- |
| Gin          | [https://github.com/goravel/gin](https://github.com/goravel/gin)     |
| Fiber        | [https://github.com/goravel/fiber](https://github.com/goravel/fiber)     |

### Request 新增 InputArray 和 InputMap 方法

Version: v1.13.1

[查看文档](../the-basics/request.md#检索一个输入值)

### Orm 模型支持自定义链接

Version: v1.13.1

[查看文档](../orm/getting-started.md#数据库连接)

### Filesystem 模块新增 Cloudinary 驱动

Version: v1.13.1

[查看文档](https://github.com/goravel/cloudinary)

### Log 新增链式方法

Version: v1.13.1

[查看文档](../the-basics/logging.md#链式方法)

### 修复 facades.Auth().User() 的问题

Version: v1.13.1

1. 修复使用 `facades.Auth().User(ctx, &user)` 方法时，如果 `user` 不存在不抛出错误的问题。

2. 修复当主键非 `int` 类型时，无法找到 `user` 的问题；

### 修复自定义 .env 路由某些情况下不生效的问题

Version: v1.13.1

### 修复 JWT 中设置 ttl == 0 时 token 立即过期的问题

Version: v1.13.1

预期当 `ttl == 0` 时，token 永不过期。 

### 修复 facades.Storage().Url() 在 windows 系统下路径错误的问题

Version: v1.13.2

[Issue #263](https://github.com/goravel/goravel/issues/263)

### 修复 Postgres 密码为空时连接异常的问题

Version: v1.13.2

[Issue #270](https://github.com/goravel/goravel/issues/270)

### 修复使用 Orm Cursor 方法时 With 方法无效的问题

Version: v1.13.2

[Issue #253](https://github.com/goravel/goravel/issues/253)

### 服务启动支持环境变量

Version: v1.13.4

[Issue #265](https://github.com/goravel/goravel/issues/265)

### 修复 validation 无法校验路由参数的问题

goravel/gin: v1.1.6

goravel/fiber: v1.1.11

[Issue #294](https://github.com/goravel/goravel/issues/294)

### 修复 Fiber 驱动无法返回文件的问题

goravel/fiber: v1.1.11

[Issue #299](https://github.com/goravel/goravel/issues/299)

### 修复 Fiber 驱动全局中间件 panic 的问题

goravel/fiber: v1.1.11

[Issue #300](https://github.com/goravel/goravel/issues/300)

### 修复 Fiber 驱动的 ContentType 设置与 Gin 驱动不同的问题

goravel/fiber: v1.1.11

[Issue #296](https://github.com/goravel/goravel/issues/296)

### 修复模型自定义链接不生效

goravel/framework: v1.13.5

[Issue #312](https://github.com/goravel/goravel/issues/312)

### 修复 Mock Log 报错

goravel/framework: v1.13.5

[Issue #320](https://github.com/goravel/goravel/issues/320)

### 修复队列任务链非线性执行的问题

goravel/framework: v1.13.6 v1.13.7

[Issue #341](https://github.com/goravel/goravel/issues/341)

### 修复使用不同 Guard 多次调用 facades.Auth().Parse() 数据被覆盖的问题

goravel/framework: v1.13.8

[Issue #388](https://github.com/goravel/goravel/issues/388)

### 修复使用 facades.Orm().WithContext() 设置 ctx 无法被正确传达到 event.Context() 的问题

goravel/framework: v1.13.8

[Issue #390](https://github.com/goravel/goravel/issues/390)

### 优化队列日志根据 APP_DEBUG 设置显示

goravel/framework: v1.13.8

`Debug` 和 `Info` 级别日志在 `APP_DEBUG=false` 时将不会被打印。

[Issue #389](https://github.com/goravel/goravel/issues/389)

### 修复 Log 换行错误的问题

goravel/framework: v1.13.9

[Issue #395](https://github.com/goravel/goravel/issues/395)

### 修复 vendor:publish 命令无法发布多层文件夹的问题

goravel/framework: v1.13.9

[Issue #345](https://github.com/goravel/goravel/issues/345)

### 修复 Log 中 traces 错误的问题

goravel/framework: v1.13.10

[Issue #402](https://github.com/goravel/goravel/issues/402)

### 修复 orm event 中 GetAttribute 方法返回数据错误的问题

goravel/framework: v1.13.10

[Issue #405](https://github.com/goravel/goravel/issues/405)

### ORM 新增 ToSql, ToRawSql 方法

goravel/framework: v1.13.10

[Issue #411](https://github.com/goravel/goravel/issues/411)
