# 从 v1.13 升级到 v1.14

### 令人兴奋的新功能 🎉

- [本地化](#本地化)
- [安装器](#安装器)
- [Cookie](#cookie)
- [Session](#session)

### 功能增强 🚀

- [gin 和 fiber 驱动支持设置 body_limit 和 header_limit](#gin-和-fiber-驱动支持设置-body-limit-和-header-limit)
- [Log 新增方法](#log-新增方法)
- [Orm 新增方法](#orm-新增方法)
- [Console 新增方法](#console-新增方法)
- [Response 新增方法](#response-新增方法)
- [新增 Build 命令](#新增-build-命令)
- [新增 helper 方法](#新增-helper-方法)
- [Redis 驱动支持设置 TLS](#redis-驱动支持设置-tls)

### 破坏性变化 🛠

- [Validation 如果验证失败将不绑定数据](#validation-如果验证失败将不绑定数据)
- [Testing 模块新增、修改方法](#testing-模块新增、修改方法)
- [优化 Mail 模块的 Queue 方法](#优化-mail-模块的-queue-方法)
- [优化 Auth 模块 ctx 的设置方法](#优化-auth-模块-ctx-的设置方法)
- [优化 mock facades 的方式](#优化-mock-facades-的方式)
- [框架 Orm model 新增 json tag](#框架-orm-model-新增-json-tag)

### Bug 修复 🐛

## 升级指南

Goravel v1.14 基于 Golang 1.21 进行开发与测试，与其他低 Golang 版本一般情况下可以兼容运行。请根据本节内容，一步步进行框架升级。

**预计升级时间：10 分钟**

### 1. 更新依赖

```
go get -u github.com/goravel/framework@v1.14.0

// 如果使用 gin
go get -u github.com/goravel/gin@v1.2.1

// 如果使用 fiber
go get -u github.com/goravel/fiber@v1.2.0

// 如果使用 redis
go get -u github.com/goravel/redis@v1.2.0

// 如果使用 s3
go get -u github.com/goravel/s3@v1.2.0

// 如果使用 oss
go get -u github.com/goravel/oss@v1.2.0

// 如果使用 cos
go get -u github.com/goravel/cos@v1.2.0

// 如果使用 minio
go get -u github.com/goravel/minio@v1.2.0

// 如果使用 cloudinay
go get -u github.com/goravel/cloudinary@v1.2.0

go mod tidy
```

### 2. 新增配置项

1. `config/app.go` 新增本地化模块配置项：

```go
"locale": "en",
"fallback_locale": "en",
"providers": []foundation.ServiceProvider{
  ...
  &session.ServiceProvider{},
  &translation.ServiceProvider{},
  ...
}
```

2. 如果需要使用 `session` 功能，新增 [config/session.go](https://github.com/goravel/goravel/blob/master/config/session.go) 文件；

### 3. 如果正在使用 Validation 模块

检查是否在校验数据失败的情况下依然尝试读取绑定值，如果有，需优化逻辑，因为该值升级后为空，详见：[Validation 如果验证失败将不绑定数据](#validation-如果验证失败将不绑定数据)

### 4. 如果正在使用 Testing 模块

检查是否使用 `Clear`, `Image` 方法，如果有，需相应修改：[Testing 模块新增、修改方法](#testing-模块新增、修改方法)

### 5. 如果正在使用 Mail 模块

检查是否使用 `Queue` 方法，如果有，需相应修改：[优化 Mail 模块的 Queue 方法](#优化-mail-模块的-queue-方法)

### 6. 如果正在使用 Auth 模块

需相应修改：[优化 Auth 模块 ctx 的设置方法](#优化-auth-模块-ctx-的设置方法)

### 7. 如果正在使用 mock facades

需相应修改：[优化 mock facades 的方式](#优化-mock-facades-的方式)

### 8. 如果正在使用框架 Orm model 并且直接通过接口返回数据

需相应修改：[框架 Orm model 新增 json tag](#框架-orm-model-新增-json-tag)

## 功能介绍

### 本地化

Version: v1.14.0

[查看文档](../digging-deeper/localization.md)

### 安装器

Version: v1.14.0

通过安装器，你可以很方便的下载并初始化一个新的 Goravel 项目。

[查看文档](http://github.com/goravel/installer)

### Cookie

Version: v1.14.0

[查看 Request 文档](../the-basics/request.md#cookie)

[查看 Response 文档](../the-basics/response.md#cookie)

### Session

Version: v1.14.0

[查看文档](../the-basics/session.md)

### gin 和 fiber 驱动支持设置 body_limit 和 header_limit

Version: v1.14.0

HTTP 驱动支持设置 `body_limit` 和 `header_limit` 以限制 `body`, `header` 大小，详见：[goravel/gin](https://github.com/goravel/gin/blob/c9d7706a6a04c05c8c33af5c97877a1ad2ea6362/README.md?plain=1#L54) 和 [goravel/fiber](https://github.com/goravel/fiber/blob/aa63ab657cd2b371fcda4df0090a41226f6c0704/README.md?plain=1#L56)。

### Log 新增方法

Version: v1.14.0

| 方法 | 说明 |
| --- | --- |
| `Stack` | 同时使用多个日志通道 |
| `Channel` | 指定日志通道 |
| `WithTrace` | 打印堆栈信息 |

[查看文档](../the-basics/logging.md#写入特定通道)

### Orm 新增方法

Version: v1.14.0

新增 `WhereIn`, `OrWhereIn`, `OrWhereNotIn`, `WhereNotIn`, `WhereBetween`, `WhereNotBetween`, `WhereNull`, `OrWhereNull`, `OrderByDesc`, `OrderBy`, `InRandomOrder`, `Exists` 方法。

### Console 新增方法

Version: v1.14.0

[查看文档](../digging-deeper/artisan-console.md#交互式输入)

### Response 新增方法

Version: v1.14.0

[查看文档](../the-basics/response.md#空响应)

### 新增 Build 命令

Version: v1.14.0

Goravel 项目可以直接通过 `go run . artisan build` 命令进行编译。

[查看文档](../getting-started/compile.md#编译命令)

### 新增 helper 方法

Version: v1.14.0

- [Str](../digging-deeper/strings.md)
- [Map](../digging-deeper/helpers.md#maps)
- [Color](../digging-deeper/color.md)
- [Convert](../digging-deeper/helpers.md#convert)
- [Collect](../digging-deeper/helpers.md#collect)

### Redis 驱动支持设置 TLS

Version: v1.14.0

[查看文档](https://github.com/goravel/redis)

### Validation 如果验证失败将不绑定数据

Version: v1.14.0

之前在调用下面方式时，如果验证失败 `userRequest` 依然绑定了值，升级后则不再绑定。

```go
var userRequest requests.UserRequest
errors, err := ctx.Request().ValidateRequest(&userRequest)

// or
validator, err := validation.Make(***)
err = validator.Bind(&userRequest)
```

### Testing 模块新增、修改方法

Version: v1.14.0

1. 新增 [Fresh](../testing/getting-started.md#重置数据库) 方法；
2. 修改 `Clear` 方法为 [Stop](../testing/getting-started.md#卸载镜像) 方法；
3. `Image` 方法新增 `ExposedPorts` 参数，删除 `Timeout` 参数；

```go
database, err := facades.Testing().Docker().Database()
database.Image(testingcontract.Image{
  Repository: "mysql",
  Tag:        "5.7",
  Env: []string{
    "MYSQL_ROOT_PASSWORD=123123",
    "MYSQL_DATABASE=goravel",
  },
  -- Timeout: 1000,
  ++ ExposedPorts: []string{"3306"},
})
```

### 优化 Mail 模块的 Queue 方法

Version: v1.14.0

`Queue` 方法的入参由 `queue *mail.Queue` 改为 `queue ...mail.Queue`。

```diff
-- facades.Mail().Queue(nil)
++ facades.Mail().Queue()

-- facades.Mail().Queue(&mail.Queue{})
++ facades.Mail().Queue(mail.Queue{})
```

### 优化 Auth 模块 ctx 的设置方法

Version: v1.14.0

之前调用 `Parse`, `User`, `Login`, `LoginUsingID`, `Refresh`, `Logout` 方法时，需要传递 `ctx`，升级后不再需要，而是可以直接设置在 `facades.Auth(ctx)`。

```diff
-- facades.Auth().Parse(ctx, token)
++ facades.Auth(ctx).Parse(token)

-- facades.Auth().User(ctx, &user)
++ facades.Auth(ctx).User(&user)

-- facades.Auth().Login(ctx, &user)
++ facades.Auth(ctx).Login(&user)

-- facades.Auth().LoginUsingID(ctx, id)
++ facades.Auth(ctx).LoginUsingID(id)

-- facades.Auth().Refresh(ctx)
++ facades.Auth(ctx).Refresh()

-- facades.Auth().Logout(ctx)
++ facades.Auth(ctx).Logout()
```

### 优化 mock facades 的方式

Version: v1.14.0

```diff
import github.com/goravel/framework/testing/mock

++ mockFactory := mock.Factory()

-- app := mock.App()
++ app := mockFactory.App()

-- artisan := mock.Artisan()
++ artisan := mockFactory.Artisan()

-- auth := mock.Auth()
++ auth := mockFactory.Auth()

-- artisan := mock.Artisan()
++ artisan := mockFactory.Artisan()

-- cache, driver, lock := mock.Cache()
++ cache := mockFactory.Cache()
++ driver := mockFactory.CacheDriver()
++ lock := mockFactory.CacheLock()

-- config := mock.Config()
++ config := mockFactory.Config()

-- crypt := mock.Crypt()
++ crypt := mockFactory.Crypt()

-- event, task := mock.Event()
++ event := mockFactory.Event()
++ event := mockFactory.EventTask()

-- gate := mock.Gate()
++ gate := mockFactory.Gate()

-- grpc := mock.Grpc()
++ grpc := mockFactory.Grpc()

-- hash := mock.Hash()
++ hash := mockFactory.Hash()

-- mock.Log()
++ mockFactory.Log()

-- mail := mock.Mail()
++ mail := mockFactory.Mail()

-- orm, query, transaction, association := mock.Orm()
++ orm := mockFactory.Orm()
++ query := mockFactory.OrmQuery()
++ transaction := mockFactory.OrmTransaction()
++ association := mockFactory.OrmAssociation()

-- queue, task := mock.Queue()
++ queue := mockFactory.Queue()
++ task := mockFactory.QueueTask()

-- rateLimiter := mock.RateLimiter()
++ rateLimiter := mockFactory.RateLimiter()

-- storage, driver, file := mock.Storage()
++ storage := mockFactory.Storage()
++ driver := mockFactory.StorageDriver()
++ file := mockFactory.StorageFile()

-- seeder := mock.Seeder()
++ seeder := mockFactory.Seeder()

-- validation, validator, errors := mock.Validation()
++ validation := mockFactory.Validation()
++ validator := mockFactory.ValidationValidator()
++ errors := mockFactory.ValidationErrors()

-- view := mock.View()
++ view := mockFactory.View()
```

### 框架 Orm model 新增 json tag

Version: v1.14.0

如果使用了框架的 Orm model 并且通过接口直接返回数据，需要自己根据原 model 结构新建 model 并替换，或者前端根据 json tag 修改字段名称。

```go
type Model struct {
	-- ID uint `gorm:"primaryKey"`
	++ ID uint `gorm:"primaryKey" json:"id"`
	Timestamps
}

type SoftDeletes struct {
	-- DeletedAt gorm.DeletedAt `gorm:"column:deleted_at"`
	++ DeletedAt gorm.DeletedAt `gorm:"column:deleted_at" json:"deleted_at"`
}

type Timestamps struct {
	-- CreatedAt carbon.DateTime `gorm:"autoCreateTime;column:created_at"`
	-- UpdatedAt carbon.DateTime `gorm:"autoUpdateTime;column:updated_at"`
	++ CreatedAt carbon.DateTime `gorm:"autoCreateTime;column:created_at" json:"created_at"`
	++ UpdatedAt carbon.DateTime `gorm:"autoUpdateTime;column:updated_at" json:"updated_at"`
}
```