# 从 v1.1 升级到 v1.2

[[toc]]

## 高影响变化

- [更新依赖](#更新依赖)
- [Auth 支持 Context](#auth-support-context)

## 升级指南

**预计升级时间：1 分钟**

### 更新依赖

**影响可能性：高**

`go.mod` 中更新依赖：

```go
github.com/goravel/framework v1.2.1
```

### Auth 支持 Context

**影响可能性：高**

```
// Old
facades.Auth.Parse(token string) error

// New
facades.Auth.Parse(ctx http.Context, token string) error
```

```
// Old
facades.Auth.User(ctx http.Context, user interface{}) error

// New
facades.Auth.User(ctx http.Context, user interface{}) error
```

```
// Old
facades.Auth.facades.Auth.Login(user interface{}) (token string, err error)

// New
facades.Auth.facades.Auth.Login(ctx http.Context, user interface{}) (token string, err error)
```

```
// Old
facades.Auth.LoginUsingID(id interface{}) (token string, err error)

// New
facades.Auth.LoginUsingID(ctx http.Context, id interface{}) (token string, err error)
```

```
// Old
facades.Auth.Refresh() (token string, err error)

// New
facades.Auth.Refresh(ctx http.Context) (token string, err error)
```

```
// Old
facades.Auth.Logout() error

// New
facades.Auth.Logout(ctx http.Context) error
```

For detail [facades.Auth](../security/authentication.md)。

<CommentService/>