# 从 v1.3 升级到 v1.4

[[toc]]

## 高影响变化

- [优化 Grpc 模块](#优化-grpc-模块)
- [优化路由注册](#优化路由注册)

## 低影响变化

- [http.Context 新增方法](#http-context-新增方法)
- [Request 新增方法](#request-新增方法)

## 升级指南

**预计升级时间：1 分钟**

### 更新依赖

**影响可能性：高**

`go.mod` 中更新依赖：

```go
github.com/goravel/framework v1.4.0
```

### 优化 Grpc 模块

**影响可能性：高**

1. 新增 [app/grpc/kernel.go](https://github.com/goravel/goravel/blob/v1.4.0/app/grpc/kernel.go) 文件；
2. 新增 [app/grpc/interceptors](https://github.com/goravel/goravel/tree/v1.4.0/app/grpc/interceptors) 目录；
3. 新增 [config/grpc.go](https://github.com/goravel/goravel/blob/v1.4.0/config/grpc.go) 文件；
4. 新增 [routes/grpc.go](https://github.com/goravel/goravel/blob/v1.4.0/routes/grpc.go) 文件；
3. [app/providers/grpc_service_provider.go](https://github.com/goravel/goravel/blob/v1.4.0/app/providers/grpc_service_provider.go) 新增注册拦截器逻辑；
4. [config/app.go](https://github.com/goravel/goravel/blob/v1.4.0/config/app.go) 文件删除 `grpc_host` 键值；

[查看文档](../the-basics/grpc.md)

### 优化路由注册

**影响可能性：高**

[app/providers/route_service_provider.go](https://github.com/goravel/goravel/blob/v1.4.0/app/providers/route_service_provider.go) 文件中，将 `routes.Web()` 由 `Register()` 移动到 `Boot()`。

### http.Context 新增方法

**影响可能性：低**

新增 `ctx.Context()` 方法。

[查看文档](../the-basics/request.md#获取-context)

### Request 新增方法

**影响可能性：低**

新增 `ctx.Request().AbortWithStatusJson` 方法。

[查看文档](../the-basics/request.md#中断请求)

<CommentService/>