# 从 v1.6 升级到 v1.7

[[toc]]

## 高影响变化

- [新增表单验证模块(v1.7.0)](#新增表单验证模块)
- [修复 request 模板 BUG(v1.7.1)](#修复-request-模板-bug)
- [修复表单验证模块 BUG(v1.7.2)](#修复表单验证模块-bug)
- [修复用户验证模块 BUG(v1.7.3)](#修复用户验证模块-bug)

## 低影响变化

- [优化队列模块 queue 名称(v1.7.2)](#优化队列模块-queue-名称)

## 升级指南

**预计升级时间：1 分钟**

### 更新依赖

**影响可能性：高**

`go.mod` 中更新依赖：

```go
github.com/goravel/framework v1.7.3
```

### 新增表单验证模块

**影响可能性：高**

版本：v1.7.0

1. 新增 [app/providers/validation_service_provider.go](https://github.com/goravel/goravel/blob/v1.7.0/app/providers/validation_service_provider.go) 文件；
2. [config/app.go](https://github.com/goravel/goravel/blob/v1.7.0/config/app.go) 文件 `providers` 新增 `&validation.ServiceProvider{},`, `&providers.ValidationServiceProvider{},`；

[查看文档](../the-basics/validation.md)

### 修复 request 模板 BUG

**影响可能性：高**

版本：v1.7.1

1. 修复使用命令 `go run . artisan make:request Test` 创建 request 模板，import 路径错误的 BUG；

### 修复表单验证模块 BUG

**影响可能性：高**

版本：v1.7.2

1. 修复 `facades.Validation` 模块注册多个自定义 Rule 时不生效的 BUG；

### 优化队列模块 queue 名称

**影响可能性：低**

版本：v1.7.2

1. 为 `facades.Queue` 模块的 queue 名称在实际执行时增加前缀，以便多项目时进行区分，前缀规则为：${app_name}_queues:${queue}；
2. 隐式优化，您无需修改任何代码；

### 修复用户验证模块 BUG

**影响可能性：高**

版本：v1.7.3

1. 修复当用户表主键为 `string` 类型时，调用 `facades.Auth.User` 方法提示错误 `Unknown column` 错误的 BUG；

<CommentService/>