# 从 v1.7 升级到 v1.8

[[toc]]

## 令人兴奋的新功能 🎉

- [Orm 新增模型关联(1.8.0)](#orm-新增模型关联)

## 功能增强 🚀

- [Request 新增方法(1.8.0)](#request-新增方法)
- [Response 新增方法(1.8.0)](#response-新增方法)
- [优化数据库迁移(1.8.0)](#优化数据库迁移)
- [Route 支持 HTTPS(1.8.3)](#route-支持-https)

## 破坏性变化 🛠

- [优化 import 顺序(1.8.0)](#优化-import-顺序)
- [mock.Validator 改名(1.8.0)](#mock-validator-改名)
- [support.Mysql 改名(1.8.0)](#support-mysql-改名)
- [即将废弃 database.NewGormInstance(1.8.0)](#即将废弃-database-newgorminstance)

## Bug 修复 🐛

- [修复 Orm 并发安全的问题(1.8.1)](#修复-orm-并发安全的问题)
- [修复 Mail 不能使用 25，465 端口发送邮件的问题(1.8.2)](#修复-mail-不能使用-25-465-端口发送邮件的问题)

## 升级指南

**预计升级时间：1 分钟**

### 更新依赖

`go.mod` 中更新依赖：

```
go get -u github.com/goravel/framework@v1.8.3
```

### Orm 新增模型关联

Version: v1.8.0

Orm 新增方法，以处理模型关联等操作：

| 方法名        | 作用                              |
| -----------  | --------------------------------- |
| Association  | [关联操作](../orm/relationships.md#querying-associations) |
| DB           | [获取通用数据库接口](../orm/getting-started.md#generic-database-interface-sqldb) |
| Load         | [延迟预加载](../orm/relationships.md#lazy-eager-loading) |
| LoadMissing  | [延迟预加载(不存在)](../orm/relationships.md#lazy-eager-loading)           |
| Omit         | [忽略关联](../orm/relationships.md#create-or-update-associations)     |
| With         | [预加载](../orm/relationships.md#Eager-Loading)     |

### Request 新增方法

Version: v1.8.0

`ctx.Request()` 新增方法，以丰富 `Query` 传参的格式：

| 方法名        | 作用                              |
| -----------  | --------------------------------- |
| `QueryArray` | [获取链接传入的数组参数](../the-basics/request.md#获取链接传入的参数) |
| `QueryMap`   | [获取链接传入的 Map 参数](../the-basics/request.md#获取链接传入的参数) |

### Response 新增方法

Version: v1.8.0

`ctx.Response()` 新增 `Origin` 方法，可以在 HTTP 中间件中获取 `Response` 的所有信息。

[查看文档](../the-basics/response.md#获取响应)

### 优化 import 顺序

Version: v1.8.0

`bootstrap/app.go` 文件中 import 顺序修改为：

```go
package bootstrap

import (
  "github.com/goravel/framework/foundation"

  "goravel/config"
)
```

[查看文件](https://github.com/goravel/goravel/blob/v1.8.0/bootstrap/app.go)

### 优化数据库迁移

Version: v1.8.0

运行生成数据库迁移文件命令 `go run . artisan make:migration create_users_table`，将根据当前使用的默认数据库驱动 `facades.Config.GetString("database.default")` 生成对应的迁移文件。

### mock.Validator 改名

Version: v1.8.0

如果您使用了 `mock.Validator` 来编写单元测试，需要进行下面修改：

```
import "github.com/goravel/framework/testing/mock"

mock.Validator

// 修改为

import "github.com/goravel/framework/testing/mock"

mock.Validation
```

[查看文档](../testing/mock.md#Mock-facades.Validation)

### support.Mysql 改名

Version: v1.8.0

如果您使用了 `support.Mysql` 等框架常量来进行数据库驱动的判断，需要进行如下修改：

```go
import "github.com/goravel/framework/database/support"

support.Mysql
support.Postgresql
support.Sqlite
support.Sqlserver

// 修改为

import "github.com/goravel/framework/contracts/database/orm"

orm.Mysql
orm.Postgresql
orm.Sqlite
orm.Sqlserver
```

`orm.Mysql` 等新的常量为 `orm.Driver` 类型，可以使用 `orm.Mysql.String()` 方法转换为字符类型。

### 即将废弃 database.NewGormInstance

Version: v1.8.0

`database.NewGormInstance` 方法将在 v1.9.0 被废弃，当前版本尚可使用，如果您使用了该方法获取 `gorm` 实例，需要进行如下修改：

```go
import "github.com/goravel/framework/database"

gorm, err := database.NewGormInstance(connection)

// 修改为

import "github.com/goravel/framework/database/gorm"

gorm, err := gorm.New(connection)
```

### 修复 Orm 并发安全的问题

Version: v1.8.1

修复当高并发访问时，第一次读取 `facades.Orm` 有可能返回 Nil。

### 修复 Mail 不能使用 25，465 端口发送邮件的问题

Version: v1.8.2

您现在可以使用 25，465，587 发送邮件了。

### Route 支持 HTTPS

Version: v1.8.3

`facades.Route` 新增 `RunTLS` 方法，支持启动 HTTPS 服务器，详见[文档](../the-basics/routing.md#启动-https-服务器)。

<CommentService/>