# 从 v1.8 升级到 v1.9

[[toc]]

## 功能增强 🚀

- [新增数据库读写分离(1.9.0)](#新增数据库读写分离)
- [新增数据库连接池配置(1.9.0)](#新增数据库连接池配置)
- [自定义 .env 路径(1.9.0)](#自定义-.env-路径)
- [Cache 新增 Memory 驱动(1.9.0)](#cache-新增-memory-驱动)
- [Orm 新增分页方法(1.9.0)](#orm-新增分页方法)
- [新增 make 命令(1.9.0)](#新增-make-命令)
- [Response 新增方法(1.9.0)](#response-新增方法)

## 破坏性变化 🛠

- [Request PrepareForValidation 方法新增 error 返回(1.9.0)](#Request-PrepareForValidation-方法新增-error-返回)

## Bug 修复 🐛

- [File 获取错误的文件类型(1.9.0)](#File-获取错误的文件类型)
- [修复 make:event 和 make:listener 命令生成模板有误的问题(1.9.0)](#修复-make:event-和-make:listener-命令生成模板有误的问题)
- [修复保存文件时有些类型无法获取后缀的问题(1.9.1)](#修复保存文件时有些类型无法获取后缀的问题)

## 升级依赖 ⬆️

- build(deps): bump github.com/gin-gonic/gin from v1.7.3 to v1.8.2

## 升级指南

**预计升级时间：10 分钟**

### 更新依赖

`go.mod` 中更新依赖：

```
go get -u github.com/goravel/framework@v1.9.0
```

### 新增数据库读写分离

Version: v1.9.0

数据库支持读写分离配置，[详见文档](../orm/getting-started.md#读写分离)。

### 新增数据库连接池配置

Version: v1.9.0

数据库配置文件 `config/database.go` 新增连接池配置 `pool`，[详见文件](https://github.com/goravel/goravel/blob/v1.9.x/config/database.go)。

### 自定义 .env 路径

Version: v1.9.0

```
// 编译前
go run . --env=../.env

//编译后
./main --env=../.env
```

### Cache 新增 Memory 驱动

Version: v1.9.0

`config/cache.go` 新增 `memory` 配置：

```
"stores": map[string]any{
  // 新增
  "memory": map[string]any{
    "driver": "memory",
  },
},
```

[详见文件](https://github.com/goravel/goravel/blob/v1.9.x/config/cache.go)

### Orm 新增分页方法

Version: v1.9.0

`facades.Orm` 新增 `Paginate` 方法，[详见文档](../orm/getting-started.md#分页)。

### 新增 make 命令

Version: v1.9.0

```
// 创建控制器
go run . artisan make:controller UserController

// 创建 HTTP 中间件
go run . artisan make:middleware Cors

// 创建模型
go run . artisan make:model User
```

### Response 新增方法

Version: v1.9.0

| 方法名        | 作用           |
| -----------  | -------------- |
| Data         | [自定义返回](../the-basics/response.md#自定义返回)     |
| Redirect     | [重定向](../the-basics/response.md#重定向) |

### Request PrepareForValidation 方法新增 error 返回

Version: v1.9.0

如果您使用到了 [表单验证中的 PrepareForValidation 方法](../the-basics/validation.md#验证前格式化数据)，请新增返回值：`PrepareForValidation(data validation.Data) error`。

### File 获取错误的文件类型

Version: v1.9.0

修复 `.docx`, `.xlsx` 等类型错误的识别为 `.zip` 的问题。

### 修复 make:event 和 make:listener 命令生成模板有误的问题

Version: v1.9.0

`import "github.com/goravel/framework/contracts/events"` 改为 `import "github.com/goravel/framework/contracts/event"`

### 修复保存文件时有些类型无法获取后缀的问题

Version: v1.9.1

下面代码有些类型无法获取后缀:

```go
file, err := ctx.Request().File()   
file.Store("upload")
```

<CommentService/>