// Copyright 2019 The gVisor Authors.
//
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file or at
// https://developers.google.com/open-source/licenses/bsd.

package atomicptr

import (
	"testing"
)

func newInt(val int) *int {
	return &val
}

func TestAtomicPtr(t *testing.T) {
	var p AtomicPtrInt
	if got := p.Load(); got != nil {
		t.Errorf("initial value is %p (%v), wanted nil", got, got)
	}
	want := newInt(42)
	p.Store(want)
	if got := p.Load(); got != want {
		t.Errorf("wrong value: got %p (%v), wanted %p (%v)", got, got, want, want)
	}
	want = newInt(100)
	p.Store(want)
	if got := p.Load(); got != want {
		t.Errorf("wrong value: got %p (%v), wanted %p (%v)", got, got, want, want)
	}
}
