// Copyright 2023 The gVisor Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package metricserver

import (
	"gvisor.dev/gvisor/pkg/prometheus"
)

// Metrics generated by the metrics server itself.
var (
	SandboxPresenceMetric = prometheus.Metric{
		Name: "sandbox_presence",
		Type: prometheus.TypeGauge,
		Help: "Boolean metric set to 1 for each known sandbox.",
	}
	SandboxRunningMetric = prometheus.Metric{
		Name: "sandbox_running",
		Type: prometheus.TypeGauge,
		Help: "Boolean metric set to 1 for each running sandbox.",
	}
	SandboxCheckpointedMetric = prometheus.Metric{
		Name: "sandbox_checkpointed",
		Type: prometheus.TypeGauge,
		Help: "Boolean metric set to 1 for each checkpointed sandbox.",
	}
	SandboxRestoredMetric = prometheus.Metric{
		Name: "sandbox_restored",
		Type: prometheus.TypeGauge,
		Help: "Boolean metric set to 1 for each restored sandbox.",
	}
	SandboxMetadataMetric = prometheus.Metric{
		Name: "sandbox_metadata",
		Type: prometheus.TypeGauge,
		Help: "Key-value pairs about per-sandbox metadata.",
	}
	SandboxCapabilitiesMetric = prometheus.Metric{
		Name: "sandbox_capabilities",
		Type: prometheus.TypeGauge,
		Help: "Linux capabilities added within containers of the sandbox.",
	}
	SandboxCapabilitiesMetricLabel = "capability"
	SpecMetadataMetric             = prometheus.Metric{
		Name: "spec_metadata",
		Type: prometheus.TypeGauge,
		Help: "Key-value pairs about OCI spec metadata.",
	}
	SandboxCreationMetric = prometheus.Metric{
		Name: "sandbox_creation_time_seconds",
		Type: prometheus.TypeGauge,
		Help: "When the sandbox was created, as a unix timestamp in seconds.",
	}
	NumRunningSandboxesMetric = prometheus.Metric{
		Name: "num_sandboxes_running",
		Type: prometheus.TypeGauge,
		Help: "Number of sandboxes running at present.",
	}
	NumCannotExportSandboxesMetric = prometheus.Metric{
		Name: "num_sandboxes_broken_metrics",
		Type: prometheus.TypeGauge,
		Help: "Number of sandboxes from which we cannot export metrics.",
	}
	NumTotalSandboxesMetric = prometheus.Metric{
		Name: "num_sandboxes_total",
		Type: prometheus.TypeCounter,
		Help: "Counter of sandboxes that have ever been started.",
	}
	NumCheckpointedSandboxesMetric = prometheus.Metric{
		Name: "num_sandboxes_checkpointed",
		Type: prometheus.TypeCounter,
		Help: "Counter of sandboxes that have been checkpointed.",
	}
	NumRestoredSandboxesMetric = prometheus.Metric{
		Name: "num_sandboxes_restored",
		Type: prometheus.TypeCounter,
		Help: "Counter of sandboxes that have been restored.",
	}
)

// Metrics is a list of metrics that the metric server generates.
var Metrics = []*prometheus.Metric{
	&SandboxPresenceMetric,
	&SandboxRunningMetric,
	&SandboxMetadataMetric,
	&SandboxCheckpointedMetric,
	&SandboxRestoredMetric,
	&SandboxCapabilitiesMetric,
	&SpecMetadataMetric,
	&SandboxCreationMetric,
	&NumRunningSandboxesMetric,
	&NumCannotExportSandboxesMetric,
	&NumTotalSandboxesMetric,
	&NumCheckpointedSandboxesMetric,
	&NumRestoredSandboxesMetric,
	&prometheus.ProcessStartTimeSeconds,
}
