// Copyright 2019 The gVisor Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef GVISOR_TEST_UTIL_TIME_UTIL_H_
#define GVISOR_TEST_UTIL_TIME_UTIL_H_

#include "absl/time/time.h"

namespace gvisor {
namespace testing {

// Sleep for at least the specified duration. Avoids glibc.
void SleepSafe(absl::Duration duration);

}  // namespace testing
}  // namespace gvisor

#endif  // GVISOR_TEST_UTIL_TIME_UTIL_H_
