// Copyright 2025 The gVisor Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package main

import (
	"context"
	"fmt"
	"os"
	"os/exec"
)

// addPathToLd adds the given path to the ld cache.
func addPathToLd(ctx context.Context, path string) error {
	const myLdConfigPath = "/etc/ld.so.conf.d/gvisor.conf"
	if err := os.WriteFile(myLdConfigPath, []byte(fmt.Sprintf("# Generated by gVisor ioctl sniffer\n%s", path)), 0644); err != nil {
		return fmt.Errorf("failed to write to ld config file %q: %w", myLdConfigPath, err)
	}
	if err := os.Remove("/etc/ld.so.cache"); err != nil && !os.IsNotExist(err) {
		return fmt.Errorf("failed to remove ld cache file: %w", err)
	}
	output, err := exec.CommandContext(ctx, "ldconfig").CombinedOutput()
	if err != nil {
		return fmt.Errorf("failed to run ldconfig: %w; output: %s", err, string(output))
	}
	return nil
}
