/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */

// Code generated by the Google Gen AI SDK generator DO NOT EDIT.

import * as common from '../_common.js';
import * as t from '../_transformers.js';
import type * as types from '../types.js';

export function createFileParametersToMldev(
  fromObject: types.CreateFileParameters,
): Record<string, unknown> {
  const toObject: Record<string, unknown> = {};

  const fromFile = common.getValueByPath(fromObject, ['file']);
  if (fromFile != null) {
    common.setValueByPath(toObject, ['file'], fromFile);
  }

  return toObject;
}

export function createFileResponseFromMldev(
  fromObject: types.CreateFileResponse,
): Record<string, unknown> {
  const toObject: Record<string, unknown> = {};

  const fromSdkHttpResponse = common.getValueByPath(fromObject, [
    'sdkHttpResponse',
  ]);
  if (fromSdkHttpResponse != null) {
    common.setValueByPath(toObject, ['sdkHttpResponse'], fromSdkHttpResponse);
  }

  return toObject;
}

export function deleteFileParametersToMldev(
  fromObject: types.DeleteFileParameters,
): Record<string, unknown> {
  const toObject: Record<string, unknown> = {};

  const fromName = common.getValueByPath(fromObject, ['name']);
  if (fromName != null) {
    common.setValueByPath(toObject, ['_url', 'file'], t.tFileName(fromName));
  }

  return toObject;
}

export function deleteFileResponseFromMldev(
  fromObject: types.DeleteFileResponse,
): Record<string, unknown> {
  const toObject: Record<string, unknown> = {};

  const fromSdkHttpResponse = common.getValueByPath(fromObject, [
    'sdkHttpResponse',
  ]);
  if (fromSdkHttpResponse != null) {
    common.setValueByPath(toObject, ['sdkHttpResponse'], fromSdkHttpResponse);
  }

  return toObject;
}

export function getFileParametersToMldev(
  fromObject: types.GetFileParameters,
): Record<string, unknown> {
  const toObject: Record<string, unknown> = {};

  const fromName = common.getValueByPath(fromObject, ['name']);
  if (fromName != null) {
    common.setValueByPath(toObject, ['_url', 'file'], t.tFileName(fromName));
  }

  return toObject;
}

export function listFilesConfigToMldev(
  fromObject: types.ListFilesConfig,
  parentObject: Record<string, unknown>,
): Record<string, unknown> {
  const toObject: Record<string, unknown> = {};

  const fromPageSize = common.getValueByPath(fromObject, ['pageSize']);
  if (parentObject !== undefined && fromPageSize != null) {
    common.setValueByPath(parentObject, ['_query', 'pageSize'], fromPageSize);
  }

  const fromPageToken = common.getValueByPath(fromObject, ['pageToken']);
  if (parentObject !== undefined && fromPageToken != null) {
    common.setValueByPath(parentObject, ['_query', 'pageToken'], fromPageToken);
  }

  return toObject;
}

export function listFilesParametersToMldev(
  fromObject: types.ListFilesParameters,
): Record<string, unknown> {
  const toObject: Record<string, unknown> = {};

  const fromConfig = common.getValueByPath(fromObject, ['config']);
  if (fromConfig != null) {
    listFilesConfigToMldev(fromConfig, toObject);
  }

  return toObject;
}

export function listFilesResponseFromMldev(
  fromObject: types.ListFilesResponse,
): Record<string, unknown> {
  const toObject: Record<string, unknown> = {};

  const fromSdkHttpResponse = common.getValueByPath(fromObject, [
    'sdkHttpResponse',
  ]);
  if (fromSdkHttpResponse != null) {
    common.setValueByPath(toObject, ['sdkHttpResponse'], fromSdkHttpResponse);
  }

  const fromNextPageToken = common.getValueByPath(fromObject, [
    'nextPageToken',
  ]);
  if (fromNextPageToken != null) {
    common.setValueByPath(toObject, ['nextPageToken'], fromNextPageToken);
  }

  const fromFiles = common.getValueByPath(fromObject, ['files']);
  if (fromFiles != null) {
    let transformedList = fromFiles;
    if (Array.isArray(transformedList)) {
      transformedList = transformedList.map((item) => {
        return item;
      });
    }
    common.setValueByPath(toObject, ['files'], transformedList);
  }

  return toObject;
}
