// This file defines protos that store the results of autotuning various
// operations.
//
// They are in proto format because we want to log them structured. They offer
// tremendous statistical, testing, and debugging value.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.4
// 	protoc        v3.21.12
// source: xla/autotuning.proto

package autotuning

import (
	dnn "github.com/gomlx/gopjrt/internal/protos/dnn"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type AutotuneResult_FailureKind int32

const (
	AutotuneResult_UNKNOWN AutotuneResult_FailureKind = 0
	// Algorithm wrote memory outside its output buffers.
	AutotuneResult_REDZONE_MODIFIED AutotuneResult_FailureKind = 1
	// Algorithm gave a different result from a reference algorithm.
	AutotuneResult_WRONG_RESULT AutotuneResult_FailureKind = 2
	// Algorithm was rejected for failing to run or for known bugs.
	AutotuneResult_DISQUALIFIED AutotuneResult_FailureKind = 3
)

// Enum value maps for AutotuneResult_FailureKind.
var (
	AutotuneResult_FailureKind_name = map[int32]string{
		0: "UNKNOWN",
		1: "REDZONE_MODIFIED",
		2: "WRONG_RESULT",
		3: "DISQUALIFIED",
	}
	AutotuneResult_FailureKind_value = map[string]int32{
		"UNKNOWN":          0,
		"REDZONE_MODIFIED": 1,
		"WRONG_RESULT":     2,
		"DISQUALIFIED":     3,
	}
)

func (x AutotuneResult_FailureKind) Enum() *AutotuneResult_FailureKind {
	p := new(AutotuneResult_FailureKind)
	*p = x
	return p
}

func (x AutotuneResult_FailureKind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutotuneResult_FailureKind) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_autotuning_proto_enumTypes[0].Descriptor()
}

func (AutotuneResult_FailureKind) Type() protoreflect.EnumType {
	return &file_xla_autotuning_proto_enumTypes[0]
}

func (x AutotuneResult_FailureKind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutotuneResult_FailureKind.Descriptor instead.
func (AutotuneResult_FailureKind) EnumDescriptor() ([]byte, []int) {
	return file_xla_autotuning_proto_rawDescGZIP(), []int{2, 0}
}

type CudnnVersion struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Major         int32                  `protobuf:"varint,1,opt,name=major,proto3" json:"major,omitempty"`
	Minor         int32                  `protobuf:"varint,2,opt,name=minor,proto3" json:"minor,omitempty"`
	Patch         int32                  `protobuf:"varint,3,opt,name=patch,proto3" json:"patch,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CudnnVersion) Reset() {
	*x = CudnnVersion{}
	mi := &file_xla_autotuning_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CudnnVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CudnnVersion) ProtoMessage() {}

func (x *CudnnVersion) ProtoReflect() protoreflect.Message {
	mi := &file_xla_autotuning_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CudnnVersion.ProtoReflect.Descriptor instead.
func (*CudnnVersion) Descriptor() ([]byte, []int) {
	return file_xla_autotuning_proto_rawDescGZIP(), []int{0}
}

func (x *CudnnVersion) GetMajor() int32 {
	if x != nil {
		return x.Major
	}
	return 0
}

func (x *CudnnVersion) GetMinor() int32 {
	if x != nil {
		return x.Minor
	}
	return 0
}

func (x *CudnnVersion) GetPatch() int32 {
	if x != nil {
		return x.Patch
	}
	return 0
}

type ComputeCapability struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Major         int32                  `protobuf:"varint,1,opt,name=major,proto3" json:"major,omitempty"`
	Minor         int32                  `protobuf:"varint,2,opt,name=minor,proto3" json:"minor,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ComputeCapability) Reset() {
	*x = ComputeCapability{}
	mi := &file_xla_autotuning_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ComputeCapability) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeCapability) ProtoMessage() {}

func (x *ComputeCapability) ProtoReflect() protoreflect.Message {
	mi := &file_xla_autotuning_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeCapability.ProtoReflect.Descriptor instead.
func (*ComputeCapability) Descriptor() ([]byte, []int) {
	return file_xla_autotuning_proto_rawDescGZIP(), []int{1}
}

func (x *ComputeCapability) GetMajor() int32 {
	if x != nil {
		return x.Major
	}
	return 0
}

func (x *ComputeCapability) GetMinor() int32 {
	if x != nil {
		return x.Minor
	}
	return 0
}

type AutotuneResult struct {
	state        protoimpl.MessageState        `protogen:"open.v1"`
	ScratchBytes int64                         `protobuf:"varint,8,opt,name=scratch_bytes,json=scratchBytes,proto3" json:"scratch_bytes,omitempty"`
	RunTime      *durationpb.Duration          `protobuf:"bytes,9,opt,name=run_time,json=runTime,proto3" json:"run_time,omitempty"`
	Failure      *AutotuneResult_FailureResult `protobuf:"bytes,7,opt,name=failure,proto3" json:"failure,omitempty"`
	// Types that are valid to be assigned to Key:
	//
	//	*AutotuneResult_Conv
	//	*AutotuneResult_Gemm
	//	*AutotuneResult_Triton
	//	*AutotuneResult_CudaConvPlan
	//	*AutotuneResult_CustomKernelFusion
	//	*AutotuneResult_Algorithm
	//	*AutotuneResult_Other
	Key           isAutotuneResult_Key `protobuf_oneof:"key"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AutotuneResult) Reset() {
	*x = AutotuneResult{}
	mi := &file_xla_autotuning_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutotuneResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutotuneResult) ProtoMessage() {}

func (x *AutotuneResult) ProtoReflect() protoreflect.Message {
	mi := &file_xla_autotuning_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutotuneResult.ProtoReflect.Descriptor instead.
func (*AutotuneResult) Descriptor() ([]byte, []int) {
	return file_xla_autotuning_proto_rawDescGZIP(), []int{2}
}

func (x *AutotuneResult) GetScratchBytes() int64 {
	if x != nil {
		return x.ScratchBytes
	}
	return 0
}

func (x *AutotuneResult) GetRunTime() *durationpb.Duration {
	if x != nil {
		return x.RunTime
	}
	return nil
}

func (x *AutotuneResult) GetFailure() *AutotuneResult_FailureResult {
	if x != nil {
		return x.Failure
	}
	return nil
}

func (x *AutotuneResult) GetKey() isAutotuneResult_Key {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *AutotuneResult) GetConv() *AutotuneResult_ConvKey {
	if x != nil {
		if x, ok := x.Key.(*AutotuneResult_Conv); ok {
			return x.Conv
		}
	}
	return nil
}

func (x *AutotuneResult) GetGemm() *AutotuneResult_GemmKey {
	if x != nil {
		if x, ok := x.Key.(*AutotuneResult_Gemm); ok {
			return x.Gemm
		}
	}
	return nil
}

func (x *AutotuneResult) GetTriton() *AutotuneResult_TritonGemmKey {
	if x != nil {
		if x, ok := x.Key.(*AutotuneResult_Triton); ok {
			return x.Triton
		}
	}
	return nil
}

func (x *AutotuneResult) GetCudaConvPlan() *AutotuneResult_CudaConvPlanKey {
	if x != nil {
		if x, ok := x.Key.(*AutotuneResult_CudaConvPlan); ok {
			return x.CudaConvPlan
		}
	}
	return nil
}

func (x *AutotuneResult) GetCustomKernelFusion() *AutotuneResult_CustomKernelFusionKey {
	if x != nil {
		if x, ok := x.Key.(*AutotuneResult_CustomKernelFusion); ok {
			return x.CustomKernelFusion
		}
	}
	return nil
}

func (x *AutotuneResult) GetAlgorithm() *dnn.AlgorithmProto {
	if x != nil {
		if x, ok := x.Key.(*AutotuneResult_Algorithm); ok {
			return x.Algorithm
		}
	}
	return nil
}

func (x *AutotuneResult) GetOther() *AutotuneResult_BackendConfigKey {
	if x != nil {
		if x, ok := x.Key.(*AutotuneResult_Other); ok {
			return x.Other
		}
	}
	return nil
}

type isAutotuneResult_Key interface {
	isAutotuneResult_Key()
}

type AutotuneResult_Conv struct {
	Conv *AutotuneResult_ConvKey `protobuf:"bytes,5,opt,name=conv,proto3,oneof"`
}

type AutotuneResult_Gemm struct {
	Gemm *AutotuneResult_GemmKey `protobuf:"bytes,6,opt,name=gemm,proto3,oneof"`
}

type AutotuneResult_Triton struct {
	Triton *AutotuneResult_TritonGemmKey `protobuf:"bytes,17,opt,name=triton,proto3,oneof"`
}

type AutotuneResult_CudaConvPlan struct {
	CudaConvPlan *AutotuneResult_CudaConvPlanKey `protobuf:"bytes,15,opt,name=cuda_conv_plan,json=cudaConvPlan,proto3,oneof"`
}

type AutotuneResult_CustomKernelFusion struct {
	CustomKernelFusion *AutotuneResult_CustomKernelFusionKey `protobuf:"bytes,18,opt,name=custom_kernel_fusion,json=customKernelFusion,proto3,oneof"`
}

type AutotuneResult_Algorithm struct {
	Algorithm *dnn.AlgorithmProto `protobuf:"bytes,16,opt,name=algorithm,proto3,oneof"`
}

type AutotuneResult_Other struct {
	Other *AutotuneResult_BackendConfigKey `protobuf:"bytes,19,opt,name=other,proto3,oneof"`
}

func (*AutotuneResult_Conv) isAutotuneResult_Key() {}

func (*AutotuneResult_Gemm) isAutotuneResult_Key() {}

func (*AutotuneResult_Triton) isAutotuneResult_Key() {}

func (*AutotuneResult_CudaConvPlan) isAutotuneResult_Key() {}

func (*AutotuneResult_CustomKernelFusion) isAutotuneResult_Key() {}

func (*AutotuneResult_Algorithm) isAutotuneResult_Key() {}

func (*AutotuneResult_Other) isAutotuneResult_Key() {}

type AutotuningLog struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Instr *anypb.Any             `protobuf:"bytes,1,opt,name=instr,proto3" json:"instr,omitempty"`
	// Records all auto-tuning results per algorithm.
	Results           []*AutotuneResult  `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	CudnnVersion      *CudnnVersion      `protobuf:"bytes,3,opt,name=cudnn_version,json=cudnnVersion,proto3" json:"cudnn_version,omitempty"`
	ComputeCapability *ComputeCapability `protobuf:"bytes,4,opt,name=compute_capability,json=computeCapability,proto3" json:"compute_capability,omitempty"`
	// stream_executor::DeviceDescription::pci_bus_id.
	DevicePciBusId string `protobuf:"bytes,5,opt,name=device_pci_bus_id,json=devicePciBusId,proto3" json:"device_pci_bus_id,omitempty"`
	BlasVersion    string `protobuf:"bytes,6,opt,name=blas_version,json=blasVersion,proto3" json:"blas_version,omitempty"`
	FusionName     string `protobuf:"bytes,7,opt,name=fusion_name,json=fusionName,proto3" json:"fusion_name,omitempty"`
	FusionCount    int64  `protobuf:"varint,8,opt,name=fusion_count,json=fusionCount,proto3" json:"fusion_count,omitempty"`
	// String representation of the selected backend. For fusions that will be
	// the GPU backend config type. For custom calls it is a target name of the
	// custom call.
	SelectedBackend string `protobuf:"bytes,9,opt,name=selected_backend,json=selectedBackend,proto3" json:"selected_backend,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *AutotuningLog) Reset() {
	*x = AutotuningLog{}
	mi := &file_xla_autotuning_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutotuningLog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutotuningLog) ProtoMessage() {}

func (x *AutotuningLog) ProtoReflect() protoreflect.Message {
	mi := &file_xla_autotuning_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutotuningLog.ProtoReflect.Descriptor instead.
func (*AutotuningLog) Descriptor() ([]byte, []int) {
	return file_xla_autotuning_proto_rawDescGZIP(), []int{3}
}

func (x *AutotuningLog) GetInstr() *anypb.Any {
	if x != nil {
		return x.Instr
	}
	return nil
}

func (x *AutotuningLog) GetResults() []*AutotuneResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *AutotuningLog) GetCudnnVersion() *CudnnVersion {
	if x != nil {
		return x.CudnnVersion
	}
	return nil
}

func (x *AutotuningLog) GetComputeCapability() *ComputeCapability {
	if x != nil {
		return x.ComputeCapability
	}
	return nil
}

func (x *AutotuningLog) GetDevicePciBusId() string {
	if x != nil {
		return x.DevicePciBusId
	}
	return ""
}

func (x *AutotuningLog) GetBlasVersion() string {
	if x != nil {
		return x.BlasVersion
	}
	return ""
}

func (x *AutotuningLog) GetFusionName() string {
	if x != nil {
		return x.FusionName
	}
	return ""
}

func (x *AutotuningLog) GetFusionCount() int64 {
	if x != nil {
		return x.FusionCount
	}
	return 0
}

func (x *AutotuningLog) GetSelectedBackend() string {
	if x != nil {
		return x.SelectedBackend
	}
	return ""
}

type AutotuneResult_FailureResult struct {
	state protoimpl.MessageState     `protogen:"open.v1"`
	Kind  AutotuneResult_FailureKind `protobuf:"varint,1,opt,name=kind,proto3,enum=xla.AutotuneResult_FailureKind" json:"kind,omitempty"`
	Msg   string                     `protobuf:"bytes,2,opt,name=msg,proto3" json:"msg,omitempty"`
	// For failure_kind == WRONG_RESULT, this field indicates the reference
	// configuration that we compared against.
	//
	// Note that the reference algorithm isn't always correct.  However,
	// empirically it's more correct, as it's "algo 0", less fancy than the
	// compared one.
	//
	// Types that are valid to be assigned to Key:
	//
	//	*AutotuneResult_FailureResult_ReferenceConv
	//	*AutotuneResult_FailureResult_ReferenceGemm
	//	*AutotuneResult_FailureResult_ReferenceCudaConvPlan
	//	*AutotuneResult_FailureResult_ReferenceAlgorithm
	Key           isAutotuneResult_FailureResult_Key `protobuf_oneof:"key"`
	BufferAddress int64                              `protobuf:"varint,13,opt,name=buffer_address,json=bufferAddress,proto3" json:"buffer_address,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AutotuneResult_FailureResult) Reset() {
	*x = AutotuneResult_FailureResult{}
	mi := &file_xla_autotuning_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutotuneResult_FailureResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutotuneResult_FailureResult) ProtoMessage() {}

func (x *AutotuneResult_FailureResult) ProtoReflect() protoreflect.Message {
	mi := &file_xla_autotuning_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutotuneResult_FailureResult.ProtoReflect.Descriptor instead.
func (*AutotuneResult_FailureResult) Descriptor() ([]byte, []int) {
	return file_xla_autotuning_proto_rawDescGZIP(), []int{2, 0}
}

func (x *AutotuneResult_FailureResult) GetKind() AutotuneResult_FailureKind {
	if x != nil {
		return x.Kind
	}
	return AutotuneResult_UNKNOWN
}

func (x *AutotuneResult_FailureResult) GetMsg() string {
	if x != nil {
		return x.Msg
	}
	return ""
}

func (x *AutotuneResult_FailureResult) GetKey() isAutotuneResult_FailureResult_Key {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *AutotuneResult_FailureResult) GetReferenceConv() *AutotuneResult_ConvKey {
	if x != nil {
		if x, ok := x.Key.(*AutotuneResult_FailureResult_ReferenceConv); ok {
			return x.ReferenceConv
		}
	}
	return nil
}

func (x *AutotuneResult_FailureResult) GetReferenceGemm() *AutotuneResult_GemmKey {
	if x != nil {
		if x, ok := x.Key.(*AutotuneResult_FailureResult_ReferenceGemm); ok {
			return x.ReferenceGemm
		}
	}
	return nil
}

func (x *AutotuneResult_FailureResult) GetReferenceCudaConvPlan() *AutotuneResult_CudaConvPlanKey {
	if x != nil {
		if x, ok := x.Key.(*AutotuneResult_FailureResult_ReferenceCudaConvPlan); ok {
			return x.ReferenceCudaConvPlan
		}
	}
	return nil
}

func (x *AutotuneResult_FailureResult) GetReferenceAlgorithm() *dnn.AlgorithmProto {
	if x != nil {
		if x, ok := x.Key.(*AutotuneResult_FailureResult_ReferenceAlgorithm); ok {
			return x.ReferenceAlgorithm
		}
	}
	return nil
}

func (x *AutotuneResult_FailureResult) GetBufferAddress() int64 {
	if x != nil {
		return x.BufferAddress
	}
	return 0
}

type isAutotuneResult_FailureResult_Key interface {
	isAutotuneResult_FailureResult_Key()
}

type AutotuneResult_FailureResult_ReferenceConv struct {
	ReferenceConv *AutotuneResult_ConvKey `protobuf:"bytes,11,opt,name=reference_conv,json=referenceConv,proto3,oneof"`
}

type AutotuneResult_FailureResult_ReferenceGemm struct {
	ReferenceGemm *AutotuneResult_GemmKey `protobuf:"bytes,12,opt,name=reference_gemm,json=referenceGemm,proto3,oneof"`
}

type AutotuneResult_FailureResult_ReferenceCudaConvPlan struct {
	ReferenceCudaConvPlan *AutotuneResult_CudaConvPlanKey `protobuf:"bytes,14,opt,name=reference_cuda_conv_plan,json=referenceCudaConvPlan,proto3,oneof"`
}

type AutotuneResult_FailureResult_ReferenceAlgorithm struct {
	ReferenceAlgorithm *dnn.AlgorithmProto `protobuf:"bytes,15,opt,name=reference_algorithm,json=referenceAlgorithm,proto3,oneof"`
}

func (*AutotuneResult_FailureResult_ReferenceConv) isAutotuneResult_FailureResult_Key() {}

func (*AutotuneResult_FailureResult_ReferenceGemm) isAutotuneResult_FailureResult_Key() {}

func (*AutotuneResult_FailureResult_ReferenceCudaConvPlan) isAutotuneResult_FailureResult_Key() {}

func (*AutotuneResult_FailureResult_ReferenceAlgorithm) isAutotuneResult_FailureResult_Key() {}

// Legacy and unused in new data; superseded by AlgorithmProto.
type AutotuneResult_ConvKey struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	Algorithm        int64                  `protobuf:"varint,1,opt,name=algorithm,proto3" json:"algorithm,omitempty"`
	TensorOpsEnabled bool                   `protobuf:"varint,2,opt,name=tensor_ops_enabled,json=tensorOpsEnabled,proto3" json:"tensor_ops_enabled,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *AutotuneResult_ConvKey) Reset() {
	*x = AutotuneResult_ConvKey{}
	mi := &file_xla_autotuning_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutotuneResult_ConvKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutotuneResult_ConvKey) ProtoMessage() {}

func (x *AutotuneResult_ConvKey) ProtoReflect() protoreflect.Message {
	mi := &file_xla_autotuning_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutotuneResult_ConvKey.ProtoReflect.Descriptor instead.
func (*AutotuneResult_ConvKey) Descriptor() ([]byte, []int) {
	return file_xla_autotuning_proto_rawDescGZIP(), []int{2, 1}
}

func (x *AutotuneResult_ConvKey) GetAlgorithm() int64 {
	if x != nil {
		return x.Algorithm
	}
	return 0
}

func (x *AutotuneResult_ConvKey) GetTensorOpsEnabled() bool {
	if x != nil {
		return x.TensorOpsEnabled
	}
	return false
}

type AutotuneResult_GemmKey struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Algorithm     int64                  `protobuf:"varint,1,opt,name=algorithm,proto3" json:"algorithm,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AutotuneResult_GemmKey) Reset() {
	*x = AutotuneResult_GemmKey{}
	mi := &file_xla_autotuning_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutotuneResult_GemmKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutotuneResult_GemmKey) ProtoMessage() {}

func (x *AutotuneResult_GemmKey) ProtoReflect() protoreflect.Message {
	mi := &file_xla_autotuning_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutotuneResult_GemmKey.ProtoReflect.Descriptor instead.
func (*AutotuneResult_GemmKey) Descriptor() ([]byte, []int) {
	return file_xla_autotuning_proto_rawDescGZIP(), []int{2, 2}
}

func (x *AutotuneResult_GemmKey) GetAlgorithm() int64 {
	if x != nil {
		return x.Algorithm
	}
	return 0
}

// Legacy and unused in new data; superseded by AlgorithmProto.
type AutotuneResult_CudaConvPlanKey struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ExecPlanId    string                 `protobuf:"bytes,1,opt,name=exec_plan_id,json=execPlanId,proto3" json:"exec_plan_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AutotuneResult_CudaConvPlanKey) Reset() {
	*x = AutotuneResult_CudaConvPlanKey{}
	mi := &file_xla_autotuning_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutotuneResult_CudaConvPlanKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutotuneResult_CudaConvPlanKey) ProtoMessage() {}

func (x *AutotuneResult_CudaConvPlanKey) ProtoReflect() protoreflect.Message {
	mi := &file_xla_autotuning_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutotuneResult_CudaConvPlanKey.ProtoReflect.Descriptor instead.
func (*AutotuneResult_CudaConvPlanKey) Descriptor() ([]byte, []int) {
	return file_xla_autotuning_proto_rawDescGZIP(), []int{2, 3}
}

func (x *AutotuneResult_CudaConvPlanKey) GetExecPlanId() string {
	if x != nil {
		return x.ExecPlanId
	}
	return ""
}

// If you don't need a proto in your code, please use TritonGemmConfig instead
// of using this proto directly.
type AutotuneResult_TritonGemmKey struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	BlockM        int64                  `protobuf:"varint,1,opt,name=block_m,json=blockM,proto3" json:"block_m,omitempty"`
	BlockN        int64                  `protobuf:"varint,2,opt,name=block_n,json=blockN,proto3" json:"block_n,omitempty"`
	BlockK        int64                  `protobuf:"varint,3,opt,name=block_k,json=blockK,proto3" json:"block_k,omitempty"`
	SplitK        int64                  `protobuf:"varint,4,opt,name=split_k,json=splitK,proto3" json:"split_k,omitempty"`
	NumStages     int64                  `protobuf:"varint,5,opt,name=num_stages,json=numStages,proto3" json:"num_stages,omitempty"`
	NumWarps      int64                  `protobuf:"varint,6,opt,name=num_warps,json=numWarps,proto3" json:"num_warps,omitempty"`
	NumCtas       int64                  `protobuf:"varint,7,opt,name=num_ctas,json=numCtas,proto3" json:"num_ctas,omitempty"`
	IsTmaAllowed  bool                   `protobuf:"varint,8,opt,name=is_tma_allowed,json=isTmaAllowed,proto3" json:"is_tma_allowed,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AutotuneResult_TritonGemmKey) Reset() {
	*x = AutotuneResult_TritonGemmKey{}
	mi := &file_xla_autotuning_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutotuneResult_TritonGemmKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutotuneResult_TritonGemmKey) ProtoMessage() {}

func (x *AutotuneResult_TritonGemmKey) ProtoReflect() protoreflect.Message {
	mi := &file_xla_autotuning_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutotuneResult_TritonGemmKey.ProtoReflect.Descriptor instead.
func (*AutotuneResult_TritonGemmKey) Descriptor() ([]byte, []int) {
	return file_xla_autotuning_proto_rawDescGZIP(), []int{2, 4}
}

func (x *AutotuneResult_TritonGemmKey) GetBlockM() int64 {
	if x != nil {
		return x.BlockM
	}
	return 0
}

func (x *AutotuneResult_TritonGemmKey) GetBlockN() int64 {
	if x != nil {
		return x.BlockN
	}
	return 0
}

func (x *AutotuneResult_TritonGemmKey) GetBlockK() int64 {
	if x != nil {
		return x.BlockK
	}
	return 0
}

func (x *AutotuneResult_TritonGemmKey) GetSplitK() int64 {
	if x != nil {
		return x.SplitK
	}
	return 0
}

func (x *AutotuneResult_TritonGemmKey) GetNumStages() int64 {
	if x != nil {
		return x.NumStages
	}
	return 0
}

func (x *AutotuneResult_TritonGemmKey) GetNumWarps() int64 {
	if x != nil {
		return x.NumWarps
	}
	return 0
}

func (x *AutotuneResult_TritonGemmKey) GetNumCtas() int64 {
	if x != nil {
		return x.NumCtas
	}
	return 0
}

func (x *AutotuneResult_TritonGemmKey) GetIsTmaAllowed() bool {
	if x != nil {
		return x.IsTmaAllowed
	}
	return false
}

type AutotuneResult_CustomKernelFusionKey struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	KernelIndex   int64                  `protobuf:"varint,1,opt,name=kernel_index,json=kernelIndex,proto3" json:"kernel_index,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AutotuneResult_CustomKernelFusionKey) Reset() {
	*x = AutotuneResult_CustomKernelFusionKey{}
	mi := &file_xla_autotuning_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutotuneResult_CustomKernelFusionKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutotuneResult_CustomKernelFusionKey) ProtoMessage() {}

func (x *AutotuneResult_CustomKernelFusionKey) ProtoReflect() protoreflect.Message {
	mi := &file_xla_autotuning_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutotuneResult_CustomKernelFusionKey.ProtoReflect.Descriptor instead.
func (*AutotuneResult_CustomKernelFusionKey) Descriptor() ([]byte, []int) {
	return file_xla_autotuning_proto_rawDescGZIP(), []int{2, 5}
}

func (x *AutotuneResult_CustomKernelFusionKey) GetKernelIndex() int64 {
	if x != nil {
		return x.KernelIndex
	}
	return 0
}

type AutotuneResult_BackendConfigKey struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Config        *anypb.Any             `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AutotuneResult_BackendConfigKey) Reset() {
	*x = AutotuneResult_BackendConfigKey{}
	mi := &file_xla_autotuning_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutotuneResult_BackendConfigKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutotuneResult_BackendConfigKey) ProtoMessage() {}

func (x *AutotuneResult_BackendConfigKey) ProtoReflect() protoreflect.Message {
	mi := &file_xla_autotuning_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutotuneResult_BackendConfigKey.ProtoReflect.Descriptor instead.
func (*AutotuneResult_BackendConfigKey) Descriptor() ([]byte, []int) {
	return file_xla_autotuning_proto_rawDescGZIP(), []int{2, 6}
}

func (x *AutotuneResult_BackendConfigKey) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AutotuneResult_BackendConfigKey) GetConfig() *anypb.Any {
	if x != nil {
		return x.Config
	}
	return nil
}

var File_xla_autotuning_proto protoreflect.FileDescriptor

var file_xla_autotuning_proto_rawDesc = string([]byte{
	0x0a, 0x14, 0x78, 0x6c, 0x61, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x03, 0x78, 0x6c, 0x61, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x78, 0x6c, 0x61, 0x2f, 0x74, 0x73, 0x6c, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x6e, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x50, 0x0a, 0x0c, 0x43, 0x75, 0x64, 0x6e, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x05, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x69, 0x6e, 0x6f,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x12, 0x14,
	0x0a, 0x05, 0x70, 0x61, 0x74, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x70,
	0x61, 0x74, 0x63, 0x68, 0x22, 0x3f, 0x0a, 0x11, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x43,
	0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x61, 0x6a,
	0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x12,
	0x14, 0x0a, 0x05, 0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05,
	0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x22, 0xdc, 0x0d, 0x0a, 0x0e, 0x41, 0x75, 0x74, 0x6f, 0x74, 0x75,
	0x6e, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x63, 0x72, 0x61,
	0x74, 0x63, 0x68, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0c, 0x73, 0x63, 0x72, 0x61, 0x74, 0x63, 0x68, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x34, 0x0a,
	0x08, 0x72, 0x75, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x72, 0x75, 0x6e, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x07, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x74,
	0x75, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72,
	0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65,
	0x12, 0x31, 0x0a, 0x04, 0x63, 0x6f, 0x6e, 0x76, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x4b, 0x65, 0x79, 0x48, 0x00, 0x52, 0x04, 0x63,
	0x6f, 0x6e, 0x76, 0x12, 0x31, 0x0a, 0x04, 0x67, 0x65, 0x6d, 0x6d, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x47, 0x65, 0x6d, 0x6d, 0x4b, 0x65, 0x79, 0x48, 0x00,
	0x52, 0x04, 0x67, 0x65, 0x6d, 0x6d, 0x12, 0x3b, 0x0a, 0x06, 0x74, 0x72, 0x69, 0x74, 0x6f, 0x6e,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x41, 0x75, 0x74,
	0x6f, 0x74, 0x75, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x54, 0x72, 0x69, 0x74,
	0x6f, 0x6e, 0x47, 0x65, 0x6d, 0x6d, 0x4b, 0x65, 0x79, 0x48, 0x00, 0x52, 0x06, 0x74, 0x72, 0x69,
	0x74, 0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x0e, 0x63, 0x75, 0x64, 0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x76,
	0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x78, 0x6c,
	0x61, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x2e, 0x43, 0x75, 0x64, 0x61, 0x43, 0x6f, 0x6e, 0x76, 0x50, 0x6c, 0x61, 0x6e, 0x4b, 0x65, 0x79,
	0x48, 0x00, 0x52, 0x0c, 0x63, 0x75, 0x64, 0x61, 0x43, 0x6f, 0x6e, 0x76, 0x50, 0x6c, 0x61, 0x6e,
	0x12, 0x5d, 0x0a, 0x14, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6b, 0x65, 0x72, 0x6e, 0x65,
	0x6c, 0x5f, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4b, 0x65, 0x72, 0x6e, 0x65, 0x6c,
	0x46, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x48, 0x00, 0x52, 0x12, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x4b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x46, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x43, 0x0a, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x10, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x6f, 0x72, 0x2e, 0x64, 0x6e, 0x6e, 0x2e, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74,
	0x68, 0x6d, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x48, 0x00, 0x52, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72,
	0x69, 0x74, 0x68, 0x6d, 0x12, 0x3c, 0x0a, 0x05, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x18, 0x13, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x74, 0x75,
	0x6e, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4b, 0x65, 0x79, 0x48, 0x00, 0x52, 0x05, 0x6f, 0x74, 0x68,
	0x65, 0x72, 0x1a, 0xc8, 0x03, 0x0a, 0x0d, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x12, 0x33, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e,
	0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x4b,
	0x69, 0x6e, 0x64, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x10, 0x0a, 0x03, 0x6d, 0x73, 0x67,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6d, 0x73, 0x67, 0x12, 0x44, 0x0a, 0x0e, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x74, 0x75,
	0x6e, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x4b, 0x65, 0x79,
	0x48, 0x00, 0x52, 0x0d, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x76, 0x12, 0x44, 0x0a, 0x0e, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x67,
	0x65, 0x6d, 0x6d, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x78, 0x6c, 0x61, 0x2e,
	0x41, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x47,
	0x65, 0x6d, 0x6d, 0x4b, 0x65, 0x79, 0x48, 0x00, 0x52, 0x0d, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x47, 0x65, 0x6d, 0x6d, 0x12, 0x5e, 0x0a, 0x18, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x75, 0x64, 0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x5f, 0x70,
	0x6c, 0x61, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x78, 0x6c, 0x61, 0x2e,
	0x41, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x43,
	0x75, 0x64, 0x61, 0x43, 0x6f, 0x6e, 0x76, 0x50, 0x6c, 0x61, 0x6e, 0x4b, 0x65, 0x79, 0x48, 0x00,
	0x52, 0x15, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x43, 0x75, 0x64, 0x61, 0x43,
	0x6f, 0x6e, 0x76, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x56, 0x0a, 0x13, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x0f,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x64, 0x6e, 0x6e, 0x2e, 0x41, 0x6c, 0x67, 0x6f, 0x72,
	0x69, 0x74, 0x68, 0x6d, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x48, 0x00, 0x52, 0x12, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12,
	0x25, 0x0a, 0x0e, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x42, 0x05, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x1a, 0x55, 0x0a,
	0x07, 0x43, 0x6f, 0x6e, 0x76, 0x4b, 0x65, 0x79, 0x12, 0x1c, 0x0a, 0x09, 0x61, 0x6c, 0x67, 0x6f,
	0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x61, 0x6c, 0x67,
	0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x2c, 0x0a, 0x12, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x5f, 0x6f, 0x70, 0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x10, 0x74, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x4f, 0x70, 0x73, 0x45, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x64, 0x1a, 0x27, 0x0a, 0x07, 0x47, 0x65, 0x6d, 0x6d, 0x4b, 0x65, 0x79, 0x12,
	0x1c, 0x0a, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x1a, 0x33, 0x0a,
	0x0f, 0x43, 0x75, 0x64, 0x61, 0x43, 0x6f, 0x6e, 0x76, 0x50, 0x6c, 0x61, 0x6e, 0x4b, 0x65, 0x79,
	0x12, 0x20, 0x0a, 0x0c, 0x65, 0x78, 0x65, 0x63, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x78, 0x65, 0x63, 0x50, 0x6c, 0x61, 0x6e,
	0x49, 0x64, 0x1a, 0xf0, 0x01, 0x0a, 0x0d, 0x54, 0x72, 0x69, 0x74, 0x6f, 0x6e, 0x47, 0x65, 0x6d,
	0x6d, 0x4b, 0x65, 0x79, 0x12, 0x17, 0x0a, 0x07, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x6d, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x4d, 0x12, 0x17, 0x0a,
	0x07, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06,
	0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x4e, 0x12, 0x17, 0x0a, 0x07, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f,
	0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x4b, 0x12,
	0x17, 0x0a, 0x07, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x06, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x4b, 0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x75, 0x6d, 0x5f,
	0x73, 0x74, 0x61, 0x67, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x6e, 0x75,
	0x6d, 0x53, 0x74, 0x61, 0x67, 0x65, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x6e, 0x75, 0x6d, 0x5f, 0x77,
	0x61, 0x72, 0x70, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08, 0x6e, 0x75, 0x6d, 0x57,
	0x61, 0x72, 0x70, 0x73, 0x12, 0x19, 0x0a, 0x08, 0x6e, 0x75, 0x6d, 0x5f, 0x63, 0x74, 0x61, 0x73,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x6e, 0x75, 0x6d, 0x43, 0x74, 0x61, 0x73, 0x12,
	0x24, 0x0a, 0x0e, 0x69, 0x73, 0x5f, 0x74, 0x6d, 0x61, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65,
	0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x69, 0x73, 0x54, 0x6d, 0x61, 0x41, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x1a, 0x3a, 0x0a, 0x15, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4b,
	0x65, 0x72, 0x6e, 0x65, 0x6c, 0x46, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x21,
	0x0a, 0x0c, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x1a, 0x54, 0x0a, 0x10, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x4b, 0x65, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x06, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x54, 0x0a, 0x0b, 0x46, 0x61, 0x69, 0x6c, 0x75,
	0x72, 0x65, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57,
	0x4e, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x45, 0x44, 0x5a, 0x4f, 0x4e, 0x45, 0x5f, 0x4d,
	0x4f, 0x44, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x57, 0x52, 0x4f,
	0x4e, 0x47, 0x5f, 0x52, 0x45, 0x53, 0x55, 0x4c, 0x54, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x44,
	0x49, 0x53, 0x51, 0x55, 0x41, 0x4c, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x03, 0x42, 0x05, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x22, 0xa6, 0x03, 0x0a, 0x0d, 0x41, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e,
	0x69, 0x6e, 0x67, 0x4c, 0x6f, 0x67, 0x12, 0x2a, 0x0a, 0x05, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x05, 0x69, 0x6e, 0x73,
	0x74, 0x72, 0x12, 0x2d, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x74, 0x75,
	0x6e, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x12, 0x36, 0x0a, 0x0d, 0x63, 0x75, 0x64, 0x6e, 0x6e, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x43,
	0x75, 0x64, 0x6e, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x63, 0x75, 0x64,
	0x6e, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a, 0x12, 0x63, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x43, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x65, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x11, 0x63,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x12, 0x29, 0x0a, 0x11, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x63, 0x69, 0x5f, 0x62,
	0x75, 0x73, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x50, 0x63, 0x69, 0x42, 0x75, 0x73, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x62,
	0x6c, 0x61, 0x73, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x62, 0x6c, 0x61, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1f,
	0x0a, 0x0b, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x21, 0x0a, 0x0c, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x62,
	0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var (
	file_xla_autotuning_proto_rawDescOnce sync.Once
	file_xla_autotuning_proto_rawDescData []byte
)

func file_xla_autotuning_proto_rawDescGZIP() []byte {
	file_xla_autotuning_proto_rawDescOnce.Do(func() {
		file_xla_autotuning_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_xla_autotuning_proto_rawDesc), len(file_xla_autotuning_proto_rawDesc)))
	})
	return file_xla_autotuning_proto_rawDescData
}

var file_xla_autotuning_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_xla_autotuning_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_xla_autotuning_proto_goTypes = []any{
	(AutotuneResult_FailureKind)(0),              // 0: xla.AutotuneResult.FailureKind
	(*CudnnVersion)(nil),                         // 1: xla.CudnnVersion
	(*ComputeCapability)(nil),                    // 2: xla.ComputeCapability
	(*AutotuneResult)(nil),                       // 3: xla.AutotuneResult
	(*AutotuningLog)(nil),                        // 4: xla.AutotuningLog
	(*AutotuneResult_FailureResult)(nil),         // 5: xla.AutotuneResult.FailureResult
	(*AutotuneResult_ConvKey)(nil),               // 6: xla.AutotuneResult.ConvKey
	(*AutotuneResult_GemmKey)(nil),               // 7: xla.AutotuneResult.GemmKey
	(*AutotuneResult_CudaConvPlanKey)(nil),       // 8: xla.AutotuneResult.CudaConvPlanKey
	(*AutotuneResult_TritonGemmKey)(nil),         // 9: xla.AutotuneResult.TritonGemmKey
	(*AutotuneResult_CustomKernelFusionKey)(nil), // 10: xla.AutotuneResult.CustomKernelFusionKey
	(*AutotuneResult_BackendConfigKey)(nil),      // 11: xla.AutotuneResult.BackendConfigKey
	(*durationpb.Duration)(nil),                  // 12: google.protobuf.Duration
	(*dnn.AlgorithmProto)(nil),                   // 13: stream_executor.dnn.AlgorithmProto
	(*anypb.Any)(nil),                            // 14: google.protobuf.Any
}
var file_xla_autotuning_proto_depIdxs = []int32{
	12, // 0: xla.AutotuneResult.run_time:type_name -> google.protobuf.Duration
	5,  // 1: xla.AutotuneResult.failure:type_name -> xla.AutotuneResult.FailureResult
	6,  // 2: xla.AutotuneResult.conv:type_name -> xla.AutotuneResult.ConvKey
	7,  // 3: xla.AutotuneResult.gemm:type_name -> xla.AutotuneResult.GemmKey
	9,  // 4: xla.AutotuneResult.triton:type_name -> xla.AutotuneResult.TritonGemmKey
	8,  // 5: xla.AutotuneResult.cuda_conv_plan:type_name -> xla.AutotuneResult.CudaConvPlanKey
	10, // 6: xla.AutotuneResult.custom_kernel_fusion:type_name -> xla.AutotuneResult.CustomKernelFusionKey
	13, // 7: xla.AutotuneResult.algorithm:type_name -> stream_executor.dnn.AlgorithmProto
	11, // 8: xla.AutotuneResult.other:type_name -> xla.AutotuneResult.BackendConfigKey
	14, // 9: xla.AutotuningLog.instr:type_name -> google.protobuf.Any
	3,  // 10: xla.AutotuningLog.results:type_name -> xla.AutotuneResult
	1,  // 11: xla.AutotuningLog.cudnn_version:type_name -> xla.CudnnVersion
	2,  // 12: xla.AutotuningLog.compute_capability:type_name -> xla.ComputeCapability
	0,  // 13: xla.AutotuneResult.FailureResult.kind:type_name -> xla.AutotuneResult.FailureKind
	6,  // 14: xla.AutotuneResult.FailureResult.reference_conv:type_name -> xla.AutotuneResult.ConvKey
	7,  // 15: xla.AutotuneResult.FailureResult.reference_gemm:type_name -> xla.AutotuneResult.GemmKey
	8,  // 16: xla.AutotuneResult.FailureResult.reference_cuda_conv_plan:type_name -> xla.AutotuneResult.CudaConvPlanKey
	13, // 17: xla.AutotuneResult.FailureResult.reference_algorithm:type_name -> stream_executor.dnn.AlgorithmProto
	14, // 18: xla.AutotuneResult.BackendConfigKey.config:type_name -> google.protobuf.Any
	19, // [19:19] is the sub-list for method output_type
	19, // [19:19] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_xla_autotuning_proto_init() }
func file_xla_autotuning_proto_init() {
	if File_xla_autotuning_proto != nil {
		return
	}
	file_xla_autotuning_proto_msgTypes[2].OneofWrappers = []any{
		(*AutotuneResult_Conv)(nil),
		(*AutotuneResult_Gemm)(nil),
		(*AutotuneResult_Triton)(nil),
		(*AutotuneResult_CudaConvPlan)(nil),
		(*AutotuneResult_CustomKernelFusion)(nil),
		(*AutotuneResult_Algorithm)(nil),
		(*AutotuneResult_Other)(nil),
	}
	file_xla_autotuning_proto_msgTypes[4].OneofWrappers = []any{
		(*AutotuneResult_FailureResult_ReferenceConv)(nil),
		(*AutotuneResult_FailureResult_ReferenceGemm)(nil),
		(*AutotuneResult_FailureResult_ReferenceCudaConvPlan)(nil),
		(*AutotuneResult_FailureResult_ReferenceAlgorithm)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_xla_autotuning_proto_rawDesc), len(file_xla_autotuning_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_xla_autotuning_proto_goTypes,
		DependencyIndexes: file_xla_autotuning_proto_depIdxs,
		EnumInfos:         file_xla_autotuning_proto_enumTypes,
		MessageInfos:      file_xla_autotuning_proto_msgTypes,
	}.Build()
	File_xla_autotuning_proto = out.File
	file_xla_autotuning_proto_goTypes = nil
	file_xla_autotuning_proto_depIdxs = nil
}
