// Copyright 2022 The OpenXLA Authors.
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//==============================================================================

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.4
// 	protoc        v3.21.12
// source: xla/stream_executor/device_description.proto

package device_description

import (
	autotune_results "github.com/gomlx/gopjrt/internal/protos/autotune_results"
	cuda_compute_capability "github.com/gomlx/gopjrt/internal/protos/cuda_compute_capability"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type RocmComputeCapabilityProto struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GcnArchName   string                 `protobuf:"bytes,1,opt,name=gcn_arch_name,json=gcnArchName,proto3" json:"gcn_arch_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RocmComputeCapabilityProto) Reset() {
	*x = RocmComputeCapabilityProto{}
	mi := &file_xla_stream_executor_device_description_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RocmComputeCapabilityProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RocmComputeCapabilityProto) ProtoMessage() {}

func (x *RocmComputeCapabilityProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_stream_executor_device_description_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RocmComputeCapabilityProto.ProtoReflect.Descriptor instead.
func (*RocmComputeCapabilityProto) Descriptor() ([]byte, []int) {
	return file_xla_stream_executor_device_description_proto_rawDescGZIP(), []int{0}
}

func (x *RocmComputeCapabilityProto) GetGcnArchName() string {
	if x != nil {
		return x.GcnArchName
	}
	return ""
}

type GpuDeviceInfoProto struct {
	state                     protoimpl.MessageState `protogen:"open.v1"`
	ThreadsPerBlockLimit      int32                  `protobuf:"varint,1,opt,name=threads_per_block_limit,json=threadsPerBlockLimit,proto3" json:"threads_per_block_limit,omitempty"`
	ThreadsPerWarp            int32                  `protobuf:"varint,2,opt,name=threads_per_warp,json=threadsPerWarp,proto3" json:"threads_per_warp,omitempty"`
	SharedMemoryPerBlock      int32                  `protobuf:"varint,3,opt,name=shared_memory_per_block,json=sharedMemoryPerBlock,proto3" json:"shared_memory_per_block,omitempty"`
	SharedMemoryPerCore       int32                  `protobuf:"varint,4,opt,name=shared_memory_per_core,json=sharedMemoryPerCore,proto3" json:"shared_memory_per_core,omitempty"`
	ThreadsPerCoreLimit       int32                  `protobuf:"varint,5,opt,name=threads_per_core_limit,json=threadsPerCoreLimit,proto3" json:"threads_per_core_limit,omitempty"`
	CoreCount                 int32                  `protobuf:"varint,6,opt,name=core_count,json=coreCount,proto3" json:"core_count,omitempty"`
	FpusPerCore               int64                  `protobuf:"varint,7,opt,name=fpus_per_core,json=fpusPerCore,proto3" json:"fpus_per_core,omitempty"`
	BlockDimLimitX            int32                  `protobuf:"varint,8,opt,name=block_dim_limit_x,json=blockDimLimitX,proto3" json:"block_dim_limit_x,omitempty"`
	BlockDimLimitY            int32                  `protobuf:"varint,9,opt,name=block_dim_limit_y,json=blockDimLimitY,proto3" json:"block_dim_limit_y,omitempty"`
	BlockDimLimitZ            int32                  `protobuf:"varint,10,opt,name=block_dim_limit_z,json=blockDimLimitZ,proto3" json:"block_dim_limit_z,omitempty"`
	MemoryBandwidth           int64                  `protobuf:"varint,11,opt,name=memory_bandwidth,json=memoryBandwidth,proto3" json:"memory_bandwidth,omitempty"`
	L2CacheSize               int64                  `protobuf:"varint,12,opt,name=l2_cache_size,json=l2CacheSize,proto3" json:"l2_cache_size,omitempty"`
	ClockRateGhz              float32                `protobuf:"fixed32,13,opt,name=clock_rate_ghz,json=clockRateGhz,proto3" json:"clock_rate_ghz,omitempty"`
	DeviceMemorySize          int64                  `protobuf:"varint,14,opt,name=device_memory_size,json=deviceMemorySize,proto3" json:"device_memory_size,omitempty"`
	SharedMemoryPerBlockOptin int32                  `protobuf:"varint,15,opt,name=shared_memory_per_block_optin,json=sharedMemoryPerBlockOptin,proto3" json:"shared_memory_per_block_optin,omitempty"`
	// Types that are valid to be assigned to ComputeCapability:
	//
	//	*GpuDeviceInfoProto_CudaComputeCapability
	//	*GpuDeviceInfoProto_RocmComputeCapability
	ComputeCapability      isGpuDeviceInfoProto_ComputeCapability `protobuf_oneof:"compute_capability"`
	RegistersPerCoreLimit  int64                                  `protobuf:"varint,18,opt,name=registers_per_core_limit,json=registersPerCoreLimit,proto3" json:"registers_per_core_limit,omitempty"`
	RegistersPerBlockLimit int64                                  `protobuf:"varint,19,opt,name=registers_per_block_limit,json=registersPerBlockLimit,proto3" json:"registers_per_block_limit,omitempty"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *GpuDeviceInfoProto) Reset() {
	*x = GpuDeviceInfoProto{}
	mi := &file_xla_stream_executor_device_description_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GpuDeviceInfoProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GpuDeviceInfoProto) ProtoMessage() {}

func (x *GpuDeviceInfoProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_stream_executor_device_description_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GpuDeviceInfoProto.ProtoReflect.Descriptor instead.
func (*GpuDeviceInfoProto) Descriptor() ([]byte, []int) {
	return file_xla_stream_executor_device_description_proto_rawDescGZIP(), []int{1}
}

func (x *GpuDeviceInfoProto) GetThreadsPerBlockLimit() int32 {
	if x != nil {
		return x.ThreadsPerBlockLimit
	}
	return 0
}

func (x *GpuDeviceInfoProto) GetThreadsPerWarp() int32 {
	if x != nil {
		return x.ThreadsPerWarp
	}
	return 0
}

func (x *GpuDeviceInfoProto) GetSharedMemoryPerBlock() int32 {
	if x != nil {
		return x.SharedMemoryPerBlock
	}
	return 0
}

func (x *GpuDeviceInfoProto) GetSharedMemoryPerCore() int32 {
	if x != nil {
		return x.SharedMemoryPerCore
	}
	return 0
}

func (x *GpuDeviceInfoProto) GetThreadsPerCoreLimit() int32 {
	if x != nil {
		return x.ThreadsPerCoreLimit
	}
	return 0
}

func (x *GpuDeviceInfoProto) GetCoreCount() int32 {
	if x != nil {
		return x.CoreCount
	}
	return 0
}

func (x *GpuDeviceInfoProto) GetFpusPerCore() int64 {
	if x != nil {
		return x.FpusPerCore
	}
	return 0
}

func (x *GpuDeviceInfoProto) GetBlockDimLimitX() int32 {
	if x != nil {
		return x.BlockDimLimitX
	}
	return 0
}

func (x *GpuDeviceInfoProto) GetBlockDimLimitY() int32 {
	if x != nil {
		return x.BlockDimLimitY
	}
	return 0
}

func (x *GpuDeviceInfoProto) GetBlockDimLimitZ() int32 {
	if x != nil {
		return x.BlockDimLimitZ
	}
	return 0
}

func (x *GpuDeviceInfoProto) GetMemoryBandwidth() int64 {
	if x != nil {
		return x.MemoryBandwidth
	}
	return 0
}

func (x *GpuDeviceInfoProto) GetL2CacheSize() int64 {
	if x != nil {
		return x.L2CacheSize
	}
	return 0
}

func (x *GpuDeviceInfoProto) GetClockRateGhz() float32 {
	if x != nil {
		return x.ClockRateGhz
	}
	return 0
}

func (x *GpuDeviceInfoProto) GetDeviceMemorySize() int64 {
	if x != nil {
		return x.DeviceMemorySize
	}
	return 0
}

func (x *GpuDeviceInfoProto) GetSharedMemoryPerBlockOptin() int32 {
	if x != nil {
		return x.SharedMemoryPerBlockOptin
	}
	return 0
}

func (x *GpuDeviceInfoProto) GetComputeCapability() isGpuDeviceInfoProto_ComputeCapability {
	if x != nil {
		return x.ComputeCapability
	}
	return nil
}

func (x *GpuDeviceInfoProto) GetCudaComputeCapability() *cuda_compute_capability.CudaComputeCapabilityProto {
	if x != nil {
		if x, ok := x.ComputeCapability.(*GpuDeviceInfoProto_CudaComputeCapability); ok {
			return x.CudaComputeCapability
		}
	}
	return nil
}

func (x *GpuDeviceInfoProto) GetRocmComputeCapability() *RocmComputeCapabilityProto {
	if x != nil {
		if x, ok := x.ComputeCapability.(*GpuDeviceInfoProto_RocmComputeCapability); ok {
			return x.RocmComputeCapability
		}
	}
	return nil
}

func (x *GpuDeviceInfoProto) GetRegistersPerCoreLimit() int64 {
	if x != nil {
		return x.RegistersPerCoreLimit
	}
	return 0
}

func (x *GpuDeviceInfoProto) GetRegistersPerBlockLimit() int64 {
	if x != nil {
		return x.RegistersPerBlockLimit
	}
	return 0
}

type isGpuDeviceInfoProto_ComputeCapability interface {
	isGpuDeviceInfoProto_ComputeCapability()
}

type GpuDeviceInfoProto_CudaComputeCapability struct {
	CudaComputeCapability *cuda_compute_capability.CudaComputeCapabilityProto `protobuf:"bytes,16,opt,name=cuda_compute_capability,json=cudaComputeCapability,proto3,oneof"`
}

type GpuDeviceInfoProto_RocmComputeCapability struct {
	RocmComputeCapability *RocmComputeCapabilityProto `protobuf:"bytes,17,opt,name=rocm_compute_capability,json=rocmComputeCapability,proto3,oneof"`
}

func (*GpuDeviceInfoProto_CudaComputeCapability) isGpuDeviceInfoProto_ComputeCapability() {}

func (*GpuDeviceInfoProto_RocmComputeCapability) isGpuDeviceInfoProto_ComputeCapability() {}

type DnnVersionInfoProto struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Major         int32                  `protobuf:"varint,1,opt,name=major,proto3" json:"major,omitempty"`
	Minor         int32                  `protobuf:"varint,2,opt,name=minor,proto3" json:"minor,omitempty"`
	Patch         int32                  `protobuf:"varint,3,opt,name=patch,proto3" json:"patch,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DnnVersionInfoProto) Reset() {
	*x = DnnVersionInfoProto{}
	mi := &file_xla_stream_executor_device_description_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DnnVersionInfoProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DnnVersionInfoProto) ProtoMessage() {}

func (x *DnnVersionInfoProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_stream_executor_device_description_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DnnVersionInfoProto.ProtoReflect.Descriptor instead.
func (*DnnVersionInfoProto) Descriptor() ([]byte, []int) {
	return file_xla_stream_executor_device_description_proto_rawDescGZIP(), []int{2}
}

func (x *DnnVersionInfoProto) GetMajor() int32 {
	if x != nil {
		return x.Major
	}
	return 0
}

func (x *DnnVersionInfoProto) GetMinor() int32 {
	if x != nil {
		return x.Minor
	}
	return 0
}

func (x *DnnVersionInfoProto) GetPatch() int32 {
	if x != nil {
		return x.Patch
	}
	return 0
}

type RuntimeVersionProto struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Major         int32                  `protobuf:"varint,1,opt,name=major,proto3" json:"major,omitempty"`
	Minor         int32                  `protobuf:"varint,2,opt,name=minor,proto3" json:"minor,omitempty"`
	Patch         int32                  `protobuf:"varint,3,opt,name=patch,proto3" json:"patch,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RuntimeVersionProto) Reset() {
	*x = RuntimeVersionProto{}
	mi := &file_xla_stream_executor_device_description_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RuntimeVersionProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeVersionProto) ProtoMessage() {}

func (x *RuntimeVersionProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_stream_executor_device_description_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeVersionProto.ProtoReflect.Descriptor instead.
func (*RuntimeVersionProto) Descriptor() ([]byte, []int) {
	return file_xla_stream_executor_device_description_proto_rawDescGZIP(), []int{3}
}

func (x *RuntimeVersionProto) GetMajor() int32 {
	if x != nil {
		return x.Major
	}
	return 0
}

func (x *RuntimeVersionProto) GetMinor() int32 {
	if x != nil {
		return x.Minor
	}
	return 0
}

func (x *RuntimeVersionProto) GetPatch() int32 {
	if x != nil {
		return x.Patch
	}
	return 0
}

type GpuTargetConfigProto struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	GpuDeviceInfo  *GpuDeviceInfoProto    `protobuf:"bytes,1,opt,name=gpu_device_info,json=gpuDeviceInfo,proto3" json:"gpu_device_info,omitempty"`
	PlatformName   string                 `protobuf:"bytes,4,opt,name=platform_name,json=platformName,proto3" json:"platform_name,omitempty"`
	DnnVersionInfo *DnnVersionInfoProto   `protobuf:"bytes,5,opt,name=dnn_version_info,json=dnnVersionInfo,proto3" json:"dnn_version_info,omitempty"`
	RuntimeVersion *RuntimeVersionProto   `protobuf:"bytes,8,opt,name=runtime_version,json=runtimeVersion,proto3" json:"runtime_version,omitempty"`
	// TODO(b/248362914): Autotuning results should be separate from
	// GpuTargetConfig because autotuning can be updated regularly separate from
	// the target.
	AutotuneResults      *autotune_results.AutotuneResults `protobuf:"bytes,6,opt,name=autotune_results,json=autotuneResults,proto3" json:"autotune_results,omitempty"`
	DeviceDescriptionStr string                            `protobuf:"bytes,7,opt,name=device_description_str,json=deviceDescriptionStr,proto3" json:"device_description_str,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *GpuTargetConfigProto) Reset() {
	*x = GpuTargetConfigProto{}
	mi := &file_xla_stream_executor_device_description_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GpuTargetConfigProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GpuTargetConfigProto) ProtoMessage() {}

func (x *GpuTargetConfigProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_stream_executor_device_description_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GpuTargetConfigProto.ProtoReflect.Descriptor instead.
func (*GpuTargetConfigProto) Descriptor() ([]byte, []int) {
	return file_xla_stream_executor_device_description_proto_rawDescGZIP(), []int{4}
}

func (x *GpuTargetConfigProto) GetGpuDeviceInfo() *GpuDeviceInfoProto {
	if x != nil {
		return x.GpuDeviceInfo
	}
	return nil
}

func (x *GpuTargetConfigProto) GetPlatformName() string {
	if x != nil {
		return x.PlatformName
	}
	return ""
}

func (x *GpuTargetConfigProto) GetDnnVersionInfo() *DnnVersionInfoProto {
	if x != nil {
		return x.DnnVersionInfo
	}
	return nil
}

func (x *GpuTargetConfigProto) GetRuntimeVersion() *RuntimeVersionProto {
	if x != nil {
		return x.RuntimeVersion
	}
	return nil
}

func (x *GpuTargetConfigProto) GetAutotuneResults() *autotune_results.AutotuneResults {
	if x != nil {
		return x.AutotuneResults
	}
	return nil
}

func (x *GpuTargetConfigProto) GetDeviceDescriptionStr() string {
	if x != nil {
		return x.DeviceDescriptionStr
	}
	return ""
}

var File_xla_stream_executor_device_description_proto protoreflect.FileDescriptor

var file_xla_stream_executor_device_description_proto_rawDesc = string([]byte{
	0x0a, 0x2c, 0x78, 0x6c, 0x61, 0x2f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x6f, 0x72, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0f,
	0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x1a,
	0x1a, 0x78, 0x6c, 0x61, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x78, 0x6c, 0x61,
	0x2f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72,
	0x2f, 0x63, 0x75, 0x64, 0x61, 0x2f, 0x63, 0x75, 0x64, 0x61, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x40, 0x0a, 0x1a, 0x52, 0x6f, 0x63, 0x6d, 0x43, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x22, 0x0a, 0x0d, 0x67, 0x63, 0x6e, 0x5f, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x67, 0x63, 0x6e, 0x41, 0x72, 0x63,
	0x68, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x97, 0x08, 0x0a, 0x12, 0x47, 0x70, 0x75, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x35, 0x0a, 0x17,
	0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x14, 0x74,
	0x68, 0x72, 0x65, 0x61, 0x64, 0x73, 0x50, 0x65, 0x72, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x4c, 0x69,
	0x6d, 0x69, 0x74, 0x12, 0x28, 0x0a, 0x10, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x73, 0x5f, 0x70,
	0x65, 0x72, 0x5f, 0x77, 0x61, 0x72, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x74,
	0x68, 0x72, 0x65, 0x61, 0x64, 0x73, 0x50, 0x65, 0x72, 0x57, 0x61, 0x72, 0x70, 0x12, 0x35, 0x0a,
	0x17, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x70,
	0x65, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x14,
	0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x50, 0x65, 0x72, 0x42,
	0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x33, 0x0a, 0x16, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x6d,
	0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x13, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x4d, 0x65, 0x6d, 0x6f,
	0x72, 0x79, 0x50, 0x65, 0x72, 0x43, 0x6f, 0x72, 0x65, 0x12, 0x33, 0x0a, 0x16, 0x74, 0x68, 0x72,
	0x65, 0x61, 0x64, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x13, 0x74, 0x68, 0x72, 0x65, 0x61,
	0x64, 0x73, 0x50, 0x65, 0x72, 0x43, 0x6f, 0x72, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x1d,
	0x0a, 0x0a, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x09, 0x63, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x22, 0x0a,
	0x0d, 0x66, 0x70, 0x75, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x66, 0x70, 0x75, 0x73, 0x50, 0x65, 0x72, 0x43, 0x6f, 0x72,
	0x65, 0x12, 0x29, 0x0a, 0x11, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x64, 0x69, 0x6d, 0x5f, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x5f, 0x78, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x62, 0x6c,
	0x6f, 0x63, 0x6b, 0x44, 0x69, 0x6d, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x58, 0x12, 0x29, 0x0a, 0x11,
	0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x64, 0x69, 0x6d, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f,
	0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x44, 0x69,
	0x6d, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x59, 0x12, 0x29, 0x0a, 0x11, 0x62, 0x6c, 0x6f, 0x63, 0x6b,
	0x5f, 0x64, 0x69, 0x6d, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x7a, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x0e, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x44, 0x69, 0x6d, 0x4c, 0x69, 0x6d, 0x69,
	0x74, 0x5a, 0x12, 0x29, 0x0a, 0x10, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x62, 0x61, 0x6e,
	0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x79, 0x42, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x12, 0x22, 0x0a,
	0x0d, 0x6c, 0x32, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x6c, 0x32, 0x43, 0x61, 0x63, 0x68, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x24, 0x0a, 0x0e, 0x63, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f,
	0x67, 0x68, 0x7a, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0c, 0x63, 0x6c, 0x6f, 0x63, 0x6b,
	0x52, 0x61, 0x74, 0x65, 0x47, 0x68, 0x7a, 0x12, 0x2c, 0x0a, 0x12, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x10, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72,
	0x79, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x40, 0x0a, 0x1d, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x5f,
	0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b,
	0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6e, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x05, 0x52, 0x19, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x64, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x50, 0x65, 0x72, 0x42, 0x6c, 0x6f,
	0x63, 0x6b, 0x4f, 0x70, 0x74, 0x69, 0x6e, 0x12, 0x65, 0x0a, 0x17, 0x63, 0x75, 0x64, 0x61, 0x5f,
	0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x43, 0x75, 0x64, 0x61, 0x43,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x48, 0x00, 0x52, 0x15, 0x63, 0x75, 0x64, 0x61, 0x43, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x65,
	0x0a, 0x17, 0x72, 0x6f, 0x63, 0x6d, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x63,
	0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f,
	0x72, 0x2e, 0x52, 0x6f, 0x63, 0x6d, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x43, 0x61, 0x70,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x48, 0x00, 0x52, 0x15,
	0x72, 0x6f, 0x63, 0x6d, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x43, 0x61, 0x70, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x37, 0x0a, 0x18, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69,
	0x74, 0x18, 0x12, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65,
	0x72, 0x73, 0x50, 0x65, 0x72, 0x43, 0x6f, 0x72, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x39,
	0x0a, 0x19, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f,
	0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x13, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x16, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x73, 0x50, 0x65, 0x72, 0x42,
	0x6c, 0x6f, 0x63, 0x6b, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x42, 0x14, 0x0a, 0x12, 0x63, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x22,
	0x57, 0x0a, 0x13, 0x44, 0x6e, 0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66,
	0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x12, 0x14, 0x0a, 0x05,
	0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x6d, 0x69, 0x6e,
	0x6f, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x70, 0x61, 0x74, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x05, 0x70, 0x61, 0x74, 0x63, 0x68, 0x22, 0x57, 0x0a, 0x13, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x14, 0x0a, 0x05, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05,
	0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x70,
	0x61, 0x74, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x70, 0x61, 0x74, 0x63,
	0x68, 0x22, 0xdc, 0x03, 0x0a, 0x14, 0x47, 0x70, 0x75, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x4b, 0x0a, 0x0f, 0x67, 0x70,
	0x75, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x47, 0x70, 0x75, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0d, 0x67, 0x70, 0x75, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4e, 0x0a, 0x10,
	0x64, 0x6e, 0x6e, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x44, 0x6e, 0x6e, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0e, 0x64, 0x6e,
	0x6e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x4d, 0x0a, 0x0f,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0e, 0x72, 0x75, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3f, 0x0a, 0x10, 0x61,
	0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x41, 0x75, 0x74, 0x6f,
	0x74, 0x75, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x0f, 0x61, 0x75, 0x74,
	0x6f, 0x74, 0x75, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x34, 0x0a, 0x16,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x74, 0x72, 0x4a, 0x04, 0x08, 0x02, 0x10, 0x03, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x04, 0x52, 0x17,
	0x63, 0x75, 0x64, 0x61, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x70,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x17, 0x72, 0x6f, 0x63, 0x6d, 0x5f, 0x63, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var (
	file_xla_stream_executor_device_description_proto_rawDescOnce sync.Once
	file_xla_stream_executor_device_description_proto_rawDescData []byte
)

func file_xla_stream_executor_device_description_proto_rawDescGZIP() []byte {
	file_xla_stream_executor_device_description_proto_rawDescOnce.Do(func() {
		file_xla_stream_executor_device_description_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_xla_stream_executor_device_description_proto_rawDesc), len(file_xla_stream_executor_device_description_proto_rawDesc)))
	})
	return file_xla_stream_executor_device_description_proto_rawDescData
}

var file_xla_stream_executor_device_description_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_xla_stream_executor_device_description_proto_goTypes = []any{
	(*RocmComputeCapabilityProto)(nil),                         // 0: stream_executor.RocmComputeCapabilityProto
	(*GpuDeviceInfoProto)(nil),                                 // 1: stream_executor.GpuDeviceInfoProto
	(*DnnVersionInfoProto)(nil),                                // 2: stream_executor.DnnVersionInfoProto
	(*RuntimeVersionProto)(nil),                                // 3: stream_executor.RuntimeVersionProto
	(*GpuTargetConfigProto)(nil),                               // 4: stream_executor.GpuTargetConfigProto
	(*cuda_compute_capability.CudaComputeCapabilityProto)(nil), // 5: stream_executor.CudaComputeCapabilityProto
	(*autotune_results.AutotuneResults)(nil),                   // 6: xla.AutotuneResults
}
var file_xla_stream_executor_device_description_proto_depIdxs = []int32{
	5, // 0: stream_executor.GpuDeviceInfoProto.cuda_compute_capability:type_name -> stream_executor.CudaComputeCapabilityProto
	0, // 1: stream_executor.GpuDeviceInfoProto.rocm_compute_capability:type_name -> stream_executor.RocmComputeCapabilityProto
	1, // 2: stream_executor.GpuTargetConfigProto.gpu_device_info:type_name -> stream_executor.GpuDeviceInfoProto
	2, // 3: stream_executor.GpuTargetConfigProto.dnn_version_info:type_name -> stream_executor.DnnVersionInfoProto
	3, // 4: stream_executor.GpuTargetConfigProto.runtime_version:type_name -> stream_executor.RuntimeVersionProto
	6, // 5: stream_executor.GpuTargetConfigProto.autotune_results:type_name -> xla.AutotuneResults
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_xla_stream_executor_device_description_proto_init() }
func file_xla_stream_executor_device_description_proto_init() {
	if File_xla_stream_executor_device_description_proto != nil {
		return
	}
	file_xla_stream_executor_device_description_proto_msgTypes[1].OneofWrappers = []any{
		(*GpuDeviceInfoProto_CudaComputeCapability)(nil),
		(*GpuDeviceInfoProto_RocmComputeCapability)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_xla_stream_executor_device_description_proto_rawDesc), len(file_xla_stream_executor_device_description_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_xla_stream_executor_device_description_proto_goTypes,
		DependencyIndexes: file_xla_stream_executor_device_description_proto_depIdxs,
		MessageInfos:      file_xla_stream_executor_device_description_proto_msgTypes,
	}.Build()
	File_xla_stream_executor_device_description_proto = out.File
	file_xla_stream_executor_device_description_proto_goTypes = nil
	file_xla_stream_executor_device_description_proto_depIdxs = nil
}
