// LINT: LEGACY_NAMES

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.4
// 	protoc        v3.21.12
// source: xla/tsl/protobuf/dnn.proto

package dnn

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Specifies the data type used by an operation.
type DataType int32

const (
	DataType_kFloat         DataType = 0
	DataType_kDouble        DataType = 1
	DataType_kHalf          DataType = 2
	DataType_kInt8          DataType = 3
	DataType_kInt32         DataType = 4
	DataType_kComplexFloat  DataType = 5
	DataType_kComplexDouble DataType = 6
	DataType_kBF16          DataType = 7
	DataType_kF8E5M2        DataType = 8
	DataType_kF8E4M3FN      DataType = 9
	DataType_kF8E5M2FNUZ    DataType = 10
	DataType_kF8E4M3FNUZ    DataType = 11
	DataType_kInt64         DataType = 12
	DataType_kF8E4M3        DataType = 13
	DataType_kF8E3M4        DataType = 14
	DataType_kF4E2M1FN      DataType = 15
	DataType_kF8E8M0FNU     DataType = 16
)

// Enum value maps for DataType.
var (
	DataType_name = map[int32]string{
		0:  "kFloat",
		1:  "kDouble",
		2:  "kHalf",
		3:  "kInt8",
		4:  "kInt32",
		5:  "kComplexFloat",
		6:  "kComplexDouble",
		7:  "kBF16",
		8:  "kF8E5M2",
		9:  "kF8E4M3FN",
		10: "kF8E5M2FNUZ",
		11: "kF8E4M3FNUZ",
		12: "kInt64",
		13: "kF8E4M3",
		14: "kF8E3M4",
		15: "kF4E2M1FN",
		16: "kF8E8M0FNU",
	}
	DataType_value = map[string]int32{
		"kFloat":         0,
		"kDouble":        1,
		"kHalf":          2,
		"kInt8":          3,
		"kInt32":         4,
		"kComplexFloat":  5,
		"kComplexDouble": 6,
		"kBF16":          7,
		"kF8E5M2":        8,
		"kF8E4M3FN":      9,
		"kF8E5M2FNUZ":    10,
		"kF8E4M3FNUZ":    11,
		"kInt64":         12,
		"kF8E4M3":        13,
		"kF8E3M4":        14,
		"kF4E2M1FN":      15,
		"kF8E8M0FNU":     16,
	}
)

func (x DataType) Enum() *DataType {
	p := new(DataType)
	*p = x
	return p
}

func (x DataType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataType) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_tsl_protobuf_dnn_proto_enumTypes[0].Descriptor()
}

func (DataType) Type() protoreflect.EnumType {
	return &file_xla_tsl_protobuf_dnn_proto_enumTypes[0]
}

func (x DataType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataType.Descriptor instead.
func (DataType) EnumDescriptor() ([]byte, []int) {
	return file_xla_tsl_protobuf_dnn_proto_rawDescGZIP(), []int{0}
}

// Describes how a convolution input or output layer's data is formatted.
type DataLayout int32

const (
	// Naming convention:
	// Y <-> row or height
	// X <-> column or width
	// Batch <-> batch, or N
	// Depth <-> feature, or channel
	// TODO(timshen): turn them into cuDNN names, e.g. kNCHW.
	//
	// Note: In cudnn, kBatchDepthYX4 and kBatchDepthYX32 are the same layout
	// (namely, NCHW_VECT_C).  It differentiates between these two by using a
	// different data type (int8x4 vs int8x32).  In StreamExecutor we use
	// different layouts for these, because we don't usually pass an explicit data
	// type to StreamExecutor functions.
	DataLayout_kYXDepthBatch   DataLayout = 0
	DataLayout_kYXBatchDepth   DataLayout = 1
	DataLayout_kBatchYXDepth   DataLayout = 2 // cuDNN's NHWC layout
	DataLayout_kBatchDepthYX   DataLayout = 3 // cuDNN's NCHW layout
	DataLayout_kBatchDepthYX4  DataLayout = 4 // cuDNN's NCHW_VECT_C with 4-elem vectors (e.g. int8x4)
	DataLayout_kBatchDepthYX32 DataLayout = 5 // cuDNN's NCHW_VECT_C with 32-elem vects (e.g. int8x32)
)

// Enum value maps for DataLayout.
var (
	DataLayout_name = map[int32]string{
		0: "kYXDepthBatch",
		1: "kYXBatchDepth",
		2: "kBatchYXDepth",
		3: "kBatchDepthYX",
		4: "kBatchDepthYX4",
		5: "kBatchDepthYX32",
	}
	DataLayout_value = map[string]int32{
		"kYXDepthBatch":   0,
		"kYXBatchDepth":   1,
		"kBatchYXDepth":   2,
		"kBatchDepthYX":   3,
		"kBatchDepthYX4":  4,
		"kBatchDepthYX32": 5,
	}
)

func (x DataLayout) Enum() *DataLayout {
	p := new(DataLayout)
	*p = x
	return p
}

func (x DataLayout) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DataLayout) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_tsl_protobuf_dnn_proto_enumTypes[1].Descriptor()
}

func (DataLayout) Type() protoreflect.EnumType {
	return &file_xla_tsl_protobuf_dnn_proto_enumTypes[1]
}

func (x DataLayout) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DataLayout.Descriptor instead.
func (DataLayout) EnumDescriptor() ([]byte, []int) {
	return file_xla_tsl_protobuf_dnn_proto_rawDescGZIP(), []int{1}
}

// Describes how a convolution filter is laid out in the memory.
type FilterLayout int32

const (
	// Naming convention:
	// Y <-> row or height
	// X <-> column or width
	// Output <-> output feature, or N
	// Input <-> input feature, or N
	// TODO(timshen): turn them into cuDNN names, e.g. kNCHW.
	FilterLayout_kOutputInputYX   FilterLayout = 0 // cuDNN's NCHW layout
	FilterLayout_kOutputYXInput   FilterLayout = 1 // cuDNN's NHWC layout
	FilterLayout_kOutputInputYX4  FilterLayout = 2 // cuDNN's NCHW_VECT_C layout with 4-elem vectors
	FilterLayout_kOutputInputYX32 FilterLayout = 5 // cuDNN's NCHW_VECT_C layout with 32-elem vectors
	// cuDNN-specific filter reordering (using `cudnnReorderFilterAndBias`)
	// When the filter is reordered, so is the bias (if present).
	FilterLayout_kOutputInputYX32_CudnnReordered FilterLayout = 6
	FilterLayout_kInputYXOutput                  FilterLayout = 3
	FilterLayout_kYXInputOutput                  FilterLayout = 4
)

// Enum value maps for FilterLayout.
var (
	FilterLayout_name = map[int32]string{
		0: "kOutputInputYX",
		1: "kOutputYXInput",
		2: "kOutputInputYX4",
		5: "kOutputInputYX32",
		6: "kOutputInputYX32_CudnnReordered",
		3: "kInputYXOutput",
		4: "kYXInputOutput",
	}
	FilterLayout_value = map[string]int32{
		"kOutputInputYX":                  0,
		"kOutputYXInput":                  1,
		"kOutputInputYX4":                 2,
		"kOutputInputYX32":                5,
		"kOutputInputYX32_CudnnReordered": 6,
		"kInputYXOutput":                  3,
		"kYXInputOutput":                  4,
	}
)

func (x FilterLayout) Enum() *FilterLayout {
	p := new(FilterLayout)
	*p = x
	return p
}

func (x FilterLayout) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FilterLayout) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_tsl_protobuf_dnn_proto_enumTypes[2].Descriptor()
}

func (FilterLayout) Type() protoreflect.EnumType {
	return &file_xla_tsl_protobuf_dnn_proto_enumTypes[2]
}

func (x FilterLayout) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FilterLayout.Descriptor instead.
func (FilterLayout) EnumDescriptor() ([]byte, []int) {
	return file_xla_tsl_protobuf_dnn_proto_rawDescGZIP(), []int{2}
}

// Describes a kind of non-linearity (threshold-like mathematical function).
type ActivationMode int32

const (
	ActivationMode_kNone    ActivationMode = 0
	ActivationMode_kSigmoid ActivationMode = 1
	// Rectified linear activation: f(x) = x < 0 ? 0 : x
	ActivationMode_kRelu ActivationMode = 2
	// Rectified linear activation; where upper maximum is 6.0.
	ActivationMode_kRelu6 ActivationMode = 3
	// Rectified linear activation; where upper maximum specified by
	// BatchDescriptor::value_max().
	ActivationMode_kReluX ActivationMode = 4
	ActivationMode_kTanh  ActivationMode = 5
	// Like ReluX; but passes all values in the range [-X,X].
	ActivationMode_kBandPass ActivationMode = 6
	// Exponential linear activation: f(x) = x < 0 ? e^x - 1 : x
	ActivationMode_kElu ActivationMode = 7
	// Leaky Rectified linear activation: f(x) = x < 0 ? alpha * x : x
	ActivationMode_kLeakyRelu ActivationMode = 8
	// Gaussian Error linear unit activation:
	//
	//	x * P(X <= x) = 0.5 * x * (1 + erf(x / sqrt(2))), where P(X) ~ N(0, 1).
	ActivationMode_kGeluExact ActivationMode = 9
)

// Enum value maps for ActivationMode.
var (
	ActivationMode_name = map[int32]string{
		0: "kNone",
		1: "kSigmoid",
		2: "kRelu",
		3: "kRelu6",
		4: "kReluX",
		5: "kTanh",
		6: "kBandPass",
		7: "kElu",
		8: "kLeakyRelu",
		9: "kGeluExact",
	}
	ActivationMode_value = map[string]int32{
		"kNone":      0,
		"kSigmoid":   1,
		"kRelu":      2,
		"kRelu6":     3,
		"kReluX":     4,
		"kTanh":      5,
		"kBandPass":  6,
		"kElu":       7,
		"kLeakyRelu": 8,
		"kGeluExact": 9,
	}
)

func (x ActivationMode) Enum() *ActivationMode {
	p := new(ActivationMode)
	*p = x
	return p
}

func (x ActivationMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ActivationMode) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_tsl_protobuf_dnn_proto_enumTypes[3].Descriptor()
}

func (ActivationMode) Type() protoreflect.EnumType {
	return &file_xla_tsl_protobuf_dnn_proto_enumTypes[3]
}

func (x ActivationMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ActivationMode.Descriptor instead.
func (ActivationMode) EnumDescriptor() ([]byte, []int) {
	return file_xla_tsl_protobuf_dnn_proto_rawDescGZIP(), []int{3}
}

// Describe the math definition for the conv op. The popular behavior is
// actually called cross-correlation in math, despite the operation is often
// referred as convolution. See cuDNN cudnnConvolutionMode_t.
type ConvolutionMode int32

const (
	ConvolutionMode_CROSS_CORRELATION ConvolutionMode = 0
	ConvolutionMode_CONVOLUTION       ConvolutionMode = 1
)

// Enum value maps for ConvolutionMode.
var (
	ConvolutionMode_name = map[int32]string{
		0: "CROSS_CORRELATION",
		1: "CONVOLUTION",
	}
	ConvolutionMode_value = map[string]int32{
		"CROSS_CORRELATION": 0,
		"CONVOLUTION":       1,
	}
)

func (x ConvolutionMode) Enum() *ConvolutionMode {
	p := new(ConvolutionMode)
	*p = x
	return p
}

func (x ConvolutionMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConvolutionMode) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_tsl_protobuf_dnn_proto_enumTypes[4].Descriptor()
}

func (ConvolutionMode) Type() protoreflect.EnumType {
	return &file_xla_tsl_protobuf_dnn_proto_enumTypes[4]
}

func (x ConvolutionMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConvolutionMode.Descriptor instead.
func (ConvolutionMode) EnumDescriptor() ([]byte, []int) {
	return file_xla_tsl_protobuf_dnn_proto_rawDescGZIP(), []int{4}
}

type ConvolutionKind int32

const (
	ConvolutionKind_INVALID                 ConvolutionKind = 0
	ConvolutionKind_FORWARD                 ConvolutionKind = 1
	ConvolutionKind_BACKWARD_FILTER         ConvolutionKind = 2
	ConvolutionKind_BACKWARD_DATA           ConvolutionKind = 3
	ConvolutionKind_FORWARD_BIAS_ACTIVATION ConvolutionKind = 4
	ConvolutionKind_FORWARD_GRAPH           ConvolutionKind = 5
)

// Enum value maps for ConvolutionKind.
var (
	ConvolutionKind_name = map[int32]string{
		0: "INVALID",
		1: "FORWARD",
		2: "BACKWARD_FILTER",
		3: "BACKWARD_DATA",
		4: "FORWARD_BIAS_ACTIVATION",
		5: "FORWARD_GRAPH",
	}
	ConvolutionKind_value = map[string]int32{
		"INVALID":                 0,
		"FORWARD":                 1,
		"BACKWARD_FILTER":         2,
		"BACKWARD_DATA":           3,
		"FORWARD_BIAS_ACTIVATION": 4,
		"FORWARD_GRAPH":           5,
	}
)

func (x ConvolutionKind) Enum() *ConvolutionKind {
	p := new(ConvolutionKind)
	*p = x
	return p
}

func (x ConvolutionKind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConvolutionKind) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_tsl_protobuf_dnn_proto_enumTypes[5].Descriptor()
}

func (ConvolutionKind) Type() protoreflect.EnumType {
	return &file_xla_tsl_protobuf_dnn_proto_enumTypes[5]
}

func (x ConvolutionKind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConvolutionKind.Descriptor instead.
func (ConvolutionKind) EnumDescriptor() ([]byte, []int) {
	return file_xla_tsl_protobuf_dnn_proto_rawDescGZIP(), []int{5}
}

// NormKind kind
type NormKind int32

const (
	NormKind_LAYER_FWD_INFER NormKind = 0
	NormKind_LAYER_FWD_TRAIN NormKind = 1
	NormKind_LAYER_BWD       NormKind = 2
)

// Enum value maps for NormKind.
var (
	NormKind_name = map[int32]string{
		0: "LAYER_FWD_INFER",
		1: "LAYER_FWD_TRAIN",
		2: "LAYER_BWD",
	}
	NormKind_value = map[string]int32{
		"LAYER_FWD_INFER": 0,
		"LAYER_FWD_TRAIN": 1,
		"LAYER_BWD":       2,
	}
)

func (x NormKind) Enum() *NormKind {
	p := new(NormKind)
	*p = x
	return p
}

func (x NormKind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NormKind) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_tsl_protobuf_dnn_proto_enumTypes[6].Descriptor()
}

func (NormKind) Type() protoreflect.EnumType {
	return &file_xla_tsl_protobuf_dnn_proto_enumTypes[6]
}

func (x NormKind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NormKind.Descriptor instead.
func (NormKind) EnumDescriptor() ([]byte, []int) {
	return file_xla_tsl_protobuf_dnn_proto_rawDescGZIP(), []int{6}
}

// FusedMHAKind kind
type FusedMHAKind int32

const (
	FusedMHAKind_BMM1_OUTPUT_UNKNOWN    FusedMHAKind = 0
	FusedMHAKind_BMM1_OUTPUT_INPUT_TYPE FusedMHAKind = 1
	FusedMHAKind_BMM1_OUTPUT_FLOAT      FusedMHAKind = 2
)

// Enum value maps for FusedMHAKind.
var (
	FusedMHAKind_name = map[int32]string{
		0: "BMM1_OUTPUT_UNKNOWN",
		1: "BMM1_OUTPUT_INPUT_TYPE",
		2: "BMM1_OUTPUT_FLOAT",
	}
	FusedMHAKind_value = map[string]int32{
		"BMM1_OUTPUT_UNKNOWN":    0,
		"BMM1_OUTPUT_INPUT_TYPE": 1,
		"BMM1_OUTPUT_FLOAT":      2,
	}
)

func (x FusedMHAKind) Enum() *FusedMHAKind {
	p := new(FusedMHAKind)
	*p = x
	return p
}

func (x FusedMHAKind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FusedMHAKind) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_tsl_protobuf_dnn_proto_enumTypes[7].Descriptor()
}

func (FusedMHAKind) Type() protoreflect.EnumType {
	return &file_xla_tsl_protobuf_dnn_proto_enumTypes[7]
}

func (x FusedMHAKind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FusedMHAKind.Descriptor instead.
func (FusedMHAKind) EnumDescriptor() ([]byte, []int) {
	return file_xla_tsl_protobuf_dnn_proto_rawDescGZIP(), []int{7}
}

// FusedMHAMaskKind kind
type FMHAMaskKind int32

const (
	FMHAMaskKind_NO_MASK        FMHAMaskKind = 0
	FMHAMaskKind_PADDING        FMHAMaskKind = 1
	FMHAMaskKind_CAUSAL         FMHAMaskKind = 2
	FMHAMaskKind_PADDING_CAUSAL FMHAMaskKind = 3
	FMHAMaskKind_ALIBI          FMHAMaskKind = 4
)

// Enum value maps for FMHAMaskKind.
var (
	FMHAMaskKind_name = map[int32]string{
		0: "NO_MASK",
		1: "PADDING",
		2: "CAUSAL",
		3: "PADDING_CAUSAL",
		4: "ALIBI",
	}
	FMHAMaskKind_value = map[string]int32{
		"NO_MASK":        0,
		"PADDING":        1,
		"CAUSAL":         2,
		"PADDING_CAUSAL": 3,
		"ALIBI":          4,
	}
)

func (x FMHAMaskKind) Enum() *FMHAMaskKind {
	p := new(FMHAMaskKind)
	*p = x
	return p
}

func (x FMHAMaskKind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FMHAMaskKind) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_tsl_protobuf_dnn_proto_enumTypes[8].Descriptor()
}

func (FMHAMaskKind) Type() protoreflect.EnumType {
	return &file_xla_tsl_protobuf_dnn_proto_enumTypes[8]
}

func (x FMHAMaskKind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FMHAMaskKind.Descriptor instead.
func (FMHAMaskKind) EnumDescriptor() ([]byte, []int) {
	return file_xla_tsl_protobuf_dnn_proto_rawDescGZIP(), []int{8}
}

type AlgorithmProto_MathType int32

const (
	AlgorithmProto_DEFAULT_MATH AlgorithmProto_MathType = 0
	// The GPU may operate 4x4 matrix FMA.
	// See cuDNN's documentation for CUDNN_TENSOR_OP_MATH.
	AlgorithmProto_TENSOR_OP_MATH AlgorithmProto_MathType = 1
)

// Enum value maps for AlgorithmProto_MathType.
var (
	AlgorithmProto_MathType_name = map[int32]string{
		0: "DEFAULT_MATH",
		1: "TENSOR_OP_MATH",
	}
	AlgorithmProto_MathType_value = map[string]int32{
		"DEFAULT_MATH":   0,
		"TENSOR_OP_MATH": 1,
	}
)

func (x AlgorithmProto_MathType) Enum() *AlgorithmProto_MathType {
	p := new(AlgorithmProto_MathType)
	*p = x
	return p
}

func (x AlgorithmProto_MathType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AlgorithmProto_MathType) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_tsl_protobuf_dnn_proto_enumTypes[9].Descriptor()
}

func (AlgorithmProto_MathType) Type() protoreflect.EnumType {
	return &file_xla_tsl_protobuf_dnn_proto_enumTypes[9]
}

func (x AlgorithmProto_MathType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AlgorithmProto_MathType.Descriptor instead.
func (AlgorithmProto_MathType) EnumDescriptor() ([]byte, []int) {
	return file_xla_tsl_protobuf_dnn_proto_rawDescGZIP(), []int{1, 0}
}

// Generic tensor representation.
type TensorDescriptorProto struct {
	state      protoimpl.MessageState `protogen:"open.v1"`
	Dimensions []int64                `protobuf:"varint,1,rep,packed,name=dimensions,proto3" json:"dimensions,omitempty"`
	DataType   DataType               `protobuf:"varint,2,opt,name=data_type,json=dataType,proto3,enum=stream_executor.dnn.DataType" json:"data_type,omitempty"`
	// Types that are valid to be assigned to LayoutOneof:
	//
	//	*TensorDescriptorProto_DataLayout
	//	*TensorDescriptorProto_FilterLayout
	LayoutOneof   isTensorDescriptorProto_LayoutOneof `protobuf_oneof:"layout_oneof"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TensorDescriptorProto) Reset() {
	*x = TensorDescriptorProto{}
	mi := &file_xla_tsl_protobuf_dnn_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TensorDescriptorProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TensorDescriptorProto) ProtoMessage() {}

func (x *TensorDescriptorProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_tsl_protobuf_dnn_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TensorDescriptorProto.ProtoReflect.Descriptor instead.
func (*TensorDescriptorProto) Descriptor() ([]byte, []int) {
	return file_xla_tsl_protobuf_dnn_proto_rawDescGZIP(), []int{0}
}

func (x *TensorDescriptorProto) GetDimensions() []int64 {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *TensorDescriptorProto) GetDataType() DataType {
	if x != nil {
		return x.DataType
	}
	return DataType_kFloat
}

func (x *TensorDescriptorProto) GetLayoutOneof() isTensorDescriptorProto_LayoutOneof {
	if x != nil {
		return x.LayoutOneof
	}
	return nil
}

func (x *TensorDescriptorProto) GetDataLayout() DataLayout {
	if x != nil {
		if x, ok := x.LayoutOneof.(*TensorDescriptorProto_DataLayout); ok {
			return x.DataLayout
		}
	}
	return DataLayout_kYXDepthBatch
}

func (x *TensorDescriptorProto) GetFilterLayout() FilterLayout {
	if x != nil {
		if x, ok := x.LayoutOneof.(*TensorDescriptorProto_FilterLayout); ok {
			return x.FilterLayout
		}
	}
	return FilterLayout_kOutputInputYX
}

type isTensorDescriptorProto_LayoutOneof interface {
	isTensorDescriptorProto_LayoutOneof()
}

type TensorDescriptorProto_DataLayout struct {
	DataLayout DataLayout `protobuf:"varint,3,opt,name=data_layout,json=dataLayout,proto3,enum=stream_executor.dnn.DataLayout,oneof"`
}

type TensorDescriptorProto_FilterLayout struct {
	FilterLayout FilterLayout `protobuf:"varint,4,opt,name=filter_layout,json=filterLayout,proto3,enum=stream_executor.dnn.FilterLayout,oneof"`
}

func (*TensorDescriptorProto_DataLayout) isTensorDescriptorProto_LayoutOneof() {}

func (*TensorDescriptorProto_FilterLayout) isTensorDescriptorProto_LayoutOneof() {}

// Generic algorithm representation.
type AlgorithmProto struct {
	state       protoimpl.MessageState  `protogen:"open.v1"`
	AlgoId      int64                   `protobuf:"varint,1,opt,name=algo_id,json=algoId,proto3" json:"algo_id,omitempty"`
	MathType    AlgorithmProto_MathType `protobuf:"varint,2,opt,name=math_type,json=mathType,proto3,enum=stream_executor.dnn.AlgorithmProto_MathType" json:"math_type,omitempty"`
	TuningKnobs map[int64]int64         `protobuf:"bytes,4,rep,name=tuning_knobs,json=tuningKnobs,proto3" json:"tuning_knobs,omitempty" protobuf_key:"varint,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	// DEPRECATED: This field is a no-op. The cuDNN frontend API is always used.
	// Retained for backward compatibility.
	// TODO(b/400841229): Remove this field.
	//
	// Deprecated: Marked as deprecated in xla/tsl/protobuf/dnn.proto.
	IsCudnnFrontend bool `protobuf:"varint,5,opt,name=is_cudnn_frontend,json=isCudnnFrontend,proto3" json:"is_cudnn_frontend,omitempty"`
	// For ROCm only, it's impossible to re-query the required workspace size
	// after running the algorithm search, so we must store the workspace size
	// along with the choice of algorithm.  For consistency and convenience,
	// cuDNN uses this field in the same way, even though it would be possible to
	// re-query the workspace size from cuDNN at each use.
	//
	// Since this message is persisted in files, we need to be able to distinguish
	// 0 workspace size from unknown workspace size in an old message, so this is
	// a message field.
	WorkspaceSize *wrapperspb.UInt64Value `protobuf:"bytes,6,opt,name=workspace_size,json=workspaceSize,proto3" json:"workspace_size,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AlgorithmProto) Reset() {
	*x = AlgorithmProto{}
	mi := &file_xla_tsl_protobuf_dnn_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AlgorithmProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AlgorithmProto) ProtoMessage() {}

func (x *AlgorithmProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_tsl_protobuf_dnn_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AlgorithmProto.ProtoReflect.Descriptor instead.
func (*AlgorithmProto) Descriptor() ([]byte, []int) {
	return file_xla_tsl_protobuf_dnn_proto_rawDescGZIP(), []int{1}
}

func (x *AlgorithmProto) GetAlgoId() int64 {
	if x != nil {
		return x.AlgoId
	}
	return 0
}

func (x *AlgorithmProto) GetMathType() AlgorithmProto_MathType {
	if x != nil {
		return x.MathType
	}
	return AlgorithmProto_DEFAULT_MATH
}

func (x *AlgorithmProto) GetTuningKnobs() map[int64]int64 {
	if x != nil {
		return x.TuningKnobs
	}
	return nil
}

// Deprecated: Marked as deprecated in xla/tsl/protobuf/dnn.proto.
func (x *AlgorithmProto) GetIsCudnnFrontend() bool {
	if x != nil {
		return x.IsCudnnFrontend
	}
	return false
}

func (x *AlgorithmProto) GetWorkspaceSize() *wrapperspb.UInt64Value {
	if x != nil {
		return x.WorkspaceSize
	}
	return nil
}

// Proto definition of AlgorithmConfig in "dnn.h".
// TODO(ruochengw): After cl/380702564 is submitted, add support for algorithm
// configs with cuDNN Frontend APIs.
type AlgorithmConfigProto struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Use oneof to emulate optional semantics in proto2 since older
	// version of proto3 cannot distinguish "unset field" and "default field".
	//
	// Types that are valid to be assigned to OptionalAlgorithm:
	//
	//	*AlgorithmConfigProto_Algorithm
	OptionalAlgorithm isAlgorithmConfigProto_OptionalAlgorithm `protobuf_oneof:"optional_algorithm"`
	// Types that are valid to be assigned to OptionalAlgorithmNoScratch:
	//
	//	*AlgorithmConfigProto_AlgorithmNoScratch
	OptionalAlgorithmNoScratch isAlgorithmConfigProto_OptionalAlgorithmNoScratch `protobuf_oneof:"optional_algorithm_no_scratch"`
	// Types that are valid to be assigned to OptionalScratchSize:
	//
	//	*AlgorithmConfigProto_ScratchSize
	OptionalScratchSize isAlgorithmConfigProto_OptionalScratchSize `protobuf_oneof:"optional_scratch_size"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *AlgorithmConfigProto) Reset() {
	*x = AlgorithmConfigProto{}
	mi := &file_xla_tsl_protobuf_dnn_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AlgorithmConfigProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AlgorithmConfigProto) ProtoMessage() {}

func (x *AlgorithmConfigProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_tsl_protobuf_dnn_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AlgorithmConfigProto.ProtoReflect.Descriptor instead.
func (*AlgorithmConfigProto) Descriptor() ([]byte, []int) {
	return file_xla_tsl_protobuf_dnn_proto_rawDescGZIP(), []int{2}
}

func (x *AlgorithmConfigProto) GetOptionalAlgorithm() isAlgorithmConfigProto_OptionalAlgorithm {
	if x != nil {
		return x.OptionalAlgorithm
	}
	return nil
}

func (x *AlgorithmConfigProto) GetAlgorithm() *AlgorithmProto {
	if x != nil {
		if x, ok := x.OptionalAlgorithm.(*AlgorithmConfigProto_Algorithm); ok {
			return x.Algorithm
		}
	}
	return nil
}

func (x *AlgorithmConfigProto) GetOptionalAlgorithmNoScratch() isAlgorithmConfigProto_OptionalAlgorithmNoScratch {
	if x != nil {
		return x.OptionalAlgorithmNoScratch
	}
	return nil
}

func (x *AlgorithmConfigProto) GetAlgorithmNoScratch() *AlgorithmProto {
	if x != nil {
		if x, ok := x.OptionalAlgorithmNoScratch.(*AlgorithmConfigProto_AlgorithmNoScratch); ok {
			return x.AlgorithmNoScratch
		}
	}
	return nil
}

func (x *AlgorithmConfigProto) GetOptionalScratchSize() isAlgorithmConfigProto_OptionalScratchSize {
	if x != nil {
		return x.OptionalScratchSize
	}
	return nil
}

func (x *AlgorithmConfigProto) GetScratchSize() int64 {
	if x != nil {
		if x, ok := x.OptionalScratchSize.(*AlgorithmConfigProto_ScratchSize); ok {
			return x.ScratchSize
		}
	}
	return 0
}

type isAlgorithmConfigProto_OptionalAlgorithm interface {
	isAlgorithmConfigProto_OptionalAlgorithm()
}

type AlgorithmConfigProto_Algorithm struct {
	Algorithm *AlgorithmProto `protobuf:"bytes,1,opt,name=algorithm,proto3,oneof"`
}

func (*AlgorithmConfigProto_Algorithm) isAlgorithmConfigProto_OptionalAlgorithm() {}

type isAlgorithmConfigProto_OptionalAlgorithmNoScratch interface {
	isAlgorithmConfigProto_OptionalAlgorithmNoScratch()
}

type AlgorithmConfigProto_AlgorithmNoScratch struct {
	AlgorithmNoScratch *AlgorithmProto `protobuf:"bytes,2,opt,name=algorithm_no_scratch,json=algorithmNoScratch,proto3,oneof"`
}

func (*AlgorithmConfigProto_AlgorithmNoScratch) isAlgorithmConfigProto_OptionalAlgorithmNoScratch() {}

type isAlgorithmConfigProto_OptionalScratchSize interface {
	isAlgorithmConfigProto_OptionalScratchSize()
}

type AlgorithmConfigProto_ScratchSize struct {
	ScratchSize int64 `protobuf:"varint,3,opt,name=scratch_size,json=scratchSize,proto3,oneof"`
}

func (*AlgorithmConfigProto_ScratchSize) isAlgorithmConfigProto_OptionalScratchSize() {}

// Convolution-specific parameters.
type ConvolutionDescriptorProto struct {
	state     protoimpl.MessageState `protogen:"open.v1"`
	Paddings  []int64                `protobuf:"varint,1,rep,packed,name=paddings,proto3" json:"paddings,omitempty"`
	Strides   []int64                `protobuf:"varint,2,rep,packed,name=strides,proto3" json:"strides,omitempty"`
	Dilations []int64                `protobuf:"varint,3,rep,packed,name=dilations,proto3" json:"dilations,omitempty"`
	// The "accumulator" type. For example, use F32 as an accumulator for F16
	// convolutions.
	// See cuDNN's cudnnConvolutionMode_t.
	ComputeMode DataType `protobuf:"varint,4,opt,name=compute_mode,json=computeMode,proto3,enum=stream_executor.dnn.DataType" json:"compute_mode,omitempty"`
	// See cuDNN's group count.
	GroupCount      int32           `protobuf:"varint,5,opt,name=group_count,json=groupCount,proto3" json:"group_count,omitempty"`
	ConvolutionMode ConvolutionMode `protobuf:"varint,6,opt,name=convolution_mode,json=convolutionMode,proto3,enum=stream_executor.dnn.ConvolutionMode" json:"convolution_mode,omitempty"`
	// Tensorflow node name, same as in NodeDef, for debugging purposes.
	Name          string `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ConvolutionDescriptorProto) Reset() {
	*x = ConvolutionDescriptorProto{}
	mi := &file_xla_tsl_protobuf_dnn_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConvolutionDescriptorProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConvolutionDescriptorProto) ProtoMessage() {}

func (x *ConvolutionDescriptorProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_tsl_protobuf_dnn_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConvolutionDescriptorProto.ProtoReflect.Descriptor instead.
func (*ConvolutionDescriptorProto) Descriptor() ([]byte, []int) {
	return file_xla_tsl_protobuf_dnn_proto_rawDescGZIP(), []int{3}
}

func (x *ConvolutionDescriptorProto) GetPaddings() []int64 {
	if x != nil {
		return x.Paddings
	}
	return nil
}

func (x *ConvolutionDescriptorProto) GetStrides() []int64 {
	if x != nil {
		return x.Strides
	}
	return nil
}

func (x *ConvolutionDescriptorProto) GetDilations() []int64 {
	if x != nil {
		return x.Dilations
	}
	return nil
}

func (x *ConvolutionDescriptorProto) GetComputeMode() DataType {
	if x != nil {
		return x.ComputeMode
	}
	return DataType_kFloat
}

func (x *ConvolutionDescriptorProto) GetGroupCount() int32 {
	if x != nil {
		return x.GroupCount
	}
	return 0
}

func (x *ConvolutionDescriptorProto) GetConvolutionMode() ConvolutionMode {
	if x != nil {
		return x.ConvolutionMode
	}
	return ConvolutionMode_CROSS_CORRELATION
}

func (x *ConvolutionDescriptorProto) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_xla_tsl_protobuf_dnn_proto protoreflect.FileDescriptor

var file_xla_tsl_protobuf_dnn_proto_rawDesc = string([]byte{
	0x0a, 0x1a, 0x78, 0x6c, 0x61, 0x2f, 0x74, 0x73, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x64, 0x6e, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x13, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x64, 0x6e,
	0x6e, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x91, 0x02, 0x0a, 0x15, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x44, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x0a, 0x0a, 0x64,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x03, 0x52,
	0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3a, 0x0a, 0x09, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d,
	0x2e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72,
	0x2e, 0x64, 0x6e, 0x6e, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x64,
	0x61, 0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x42, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x64,
	0x6e, 0x6e, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x48, 0x00, 0x52,
	0x0a, 0x64, 0x61, 0x74, 0x61, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x48, 0x0a, 0x0d, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x21, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x6f, 0x72, 0x2e, 0x64, 0x6e, 0x6e, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x4c,
	0x61, 0x79, 0x6f, 0x75, 0x74, 0x48, 0x00, 0x52, 0x0c, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x4c,
	0x61, 0x79, 0x6f, 0x75, 0x74, 0x42, 0x0e, 0x0a, 0x0c, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x5f,
	0x6f, 0x6e, 0x65, 0x6f, 0x66, 0x22, 0xba, 0x03, 0x0a, 0x0e, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69,
	0x74, 0x68, 0x6d, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x0a, 0x07, 0x61, 0x6c, 0x67, 0x6f,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x61, 0x6c, 0x67, 0x6f, 0x49,
	0x64, 0x12, 0x49, 0x0a, 0x09, 0x6d, 0x61, 0x74, 0x68, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x64, 0x6e, 0x6e, 0x2e, 0x41, 0x6c, 0x67, 0x6f, 0x72,
	0x69, 0x74, 0x68, 0x6d, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4d, 0x61, 0x74, 0x68, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x08, 0x6d, 0x61, 0x74, 0x68, 0x54, 0x79, 0x70, 0x65, 0x12, 0x57, 0x0a, 0x0c,
	0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6b, 0x6e, 0x6f, 0x62, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x6f, 0x72, 0x2e, 0x64, 0x6e, 0x6e, 0x2e, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74,
	0x68, 0x6d, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x4b, 0x6e,
	0x6f, 0x62, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67,
	0x4b, 0x6e, 0x6f, 0x62, 0x73, 0x12, 0x2e, 0x0a, 0x11, 0x69, 0x73, 0x5f, 0x63, 0x75, 0x64, 0x6e,
	0x6e, 0x5f, 0x66, 0x72, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x0f, 0x69, 0x73, 0x43, 0x75, 0x64, 0x6e, 0x6e, 0x46, 0x72, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x64, 0x12, 0x43, 0x0a, 0x0e, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x1a, 0x3e, 0x0a, 0x10, 0x54, 0x75,
	0x6e, 0x69, 0x6e, 0x67, 0x4b, 0x6e, 0x6f, 0x62, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x30, 0x0a, 0x08, 0x4d, 0x61,
	0x74, 0x68, 0x54, 0x79, 0x70, 0x65, 0x12, 0x10, 0x0a, 0x0c, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c,
	0x54, 0x5f, 0x4d, 0x41, 0x54, 0x48, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x54, 0x45, 0x4e, 0x53,
	0x4f, 0x52, 0x5f, 0x4f, 0x50, 0x5f, 0x4d, 0x41, 0x54, 0x48, 0x10, 0x01, 0x4a, 0x04, 0x08, 0x03,
	0x10, 0x04, 0x22, 0xa9, 0x02, 0x0a, 0x14, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x43, 0x0a, 0x09, 0x61,
	0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72,
	0x2e, 0x64, 0x6e, 0x6e, 0x2e, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x48, 0x00, 0x52, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d,
	0x12, 0x57, 0x0a, 0x14, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x5f, 0x6e, 0x6f,
	0x5f, 0x73, 0x63, 0x72, 0x61, 0x74, 0x63, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72,
	0x2e, 0x64, 0x6e, 0x6e, 0x2e, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x48, 0x01, 0x52, 0x12, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d,
	0x4e, 0x6f, 0x53, 0x63, 0x72, 0x61, 0x74, 0x63, 0x68, 0x12, 0x23, 0x0a, 0x0c, 0x73, 0x63, 0x72,
	0x61, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x48,
	0x02, 0x52, 0x0b, 0x73, 0x63, 0x72, 0x61, 0x74, 0x63, 0x68, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x14,
	0x0a, 0x12, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x72,
	0x69, 0x74, 0x68, 0x6d, 0x42, 0x1f, 0x0a, 0x1d, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x5f, 0x6e, 0x6f, 0x5f, 0x73, 0x63,
	0x72, 0x61, 0x74, 0x63, 0x68, 0x42, 0x17, 0x0a, 0x15, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61,
	0x6c, 0x5f, 0x73, 0x63, 0x72, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x22, 0xb8,
	0x02, 0x0a, 0x1a, 0x43, 0x6f, 0x6e, 0x76, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x0a,
	0x08, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x03, 0x52,
	0x08, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x74, 0x72,
	0x69, 0x64, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x03, 0x52, 0x07, 0x73, 0x74, 0x72, 0x69,
	0x64, 0x65, 0x73, 0x12, 0x1c, 0x0a, 0x09, 0x64, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x03, 0x52, 0x09, 0x64, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x40, 0x0a, 0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x6d, 0x6f, 0x64,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d, 0x2e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x2e, 0x64, 0x6e, 0x6e, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x4d,
	0x6f, 0x64, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4f, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x76, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24,
	0x2e, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72,
	0x2e, 0x64, 0x6e, 0x6e, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x76, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x2a, 0xfa, 0x01, 0x0a, 0x08, 0x44, 0x61,
	0x74, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0a, 0x0a, 0x06, 0x6b, 0x46, 0x6c, 0x6f, 0x61, 0x74,
	0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x6b, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x10, 0x01, 0x12,
	0x09, 0x0a, 0x05, 0x6b, 0x48, 0x61, 0x6c, 0x66, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x6b, 0x49,
	0x6e, 0x74, 0x38, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x6b, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x10,
	0x04, 0x12, 0x11, 0x0a, 0x0d, 0x6b, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x46, 0x6c, 0x6f,
	0x61, 0x74, 0x10, 0x05, 0x12, 0x12, 0x0a, 0x0e, 0x6b, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78,
	0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x10, 0x06, 0x12, 0x09, 0x0a, 0x05, 0x6b, 0x42, 0x46, 0x31,
	0x36, 0x10, 0x07, 0x12, 0x0b, 0x0a, 0x07, 0x6b, 0x46, 0x38, 0x45, 0x35, 0x4d, 0x32, 0x10, 0x08,
	0x12, 0x0d, 0x0a, 0x09, 0x6b, 0x46, 0x38, 0x45, 0x34, 0x4d, 0x33, 0x46, 0x4e, 0x10, 0x09, 0x12,
	0x0f, 0x0a, 0x0b, 0x6b, 0x46, 0x38, 0x45, 0x35, 0x4d, 0x32, 0x46, 0x4e, 0x55, 0x5a, 0x10, 0x0a,
	0x12, 0x0f, 0x0a, 0x0b, 0x6b, 0x46, 0x38, 0x45, 0x34, 0x4d, 0x33, 0x46, 0x4e, 0x55, 0x5a, 0x10,
	0x0b, 0x12, 0x0a, 0x0a, 0x06, 0x6b, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x10, 0x0c, 0x12, 0x0b, 0x0a,
	0x07, 0x6b, 0x46, 0x38, 0x45, 0x34, 0x4d, 0x33, 0x10, 0x0d, 0x12, 0x0b, 0x0a, 0x07, 0x6b, 0x46,
	0x38, 0x45, 0x33, 0x4d, 0x34, 0x10, 0x0e, 0x12, 0x0d, 0x0a, 0x09, 0x6b, 0x46, 0x34, 0x45, 0x32,
	0x4d, 0x31, 0x46, 0x4e, 0x10, 0x0f, 0x12, 0x0e, 0x0a, 0x0a, 0x6b, 0x46, 0x38, 0x45, 0x38, 0x4d,
	0x30, 0x46, 0x4e, 0x55, 0x10, 0x10, 0x2a, 0x81, 0x01, 0x0a, 0x0a, 0x44, 0x61, 0x74, 0x61, 0x4c,
	0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x11, 0x0a, 0x0d, 0x6b, 0x59, 0x58, 0x44, 0x65, 0x70, 0x74,
	0x68, 0x42, 0x61, 0x74, 0x63, 0x68, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x6b, 0x59, 0x58, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x70, 0x74, 0x68, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x6b,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x59, 0x58, 0x44, 0x65, 0x70, 0x74, 0x68, 0x10, 0x02, 0x12, 0x11,
	0x0a, 0x0d, 0x6b, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x70, 0x74, 0x68, 0x59, 0x58, 0x10,
	0x03, 0x12, 0x12, 0x0a, 0x0e, 0x6b, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x70, 0x74, 0x68,
	0x59, 0x58, 0x34, 0x10, 0x04, 0x12, 0x13, 0x0a, 0x0f, 0x6b, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44,
	0x65, 0x70, 0x74, 0x68, 0x59, 0x58, 0x33, 0x32, 0x10, 0x05, 0x2a, 0xae, 0x01, 0x0a, 0x0c, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x12, 0x0a, 0x0e, 0x6b,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x59, 0x58, 0x10, 0x00, 0x12,
	0x12, 0x0a, 0x0e, 0x6b, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x59, 0x58, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x6b, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x59, 0x58, 0x34, 0x10, 0x02, 0x12, 0x14, 0x0a, 0x10, 0x6b, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x59, 0x58, 0x33, 0x32, 0x10, 0x05, 0x12, 0x23,
	0x0a, 0x1f, 0x6b, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x59, 0x58,
	0x33, 0x32, 0x5f, 0x43, 0x75, 0x64, 0x6e, 0x6e, 0x52, 0x65, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x65,
	0x64, 0x10, 0x06, 0x12, 0x12, 0x0a, 0x0e, 0x6b, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x59, 0x58, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x6b, 0x59, 0x58, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x10, 0x04, 0x2a, 0x90, 0x01, 0x0a, 0x0e,
	0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x09,
	0x0a, 0x05, 0x6b, 0x4e, 0x6f, 0x6e, 0x65, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x6b, 0x53, 0x69,
	0x67, 0x6d, 0x6f, 0x69, 0x64, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x6b, 0x52, 0x65, 0x6c, 0x75,
	0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x6b, 0x52, 0x65, 0x6c, 0x75, 0x36, 0x10, 0x03, 0x12, 0x0a,
	0x0a, 0x06, 0x6b, 0x52, 0x65, 0x6c, 0x75, 0x58, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x6b, 0x54,
	0x61, 0x6e, 0x68, 0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09, 0x6b, 0x42, 0x61, 0x6e, 0x64, 0x50, 0x61,
	0x73, 0x73, 0x10, 0x06, 0x12, 0x08, 0x0a, 0x04, 0x6b, 0x45, 0x6c, 0x75, 0x10, 0x07, 0x12, 0x0e,
	0x0a, 0x0a, 0x6b, 0x4c, 0x65, 0x61, 0x6b, 0x79, 0x52, 0x65, 0x6c, 0x75, 0x10, 0x08, 0x12, 0x0e,
	0x0a, 0x0a, 0x6b, 0x47, 0x65, 0x6c, 0x75, 0x45, 0x78, 0x61, 0x63, 0x74, 0x10, 0x09, 0x2a, 0x39,
	0x0a, 0x0f, 0x43, 0x6f, 0x6e, 0x76, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64,
	0x65, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x52, 0x4f, 0x53, 0x53, 0x5f, 0x43, 0x4f, 0x52, 0x52, 0x45,
	0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x43, 0x4f, 0x4e, 0x56,
	0x4f, 0x4c, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x2a, 0x83, 0x01, 0x0a, 0x0f, 0x43, 0x6f,
	0x6e, 0x76, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x0b, 0x0a,
	0x07, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x46, 0x4f,
	0x52, 0x57, 0x41, 0x52, 0x44, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x42, 0x41, 0x43, 0x4b, 0x57,
	0x41, 0x52, 0x44, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x10, 0x02, 0x12, 0x11, 0x0a, 0x0d,
	0x42, 0x41, 0x43, 0x4b, 0x57, 0x41, 0x52, 0x44, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x10, 0x03, 0x12,
	0x1b, 0x0a, 0x17, 0x46, 0x4f, 0x52, 0x57, 0x41, 0x52, 0x44, 0x5f, 0x42, 0x49, 0x41, 0x53, 0x5f,
	0x41, 0x43, 0x54, 0x49, 0x56, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x11, 0x0a, 0x0d,
	0x46, 0x4f, 0x52, 0x57, 0x41, 0x52, 0x44, 0x5f, 0x47, 0x52, 0x41, 0x50, 0x48, 0x10, 0x05, 0x2a,
	0x43, 0x0a, 0x08, 0x4e, 0x6f, 0x72, 0x6d, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x13, 0x0a, 0x0f, 0x4c,
	0x41, 0x59, 0x45, 0x52, 0x5f, 0x46, 0x57, 0x44, 0x5f, 0x49, 0x4e, 0x46, 0x45, 0x52, 0x10, 0x00,
	0x12, 0x13, 0x0a, 0x0f, 0x4c, 0x41, 0x59, 0x45, 0x52, 0x5f, 0x46, 0x57, 0x44, 0x5f, 0x54, 0x52,
	0x41, 0x49, 0x4e, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x4c, 0x41, 0x59, 0x45, 0x52, 0x5f, 0x42,
	0x57, 0x44, 0x10, 0x02, 0x2a, 0x5a, 0x0a, 0x0c, 0x46, 0x75, 0x73, 0x65, 0x64, 0x4d, 0x48, 0x41,
	0x4b, 0x69, 0x6e, 0x64, 0x12, 0x17, 0x0a, 0x13, 0x42, 0x4d, 0x4d, 0x31, 0x5f, 0x4f, 0x55, 0x54,
	0x50, 0x55, 0x54, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x1a, 0x0a,
	0x16, 0x42, 0x4d, 0x4d, 0x31, 0x5f, 0x4f, 0x55, 0x54, 0x50, 0x55, 0x54, 0x5f, 0x49, 0x4e, 0x50,
	0x55, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x42, 0x4d, 0x4d,
	0x31, 0x5f, 0x4f, 0x55, 0x54, 0x50, 0x55, 0x54, 0x5f, 0x46, 0x4c, 0x4f, 0x41, 0x54, 0x10, 0x02,
	0x2a, 0x53, 0x0a, 0x0c, 0x46, 0x4d, 0x48, 0x41, 0x4d, 0x61, 0x73, 0x6b, 0x4b, 0x69, 0x6e, 0x64,
	0x12, 0x0b, 0x0a, 0x07, 0x4e, 0x4f, 0x5f, 0x4d, 0x41, 0x53, 0x4b, 0x10, 0x00, 0x12, 0x0b, 0x0a,
	0x07, 0x50, 0x41, 0x44, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x41,
	0x55, 0x53, 0x41, 0x4c, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x41, 0x44, 0x44, 0x49, 0x4e,
	0x47, 0x5f, 0x43, 0x41, 0x55, 0x53, 0x41, 0x4c, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x4c,
	0x49, 0x42, 0x49, 0x10, 0x04, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var (
	file_xla_tsl_protobuf_dnn_proto_rawDescOnce sync.Once
	file_xla_tsl_protobuf_dnn_proto_rawDescData []byte
)

func file_xla_tsl_protobuf_dnn_proto_rawDescGZIP() []byte {
	file_xla_tsl_protobuf_dnn_proto_rawDescOnce.Do(func() {
		file_xla_tsl_protobuf_dnn_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_xla_tsl_protobuf_dnn_proto_rawDesc), len(file_xla_tsl_protobuf_dnn_proto_rawDesc)))
	})
	return file_xla_tsl_protobuf_dnn_proto_rawDescData
}

var file_xla_tsl_protobuf_dnn_proto_enumTypes = make([]protoimpl.EnumInfo, 10)
var file_xla_tsl_protobuf_dnn_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_xla_tsl_protobuf_dnn_proto_goTypes = []any{
	(DataType)(0),                      // 0: stream_executor.dnn.DataType
	(DataLayout)(0),                    // 1: stream_executor.dnn.DataLayout
	(FilterLayout)(0),                  // 2: stream_executor.dnn.FilterLayout
	(ActivationMode)(0),                // 3: stream_executor.dnn.ActivationMode
	(ConvolutionMode)(0),               // 4: stream_executor.dnn.ConvolutionMode
	(ConvolutionKind)(0),               // 5: stream_executor.dnn.ConvolutionKind
	(NormKind)(0),                      // 6: stream_executor.dnn.NormKind
	(FusedMHAKind)(0),                  // 7: stream_executor.dnn.FusedMHAKind
	(FMHAMaskKind)(0),                  // 8: stream_executor.dnn.FMHAMaskKind
	(AlgorithmProto_MathType)(0),       // 9: stream_executor.dnn.AlgorithmProto.MathType
	(*TensorDescriptorProto)(nil),      // 10: stream_executor.dnn.TensorDescriptorProto
	(*AlgorithmProto)(nil),             // 11: stream_executor.dnn.AlgorithmProto
	(*AlgorithmConfigProto)(nil),       // 12: stream_executor.dnn.AlgorithmConfigProto
	(*ConvolutionDescriptorProto)(nil), // 13: stream_executor.dnn.ConvolutionDescriptorProto
	nil,                                // 14: stream_executor.dnn.AlgorithmProto.TuningKnobsEntry
	(*wrapperspb.UInt64Value)(nil),     // 15: google.protobuf.UInt64Value
}
var file_xla_tsl_protobuf_dnn_proto_depIdxs = []int32{
	0,  // 0: stream_executor.dnn.TensorDescriptorProto.data_type:type_name -> stream_executor.dnn.DataType
	1,  // 1: stream_executor.dnn.TensorDescriptorProto.data_layout:type_name -> stream_executor.dnn.DataLayout
	2,  // 2: stream_executor.dnn.TensorDescriptorProto.filter_layout:type_name -> stream_executor.dnn.FilterLayout
	9,  // 3: stream_executor.dnn.AlgorithmProto.math_type:type_name -> stream_executor.dnn.AlgorithmProto.MathType
	14, // 4: stream_executor.dnn.AlgorithmProto.tuning_knobs:type_name -> stream_executor.dnn.AlgorithmProto.TuningKnobsEntry
	15, // 5: stream_executor.dnn.AlgorithmProto.workspace_size:type_name -> google.protobuf.UInt64Value
	11, // 6: stream_executor.dnn.AlgorithmConfigProto.algorithm:type_name -> stream_executor.dnn.AlgorithmProto
	11, // 7: stream_executor.dnn.AlgorithmConfigProto.algorithm_no_scratch:type_name -> stream_executor.dnn.AlgorithmProto
	0,  // 8: stream_executor.dnn.ConvolutionDescriptorProto.compute_mode:type_name -> stream_executor.dnn.DataType
	4,  // 9: stream_executor.dnn.ConvolutionDescriptorProto.convolution_mode:type_name -> stream_executor.dnn.ConvolutionMode
	10, // [10:10] is the sub-list for method output_type
	10, // [10:10] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_xla_tsl_protobuf_dnn_proto_init() }
func file_xla_tsl_protobuf_dnn_proto_init() {
	if File_xla_tsl_protobuf_dnn_proto != nil {
		return
	}
	file_xla_tsl_protobuf_dnn_proto_msgTypes[0].OneofWrappers = []any{
		(*TensorDescriptorProto_DataLayout)(nil),
		(*TensorDescriptorProto_FilterLayout)(nil),
	}
	file_xla_tsl_protobuf_dnn_proto_msgTypes[2].OneofWrappers = []any{
		(*AlgorithmConfigProto_Algorithm)(nil),
		(*AlgorithmConfigProto_AlgorithmNoScratch)(nil),
		(*AlgorithmConfigProto_ScratchSize)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_xla_tsl_protobuf_dnn_proto_rawDesc), len(file_xla_tsl_protobuf_dnn_proto_rawDesc)),
			NumEnums:      10,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_xla_tsl_protobuf_dnn_proto_goTypes,
		DependencyIndexes: file_xla_tsl_protobuf_dnn_proto_depIdxs,
		EnumInfos:         file_xla_tsl_protobuf_dnn_proto_enumTypes,
		MessageInfos:      file_xla_tsl_protobuf_dnn_proto_msgTypes,
	}.Build()
	File_xla_tsl_protobuf_dnn_proto = out.File
	file_xla_tsl_protobuf_dnn_proto_goTypes = nil
	file_xla_tsl_protobuf_dnn_proto_depIdxs = nil
}
