// Copyright 2017 The OpenXLA Authors.
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//==============================================================================

// This proto file defines messages which represent the HLO module. This is a
// full fidelity serialization of the c++ HLO constructs.
//
// Many of the protos below are simple 1-to-1 serializations of the
// corresponding C++ classes, e.g., HloModule, HloComputation, and
// HloInstruction.
//
// FIELD NAMES ARE IMPORTANT
//
// Unlike most protos, you can't safely change the names of fields, even if you
// keep the numeric ids the same. This is because we sometimes serialize these
// protos as JSON, which includes the field names in the serialization.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.4
// 	protoc        v3.21.12
// source: xla/service/hlo.proto

package hlo

import (
	metrics "github.com/gomlx/gopjrt/internal/protos/metrics"
	xla_data "github.com/gomlx/gopjrt/internal/protos/xla_data"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type CustomCallSchedule int32

const (
	CustomCallSchedule_SCHEDULE_NONE     CustomCallSchedule = 0
	CustomCallSchedule_SCHEDULE_LATEST   CustomCallSchedule = 1
	CustomCallSchedule_SCHEDULE_EARLIEST CustomCallSchedule = 2
)

// Enum value maps for CustomCallSchedule.
var (
	CustomCallSchedule_name = map[int32]string{
		0: "SCHEDULE_NONE",
		1: "SCHEDULE_LATEST",
		2: "SCHEDULE_EARLIEST",
	}
	CustomCallSchedule_value = map[string]int32{
		"SCHEDULE_NONE":     0,
		"SCHEDULE_LATEST":   1,
		"SCHEDULE_EARLIEST": 2,
	}
)

func (x CustomCallSchedule) Enum() *CustomCallSchedule {
	p := new(CustomCallSchedule)
	*p = x
	return p
}

func (x CustomCallSchedule) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CustomCallSchedule) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_service_hlo_proto_enumTypes[0].Descriptor()
}

func (CustomCallSchedule) Type() protoreflect.EnumType {
	return &file_xla_service_hlo_proto_enumTypes[0]
}

func (x CustomCallSchedule) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CustomCallSchedule.Descriptor instead.
func (CustomCallSchedule) EnumDescriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{0}
}

// The version of the API used by the custom call function. The signatures for
// each version are given below.
// TODO(b/189822916): Remove this enum when all clients are migrated to the
// status-returning API.
type CustomCallApiVersion int32

const (
	CustomCallApiVersion_API_VERSION_UNSPECIFIED CustomCallApiVersion = 0
	// The first version of the API, with the following signatures:
	//
	// CPU:
	//
	//	void do_custom_call(void* out, const void** in);
	//
	// GPU:
	//
	//	void do_custom_call(CUstream stream, void** buffers,
	//	                    const char* opaque, size_t opaque_len);
	CustomCallApiVersion_API_VERSION_ORIGINAL CustomCallApiVersion = 1
	// When the ability to return success/failure status was added:
	//
	// CPU:
	//
	//	void do_custom_call(void* out, const void** in,
	//	                    XlaCustomCallStatus* status);
	//
	// GPU:
	//
	//	void do_custom_call(CUstream stream, void** buffers,
	//	                    const char* opaque, size_t opaque_len,
	//	                    XlaCustomCallStatus* status);
	CustomCallApiVersion_API_VERSION_STATUS_RETURNING CustomCallApiVersion = 2
	// Fixes the API signatures on the CPU side of the version STATUS_RETURNING by
	// adding the opaque string so that the custom call API is consistent across
	// CPUs and GPUs. For GPUs, the behaviors invoked by
	// API_VERSION_STATUS_RETURNING and API_VERSION_STATUS_RETURNING_UNIFIED are
	// the same.
	//
	// CPU:
	//
	//	void do_custom_call(void* out, const void** in,
	//	                    const char* opaque, size_t opaque_len,
	//	                    XlaCustomCallStatus* status);
	//
	// GPU:
	//
	//	void do_custom_call(CUstream stream, void** buffers,
	//	                    const char* opaque, size_t opaque_len,
	//	                    XlaCustomCallStatus* status);
	CustomCallApiVersion_API_VERSION_STATUS_RETURNING_UNIFIED CustomCallApiVersion = 3
	// Api version implementing XLA runtime custom call calling convention. These
	// custom calls can be registered as an XLA runtime custom call (1) or as XLA
	// runtime FFI binding (2).
	//
	// This type of custom call uses custom ABI to pass type information along
	// with custom call arguments. Also it passes buffer arguments together with
	// data type, sizes and strides.
	//
	// Example: (XLA runtime custom call)
	//
	//	absl::Status DoCustomCall(StridedMemrefView arg, float attr);
	//
	//	CustomCall::Bind("custom_call")
	//	  .Arg<StridedMemrefView>()
	//	  .Attr<float>("attr")
	//	  .To(DoCustomCall);
	//
	// (1) xla/runtime/custom_call.h
	// (2) xla/runtime/ffi/ffi.h
	CustomCallApiVersion_API_VERSION_TYPED_FFI CustomCallApiVersion = 4
)

// Enum value maps for CustomCallApiVersion.
var (
	CustomCallApiVersion_name = map[int32]string{
		0: "API_VERSION_UNSPECIFIED",
		1: "API_VERSION_ORIGINAL",
		2: "API_VERSION_STATUS_RETURNING",
		3: "API_VERSION_STATUS_RETURNING_UNIFIED",
		4: "API_VERSION_TYPED_FFI",
	}
	CustomCallApiVersion_value = map[string]int32{
		"API_VERSION_UNSPECIFIED":              0,
		"API_VERSION_ORIGINAL":                 1,
		"API_VERSION_STATUS_RETURNING":         2,
		"API_VERSION_STATUS_RETURNING_UNIFIED": 3,
		"API_VERSION_TYPED_FFI":                4,
	}
)

func (x CustomCallApiVersion) Enum() *CustomCallApiVersion {
	p := new(CustomCallApiVersion)
	*p = x
	return p
}

func (x CustomCallApiVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CustomCallApiVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_service_hlo_proto_enumTypes[1].Descriptor()
}

func (CustomCallApiVersion) Type() protoreflect.EnumType {
	return &file_xla_service_hlo_proto_enumTypes[1]
}

func (x CustomCallApiVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CustomCallApiVersion.Descriptor instead.
func (CustomCallApiVersion) EnumDescriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{1}
}

type Kind int32

const (
	// Define a UNDEFINED_ALIAS equal to zero to get around the default-0 proto3
	// behavior and missing has_*() APIs.
	Kind_UNDEFINED_ALIAS Kind = 0
	// The buffers may or may not alias at runtime.
	Kind_MAY_ALIAS Kind = 1
	// The buffers must alias at runtime.
	Kind_MUST_ALIAS Kind = 2
)

// Enum value maps for Kind.
var (
	Kind_name = map[int32]string{
		0: "UNDEFINED_ALIAS",
		1: "MAY_ALIAS",
		2: "MUST_ALIAS",
	}
	Kind_value = map[string]int32{
		"UNDEFINED_ALIAS": 0,
		"MAY_ALIAS":       1,
		"MUST_ALIAS":      2,
	}
)

func (x Kind) Enum() *Kind {
	p := new(Kind)
	*p = x
	return p
}

func (x Kind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Kind) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_service_hlo_proto_enumTypes[2].Descriptor()
}

func (Kind) Type() protoreflect.EnumType {
	return &file_xla_service_hlo_proto_enumTypes[2]
}

func (x Kind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Kind.Descriptor instead.
func (Kind) EnumDescriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{2}
}

// The type of optimization profile in use for module-level optimizations.
type HloModuleProto_ProfileType int32

const (
	HloModuleProto_INVALID  HloModuleProto_ProfileType = 0
	HloModuleProto_FLAG     HloModuleProto_ProfileType = 1
	HloModuleProto_FUSION   HloModuleProto_ProfileType = 2
	HloModuleProto_LAYOUT   HloModuleProto_ProfileType = 3
	HloModuleProto_DOT      HloModuleProto_ProfileType = 4
	HloModuleProto_FLAGNET  HloModuleProto_ProfileType = 5
	HloModuleProto_SHARDING HloModuleProto_ProfileType = 6
	HloModuleProto_SCHEDULE HloModuleProto_ProfileType = 7
)

// Enum value maps for HloModuleProto_ProfileType.
var (
	HloModuleProto_ProfileType_name = map[int32]string{
		0: "INVALID",
		1: "FLAG",
		2: "FUSION",
		3: "LAYOUT",
		4: "DOT",
		5: "FLAGNET",
		6: "SHARDING",
		7: "SCHEDULE",
	}
	HloModuleProto_ProfileType_value = map[string]int32{
		"INVALID":  0,
		"FLAG":     1,
		"FUSION":   2,
		"LAYOUT":   3,
		"DOT":      4,
		"FLAGNET":  5,
		"SHARDING": 6,
		"SCHEDULE": 7,
	}
)

func (x HloModuleProto_ProfileType) Enum() *HloModuleProto_ProfileType {
	p := new(HloModuleProto_ProfileType)
	*p = x
	return p
}

func (x HloModuleProto_ProfileType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HloModuleProto_ProfileType) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_service_hlo_proto_enumTypes[3].Descriptor()
}

func (HloModuleProto_ProfileType) Type() protoreflect.EnumType {
	return &file_xla_service_hlo_proto_enumTypes[3]
}

func (x HloModuleProto_ProfileType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HloModuleProto_ProfileType.Descriptor instead.
func (HloModuleProto_ProfileType) EnumDescriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{7, 0}
}

type HeapSimulatorTrace_Event_Kind int32

const (
	HeapSimulatorTrace_Event_ALLOC HeapSimulatorTrace_Event_Kind = 0 // A memory region was allocated for the buffer.
	HeapSimulatorTrace_Event_FREE  HeapSimulatorTrace_Event_Kind = 1 // A memory region was freed for the buffer.
	// A buffer was shared with another (canonical) buffer. This is similar to
	// ALLOC, except that instead of allocating a new region of memory, the
	// memory region of the canonical buffer is directly re-used. Multiple
	// buffers may share with the same canonical buffer. The lifetime of the
	// canonical buffer is extended to the union of all lifetimes.
	HeapSimulatorTrace_Event_SHARE_WITH HeapSimulatorTrace_Event_Kind = 2
)

// Enum value maps for HeapSimulatorTrace_Event_Kind.
var (
	HeapSimulatorTrace_Event_Kind_name = map[int32]string{
		0: "ALLOC",
		1: "FREE",
		2: "SHARE_WITH",
	}
	HeapSimulatorTrace_Event_Kind_value = map[string]int32{
		"ALLOC":      0,
		"FREE":       1,
		"SHARE_WITH": 2,
	}
)

func (x HeapSimulatorTrace_Event_Kind) Enum() *HeapSimulatorTrace_Event_Kind {
	p := new(HeapSimulatorTrace_Event_Kind)
	*p = x
	return p
}

func (x HeapSimulatorTrace_Event_Kind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HeapSimulatorTrace_Event_Kind) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_service_hlo_proto_enumTypes[4].Descriptor()
}

func (HeapSimulatorTrace_Event_Kind) Type() protoreflect.EnumType {
	return &file_xla_service_hlo_proto_enumTypes[4]
}

func (x HeapSimulatorTrace_Event_Kind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HeapSimulatorTrace_Event_Kind.Descriptor instead.
func (HeapSimulatorTrace_Event_Kind) EnumDescriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{10, 0, 0}
}

// Serialization of HloInstruction.
// Next ID: 92
type HloInstructionProto struct {
	state    protoimpl.MessageState `protogen:"open.v1"`
	Name     string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Opcode   string                 `protobuf:"bytes,2,opt,name=opcode,proto3" json:"opcode,omitempty"`
	Shape    *xla_data.ShapeProto   `protobuf:"bytes,3,opt,name=shape,proto3" json:"shape,omitempty"`
	Metadata *xla_data.OpMetadata   `protobuf:"bytes,7,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Literal, only present for kConstant.
	Literal *xla_data.LiteralProto `protobuf:"bytes,8,opt,name=literal,proto3" json:"literal,omitempty"`
	// Parameter number is only present for kParameter.
	ParameterNumber int64 `protobuf:"varint,9,opt,name=parameter_number,json=parameterNumber,proto3" json:"parameter_number,omitempty"`
	// Fusion state, only present for kFusion.
	FusionKind string `protobuf:"bytes,11,opt,name=fusion_kind,json=fusionKind,proto3" json:"fusion_kind,omitempty"`
	// Index for kGetTupleElement.
	TupleIndex int64 `protobuf:"varint,13,opt,name=tuple_index,json=tupleIndex,proto3" json:"tuple_index,omitempty"`
	// Dimensions present for some operations that require reshaping or
	// broadcasting, including Reshape, Reduce, ReduceWindow, and Reverse.
	Dimensions []int64 `protobuf:"varint,14,rep,packed,name=dimensions,proto3" json:"dimensions,omitempty"`
	// Describes the window in a windowed operation such as convolution.
	Window *xla_data.Window `protobuf:"bytes,15,opt,name=window,proto3" json:"window,omitempty"`
	// Describes the dimension numbers used for a convolution.
	ConvolutionDimensionNumbers *xla_data.ConvolutionDimensionNumbers `protobuf:"bytes,16,opt,name=convolution_dimension_numbers,json=convolutionDimensionNumbers,proto3" json:"convolution_dimension_numbers,omitempty"`
	// The number of feature groups. Used for a convolution. Must be a divisor of
	// the input feature dimension and output feature dimension. If not specified,
	// it will use a default value of 1.
	FeatureGroupCount int64                                  `protobuf:"varint,50,opt,name=feature_group_count,json=featureGroupCount,proto3" json:"feature_group_count,omitempty"`
	BatchGroupCount   int64                                  `protobuf:"varint,58,opt,name=batch_group_count,json=batchGroupCount,proto3" json:"batch_group_count,omitempty"`
	SliceDimensions   []*HloInstructionProto_SliceDimensions `protobuf:"bytes,17,rep,name=slice_dimensions,json=sliceDimensions,proto3" json:"slice_dimensions,omitempty"`
	// The bit sizes for a reduce-precision operation.
	ExponentBits int32 `protobuf:"varint,18,opt,name=exponent_bits,json=exponentBits,proto3" json:"exponent_bits,omitempty"`
	MantissaBits int32 `protobuf:"varint,19,opt,name=mantissa_bits,json=mantissaBits,proto3" json:"mantissa_bits,omitempty"`
	// Describes the [start, start + size) range size for a dynamic slice
	// ('start' is specified dynamically in the second operand of the operation).
	DynamicSliceSizes []int64 `protobuf:"varint,20,rep,packed,name=dynamic_slice_sizes,json=dynamicSliceSizes,proto3" json:"dynamic_slice_sizes,omitempty"`
	// The padding configuration that describes the edge padding and interior
	// padding of this pad instruction. Only set for pad instructions.
	PaddingConfig *xla_data.PaddingConfig `protobuf:"bytes,21,opt,name=padding_config,json=paddingConfig,proto3" json:"padding_config,omitempty"`
	// Outfeed configuration information, only present for kOutfeed.
	OutfeedConfig []byte `protobuf:"bytes,22,opt,name=outfeed_config,json=outfeedConfig,proto3" json:"outfeed_config,omitempty"`
	// The distribution requested for random number generation.
	// Only present for kRng.
	Distribution xla_data.RandomDistribution `protobuf:"varint,23,opt,name=distribution,proto3,enum=xla.RandomDistribution" json:"distribution,omitempty"`
	// A small float number added to the variance to avoid divide-by-zero error.
	// Only present for kBatchNormTraining, kBatchNormInference, and
	// kBatchNormGrad.
	Epsilon float32 `protobuf:"fixed32,24,opt,name=epsilon,proto3" json:"epsilon,omitempty"`
	// An integer value representing the index of the feature dimension.
	// Only present for kBatchNormTraining, kBatchNormInference, and
	// kBatchNormGrad.
	FeatureIndex int64 `protobuf:"varint,25,opt,name=feature_index,json=featureIndex,proto3" json:"feature_index,omitempty"`
	// Represents a unique identifier for each Send/Recv instruction pair or
	// optionally for collective instructions (AllReduce, CollectivePermute,
	// AllToAll). Non-positive channel_id is equivalent to no channel id.
	ChannelId int64 `protobuf:"varint,26,opt,name=channel_id,json=channelId,proto3" json:"channel_id,omitempty"`
	// The string representation of the infeed configuration.
	InfeedConfig []byte `protobuf:"bytes,27,opt,name=infeed_config,json=infeedConfig,proto3" json:"infeed_config,omitempty"`
	// Name of a external target (eg, global symbol) to call, only present for
	// kCustomCall.
	CustomCallTarget string `protobuf:"bytes,28,opt,name=custom_call_target,json=customCallTarget,proto3" json:"custom_call_target,omitempty"`
	// Shape of outfeed request.
	OutfeedShape *xla_data.ShapeProto `protobuf:"bytes,29,opt,name=outfeed_shape,json=outfeedShape,proto3" json:"outfeed_shape,omitempty"`
	// Describes the dimension numbers used for a dot operation
	DotDimensionNumbers *xla_data.DotDimensionNumbers `protobuf:"bytes,30,opt,name=dot_dimension_numbers,json=dotDimensionNumbers,proto3" json:"dot_dimension_numbers,omitempty"`
	// Describes the dimension numbers used for a ragged dot operation
	RaggedDotDimensionNumbers *xla_data.RaggedDotDimensionNumbers `protobuf:"bytes,90,opt,name=ragged_dot_dimension_numbers,json=raggedDotDimensionNumbers,proto3" json:"ragged_dot_dimension_numbers,omitempty"`
	// FFT type (FFT, IFFT, etc).
	FftType xla_data.FftType `protobuf:"varint,31,opt,name=fft_type,json=fftType,proto3,enum=xla.FftType" json:"fft_type,omitempty"`
	// FFT length.
	FftLength []int64 `protobuf:"varint,32,rep,packed,name=fft_length,json=fftLength,proto3" json:"fft_length,omitempty"`
	// Comparison direction only used for kCompare.
	ComparisonDirection string `protobuf:"bytes,63,opt,name=comparison_direction,json=comparisonDirection,proto3" json:"comparison_direction,omitempty"`
	// Gather dimension numbers.
	GatherDimensionNumbers *xla_data.GatherDimensionNumbers `protobuf:"bytes,33,opt,name=gather_dimension_numbers,json=gatherDimensionNumbers,proto3" json:"gather_dimension_numbers,omitempty"`
	GatherSliceSizes       []int64                          `protobuf:"varint,34,rep,packed,name=gather_slice_sizes,json=gatherSliceSizes,proto3" json:"gather_slice_sizes,omitempty"`
	// The id of this instruction.
	Id                    int64                `protobuf:"varint,35,opt,name=id,proto3" json:"id,omitempty"`
	OperandIds            []int64              `protobuf:"varint,36,rep,packed,name=operand_ids,json=operandIds,proto3" json:"operand_ids,omitempty"`
	ControlPredecessorIds []int64              `protobuf:"varint,37,rep,packed,name=control_predecessor_ids,json=controlPredecessorIds,proto3" json:"control_predecessor_ids,omitempty"`
	CalledComputationIds  []int64              `protobuf:"varint,38,rep,packed,name=called_computation_ids,json=calledComputationIds,proto3" json:"called_computation_ids,omitempty"`
	Sharding              *xla_data.OpSharding `protobuf:"bytes,40,opt,name=sharding,proto3" json:"sharding,omitempty"`
	// Backend configuration for the instruction. Has backend-specific meaning.
	BackendConfig []byte `protobuf:"bytes,43,opt,name=backend_config,json=backendConfig,proto3" json:"backend_config,omitempty"`
	// Deprecated, but keeping for backward compatibility.
	// Use collective_device_list. Cross replica op fields.
	//
	// Deprecated: Marked as deprecated in xla/service/hlo.proto.
	ReplicaGroups []*xla_data.ReplicaGroup `protobuf:"bytes,49,rep,name=replica_groups,json=replicaGroups,proto3" json:"replica_groups,omitempty"`
	// Deprecated, but keeping it for backward compatibility. Use channel_id.
	// Non-positive all_reduce_id is equivalent to no all_reduce_id.
	//
	// Deprecated: Marked as deprecated in xla/service/hlo.proto.
	AllReduceId int64 `protobuf:"varint,45,opt,name=all_reduce_id,json=allReduceId,proto3" json:"all_reduce_id,omitempty"`
	// If true, interprets ids in ReplicaGroup as global device ids, which is
	// a linearized id of `replica_id * partition_count + partition_id`.
	UseGlobalDeviceIds bool `protobuf:"varint,71,opt,name=use_global_device_ids,json=useGlobalDeviceIds,proto3" json:"use_global_device_ids,omitempty"`
	// Whether this Send/Recv instruction transfers data to/from the host. Only
	// present for Send and Recv instructions and their SendDone and RecvDone
	// partners.
	IsHostTransfer bool `protobuf:"varint,47,opt,name=is_host_transfer,json=isHostTransfer,proto3" json:"is_host_transfer,omitempty"`
	// Whether this Sort instruction should be stable.
	IsStable                bool                              `protobuf:"varint,60,opt,name=is_stable,json=isStable,proto3" json:"is_stable,omitempty"`
	ScatterDimensionNumbers *xla_data.ScatterDimensionNumbers `protobuf:"bytes,48,opt,name=scatter_dimension_numbers,json=scatterDimensionNumbers,proto3" json:"scatter_dimension_numbers,omitempty"`
	// Precision configuration for the instruction. Has backend-specific meaning.
	PrecisionConfig *xla_data.PrecisionConfig `protobuf:"bytes,51,opt,name=precision_config,json=precisionConfig,proto3" json:"precision_config,omitempty"`
	// Collective permute field.
	SourceTargetPairs []*xla_data.SourceTarget `protobuf:"bytes,52,rep,name=source_target_pairs,json=sourceTargetPairs,proto3" json:"source_target_pairs,omitempty"`
	// Sharding for kDomain instructions.
	DomainEntrySharding *xla_data.OpSharding `protobuf:"bytes,54,opt,name=domain_entry_sharding,json=domainEntrySharding,proto3" json:"domain_entry_sharding,omitempty"`
	DomainExitSharding  *xla_data.OpSharding `protobuf:"bytes,55,opt,name=domain_exit_sharding,json=domainExitSharding,proto3" json:"domain_exit_sharding,omitempty"`
	// For custom call this indicates that the layouts are constrained. If
	// constrain_layout is true then the 'shape' field must contain a layout, and
	// 'operand_shapes_with_layout' must contain a shape with layout for each
	// operand.
	ConstrainLayout         bool                   `protobuf:"varint,56,opt,name=constrain_layout,json=constrainLayout,proto3" json:"constrain_layout,omitempty"`
	OperandShapesWithLayout []*xla_data.ShapeProto `protobuf:"bytes,57,rep,name=operand_shapes_with_layout,json=operandShapesWithLayout,proto3" json:"operand_shapes_with_layout,omitempty"`
	// Options for TriangularSolve
	TriangularSolveOptions *xla_data.TriangularSolveOptions `protobuf:"bytes,59,opt,name=triangular_solve_options,json=triangularSolveOptions,proto3" json:"triangular_solve_options,omitempty"`
	// Options for Cholesky
	CholeskyOptions *xla_data.CholeskyOptions `protobuf:"bytes,62,opt,name=cholesky_options,json=choleskyOptions,proto3" json:"cholesky_options,omitempty"`
	// Describes how parameters behave with regards to replicas.
	ParameterReplication *xla_data.ParameterReplication `protobuf:"bytes,61,opt,name=parameter_replication,json=parameterReplication,proto3" json:"parameter_replication,omitempty"`
	// Whether the kCustomCall instruction has side-effects, only present for
	// kCustomCall.
	CustomCallHasSideEffect bool `protobuf:"varint,65,opt,name=custom_call_has_side_effect,json=customCallHasSideEffect,proto3" json:"custom_call_has_side_effect,omitempty"`
	// A list of OutputOperandAliasing pairs that specifies aliasing buffers
	// between output and operands for kCustomCall and kFusion.
	OutputOperandAliasing []*xla_data.OutputOperandAliasing `protobuf:"bytes,74,rep,name=output_operand_aliasing,json=outputOperandAliasing,proto3" json:"output_operand_aliasing,omitempty"`
	// Specifies the desired schedule for the custom-call. The field is only
	// present for custom-call.
	CustomCallSchedule CustomCallSchedule `protobuf:"varint,76,opt,name=custom_call_schedule,json=customCallSchedule,proto3,enum=xla.CustomCallSchedule" json:"custom_call_schedule,omitempty"`
	// The delta value for kRngGetAndUpdateState.
	Delta int64 `protobuf:"varint,66,opt,name=delta,proto3" json:"delta,omitempty"`
	// Specifies if the gather/scatter indices are guaranteed to be sorted by the
	// caller.
	IndicesAreSorted bool `protobuf:"varint,67,opt,name=indices_are_sorted,json=indicesAreSorted,proto3" json:"indices_are_sorted,omitempty"`
	// Frontend attributes to pass to the XLA backend.
	FrontendAttributes *xla_data.FrontendAttributes `protobuf:"bytes,68,opt,name=frontend_attributes,json=frontendAttributes,proto3" json:"frontend_attributes,omitempty"`
	// Specifies if all elements updated are guaranteed to be unique by
	// the caller.
	UniqueIndices bool `protobuf:"varint,69,opt,name=unique_indices,json=uniqueIndices,proto3" json:"unique_indices,omitempty"`
	// RNG algorithm used by kRngBitGenerator.
	RngAlgorithm xla_data.RandomAlgorithm `protobuf:"varint,70,opt,name=rng_algorithm,json=rngAlgorithm,proto3,enum=xla.RandomAlgorithm" json:"rng_algorithm,omitempty"`
	// The comparison type used for kCompare.
	ComparisonType string `protobuf:"bytes,72,opt,name=comparison_type,json=comparisonType,proto3" json:"comparison_type,omitempty"`
	// Specifies if this is a cross-program-prefetch, used by kCopyStart.
	// Deprecated and replaced by optional_cross_program_prefetch_index.
	//
	// Deprecated: Marked as deprecated in xla/service/hlo.proto.
	IsCrossProgramPrefetch bool `protobuf:"varint,73,opt,name=is_cross_program_prefetch,json=isCrossProgramPrefetch,proto3" json:"is_cross_program_prefetch,omitempty"`
	// Specifies the cross-program-prefetch index used by kCopyStart. Uses oneof
	// to emulate the 'optional' keyword for proto3 versions before v3.15.0
	// released 2021/2/18.
	//
	// Types that are valid to be assigned to OptionalCrossProgramPrefetchIndex:
	//
	//	*HloInstructionProto_CrossProgramPrefetchIndex
	OptionalCrossProgramPrefetchIndex isHloInstructionProto_OptionalCrossProgramPrefetchIndex `protobuf_oneof:"optional_cross_program_prefetch_index"`
	// If a convolution is dynamic, a dynamic padding type will be specified.
	PaddingType xla_data.PaddingType `protobuf:"varint,75,opt,name=padding_type,json=paddingType,proto3,enum=xla.PaddingType" json:"padding_type,omitempty"`
	// The API version used by the custom call function. This field is only
	// present for custom-call.
	// TODO(b/189822916): Remove this field when all clients are migrated to the
	// status-returning API.
	CustomCallApiVersion CustomCallApiVersion `protobuf:"varint,77,opt,name=custom_call_api_version,json=customCallApiVersion,proto3,enum=xla.CustomCallApiVersion" json:"custom_call_api_version,omitempty"`
	// Represents a unique execution thread name for one or more async groups.
	// Each HLO module may contain a main thread and one or more parallel threads.
	// Empty async_execution_thread is equivalent to main thread.
	AsyncExecutionThread string `protobuf:"bytes,79,opt,name=async_execution_thread,json=asyncExecutionThread,proto3" json:"async_execution_thread,omitempty"`
	// Represents the K value for top-k.
	K int64 `protobuf:"varint,81,opt,name=k,proto3" json:"k,omitempty"`
	// Represents the largest flag for top-k.
	Largest bool `protobuf:"varint,85,opt,name=largest,proto3" json:"largest,omitempty"`
	// Represents the information for tracking propagation of values within HLO
	// graph.
	StatisticsViz *xla_data.StatisticsViz `protobuf:"bytes,82,opt,name=statistics_viz,json=statisticsViz,proto3" json:"statistics_viz,omitempty"`
	// Represents the list of devices that participate in a collective operation.
	CollectiveDeviceList *xla_data.CollectiveDeviceListProto `protobuf:"bytes,87,opt,name=collective_device_list,json=collectiveDeviceList,proto3" json:"collective_device_list,omitempty"`
	// For HLO value tracking.
	OriginalValue *xla_data.OriginalValueProto `protobuf:"bytes,88,opt,name=original_value,json=originalValue,proto3" json:"original_value,omitempty"`
	// Specifies if a call instruction is a composite.
	IsComposite bool `protobuf:"varint,89,opt,name=is_composite,json=isComposite,proto3" json:"is_composite,omitempty"`
	// Accuracy for unary functions with multiple implementations.
	ResultAccuracy *xla_data.ResultAccuracy `protobuf:"bytes,91,opt,name=result_accuracy,json=resultAccuracy,proto3" json:"result_accuracy,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *HloInstructionProto) Reset() {
	*x = HloInstructionProto{}
	mi := &file_xla_service_hlo_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HloInstructionProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HloInstructionProto) ProtoMessage() {}

func (x *HloInstructionProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HloInstructionProto.ProtoReflect.Descriptor instead.
func (*HloInstructionProto) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{0}
}

func (x *HloInstructionProto) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HloInstructionProto) GetOpcode() string {
	if x != nil {
		return x.Opcode
	}
	return ""
}

func (x *HloInstructionProto) GetShape() *xla_data.ShapeProto {
	if x != nil {
		return x.Shape
	}
	return nil
}

func (x *HloInstructionProto) GetMetadata() *xla_data.OpMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *HloInstructionProto) GetLiteral() *xla_data.LiteralProto {
	if x != nil {
		return x.Literal
	}
	return nil
}

func (x *HloInstructionProto) GetParameterNumber() int64 {
	if x != nil {
		return x.ParameterNumber
	}
	return 0
}

func (x *HloInstructionProto) GetFusionKind() string {
	if x != nil {
		return x.FusionKind
	}
	return ""
}

func (x *HloInstructionProto) GetTupleIndex() int64 {
	if x != nil {
		return x.TupleIndex
	}
	return 0
}

func (x *HloInstructionProto) GetDimensions() []int64 {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *HloInstructionProto) GetWindow() *xla_data.Window {
	if x != nil {
		return x.Window
	}
	return nil
}

func (x *HloInstructionProto) GetConvolutionDimensionNumbers() *xla_data.ConvolutionDimensionNumbers {
	if x != nil {
		return x.ConvolutionDimensionNumbers
	}
	return nil
}

func (x *HloInstructionProto) GetFeatureGroupCount() int64 {
	if x != nil {
		return x.FeatureGroupCount
	}
	return 0
}

func (x *HloInstructionProto) GetBatchGroupCount() int64 {
	if x != nil {
		return x.BatchGroupCount
	}
	return 0
}

func (x *HloInstructionProto) GetSliceDimensions() []*HloInstructionProto_SliceDimensions {
	if x != nil {
		return x.SliceDimensions
	}
	return nil
}

func (x *HloInstructionProto) GetExponentBits() int32 {
	if x != nil {
		return x.ExponentBits
	}
	return 0
}

func (x *HloInstructionProto) GetMantissaBits() int32 {
	if x != nil {
		return x.MantissaBits
	}
	return 0
}

func (x *HloInstructionProto) GetDynamicSliceSizes() []int64 {
	if x != nil {
		return x.DynamicSliceSizes
	}
	return nil
}

func (x *HloInstructionProto) GetPaddingConfig() *xla_data.PaddingConfig {
	if x != nil {
		return x.PaddingConfig
	}
	return nil
}

func (x *HloInstructionProto) GetOutfeedConfig() []byte {
	if x != nil {
		return x.OutfeedConfig
	}
	return nil
}

func (x *HloInstructionProto) GetDistribution() xla_data.RandomDistribution {
	if x != nil {
		return x.Distribution
	}
	return xla_data.RandomDistribution(0)
}

func (x *HloInstructionProto) GetEpsilon() float32 {
	if x != nil {
		return x.Epsilon
	}
	return 0
}

func (x *HloInstructionProto) GetFeatureIndex() int64 {
	if x != nil {
		return x.FeatureIndex
	}
	return 0
}

func (x *HloInstructionProto) GetChannelId() int64 {
	if x != nil {
		return x.ChannelId
	}
	return 0
}

func (x *HloInstructionProto) GetInfeedConfig() []byte {
	if x != nil {
		return x.InfeedConfig
	}
	return nil
}

func (x *HloInstructionProto) GetCustomCallTarget() string {
	if x != nil {
		return x.CustomCallTarget
	}
	return ""
}

func (x *HloInstructionProto) GetOutfeedShape() *xla_data.ShapeProto {
	if x != nil {
		return x.OutfeedShape
	}
	return nil
}

func (x *HloInstructionProto) GetDotDimensionNumbers() *xla_data.DotDimensionNumbers {
	if x != nil {
		return x.DotDimensionNumbers
	}
	return nil
}

func (x *HloInstructionProto) GetRaggedDotDimensionNumbers() *xla_data.RaggedDotDimensionNumbers {
	if x != nil {
		return x.RaggedDotDimensionNumbers
	}
	return nil
}

func (x *HloInstructionProto) GetFftType() xla_data.FftType {
	if x != nil {
		return x.FftType
	}
	return xla_data.FftType(0)
}

func (x *HloInstructionProto) GetFftLength() []int64 {
	if x != nil {
		return x.FftLength
	}
	return nil
}

func (x *HloInstructionProto) GetComparisonDirection() string {
	if x != nil {
		return x.ComparisonDirection
	}
	return ""
}

func (x *HloInstructionProto) GetGatherDimensionNumbers() *xla_data.GatherDimensionNumbers {
	if x != nil {
		return x.GatherDimensionNumbers
	}
	return nil
}

func (x *HloInstructionProto) GetGatherSliceSizes() []int64 {
	if x != nil {
		return x.GatherSliceSizes
	}
	return nil
}

func (x *HloInstructionProto) GetId() int64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *HloInstructionProto) GetOperandIds() []int64 {
	if x != nil {
		return x.OperandIds
	}
	return nil
}

func (x *HloInstructionProto) GetControlPredecessorIds() []int64 {
	if x != nil {
		return x.ControlPredecessorIds
	}
	return nil
}

func (x *HloInstructionProto) GetCalledComputationIds() []int64 {
	if x != nil {
		return x.CalledComputationIds
	}
	return nil
}

func (x *HloInstructionProto) GetSharding() *xla_data.OpSharding {
	if x != nil {
		return x.Sharding
	}
	return nil
}

func (x *HloInstructionProto) GetBackendConfig() []byte {
	if x != nil {
		return x.BackendConfig
	}
	return nil
}

// Deprecated: Marked as deprecated in xla/service/hlo.proto.
func (x *HloInstructionProto) GetReplicaGroups() []*xla_data.ReplicaGroup {
	if x != nil {
		return x.ReplicaGroups
	}
	return nil
}

// Deprecated: Marked as deprecated in xla/service/hlo.proto.
func (x *HloInstructionProto) GetAllReduceId() int64 {
	if x != nil {
		return x.AllReduceId
	}
	return 0
}

func (x *HloInstructionProto) GetUseGlobalDeviceIds() bool {
	if x != nil {
		return x.UseGlobalDeviceIds
	}
	return false
}

func (x *HloInstructionProto) GetIsHostTransfer() bool {
	if x != nil {
		return x.IsHostTransfer
	}
	return false
}

func (x *HloInstructionProto) GetIsStable() bool {
	if x != nil {
		return x.IsStable
	}
	return false
}

func (x *HloInstructionProto) GetScatterDimensionNumbers() *xla_data.ScatterDimensionNumbers {
	if x != nil {
		return x.ScatterDimensionNumbers
	}
	return nil
}

func (x *HloInstructionProto) GetPrecisionConfig() *xla_data.PrecisionConfig {
	if x != nil {
		return x.PrecisionConfig
	}
	return nil
}

func (x *HloInstructionProto) GetSourceTargetPairs() []*xla_data.SourceTarget {
	if x != nil {
		return x.SourceTargetPairs
	}
	return nil
}

func (x *HloInstructionProto) GetDomainEntrySharding() *xla_data.OpSharding {
	if x != nil {
		return x.DomainEntrySharding
	}
	return nil
}

func (x *HloInstructionProto) GetDomainExitSharding() *xla_data.OpSharding {
	if x != nil {
		return x.DomainExitSharding
	}
	return nil
}

func (x *HloInstructionProto) GetConstrainLayout() bool {
	if x != nil {
		return x.ConstrainLayout
	}
	return false
}

func (x *HloInstructionProto) GetOperandShapesWithLayout() []*xla_data.ShapeProto {
	if x != nil {
		return x.OperandShapesWithLayout
	}
	return nil
}

func (x *HloInstructionProto) GetTriangularSolveOptions() *xla_data.TriangularSolveOptions {
	if x != nil {
		return x.TriangularSolveOptions
	}
	return nil
}

func (x *HloInstructionProto) GetCholeskyOptions() *xla_data.CholeskyOptions {
	if x != nil {
		return x.CholeskyOptions
	}
	return nil
}

func (x *HloInstructionProto) GetParameterReplication() *xla_data.ParameterReplication {
	if x != nil {
		return x.ParameterReplication
	}
	return nil
}

func (x *HloInstructionProto) GetCustomCallHasSideEffect() bool {
	if x != nil {
		return x.CustomCallHasSideEffect
	}
	return false
}

func (x *HloInstructionProto) GetOutputOperandAliasing() []*xla_data.OutputOperandAliasing {
	if x != nil {
		return x.OutputOperandAliasing
	}
	return nil
}

func (x *HloInstructionProto) GetCustomCallSchedule() CustomCallSchedule {
	if x != nil {
		return x.CustomCallSchedule
	}
	return CustomCallSchedule_SCHEDULE_NONE
}

func (x *HloInstructionProto) GetDelta() int64 {
	if x != nil {
		return x.Delta
	}
	return 0
}

func (x *HloInstructionProto) GetIndicesAreSorted() bool {
	if x != nil {
		return x.IndicesAreSorted
	}
	return false
}

func (x *HloInstructionProto) GetFrontendAttributes() *xla_data.FrontendAttributes {
	if x != nil {
		return x.FrontendAttributes
	}
	return nil
}

func (x *HloInstructionProto) GetUniqueIndices() bool {
	if x != nil {
		return x.UniqueIndices
	}
	return false
}

func (x *HloInstructionProto) GetRngAlgorithm() xla_data.RandomAlgorithm {
	if x != nil {
		return x.RngAlgorithm
	}
	return xla_data.RandomAlgorithm(0)
}

func (x *HloInstructionProto) GetComparisonType() string {
	if x != nil {
		return x.ComparisonType
	}
	return ""
}

// Deprecated: Marked as deprecated in xla/service/hlo.proto.
func (x *HloInstructionProto) GetIsCrossProgramPrefetch() bool {
	if x != nil {
		return x.IsCrossProgramPrefetch
	}
	return false
}

func (x *HloInstructionProto) GetOptionalCrossProgramPrefetchIndex() isHloInstructionProto_OptionalCrossProgramPrefetchIndex {
	if x != nil {
		return x.OptionalCrossProgramPrefetchIndex
	}
	return nil
}

func (x *HloInstructionProto) GetCrossProgramPrefetchIndex() int32 {
	if x != nil {
		if x, ok := x.OptionalCrossProgramPrefetchIndex.(*HloInstructionProto_CrossProgramPrefetchIndex); ok {
			return x.CrossProgramPrefetchIndex
		}
	}
	return 0
}

func (x *HloInstructionProto) GetPaddingType() xla_data.PaddingType {
	if x != nil {
		return x.PaddingType
	}
	return xla_data.PaddingType(0)
}

func (x *HloInstructionProto) GetCustomCallApiVersion() CustomCallApiVersion {
	if x != nil {
		return x.CustomCallApiVersion
	}
	return CustomCallApiVersion_API_VERSION_UNSPECIFIED
}

func (x *HloInstructionProto) GetAsyncExecutionThread() string {
	if x != nil {
		return x.AsyncExecutionThread
	}
	return ""
}

func (x *HloInstructionProto) GetK() int64 {
	if x != nil {
		return x.K
	}
	return 0
}

func (x *HloInstructionProto) GetLargest() bool {
	if x != nil {
		return x.Largest
	}
	return false
}

func (x *HloInstructionProto) GetStatisticsViz() *xla_data.StatisticsViz {
	if x != nil {
		return x.StatisticsViz
	}
	return nil
}

func (x *HloInstructionProto) GetCollectiveDeviceList() *xla_data.CollectiveDeviceListProto {
	if x != nil {
		return x.CollectiveDeviceList
	}
	return nil
}

func (x *HloInstructionProto) GetOriginalValue() *xla_data.OriginalValueProto {
	if x != nil {
		return x.OriginalValue
	}
	return nil
}

func (x *HloInstructionProto) GetIsComposite() bool {
	if x != nil {
		return x.IsComposite
	}
	return false
}

func (x *HloInstructionProto) GetResultAccuracy() *xla_data.ResultAccuracy {
	if x != nil {
		return x.ResultAccuracy
	}
	return nil
}

type isHloInstructionProto_OptionalCrossProgramPrefetchIndex interface {
	isHloInstructionProto_OptionalCrossProgramPrefetchIndex()
}

type HloInstructionProto_CrossProgramPrefetchIndex struct {
	CrossProgramPrefetchIndex int32 `protobuf:"varint,80,opt,name=cross_program_prefetch_index,json=crossProgramPrefetchIndex,proto3,oneof"`
}

func (*HloInstructionProto_CrossProgramPrefetchIndex) isHloInstructionProto_OptionalCrossProgramPrefetchIndex() {
}

// Serialization of HloComputation.
type HloComputationProto struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Name  string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The array of instructions is always in a valid dependency order, where
	// operands appear before their users.
	Instructions []*HloInstructionProto      `protobuf:"bytes,2,rep,name=instructions,proto3" json:"instructions,omitempty"`
	ProgramShape *xla_data.ProgramShapeProto `protobuf:"bytes,4,opt,name=program_shape,json=programShape,proto3" json:"program_shape,omitempty"`
	// The id of this computation.
	Id int64 `protobuf:"varint,5,opt,name=id,proto3" json:"id,omitempty"`
	// The id of the root of the computation.
	RootId int64 `protobuf:"varint,6,opt,name=root_id,json=rootId,proto3" json:"root_id,omitempty"`
	// Whether this is a fusion computation. Fusion computations should use this
	// to determine whether they are a fusion in CreateFromProto since the
	// parent fusion_instruction_ may get removed and be nullptr.
	IsFusionComputation bool `protobuf:"varint,7,opt,name=is_fusion_computation,json=isFusionComputation,proto3" json:"is_fusion_computation,omitempty"`
	// The name of execution thread this computation belongs to.
	ExecutionThread string `protobuf:"bytes,8,opt,name=execution_thread,json=executionThread,proto3" json:"execution_thread,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *HloComputationProto) Reset() {
	*x = HloComputationProto{}
	mi := &file_xla_service_hlo_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HloComputationProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HloComputationProto) ProtoMessage() {}

func (x *HloComputationProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HloComputationProto.ProtoReflect.Descriptor instead.
func (*HloComputationProto) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{1}
}

func (x *HloComputationProto) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HloComputationProto) GetInstructions() []*HloInstructionProto {
	if x != nil {
		return x.Instructions
	}
	return nil
}

func (x *HloComputationProto) GetProgramShape() *xla_data.ProgramShapeProto {
	if x != nil {
		return x.ProgramShape
	}
	return nil
}

func (x *HloComputationProto) GetId() int64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *HloComputationProto) GetRootId() int64 {
	if x != nil {
		return x.RootId
	}
	return 0
}

func (x *HloComputationProto) GetIsFusionComputation() bool {
	if x != nil {
		return x.IsFusionComputation
	}
	return false
}

func (x *HloComputationProto) GetExecutionThread() string {
	if x != nil {
		return x.ExecutionThread
	}
	return ""
}

// Serialization of an HLO schedule. An HLO schedule contains a total order of
// instructions for each non-fusion computation in the module.
type HloScheduleProto struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Map from computation id to sequence.
	Sequences     map[int64]*HloScheduleProto_InstructionSequence `protobuf:"bytes,1,rep,name=sequences,proto3" json:"sequences,omitempty" protobuf_key:"varint,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HloScheduleProto) Reset() {
	*x = HloScheduleProto{}
	mi := &file_xla_service_hlo_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HloScheduleProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HloScheduleProto) ProtoMessage() {}

func (x *HloScheduleProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HloScheduleProto.ProtoReflect.Descriptor instead.
func (*HloScheduleProto) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{2}
}

func (x *HloScheduleProto) GetSequences() map[int64]*HloScheduleProto_InstructionSequence {
	if x != nil {
		return x.Sequences
	}
	return nil
}

type HloInputOutputAliasProto struct {
	state         protoimpl.MessageState                      `protogen:"open.v1"`
	Entries       []*HloInputOutputAliasProto_AliasEntryProto `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HloInputOutputAliasProto) Reset() {
	*x = HloInputOutputAliasProto{}
	mi := &file_xla_service_hlo_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HloInputOutputAliasProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HloInputOutputAliasProto) ProtoMessage() {}

func (x *HloInputOutputAliasProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HloInputOutputAliasProto.ProtoReflect.Descriptor instead.
func (*HloInputOutputAliasProto) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{3}
}

func (x *HloInputOutputAliasProto) GetEntries() []*HloInputOutputAliasProto_AliasEntryProto {
	if x != nil {
		return x.Entries
	}
	return nil
}

type HloBufferDonorProto struct {
	state         protoimpl.MessageState                       `protogen:"open.v1"`
	Entries       []*HloBufferDonorProto_BufferDonorEntryProto `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HloBufferDonorProto) Reset() {
	*x = HloBufferDonorProto{}
	mi := &file_xla_service_hlo_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HloBufferDonorProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HloBufferDonorProto) ProtoMessage() {}

func (x *HloBufferDonorProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HloBufferDonorProto.ProtoReflect.Descriptor instead.
func (*HloBufferDonorProto) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{4}
}

func (x *HloBufferDonorProto) GetEntries() []*HloBufferDonorProto_BufferDonorEntryProto {
	if x != nil {
		return x.Entries
	}
	return nil
}

type CrossProgramPrefetch struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Parameter     int64                  `protobuf:"varint,1,opt,name=parameter,proto3" json:"parameter,omitempty"`
	Index         []int64                `protobuf:"varint,2,rep,packed,name=index,proto3" json:"index,omitempty"`
	Offset        int64                  `protobuf:"varint,3,opt,name=offset,proto3" json:"offset,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CrossProgramPrefetch) Reset() {
	*x = CrossProgramPrefetch{}
	mi := &file_xla_service_hlo_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CrossProgramPrefetch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CrossProgramPrefetch) ProtoMessage() {}

func (x *CrossProgramPrefetch) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CrossProgramPrefetch.ProtoReflect.Descriptor instead.
func (*CrossProgramPrefetch) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{5}
}

func (x *CrossProgramPrefetch) GetParameter() int64 {
	if x != nil {
		return x.Parameter
	}
	return 0
}

func (x *CrossProgramPrefetch) GetIndex() []int64 {
	if x != nil {
		return x.Index
	}
	return nil
}

func (x *CrossProgramPrefetch) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

// Serialization of stack frames index representations.
// Stack frames index presented in four flat arrays:
// 1. File names array.
// 2. Function names array.
// 3. File location array.
// 4. Frame array.
// All reference ids in sub-protos are 1-based positions of the
// entity in the flat array.
// Ids are 1-based to keep 0 value as representation of non-set property.
type StackFrameIndexProto struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Flat index array of file names.
	FileNames []string `protobuf:"bytes,1,rep,name=file_names,json=fileNames,proto3" json:"file_names,omitempty"`
	// Flat index array of function names.
	FunctionNames []string `protobuf:"bytes,2,rep,name=function_names,json=functionNames,proto3" json:"function_names,omitempty"`
	// Flat index array of file locations.
	FileLocations []*StackFrameIndexProto_FileLocation `protobuf:"bytes,3,rep,name=file_locations,json=fileLocations,proto3" json:"file_locations,omitempty"`
	// Flat index array of frames.
	StackFrames   []*StackFrameIndexProto_StackFrame `protobuf:"bytes,4,rep,name=stack_frames,json=stackFrames,proto3" json:"stack_frames,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StackFrameIndexProto) Reset() {
	*x = StackFrameIndexProto{}
	mi := &file_xla_service_hlo_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StackFrameIndexProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StackFrameIndexProto) ProtoMessage() {}

func (x *StackFrameIndexProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StackFrameIndexProto.ProtoReflect.Descriptor instead.
func (*StackFrameIndexProto) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{6}
}

func (x *StackFrameIndexProto) GetFileNames() []string {
	if x != nil {
		return x.FileNames
	}
	return nil
}

func (x *StackFrameIndexProto) GetFunctionNames() []string {
	if x != nil {
		return x.FunctionNames
	}
	return nil
}

func (x *StackFrameIndexProto) GetFileLocations() []*StackFrameIndexProto_FileLocation {
	if x != nil {
		return x.FileLocations
	}
	return nil
}

func (x *StackFrameIndexProto) GetStackFrames() []*StackFrameIndexProto_StackFrame {
	if x != nil {
		return x.StackFrames
	}
	return nil
}

// Serialization of HloModule.
type HloModuleProto struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	Name                 string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	EntryComputationName string                 `protobuf:"bytes,2,opt,name=entry_computation_name,json=entryComputationName,proto3" json:"entry_computation_name,omitempty"`
	EntryComputationId   int64                  `protobuf:"varint,6,opt,name=entry_computation_id,json=entryComputationId,proto3" json:"entry_computation_id,omitempty"`
	// The array of computations is always in a valid dependency order, where
	// callees appear before their callers.
	Computations []*HloComputationProto `protobuf:"bytes,3,rep,name=computations,proto3" json:"computations,omitempty"`
	// The host program shape (with layout) of the entry computation.
	HostProgramShape *xla_data.ProgramShapeProto `protobuf:"bytes,4,opt,name=host_program_shape,json=hostProgramShape,proto3" json:"host_program_shape,omitempty"`
	// The id of this module.
	Id int64 `protobuf:"varint,5,opt,name=id,proto3" json:"id,omitempty"`
	// The schedule for this module.
	Schedule *HloScheduleProto `protobuf:"bytes,7,opt,name=schedule,proto3" json:"schedule,omitempty"`
	// Describes alias information between inputs and outputs.
	InputOutputAlias *HloInputOutputAliasProto `protobuf:"bytes,8,opt,name=input_output_alias,json=inputOutputAlias,proto3" json:"input_output_alias,omitempty"`
	// Describes the information of input buffer donors.
	BufferDonor            *HloBufferDonorProto    `protobuf:"bytes,18,opt,name=buffer_donor,json=bufferDonor,proto3" json:"buffer_donor,omitempty"`
	CrossProgramPrefetches []*CrossProgramPrefetch `protobuf:"bytes,10,rep,name=cross_program_prefetches,json=crossProgramPrefetches,proto3" json:"cross_program_prefetches,omitempty"`
	// True if the module contains dynamic computation.
	IsDynamic               bool                   `protobuf:"varint,11,opt,name=is_dynamic,json=isDynamic,proto3" json:"is_dynamic,omitempty"`
	SpmdOutputSharding      *xla_data.OpSharding   `protobuf:"bytes,12,opt,name=spmd_output_sharding,json=spmdOutputSharding,proto3" json:"spmd_output_sharding,omitempty"`
	SpmdParametersShardings []*xla_data.OpSharding `protobuf:"bytes,14,rep,name=spmd_parameters_shardings,json=spmdParametersShardings,proto3" json:"spmd_parameters_shardings,omitempty"`
	// Uses AutoSharding pass or not.
	UseAutoSpmdPartitioning bool `protobuf:"varint,16,opt,name=use_auto_spmd_partitioning,json=useAutoSpmdPartitioning,proto3" json:"use_auto_spmd_partitioning,omitempty"`
	// Profile information for the HLO module.
	ProfileInfo []*HloModuleProto_ProfileInfo `protobuf:"bytes,13,rep,name=profile_info,json=profileInfo,proto3" json:"profile_info,omitempty"`
	// DeviceAssignment object information.
	DeviceAssignment *xla_data.DeviceAssignmentProto `protobuf:"bytes,15,opt,name=device_assignment,json=deviceAssignment,proto3" json:"device_assignment,omitempty"`
	// Stack frames index.
	StackFrameIndex *StackFrameIndexProto `protobuf:"bytes,17,opt,name=stack_frame_index,json=stackFrameIndex,proto3" json:"stack_frame_index,omitempty"`
	// Frontend attributes to pass to the XLA backend.
	FrontendAttributes         *xla_data.FrontendAttributes     `protobuf:"bytes,19,opt,name=frontend_attributes,json=frontendAttributes,proto3" json:"frontend_attributes,omitempty"`
	OriginalValueRecoveryTable *OriginalValueRecoveryTableProto `protobuf:"bytes,20,opt,name=original_value_recovery_table,json=originalValueRecoveryTable,proto3" json:"original_value_recovery_table,omitempty"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *HloModuleProto) Reset() {
	*x = HloModuleProto{}
	mi := &file_xla_service_hlo_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HloModuleProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HloModuleProto) ProtoMessage() {}

func (x *HloModuleProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HloModuleProto.ProtoReflect.Descriptor instead.
func (*HloModuleProto) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{7}
}

func (x *HloModuleProto) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HloModuleProto) GetEntryComputationName() string {
	if x != nil {
		return x.EntryComputationName
	}
	return ""
}

func (x *HloModuleProto) GetEntryComputationId() int64 {
	if x != nil {
		return x.EntryComputationId
	}
	return 0
}

func (x *HloModuleProto) GetComputations() []*HloComputationProto {
	if x != nil {
		return x.Computations
	}
	return nil
}

func (x *HloModuleProto) GetHostProgramShape() *xla_data.ProgramShapeProto {
	if x != nil {
		return x.HostProgramShape
	}
	return nil
}

func (x *HloModuleProto) GetId() int64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *HloModuleProto) GetSchedule() *HloScheduleProto {
	if x != nil {
		return x.Schedule
	}
	return nil
}

func (x *HloModuleProto) GetInputOutputAlias() *HloInputOutputAliasProto {
	if x != nil {
		return x.InputOutputAlias
	}
	return nil
}

func (x *HloModuleProto) GetBufferDonor() *HloBufferDonorProto {
	if x != nil {
		return x.BufferDonor
	}
	return nil
}

func (x *HloModuleProto) GetCrossProgramPrefetches() []*CrossProgramPrefetch {
	if x != nil {
		return x.CrossProgramPrefetches
	}
	return nil
}

func (x *HloModuleProto) GetIsDynamic() bool {
	if x != nil {
		return x.IsDynamic
	}
	return false
}

func (x *HloModuleProto) GetSpmdOutputSharding() *xla_data.OpSharding {
	if x != nil {
		return x.SpmdOutputSharding
	}
	return nil
}

func (x *HloModuleProto) GetSpmdParametersShardings() []*xla_data.OpSharding {
	if x != nil {
		return x.SpmdParametersShardings
	}
	return nil
}

func (x *HloModuleProto) GetUseAutoSpmdPartitioning() bool {
	if x != nil {
		return x.UseAutoSpmdPartitioning
	}
	return false
}

func (x *HloModuleProto) GetProfileInfo() []*HloModuleProto_ProfileInfo {
	if x != nil {
		return x.ProfileInfo
	}
	return nil
}

func (x *HloModuleProto) GetDeviceAssignment() *xla_data.DeviceAssignmentProto {
	if x != nil {
		return x.DeviceAssignment
	}
	return nil
}

func (x *HloModuleProto) GetStackFrameIndex() *StackFrameIndexProto {
	if x != nil {
		return x.StackFrameIndex
	}
	return nil
}

func (x *HloModuleProto) GetFrontendAttributes() *xla_data.FrontendAttributes {
	if x != nil {
		return x.FrontendAttributes
	}
	return nil
}

func (x *HloModuleProto) GetOriginalValueRecoveryTable() *OriginalValueRecoveryTableProto {
	if x != nil {
		return x.OriginalValueRecoveryTable
	}
	return nil
}

// Serialization of LogicalBuffer.
type LogicalBufferProto struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Id    int64                  `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Size  int64                  `protobuf:"varint,2,opt,name=size,proto3" json:"size,omitempty"`
	// The location where the buffer is defined.
	DefinedAt     *LogicalBufferProto_Location `protobuf:"bytes,3,opt,name=defined_at,json=definedAt,proto3" json:"defined_at,omitempty"`
	Color         int64                        `protobuf:"varint,4,opt,name=color,proto3" json:"color,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LogicalBufferProto) Reset() {
	*x = LogicalBufferProto{}
	mi := &file_xla_service_hlo_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogicalBufferProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogicalBufferProto) ProtoMessage() {}

func (x *LogicalBufferProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogicalBufferProto.ProtoReflect.Descriptor instead.
func (*LogicalBufferProto) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{8}
}

func (x *LogicalBufferProto) GetId() int64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *LogicalBufferProto) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *LogicalBufferProto) GetDefinedAt() *LogicalBufferProto_Location {
	if x != nil {
		return x.DefinedAt
	}
	return nil
}

func (x *LogicalBufferProto) GetColor() int64 {
	if x != nil {
		return x.Color
	}
	return 0
}

// Serialization of BufferAllocation.
type BufferAllocationProto struct {
	state                        protoimpl.MessageState            `protogen:"open.v1"`
	Index                        int64                             `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
	Size                         int64                             `protobuf:"varint,2,opt,name=size,proto3" json:"size,omitempty"`
	IsThreadLocal                bool                              `protobuf:"varint,3,opt,name=is_thread_local,json=isThreadLocal,proto3" json:"is_thread_local,omitempty"`
	IsTuple                      bool                              `protobuf:"varint,11,opt,name=is_tuple,json=isTuple,proto3" json:"is_tuple,omitempty"`
	IsEntryComputationParameter  bool                              `protobuf:"varint,5,opt,name=is_entry_computation_parameter,json=isEntryComputationParameter,proto3" json:"is_entry_computation_parameter,omitempty"`
	IsConstant                   bool                              `protobuf:"varint,12,opt,name=is_constant,json=isConstant,proto3" json:"is_constant,omitempty"`
	ParameterNumber              int64                             `protobuf:"varint,6,opt,name=parameter_number,json=parameterNumber,proto3" json:"parameter_number,omitempty"`
	ParameterShapeIndex          []int64                           `protobuf:"varint,10,rep,packed,name=parameter_shape_index,json=parameterShapeIndex,proto3" json:"parameter_shape_index,omitempty"`
	IsParameterAliasedWithOutput bool                              `protobuf:"varint,13,opt,name=is_parameter_aliased_with_output,json=isParameterAliasedWithOutput,proto3" json:"is_parameter_aliased_with_output,omitempty"`
	MaybeLiveOut                 bool                              `protobuf:"varint,7,opt,name=maybe_live_out,json=maybeLiveOut,proto3" json:"maybe_live_out,omitempty"`
	Color                        int64                             `protobuf:"varint,8,opt,name=color,proto3" json:"color,omitempty"`
	Assigned                     []*BufferAllocationProto_Assigned `protobuf:"bytes,9,rep,name=assigned,proto3" json:"assigned,omitempty"`
	unknownFields                protoimpl.UnknownFields
	sizeCache                    protoimpl.SizeCache
}

func (x *BufferAllocationProto) Reset() {
	*x = BufferAllocationProto{}
	mi := &file_xla_service_hlo_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BufferAllocationProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BufferAllocationProto) ProtoMessage() {}

func (x *BufferAllocationProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BufferAllocationProto.ProtoReflect.Descriptor instead.
func (*BufferAllocationProto) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{9}
}

func (x *BufferAllocationProto) GetIndex() int64 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *BufferAllocationProto) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *BufferAllocationProto) GetIsThreadLocal() bool {
	if x != nil {
		return x.IsThreadLocal
	}
	return false
}

func (x *BufferAllocationProto) GetIsTuple() bool {
	if x != nil {
		return x.IsTuple
	}
	return false
}

func (x *BufferAllocationProto) GetIsEntryComputationParameter() bool {
	if x != nil {
		return x.IsEntryComputationParameter
	}
	return false
}

func (x *BufferAllocationProto) GetIsConstant() bool {
	if x != nil {
		return x.IsConstant
	}
	return false
}

func (x *BufferAllocationProto) GetParameterNumber() int64 {
	if x != nil {
		return x.ParameterNumber
	}
	return 0
}

func (x *BufferAllocationProto) GetParameterShapeIndex() []int64 {
	if x != nil {
		return x.ParameterShapeIndex
	}
	return nil
}

func (x *BufferAllocationProto) GetIsParameterAliasedWithOutput() bool {
	if x != nil {
		return x.IsParameterAliasedWithOutput
	}
	return false
}

func (x *BufferAllocationProto) GetMaybeLiveOut() bool {
	if x != nil {
		return x.MaybeLiveOut
	}
	return false
}

func (x *BufferAllocationProto) GetColor() int64 {
	if x != nil {
		return x.Color
	}
	return 0
}

func (x *BufferAllocationProto) GetAssigned() []*BufferAllocationProto_Assigned {
	if x != nil {
		return x.Assigned
	}
	return nil
}

// A trace of a HeapSimulator run.
type HeapSimulatorTrace struct {
	state                 protoimpl.MessageState      `protogen:"open.v1"`
	Events                []*HeapSimulatorTrace_Event `protobuf:"bytes,1,rep,name=events,proto3" json:"events,omitempty"`
	WholeModuleSimulation bool                        `protobuf:"varint,2,opt,name=whole_module_simulation,json=wholeModuleSimulation,proto3" json:"whole_module_simulation,omitempty"`
	BufferAllocationIndex int64                       `protobuf:"varint,3,opt,name=buffer_allocation_index,json=bufferAllocationIndex,proto3" json:"buffer_allocation_index,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *HeapSimulatorTrace) Reset() {
	*x = HeapSimulatorTrace{}
	mi := &file_xla_service_hlo_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HeapSimulatorTrace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeapSimulatorTrace) ProtoMessage() {}

func (x *HeapSimulatorTrace) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeapSimulatorTrace.ProtoReflect.Descriptor instead.
func (*HeapSimulatorTrace) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{10}
}

func (x *HeapSimulatorTrace) GetEvents() []*HeapSimulatorTrace_Event {
	if x != nil {
		return x.Events
	}
	return nil
}

func (x *HeapSimulatorTrace) GetWholeModuleSimulation() bool {
	if x != nil {
		return x.WholeModuleSimulation
	}
	return false
}

func (x *HeapSimulatorTrace) GetBufferAllocationIndex() int64 {
	if x != nil {
		return x.BufferAllocationIndex
	}
	return 0
}

// An abstraction representing a set of HLO module built to run concurrently
// across different devices.
type HloModuleGroupProto struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Name          string                 `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	HloModules    []*HloModuleProto      `protobuf:"bytes,2,rep,name=hlo_modules,json=hloModules,proto3" json:"hlo_modules,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HloModuleGroupProto) Reset() {
	*x = HloModuleGroupProto{}
	mi := &file_xla_service_hlo_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HloModuleGroupProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HloModuleGroupProto) ProtoMessage() {}

func (x *HloModuleGroupProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HloModuleGroupProto.ProtoReflect.Descriptor instead.
func (*HloModuleGroupProto) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{11}
}

func (x *HloModuleGroupProto) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HloModuleGroupProto) GetHloModules() []*HloModuleProto {
	if x != nil {
		return x.HloModules
	}
	return nil
}

// Serialization of BufferAssignment.
type BufferAssignmentProto struct {
	state               protoimpl.MessageState               `protogen:"open.v1"`
	LogicalBuffers      []*LogicalBufferProto                `protobuf:"bytes,1,rep,name=logical_buffers,json=logicalBuffers,proto3" json:"logical_buffers,omitempty"`
	BufferAliases       []*BufferAssignmentProto_BufferAlias `protobuf:"bytes,2,rep,name=buffer_aliases,json=bufferAliases,proto3" json:"buffer_aliases,omitempty"`
	BufferAllocations   []*BufferAllocationProto             `protobuf:"bytes,3,rep,name=buffer_allocations,json=bufferAllocations,proto3" json:"buffer_allocations,omitempty"`
	HeapSimulatorTraces []*HeapSimulatorTrace                `protobuf:"bytes,4,rep,name=heap_simulator_traces,json=heapSimulatorTraces,proto3" json:"heap_simulator_traces,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *BufferAssignmentProto) Reset() {
	*x = BufferAssignmentProto{}
	mi := &file_xla_service_hlo_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BufferAssignmentProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BufferAssignmentProto) ProtoMessage() {}

func (x *BufferAssignmentProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BufferAssignmentProto.ProtoReflect.Descriptor instead.
func (*BufferAssignmentProto) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{12}
}

func (x *BufferAssignmentProto) GetLogicalBuffers() []*LogicalBufferProto {
	if x != nil {
		return x.LogicalBuffers
	}
	return nil
}

func (x *BufferAssignmentProto) GetBufferAliases() []*BufferAssignmentProto_BufferAlias {
	if x != nil {
		return x.BufferAliases
	}
	return nil
}

func (x *BufferAssignmentProto) GetBufferAllocations() []*BufferAllocationProto {
	if x != nil {
		return x.BufferAllocations
	}
	return nil
}

func (x *BufferAssignmentProto) GetHeapSimulatorTraces() []*HeapSimulatorTrace {
	if x != nil {
		return x.HeapSimulatorTraces
	}
	return nil
}

// Grouping message that contains all of the information above.
type HloProto struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	HloModule        *HloModuleProto        `protobuf:"bytes,1,opt,name=hlo_module,json=hloModule,proto3" json:"hlo_module,omitempty"`
	BufferAssignment *BufferAssignmentProto `protobuf:"bytes,3,opt,name=buffer_assignment,json=bufferAssignment,proto3" json:"buffer_assignment,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *HloProto) Reset() {
	*x = HloProto{}
	mi := &file_xla_service_hlo_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HloProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HloProto) ProtoMessage() {}

func (x *HloProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HloProto.ProtoReflect.Descriptor instead.
func (*HloProto) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{13}
}

func (x *HloProto) GetHloModule() *HloModuleProto {
	if x != nil {
		return x.HloModule
	}
	return nil
}

func (x *HloProto) GetBufferAssignment() *BufferAssignmentProto {
	if x != nil {
		return x.BufferAssignment
	}
	return nil
}

// Encapsulates HloProto together with the arguments, result, and
// execution_platform. This message is used for purposes such as
// analysis/replay/file-storage.
type HloSnapshot struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The hlo graph.
	Hlo *HloProto `protobuf:"bytes,1,opt,name=hlo,proto3" json:"hlo,omitempty"`
	// The arguments passed to the graph.
	Arguments []*xla_data.LiteralProto `protobuf:"bytes,2,rep,name=arguments,proto3" json:"arguments,omitempty"`
	// The result of the graph.
	Result *xla_data.LiteralProto `protobuf:"bytes,3,opt,name=result,proto3" json:"result,omitempty"`
	// The name of the platform used to run the graph.
	ExecutionPlatform string `protobuf:"bytes,4,opt,name=execution_platform,json=executionPlatform,proto3" json:"execution_platform,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *HloSnapshot) Reset() {
	*x = HloSnapshot{}
	mi := &file_xla_service_hlo_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HloSnapshot) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HloSnapshot) ProtoMessage() {}

func (x *HloSnapshot) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HloSnapshot.ProtoReflect.Descriptor instead.
func (*HloSnapshot) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{14}
}

func (x *HloSnapshot) GetHlo() *HloProto {
	if x != nil {
		return x.Hlo
	}
	return nil
}

func (x *HloSnapshot) GetArguments() []*xla_data.LiteralProto {
	if x != nil {
		return x.Arguments
	}
	return nil
}

func (x *HloSnapshot) GetResult() *xla_data.LiteralProto {
	if x != nil {
		return x.Result
	}
	return nil
}

func (x *HloSnapshot) GetExecutionPlatform() string {
	if x != nil {
		return x.ExecutionPlatform
	}
	return ""
}

type HloInputs struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Only one of the following two fields is expected to be set. `arguments`
	// stores the literals, when `arguments_descriptors` stores only the
	// information required to decode the literals. This was introduced to bypass
	// the 2GiB limitation on proto size.
	Arguments            []*xla_data.LiteralProto       `protobuf:"bytes,1,rep,name=arguments,proto3" json:"arguments,omitempty"`
	ArgumentsDescriptors []*HloInputs_LiteralDescriptor `protobuf:"bytes,2,rep,name=arguments_descriptors,json=argumentsDescriptors,proto3" json:"arguments_descriptors,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *HloInputs) Reset() {
	*x = HloInputs{}
	mi := &file_xla_service_hlo_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HloInputs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HloInputs) ProtoMessage() {}

func (x *HloInputs) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HloInputs.ProtoReflect.Descriptor instead.
func (*HloInputs) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{15}
}

func (x *HloInputs) GetArguments() []*xla_data.LiteralProto {
	if x != nil {
		return x.Arguments
	}
	return nil
}

func (x *HloInputs) GetArgumentsDescriptors() []*HloInputs_LiteralDescriptor {
	if x != nil {
		return x.ArgumentsDescriptors
	}
	return nil
}

type HloUnoptimizedSnapshot struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The unoptimized hlo graph.
	HloModule     *HloModuleProto `protobuf:"bytes,1,opt,name=hlo_module,json=hloModule,proto3" json:"hlo_module,omitempty"`
	Partitions    []*HloInputs    `protobuf:"bytes,2,rep,name=partitions,proto3" json:"partitions,omitempty"`
	Version       int32           `protobuf:"varint,3,opt,name=version,proto3" json:"version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HloUnoptimizedSnapshot) Reset() {
	*x = HloUnoptimizedSnapshot{}
	mi := &file_xla_service_hlo_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HloUnoptimizedSnapshot) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HloUnoptimizedSnapshot) ProtoMessage() {}

func (x *HloUnoptimizedSnapshot) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HloUnoptimizedSnapshot.ProtoReflect.Descriptor instead.
func (*HloUnoptimizedSnapshot) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{16}
}

func (x *HloUnoptimizedSnapshot) GetHloModule() *HloModuleProto {
	if x != nil {
		return x.HloModule
	}
	return nil
}

func (x *HloUnoptimizedSnapshot) GetPartitions() []*HloInputs {
	if x != nil {
		return x.Partitions
	}
	return nil
}

func (x *HloUnoptimizedSnapshot) GetVersion() int32 {
	if x != nil {
		return x.Version
	}
	return 0
}

// Metadata for an HLO module. Dumped after HLO passes and before LLO lowering
// with filename module_####.metadata.textproto, where #### is
// canonical_module_id.
type HloModuleMetadataProto struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Uniquely identifies an HloModuleMetadata. Equal to the first unique_id
	// of the module (a module may go through multiple unique_ids). If a module
	// is partitioned into multiple modules, those modules will each have a new
	// HloModuleMetadata with a different canonical_module_id.
	CanonicalModuleId int64 `protobuf:"varint,1,opt,name=canonical_module_id,json=canonicalModuleId,proto3" json:"canonical_module_id,omitempty"`
	// Name of the module group that the module is part of.
	ModuleGroupName string `protobuf:"bytes,2,opt,name=module_group_name,json=moduleGroupName,proto3" json:"module_group_name,omitempty"`
	// The canonical module id of the module that this one is partitioned from,
	// if applicable.
	OriginalModuleId int64 `protobuf:"varint,3,opt,name=original_module_id,json=originalModuleId,proto3" json:"original_module_id,omitempty"`
	// The canonical module ids of the modules that this one is partitioned into,
	// if applicable.
	PartitionedModuleIds []int64 `protobuf:"varint,4,rep,packed,name=partitioned_module_ids,json=partitionedModuleIds,proto3" json:"partitioned_module_ids,omitempty"`
	// Metadata for the HLO passes that are run on the module.
	PassMetadata  []*HloPassMetadata `protobuf:"bytes,5,rep,name=pass_metadata,json=passMetadata,proto3" json:"pass_metadata,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HloModuleMetadataProto) Reset() {
	*x = HloModuleMetadataProto{}
	mi := &file_xla_service_hlo_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HloModuleMetadataProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HloModuleMetadataProto) ProtoMessage() {}

func (x *HloModuleMetadataProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HloModuleMetadataProto.ProtoReflect.Descriptor instead.
func (*HloModuleMetadataProto) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{17}
}

func (x *HloModuleMetadataProto) GetCanonicalModuleId() int64 {
	if x != nil {
		return x.CanonicalModuleId
	}
	return 0
}

func (x *HloModuleMetadataProto) GetModuleGroupName() string {
	if x != nil {
		return x.ModuleGroupName
	}
	return ""
}

func (x *HloModuleMetadataProto) GetOriginalModuleId() int64 {
	if x != nil {
		return x.OriginalModuleId
	}
	return 0
}

func (x *HloModuleMetadataProto) GetPartitionedModuleIds() []int64 {
	if x != nil {
		return x.PartitionedModuleIds
	}
	return nil
}

func (x *HloModuleMetadataProto) GetPassMetadata() []*HloPassMetadata {
	if x != nil {
		return x.PassMetadata
	}
	return nil
}

// Metadata for one run of an HLO pass on a module. Provides more information
// when processing debug dumps of HloProtos about the order of HLO passes and
// various other stats like duration. `pass_id` may also be used to identify a
// particular run of a pass in debug info that propagates through stages of
// compilation.
type HloPassMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// For a given module, pass_id uniquely identifies a run of an HLO pass on
	// that module. Note that a pass_id may not always refer to the same pass
	// because the order of passes during compilation may change. For finding
	// metadata for a particular pass, pass_name and pipeline_name would be more
	// reliable, although note that they may not be unique.
	PassId       int64  `protobuf:"varint,1,opt,name=pass_id,json=passId,proto3" json:"pass_id,omitempty"`
	PassName     string `protobuf:"bytes,2,opt,name=pass_name,json=passName,proto3" json:"pass_name,omitempty"`
	PipelineName string `protobuf:"bytes,3,opt,name=pipeline_name,json=pipelineName,proto3" json:"pipeline_name,omitempty"`
	// Filenames of the dumps of the module after this pass ran. Module may be
	// dumped in multiple formats, and the order of formats in this field will
	// stay consistent across passes.
	DumpFilenames []string `protobuf:"bytes,4,rep,name=dump_filenames,json=dumpFilenames,proto3" json:"dump_filenames,omitempty"`
	// Return value of pass.Run(). True if this pass changed the module, or, in
	// the case where the module was run through this pass as part of a module
	// group, true if this pass changed any module in the same module group.
	ModuleChanged bool `protobuf:"varint,5,opt,name=module_changed,json=moduleChanged,proto3" json:"module_changed,omitempty"`
	// The unique_id of the module that this pass is run on. May be different from
	// the canonical_module_id of the HloModuleMetadata that this HloPassMetadata
	// is inside.
	ModuleId int64 `protobuf:"varint,6,opt,name=module_id,json=moduleId,proto3" json:"module_id,omitempty"`
	// If the module went through this pass as part of a module group, this is
	// set as the ids of all the modules in the module group. Empty otherwise.
	ModuleGroupModuleIds []int64 `protobuf:"varint,7,rep,packed,name=module_group_module_ids,json=moduleGroupModuleIds,proto3" json:"module_group_module_ids,omitempty"`
	// Timestamp before and after the pass is run. Note they may be equal.
	StartTimestampUsec int64 `protobuf:"varint,8,opt,name=start_timestamp_usec,json=startTimestampUsec,proto3" json:"start_timestamp_usec,omitempty"`
	EndTimestampUsec   int64 `protobuf:"varint,9,opt,name=end_timestamp_usec,json=endTimestampUsec,proto3" json:"end_timestamp_usec,omitempty"`
	// Custom metadata for the pass.
	CustomMetadata *anypb.Any `protobuf:"bytes,10,opt,name=custom_metadata,json=customMetadata,proto3" json:"custom_metadata,omitempty"`
	// Used to log any number of key, value pair stats per pass.
	KvMetrics     []*metrics.KeyValueMetric `protobuf:"bytes,11,rep,name=kv_metrics,json=kvMetrics,proto3" json:"kv_metrics,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HloPassMetadata) Reset() {
	*x = HloPassMetadata{}
	mi := &file_xla_service_hlo_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HloPassMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HloPassMetadata) ProtoMessage() {}

func (x *HloPassMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HloPassMetadata.ProtoReflect.Descriptor instead.
func (*HloPassMetadata) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{18}
}

func (x *HloPassMetadata) GetPassId() int64 {
	if x != nil {
		return x.PassId
	}
	return 0
}

func (x *HloPassMetadata) GetPassName() string {
	if x != nil {
		return x.PassName
	}
	return ""
}

func (x *HloPassMetadata) GetPipelineName() string {
	if x != nil {
		return x.PipelineName
	}
	return ""
}

func (x *HloPassMetadata) GetDumpFilenames() []string {
	if x != nil {
		return x.DumpFilenames
	}
	return nil
}

func (x *HloPassMetadata) GetModuleChanged() bool {
	if x != nil {
		return x.ModuleChanged
	}
	return false
}

func (x *HloPassMetadata) GetModuleId() int64 {
	if x != nil {
		return x.ModuleId
	}
	return 0
}

func (x *HloPassMetadata) GetModuleGroupModuleIds() []int64 {
	if x != nil {
		return x.ModuleGroupModuleIds
	}
	return nil
}

func (x *HloPassMetadata) GetStartTimestampUsec() int64 {
	if x != nil {
		return x.StartTimestampUsec
	}
	return 0
}

func (x *HloPassMetadata) GetEndTimestampUsec() int64 {
	if x != nil {
		return x.EndTimestampUsec
	}
	return 0
}

func (x *HloPassMetadata) GetCustomMetadata() *anypb.Any {
	if x != nil {
		return x.CustomMetadata
	}
	return nil
}

func (x *HloPassMetadata) GetKvMetrics() []*metrics.KeyValueMetric {
	if x != nil {
		return x.KvMetrics
	}
	return nil
}

type OriginalValueRecoveryTableProto struct {
	state         protoimpl.MessageState                   `protogen:"open.v1"`
	Entries       []*OriginalValueRecoveryTableProto_Entry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OriginalValueRecoveryTableProto) Reset() {
	*x = OriginalValueRecoveryTableProto{}
	mi := &file_xla_service_hlo_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OriginalValueRecoveryTableProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OriginalValueRecoveryTableProto) ProtoMessage() {}

func (x *OriginalValueRecoveryTableProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OriginalValueRecoveryTableProto.ProtoReflect.Descriptor instead.
func (*OriginalValueRecoveryTableProto) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{19}
}

func (x *OriginalValueRecoveryTableProto) GetEntries() []*OriginalValueRecoveryTableProto_Entry {
	if x != nil {
		return x.Entries
	}
	return nil
}

// Describes the [begin, end) index range and stride for slices.
type HloInstructionProto_SliceDimensions struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Start         int64                  `protobuf:"varint,1,opt,name=start,proto3" json:"start,omitempty"`
	Limit         int64                  `protobuf:"varint,2,opt,name=limit,proto3" json:"limit,omitempty"`
	Stride        int64                  `protobuf:"varint,3,opt,name=stride,proto3" json:"stride,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HloInstructionProto_SliceDimensions) Reset() {
	*x = HloInstructionProto_SliceDimensions{}
	mi := &file_xla_service_hlo_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HloInstructionProto_SliceDimensions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HloInstructionProto_SliceDimensions) ProtoMessage() {}

func (x *HloInstructionProto_SliceDimensions) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HloInstructionProto_SliceDimensions.ProtoReflect.Descriptor instead.
func (*HloInstructionProto_SliceDimensions) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{0, 0}
}

func (x *HloInstructionProto_SliceDimensions) GetStart() int64 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *HloInstructionProto_SliceDimensions) GetLimit() int64 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *HloInstructionProto_SliceDimensions) GetStride() int64 {
	if x != nil {
		return x.Stride
	}
	return 0
}

type HloScheduleProto_InstructionSequence struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	InstructionIds []int64                `protobuf:"varint,1,rep,packed,name=instruction_ids,json=instructionIds,proto3" json:"instruction_ids,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *HloScheduleProto_InstructionSequence) Reset() {
	*x = HloScheduleProto_InstructionSequence{}
	mi := &file_xla_service_hlo_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HloScheduleProto_InstructionSequence) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HloScheduleProto_InstructionSequence) ProtoMessage() {}

func (x *HloScheduleProto_InstructionSequence) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HloScheduleProto_InstructionSequence.ProtoReflect.Descriptor instead.
func (*HloScheduleProto_InstructionSequence) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{2, 0}
}

func (x *HloScheduleProto_InstructionSequence) GetInstructionIds() []int64 {
	if x != nil {
		return x.InstructionIds
	}
	return nil
}

// The following proto describes a pair of aliased an input
// (described by parameter number and a ShapeIndex of the parameter)
// and an output (described by a ShapeIndex of the root
// instruction). For example:
//
//	entry = {
//	 output_shape_index={1},
//	 parameter_number=0,
//	 parameter_shape_index={1, 2},
//	}
//
// This entry indicates that the first parameter's {1, 2} element is
// aliased with the {1} element of the root instruction.
type HloInputOutputAliasProto_AliasEntryProto struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ShapeIndex of the root hlo.
	OutputShapeIndex []int64 `protobuf:"varint,1,rep,packed,name=output_shape_index,json=outputShapeIndex,proto3" json:"output_shape_index,omitempty"`
	// Number of the parameter in entry computation.
	ParameterNumber int64 `protobuf:"varint,2,opt,name=parameter_number,json=parameterNumber,proto3" json:"parameter_number,omitempty"`
	// ShapeIndex of the parameter instruction.
	ParameterShapeIndex []int64 `protobuf:"varint,3,rep,packed,name=parameter_shape_index,json=parameterShapeIndex,proto3" json:"parameter_shape_index,omitempty"`
	// The kind of alias to be setup.
	Kind          Kind `protobuf:"varint,4,opt,name=kind,proto3,enum=xla.Kind" json:"kind,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HloInputOutputAliasProto_AliasEntryProto) Reset() {
	*x = HloInputOutputAliasProto_AliasEntryProto{}
	mi := &file_xla_service_hlo_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HloInputOutputAliasProto_AliasEntryProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HloInputOutputAliasProto_AliasEntryProto) ProtoMessage() {}

func (x *HloInputOutputAliasProto_AliasEntryProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HloInputOutputAliasProto_AliasEntryProto.ProtoReflect.Descriptor instead.
func (*HloInputOutputAliasProto_AliasEntryProto) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{3, 0}
}

func (x *HloInputOutputAliasProto_AliasEntryProto) GetOutputShapeIndex() []int64 {
	if x != nil {
		return x.OutputShapeIndex
	}
	return nil
}

func (x *HloInputOutputAliasProto_AliasEntryProto) GetParameterNumber() int64 {
	if x != nil {
		return x.ParameterNumber
	}
	return 0
}

func (x *HloInputOutputAliasProto_AliasEntryProto) GetParameterShapeIndex() []int64 {
	if x != nil {
		return x.ParameterShapeIndex
	}
	return nil
}

func (x *HloInputOutputAliasProto_AliasEntryProto) GetKind() Kind {
	if x != nil {
		return x.Kind
	}
	return Kind_UNDEFINED_ALIAS
}

// The following proto describes an input (described by parameter number and a
// ShapeIndex of the parameter) that can donate its butter to any output
// tensor. It is similar to HloInputOutputAliasProto, but without a paired
// output. For example:
//
//	entry = {
//	 parameter_number=0,
//	 parameter_shape_index={1, 2},
//	}
//
// This entry indicates that the first parameter's {1, 2} element can donate
// its buffer.
type HloBufferDonorProto_BufferDonorEntryProto struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Number of the parameter in entry computation.
	ParameterNumber int64 `protobuf:"varint,1,opt,name=parameter_number,json=parameterNumber,proto3" json:"parameter_number,omitempty"`
	// ShapeIndex of the parameter instruction.
	ParameterShapeIndex []int64 `protobuf:"varint,2,rep,packed,name=parameter_shape_index,json=parameterShapeIndex,proto3" json:"parameter_shape_index,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *HloBufferDonorProto_BufferDonorEntryProto) Reset() {
	*x = HloBufferDonorProto_BufferDonorEntryProto{}
	mi := &file_xla_service_hlo_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HloBufferDonorProto_BufferDonorEntryProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HloBufferDonorProto_BufferDonorEntryProto) ProtoMessage() {}

func (x *HloBufferDonorProto_BufferDonorEntryProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HloBufferDonorProto_BufferDonorEntryProto.ProtoReflect.Descriptor instead.
func (*HloBufferDonorProto_BufferDonorEntryProto) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{4, 0}
}

func (x *HloBufferDonorProto_BufferDonorEntryProto) GetParameterNumber() int64 {
	if x != nil {
		return x.ParameterNumber
	}
	return 0
}

func (x *HloBufferDonorProto_BufferDonorEntryProto) GetParameterShapeIndex() []int64 {
	if x != nil {
		return x.ParameterShapeIndex
	}
	return nil
}

// Serialization of file position.
type StackFrameIndexProto_FileLocation struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// 1-based position of file name.
	FileNameId int32 `protobuf:"varint,1,opt,name=file_name_id,json=fileNameId,proto3" json:"file_name_id,omitempty"`
	// 1-based position of function name.
	FunctionNameId int32 `protobuf:"varint,2,opt,name=function_name_id,json=functionNameId,proto3" json:"function_name_id,omitempty"`
	// Line number.
	Line int32 `protobuf:"varint,3,opt,name=line,proto3" json:"line,omitempty"`
	// End line number.
	EndLine int32 `protobuf:"varint,5,opt,name=end_line,json=endLine,proto3" json:"end_line,omitempty"`
	// Column number.
	Column int32 `protobuf:"varint,4,opt,name=column,proto3" json:"column,omitempty"`
	// End column number.
	EndColumn     int32 `protobuf:"varint,6,opt,name=end_column,json=endColumn,proto3" json:"end_column,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StackFrameIndexProto_FileLocation) Reset() {
	*x = StackFrameIndexProto_FileLocation{}
	mi := &file_xla_service_hlo_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StackFrameIndexProto_FileLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StackFrameIndexProto_FileLocation) ProtoMessage() {}

func (x *StackFrameIndexProto_FileLocation) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StackFrameIndexProto_FileLocation.ProtoReflect.Descriptor instead.
func (*StackFrameIndexProto_FileLocation) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{6, 0}
}

func (x *StackFrameIndexProto_FileLocation) GetFileNameId() int32 {
	if x != nil {
		return x.FileNameId
	}
	return 0
}

func (x *StackFrameIndexProto_FileLocation) GetFunctionNameId() int32 {
	if x != nil {
		return x.FunctionNameId
	}
	return 0
}

func (x *StackFrameIndexProto_FileLocation) GetLine() int32 {
	if x != nil {
		return x.Line
	}
	return 0
}

func (x *StackFrameIndexProto_FileLocation) GetEndLine() int32 {
	if x != nil {
		return x.EndLine
	}
	return 0
}

func (x *StackFrameIndexProto_FileLocation) GetColumn() int32 {
	if x != nil {
		return x.Column
	}
	return 0
}

func (x *StackFrameIndexProto_FileLocation) GetEndColumn() int32 {
	if x != nil {
		return x.EndColumn
	}
	return 0
}

// Serialization of frame.
type StackFrameIndexProto_StackFrame struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// 1-based position of file location.
	FileLocationId int32 `protobuf:"varint,1,opt,name=file_location_id,json=fileLocationId,proto3" json:"file_location_id,omitempty"`
	// 1-based position of the parent frame.
	ParentFrameId int32 `protobuf:"varint,2,opt,name=parent_frame_id,json=parentFrameId,proto3" json:"parent_frame_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *StackFrameIndexProto_StackFrame) Reset() {
	*x = StackFrameIndexProto_StackFrame{}
	mi := &file_xla_service_hlo_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StackFrameIndexProto_StackFrame) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StackFrameIndexProto_StackFrame) ProtoMessage() {}

func (x *StackFrameIndexProto_StackFrame) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StackFrameIndexProto_StackFrame.ProtoReflect.Descriptor instead.
func (*StackFrameIndexProto_StackFrame) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{6, 1}
}

func (x *StackFrameIndexProto_StackFrame) GetFileLocationId() int32 {
	if x != nil {
		return x.FileLocationId
	}
	return 0
}

func (x *StackFrameIndexProto_StackFrame) GetParentFrameId() int32 {
	if x != nil {
		return x.ParentFrameId
	}
	return 0
}

// Information about the optimization profile that this module contains.
type HloModuleProto_ProfileInfo struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The optimization profiles that this module contains.
	ProfileType HloModuleProto_ProfileType `protobuf:"varint,1,opt,name=profile_type,json=profileType,proto3,enum=xla.HloModuleProto_ProfileType" json:"profile_type,omitempty"`
	// Speedup of tuned config compared to default config.
	RelativeSpeedup float64 `protobuf:"fixed64,2,opt,name=relative_speedup,json=relativeSpeedup,proto3" json:"relative_speedup,omitempty"`
	// The source of the optimization profile that this module contains.
	ProfileSource xla_data.ProfileSource `protobuf:"varint,3,opt,name=profile_source,json=profileSource,proto3,enum=xla.ProfileSource" json:"profile_source,omitempty"`
	// The compilation event that triggered the use of the profile.
	CompilationEvent xla_data.CompilationEvent `protobuf:"varint,4,opt,name=compilation_event,json=compilationEvent,proto3,enum=xla.CompilationEvent" json:"compilation_event,omitempty"`
	// The fingerprint of this profile. `fingerprint` should match a key
	// in the profile table.
	Fingerprint string `protobuf:"bytes,5,opt,name=fingerprint,proto3" json:"fingerprint,omitempty"`
	// The type of profile generation strategy used to generate the profile.
	ProfileGenerationStrategy xla_data.ProfileGenerationStrategy `protobuf:"varint,6,opt,name=profile_generation_strategy,json=profileGenerationStrategy,proto3,enum=xla.ProfileGenerationStrategy" json:"profile_generation_strategy,omitempty"`
	// The original changelist the profile was generated at.
	OriginalChangelist int64 `protobuf:"varint,7,opt,name=original_changelist,json=originalChangelist,proto3" json:"original_changelist,omitempty"`
	// The changelist this profile was last updated at.
	Changelist    int64 `protobuf:"varint,8,opt,name=changelist,proto3" json:"changelist,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HloModuleProto_ProfileInfo) Reset() {
	*x = HloModuleProto_ProfileInfo{}
	mi := &file_xla_service_hlo_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HloModuleProto_ProfileInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HloModuleProto_ProfileInfo) ProtoMessage() {}

func (x *HloModuleProto_ProfileInfo) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HloModuleProto_ProfileInfo.ProtoReflect.Descriptor instead.
func (*HloModuleProto_ProfileInfo) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{7, 0}
}

func (x *HloModuleProto_ProfileInfo) GetProfileType() HloModuleProto_ProfileType {
	if x != nil {
		return x.ProfileType
	}
	return HloModuleProto_INVALID
}

func (x *HloModuleProto_ProfileInfo) GetRelativeSpeedup() float64 {
	if x != nil {
		return x.RelativeSpeedup
	}
	return 0
}

func (x *HloModuleProto_ProfileInfo) GetProfileSource() xla_data.ProfileSource {
	if x != nil {
		return x.ProfileSource
	}
	return xla_data.ProfileSource(0)
}

func (x *HloModuleProto_ProfileInfo) GetCompilationEvent() xla_data.CompilationEvent {
	if x != nil {
		return x.CompilationEvent
	}
	return xla_data.CompilationEvent(0)
}

func (x *HloModuleProto_ProfileInfo) GetFingerprint() string {
	if x != nil {
		return x.Fingerprint
	}
	return ""
}

func (x *HloModuleProto_ProfileInfo) GetProfileGenerationStrategy() xla_data.ProfileGenerationStrategy {
	if x != nil {
		return x.ProfileGenerationStrategy
	}
	return xla_data.ProfileGenerationStrategy(0)
}

func (x *HloModuleProto_ProfileInfo) GetOriginalChangelist() int64 {
	if x != nil {
		return x.OriginalChangelist
	}
	return 0
}

func (x *HloModuleProto_ProfileInfo) GetChangelist() int64 {
	if x != nil {
		return x.Changelist
	}
	return 0
}

// Location represents an instruction and its shape index, which uniquely
// identifies a point where a buffer is needed.
type LogicalBufferProto_Location struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// TODO(b/239098765): Remove instruction_name and computation_name.
	//
	// Deprecated: Marked as deprecated in xla/service/hlo.proto.
	InstructionName string  `protobuf:"bytes,2,opt,name=instruction_name,json=instructionName,proto3" json:"instruction_name,omitempty"`
	InstructionId   int64   `protobuf:"varint,4,opt,name=instruction_id,json=instructionId,proto3" json:"instruction_id,omitempty"`
	ShapeIndex      []int64 `protobuf:"varint,3,rep,packed,name=shape_index,json=shapeIndex,proto3" json:"shape_index,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *LogicalBufferProto_Location) Reset() {
	*x = LogicalBufferProto_Location{}
	mi := &file_xla_service_hlo_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogicalBufferProto_Location) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogicalBufferProto_Location) ProtoMessage() {}

func (x *LogicalBufferProto_Location) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogicalBufferProto_Location.ProtoReflect.Descriptor instead.
func (*LogicalBufferProto_Location) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{8, 0}
}

// Deprecated: Marked as deprecated in xla/service/hlo.proto.
func (x *LogicalBufferProto_Location) GetInstructionName() string {
	if x != nil {
		return x.InstructionName
	}
	return ""
}

func (x *LogicalBufferProto_Location) GetInstructionId() int64 {
	if x != nil {
		return x.InstructionId
	}
	return 0
}

func (x *LogicalBufferProto_Location) GetShapeIndex() []int64 {
	if x != nil {
		return x.ShapeIndex
	}
	return nil
}

// Assigned represents a single LogicalBuffer that is assigned to this
// BufferAllocation.
type BufferAllocationProto_Assigned struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	LogicalBufferId int64                  `protobuf:"varint,1,opt,name=logical_buffer_id,json=logicalBufferId,proto3" json:"logical_buffer_id,omitempty"`
	Offset          int64                  `protobuf:"varint,2,opt,name=offset,proto3" json:"offset,omitempty"`
	Size            int64                  `protobuf:"varint,3,opt,name=size,proto3" json:"size,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *BufferAllocationProto_Assigned) Reset() {
	*x = BufferAllocationProto_Assigned{}
	mi := &file_xla_service_hlo_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BufferAllocationProto_Assigned) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BufferAllocationProto_Assigned) ProtoMessage() {}

func (x *BufferAllocationProto_Assigned) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BufferAllocationProto_Assigned.ProtoReflect.Descriptor instead.
func (*BufferAllocationProto_Assigned) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{9, 0}
}

func (x *BufferAllocationProto_Assigned) GetLogicalBufferId() int64 {
	if x != nil {
		return x.LogicalBufferId
	}
	return 0
}

func (x *BufferAllocationProto_Assigned) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *BufferAllocationProto_Assigned) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

// The trace includes a list of events, where each event describes one action
// performed by the heap simulator.
type HeapSimulatorTrace_Event struct {
	state protoimpl.MessageState        `protogen:"open.v1"`
	Kind  HeapSimulatorTrace_Event_Kind `protobuf:"varint,1,opt,name=kind,proto3,enum=xla.HeapSimulatorTrace_Event_Kind" json:"kind,omitempty"`
	// The id of the LogicalBuffer that the event applies to.
	BufferId int64 `protobuf:"varint,2,opt,name=buffer_id,json=bufferId,proto3" json:"buffer_id,omitempty"`
	// The HloInstruction that the simulation was processing that caused this
	// event to occur, identified by its computation and instruction name. E.g.
	// buffers defined by instruction A are allocated when processing A.
	ComputationName string `protobuf:"bytes,3,opt,name=computation_name,json=computationName,proto3" json:"computation_name,omitempty"`
	InstructionName string `protobuf:"bytes,4,opt,name=instruction_name,json=instructionName,proto3" json:"instruction_name,omitempty"`
	// The id of the canonical LogicalBuffer that the buffer shares with. Only
	// set for SHARE_WITH events.
	ShareWithCanonicalId int64 `protobuf:"varint,5,opt,name=share_with_canonical_id,json=shareWithCanonicalId,proto3" json:"share_with_canonical_id,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *HeapSimulatorTrace_Event) Reset() {
	*x = HeapSimulatorTrace_Event{}
	mi := &file_xla_service_hlo_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HeapSimulatorTrace_Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HeapSimulatorTrace_Event) ProtoMessage() {}

func (x *HeapSimulatorTrace_Event) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HeapSimulatorTrace_Event.ProtoReflect.Descriptor instead.
func (*HeapSimulatorTrace_Event) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{10, 0}
}

func (x *HeapSimulatorTrace_Event) GetKind() HeapSimulatorTrace_Event_Kind {
	if x != nil {
		return x.Kind
	}
	return HeapSimulatorTrace_Event_ALLOC
}

func (x *HeapSimulatorTrace_Event) GetBufferId() int64 {
	if x != nil {
		return x.BufferId
	}
	return 0
}

func (x *HeapSimulatorTrace_Event) GetComputationName() string {
	if x != nil {
		return x.ComputationName
	}
	return ""
}

func (x *HeapSimulatorTrace_Event) GetInstructionName() string {
	if x != nil {
		return x.InstructionName
	}
	return ""
}

func (x *HeapSimulatorTrace_Event) GetShareWithCanonicalId() int64 {
	if x != nil {
		return x.ShareWithCanonicalId
	}
	return 0
}

// Alias represents a source LogicalBuffer, and the buffer location that
// aliases it.
type BufferAssignmentProto_BufferAlias struct {
	state          protoimpl.MessageState       `protogen:"open.v1"`
	SourceBufferId int64                        `protobuf:"varint,1,opt,name=source_buffer_id,json=sourceBufferId,proto3" json:"source_buffer_id,omitempty"`
	Location       *LogicalBufferProto_Location `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *BufferAssignmentProto_BufferAlias) Reset() {
	*x = BufferAssignmentProto_BufferAlias{}
	mi := &file_xla_service_hlo_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BufferAssignmentProto_BufferAlias) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BufferAssignmentProto_BufferAlias) ProtoMessage() {}

func (x *BufferAssignmentProto_BufferAlias) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BufferAssignmentProto_BufferAlias.ProtoReflect.Descriptor instead.
func (*BufferAssignmentProto_BufferAlias) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{12, 0}
}

func (x *BufferAssignmentProto_BufferAlias) GetSourceBufferId() int64 {
	if x != nil {
		return x.SourceBufferId
	}
	return 0
}

func (x *BufferAssignmentProto_BufferAlias) GetLocation() *LogicalBufferProto_Location {
	if x != nil {
		return x.Location
	}
	return nil
}

// Stores the information required to decode the literal.
type HloInputs_LiteralDescriptor struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	Version           int32                  `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	ArgumentSizeBytes uint64                 `protobuf:"varint,2,opt,name=argument_size_bytes,json=argumentSizeBytes,proto3" json:"argument_size_bytes,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *HloInputs_LiteralDescriptor) Reset() {
	*x = HloInputs_LiteralDescriptor{}
	mi := &file_xla_service_hlo_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HloInputs_LiteralDescriptor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HloInputs_LiteralDescriptor) ProtoMessage() {}

func (x *HloInputs_LiteralDescriptor) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HloInputs_LiteralDescriptor.ProtoReflect.Descriptor instead.
func (*HloInputs_LiteralDescriptor) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{15, 0}
}

func (x *HloInputs_LiteralDescriptor) GetVersion() int32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *HloInputs_LiteralDescriptor) GetArgumentSizeBytes() uint64 {
	if x != nil {
		return x.ArgumentSizeBytes
	}
	return 0
}

type OriginalValueRecoveryTableProto_Entry struct {
	state            protoimpl.MessageState       `protogen:"open.v1"`
	OldOriginalArray *xla_data.OriginalArrayProto `protobuf:"bytes,1,opt,name=old_original_array,json=oldOriginalArray,proto3" json:"old_original_array,omitempty"`
	NewOriginalArray *xla_data.OriginalArrayProto `protobuf:"bytes,2,opt,name=new_original_array,json=newOriginalArray,proto3" json:"new_original_array,omitempty"`
	RecoveryModule   *HloModuleProto              `protobuf:"bytes,3,opt,name=recovery_module,json=recoveryModule,proto3" json:"recovery_module,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *OriginalValueRecoveryTableProto_Entry) Reset() {
	*x = OriginalValueRecoveryTableProto_Entry{}
	mi := &file_xla_service_hlo_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OriginalValueRecoveryTableProto_Entry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OriginalValueRecoveryTableProto_Entry) ProtoMessage() {}

func (x *OriginalValueRecoveryTableProto_Entry) ProtoReflect() protoreflect.Message {
	mi := &file_xla_service_hlo_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OriginalValueRecoveryTableProto_Entry.ProtoReflect.Descriptor instead.
func (*OriginalValueRecoveryTableProto_Entry) Descriptor() ([]byte, []int) {
	return file_xla_service_hlo_proto_rawDescGZIP(), []int{19, 0}
}

func (x *OriginalValueRecoveryTableProto_Entry) GetOldOriginalArray() *xla_data.OriginalArrayProto {
	if x != nil {
		return x.OldOriginalArray
	}
	return nil
}

func (x *OriginalValueRecoveryTableProto_Entry) GetNewOriginalArray() *xla_data.OriginalArrayProto {
	if x != nil {
		return x.NewOriginalArray
	}
	return nil
}

func (x *OriginalValueRecoveryTableProto_Entry) GetRecoveryModule() *HloModuleProto {
	if x != nil {
		return x.RecoveryModule
	}
	return nil
}

var File_xla_service_hlo_proto protoreflect.FileDescriptor

var file_xla_service_hlo_proto_rawDesc = string([]byte{
	0x0a, 0x15, 0x78, 0x6c, 0x61, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2f, 0x68, 0x6c,
	0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x03, 0x78, 0x6c, 0x61, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x78, 0x6c, 0x61, 0x2f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x12, 0x78, 0x6c, 0x61, 0x2f, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xec, 0x21, 0x0a, 0x13, 0x48, 0x6c, 0x6f, 0x49, 0x6e,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x70, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x6f, 0x70, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x25, 0x0a, 0x05, 0x73, 0x68,
	0x61, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x78, 0x6c, 0x61, 0x2e,
	0x53, 0x68, 0x61, 0x70, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x05, 0x73, 0x68, 0x61, 0x70,
	0x65, 0x12, 0x2b, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x4f, 0x70, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2b,
	0x0a, 0x07, 0x6c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x11, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x52, 0x07, 0x6c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x12, 0x29, 0x0a, 0x10, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x66, 0x75, 0x73,
	0x69, 0x6f, 0x6e, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x75, 0x70, 0x6c, 0x65,
	0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x74, 0x75,
	0x70, 0x6c, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x1e, 0x0a, 0x0a, 0x64, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x03, 0x52, 0x0a, 0x64, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x23, 0x0a, 0x06, 0x77, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0b, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x57,
	0x69, 0x6e, 0x64, 0x6f, 0x77, 0x52, 0x06, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x64, 0x0a,
	0x1d, 0x63, 0x6f, 0x6e, 0x76, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x18, 0x10,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4e,
	0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x52, 0x1b, 0x63, 0x6f, 0x6e, 0x76, 0x6f, 0x6c, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x32, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x11, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x2a, 0x0a, 0x11, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x3a, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f,
	0x62, 0x61, 0x74, 0x63, 0x68, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x53, 0x0a, 0x10, 0x73, 0x6c, 0x69, 0x63, 0x65, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x78, 0x6c, 0x61, 0x2e,
	0x48, 0x6c, 0x6f, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x0f, 0x73, 0x6c, 0x69, 0x63, 0x65, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x78, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74,
	0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x12, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x65, 0x78, 0x70,
	0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x42, 0x69, 0x74, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x6d, 0x61, 0x6e,
	0x74, 0x69, 0x73, 0x73, 0x61, 0x5f, 0x62, 0x69, 0x74, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x0c, 0x6d, 0x61, 0x6e, 0x74, 0x69, 0x73, 0x73, 0x61, 0x42, 0x69, 0x74, 0x73, 0x12, 0x2e,
	0x0a, 0x13, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x5f, 0x73, 0x6c, 0x69, 0x63, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x73, 0x18, 0x14, 0x20, 0x03, 0x28, 0x03, 0x52, 0x11, 0x64, 0x79, 0x6e,
	0x61, 0x6d, 0x69, 0x63, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x73, 0x12, 0x39,
	0x0a, 0x0e, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x50, 0x61, 0x64,
	0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0d, 0x70, 0x61, 0x64, 0x64,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x25, 0x0a, 0x0e, 0x6f, 0x75, 0x74,
	0x66, 0x65, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x16, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x0d, 0x6f, 0x75, 0x74, 0x66, 0x65, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x3b, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x17, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x17, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x52, 0x61, 0x6e,
	0x64, 0x6f, 0x6d, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0c, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a,
	0x07, 0x65, 0x70, 0x73, 0x69, 0x6c, 0x6f, 0x6e, 0x18, 0x18, 0x20, 0x01, 0x28, 0x02, 0x52, 0x07,
	0x65, 0x70, 0x73, 0x69, 0x6c, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x19, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c,
	0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x1d, 0x0a, 0x0a,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x09, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x69,
	0x6e, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x1b, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x0c, 0x69, 0x6e, 0x66, 0x65, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x2c, 0x0a, 0x12, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x5f,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x43, 0x61, 0x6c, 0x6c, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x34,
	0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x73, 0x68, 0x61, 0x70, 0x65, 0x18,
	0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x53, 0x68, 0x61, 0x70,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x66, 0x65, 0x65, 0x64, 0x53,
	0x68, 0x61, 0x70, 0x65, 0x12, 0x4c, 0x0a, 0x15, 0x64, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x18, 0x1e, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x44, 0x6f, 0x74, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x52, 0x13, 0x64,
	0x6f, 0x74, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x73, 0x12, 0x5f, 0x0a, 0x1c, 0x72, 0x61, 0x67, 0x67, 0x65, 0x64, 0x5f, 0x64, 0x6f, 0x74,
	0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x73, 0x18, 0x5a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x52,
	0x61, 0x67, 0x67, 0x65, 0x64, 0x44, 0x6f, 0x74, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x52, 0x19, 0x72, 0x61, 0x67, 0x67, 0x65, 0x64,
	0x44, 0x6f, 0x74, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x12, 0x27, 0x0a, 0x08, 0x66, 0x66, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x1f, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0c, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x46, 0x66, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x07, 0x66, 0x66, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x66, 0x66, 0x74, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x20, 0x20, 0x03, 0x28, 0x03,
	0x52, 0x09, 0x66, 0x66, 0x74, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x12, 0x31, 0x0a, 0x14, 0x63,
	0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x3f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x70, 0x61,
	0x72, 0x69, 0x73, 0x6f, 0x6e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x55,
	0x0a, 0x18, 0x67, 0x61, 0x74, 0x68, 0x65, 0x72, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x18, 0x21, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x47, 0x61, 0x74, 0x68, 0x65, 0x72, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x52, 0x16, 0x67,
	0x61, 0x74, 0x68, 0x65, 0x72, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x75,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x67, 0x61, 0x74, 0x68, 0x65, 0x72, 0x5f,
	0x73, 0x6c, 0x69, 0x63, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x73, 0x18, 0x22, 0x20, 0x03, 0x28,
	0x03, 0x52, 0x10, 0x67, 0x61, 0x74, 0x68, 0x65, 0x72, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x73, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x23, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x02, 0x69, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x69,
	0x64, 0x73, 0x18, 0x24, 0x20, 0x03, 0x28, 0x03, 0x52, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x6e,
	0x64, 0x49, 0x64, 0x73, 0x12, 0x36, 0x0a, 0x17, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x5f,
	0x70, 0x72, 0x65, 0x64, 0x65, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f, 0x69, 0x64, 0x73, 0x18,
	0x25, 0x20, 0x03, 0x28, 0x03, 0x52, 0x15, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x50, 0x72,
	0x65, 0x64, 0x65, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x49, 0x64, 0x73, 0x12, 0x34, 0x0a, 0x16,
	0x63, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x26, 0x20, 0x03, 0x28, 0x03, 0x52, 0x14, 0x63, 0x61,
	0x6c, 0x6c, 0x65, 0x64, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x73, 0x12, 0x2b, 0x0a, 0x08, 0x73, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x28,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x4f, 0x70, 0x53, 0x68, 0x61,
	0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x73, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x12,
	0x25, 0x0a, 0x0e, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x2b, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0d, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3c, 0x0a, 0x0e, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x31, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11,
	0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0d, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x12, 0x26, 0x0a, 0x0d, 0x61, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x64, 0x75,
	0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x2d, 0x20, 0x01, 0x28, 0x03, 0x42, 0x02, 0x18, 0x01, 0x52,
	0x0b, 0x61, 0x6c, 0x6c, 0x52, 0x65, 0x64, 0x75, 0x63, 0x65, 0x49, 0x64, 0x12, 0x31, 0x0a, 0x15,
	0x75, 0x73, 0x65, 0x5f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x47, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x75, 0x73, 0x65,
	0x47, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x64, 0x73, 0x12,
	0x28, 0x0a, 0x10, 0x69, 0x73, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x18, 0x2f, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x69, 0x73, 0x48, 0x6f, 0x73,
	0x74, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x73, 0x5f,
	0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x3c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x69, 0x73,
	0x53, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x58, 0x0a, 0x19, 0x73, 0x63, 0x61, 0x74, 0x74, 0x65,
	0x72, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x18, 0x30, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x78, 0x6c, 0x61, 0x2e,
	0x53, 0x63, 0x61, 0x74, 0x74, 0x65, 0x72, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x52, 0x17, 0x73, 0x63, 0x61, 0x74, 0x74, 0x65, 0x72,
	0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73,
	0x12, 0x3f, 0x0a, 0x10, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x33, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x78, 0x6c, 0x61,
	0x2e, 0x50, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x0f, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x41, 0x0a, 0x13, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x5f, 0x70, 0x61, 0x69, 0x72, 0x73, 0x18, 0x34, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11,
	0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x52, 0x11, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50,
	0x61, 0x69, 0x72, 0x73, 0x12, 0x43, 0x0a, 0x15, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x36, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x4f, 0x70, 0x53, 0x68, 0x61, 0x72,
	0x64, 0x69, 0x6e, 0x67, 0x52, 0x13, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x41, 0x0a, 0x14, 0x64, 0x6f, 0x6d,
	0x61, 0x69, 0x6e, 0x5f, 0x65, 0x78, 0x69, 0x74, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e,
	0x67, 0x18, 0x37, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x4f, 0x70,
	0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x12, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
	0x45, 0x78, 0x69, 0x74, 0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x29, 0x0a, 0x10,
	0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x5f, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74,
	0x18, 0x38, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x4c, 0x0a, 0x1a, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x6e, 0x64, 0x5f, 0x73, 0x68, 0x61, 0x70, 0x65, 0x73, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x6c,
	0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x39, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x78, 0x6c,
	0x61, 0x2e, 0x53, 0x68, 0x61, 0x70, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x17, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x6e, 0x64, 0x53, 0x68, 0x61, 0x70, 0x65, 0x73, 0x57, 0x69, 0x74, 0x68, 0x4c,
	0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x55, 0x0a, 0x18, 0x74, 0x72, 0x69, 0x61, 0x6e, 0x67, 0x75,
	0x6c, 0x61, 0x72, 0x5f, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x3b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x54, 0x72,
	0x69, 0x61, 0x6e, 0x67, 0x75, 0x6c, 0x61, 0x72, 0x53, 0x6f, 0x6c, 0x76, 0x65, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x16, 0x74, 0x72, 0x69, 0x61, 0x6e, 0x67, 0x75, 0x6c, 0x61, 0x72,
	0x53, 0x6f, 0x6c, 0x76, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3f, 0x0a, 0x10,
	0x63, 0x68, 0x6f, 0x6c, 0x65, 0x73, 0x6b, 0x79, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x3e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x43, 0x68, 0x6f,
	0x6c, 0x65, 0x73, 0x6b, 0x79, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0f, 0x63, 0x68,
	0x6f, 0x6c, 0x65, 0x73, 0x6b, 0x79, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4e, 0x0a,
	0x15, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x3d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x78,
	0x6c, 0x61, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x0a,
	0x1b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x68, 0x61, 0x73,
	0x5f, 0x73, 0x69, 0x64, 0x65, 0x5f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x18, 0x41, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x17, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x61, 0x6c, 0x6c, 0x48, 0x61,
	0x73, 0x53, 0x69, 0x64, 0x65, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x12, 0x52, 0x0a, 0x17, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x61, 0x6c,
	0x69, 0x61, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x4a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x78,
	0x6c, 0x61, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x6e, 0x64,
	0x41, 0x6c, 0x69, 0x61, 0x73, 0x69, 0x6e, 0x67, 0x52, 0x15, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x6e, 0x64, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x69, 0x6e, 0x67, 0x12,
	0x49, 0x0a, 0x14, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x73,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x4c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x17, 0x2e,
	0x78, 0x6c, 0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x61, 0x6c, 0x6c, 0x53, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x12, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x61,
	0x6c, 0x6c, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x64, 0x65,
	0x6c, 0x74, 0x61, 0x18, 0x42, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x64, 0x65, 0x6c, 0x74, 0x61,
	0x12, 0x2c, 0x0a, 0x12, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x5f, 0x61, 0x72, 0x65, 0x5f,
	0x73, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x18, 0x43, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x69, 0x6e,
	0x64, 0x69, 0x63, 0x65, 0x73, 0x41, 0x72, 0x65, 0x53, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x12, 0x48,
	0x0a, 0x13, 0x66, 0x72, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x44, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x78, 0x6c,
	0x61, 0x2e, 0x46, 0x72, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x52, 0x12, 0x66, 0x72, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x75, 0x6e, 0x69, 0x71,
	0x75, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x18, 0x45, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0d, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x49, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x12,
	0x39, 0x0a, 0x0d, 0x72, 0x6e, 0x67, 0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d,
	0x18, 0x46, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x14, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x52, 0x61, 0x6e,
	0x64, 0x6f, 0x6d, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x52, 0x0c, 0x72, 0x6e,
	0x67, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x27, 0x0a, 0x0f, 0x63, 0x6f,
	0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x48, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f, 0x6e, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x3d, 0x0a, 0x19, 0x69, 0x73, 0x5f, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x5f,
	0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x74, 0x63, 0x68,
	0x18, 0x49, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x52, 0x16, 0x69, 0x73, 0x43, 0x72,
	0x6f, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x50, 0x72, 0x65, 0x66, 0x65, 0x74,
	0x63, 0x68, 0x12, 0x41, 0x0a, 0x1c, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x67,
	0x72, 0x61, 0x6d, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x74, 0x63, 0x68, 0x5f, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x18, 0x50, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x19, 0x63, 0x72, 0x6f, 0x73,
	0x73, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x50, 0x72, 0x65, 0x66, 0x65, 0x74, 0x63, 0x68,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x33, 0x0a, 0x0c, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x4b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x78, 0x6c,
	0x61, 0x2e, 0x50, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x70,
	0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x12, 0x50, 0x0a, 0x17, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x4d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x19, 0x2e, 0x78, 0x6c,
	0x61, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x61, 0x6c, 0x6c, 0x41, 0x70, 0x69, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x14, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x61,
	0x6c, 0x6c, 0x41, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x16,
	0x61, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x18, 0x4f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x61, 0x73,
	0x79, 0x6e, 0x63, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x68, 0x72, 0x65,
	0x61, 0x64, 0x12, 0x0c, 0x0a, 0x01, 0x6b, 0x18, 0x51, 0x20, 0x01, 0x28, 0x03, 0x52, 0x01, 0x6b,
	0x12, 0x18, 0x0a, 0x07, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x73, 0x74, 0x18, 0x55, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x07, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x0e, 0x73, 0x74,
	0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x5f, 0x76, 0x69, 0x7a, 0x18, 0x52, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74,
	0x69, 0x63, 0x73, 0x56, 0x69, 0x7a, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69,
	0x63, 0x73, 0x56, 0x69, 0x7a, 0x12, 0x54, 0x0a, 0x16, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18,
	0x57, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x43, 0x6f, 0x6c, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x69, 0x73, 0x74,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x14, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x0e, 0x6f,
	0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x58, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e,
	0x61, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0d, 0x6f, 0x72,
	0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x69,
	0x73, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x65, 0x18, 0x59, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0b, 0x69, 0x73, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x65, 0x12, 0x3c,
	0x0a, 0x0f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x61, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63,
	0x79, 0x18, 0x5b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x52, 0x0e, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x1a, 0x55, 0x0a, 0x0f,
	0x53, 0x6c, 0x69, 0x63, 0x65, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x73,
	0x74, 0x72, 0x69, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x73, 0x74, 0x72,
	0x69, 0x64, 0x65, 0x42, 0x27, 0x0a, 0x25, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f,
	0x63, 0x72, 0x6f, 0x73, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x5f, 0x70, 0x72,
	0x65, 0x66, 0x65, 0x74, 0x63, 0x68, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x4a, 0x04, 0x08, 0x0a,
	0x10, 0x0b, 0x4a, 0x04, 0x08, 0x0c, 0x10, 0x0d, 0x4a, 0x04, 0x08, 0x04, 0x10, 0x05, 0x4a, 0x04,
	0x08, 0x05, 0x10, 0x06, 0x4a, 0x04, 0x08, 0x06, 0x10, 0x07, 0x4a, 0x04, 0x08, 0x2c, 0x10, 0x2d,
	0x4a, 0x04, 0x08, 0x35, 0x10, 0x36, 0x4a, 0x04, 0x08, 0x2e, 0x10, 0x2f, 0x4a, 0x04, 0x08, 0x29,
	0x10, 0x2a, 0x4a, 0x04, 0x08, 0x2a, 0x10, 0x2b, 0x4a, 0x04, 0x08, 0x40, 0x10, 0x41, 0x4a, 0x04,
	0x08, 0x4e, 0x10, 0x4f, 0x4a, 0x04, 0x08, 0x53, 0x10, 0x54, 0x4a, 0x04, 0x08, 0x54, 0x10, 0x55,
	0x4a, 0x04, 0x08, 0x56, 0x10, 0x57, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x52, 0x1e, 0x66, 0x75, 0x73, 0x65, 0x64, 0x5f, 0x69, 0x6e,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x6e, 0x64, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x52, 0x19, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x5f, 0x70,
	0x72, 0x65, 0x64, 0x65, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x52, 0x18, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x52, 0x11, 0x72, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x73, 0x52, 0x12, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x6f, 0x70, 0x61, 0x71, 0x75,
	0x65, 0x52, 0x12, 0x61, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x64, 0x75, 0x63, 0x65, 0x5f, 0x62, 0x61,
	0x72, 0x72, 0x69, 0x65, 0x72, 0x22, 0xbd, 0x02, 0x0a, 0x13, 0x48, 0x6c, 0x6f, 0x43, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x3c, 0x0a, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x48, 0x6c,
	0x6f, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x3b, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x5f, 0x73, 0x68, 0x61, 0x70, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x50, 0x72, 0x6f,
	0x67, 0x72, 0x61, 0x6d, 0x53, 0x68, 0x61, 0x70, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0c,
	0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x53, 0x68, 0x61, 0x70, 0x65, 0x12, 0x0e, 0x0a, 0x02,
	0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x17, 0x0a, 0x07,
	0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x72,
	0x6f, 0x6f, 0x74, 0x49, 0x64, 0x12, 0x32, 0x0a, 0x15, 0x69, 0x73, 0x5f, 0x66, 0x75, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x69, 0x73, 0x46, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x0a, 0x10, 0x65, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x68,
	0x72, 0x65, 0x61, 0x64, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x04, 0x52, 0x09, 0x72, 0x6f, 0x6f, 0x74,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xff, 0x01, 0x0a, 0x10, 0x48, 0x6c, 0x6f, 0x53, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x42, 0x0a, 0x09, 0x73, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e,
	0x78, 0x6c, 0x61, 0x2e, 0x48, 0x6c, 0x6f, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x09, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x1a, 0x3e,
	0x0a, 0x13, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x03, 0x52, 0x0e,
	0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x73, 0x1a, 0x67,
	0x0a, 0x0e, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x3f, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x48, 0x6c, 0x6f, 0x53, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xa3, 0x02, 0x0a, 0x18, 0x48, 0x6c, 0x6f, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x47, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x48, 0x6c, 0x6f, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x1a, 0xbd, 0x01,
	0x0a, 0x0f, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x2c, 0x0a, 0x12, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x68, 0x61, 0x70,
	0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x03, 0x28, 0x03, 0x52, 0x10, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x68, 0x61, 0x70, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12,
	0x29, 0x0a, 0x10, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x75, 0x6d,
	0x62, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x15, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x68, 0x61, 0x70, 0x65, 0x5f, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x18, 0x03, 0x20, 0x03, 0x28, 0x03, 0x52, 0x13, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x53, 0x68, 0x61, 0x70, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x1d,
	0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x09, 0x2e, 0x78,
	0x6c, 0x61, 0x2e, 0x4b, 0x69, 0x6e, 0x64, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0xd7, 0x01,
	0x0a, 0x13, 0x48, 0x6c, 0x6f, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x44, 0x6f, 0x6e, 0x6f, 0x72,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x48, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x48, 0x6c, 0x6f,
	0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x44, 0x6f, 0x6e, 0x6f, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x2e, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x44, 0x6f, 0x6e, 0x6f, 0x72, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x1a,
	0x76, 0x0a, 0x15, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x44, 0x6f, 0x6e, 0x6f, 0x72, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x29, 0x0a, 0x10, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4e, 0x75, 0x6d,
	0x62, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x15, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x5f, 0x73, 0x68, 0x61, 0x70, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x03, 0x52, 0x13, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x68, 0x61,
	0x70, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x22, 0x62, 0x0a, 0x14, 0x43, 0x72, 0x6f, 0x73, 0x73,
	0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x50, 0x72, 0x65, 0x66, 0x65, 0x74, 0x63, 0x68, 0x12,
	0x1c, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x09, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x14, 0x0a,
	0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x03, 0x28, 0x03, 0x52, 0x05, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0x97, 0x04, 0x0a, 0x14,
	0x53, 0x74, 0x61, 0x63, 0x6b, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x4e, 0x61,
	0x6d, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x66, 0x75, 0x6e,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x4d, 0x0a, 0x0e, 0x66, 0x69,
	0x6c, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x26, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x46, 0x72,
	0x61, 0x6d, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x46, 0x69,
	0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x66, 0x69, 0x6c, 0x65,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x47, 0x0a, 0x0c, 0x73, 0x74, 0x61,
	0x63, 0x6b, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x46, 0x72, 0x61, 0x6d, 0x65,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b,
	0x46, 0x72, 0x61, 0x6d, 0x65, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x46, 0x72, 0x61, 0x6d,
	0x65, 0x73, 0x1a, 0xc0, 0x01, 0x0a, 0x0c, 0x46, 0x69, 0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x0c, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x66, 0x69, 0x6c, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x10, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x49, 0x64, 0x12,
	0x12, 0x0a, 0x04, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x6c,
	0x69, 0x6e, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x6c, 0x69, 0x6e, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x4c, 0x69, 0x6e, 0x65, 0x12, 0x16,
	0x0a, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06,
	0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x65, 0x6e, 0x64, 0x5f, 0x63, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x43,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x1a, 0x5e, 0x0a, 0x0a, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x46, 0x72,
	0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0e, 0x66,
	0x69, 0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x26, 0x0a,
	0x0f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x46, 0x72,
	0x61, 0x6d, 0x65, 0x49, 0x64, 0x22, 0x87, 0x0e, 0x0a, 0x0e, 0x48, 0x6c, 0x6f, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x16,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x12, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x12, 0x3c, 0x0a, 0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x78, 0x6c, 0x61,
	0x2e, 0x48, 0x6c, 0x6f, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x44, 0x0a, 0x12, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72,
	0x61, 0x6d, 0x5f, 0x73, 0x68, 0x61, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16,
	0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x53, 0x68, 0x61, 0x70,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x10, 0x68, 0x6f, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x67,
	0x72, 0x61, 0x6d, 0x53, 0x68, 0x61, 0x70, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x31, 0x0a, 0x08, 0x73, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x78, 0x6c, 0x61,
	0x2e, 0x48, 0x6c, 0x6f, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x52, 0x08, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x4b, 0x0a, 0x12, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x6c, 0x69, 0x61,
	0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x48, 0x6c,
	0x6f, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x6c, 0x69, 0x61,
	0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x10, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x12, 0x3b, 0x0a, 0x0c, 0x62, 0x75, 0x66, 0x66,
	0x65, 0x72, 0x5f, 0x64, 0x6f, 0x6e, 0x6f, 0x72, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18,
	0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x48, 0x6c, 0x6f, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x44, 0x6f,
	0x6e, 0x6f, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0b, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72,
	0x44, 0x6f, 0x6e, 0x6f, 0x72, 0x12, 0x53, 0x0a, 0x18, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x5f, 0x70,
	0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x74, 0x63, 0x68, 0x65,
	0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x43, 0x72,
	0x6f, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x50, 0x72, 0x65, 0x66, 0x65, 0x74,
	0x63, 0x68, 0x52, 0x16, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d,
	0x50, 0x72, 0x65, 0x66, 0x65, 0x74, 0x63, 0x68, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x73,
	0x5f, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09,
	0x69, 0x73, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x12, 0x41, 0x0a, 0x14, 0x73, 0x70, 0x6d,
	0x64, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e,
	0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x4f, 0x70,
	0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x12, 0x73, 0x70, 0x6d, 0x64, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x4b, 0x0a, 0x19,
	0x73, 0x70, 0x6d, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x5f,
	0x73, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x0f, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x4f, 0x70, 0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67,
	0x52, 0x17, 0x73, 0x70, 0x6d, 0x64, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3b, 0x0a, 0x1a, 0x75, 0x73, 0x65,
	0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x73, 0x70, 0x6d, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x10, 0x20, 0x01, 0x28, 0x08, 0x52, 0x17, 0x75,
	0x73, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x53, 0x70, 0x6d, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x42, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x78,
	0x6c, 0x61, 0x2e, 0x48, 0x6c, 0x6f, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0b, 0x70,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x47, 0x0a, 0x11, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x52, 0x10, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x12, 0x45, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x5f, 0x66, 0x72, 0x61,
	0x6d, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x63, 0x6b, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0f, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x46, 0x72, 0x61, 0x6d, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x48, 0x0a, 0x13, 0x66, 0x72,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x46, 0x72,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x52, 0x12, 0x66, 0x72, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x65, 0x73, 0x12, 0x67, 0x0a, 0x1d, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x5f,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x78, 0x6c,
	0x61, 0x2e, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x52, 0x1a, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x1a, 0xce, 0x03,
	0x0a, 0x0b, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x42, 0x0a,
	0x0c, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x48, 0x6c, 0x6f, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x70,
	0x65, 0x65, 0x64, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0f, 0x72, 0x65, 0x6c,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x53, 0x70, 0x65, 0x65, 0x64, 0x75, 0x70, 0x12, 0x39, 0x0a, 0x0e,
	0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x42, 0x0a, 0x11, 0x63, 0x6f, 0x6d, 0x70, 0x69,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x15, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x69,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x66,
	0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x66, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x12, 0x5e, 0x0a,
	0x1b, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65,
	0x67, 0x79, 0x52, 0x19, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x2f, 0x0a,
	0x13, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x6c, 0x69, 0x73, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12, 0x6f, 0x72, 0x69, 0x67,
	0x69, 0x6e, 0x61, 0x6c, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x6c, 0x69, 0x73, 0x74, 0x12, 0x1e,
	0x0a, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0a, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x6c, 0x69, 0x73, 0x74, 0x22, 0x6e,
	0x0a, 0x0b, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0b, 0x0a,
	0x07, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x4c,
	0x41, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x55, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x02,
	0x12, 0x0a, 0x0a, 0x06, 0x4c, 0x41, 0x59, 0x4f, 0x55, 0x54, 0x10, 0x03, 0x12, 0x07, 0x0a, 0x03,
	0x44, 0x4f, 0x54, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x46, 0x4c, 0x41, 0x47, 0x4e, 0x45, 0x54,
	0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x48, 0x41, 0x52, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x06,
	0x12, 0x0c, 0x0a, 0x08, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x10, 0x07, 0x4a, 0x04,
	0x08, 0x09, 0x10, 0x0a, 0x52, 0x19, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x5f, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x22,
	0x99, 0x02, 0x0a, 0x12, 0x4c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x42, 0x75, 0x66, 0x66, 0x65,
	0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x3f, 0x0a, 0x0a, 0x64, 0x65,
	0x66, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20,
	0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x42, 0x75, 0x66, 0x66,
	0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x09, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x41, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x63,
	0x6f, 0x6c, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x6c, 0x6f,
	0x72, 0x1a, 0x87, 0x01, 0x0a, 0x08, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2d,
	0x0a, 0x10, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0f, 0x69, 0x6e,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a,
	0x0e, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x68, 0x61, 0x70, 0x65, 0x5f, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x18, 0x03, 0x20, 0x03, 0x28, 0x03, 0x52, 0x0a, 0x73, 0x68, 0x61, 0x70, 0x65,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x4a, 0x04, 0x08, 0x01, 0x10, 0x02, 0x22, 0xf2, 0x04, 0x0a, 0x15,
	0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x12, 0x0a, 0x04, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12,
	0x26, 0x0a, 0x0f, 0x69, 0x73, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6c, 0x6f, 0x63,
	0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x69, 0x73, 0x54, 0x68, 0x72, 0x65,
	0x61, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x12, 0x19, 0x0a, 0x08, 0x69, 0x73, 0x5f, 0x74, 0x75,
	0x70, 0x6c, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x69, 0x73, 0x54, 0x75, 0x70,
	0x6c, 0x65, 0x12, 0x43, 0x0a, 0x1e, 0x69, 0x73, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1b, 0x69, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x73, 0x5f, 0x63, 0x6f,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x69, 0x73,
	0x43, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4e, 0x75, 0x6d,
	0x62, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x15, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x5f, 0x73, 0x68, 0x61, 0x70, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x0a, 0x20, 0x03,
	0x28, 0x03, 0x52, 0x13, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x68, 0x61,
	0x70, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x46, 0x0a, 0x20, 0x69, 0x73, 0x5f, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x64, 0x5f,
	0x77, 0x69, 0x74, 0x68, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x1c, 0x69, 0x73, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x41, 0x6c,
	0x69, 0x61, 0x73, 0x65, 0x64, 0x57, 0x69, 0x74, 0x68, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12,
	0x24, 0x0a, 0x0e, 0x6d, 0x61, 0x79, 0x62, 0x65, 0x5f, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x6f, 0x75,
	0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x6d, 0x61, 0x79, 0x62, 0x65, 0x4c, 0x69,
	0x76, 0x65, 0x4f, 0x75, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x12, 0x3f, 0x0a, 0x08, 0x61,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x78, 0x6c, 0x61, 0x2e, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x65, 0x64, 0x52, 0x08, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x1a, 0x62, 0x0a, 0x08,
	0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x12, 0x2a, 0x0a, 0x11, 0x6c, 0x6f, 0x67, 0x69,
	0x63, 0x61, 0x6c, 0x5f, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0f, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x42, 0x75, 0x66, 0x66,
	0x65, 0x72, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x12, 0x0a, 0x04,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65,
	0x22, 0xd4, 0x03, 0x0a, 0x12, 0x48, 0x65, 0x61, 0x70, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74,
	0x6f, 0x72, 0x54, 0x72, 0x61, 0x63, 0x65, 0x12, 0x35, 0x0a, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x48, 0x65,
	0x61, 0x70, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x54, 0x72, 0x61, 0x63, 0x65,
	0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x36,
	0x0a, 0x17, 0x77, 0x68, 0x6f, 0x6c, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x73,
	0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x15, 0x77, 0x68, 0x6f, 0x6c, 0x65, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x53, 0x69, 0x6d, 0x75,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x0a, 0x17, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72,
	0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x41,
	0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x1a, 0x96,
	0x02, 0x0a, 0x05, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x36, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x48, 0x65, 0x61,
	0x70, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x54, 0x72, 0x61, 0x63, 0x65, 0x2e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x4b, 0x69, 0x6e, 0x64, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64,
	0x12, 0x1b, 0x0a, 0x09, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x08, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x49, 0x64, 0x12, 0x29, 0x0a,
	0x10, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x69, 0x6e, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x17, 0x73, 0x68, 0x61, 0x72, 0x65, 0x5f, 0x77, 0x69, 0x74,
	0x68, 0x5f, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x73, 0x68, 0x61, 0x72, 0x65, 0x57, 0x69, 0x74, 0x68, 0x43,
	0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x49, 0x64, 0x22, 0x2b, 0x0a, 0x04, 0x4b, 0x69,
	0x6e, 0x64, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x4c, 0x4c, 0x4f, 0x43, 0x10, 0x00, 0x12, 0x08, 0x0a,
	0x04, 0x46, 0x52, 0x45, 0x45, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x48, 0x41, 0x52, 0x45,
	0x5f, 0x57, 0x49, 0x54, 0x48, 0x10, 0x02, 0x22, 0x5f, 0x0a, 0x13, 0x48, 0x6c, 0x6f, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x34, 0x0a, 0x0b, 0x68, 0x6c, 0x6f, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x48, 0x6c,
	0x6f, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0a, 0x68, 0x6c,
	0x6f, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x22, 0xb7, 0x03, 0x0a, 0x15, 0x42, 0x75, 0x66,
	0x66, 0x65, 0x72, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x40, 0x0a, 0x0f, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x62, 0x75,
	0x66, 0x66, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x78, 0x6c,
	0x61, 0x2e, 0x4c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0e, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x42, 0x75, 0x66,
	0x66, 0x65, 0x72, 0x73, 0x12, 0x4d, 0x0a, 0x0e, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x61,
	0x6c, 0x69, 0x61, 0x73, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x78,
	0x6c, 0x61, 0x2e, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x41,
	0x6c, 0x69, 0x61, 0x73, 0x52, 0x0d, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x41, 0x6c, 0x69, 0x61,
	0x73, 0x65, 0x73, 0x12, 0x49, 0x0a, 0x12, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x61, 0x6c,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x41, 0x6c, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x11, 0x62, 0x75, 0x66,
	0x66, 0x65, 0x72, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x4b,
	0x0a, 0x15, 0x68, 0x65, 0x61, 0x70, 0x5f, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72,
	0x5f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x78, 0x6c, 0x61, 0x2e, 0x48, 0x65, 0x61, 0x70, 0x53, 0x69, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x6f,
	0x72, 0x54, 0x72, 0x61, 0x63, 0x65, 0x52, 0x13, 0x68, 0x65, 0x61, 0x70, 0x53, 0x69, 0x6d, 0x75,
	0x6c, 0x61, 0x74, 0x6f, 0x72, 0x54, 0x72, 0x61, 0x63, 0x65, 0x73, 0x1a, 0x75, 0x0a, 0x0b, 0x42,
	0x75, 0x66, 0x66, 0x65, 0x72, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x75, 0x66, 0x66,
	0x65, 0x72, 0x49, 0x64, 0x12, 0x3c, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x4c, 0x6f, 0x67,
	0x69, 0x63, 0x61, 0x6c, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x9b, 0x01, 0x0a, 0x08, 0x48, 0x6c, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x32, 0x0a, 0x0a, 0x68, 0x6c, 0x6f, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x48, 0x6c, 0x6f, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x09, 0x68, 0x6c, 0x6f, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x12, 0x47, 0x0a, 0x11, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x61, 0x73,
	0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x41, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x10, 0x62, 0x75, 0x66, 0x66,
	0x65, 0x72, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x4a, 0x04, 0x08, 0x02,
	0x10, 0x03, 0x52, 0x0c, 0x68, 0x6c, 0x6f, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0x22, 0xb9, 0x01, 0x0a, 0x0b, 0x48, 0x6c, 0x6f, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x12, 0x1f, 0x0a, 0x03, 0x68, 0x6c, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0d, 0x2e,
	0x78, 0x6c, 0x61, 0x2e, 0x48, 0x6c, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x03, 0x68, 0x6c,
	0x6f, 0x12, 0x2f, 0x0a, 0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72,
	0x61, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x12, 0x29, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x11, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x2d, 0x0a,
	0x12, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x22, 0xf2, 0x01, 0x0a,
	0x09, 0x48, 0x6c, 0x6f, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x2f, 0x0a, 0x09, 0x61, 0x72,
	0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e,
	0x78, 0x6c, 0x61, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x52, 0x09, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x55, 0x0a, 0x15, 0x61,
	0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x78, 0x6c, 0x61,
	0x2e, 0x48, 0x6c, 0x6f, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72,
	0x61, 0x6c, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x52, 0x14, 0x61, 0x72,
	0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f,
	0x72, 0x73, 0x1a, 0x5d, 0x0a, 0x11, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x44, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x2e, 0x0a, 0x13, 0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x11,
	0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x22, 0x96, 0x01, 0x0a, 0x16, 0x48, 0x6c, 0x6f, 0x55, 0x6e, 0x6f, 0x70, 0x74, 0x69, 0x6d,
	0x69, 0x7a, 0x65, 0x64, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x32, 0x0a, 0x0a,
	0x68, 0x6c, 0x6f, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x13, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x48, 0x6c, 0x6f, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x09, 0x68, 0x6c, 0x6f, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x12, 0x2e, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x48, 0x6c, 0x6f, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x73, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x93, 0x02, 0x0a, 0x16, 0x48,
	0x6c, 0x6f, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2e, 0x0a, 0x13, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63,
	0x61, 0x6c, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x11, 0x63, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x2a, 0x0a, 0x11, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x2c, 0x0a, 0x12, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x6f,
	0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x49, 0x64, 0x12,
	0x34, 0x0a, 0x16, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x5f, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x03, 0x52,
	0x14, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x49, 0x64, 0x73, 0x12, 0x39, 0x0a, 0x0d, 0x70, 0x61, 0x73, 0x73, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x78,
	0x6c, 0x61, 0x2e, 0x48, 0x6c, 0x6f, 0x50, 0x61, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x52, 0x0c, 0x70, 0x61, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x22, 0xe1, 0x03, 0x0a, 0x0f, 0x48, 0x6c, 0x6f, 0x50, 0x61, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x17, 0x0a, 0x07, 0x70, 0x61, 0x73, 0x73, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x70, 0x61, 0x73, 0x73, 0x49, 0x64, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x73, 0x73, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x25, 0x0a, 0x0e, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x64, 0x75, 0x6d, 0x70, 0x46, 0x69, 0x6c,
	0x65, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x12, 0x1b, 0x0a,
	0x09, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x08, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x35, 0x0a, 0x17, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x03, 0x52, 0x14, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x49, 0x64,
	0x73, 0x12, 0x30, 0x0a, 0x14, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x5f, 0x75, 0x73, 0x65, 0x63, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x12, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x55,
	0x73, 0x65, 0x63, 0x12, 0x2c, 0x0a, 0x12, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x5f, 0x75, 0x73, 0x65, 0x63, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x10, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x55, 0x73, 0x65,
	0x63, 0x12, 0x3d, 0x0a, 0x0f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79,
	0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x32, 0x0a, 0x0a, 0x6b, 0x76, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x0b,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x4b, 0x65, 0x79, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x09, 0x6b, 0x76, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x22, 0xbd, 0x02, 0x0a, 0x1f, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61,
	0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x44, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x78, 0x6c, 0x61, 0x2e,
	0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x65, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x1a, 0xd3,
	0x01, 0x0a, 0x05, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x45, 0x0a, 0x12, 0x6f, 0x6c, 0x64, 0x5f,
	0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x61, 0x72, 0x72, 0x61, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x4f, 0x72, 0x69, 0x67, 0x69,
	0x6e, 0x61, 0x6c, 0x41, 0x72, 0x72, 0x61, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x10, 0x6f,
	0x6c, 0x64, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x41, 0x72, 0x72, 0x61, 0x79, 0x12,
	0x45, 0x0a, 0x12, 0x6e, 0x65, 0x77, 0x5f, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f,
	0x61, 0x72, 0x72, 0x61, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x78, 0x6c,
	0x61, 0x2e, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x41, 0x72, 0x72, 0x61, 0x79, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x52, 0x10, 0x6e, 0x65, 0x77, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61,
	0x6c, 0x41, 0x72, 0x72, 0x61, 0x79, 0x12, 0x3c, 0x0a, 0x0f, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x13, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x48, 0x6c, 0x6f, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0e, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x2a, 0x53, 0x0a, 0x12, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x61,
	0x6c, 0x6c, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x43,
	0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x00, 0x12, 0x13, 0x0a,
	0x0f, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x5f, 0x4c, 0x41, 0x54, 0x45, 0x53, 0x54,
	0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x5f, 0x45,
	0x41, 0x52, 0x4c, 0x49, 0x45, 0x53, 0x54, 0x10, 0x02, 0x2a, 0xb4, 0x01, 0x0a, 0x14, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x43, 0x61, 0x6c, 0x6c, 0x41, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x17, 0x41, 0x50, 0x49, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f,
	0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x18, 0x0a, 0x14, 0x41, 0x50, 0x49, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x4f,
	0x52, 0x49, 0x47, 0x49, 0x4e, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x20, 0x0a, 0x1c, 0x41, 0x50, 0x49,
	0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f,
	0x52, 0x45, 0x54, 0x55, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x28, 0x0a, 0x24, 0x41,
	0x50, 0x49, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55,
	0x53, 0x5f, 0x52, 0x45, 0x54, 0x55, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x55, 0x4e, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x03, 0x12, 0x19, 0x0a, 0x15, 0x41, 0x50, 0x49, 0x5f, 0x56, 0x45, 0x52,
	0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x44, 0x5f, 0x46, 0x46, 0x49, 0x10, 0x04,
	0x2a, 0x3a, 0x0a, 0x04, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x13, 0x0a, 0x0f, 0x55, 0x4e, 0x44, 0x45,
	0x46, 0x49, 0x4e, 0x45, 0x44, 0x5f, 0x41, 0x4c, 0x49, 0x41, 0x53, 0x10, 0x00, 0x12, 0x0d, 0x0a,
	0x09, 0x4d, 0x41, 0x59, 0x5f, 0x41, 0x4c, 0x49, 0x41, 0x53, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a,
	0x4d, 0x55, 0x53, 0x54, 0x5f, 0x41, 0x4c, 0x49, 0x41, 0x53, 0x10, 0x02, 0x42, 0x03, 0xf8, 0x01,
	0x01, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var (
	file_xla_service_hlo_proto_rawDescOnce sync.Once
	file_xla_service_hlo_proto_rawDescData []byte
)

func file_xla_service_hlo_proto_rawDescGZIP() []byte {
	file_xla_service_hlo_proto_rawDescOnce.Do(func() {
		file_xla_service_hlo_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_xla_service_hlo_proto_rawDesc), len(file_xla_service_hlo_proto_rawDesc)))
	})
	return file_xla_service_hlo_proto_rawDescData
}

var file_xla_service_hlo_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_xla_service_hlo_proto_msgTypes = make([]protoimpl.MessageInfo, 34)
var file_xla_service_hlo_proto_goTypes = []any{
	(CustomCallSchedule)(0),                      // 0: xla.CustomCallSchedule
	(CustomCallApiVersion)(0),                    // 1: xla.CustomCallApiVersion
	(Kind)(0),                                    // 2: xla.Kind
	(HloModuleProto_ProfileType)(0),              // 3: xla.HloModuleProto.ProfileType
	(HeapSimulatorTrace_Event_Kind)(0),           // 4: xla.HeapSimulatorTrace.Event.Kind
	(*HloInstructionProto)(nil),                  // 5: xla.HloInstructionProto
	(*HloComputationProto)(nil),                  // 6: xla.HloComputationProto
	(*HloScheduleProto)(nil),                     // 7: xla.HloScheduleProto
	(*HloInputOutputAliasProto)(nil),             // 8: xla.HloInputOutputAliasProto
	(*HloBufferDonorProto)(nil),                  // 9: xla.HloBufferDonorProto
	(*CrossProgramPrefetch)(nil),                 // 10: xla.CrossProgramPrefetch
	(*StackFrameIndexProto)(nil),                 // 11: xla.StackFrameIndexProto
	(*HloModuleProto)(nil),                       // 12: xla.HloModuleProto
	(*LogicalBufferProto)(nil),                   // 13: xla.LogicalBufferProto
	(*BufferAllocationProto)(nil),                // 14: xla.BufferAllocationProto
	(*HeapSimulatorTrace)(nil),                   // 15: xla.HeapSimulatorTrace
	(*HloModuleGroupProto)(nil),                  // 16: xla.HloModuleGroupProto
	(*BufferAssignmentProto)(nil),                // 17: xla.BufferAssignmentProto
	(*HloProto)(nil),                             // 18: xla.HloProto
	(*HloSnapshot)(nil),                          // 19: xla.HloSnapshot
	(*HloInputs)(nil),                            // 20: xla.HloInputs
	(*HloUnoptimizedSnapshot)(nil),               // 21: xla.HloUnoptimizedSnapshot
	(*HloModuleMetadataProto)(nil),               // 22: xla.HloModuleMetadataProto
	(*HloPassMetadata)(nil),                      // 23: xla.HloPassMetadata
	(*OriginalValueRecoveryTableProto)(nil),      // 24: xla.OriginalValueRecoveryTableProto
	(*HloInstructionProto_SliceDimensions)(nil),  // 25: xla.HloInstructionProto.SliceDimensions
	(*HloScheduleProto_InstructionSequence)(nil), // 26: xla.HloScheduleProto.InstructionSequence
	nil, // 27: xla.HloScheduleProto.SequencesEntry
	(*HloInputOutputAliasProto_AliasEntryProto)(nil),  // 28: xla.HloInputOutputAliasProto.AliasEntryProto
	(*HloBufferDonorProto_BufferDonorEntryProto)(nil), // 29: xla.HloBufferDonorProto.BufferDonorEntryProto
	(*StackFrameIndexProto_FileLocation)(nil),         // 30: xla.StackFrameIndexProto.FileLocation
	(*StackFrameIndexProto_StackFrame)(nil),           // 31: xla.StackFrameIndexProto.StackFrame
	(*HloModuleProto_ProfileInfo)(nil),                // 32: xla.HloModuleProto.ProfileInfo
	(*LogicalBufferProto_Location)(nil),               // 33: xla.LogicalBufferProto.Location
	(*BufferAllocationProto_Assigned)(nil),            // 34: xla.BufferAllocationProto.Assigned
	(*HeapSimulatorTrace_Event)(nil),                  // 35: xla.HeapSimulatorTrace.Event
	(*BufferAssignmentProto_BufferAlias)(nil),         // 36: xla.BufferAssignmentProto.BufferAlias
	(*HloInputs_LiteralDescriptor)(nil),               // 37: xla.HloInputs.LiteralDescriptor
	(*OriginalValueRecoveryTableProto_Entry)(nil),     // 38: xla.OriginalValueRecoveryTableProto.Entry
	(*xla_data.ShapeProto)(nil),                       // 39: xla.ShapeProto
	(*xla_data.OpMetadata)(nil),                       // 40: xla.OpMetadata
	(*xla_data.LiteralProto)(nil),                     // 41: xla.LiteralProto
	(*xla_data.Window)(nil),                           // 42: xla.Window
	(*xla_data.ConvolutionDimensionNumbers)(nil),      // 43: xla.ConvolutionDimensionNumbers
	(*xla_data.PaddingConfig)(nil),                    // 44: xla.PaddingConfig
	(xla_data.RandomDistribution)(0),                  // 45: xla.RandomDistribution
	(*xla_data.DotDimensionNumbers)(nil),              // 46: xla.DotDimensionNumbers
	(*xla_data.RaggedDotDimensionNumbers)(nil),        // 47: xla.RaggedDotDimensionNumbers
	(xla_data.FftType)(0),                             // 48: xla.FftType
	(*xla_data.GatherDimensionNumbers)(nil),           // 49: xla.GatherDimensionNumbers
	(*xla_data.OpSharding)(nil),                       // 50: xla.OpSharding
	(*xla_data.ReplicaGroup)(nil),                     // 51: xla.ReplicaGroup
	(*xla_data.ScatterDimensionNumbers)(nil),          // 52: xla.ScatterDimensionNumbers
	(*xla_data.PrecisionConfig)(nil),                  // 53: xla.PrecisionConfig
	(*xla_data.SourceTarget)(nil),                     // 54: xla.SourceTarget
	(*xla_data.TriangularSolveOptions)(nil),           // 55: xla.TriangularSolveOptions
	(*xla_data.CholeskyOptions)(nil),                  // 56: xla.CholeskyOptions
	(*xla_data.ParameterReplication)(nil),             // 57: xla.ParameterReplication
	(*xla_data.OutputOperandAliasing)(nil),            // 58: xla.OutputOperandAliasing
	(*xla_data.FrontendAttributes)(nil),               // 59: xla.FrontendAttributes
	(xla_data.RandomAlgorithm)(0),                     // 60: xla.RandomAlgorithm
	(xla_data.PaddingType)(0),                         // 61: xla.PaddingType
	(*xla_data.StatisticsViz)(nil),                    // 62: xla.StatisticsViz
	(*xla_data.CollectiveDeviceListProto)(nil),        // 63: xla.CollectiveDeviceListProto
	(*xla_data.OriginalValueProto)(nil),               // 64: xla.OriginalValueProto
	(*xla_data.ResultAccuracy)(nil),                   // 65: xla.ResultAccuracy
	(*xla_data.ProgramShapeProto)(nil),                // 66: xla.ProgramShapeProto
	(*xla_data.DeviceAssignmentProto)(nil),            // 67: xla.DeviceAssignmentProto
	(*anypb.Any)(nil),                                 // 68: google.protobuf.Any
	(*metrics.KeyValueMetric)(nil),                    // 69: xla.KeyValueMetric
	(xla_data.ProfileSource)(0),                       // 70: xla.ProfileSource
	(xla_data.CompilationEvent)(0),                    // 71: xla.CompilationEvent
	(xla_data.ProfileGenerationStrategy)(0),           // 72: xla.ProfileGenerationStrategy
	(*xla_data.OriginalArrayProto)(nil),               // 73: xla.OriginalArrayProto
}
var file_xla_service_hlo_proto_depIdxs = []int32{
	39, // 0: xla.HloInstructionProto.shape:type_name -> xla.ShapeProto
	40, // 1: xla.HloInstructionProto.metadata:type_name -> xla.OpMetadata
	41, // 2: xla.HloInstructionProto.literal:type_name -> xla.LiteralProto
	42, // 3: xla.HloInstructionProto.window:type_name -> xla.Window
	43, // 4: xla.HloInstructionProto.convolution_dimension_numbers:type_name -> xla.ConvolutionDimensionNumbers
	25, // 5: xla.HloInstructionProto.slice_dimensions:type_name -> xla.HloInstructionProto.SliceDimensions
	44, // 6: xla.HloInstructionProto.padding_config:type_name -> xla.PaddingConfig
	45, // 7: xla.HloInstructionProto.distribution:type_name -> xla.RandomDistribution
	39, // 8: xla.HloInstructionProto.outfeed_shape:type_name -> xla.ShapeProto
	46, // 9: xla.HloInstructionProto.dot_dimension_numbers:type_name -> xla.DotDimensionNumbers
	47, // 10: xla.HloInstructionProto.ragged_dot_dimension_numbers:type_name -> xla.RaggedDotDimensionNumbers
	48, // 11: xla.HloInstructionProto.fft_type:type_name -> xla.FftType
	49, // 12: xla.HloInstructionProto.gather_dimension_numbers:type_name -> xla.GatherDimensionNumbers
	50, // 13: xla.HloInstructionProto.sharding:type_name -> xla.OpSharding
	51, // 14: xla.HloInstructionProto.replica_groups:type_name -> xla.ReplicaGroup
	52, // 15: xla.HloInstructionProto.scatter_dimension_numbers:type_name -> xla.ScatterDimensionNumbers
	53, // 16: xla.HloInstructionProto.precision_config:type_name -> xla.PrecisionConfig
	54, // 17: xla.HloInstructionProto.source_target_pairs:type_name -> xla.SourceTarget
	50, // 18: xla.HloInstructionProto.domain_entry_sharding:type_name -> xla.OpSharding
	50, // 19: xla.HloInstructionProto.domain_exit_sharding:type_name -> xla.OpSharding
	39, // 20: xla.HloInstructionProto.operand_shapes_with_layout:type_name -> xla.ShapeProto
	55, // 21: xla.HloInstructionProto.triangular_solve_options:type_name -> xla.TriangularSolveOptions
	56, // 22: xla.HloInstructionProto.cholesky_options:type_name -> xla.CholeskyOptions
	57, // 23: xla.HloInstructionProto.parameter_replication:type_name -> xla.ParameterReplication
	58, // 24: xla.HloInstructionProto.output_operand_aliasing:type_name -> xla.OutputOperandAliasing
	0,  // 25: xla.HloInstructionProto.custom_call_schedule:type_name -> xla.CustomCallSchedule
	59, // 26: xla.HloInstructionProto.frontend_attributes:type_name -> xla.FrontendAttributes
	60, // 27: xla.HloInstructionProto.rng_algorithm:type_name -> xla.RandomAlgorithm
	61, // 28: xla.HloInstructionProto.padding_type:type_name -> xla.PaddingType
	1,  // 29: xla.HloInstructionProto.custom_call_api_version:type_name -> xla.CustomCallApiVersion
	62, // 30: xla.HloInstructionProto.statistics_viz:type_name -> xla.StatisticsViz
	63, // 31: xla.HloInstructionProto.collective_device_list:type_name -> xla.CollectiveDeviceListProto
	64, // 32: xla.HloInstructionProto.original_value:type_name -> xla.OriginalValueProto
	65, // 33: xla.HloInstructionProto.result_accuracy:type_name -> xla.ResultAccuracy
	5,  // 34: xla.HloComputationProto.instructions:type_name -> xla.HloInstructionProto
	66, // 35: xla.HloComputationProto.program_shape:type_name -> xla.ProgramShapeProto
	27, // 36: xla.HloScheduleProto.sequences:type_name -> xla.HloScheduleProto.SequencesEntry
	28, // 37: xla.HloInputOutputAliasProto.entries:type_name -> xla.HloInputOutputAliasProto.AliasEntryProto
	29, // 38: xla.HloBufferDonorProto.entries:type_name -> xla.HloBufferDonorProto.BufferDonorEntryProto
	30, // 39: xla.StackFrameIndexProto.file_locations:type_name -> xla.StackFrameIndexProto.FileLocation
	31, // 40: xla.StackFrameIndexProto.stack_frames:type_name -> xla.StackFrameIndexProto.StackFrame
	6,  // 41: xla.HloModuleProto.computations:type_name -> xla.HloComputationProto
	66, // 42: xla.HloModuleProto.host_program_shape:type_name -> xla.ProgramShapeProto
	7,  // 43: xla.HloModuleProto.schedule:type_name -> xla.HloScheduleProto
	8,  // 44: xla.HloModuleProto.input_output_alias:type_name -> xla.HloInputOutputAliasProto
	9,  // 45: xla.HloModuleProto.buffer_donor:type_name -> xla.HloBufferDonorProto
	10, // 46: xla.HloModuleProto.cross_program_prefetches:type_name -> xla.CrossProgramPrefetch
	50, // 47: xla.HloModuleProto.spmd_output_sharding:type_name -> xla.OpSharding
	50, // 48: xla.HloModuleProto.spmd_parameters_shardings:type_name -> xla.OpSharding
	32, // 49: xla.HloModuleProto.profile_info:type_name -> xla.HloModuleProto.ProfileInfo
	67, // 50: xla.HloModuleProto.device_assignment:type_name -> xla.DeviceAssignmentProto
	11, // 51: xla.HloModuleProto.stack_frame_index:type_name -> xla.StackFrameIndexProto
	59, // 52: xla.HloModuleProto.frontend_attributes:type_name -> xla.FrontendAttributes
	24, // 53: xla.HloModuleProto.original_value_recovery_table:type_name -> xla.OriginalValueRecoveryTableProto
	33, // 54: xla.LogicalBufferProto.defined_at:type_name -> xla.LogicalBufferProto.Location
	34, // 55: xla.BufferAllocationProto.assigned:type_name -> xla.BufferAllocationProto.Assigned
	35, // 56: xla.HeapSimulatorTrace.events:type_name -> xla.HeapSimulatorTrace.Event
	12, // 57: xla.HloModuleGroupProto.hlo_modules:type_name -> xla.HloModuleProto
	13, // 58: xla.BufferAssignmentProto.logical_buffers:type_name -> xla.LogicalBufferProto
	36, // 59: xla.BufferAssignmentProto.buffer_aliases:type_name -> xla.BufferAssignmentProto.BufferAlias
	14, // 60: xla.BufferAssignmentProto.buffer_allocations:type_name -> xla.BufferAllocationProto
	15, // 61: xla.BufferAssignmentProto.heap_simulator_traces:type_name -> xla.HeapSimulatorTrace
	12, // 62: xla.HloProto.hlo_module:type_name -> xla.HloModuleProto
	17, // 63: xla.HloProto.buffer_assignment:type_name -> xla.BufferAssignmentProto
	18, // 64: xla.HloSnapshot.hlo:type_name -> xla.HloProto
	41, // 65: xla.HloSnapshot.arguments:type_name -> xla.LiteralProto
	41, // 66: xla.HloSnapshot.result:type_name -> xla.LiteralProto
	41, // 67: xla.HloInputs.arguments:type_name -> xla.LiteralProto
	37, // 68: xla.HloInputs.arguments_descriptors:type_name -> xla.HloInputs.LiteralDescriptor
	12, // 69: xla.HloUnoptimizedSnapshot.hlo_module:type_name -> xla.HloModuleProto
	20, // 70: xla.HloUnoptimizedSnapshot.partitions:type_name -> xla.HloInputs
	23, // 71: xla.HloModuleMetadataProto.pass_metadata:type_name -> xla.HloPassMetadata
	68, // 72: xla.HloPassMetadata.custom_metadata:type_name -> google.protobuf.Any
	69, // 73: xla.HloPassMetadata.kv_metrics:type_name -> xla.KeyValueMetric
	38, // 74: xla.OriginalValueRecoveryTableProto.entries:type_name -> xla.OriginalValueRecoveryTableProto.Entry
	26, // 75: xla.HloScheduleProto.SequencesEntry.value:type_name -> xla.HloScheduleProto.InstructionSequence
	2,  // 76: xla.HloInputOutputAliasProto.AliasEntryProto.kind:type_name -> xla.Kind
	3,  // 77: xla.HloModuleProto.ProfileInfo.profile_type:type_name -> xla.HloModuleProto.ProfileType
	70, // 78: xla.HloModuleProto.ProfileInfo.profile_source:type_name -> xla.ProfileSource
	71, // 79: xla.HloModuleProto.ProfileInfo.compilation_event:type_name -> xla.CompilationEvent
	72, // 80: xla.HloModuleProto.ProfileInfo.profile_generation_strategy:type_name -> xla.ProfileGenerationStrategy
	4,  // 81: xla.HeapSimulatorTrace.Event.kind:type_name -> xla.HeapSimulatorTrace.Event.Kind
	33, // 82: xla.BufferAssignmentProto.BufferAlias.location:type_name -> xla.LogicalBufferProto.Location
	73, // 83: xla.OriginalValueRecoveryTableProto.Entry.old_original_array:type_name -> xla.OriginalArrayProto
	73, // 84: xla.OriginalValueRecoveryTableProto.Entry.new_original_array:type_name -> xla.OriginalArrayProto
	12, // 85: xla.OriginalValueRecoveryTableProto.Entry.recovery_module:type_name -> xla.HloModuleProto
	86, // [86:86] is the sub-list for method output_type
	86, // [86:86] is the sub-list for method input_type
	86, // [86:86] is the sub-list for extension type_name
	86, // [86:86] is the sub-list for extension extendee
	0,  // [0:86] is the sub-list for field type_name
}

func init() { file_xla_service_hlo_proto_init() }
func file_xla_service_hlo_proto_init() {
	if File_xla_service_hlo_proto != nil {
		return
	}
	file_xla_service_hlo_proto_msgTypes[0].OneofWrappers = []any{
		(*HloInstructionProto_CrossProgramPrefetchIndex)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_xla_service_hlo_proto_rawDesc), len(file_xla_service_hlo_proto_rawDesc)),
			NumEnums:      5,
			NumMessages:   34,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_xla_service_hlo_proto_goTypes,
		DependencyIndexes: file_xla_service_hlo_proto_depIdxs,
		EnumInfos:         file_xla_service_hlo_proto_enumTypes,
		MessageInfos:      file_xla_service_hlo_proto_msgTypes,
	}.Build()
	File_xla_service_hlo_proto = out.File
	file_xla_service_hlo_proto_goTypes = nil
	file_xla_service_hlo_proto_depIdxs = nil
}
