// Copyright 2017 The OpenXLA Authors.
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//==============================================================================

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.4
// 	protoc        v3.21.12
// source: xla/xla.proto

package xla

import (
	hlo "github.com/gomlx/gopjrt/internal/protos/hlo"
	xla_data "github.com/gomlx/gopjrt/internal/protos/xla_data"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	anypb "google.golang.org/protobuf/types/known/anypb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum to define all collective ops
// that xla supports.
type DebugOptions_CollectiveOpType int32

const (
	DebugOptions_NOOP                DebugOptions_CollectiveOpType = 0
	DebugOptions_ALLREDUCE           DebugOptions_CollectiveOpType = 1
	DebugOptions_ALLGATHER           DebugOptions_CollectiveOpType = 2
	DebugOptions_REDUCESCATTER       DebugOptions_CollectiveOpType = 3
	DebugOptions_COLLECTIVEBROADCAST DebugOptions_CollectiveOpType = 4
	DebugOptions_ALLTOALL            DebugOptions_CollectiveOpType = 5
	DebugOptions_COLLECTIVEPERMUTE   DebugOptions_CollectiveOpType = 6
	DebugOptions_RAGGEDALLTOALL      DebugOptions_CollectiveOpType = 7
	// Add more collectives before ALL
	DebugOptions_ALLCOLLECTIVES DebugOptions_CollectiveOpType = 8
)

// Enum value maps for DebugOptions_CollectiveOpType.
var (
	DebugOptions_CollectiveOpType_name = map[int32]string{
		0: "NOOP",
		1: "ALLREDUCE",
		2: "ALLGATHER",
		3: "REDUCESCATTER",
		4: "COLLECTIVEBROADCAST",
		5: "ALLTOALL",
		6: "COLLECTIVEPERMUTE",
		7: "RAGGEDALLTOALL",
		8: "ALLCOLLECTIVES",
	}
	DebugOptions_CollectiveOpType_value = map[string]int32{
		"NOOP":                0,
		"ALLREDUCE":           1,
		"ALLGATHER":           2,
		"REDUCESCATTER":       3,
		"COLLECTIVEBROADCAST": 4,
		"ALLTOALL":            5,
		"COLLECTIVEPERMUTE":   6,
		"RAGGEDALLTOALL":      7,
		"ALLCOLLECTIVES":      8,
	}
)

func (x DebugOptions_CollectiveOpType) Enum() *DebugOptions_CollectiveOpType {
	p := new(DebugOptions_CollectiveOpType)
	*p = x
	return p
}

func (x DebugOptions_CollectiveOpType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DebugOptions_CollectiveOpType) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_proto_enumTypes[0].Descriptor()
}

func (DebugOptions_CollectiveOpType) Type() protoreflect.EnumType {
	return &file_xla_xla_proto_enumTypes[0]
}

func (x DebugOptions_CollectiveOpType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DebugOptions_CollectiveOpType.Descriptor instead.
func (DebugOptions_CollectiveOpType) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{1, 0}
}

// Commands are categorized into 5 types:
// FUSION represents regular fusion kernels.
// CUBLAS/CUBLASLT, CUDNN, and COLLECTIVES represent library calls.
// CONDITIONALS represents control flow.
type DebugOptions_CommandBufferCmdType int32

const (
	DebugOptions_INVALID                   DebugOptions_CommandBufferCmdType = 0
	DebugOptions_FUSION                    DebugOptions_CommandBufferCmdType = 1
	DebugOptions_CUBLAS                    DebugOptions_CommandBufferCmdType = 2
	DebugOptions_CUDNN                     DebugOptions_CommandBufferCmdType = 3
	DebugOptions_COLLECTIVES               DebugOptions_CommandBufferCmdType = 4
	DebugOptions_CONDITIONAL               DebugOptions_CommandBufferCmdType = 5
	DebugOptions_WHILE                     DebugOptions_CommandBufferCmdType = 6
	DebugOptions_CUSTOM_CALL               DebugOptions_CommandBufferCmdType = 7
	DebugOptions_CUBLASLT                  DebugOptions_CommandBufferCmdType = 8
	DebugOptions_DYNAMIC_SLICE_FUSION      DebugOptions_CommandBufferCmdType = 9
	DebugOptions_DYNAMIC_SLICE_COPY_FUSION DebugOptions_CommandBufferCmdType = 10
)

// Enum value maps for DebugOptions_CommandBufferCmdType.
var (
	DebugOptions_CommandBufferCmdType_name = map[int32]string{
		0:  "INVALID",
		1:  "FUSION",
		2:  "CUBLAS",
		3:  "CUDNN",
		4:  "COLLECTIVES",
		5:  "CONDITIONAL",
		6:  "WHILE",
		7:  "CUSTOM_CALL",
		8:  "CUBLASLT",
		9:  "DYNAMIC_SLICE_FUSION",
		10: "DYNAMIC_SLICE_COPY_FUSION",
	}
	DebugOptions_CommandBufferCmdType_value = map[string]int32{
		"INVALID":                   0,
		"FUSION":                    1,
		"CUBLAS":                    2,
		"CUDNN":                     3,
		"COLLECTIVES":               4,
		"CONDITIONAL":               5,
		"WHILE":                     6,
		"CUSTOM_CALL":               7,
		"CUBLASLT":                  8,
		"DYNAMIC_SLICE_FUSION":      9,
		"DYNAMIC_SLICE_COPY_FUSION": 10,
	}
)

func (x DebugOptions_CommandBufferCmdType) Enum() *DebugOptions_CommandBufferCmdType {
	p := new(DebugOptions_CommandBufferCmdType)
	*p = x
	return p
}

func (x DebugOptions_CommandBufferCmdType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DebugOptions_CommandBufferCmdType) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_proto_enumTypes[1].Descriptor()
}

func (DebugOptions_CommandBufferCmdType) Type() protoreflect.EnumType {
	return &file_xla_xla_proto_enumTypes[1]
}

func (x DebugOptions_CommandBufferCmdType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DebugOptions_CommandBufferCmdType.Descriptor instead.
func (DebugOptions_CommandBufferCmdType) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{1, 1}
}

type DebugOptions_LibNvJitLinkMode int32

const (
	// LibNvJitLink is used if it is available and no buggy version has been
	// detected.
	DebugOptions_LIB_NV_JIT_LINK_MODE_AUTO DebugOptions_LibNvJitLinkMode = 0
	// LibNvJitLink is never used.
	DebugOptions_LIB_NV_JIT_LINK_MODE_DISABLED DebugOptions_LibNvJitLinkMode = 1
	// LibNvJitLink is used always. If it is not available, compilation will
	// fail.
	DebugOptions_LIB_NV_JIT_LINK_MODE_ENABLED DebugOptions_LibNvJitLinkMode = 2
)

// Enum value maps for DebugOptions_LibNvJitLinkMode.
var (
	DebugOptions_LibNvJitLinkMode_name = map[int32]string{
		0: "LIB_NV_JIT_LINK_MODE_AUTO",
		1: "LIB_NV_JIT_LINK_MODE_DISABLED",
		2: "LIB_NV_JIT_LINK_MODE_ENABLED",
	}
	DebugOptions_LibNvJitLinkMode_value = map[string]int32{
		"LIB_NV_JIT_LINK_MODE_AUTO":     0,
		"LIB_NV_JIT_LINK_MODE_DISABLED": 1,
		"LIB_NV_JIT_LINK_MODE_ENABLED":  2,
	}
)

func (x DebugOptions_LibNvJitLinkMode) Enum() *DebugOptions_LibNvJitLinkMode {
	p := new(DebugOptions_LibNvJitLinkMode)
	*p = x
	return p
}

func (x DebugOptions_LibNvJitLinkMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DebugOptions_LibNvJitLinkMode) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_proto_enumTypes[2].Descriptor()
}

func (DebugOptions_LibNvJitLinkMode) Type() protoreflect.EnumType {
	return &file_xla_xla_proto_enumTypes[2]
}

func (x DebugOptions_LibNvJitLinkMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DebugOptions_LibNvJitLinkMode.Descriptor instead.
func (DebugOptions_LibNvJitLinkMode) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{1, 2}
}

// Enables strict PGLE checking. If an FDO profile is specified and latency
// hiding scheduler encounters missing instructions in the profile
// compilation will halt or warn depending on the value of this option.
type DebugOptions_PGLEStrictnessLevel int32

const (
	DebugOptions_PGLE_STRICTNESS_LEVEL_OFF   DebugOptions_PGLEStrictnessLevel = 0
	DebugOptions_PGLE_STRICTNESS_LEVEL_WARN  DebugOptions_PGLEStrictnessLevel = 1
	DebugOptions_PGLE_STRICTNESS_LEVEL_ERROR DebugOptions_PGLEStrictnessLevel = 2
)

// Enum value maps for DebugOptions_PGLEStrictnessLevel.
var (
	DebugOptions_PGLEStrictnessLevel_name = map[int32]string{
		0: "PGLE_STRICTNESS_LEVEL_OFF",
		1: "PGLE_STRICTNESS_LEVEL_WARN",
		2: "PGLE_STRICTNESS_LEVEL_ERROR",
	}
	DebugOptions_PGLEStrictnessLevel_value = map[string]int32{
		"PGLE_STRICTNESS_LEVEL_OFF":   0,
		"PGLE_STRICTNESS_LEVEL_WARN":  1,
		"PGLE_STRICTNESS_LEVEL_ERROR": 2,
	}
)

func (x DebugOptions_PGLEStrictnessLevel) Enum() *DebugOptions_PGLEStrictnessLevel {
	p := new(DebugOptions_PGLEStrictnessLevel)
	*p = x
	return p
}

func (x DebugOptions_PGLEStrictnessLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DebugOptions_PGLEStrictnessLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_proto_enumTypes[3].Descriptor()
}

func (DebugOptions_PGLEStrictnessLevel) Type() protoreflect.EnumType {
	return &file_xla_xla_proto_enumTypes[3]
}

func (x DebugOptions_PGLEStrictnessLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DebugOptions_PGLEStrictnessLevel.Descriptor instead.
func (DebugOptions_PGLEStrictnessLevel) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{1, 3}
}

type DebugOptions_ShapeChecks int32

const (
	// Do not insert any shape checks for dynamically shaped operations; output
	// buffers might contain garbage data if shapes don't match.
	DebugOptions_IGNORE DebugOptions_ShapeChecks = 0
	// Check shapes at runtime, will insert an extra synchronization if shapes
	// cannot be proven correct at compile time.
	DebugOptions_RUNTIME DebugOptions_ShapeChecks = 1
	// Will refuse to compile any program where shape correctness can not be
	// established at compile time.
	DebugOptions_COMPILE_TIME DebugOptions_ShapeChecks = 2
)

// Enum value maps for DebugOptions_ShapeChecks.
var (
	DebugOptions_ShapeChecks_name = map[int32]string{
		0: "IGNORE",
		1: "RUNTIME",
		2: "COMPILE_TIME",
	}
	DebugOptions_ShapeChecks_value = map[string]int32{
		"IGNORE":       0,
		"RUNTIME":      1,
		"COMPILE_TIME": 2,
	}
)

func (x DebugOptions_ShapeChecks) Enum() *DebugOptions_ShapeChecks {
	p := new(DebugOptions_ShapeChecks)
	*p = x
	return p
}

func (x DebugOptions_ShapeChecks) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DebugOptions_ShapeChecks) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_proto_enumTypes[4].Descriptor()
}

func (DebugOptions_ShapeChecks) Type() protoreflect.EnumType {
	return &file_xla_xla_proto_enumTypes[4]
}

func (x DebugOptions_ShapeChecks) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DebugOptions_ShapeChecks.Descriptor instead.
func (DebugOptions_ShapeChecks) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{1, 4}
}

type DebugOptions_WhileLoopUnrolling int32

const (
	DebugOptions_WHILE_LOOP_UNROLLING_NO_UNROLL DebugOptions_WhileLoopUnrolling = 0
	// Has the same effect as setting
	// `xla_gpu_enable_while_loop_double_buffering`.
	DebugOptions_WHILE_LOOP_UNROLLING_DOUBLE_BUFFER DebugOptions_WhileLoopUnrolling = 1
	// Enables full loop unrolling using the same strategy as `DOUBLE_BUFFER`.
	DebugOptions_WHILE_LOOP_UNROLLING_FULL_UNROLL DebugOptions_WhileLoopUnrolling = 2
	// Enables loop unrolling when we have at least one collective within a
	// while loop.
	DebugOptions_WHILE_LOOP_UNROLLING_AUTO_UNROLL DebugOptions_WhileLoopUnrolling = 3
)

// Enum value maps for DebugOptions_WhileLoopUnrolling.
var (
	DebugOptions_WhileLoopUnrolling_name = map[int32]string{
		0: "WHILE_LOOP_UNROLLING_NO_UNROLL",
		1: "WHILE_LOOP_UNROLLING_DOUBLE_BUFFER",
		2: "WHILE_LOOP_UNROLLING_FULL_UNROLL",
		3: "WHILE_LOOP_UNROLLING_AUTO_UNROLL",
	}
	DebugOptions_WhileLoopUnrolling_value = map[string]int32{
		"WHILE_LOOP_UNROLLING_NO_UNROLL":     0,
		"WHILE_LOOP_UNROLLING_DOUBLE_BUFFER": 1,
		"WHILE_LOOP_UNROLLING_FULL_UNROLL":   2,
		"WHILE_LOOP_UNROLLING_AUTO_UNROLL":   3,
	}
)

func (x DebugOptions_WhileLoopUnrolling) Enum() *DebugOptions_WhileLoopUnrolling {
	p := new(DebugOptions_WhileLoopUnrolling)
	*p = x
	return p
}

func (x DebugOptions_WhileLoopUnrolling) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DebugOptions_WhileLoopUnrolling) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_proto_enumTypes[5].Descriptor()
}

func (DebugOptions_WhileLoopUnrolling) Type() protoreflect.EnumType {
	return &file_xla_xla_proto_enumTypes[5]
}

func (x DebugOptions_WhileLoopUnrolling) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DebugOptions_WhileLoopUnrolling.Descriptor instead.
func (DebugOptions_WhileLoopUnrolling) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{1, 5}
}

// --------------------------------------------------------------------------//
// XLA:CPU options.
// --------------------------------------------------------------------------//
// clang-format off
// go/keep-sorted start newline_separated=yes skip_lines=1 ignore_prefixes=["optional bool","optional int32","optional string", "optional XnnGraphFusionMode", "repeated LibraryFusionType"]
// clang-format on
type DebugOptions_LibraryFusionType int32

const (
	DebugOptions_LIBRARY_FUSION_TYPE_INVALID DebugOptions_LibraryFusionType = 0
	DebugOptions_LIBRARY_FUSION_TYPE_DOT     DebugOptions_LibraryFusionType = 1 // Dot and any eltwise ops around it.
	DebugOptions_LIBRARY_FUSION_TYPE_ELTWISE DebugOptions_LibraryFusionType = 2
	DebugOptions_LIBRARY_FUSION_TYPE_REDUCE  DebugOptions_LibraryFusionType = 3
)

// Enum value maps for DebugOptions_LibraryFusionType.
var (
	DebugOptions_LibraryFusionType_name = map[int32]string{
		0: "LIBRARY_FUSION_TYPE_INVALID",
		1: "LIBRARY_FUSION_TYPE_DOT",
		2: "LIBRARY_FUSION_TYPE_ELTWISE",
		3: "LIBRARY_FUSION_TYPE_REDUCE",
	}
	DebugOptions_LibraryFusionType_value = map[string]int32{
		"LIBRARY_FUSION_TYPE_INVALID": 0,
		"LIBRARY_FUSION_TYPE_DOT":     1,
		"LIBRARY_FUSION_TYPE_ELTWISE": 2,
		"LIBRARY_FUSION_TYPE_REDUCE":  3,
	}
)

func (x DebugOptions_LibraryFusionType) Enum() *DebugOptions_LibraryFusionType {
	p := new(DebugOptions_LibraryFusionType)
	*p = x
	return p
}

func (x DebugOptions_LibraryFusionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DebugOptions_LibraryFusionType) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_proto_enumTypes[6].Descriptor()
}

func (DebugOptions_LibraryFusionType) Type() protoreflect.EnumType {
	return &file_xla_xla_proto_enumTypes[6]
}

func (x DebugOptions_LibraryFusionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DebugOptions_LibraryFusionType.Descriptor instead.
func (DebugOptions_LibraryFusionType) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{1, 6}
}

type DebugOptions_XnnGraphFusionMode int32

const (
	DebugOptions_XNN_GRAPH_FUSION_MODE_DISABLED          DebugOptions_XnnGraphFusionMode = 0
	DebugOptions_XNN_GRAPH_FUSION_MODE_GREEDY            DebugOptions_XnnGraphFusionMode = 1
	DebugOptions_XNN_GRAPH_FUSION_MODE_GREEDY_SLINKY     DebugOptions_XnnGraphFusionMode = 2
	DebugOptions_XNN_GRAPH_FUSION_MODE_BYPASS_COST_MODEL DebugOptions_XnnGraphFusionMode = 3
)

// Enum value maps for DebugOptions_XnnGraphFusionMode.
var (
	DebugOptions_XnnGraphFusionMode_name = map[int32]string{
		0: "XNN_GRAPH_FUSION_MODE_DISABLED",
		1: "XNN_GRAPH_FUSION_MODE_GREEDY",
		2: "XNN_GRAPH_FUSION_MODE_GREEDY_SLINKY",
		3: "XNN_GRAPH_FUSION_MODE_BYPASS_COST_MODEL",
	}
	DebugOptions_XnnGraphFusionMode_value = map[string]int32{
		"XNN_GRAPH_FUSION_MODE_DISABLED":          0,
		"XNN_GRAPH_FUSION_MODE_GREEDY":            1,
		"XNN_GRAPH_FUSION_MODE_GREEDY_SLINKY":     2,
		"XNN_GRAPH_FUSION_MODE_BYPASS_COST_MODEL": 3,
	}
)

func (x DebugOptions_XnnGraphFusionMode) Enum() *DebugOptions_XnnGraphFusionMode {
	p := new(DebugOptions_XnnGraphFusionMode)
	*p = x
	return p
}

func (x DebugOptions_XnnGraphFusionMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DebugOptions_XnnGraphFusionMode) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_proto_enumTypes[7].Descriptor()
}

func (DebugOptions_XnnGraphFusionMode) Type() protoreflect.EnumType {
	return &file_xla_xla_proto_enumTypes[7]
}

func (x DebugOptions_XnnGraphFusionMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DebugOptions_XnnGraphFusionMode.Descriptor instead.
func (DebugOptions_XnnGraphFusionMode) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{1, 7}
}

// Command buffer scheduling mode.
// SERIALIZE: Serialize all commands in a command buffer.
// CONCURRENT: Identify concurrent across operator through data conflicts.
// LHS: Uses the same latency hidden scheduling results as adopted by
// LatencyHidingScheduler which hides latencies of operations that can run in
// parallel with other operations.
type DebugOptions_CommandBufferSchedulingMode int32

const (
	DebugOptions_SERIALIZE  DebugOptions_CommandBufferSchedulingMode = 0
	DebugOptions_CONCURRENT DebugOptions_CommandBufferSchedulingMode = 1
	DebugOptions_LHS        DebugOptions_CommandBufferSchedulingMode = 2
)

// Enum value maps for DebugOptions_CommandBufferSchedulingMode.
var (
	DebugOptions_CommandBufferSchedulingMode_name = map[int32]string{
		0: "SERIALIZE",
		1: "CONCURRENT",
		2: "LHS",
	}
	DebugOptions_CommandBufferSchedulingMode_value = map[string]int32{
		"SERIALIZE":  0,
		"CONCURRENT": 1,
		"LHS":        2,
	}
)

func (x DebugOptions_CommandBufferSchedulingMode) Enum() *DebugOptions_CommandBufferSchedulingMode {
	p := new(DebugOptions_CommandBufferSchedulingMode)
	*p = x
	return p
}

func (x DebugOptions_CommandBufferSchedulingMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DebugOptions_CommandBufferSchedulingMode) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_proto_enumTypes[8].Descriptor()
}

func (DebugOptions_CommandBufferSchedulingMode) Type() protoreflect.EnumType {
	return &file_xla_xla_proto_enumTypes[8]
}

func (x DebugOptions_CommandBufferSchedulingMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DebugOptions_CommandBufferSchedulingMode.Descriptor instead.
func (DebugOptions_CommandBufferSchedulingMode) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{1, 8}
}

// Options for the generic Triton emitter.
// Set with xla_gpu_unsupported_generic_triton_emitter_features.
type DebugOptions_GenericTritonEmitterFeature int32

const (
	// No specfic meaning, zero value for protobuf best practices.
	DebugOptions_GENERIC_TRITON_EMITTER_UNSPECIFIED DebugOptions_GenericTritonEmitterFeature = 0
	// Enable nest_gemm_fusion pass to convert gemms to be emitted by the
	// generic Triton emitter.
	DebugOptions_GENERIC_TRITON_EMITTER_ENABLE_NESTED_GEMM DebugOptions_GenericTritonEmitterFeature = 1
	// Disable legacy GEMM emitter, that might lead to crashes if GEMM is not
	// supported by the generic emitter.
	DebugOptions_GENERIC_TRITON_EMITTER_DISABLE_LEGACY_GEMM DebugOptions_GenericTritonEmitterFeature = 2
	// Do not restrict which ops can be present in the GEMM fusion.
	DebugOptions_GENERIC_TRITON_EMITTER_ALLOW_ALL_OPS_IN_GEMM_FUSION DebugOptions_GenericTritonEmitterFeature = 3
	// Do not restrict the shapes of the operands and the result of the dot
	// instruction.
	DebugOptions_GENERIC_TRITON_EMITTER_ALLOW_ALL_GEMM_SHAPES DebugOptions_GenericTritonEmitterFeature = 4
	// Fail in autotuner if any of the configs are not supported.
	// Otherwise, the autotuner will silenly ignore configs that are regected.
	DebugOptions_GENERIC_TRITON_EMITTER_MUST_ACCEPT_ALL_AUTOTUNER_CONFIGS DebugOptions_GenericTritonEmitterFeature = 5
)

// Enum value maps for DebugOptions_GenericTritonEmitterFeature.
var (
	DebugOptions_GenericTritonEmitterFeature_name = map[int32]string{
		0: "GENERIC_TRITON_EMITTER_UNSPECIFIED",
		1: "GENERIC_TRITON_EMITTER_ENABLE_NESTED_GEMM",
		2: "GENERIC_TRITON_EMITTER_DISABLE_LEGACY_GEMM",
		3: "GENERIC_TRITON_EMITTER_ALLOW_ALL_OPS_IN_GEMM_FUSION",
		4: "GENERIC_TRITON_EMITTER_ALLOW_ALL_GEMM_SHAPES",
		5: "GENERIC_TRITON_EMITTER_MUST_ACCEPT_ALL_AUTOTUNER_CONFIGS",
	}
	DebugOptions_GenericTritonEmitterFeature_value = map[string]int32{
		"GENERIC_TRITON_EMITTER_UNSPECIFIED":                       0,
		"GENERIC_TRITON_EMITTER_ENABLE_NESTED_GEMM":                1,
		"GENERIC_TRITON_EMITTER_DISABLE_LEGACY_GEMM":               2,
		"GENERIC_TRITON_EMITTER_ALLOW_ALL_OPS_IN_GEMM_FUSION":      3,
		"GENERIC_TRITON_EMITTER_ALLOW_ALL_GEMM_SHAPES":             4,
		"GENERIC_TRITON_EMITTER_MUST_ACCEPT_ALL_AUTOTUNER_CONFIGS": 5,
	}
)

func (x DebugOptions_GenericTritonEmitterFeature) Enum() *DebugOptions_GenericTritonEmitterFeature {
	p := new(DebugOptions_GenericTritonEmitterFeature)
	*p = x
	return p
}

func (x DebugOptions_GenericTritonEmitterFeature) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DebugOptions_GenericTritonEmitterFeature) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_proto_enumTypes[9].Descriptor()
}

func (DebugOptions_GenericTritonEmitterFeature) Type() protoreflect.EnumType {
	return &file_xla_xla_proto_enumTypes[9]
}

func (x DebugOptions_GenericTritonEmitterFeature) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DebugOptions_GenericTritonEmitterFeature.Descriptor instead.
func (DebugOptions_GenericTritonEmitterFeature) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{1, 9}
}

// Experimental optimizations for SPMD-based pipeline parallelism on GPU.
type DebugOptions_PipelineParallelismOptLevel int32

const (
	DebugOptions_PIPELINE_PARALLELISM_OPT_LEVEL_DISABLE DebugOptions_PipelineParallelismOptLevel = 0
	// Enable only collective-permute decomposer to overlap send and recv
	// separately, allowing to reveive data in the previous iteration while
	// sending the current iteration.
	DebugOptions_PIPELINE_PARALLELISM_OPT_LEVEL_ENABLE DebugOptions_PipelineParallelismOptLevel = 1
)

// Enum value maps for DebugOptions_PipelineParallelismOptLevel.
var (
	DebugOptions_PipelineParallelismOptLevel_name = map[int32]string{
		0: "PIPELINE_PARALLELISM_OPT_LEVEL_DISABLE",
		1: "PIPELINE_PARALLELISM_OPT_LEVEL_ENABLE",
	}
	DebugOptions_PipelineParallelismOptLevel_value = map[string]int32{
		"PIPELINE_PARALLELISM_OPT_LEVEL_DISABLE": 0,
		"PIPELINE_PARALLELISM_OPT_LEVEL_ENABLE":  1,
	}
)

func (x DebugOptions_PipelineParallelismOptLevel) Enum() *DebugOptions_PipelineParallelismOptLevel {
	p := new(DebugOptions_PipelineParallelismOptLevel)
	*p = x
	return p
}

func (x DebugOptions_PipelineParallelismOptLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DebugOptions_PipelineParallelismOptLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_proto_enumTypes[10].Descriptor()
}

func (DebugOptions_PipelineParallelismOptLevel) Type() protoreflect.EnumType {
	return &file_xla_xla_proto_enumTypes[10]
}

func (x DebugOptions_PipelineParallelismOptLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DebugOptions_PipelineParallelismOptLevel.Descriptor instead.
func (DebugOptions_PipelineParallelismOptLevel) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{1, 10}
}

type DebugOptions_StepMarkerLocation int32

const (
	// Generate a step marker at the program entry. This handles the case where
	// each step is done by one or multiple program execution(s). Only the first
	// program will be tagged for generating a step marker at the program entry.
	// This is the default.
	DebugOptions_STEP_MARK_AT_ENTRY DebugOptions_StepMarkerLocation = 0
	// Generate a step marker at each iteration of the top level while loop,
	// which is assumed to be a training loop.
	DebugOptions_STEP_MARK_AT_TOP_LEVEL_WHILE_LOOP DebugOptions_StepMarkerLocation = 1
	// Generate a step marker at each iteration of the second level while loops,
	// which is assumed to be a training or eval loop.
	DebugOptions_STEP_MARK_AT_SECOND_LEVEL_WHILE_LOOP DebugOptions_StepMarkerLocation = 3
	// No step marker generated.
	DebugOptions_STEP_MARK_NONE DebugOptions_StepMarkerLocation = 2
)

// Enum value maps for DebugOptions_StepMarkerLocation.
var (
	DebugOptions_StepMarkerLocation_name = map[int32]string{
		0: "STEP_MARK_AT_ENTRY",
		1: "STEP_MARK_AT_TOP_LEVEL_WHILE_LOOP",
		3: "STEP_MARK_AT_SECOND_LEVEL_WHILE_LOOP",
		2: "STEP_MARK_NONE",
	}
	DebugOptions_StepMarkerLocation_value = map[string]int32{
		"STEP_MARK_AT_ENTRY":                   0,
		"STEP_MARK_AT_TOP_LEVEL_WHILE_LOOP":    1,
		"STEP_MARK_AT_SECOND_LEVEL_WHILE_LOOP": 3,
		"STEP_MARK_NONE":                       2,
	}
)

func (x DebugOptions_StepMarkerLocation) Enum() *DebugOptions_StepMarkerLocation {
	p := new(DebugOptions_StepMarkerLocation)
	*p = x
	return p
}

func (x DebugOptions_StepMarkerLocation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DebugOptions_StepMarkerLocation) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_proto_enumTypes[11].Descriptor()
}

func (DebugOptions_StepMarkerLocation) Type() protoreflect.EnumType {
	return &file_xla_xla_proto_enumTypes[11]
}

func (x DebugOptions_StepMarkerLocation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DebugOptions_StepMarkerLocation.Descriptor instead.
func (DebugOptions_StepMarkerLocation) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{1, 11}
}

type DebugOptions_PartitioningAlgorithm int32

const (
	DebugOptions_PARTITIONING_ALGORITHM_NOOP DebugOptions_PartitioningAlgorithm = 0
	DebugOptions_PARTITIONING_ALGORITHM_EXP0 DebugOptions_PartitioningAlgorithm = 1
	DebugOptions_PARTITIONING_ALGORITHM_EXP1 DebugOptions_PartitioningAlgorithm = 2
	DebugOptions_PARTITIONING_ALGORITHM_EXP2 DebugOptions_PartitioningAlgorithm = 3
)

// Enum value maps for DebugOptions_PartitioningAlgorithm.
var (
	DebugOptions_PartitioningAlgorithm_name = map[int32]string{
		0: "PARTITIONING_ALGORITHM_NOOP",
		1: "PARTITIONING_ALGORITHM_EXP0",
		2: "PARTITIONING_ALGORITHM_EXP1",
		3: "PARTITIONING_ALGORITHM_EXP2",
	}
	DebugOptions_PartitioningAlgorithm_value = map[string]int32{
		"PARTITIONING_ALGORITHM_NOOP": 0,
		"PARTITIONING_ALGORITHM_EXP0": 1,
		"PARTITIONING_ALGORITHM_EXP1": 2,
		"PARTITIONING_ALGORITHM_EXP2": 3,
	}
)

func (x DebugOptions_PartitioningAlgorithm) Enum() *DebugOptions_PartitioningAlgorithm {
	p := new(DebugOptions_PartitioningAlgorithm)
	*p = x
	return p
}

func (x DebugOptions_PartitioningAlgorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DebugOptions_PartitioningAlgorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_proto_enumTypes[12].Descriptor()
}

func (DebugOptions_PartitioningAlgorithm) Type() protoreflect.EnumType {
	return &file_xla_xla_proto_enumTypes[12]
}

func (x DebugOptions_PartitioningAlgorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DebugOptions_PartitioningAlgorithm.Descriptor instead.
func (DebugOptions_PartitioningAlgorithm) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{1, 12}
}

type DebugOptions_UnstableReductionDetectionMode int32

const (
	DebugOptions_UNSTABLE_REDUCTION_DETECTION_MODE_NONE    DebugOptions_UnstableReductionDetectionMode = 0
	DebugOptions_UNSTABLE_REDUCTION_DETECTION_MODE_WARNING DebugOptions_UnstableReductionDetectionMode = 1
	DebugOptions_UNSTABLE_REDUCTION_DETECTION_MODE_FAIL    DebugOptions_UnstableReductionDetectionMode = 2
)

// Enum value maps for DebugOptions_UnstableReductionDetectionMode.
var (
	DebugOptions_UnstableReductionDetectionMode_name = map[int32]string{
		0: "UNSTABLE_REDUCTION_DETECTION_MODE_NONE",
		1: "UNSTABLE_REDUCTION_DETECTION_MODE_WARNING",
		2: "UNSTABLE_REDUCTION_DETECTION_MODE_FAIL",
	}
	DebugOptions_UnstableReductionDetectionMode_value = map[string]int32{
		"UNSTABLE_REDUCTION_DETECTION_MODE_NONE":    0,
		"UNSTABLE_REDUCTION_DETECTION_MODE_WARNING": 1,
		"UNSTABLE_REDUCTION_DETECTION_MODE_FAIL":    2,
	}
)

func (x DebugOptions_UnstableReductionDetectionMode) Enum() *DebugOptions_UnstableReductionDetectionMode {
	p := new(DebugOptions_UnstableReductionDetectionMode)
	*p = x
	return p
}

func (x DebugOptions_UnstableReductionDetectionMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DebugOptions_UnstableReductionDetectionMode) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_proto_enumTypes[13].Descriptor()
}

func (DebugOptions_UnstableReductionDetectionMode) Type() protoreflect.EnumType {
	return &file_xla_xla_proto_enumTypes[13]
}

func (x DebugOptions_UnstableReductionDetectionMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DebugOptions_UnstableReductionDetectionMode.Descriptor instead.
func (DebugOptions_UnstableReductionDetectionMode) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{1, 13}
}

type DebugOptions_AutotuneCacheMode int32

const (
	DebugOptions_AUTOTUNE_CACHE_MODE_UNSPECIFIED DebugOptions_AutotuneCacheMode = 0
	// If the cache exists per fusion autotuner loads it and terminates,
	// otherwise runs autotuner and dumps the result.
	DebugOptions_AUTOTUNE_CACHE_MODE_UPDATE DebugOptions_AutotuneCacheMode = 1
	// Sets readonly access to the cache for the per fusion autotuner. Same as
	// above, but doesn't dump anything.
	DebugOptions_AUTOTUNE_CACHE_MODE_READ DebugOptions_AutotuneCacheMode = 2
)

// Enum value maps for DebugOptions_AutotuneCacheMode.
var (
	DebugOptions_AutotuneCacheMode_name = map[int32]string{
		0: "AUTOTUNE_CACHE_MODE_UNSPECIFIED",
		1: "AUTOTUNE_CACHE_MODE_UPDATE",
		2: "AUTOTUNE_CACHE_MODE_READ",
	}
	DebugOptions_AutotuneCacheMode_value = map[string]int32{
		"AUTOTUNE_CACHE_MODE_UNSPECIFIED": 0,
		"AUTOTUNE_CACHE_MODE_UPDATE":      1,
		"AUTOTUNE_CACHE_MODE_READ":        2,
	}
)

func (x DebugOptions_AutotuneCacheMode) Enum() *DebugOptions_AutotuneCacheMode {
	p := new(DebugOptions_AutotuneCacheMode)
	*p = x
	return p
}

func (x DebugOptions_AutotuneCacheMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DebugOptions_AutotuneCacheMode) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_proto_enumTypes[14].Descriptor()
}

func (DebugOptions_AutotuneCacheMode) Type() protoreflect.EnumType {
	return &file_xla_xla_proto_enumTypes[14]
}

func (x DebugOptions_AutotuneCacheMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DebugOptions_AutotuneCacheMode.Descriptor instead.
func (DebugOptions_AutotuneCacheMode) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{1, 14}
}

type ExecutionOptions_EffortLevel int32

const (
	ExecutionOptions_EFFORT_UNKNOWN ExecutionOptions_EffortLevel = 0
	// The values in this enum are intended to be comparable, such that higher
	// values represent higher effort spent. The addition of new values must
	// maintain this property.
	ExecutionOptions_EFFORT_O0 ExecutionOptions_EffortLevel = 9
	ExecutionOptions_EFFORT_O1 ExecutionOptions_EffortLevel = 19
	ExecutionOptions_EFFORT_O2 ExecutionOptions_EffortLevel = 29
	ExecutionOptions_EFFORT_O3 ExecutionOptions_EffortLevel = 39
)

// Enum value maps for ExecutionOptions_EffortLevel.
var (
	ExecutionOptions_EffortLevel_name = map[int32]string{
		0:  "EFFORT_UNKNOWN",
		9:  "EFFORT_O0",
		19: "EFFORT_O1",
		29: "EFFORT_O2",
		39: "EFFORT_O3",
	}
	ExecutionOptions_EffortLevel_value = map[string]int32{
		"EFFORT_UNKNOWN": 0,
		"EFFORT_O0":      9,
		"EFFORT_O1":      19,
		"EFFORT_O2":      29,
		"EFFORT_O3":      39,
	}
)

func (x ExecutionOptions_EffortLevel) Enum() *ExecutionOptions_EffortLevel {
	p := new(ExecutionOptions_EffortLevel)
	*p = x
	return p
}

func (x ExecutionOptions_EffortLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExecutionOptions_EffortLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_proto_enumTypes[15].Descriptor()
}

func (ExecutionOptions_EffortLevel) Type() protoreflect.EnumType {
	return &file_xla_xla_proto_enumTypes[15]
}

func (x ExecutionOptions_EffortLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExecutionOptions_EffortLevel.Descriptor instead.
func (ExecutionOptions_EffortLevel) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{4, 0}
}

type HloModuleConfigProto_FusionConfigCollection int32

const (
	HloModuleConfigProto_OFF      HloModuleConfigProto_FusionConfigCollection = 0 // Do not collect configuration.
	HloModuleConfigProto_PER_EDGE HloModuleConfigProto_FusionConfigCollection = 1 // Collect per-edge configuration.
	HloModuleConfigProto_PER_NODE HloModuleConfigProto_FusionConfigCollection = 2 // Collect per-node configuration.
)

// Enum value maps for HloModuleConfigProto_FusionConfigCollection.
var (
	HloModuleConfigProto_FusionConfigCollection_name = map[int32]string{
		0: "OFF",
		1: "PER_EDGE",
		2: "PER_NODE",
	}
	HloModuleConfigProto_FusionConfigCollection_value = map[string]int32{
		"OFF":      0,
		"PER_EDGE": 1,
		"PER_NODE": 2,
	}
)

func (x HloModuleConfigProto_FusionConfigCollection) Enum() *HloModuleConfigProto_FusionConfigCollection {
	p := new(HloModuleConfigProto_FusionConfigCollection)
	*p = x
	return p
}

func (x HloModuleConfigProto_FusionConfigCollection) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HloModuleConfigProto_FusionConfigCollection) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_proto_enumTypes[16].Descriptor()
}

func (HloModuleConfigProto_FusionConfigCollection) Type() protoreflect.EnumType {
	return &file_xla_xla_proto_enumTypes[16]
}

func (x HloModuleConfigProto_FusionConfigCollection) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HloModuleConfigProto_FusionConfigCollection.Descriptor instead.
func (HloModuleConfigProto_FusionConfigCollection) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{5, 0}
}

// Proto version of `xla::CompilationEnvironments`.
type CompilationEnvironmentsProto struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Environments  []*anypb.Any           `protobuf:"bytes,1,rep,name=environments,proto3" json:"environments,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CompilationEnvironmentsProto) Reset() {
	*x = CompilationEnvironmentsProto{}
	mi := &file_xla_xla_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CompilationEnvironmentsProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompilationEnvironmentsProto) ProtoMessage() {}

func (x *CompilationEnvironmentsProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompilationEnvironmentsProto.ProtoReflect.Descriptor instead.
func (*CompilationEnvironmentsProto) Descriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{0}
}

func (x *CompilationEnvironmentsProto) GetEnvironments() []*anypb.Any {
	if x != nil {
		return x.Environments
	}
	return nil
}

// Debugging options for XLA. These options may change at any time - there are
// no guarantees about backward or forward compatibility for these fields with
// the exception of few stable GPU feature flags (see `GetFlagStatus` in
// `debug_options_flags.cc`).
//
// Debug options naming and organization:
//
//  1. Backend-agnostic options: `xla_$flag_name` - go first, and sorted
//     alphabetically by the flag name.
//
//  2. Backend-specific options: `xla_$backend_$flag_name` - must be in the
//     corresponding backend section, and sorted alphabetically by the flag name.
//
// All singular scalar fields must be explicitly defined as `optional` so that
// field presence is available to support merging between command-line flags and
// stored instances. This is enforced via a unit test.
type DebugOptions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Return an error if HostOffloader would have automatically offloaded some
	// compute to the host.
	XlaDisableAutomaticHostComputeOffload *bool `protobuf:"varint,408,opt,name=xla_disable_automatic_host_compute_offload,json=xlaDisableAutomaticHostComputeOffload,proto3,oneof" json:"xla_disable_automatic_host_compute_offload,omitempty"`
	// Perform hash-based cycle detection in fixed-point loops.
	XlaHloPassFixDetectCycles *bool `protobuf:"varint,370,opt,name=xla_hlo_pass_fix_detect_cycles,json=xlaHloPassFixDetectCycles,proto3,oneof" json:"xla_hlo_pass_fix_detect_cycles,omitempty"`
	// Crash if HloPassFix can not converge after a fixed number of iterations.
	XlaUnsupportedCrashOnHloPassFixMaxIterations *bool `protobuf:"varint,363,opt,name=xla_unsupported_crash_on_hlo_pass_fix_max_iterations,json=xlaUnsupportedCrashOnHloPassFixMaxIterations,proto3,oneof" json:"xla_unsupported_crash_on_hlo_pass_fix_max_iterations,omitempty"`
	// Crash if a pass reports that it changes the HLO but in fact it did not.
	XlaUnsupportedCrashOnHloPassNoopChange *bool `protobuf:"varint,379,opt,name=xla_unsupported_crash_on_hlo_pass_noop_change,json=xlaUnsupportedCrashOnHloPassNoopChange,proto3,oneof" json:"xla_unsupported_crash_on_hlo_pass_noop_change,omitempty"`
	// Crash if a pass reports that it did not change the HLO but in fact it did.
	XlaUnsupportedCrashOnHloPassSilentHloChange *bool `protobuf:"varint,380,opt,name=xla_unsupported_crash_on_hlo_pass_silent_hlo_change,json=xlaUnsupportedCrashOnHloPassSilentHloChange,proto3,oneof" json:"xla_unsupported_crash_on_hlo_pass_silent_hlo_change,omitempty"` // go/keep-sorted end
	// Use region analysis in copy insertion pass.
	XlaCpuCopyInsertionUseRegionAnalysis *bool `protobuf:"varint,337,opt,name=xla_cpu_copy_insertion_use_region_analysis,json=xlaCpuCopyInsertionUseRegionAnalysis,proto3,oneof" json:"xla_cpu_copy_insertion_use_region_analysis,omitempty"`
	// Sets how often we verify the emitted modules. Higher "levels mean
	// more frequent verification. Currently supported: 0, 1.
	XlaCpuEmitterVerificationLevel *int32 `protobuf:"varint,395,opt,name=xla_cpu_emitter_verification_level,json=xlaCpuEmitterVerificationLevel,proto3,oneof" json:"xla_cpu_emitter_verification_level,omitempty"`
	// When true, XLA:CPU uses HLO module scheduler that is optimized for
	// extracting concurrency at the cost of extra memory: we extend the live
	// ranges of temporaries to allow XLA runtime to schedule independent
	// operations in parallel on separate threads.
	XlaCpuEnableConcurrencyOptimizedScheduler *bool `protobuf:"varint,307,opt,name=xla_cpu_enable_concurrency_optimized_scheduler,json=xlaCpuEnableConcurrencyOptimizedScheduler,proto3,oneof" json:"xla_cpu_enable_concurrency_optimized_scheduler,omitempty"`
	// When true, "unsafe" mathematical optimizations are enabled. These
	// transformations include but are not limited to:
	//
	//   - Reducing the precision of operations (e.g. using an approximate sin
	//     function, or transforming x/y into x * (1/y)).
	//   - Assuming that operations never produce or consume NaN or +/- Inf (this
	//     behavior can be adjusted using xla_cpu_fast_math_allow_{nans|infs}).
	//   - Assuming that +0 and -0 are indistinguishable.
	XlaCpuEnableFastMath *bool `protobuf:"varint,99,opt,name=xla_cpu_enable_fast_math,json=xlaCpuEnableFastMath,proto3,oneof" json:"xla_cpu_enable_fast_math,omitempty"`
	// When false we lower the Minimum and Maximum hlos in the CPU backend such
	// that Min(NotNaN, NaN) = Min(NaN, NotNaN) = NaN.  In other words, if flag
	// this is false we always propagate NaNs through Min and Max.
	//
	// Note, this does not correspond to the exact same behavior as the gpu flag
	// below!
	XlaCpuEnableFastMinMax *bool `protobuf:"varint,140,opt,name=xla_cpu_enable_fast_min_max,json=xlaCpuEnableFastMinMax,proto3,oneof" json:"xla_cpu_enable_fast_min_max,omitempty"`
	// Call oneDNN custom call thunks in the CPU backend
	XlaCpuExperimentalOnednnCustomCall *bool `protobuf:"varint,412,opt,name=xla_cpu_experimental_onednn_custom_call,json=xlaCpuExperimentalOnednnCustomCall,proto3,oneof" json:"xla_cpu_experimental_onednn_custom_call,omitempty"`
	// Stores the fusion types enabled for oneDNN in DotLibraryRewriter pass.
	XlaCpuExperimentalOnednnFusionType []DebugOptions_LibraryFusionType `protobuf:"varint,399,rep,packed,name=xla_cpu_experimental_onednn_fusion_type,json=xlaCpuExperimentalOnednnFusionType,proto3,enum=xla.DebugOptions_LibraryFusionType" json:"xla_cpu_experimental_onednn_fusion_type,omitempty"`
	// Stores the fusion types enabled for XNNPACK in DotLibraryRewriter pass.
	XlaCpuExperimentalXnnFusionType []DebugOptions_LibraryFusionType `protobuf:"varint,400,rep,packed,name=xla_cpu_experimental_xnn_fusion_type,json=xlaCpuExperimentalXnnFusionType,proto3,enum=xla.DebugOptions_LibraryFusionType" json:"xla_cpu_experimental_xnn_fusion_type,omitempty"`
	// Controls XnnGraphFusion HLO pass.
	XlaCpuExperimentalXnnGraphFusionMode *DebugOptions_XnnGraphFusionMode `protobuf:"varint,365,opt,name=xla_cpu_experimental_xnn_graph_fusion_mode,json=xlaCpuExperimentalXnnGraphFusionMode,proto3,enum=xla.DebugOptions_XnnGraphFusionMode,oneof" json:"xla_cpu_experimental_xnn_graph_fusion_mode,omitempty"`
	// When xla_cpu_enable_fast_math is true then this controls whether we forbid
	// to use the reciprocal of an argument instead of division. Ignored when
	// xla_cpu_enable_fast_math is false.
	XlaCpuFastMathHonorDivision *bool `protobuf:"varint,126,opt,name=xla_cpu_fast_math_honor_division,json=xlaCpuFastMathHonorDivision,proto3,oneof" json:"xla_cpu_fast_math_honor_division,omitempty"`
	// When xla_cpu_enable_fast_math is true then this controls whether we forbid
	// to approximate calculations for functions. Ignored when
	// xla_cpu_enable_fast_math is false.
	XlaCpuFastMathHonorFunctions *bool `protobuf:"varint,129,opt,name=xla_cpu_fast_math_honor_functions,json=xlaCpuFastMathHonorFunctions,proto3,oneof" json:"xla_cpu_fast_math_honor_functions,omitempty"`
	// When xla_cpu_enable_fast_math is true then this controls whether we allow
	// operations to produce infinites. Ignored when xla_cpu_enable_fast_math is
	// false.
	XlaCpuFastMathHonorInfs *bool `protobuf:"varint,121,opt,name=xla_cpu_fast_math_honor_infs,json=xlaCpuFastMathHonorInfs,proto3,oneof" json:"xla_cpu_fast_math_honor_infs,omitempty"`
	// When xla_cpu_enable_fast_math is true then this controls whether we allow
	// operations to produce NaNs.  Ignored when xla_cpu_enable_fast_math is
	// false.
	XlaCpuFastMathHonorNans *bool `protobuf:"varint,120,opt,name=xla_cpu_fast_math_honor_nans,json=xlaCpuFastMathHonorNans,proto3,oneof" json:"xla_cpu_fast_math_honor_nans,omitempty"`
	// When true, XLA:CPU all LLVM kernels entry points will be prefixed with the
	// module name. They will also be converted to C style names. This is required
	// for AOT compilation.
	XlaCpuGenerateUniqueCStyleKernelEntryPoints *bool `protobuf:"varint,372,opt,name=xla_cpu_generate_unique_c_style_kernel_entry_points,json=xlaCpuGenerateUniqueCStyleKernelEntryPoints,proto3,oneof" json:"xla_cpu_generate_unique_c_style_kernel_entry_points,omitempty"`
	// When set, XLA:CPU will only generate code up to the specified ISA.
	// (It will not use newer ISAs.) Using the string format allows us to extend
	// the flag for more flexible control if necessary.
	XlaCpuMaxIsa *string `protobuf:"bytes,333,opt,name=xla_cpu_max_isa,json=xlaCpuMaxIsa,proto3,oneof" json:"xla_cpu_max_isa,omitempty"`
	// The number of parts to split the LLVM module into before codegen. This
	// allows XLA to compile all parts in parallel, and resolve kernel symbols
	// from different dynamic libraries.
	XlaCpuParallelCodegenSplitCount *int32 `protobuf:"varint,323,opt,name=xla_cpu_parallel_codegen_split_count,json=xlaCpuParallelCodegenSplitCount,proto3,oneof" json:"xla_cpu_parallel_codegen_split_count,omitempty"`
	// A `prefer-vector-width` value that is passed to the LLVM backend. Default
	// value is `256` (AVX2 on x86 platforms).
	XlaCpuPreferVectorWidth *int32 `protobuf:"varint,308,opt,name=xla_cpu_prefer_vector_width,json=xlaCpuPreferVectorWidth,proto3,oneof" json:"xla_cpu_prefer_vector_width,omitempty"`
	// If set, XLA:CPU uses "fusion emitters" for codegen.
	XlaCpuUseFusionEmitters *bool `protobuf:"varint,376,opt,name=xla_cpu_use_fusion_emitters,json=xlaCpuUseFusionEmitters,proto3,oneof" json:"xla_cpu_use_fusion_emitters,omitempty"`
	// When true, XLA:CPU uses XNNPACK to execute supported operations.
	XlaCpuUseXnnpack *bool `protobuf:"varint,359,opt,name=xla_cpu_use_xnnpack,json=xlaCpuUseXnnpack,proto3,oneof" json:"xla_cpu_use_xnnpack,omitempty"`
	// Enabling this will enable optimizations that ignore the possibility of NaN.
	XlaEnableFastMath *bool `protobuf:"varint,335,opt,name=xla_enable_fast_math,json=xlaEnableFastMath,proto3,oneof" json:"xla_enable_fast_math,omitempty"`
	// If true, every time an HLO module is run, we will dump an
	// HloUnoptimizedSnapshot (essentially, a serialized unoptimizedmodule plus
	// its inputs) to the --xla_dump_to directory. This flag is currently
	// supported on XLA:GPU and XLA:CPU.
	XlaDumpHloUnoptimizedSnapshots *bool `protobuf:"varint,405,opt,name=xla_dump_hlo_unoptimized_snapshots,json=xlaDumpHloUnoptimizedSnapshots,proto3,oneof" json:"xla_dump_hlo_unoptimized_snapshots,omitempty"`
	// Denylist for cuDNN convolutions.
	XlaGpuAlgorithmDenylistPath *string `protobuf:"bytes,128,opt,name=xla_gpu_algorithm_denylist_path,json=xlaGpuAlgorithmDenylistPath,proto3,oneof" json:"xla_gpu_algorithm_denylist_path,omitempty"`
	// Size threshold (in bytes) for the GPU all-gather combiner.
	XlaGpuAllGatherCombineThresholdBytes *int64 `protobuf:"varint,212,opt,name=xla_gpu_all_gather_combine_threshold_bytes,json=xlaGpuAllGatherCombineThresholdBytes,proto3,oneof" json:"xla_gpu_all_gather_combine_threshold_bytes,omitempty"`
	// Number of devices per host for first stage of BlueConnect decomposition
	// pass. The pass will attempt to decompose all-reduces ops into a
	// ReduceScatter-AllReduce-AllGather sequence, with the initial ReduceScatter
	// being performed over all of the devices in the same host. Set to < 1 to
	// disable all-reduce decomposition.
	XlaGpuAllReduceBlueconnectNumDevicesPerHost *int32 `protobuf:"varint,159,opt,name=xla_gpu_all_reduce_blueconnect_num_devices_per_host,json=xlaGpuAllReduceBlueconnectNumDevicesPerHost,proto3,oneof" json:"xla_gpu_all_reduce_blueconnect_num_devices_per_host,omitempty"`
	// Size threshold (in bytes) for the GPU all-reduce combiner.
	XlaGpuAllReduceCombineThresholdBytes *int64 `protobuf:"varint,157,opt,name=xla_gpu_all_reduce_combine_threshold_bytes,json=xlaGpuAllReduceCombineThresholdBytes,proto3,oneof" json:"xla_gpu_all_reduce_combine_threshold_bytes,omitempty"`
	// Extra platform-specific options to improve analytical latency
	// estimator precision; comma-separated list of 'key=val' strings (=val may be
	// omitted); no whitespace around commas. Available options:
	// --xla_gpu_analytical_latency_estimator_options=
	// 'nccl_op_launch_us=55,nic_speed_gbps=40,chunk_prep_us=1,rtt_us=2,
	// gpus_per_node=4,chunk_size_bytes=1024'
	XlaGpuAnalyticalLatencyEstimatorOptions map[string]string `protobuf:"bytes,357,rep,name=xla_gpu_analytical_latency_estimator_options,json=xlaGpuAnalyticalLatencyEstimatorOptions,proto3" json:"xla_gpu_analytical_latency_estimator_options,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// If true, XLA will wrap `dot` operations into async computations in an
	// effort to parallelize matrix operations.
	XlaGpuAsyncDot *bool `protobuf:"varint,321,opt,name=xla_gpu_async_dot,json=xlaGpuAsyncDot,proto3,oneof" json:"xla_gpu_async_dot,omitempty"`
	// Memory budget in GB per device for AutoSharding.
	XlaGpuAutoSpmdPartitioningMemoryBudgetGb *int32 `protobuf:"varint,224,opt,name=xla_gpu_auto_spmd_partitioning_memory_budget_gb,json=xlaGpuAutoSpmdPartitioningMemoryBudgetGb,proto3,oneof" json:"xla_gpu_auto_spmd_partitioning_memory_budget_gb,omitempty"`
	// See the definition of the
	// xla_gpu_auto_spmd_partitioning_memory_budget_ratio flag for the meaning of
	// this field.
	XlaGpuAutoSpmdPartitioningMemoryBudgetRatio *float32 `protobuf:"fixed32,225,opt,name=xla_gpu_auto_spmd_partitioning_memory_budget_ratio,json=xlaGpuAutoSpmdPartitioningMemoryBudgetRatio,proto3,oneof" json:"xla_gpu_auto_spmd_partitioning_memory_budget_ratio,omitempty"`
	// Relative precision for comparing different GEMM solutions
	XlaGpuAutotuneGemmRtol *float32 `protobuf:"fixed32,316,opt,name=xla_gpu_autotune_gemm_rtol,json=xlaGpuAutotuneGemmRtol,proto3,oneof" json:"xla_gpu_autotune_gemm_rtol,omitempty"`
	// 0:   Disable gemm and convolution autotuning.
	// 1:   Enable autotuning, but disable correctness checking.
	// 2:   Also set output buffers to random numbers during autotuning.
	// 3:   Also reset output buffers to random numbers after autotuning each
	//
	//	algorithm.
	//
	// 4+:  Also check for correct outputs and for out-of-bounds reads/writes.
	//
	// Default: 4.
	XlaGpuAutotuneLevel *int32 `protobuf:"varint,123,opt,name=xla_gpu_autotune_level,json=xlaGpuAutotuneLevel,proto3,oneof" json:"xla_gpu_autotune_level,omitempty"`
	// If non-zero, limits the number of solutions to be used by GEMM autotuner.
	// This might be useful if underlying math library returns too many GEMM
	// solutions.
	XlaGpuAutotuneMaxSolutions *int64 `protobuf:"varint,288,opt,name=xla_gpu_autotune_max_solutions,json=xlaGpuAutotuneMaxSolutions,proto3,oneof" json:"xla_gpu_autotune_max_solutions,omitempty"`
	// If true, each fusion instruction will have a cost model runtime estimate in
	// backend config after compilation.
	XlaGpuCollectCostModelStats *bool `protobuf:"varint,240,opt,name=xla_gpu_collect_cost_model_stats,json=xlaGpuCollectCostModelStats,proto3,oneof" json:"xla_gpu_collect_cost_model_stats,omitempty"`
	// Inflate collective cost by running each collective multiple times.
	XlaGpuCollectiveInflationFactor *int32 `protobuf:"varint,205,opt,name=xla_gpu_collective_inflation_factor,json=xlaGpuCollectiveInflationFactor,proto3,oneof" json:"xla_gpu_collective_inflation_factor,omitempty"`
	// Size threshold (in bytes) for the GPU collective-permute combiner.
	XlaGpuCollectivePermuteCombineThresholdBytes *int64 `protobuf:"varint,378,opt,name=xla_gpu_collective_permute_combine_threshold_bytes,json=xlaGpuCollectivePermuteCombineThresholdBytes,proto3,oneof" json:"xla_gpu_collective_permute_combine_threshold_bytes,omitempty"`
	// The minimum data size in bytes to trigger collective-permute-decomposer
	// transformation.
	XlaGpuCollectivePermuteDecomposerThreshold *int64 `protobuf:"varint,237,opt,name=xla_gpu_collective_permute_decomposer_threshold,json=xlaGpuCollectivePermuteDecomposerThreshold,proto3,oneof" json:"xla_gpu_collective_permute_decomposer_threshold,omitempty"`
	// Do not lock collective cliques for each XLA:GPU execution, and instead
	// use per-process cliques that are never unlocked. This disables deadlock
	// prevention mechanism in XLA:GPU and should be used at you own risk. If
	// collective operations from concurrent executions are not correcctly ordered
	// it may lead to deadlocks, crashes or will produce garbage.
	XlaGpuCollectivesUsePersistentCliques *bool                                     `protobuf:"varint,354,opt,name=xla_gpu_collectives_use_persistent_cliques,json=xlaGpuCollectivesUsePersistentCliques,proto3,oneof" json:"xla_gpu_collectives_use_persistent_cliques,omitempty"`
	XlaGpuCommandBufferSchedulingMode     *DebugOptions_CommandBufferSchedulingMode `protobuf:"varint,404,opt,name=xla_gpu_command_buffer_scheduling_mode,json=xlaGpuCommandBufferSchedulingMode,proto3,enum=xla.DebugOptions_CommandBufferSchedulingMode,oneof" json:"xla_gpu_command_buffer_scheduling_mode,omitempty"`
	// During command buffer lowering, unroll the loop command if loop has known
	// loop count and the loop body does not have unsupported commands.
	XlaGpuCommandBufferUnrollLoops       *bool `protobuf:"varint,411,opt,name=xla_gpu_command_buffer_unroll_loops,json=xlaGpuCommandBufferUnrollLoops,proto3,oneof" json:"xla_gpu_command_buffer_unroll_loops,omitempty"`
	XlaGpuCopyInsertionUseRegionAnalysis *bool `protobuf:"varint,236,opt,name=xla_gpu_copy_insertion_use_region_analysis,json=xlaGpuCopyInsertionUseRegionAnalysis,proto3,oneof" json:"xla_gpu_copy_insertion_use_region_analysis,omitempty"`
	// Crashes the program when any kind of verification fails, instead of just
	// logging the failures. One example is cross checking of convolution results
	// among different algorithms.
	XlaGpuCrashOnVerificationFailures *bool `protobuf:"varint,101,opt,name=xla_gpu_crash_on_verification_failures,json=xlaGpuCrashOnVerificationFailures,proto3,oneof" json:"xla_gpu_crash_on_verification_failures,omitempty"`
	// Allow Triton GEMM autotuning to fall back to cuBLAS when that is
	// faster.
	XlaGpuCublasFallback *bool `protobuf:"varint,247,opt,name=xla_gpu_cublas_fallback,json=xlaGpuCublasFallback,proto3,oneof" json:"xla_gpu_cublas_fallback,omitempty"`
	// Path to directory with cuda/ptx tools and libraries.
	XlaGpuCudaDataDir *string `protobuf:"bytes,61,opt,name=xla_gpu_cuda_data_dir,json=xlaGpuCudaDataDir,proto3,oneof" json:"xla_gpu_cuda_data_dir,omitempty"`
	// Let GEMM fusion autotuning probe cuDNN as a backend.
	// Current levels:
	// 0: Disabled.
	// 1: Enabled on Blackwell+ GPUs.
	// 2: Enabled on all supported GPUs (Ampere+).
	XlaGpuCudnnGemmFusionLevel *int32 `protobuf:"varint,285,opt,name=xla_gpu_cudnn_gemm_fusion_level,json=xlaGpuCudnnGemmFusionLevel,proto3,oneof" json:"xla_gpu_cudnn_gemm_fusion_level,omitempty"`
	// Limit for the number of kernel configurations (plans) to use during
	// autotuning of cuDNN GEMM fusions. The more - the slower the autotuning
	// but potentially higher the performance.
	XlaGpuCudnnGemmMaxPlans *int32 `protobuf:"varint,318,opt,name=xla_gpu_cudnn_gemm_max_plans,json=xlaGpuCudnnGemmMaxPlans,proto3,oneof" json:"xla_gpu_cudnn_gemm_max_plans,omitempty"`
	// Guarantees run-to-run determinism.
	// This flag implies --xla_gpu_exclude_nondeterministic_ops and in addition
	// disables autotuning.
	XlaGpuDeterministicOps        *bool                           `protobuf:"varint,148,opt,name=xla_gpu_deterministic_ops,json=xlaGpuDeterministicOps,proto3,oneof" json:"xla_gpu_deterministic_ops,omitempty"`
	XlaGpuDisableAsyncCollectives []DebugOptions_CollectiveOpType `protobuf:"varint,289,rep,packed,name=xla_gpu_disable_async_collectives,json=xlaGpuDisableAsyncCollectives,proto3,enum=xla.DebugOptions_CollectiveOpType" json:"xla_gpu_disable_async_collectives,omitempty"`
	// If set to true XLA:GPU invokes `ptxas` with -O0 (default is -O3).
	XlaGpuDisableGpuasmOptimizations *bool `protobuf:"varint,103,opt,name=xla_gpu_disable_gpuasm_optimizations,json=xlaGpuDisableGpuasmOptimizations,proto3,oneof" json:"xla_gpu_disable_gpuasm_optimizations,omitempty"`
	// DotMerger pass threshold size to be used in MB.
	XlaGpuDotMergerThresholdMb *int32 `protobuf:"varint,331,opt,name=xla_gpu_dot_merger_threshold_mb,json=xlaGpuDotMergerThresholdMb,proto3,oneof" json:"xla_gpu_dot_merger_threshold_mb,omitempty"`
	// File to write autotune logs to. It will stored in txt format.
	XlaGpuDumpAutotuneLogsTo *string `protobuf:"bytes,292,opt,name=xla_gpu_dump_autotune_logs_to,json=xlaGpuDumpAutotuneLogsTo,proto3,oneof" json:"xla_gpu_dump_autotune_logs_to,omitempty"`
	// File to write autotune results to. It will be a binary file unless the name
	// ends with .txt or .textproto. Warning: The results are written at every
	// compilation, possibly multiple times per process. This only works on CUDA.
	XlaGpuDumpAutotuneResultsTo    *string `protobuf:"bytes,222,opt,name=xla_gpu_dump_autotune_results_to,json=xlaGpuDumpAutotuneResultsTo,proto3,oneof" json:"xla_gpu_dump_autotune_results_to,omitempty"`
	XlaGpuDumpAutotunedGemmFusions *bool   `protobuf:"varint,232,opt,name=xla_gpu_dump_autotuned_gemm_fusions,json=xlaGpuDumpAutotunedGemmFusions,proto3,oneof" json:"xla_gpu_dump_autotuned_gemm_fusions,omitempty"`
	// Whether to dump llvm ir when compiling to ptx.
	XlaGpuDumpLlvmir *bool `protobuf:"varint,155,opt,name=xla_gpu_dump_llvmir,json=xlaGpuDumpLlvmir,proto3,oneof" json:"xla_gpu_dump_llvmir,omitempty"`
	// Combine all-gather ops with the same dimension or irrespective of their
	// dimension.
	XlaGpuEnableAllGatherCombineByDim      *bool `protobuf:"varint,254,opt,name=xla_gpu_enable_all_gather_combine_by_dim,json=xlaGpuEnableAllGatherCombineByDim,proto3,oneof" json:"xla_gpu_enable_all_gather_combine_by_dim,omitempty"`
	XlaGpuEnableAnalyticalLatencyEstimator *bool `protobuf:"varint,255,opt,name=xla_gpu_enable_analytical_latency_estimator,json=xlaGpuEnableAnalyticalLatencyEstimator,proto3,oneof" json:"xla_gpu_enable_analytical_latency_estimator,omitempty"`
	// Enables NCCL Speed-of-Light (SoL) analytical cost model
	XlaGpuEnableAnalyticalSolLatencyEstimator *bool `protobuf:"varint,356,opt,name=xla_gpu_enable_analytical_sol_latency_estimator,json=xlaGpuEnableAnalyticalSolLatencyEstimator,proto3,oneof" json:"xla_gpu_enable_analytical_sol_latency_estimator,omitempty"`
	XlaGpuEnableApproxCostlyCollectives       *bool `protobuf:"varint,305,opt,name=xla_gpu_enable_approx_costly_collectives,json=xlaGpuEnableApproxCostlyCollectives,proto3,oneof" json:"xla_gpu_enable_approx_costly_collectives,omitempty"`
	// Determine the types of commands that are recorded into command buffers.
	XlaGpuEnableCommandBuffer []DebugOptions_CommandBufferCmdType `protobuf:"varint,258,rep,packed,name=xla_gpu_enable_command_buffer,json=xlaGpuEnableCommandBuffer,proto3,enum=xla.DebugOptions_CommandBufferCmdType" json:"xla_gpu_enable_command_buffer,omitempty"`
	// Enable radix sort using CUB.
	XlaGpuEnableCubRadixSort *bool `protobuf:"varint,259,opt,name=xla_gpu_enable_cub_radix_sort,json=xlaGpuEnableCubRadixSort,proto3,oneof" json:"xla_gpu_enable_cub_radix_sort,omitempty"`
	// Whether to use cuBLASLt for GEMMs on GPUs.
	XlaGpuEnableCublaslt                          *bool `protobuf:"varint,166,opt,name=xla_gpu_enable_cublaslt,json=xlaGpuEnableCublaslt,proto3,oneof" json:"xla_gpu_enable_cublaslt,omitempty"`
	XlaGpuEnableCudnnInt8X32ConvolutionReordering *bool `protobuf:"varint,189,opt,name=xla_gpu_enable_cudnn_int8x32_convolution_reordering,json=xlaGpuEnableCudnnInt8x32ConvolutionReordering,proto3,oneof" json:"xla_gpu_enable_cudnn_int8x32_convolution_reordering,omitempty"`
	// Rewrite layer norm patterns into cuDNN library calls.
	XlaGpuEnableCudnnLayerNorm *bool `protobuf:"varint,262,opt,name=xla_gpu_enable_cudnn_layer_norm,json=xlaGpuEnableCudnnLayerNorm,proto3,oneof" json:"xla_gpu_enable_cudnn_layer_norm,omitempty"`
	// Enables address computation fusion to optimize dynamic-slice and
	// dynamic-update-slice operations around library calls.
	XlaGpuEnableDynamicSliceFusion *bool `protobuf:"varint,105,opt,name=xla_gpu_enable_dynamic_slice_fusion,json=xlaGpuEnableDynamicSliceFusion,proto3,oneof" json:"xla_gpu_enable_dynamic_slice_fusion,omitempty"`
	// When true we lower the Minimum and Maximum hlos in the GPU backend such
	// that Min(NotNaN, NaN) = Min(NaN, NotNaN) = NotNaN.  In other words, if flag
	// this is true we don't propagate NaNs through Min and Max.
	XlaGpuEnableFastMinMax                 *bool `protobuf:"varint,100,opt,name=xla_gpu_enable_fast_min_max,json=xlaGpuEnableFastMinMax,proto3,oneof" json:"xla_gpu_enable_fast_min_max,omitempty"`
	XlaGpuEnableHighestPriorityAsyncStream *bool `protobuf:"varint,216,opt,name=xla_gpu_enable_highest_priority_async_stream,json=xlaGpuEnableHighestPriorityAsyncStream,proto3,oneof" json:"xla_gpu_enable_highest_priority_async_stream,omitempty"`
	// If true, will enable host memory offloading on a device.
	XlaGpuEnableHostMemoryOffloading   *bool `protobuf:"varint,296,opt,name=xla_gpu_enable_host_memory_offloading,json=xlaGpuEnableHostMemoryOffloading,proto3,oneof" json:"xla_gpu_enable_host_memory_offloading,omitempty"`
	XlaGpuEnableLatencyHidingScheduler *bool `protobuf:"varint,186,opt,name=xla_gpu_enable_latency_hiding_scheduler,json=xlaGpuEnableLatencyHidingScheduler,proto3,oneof" json:"xla_gpu_enable_latency_hiding_scheduler,omitempty"`
	// If enabled, uses the libnvptxcompiler library to compile PTX to cuBIN.
	XlaGpuEnableLibnvptxcompiler *bool `protobuf:"varint,269,opt,name=xla_gpu_enable_libnvptxcompiler,json=xlaGpuEnableLibnvptxcompiler,proto3,oneof" json:"xla_gpu_enable_libnvptxcompiler,omitempty"`
	// Indicates whether to do LLVM module compilation in a parallelised way. When
	// set, the number of threads depends on
	// `xla_gpu_force_compilation_parallelism`.
	XlaGpuEnableLlvmModuleCompilationParallelism *bool `protobuf:"varint,268,opt,name=xla_gpu_enable_llvm_module_compilation_parallelism,json=xlaGpuEnableLlvmModuleCompilationParallelism,proto3,oneof" json:"xla_gpu_enable_llvm_module_compilation_parallelism,omitempty"`
	// DEPRECATED: This flag is a no-op.
	//
	// Deprecated: Marked as deprecated in xla/xla.proto.
	XlaGpuEnableNcclCliqueOptimization *bool `protobuf:"varint,244,opt,name=xla_gpu_enable_nccl_clique_optimization,json=xlaGpuEnableNcclCliqueOptimization,proto3,oneof" json:"xla_gpu_enable_nccl_clique_optimization,omitempty"`
	// Enable NCCL communicator splitting.
	XlaGpuEnableNcclCommSplitting *bool `protobuf:"varint,272,opt,name=xla_gpu_enable_nccl_comm_splitting,json=xlaGpuEnableNcclCommSplitting,proto3,oneof" json:"xla_gpu_enable_nccl_comm_splitting,omitempty"`
	// Enable NCCL user buffers.
	XlaGpuEnableNcclUserBuffers    *bool `protobuf:"varint,267,opt,name=xla_gpu_enable_nccl_user_buffers,json=xlaGpuEnableNcclUserBuffers,proto3,oneof" json:"xla_gpu_enable_nccl_user_buffers,omitempty"`
	XlaGpuEnablePipelinedAllGather *bool `protobuf:"varint,227,opt,name=xla_gpu_enable_pipelined_all_gather,json=xlaGpuEnablePipelinedAllGather,proto3,oneof" json:"xla_gpu_enable_pipelined_all_gather,omitempty"`
	XlaGpuEnablePipelinedAllReduce *bool `protobuf:"varint,217,opt,name=xla_gpu_enable_pipelined_all_reduce,json=xlaGpuEnablePipelinedAllReduce,proto3,oneof" json:"xla_gpu_enable_pipelined_all_reduce,omitempty"`
	// Deprecated: Marked as deprecated in xla/xla.proto.
	XlaGpuEnablePipelinedCollectives   *bool `protobuf:"varint,239,opt,name=xla_gpu_enable_pipelined_collectives,json=xlaGpuEnablePipelinedCollectives,proto3,oneof" json:"xla_gpu_enable_pipelined_collectives,omitempty"`
	XlaGpuEnablePipelinedP2P           *bool `protobuf:"varint,246,opt,name=xla_gpu_enable_pipelined_p2p,json=xlaGpuEnablePipelinedP2p,proto3,oneof" json:"xla_gpu_enable_pipelined_p2p,omitempty"`
	XlaGpuEnablePipelinedReduceScatter *bool `protobuf:"varint,231,opt,name=xla_gpu_enable_pipelined_reduce_scatter,json=xlaGpuEnablePipelinedReduceScatter,proto3,oneof" json:"xla_gpu_enable_pipelined_reduce_scatter,omitempty"`
	// Enable allreduce reassociation on allreduces that are converted to a wider
	// type. The resulting allreduce will be promoted to a wider-typed allreduce.
	XlaGpuEnableReassociationForConvertedAr *bool `protobuf:"varint,209,opt,name=xla_gpu_enable_reassociation_for_converted_ar,json=xlaGpuEnableReassociationForConvertedAr,proto3,oneof" json:"xla_gpu_enable_reassociation_for_converted_ar,omitempty"`
	// Combine reduce-scatter ops with the same dimension or irrespective of their
	// dimension.
	XlaGpuEnableReduceScatterCombineByDim *bool `protobuf:"varint,257,opt,name=xla_gpu_enable_reduce_scatter_combine_by_dim,json=xlaGpuEnableReduceScatterCombineByDim,proto3,oneof" json:"xla_gpu_enable_reduce_scatter_combine_by_dim,omitempty"`
	// Whether reduction epilogue fusion is enabled in fusion passes.
	XlaGpuEnableReductionEpilogueFusion *bool `protobuf:"varint,243,opt,name=xla_gpu_enable_reduction_epilogue_fusion,json=xlaGpuEnableReductionEpilogueFusion,proto3,oneof" json:"xla_gpu_enable_reduction_epilogue_fusion,omitempty"`
	// Enable the scatter determinism expander, an optimized pass that
	// rewrites scatter operations to ensure deterministic behavior with high
	// performance.
	// Note that even when this flag is disabled, scatter operations may still
	// be deterministic, although with additional overhead.
	XlaGpuEnableScatterDeterminismExpander *bool `protobuf:"varint,345,opt,name=xla_gpu_enable_scatter_determinism_expander,json=xlaGpuEnableScatterDeterminismExpander,proto3,oneof" json:"xla_gpu_enable_scatter_determinism_expander,omitempty"`
	// Enables shared constants for XLA/GPU. This allows large constants to be
	// shared among multiple GPU executables.
	XlaGpuEnableSharedConstants  *bool `protobuf:"varint,165,opt,name=xla_gpu_enable_shared_constants,json=xlaGpuEnableSharedConstants,proto3,oneof" json:"xla_gpu_enable_shared_constants,omitempty"`
	XlaGpuEnableSplitKAutotuning *bool `protobuf:"varint,241,opt,name=xla_gpu_enable_split_k_autotuning,json=xlaGpuEnableSplitKAutotuning,proto3,oneof" json:"xla_gpu_enable_split_k_autotuning,omitempty"`
	XlaGpuEnableTritonGemm       *bool `protobuf:"varint,188,opt,name=xla_gpu_enable_triton_gemm,json=xlaGpuEnableTritonGemm,proto3,oneof" json:"xla_gpu_enable_triton_gemm,omitempty"`
	// Enable double buffering for loops.
	XlaGpuEnableWhileLoopDoubleBuffering *bool `protobuf:"varint,248,opt,name=xla_gpu_enable_while_loop_double_buffering,json=xlaGpuEnableWhileLoopDoubleBuffering,proto3,oneof" json:"xla_gpu_enable_while_loop_double_buffering,omitempty"`
	// Enable hoisting of reduce-scatter out of while loops.
	XlaGpuEnableWhileLoopReduceScatterCodeMotion *bool `protobuf:"varint,203,opt,name=xla_gpu_enable_while_loop_reduce_scatter_code_motion,json=xlaGpuEnableWhileLoopReduceScatterCodeMotion,proto3,oneof" json:"xla_gpu_enable_while_loop_reduce_scatter_code_motion,omitempty"`
	// Determine the while loop unrolling scheme.
	XlaGpuEnableWhileLoopUnrolling *DebugOptions_WhileLoopUnrolling `protobuf:"varint,294,opt,name=xla_gpu_enable_while_loop_unrolling,json=xlaGpuEnableWhileLoopUnrolling,proto3,enum=xla.DebugOptions_WhileLoopUnrolling,oneof" json:"xla_gpu_enable_while_loop_unrolling,omitempty"`
	// Excludes non-deterministic ops from compiled executables.
	// Unlike --xla_gpu_deterministic_ops does not disable autotuning - the
	// compilation itself can be non-deterministic.
	// Scatter ops can non-deterministic by default; these get converted to
	// a deterministic implementation.
	XlaGpuExcludeNondeterministicOps *bool `protobuf:"varint,297,opt,name=xla_gpu_exclude_nondeterministic_ops,json=xlaGpuExcludeNondeterministicOps,proto3,oneof" json:"xla_gpu_exclude_nondeterministic_ops,omitempty"`
	// Timeout to terminate on stuck rendez-vous.
	XlaGpuExecutableTerminateTimeoutSeconds *int32 `protobuf:"varint,328,opt,name=xla_gpu_executable_terminate_timeout_seconds,json=xlaGpuExecutableTerminateTimeoutSeconds,proto3,oneof" json:"xla_gpu_executable_terminate_timeout_seconds,omitempty"`
	// Timeout to issue a warning on stuck rendez-vous.
	XlaGpuExecutableWarnStuckTimeoutSeconds *int32 `protobuf:"varint,327,opt,name=xla_gpu_executable_warn_stuck_timeout_seconds,json=xlaGpuExecutableWarnStuckTimeoutSeconds,proto3,oneof" json:"xla_gpu_executable_warn_stuck_timeout_seconds,omitempty"`
	XlaGpuExhaustiveTilingSearch            *bool  `protobuf:"varint,219,opt,name=xla_gpu_exhaustive_tiling_search,json=xlaGpuExhaustiveTilingSearch,proto3,oneof" json:"xla_gpu_exhaustive_tiling_search,omitempty"`
	// Specifies the behavior of per kernel autotuning cache.
	XlaGpuExperimentalAutotuneCacheMode *DebugOptions_AutotuneCacheMode `protobuf:"varint,324,opt,name=xla_gpu_experimental_autotune_cache_mode,json=xlaGpuExperimentalAutotuneCacheMode,proto3,enum=xla.DebugOptions_AutotuneCacheMode,oneof" json:"xla_gpu_experimental_autotune_cache_mode,omitempty"`
	// Specifies the directory to store per kernel autotuning cache.
	XlaGpuExperimentalAutotunerCacheDir *string `protobuf:"bytes,407,opt,name=xla_gpu_experimental_autotuner_cache_dir,json=xlaGpuExperimentalAutotunerCacheDir,proto3,oneof" json:"xla_gpu_experimental_autotuner_cache_dir,omitempty"`
	// Specifies the distance threshold in ScheduleAwareCollectiveOpsCSE
	XlaGpuExperimentalCollectiveCseDistanceThreshold *int64 `protobuf:"varint,374,opt,name=xla_gpu_experimental_collective_cse_distance_threshold,json=xlaGpuExperimentalCollectiveCseDistanceThreshold,proto3,oneof" json:"xla_gpu_experimental_collective_cse_distance_threshold,omitempty"`
	// Path to experimental collective perf tables.
	XlaGpuExperimentalCollectivePerfTablePath *string `protobuf:"bytes,377,opt,name=xla_gpu_experimental_collective_perf_table_path,json=xlaGpuExperimentalCollectivePerfTablePath,proto3,oneof" json:"xla_gpu_experimental_collective_perf_table_path,omitempty"`
	// Experimentally disables binary libraries in GPU compiler passes.
	XlaGpuExperimentalDisableBinaryLibraries *bool `protobuf:"varint,329,opt,name=xla_gpu_experimental_disable_binary_libraries,json=xlaGpuExperimentalDisableBinaryLibraries,proto3,oneof" json:"xla_gpu_experimental_disable_binary_libraries,omitempty"`
	// Dump FDO profiles in a binary format to a separate file.
	XlaGpuExperimentalDumpFdoProfiles *bool `protobuf:"varint,338,opt,name=xla_gpu_experimental_dump_fdo_profiles,json=xlaGpuExperimentalDumpFdoProfiles,proto3,oneof" json:"xla_gpu_experimental_dump_fdo_profiles,omitempty"`
	// Enable windowed einsum(collective matmul) rewrite for all-to-all + gemm
	// This feature is still experimental and effective only
	// xla_gpu_multi_streamed_windowed_einsum is set to true.
	XlaGpuExperimentalEnableAlltoallWindowedEinsum *bool `protobuf:"varint,360,opt,name=xla_gpu_experimental_enable_alltoall_windowed_einsum,json=xlaGpuExperimentalEnableAlltoallWindowedEinsum,proto3,oneof" json:"xla_gpu_experimental_enable_alltoall_windowed_einsum,omitempty"`
	// Enables an experimental feature for command buffer conversion on thunks.
	XlaGpuExperimentalEnableCommandBufferOnThunks *bool `protobuf:"varint,394,opt,name=xla_gpu_experimental_enable_command_buffer_on_thunks,json=xlaGpuExperimentalEnableCommandBufferOnThunks,proto3,oneof" json:"xla_gpu_experimental_enable_command_buffer_on_thunks,omitempty"`
	// If true, enable autotuning between the native & triton fusion emitters.
	XlaGpuExperimentalEnableFusionAutotuner *bool `protobuf:"varint,409,opt,name=xla_gpu_experimental_enable_fusion_autotuner,json=xlaGpuExperimentalEnableFusionAutotuner,proto3,oneof" json:"xla_gpu_experimental_enable_fusion_autotuner,omitempty"`
	// Enabling this flag will attempt to redirect every already-constructed
	// fusion possible to the Triton emitter.
	//
	// For example, a fusion with kind kLoop will be transformed to a fusion with
	// kind kCustom (and underlying kTritonFusionKind) if it can be tiled
	// correctly, and if all the instructions it contains are supported by XLA's
	// Triton emitter. Tile sizes are assigned automatically.
	//
	// Pre-existing block-level fusions are left unmodified.
	XlaGpuExperimentalEnableFusionBlockLevelRewriter *bool `protobuf:"varint,334,opt,name=xla_gpu_experimental_enable_fusion_block_level_rewriter,json=xlaGpuExperimentalEnableFusionBlockLevelRewriter,proto3,oneof" json:"xla_gpu_experimental_enable_fusion_block_level_rewriter,omitempty"`
	// If true, enable heuristic based collective combining.
	XlaGpuExperimentalEnableHeuristicCollectiveCombining *bool `protobuf:"varint,366,opt,name=xla_gpu_experimental_enable_heuristic_collective_combining,json=xlaGpuExperimentalEnableHeuristicCollectiveCombining,proto3,oneof" json:"xla_gpu_experimental_enable_heuristic_collective_combining,omitempty"`
	// Enable NCCL symmetric buffers.
	XlaGpuExperimentalEnableNcclSymmetricBuffers *bool `protobuf:"varint,406,opt,name=xla_gpu_experimental_enable_nccl_symmetric_buffers,json=xlaGpuExperimentalEnableNcclSymmetricBuffers,proto3,oneof" json:"xla_gpu_experimental_enable_nccl_symmetric_buffers,omitempty"`
	// Enable NVSHMEM. Must be set via XLA_FLAGS variable before XLA client is
	// initialized and can't be set just through HLO Config->ExecutionOptions.
	XlaGpuExperimentalEnableNvshmem *bool `protobuf:"varint,388,opt,name=xla_gpu_experimental_enable_nvshmem,json=xlaGpuExperimentalEnableNvshmem,proto3,oneof" json:"xla_gpu_experimental_enable_nvshmem,omitempty"`
	// Enable the pass that splits GEMMs that underutilize the GPU load by
	// splitting the K dimension using a heuristic.
	XlaGpuExperimentalEnableSplitKRewrite *bool `protobuf:"varint,386,opt,name=xla_gpu_experimental_enable_split_k_rewrite,json=xlaGpuExperimentalEnableSplitKRewrite,proto3,oneof" json:"xla_gpu_experimental_enable_split_k_rewrite,omitempty"`
	// Enable fusion for the subchannel dequantisation sequences like
	// [x,z]param -> [x,y,z]broadcast -> [x*y,z]bitcast -> multiply -> dot.
	// Performance can be worse, because some block sizes / split-k > 1 is
	// not considered for subchannel dequant fusions.
	XlaGpuExperimentalEnableSubchannelDequantisationFusion *bool `protobuf:"varint,368,opt,name=xla_gpu_experimental_enable_subchannel_dequantisation_fusion,json=xlaGpuExperimentalEnableSubchannelDequantisationFusion,proto3,oneof" json:"xla_gpu_experimental_enable_subchannel_dequantisation_fusion,omitempty"`
	// When enabled, the PriorityFusion pass will try to make Triton fusions first
	// and foremost where it is possible.
	//
	// A kCustom fusion with underlying kTritonFusionKind will be created if it
	// can be tiled correctly, and if all the instructions it contains are
	// supported by XLA's Triton emitter. Tile sizes are assigned automatically.
	XlaGpuExperimentalEnableTritonHerolessPriorityFusion *bool `protobuf:"varint,340,opt,name=xla_gpu_experimental_enable_triton_heroless_priority_fusion,json=xlaGpuExperimentalEnableTritonHerolessPriorityFusion,proto3,oneof" json:"xla_gpu_experimental_enable_triton_heroless_priority_fusion,omitempty"`
	// When possible, XLA will use Triton's experimental TMA feature.
	XlaGpuExperimentalEnableTritonTma *bool `protobuf:"varint,355,opt,name=xla_gpu_experimental_enable_triton_tma,json=xlaGpuExperimentalEnableTritonTma,proto3,oneof" json:"xla_gpu_experimental_enable_triton_tma,omitempty"`
	// For sub-byte dot operands, layout them along contracting dimensions.
	XlaGpuExperimentalPackDotOperandsAlongKDimension *bool `protobuf:"varint,362,opt,name=xla_gpu_experimental_pack_dot_operands_along_k_dimension,json=xlaGpuExperimentalPackDotOperandsAlongKDimension,proto3,oneof" json:"xla_gpu_experimental_pack_dot_operands_along_k_dimension,omitempty"`
	// This controls how many in-flight collectives latency hiding scheduler
	// can schedule. Example usage:
	// With xla_gpu_experimental_parallel_collective_overlap_limit = 1:
	//
	//	coll.1-start = collective(input)
	//	coll.1-done = collective(coll.1-start)
	//	coll.2-start = collective(input2)
	//	coll.2-done = collective(coll.2-start)
	//
	// With xla_gpu_experimental_parallel_collective_overlap_limit = 2:
	//
	//	coll.1-start = collective(input)
	//	coll.2-start = collective(input2)
	//	coll.1-done = collective(coll.1-start)
	//	coll.2-done = collective(coll.2-start)
	XlaGpuExperimentalParallelCollectiveOverlapLimit *int32                                    `protobuf:"varint,336,opt,name=xla_gpu_experimental_parallel_collective_overlap_limit,json=xlaGpuExperimentalParallelCollectiveOverlapLimit,proto3,oneof" json:"xla_gpu_experimental_parallel_collective_overlap_limit,omitempty"`
	XlaGpuExperimentalPipelineParallelismOptLevel    *DebugOptions_PipelineParallelismOptLevel `protobuf:"varint,351,opt,name=xla_gpu_experimental_pipeline_parallelism_opt_level,json=xlaGpuExperimentalPipelineParallelismOptLevel,proto3,enum=xla.DebugOptions_PipelineParallelismOptLevel,oneof" json:"xla_gpu_experimental_pipeline_parallelism_opt_level,omitempty"`
	XlaGpuExperimentalStreamAnnotation               *bool                                     `protobuf:"varint,342,opt,name=xla_gpu_experimental_stream_annotation,json=xlaGpuExperimentalStreamAnnotation,proto3,oneof" json:"xla_gpu_experimental_stream_annotation,omitempty"`
	// If true, use the AutotunerPass to autotune fusions, instead of the
	// gemm_fusion_autotuner.
	XlaGpuExperimentalUseAutotunerPass *bool `protobuf:"varint,396,opt,name=xla_gpu_experimental_use_autotuner_pass,json=xlaGpuExperimentalUseAutotunerPass,proto3,oneof" json:"xla_gpu_experimental_use_autotuner_pass,omitempty"`
	// If true, use the ragged dot fusion emitter rather than expanding to a
	// regular dot.
	XlaGpuExperimentalUseRaggedDotFusion *bool `protobuf:"varint,401,opt,name=xla_gpu_experimental_use_ragged_dot_fusion,json=xlaGpuExperimentalUseRaggedDotFusion,proto3,oneof" json:"xla_gpu_experimental_use_ragged_dot_fusion,omitempty"`
	// If true, PTX compilation will fail if a kernel spills registers.
	// This is meant for debugging and only applies to CUDA PTX compilation.
	XlaGpuFailPtxCompilationOnRegisterSpilling *bool `protobuf:"varint,353,opt,name=xla_gpu_fail_ptx_compilation_on_register_spilling,json=xlaGpuFailPtxCompilationOnRegisterSpilling,proto3,oneof" json:"xla_gpu_fail_ptx_compilation_on_register_spilling,omitempty"`
	// Filter out kernels that spill registers during autotuning.
	XlaGpuFilterKernelsSpillingRegistersOnAutotuning *bool `protobuf:"varint,250,opt,name=xla_gpu_filter_kernels_spilling_registers_on_autotuning,json=xlaGpuFilterKernelsSpillingRegistersOnAutotuning,proto3,oneof" json:"xla_gpu_filter_kernels_spilling_registers_on_autotuning,omitempty"`
	// The number of seconds to wait before terminating a rendezvous of the first
	// call.
	XlaGpuFirstCollectiveCallTerminateTimeoutSeconds *int32 `protobuf:"varint,392,opt,name=xla_gpu_first_collective_call_terminate_timeout_seconds,json=xlaGpuFirstCollectiveCallTerminateTimeoutSeconds,proto3,oneof" json:"xla_gpu_first_collective_call_terminate_timeout_seconds,omitempty"`
	// The number of seconds to wait before warning about a first call rendezvous
	// that has not yet timed out.
	XlaGpuFirstCollectiveCallWarnStuckTimeoutSeconds *int32 `protobuf:"varint,391,opt,name=xla_gpu_first_collective_call_warn_stuck_timeout_seconds,json=xlaGpuFirstCollectiveCallWarnStuckTimeoutSeconds,proto3,oneof" json:"xla_gpu_first_collective_call_warn_stuck_timeout_seconds,omitempty"`
	// Overrides normal multi-threaded compilation setting to use this many
	// threads. Setting to 0 (the default value) means no enforcement.
	XlaGpuForceCompilationParallelism *int32 `protobuf:"varint,147,opt,name=xla_gpu_force_compilation_parallelism,json=xlaGpuForceCompilationParallelism,proto3,oneof" json:"xla_gpu_force_compilation_parallelism,omitempty"`
	// Overrides for XLA GPU's convolution layout heuristic.
	XlaGpuForceConvNchw *bool `protobuf:"varint,125,opt,name=xla_gpu_force_conv_nchw,json=xlaGpuForceConvNchw,proto3,oneof" json:"xla_gpu_force_conv_nchw,omitempty"`
	XlaGpuForceConvNhwc *bool `protobuf:"varint,146,opt,name=xla_gpu_force_conv_nhwc,json=xlaGpuForceConvNhwc,proto3,oneof" json:"xla_gpu_force_conv_nhwc,omitempty"`
	// Enable flush-to-zero semantics in the GPU backend.
	XlaGpuFtz                       *bool `protobuf:"varint,62,opt,name=xla_gpu_ftz,json=xlaGpuFtz,proto3,oneof" json:"xla_gpu_ftz,omitempty"`
	XlaGpuFusedAttentionUseCudnnRng *bool `protobuf:"varint,235,opt,name=xla_gpu_fused_attention_use_cudnn_rng,json=xlaGpuFusedAttentionUseCudnnRng,proto3,oneof" json:"xla_gpu_fused_attention_use_cudnn_rng,omitempty"`
	// Threshold to rewrite matmul to cuBLAS or Triton (minimum combined number of
	// elements of both matrices in non-batch dimensions to be considered for a
	// rewrite).
	XlaGpuGemmRewriteSizeThreshold *int64 `protobuf:"varint,283,opt,name=xla_gpu_gemm_rewrite_size_threshold,json=xlaGpuGemmRewriteSizeThreshold,proto3,oneof" json:"xla_gpu_gemm_rewrite_size_threshold,omitempty"`
	// If true, we generate debug info when compiling PTX. This is useful for
	// profiling and debugging.
	XlaGpuGenerateDebugInfo *bool `protobuf:"varint,348,opt,name=xla_gpu_generate_debug_info,json=xlaGpuGenerateDebugInfo,proto3,oneof" json:"xla_gpu_generate_debug_info,omitempty"`
	// If true, we generate line info when compiling PTX. This is useful for
	// profiling and debugging.
	XlaGpuGenerateLineInfo *bool `protobuf:"varint,349,opt,name=xla_gpu_generate_line_info,json=xlaGpuGenerateLineInfo,proto3,oneof" json:"xla_gpu_generate_line_info,omitempty"`
	// DEPRECATED: Use `xla_gpu_command_buffer_scheduling_mode` instead.
	// Identify concurrent regions in GPU graphs and execute them concurrently.
	//
	// Deprecated: Marked as deprecated in xla/xla.proto.
	XlaGpuGraphEnableConcurrentRegion *bool `protobuf:"varint,215,opt,name=xla_gpu_graph_enable_concurrent_region,json=xlaGpuGraphEnableConcurrentRegion,proto3,oneof" json:"xla_gpu_graph_enable_concurrent_region,omitempty"`
	// This number determines how many moved instructions like fusion kernels are
	// required for a region to be captured as a function to be launched as a GPU
	// graph.
	XlaGpuGraphMinGraphSize *int32  `protobuf:"varint,208,opt,name=xla_gpu_graph_min_graph_size,json=xlaGpuGraphMinGraphSize,proto3,oneof" json:"xla_gpu_graph_min_graph_size,omitempty"`
	XlaGpuKernelCacheFile   *string `protobuf:"bytes,306,opt,name=xla_gpu_kernel_cache_file,json=xlaGpuKernelCacheFile,proto3,oneof" json:"xla_gpu_kernel_cache_file,omitempty"`
	// If enabled, uses the libnvjitlink library for PTX compilation and linking
	XlaGpuLibnvjitlinkMode *DebugOptions_LibNvJitLinkMode `protobuf:"varint,343,opt,name=xla_gpu_libnvjitlink_mode,json=xlaGpuLibnvjitlinkMode,proto3,enum=xla.DebugOptions_LibNvJitLinkMode,oneof" json:"xla_gpu_libnvjitlink_mode,omitempty"`
	// Paths to files with LLVM code.
	XlaGpuLlvmIrFile            []string `protobuf:"bytes,150,rep,name=xla_gpu_llvm_ir_file,json=xlaGpuLlvmIrFile,proto3" json:"xla_gpu_llvm_ir_file,omitempty"`
	XlaGpuLlvmVerificationLevel *int32   `protobuf:"varint,256,opt,name=xla_gpu_llvm_verification_level,json=xlaGpuLlvmVerificationLevel,proto3,oneof" json:"xla_gpu_llvm_verification_level,omitempty"`
	// File to load autotune results from. It will be considered a binary file
	// unless the name ends with .txt or .textproto. At most one loading will
	// happen during the lifetime of one process, even if the first one is
	// unsuccessful or different file paths are passed here. This only works on
	// CUDA.
	XlaGpuLoadAutotuneResultsFrom *string `protobuf:"bytes,223,opt,name=xla_gpu_load_autotune_results_from,json=xlaGpuLoadAutotuneResultsFrom,proto3,oneof" json:"xla_gpu_load_autotune_results_from,omitempty"`
	XlaGpuMemoryLimitSlopFactor   *int32  `protobuf:"varint,260,opt,name=xla_gpu_memory_limit_slop_factor,json=xlaGpuMemoryLimitSlopFactor,proto3,oneof" json:"xla_gpu_memory_limit_slop_factor,omitempty"`
	// Replace custom calls with noop operations.
	XlaGpuMockCustomCalls *bool `protobuf:"varint,245,opt,name=xla_gpu_mock_custom_calls,json=xlaGpuMockCustomCalls,proto3,oneof" json:"xla_gpu_mock_custom_calls,omitempty"`
	// Whether to use multiple compute streams to run windowed einsum.
	XlaGpuMultiStreamedWindowedEinsum *bool `protobuf:"varint,280,opt,name=xla_gpu_multi_streamed_windowed_einsum,json=xlaGpuMultiStreamedWindowedEinsum,proto3,oneof" json:"xla_gpu_multi_streamed_windowed_einsum,omitempty"`
	// If true, NCCL collectives (e.g., AllReduce) execute asynchronously. If
	// xla_gpu_nccl_blocking_communicators is false, then
	// xla_gpu_nccl_async_execution must be true.
	XlaGpuNcclAsyncExecution *bool `protobuf:"varint,393,opt,name=xla_gpu_nccl_async_execution,json=xlaGpuNcclAsyncExecution,proto3,oneof" json:"xla_gpu_nccl_async_execution,omitempty"`
	// There are two types of NCCL communicators: blocking and non-blocking.  When
	// a collective operation is called on a blocking communicator, the
	// communicator blocks until the operation has been scheduled on the GPU. A
	// non-blocking communicator, on the other hand, returns immediately.
	//
	// https://docs.nvidia.com/deeplearning/nccl/user-guide/docs/api/types.html#c.blocking
	XlaGpuNcclBlockingCommunicators *bool `protobuf:"varint,390,opt,name=xla_gpu_nccl_blocking_communicators,json=xlaGpuNcclBlockingCommunicators,proto3,oneof" json:"xla_gpu_nccl_blocking_communicators,omitempty"`
	// Specify the maximum number of channels(SMs) NCCL
	// will use for collective operations.
	XlaGpuNcclCollectiveMaxNchannels *int64 `protobuf:"varint,273,opt,name=xla_gpu_nccl_collective_max_nchannels,json=xlaGpuNcclCollectiveMaxNchannels,proto3,oneof" json:"xla_gpu_nccl_collective_max_nchannels,omitempty"`
	// Set number of ranks per root rank for NCCL init.
	XlaGpuNcclInitMaxRankPerRootRatio *int64 `protobuf:"varint,277,opt,name=xla_gpu_nccl_init_max_rank_per_root_ratio,json=xlaGpuNcclInitMaxRankPerRootRatio,proto3,oneof" json:"xla_gpu_nccl_init_max_rank_per_root_ratio,omitempty"`
	// Specify the maximum number of channels(SMs) NCCL
	// will use for p2p operations.
	XlaGpuNcclP2PMaxNchannels *int64 `protobuf:"varint,274,opt,name=xla_gpu_nccl_p2p_max_nchannels,json=xlaGpuNcclP2pMaxNchannels,proto3,oneof" json:"xla_gpu_nccl_p2p_max_nchannels,omitempty"`
	// If true, Nccl errors will terminate the process.
	XlaGpuNcclTerminateOnError *bool `protobuf:"varint,301,opt,name=xla_gpu_nccl_terminate_on_error,json=xlaGpuNcclTerminateOnError,proto3,oneof" json:"xla_gpu_nccl_terminate_on_error,omitempty"`
	// Timeout in seconds before terminating jobs that are stuck in a NCCL
	// Rendezvous. Negative value disables the timeout and will not terminate.
	XlaGpuNcclTerminationTimeoutSeconds *int64 `protobuf:"varint,163,opt,name=xla_gpu_nccl_termination_timeout_seconds,json=xlaGpuNcclTerminationTimeoutSeconds,proto3,oneof" json:"xla_gpu_nccl_termination_timeout_seconds,omitempty"`
	// If set >= 0, this controls the total bytes(combined sizes of both
	// operands in bytes) to enable windowed einsum and
	// xla_gpu_threshold_for_windowed_einsum_mib will be ignored.
	XlaGpuOperandBytesThresholdForWindowedEinsum *int64                            `protobuf:"varint,339,opt,name=xla_gpu_operand_bytes_threshold_for_windowed_einsum,json=xlaGpuOperandBytesThresholdForWindowedEinsum,proto3,oneof" json:"xla_gpu_operand_bytes_threshold_for_windowed_einsum,omitempty"`
	XlaGpuOverrideGemmAutotuner                  *string                           `protobuf:"bytes,295,opt,name=xla_gpu_override_gemm_autotuner,json=xlaGpuOverrideGemmAutotuner,proto3,oneof" json:"xla_gpu_override_gemm_autotuner,omitempty"`
	XlaGpuPerFusionAutotuneCacheDir              *string                           `protobuf:"bytes,310,opt,name=xla_gpu_per_fusion_autotune_cache_dir,json=xlaGpuPerFusionAutotuneCacheDir,proto3,oneof" json:"xla_gpu_per_fusion_autotune_cache_dir,omitempty"`
	XlaGpuPgleAccuracyChecker                    *DebugOptions_PGLEStrictnessLevel `protobuf:"varint,341,opt,name=xla_gpu_pgle_accuracy_checker,json=xlaGpuPgleAccuracyChecker,proto3,enum=xla.DebugOptions_PGLEStrictnessLevel,oneof" json:"xla_gpu_pgle_accuracy_checker,omitempty"`
	XlaGpuPgleProfileFileOrDirectoryPath         *string                           `protobuf:"bytes,210,opt,name=xla_gpu_pgle_profile_file_or_directory_path,json=xlaGpuPgleProfileFileOrDirectoryPath,proto3,oneof" json:"xla_gpu_pgle_profile_file_or_directory_path,omitempty"`
	// Paths to files with ptx code.
	XlaGpuPtxFile []string `protobuf:"bytes,127,rep,name=xla_gpu_ptx_file,json=xlaGpuPtxFile,proto3" json:"xla_gpu_ptx_file,omitempty"`
	// Size threshold (in bytes) for the GPU reduce-scatter combiner.
	XlaGpuReduceScatterCombineThresholdBytes *int64 `protobuf:"varint,213,opt,name=xla_gpu_reduce_scatter_combine_threshold_bytes,json=xlaGpuReduceScatterCombineThresholdBytes,proto3,oneof" json:"xla_gpu_reduce_scatter_combine_threshold_bytes,omitempty"`
	// Amount of padding the redzone allocator will put on one side of each buffer
	// it allocates.  (So the buffer's total size will be increased by 2x this
	// value.)
	//
	// Higher values make it more likely that we'll catch an out-of-bounds read or
	// write.  Smaller values consume less memory during autotuning.  Note that a
	// fused cudnn conv has up to 6 total buffers (4 inputs, 1 output, and 1
	// scratch), so this can be multiplied by quite a lot.
	XlaGpuRedzonePaddingBytes *int64 `protobuf:"varint,228,opt,name=xla_gpu_redzone_padding_bytes,json=xlaGpuRedzonePaddingBytes,proto3,oneof" json:"xla_gpu_redzone_padding_bytes,omitempty"`
	// If true, will require complete AOT autotuning results; in the case of
	// missing AOT result, the model will not be compiled or executed, a
	// `NotFound` error will be returned.
	XlaGpuRequireCompleteAotAutotuneResults *bool `protobuf:"varint,284,opt,name=xla_gpu_require_complete_aot_autotune_results,json=xlaGpuRequireCompleteAotAutotuneResults,proto3,oneof" json:"xla_gpu_require_complete_aot_autotune_results,omitempty"`
	// If true, XLA runtime will retain exclusive ownership of the GPU when
	// running a module, so there are no multi-thread conflicts on the GPU. This
	// can enable some optimizations that reduce the cost of resource management,
	// e.g., command buffer updates to ensure correctness when running in
	// multi-thread mode.
	XlaGpuRequireExclusiveLock *bool                     `protobuf:"varint,347,opt,name=xla_gpu_require_exclusive_lock,json=xlaGpuRequireExclusiveLock,proto3,oneof" json:"xla_gpu_require_exclusive_lock,omitempty"`
	XlaGpuShapeChecks          *DebugOptions_ShapeChecks `protobuf:"varint,170,opt,name=xla_gpu_shape_checks,json=xlaGpuShapeChecks,proto3,enum=xla.DebugOptions_ShapeChecks,oneof" json:"xla_gpu_shape_checks,omitempty"`
	// If true, shards the autotuning work between participating compiler
	// processes (typically in multi-host setups) and joins the results when
	// it's done.
	XlaGpuShardAutotuning *bool `protobuf:"varint,304,opt,name=xla_gpu_shard_autotuning,json=xlaGpuShardAutotuning,proto3,oneof" json:"xla_gpu_shard_autotuning,omitempty"`
	// If true, abort immediately when conv algorithm picker fails, rather than
	// logging a warning and proceeding with fallback.
	XlaGpuStrictConvAlgorithmPicker *bool `protobuf:"varint,156,opt,name=xla_gpu_strict_conv_algorithm_picker,json=xlaGpuStrictConvAlgorithmPicker,proto3,oneof" json:"xla_gpu_strict_conv_algorithm_picker,omitempty"`
	// Description of the target platform in GpuTargetConfigProto format; if
	// provided, deviceless compilation is assumed, and the current device is
	// ignored.
	XlaGpuTargetConfigFilename *string `protobuf:"bytes,261,opt,name=xla_gpu_target_config_filename,json=xlaGpuTargetConfigFilename,proto3,oneof" json:"xla_gpu_target_config_filename,omitempty"`
	// Enable this flag will use a separate memory space color for
	// temp buffer, and then will use separate memory allocator to allocate it,
	// as there is no other memory allocation interference,
	// it will allocate temp buffer to some fix address on every iteration,
	// which is good for cuda-graph perf.
	XlaGpuTempBufferUseSeparateColor *bool `protobuf:"varint,312,opt,name=xla_gpu_temp_buffer_use_separate_color,json=xlaGpuTempBufferUseSeparateColor,proto3,oneof" json:"xla_gpu_temp_buffer_use_separate_color,omitempty"`
	// Threshold to enable windowed einsum (collective matmul) in MB.
	XlaGpuThresholdForWindowedEinsumMib *int64 `protobuf:"varint,265,opt,name=xla_gpu_threshold_for_windowed_einsum_mib,json=xlaGpuThresholdForWindowedEinsumMib,proto3,oneof" json:"xla_gpu_threshold_for_windowed_einsum_mib,omitempty"`
	// Creates triton fusion for all supported gemms.
	// To make sure only triton gemm is chosen by the autotuner run with
	// `xla_gpu_cublas_fallback` set to false.
	XlaGpuTritonGemmAny *bool `protobuf:"varint,190,opt,name=xla_gpu_triton_gemm_any,json=xlaGpuTritonGemmAny,proto3,oneof" json:"xla_gpu_triton_gemm_any,omitempty"`
	// It is usually preferable to not fallback to the driver; it can consume more
	// memory, or have bugs.
	XlaGpuUnsafeFallbackToDriverOnPtxasNotFound *bool `protobuf:"varint,138,opt,name=xla_gpu_unsafe_fallback_to_driver_on_ptxas_not_found,json=xlaGpuUnsafeFallbackToDriverOnPtxasNotFound,proto3,oneof" json:"xla_gpu_unsafe_fallback_to_driver_on_ptxas_not_found,omitempty"`
	// If true, XLA will annotate instructions in the dumps with emitter code
	// location (source:line) annotations. This helps to identify the source of
	// the code that emits a particular instruction.
	XlaGpuUnsupportedAnnotateWithEmitterLoc *bool `protobuf:"varint,358,opt,name=xla_gpu_unsupported_annotate_with_emitter_loc,json=xlaGpuUnsupportedAnnotateWithEmitterLoc,proto3,oneof" json:"xla_gpu_unsupported_annotate_with_emitter_loc,omitempty"`
	// Internal testing flag to switch AllReduceDecomposer on or off.
	XlaGpuUnsupportedEnableAllReduceDecomposer *bool `protobuf:"varint,384,opt,name=xla_gpu_unsupported_enable_all_reduce_decomposer,json=xlaGpuUnsupportedEnableAllReduceDecomposer,proto3,oneof" json:"xla_gpu_unsupported_enable_all_reduce_decomposer,omitempty"`
	// Internal testing flag to switch RaggedAllToAllDecomposer on or off.
	XlaGpuUnsupportedEnableRaggedAllToAllDecomposer *bool `protobuf:"varint,350,opt,name=xla_gpu_unsupported_enable_ragged_all_to_all_decomposer,json=xlaGpuUnsupportedEnableRaggedAllToAllDecomposer,proto3,oneof" json:"xla_gpu_unsupported_enable_ragged_all_to_all_decomposer,omitempty"`
	// Internal debug/testing flag to switch Triton GEMM fusions on or off.
	XlaGpuUnsupportedEnableTritonGemm *bool `protobuf:"varint,322,opt,name=xla_gpu_unsupported_enable_triton_gemm,json=xlaGpuUnsupportedEnableTritonGemm,proto3,oneof" json:"xla_gpu_unsupported_enable_triton_gemm,omitempty"`
	// Enable experimental triton multi-output fusion.
	// TODO(b/390559452): Remove the flag once the feature is stable.
	XlaGpuUnsupportedEnableTritonMultiOutputFusion *bool `protobuf:"varint,382,opt,name=xla_gpu_unsupported_enable_triton_multi_output_fusion,json=xlaGpuUnsupportedEnableTritonMultiOutputFusion,proto3,oneof" json:"xla_gpu_unsupported_enable_triton_multi_output_fusion,omitempty"`
	// Controls smaller knobs of the generic Triton emitter.
	// Do not rely on this flag currently supported values as they are subject to
	// change. Check 'debug_option_flags' for description.
	// TODO(b/393299275): remove the flag once we fully switched to the new
	// emitter.
	XlaGpuUnsupportedGenericTritonEmitterFeatures []DebugOptions_GenericTritonEmitterFeature `protobuf:"varint,398,rep,packed,name=xla_gpu_unsupported_generic_triton_emitter_features,json=xlaGpuUnsupportedGenericTritonEmitterFeatures,proto3,enum=xla.DebugOptions_GenericTritonEmitterFeature" json:"xla_gpu_unsupported_generic_triton_emitter_features,omitempty"`
	// Internal testing flag to enable one-shot kernel for single-host
	// all-reduce operations.
	XlaGpuUnsupportedUseAllReduceOneShotKernel *bool `protobuf:"varint,387,opt,name=xla_gpu_unsupported_use_all_reduce_one_shot_kernel,json=xlaGpuUnsupportedUseAllReduceOneShotKernel,proto3,oneof" json:"xla_gpu_unsupported_use_all_reduce_one_shot_kernel,omitempty"`
	// Internal testing flag to enable one-shot kernel for single-host
	// ragged-all-to-all operations.
	XlaGpuUnsupportedUseRaggedAllToAllOneShotKernel *bool `protobuf:"varint,375,opt,name=xla_gpu_unsupported_use_ragged_all_to_all_one_shot_kernel,json=xlaGpuUnsupportedUseRaggedAllToAllOneShotKernel,proto3,oneof" json:"xla_gpu_unsupported_use_ragged_all_to_all_one_shot_kernel,omitempty"`
	// Use lld as a library for the linking step
	XlaGpuUseInprocessLld *bool `protobuf:"varint,389,opt,name=xla_gpu_use_inprocess_lld,json=xlaGpuUseInprocessLld,proto3,oneof" json:"xla_gpu_use_inprocess_lld,omitempty"`
	// This instructs the runtime whether to use memcpy for p2p communication when
	// source and target are located within a node(nvlink).
	XlaGpuUseMemcpyLocalP2P *bool `protobuf:"varint,287,opt,name=xla_gpu_use_memcpy_local_p2p,json=xlaGpuUseMemcpyLocalP2p,proto3,oneof" json:"xla_gpu_use_memcpy_local_p2p,omitempty"`
	// An option to enable using cuDNN runtime compiled fusion kernels which is
	// available and recommended for Ampere+ GPUs.
	XlaGpuUseRuntimeFusion *bool `protobuf:"varint,181,opt,name=xla_gpu_use_runtime_fusion,json=xlaGpuUseRuntimeFusion,proto3,oneof" json:"xla_gpu_use_runtime_fusion,omitempty"`
	// If true, will verify that the numerical results of Triton fusions match
	// the results of regular emitters.
	XlaGpuVerifyTritonFusionNumerics *bool `protobuf:"varint,291,opt,name=xla_gpu_verify_triton_fusion_numerics,json=xlaGpuVerifyTritonFusionNumerics,proto3,oneof" json:"xla_gpu_verify_triton_fusion_numerics,omitempty"`
	// Show addresses of HLO ops in graph dump.
	XlaHloGraphAddresses *bool `protobuf:"varint,2,opt,name=xla_hlo_graph_addresses,json=xlaHloGraphAddresses,proto3,oneof" json:"xla_hlo_graph_addresses,omitempty"`
	// Instrument the computation to collect per-HLO cycle counts.
	XlaHloProfile *bool `protobuf:"varint,9,opt,name=xla_hlo_profile,json=xlaHloProfile,proto3,oneof" json:"xla_hlo_profile,omitempty"`
	// List of HLO passes to disable/enable. These names must exactly match the
	// pass names as specified by the HloPassInterface::name() method.
	//
	// At least one of xla_disable_hlo_passes and xla_enable_hlo_passes_only must
	// be empty.
	XlaDisableHloPasses    []string `protobuf:"bytes,30,rep,name=xla_disable_hlo_passes,json=xlaDisableHloPasses,proto3" json:"xla_disable_hlo_passes,omitempty"`
	XlaEnableHloPassesOnly []string `protobuf:"bytes,124,rep,name=xla_enable_hlo_passes_only,json=xlaEnableHloPassesOnly,proto3" json:"xla_enable_hlo_passes_only,omitempty"`
	// Disables all HLO passes.  Notes that some passes are necessary for
	// correctness and the invariants that must be satisfied by "fully optimized"
	// HLO are different for different devices and may change over time.  The only
	// "guarantee", such as it is, is that if you compile XLA and dump the
	// optimized HLO for some graph, you should be able to run it again on the
	// same device with the same build of XLA.
	XlaDisableAllHloPasses *bool `protobuf:"varint,104,opt,name=xla_disable_all_hlo_passes,json=xlaDisableAllHloPasses,proto3,oneof" json:"xla_disable_all_hlo_passes,omitempty"`
	// Numerical optimization level for the XLA compiler backend; the specific
	// interpretation of this value is left to the backends.
	XlaBackendOptimizationLevel *int32 `protobuf:"varint,31,opt,name=xla_backend_optimization_level,json=xlaBackendOptimizationLevel,proto3,oneof" json:"xla_backend_optimization_level,omitempty"`
	// Embed the compiler IR as a string in the executable.
	XlaEmbedIrInExecutable *bool `protobuf:"varint,33,opt,name=xla_embed_ir_in_executable,json=xlaEmbedIrInExecutable,proto3,oneof" json:"xla_embed_ir_in_executable,omitempty"`
	// Eliminate implicit broadcasts when lowering user computations to HLO
	// instructions; use explicit broadcast instead.
	XlaEliminateHloImplicitBroadcast *bool `protobuf:"varint,35,opt,name=xla_eliminate_hlo_implicit_broadcast,json=xlaEliminateHloImplicitBroadcast,proto3,oneof" json:"xla_eliminate_hlo_implicit_broadcast,omitempty"`
	// When generating calls to Eigen in the CPU backend, use multi-threaded Eigen
	// mode.
	XlaCpuMultiThreadEigen *bool `protobuf:"varint,60,opt,name=xla_cpu_multi_thread_eigen,json=xlaCpuMultiThreadEigen,proto3,oneof" json:"xla_cpu_multi_thread_eigen,omitempty"`
	// If true, in LLVM-based backends, emit !alias.scope metadata in
	// generated IR.
	XlaLlvmEnableAliasScopeMetadata *bool `protobuf:"varint,70,opt,name=xla_llvm_enable_alias_scope_metadata,json=xlaLlvmEnableAliasScopeMetadata,proto3,oneof" json:"xla_llvm_enable_alias_scope_metadata,omitempty"`
	// If true, in LLVM-based backends, emit !noalias metadata in the
	// generated IR.
	XlaLlvmEnableNoaliasMetadata *bool `protobuf:"varint,71,opt,name=xla_llvm_enable_noalias_metadata,json=xlaLlvmEnableNoaliasMetadata,proto3,oneof" json:"xla_llvm_enable_noalias_metadata,omitempty"`
	// If true, in LLVM-based backends, emit !invariant.load metadata in
	// the generated IR.
	XlaLlvmEnableInvariantLoadMetadata *bool `protobuf:"varint,72,opt,name=xla_llvm_enable_invariant_load_metadata,json=xlaLlvmEnableInvariantLoadMetadata,proto3,oneof" json:"xla_llvm_enable_invariant_load_metadata,omitempty"`
	// If true, a set of expensive LLVM optimization passes will not be run.
	XlaLlvmDisableExpensivePasses *bool `protobuf:"varint,73,opt,name=xla_llvm_disable_expensive_passes,json=xlaLlvmDisableExpensivePasses,proto3,oneof" json:"xla_llvm_disable_expensive_passes,omitempty"`
	// This is used by ClientLibraryTestBase::ComputeAndCompare*. If true, the
	// computation will run n! times with all permunations of layouts for the
	// output shape in rank n. For example, with a 3D shape, all permutations of
	// the set {0, 1, 2} are tried.
	XlaTestAllOutputLayouts *bool `protobuf:"varint,90,opt,name=xla_test_all_output_layouts,json=xlaTestAllOutputLayouts,proto3,oneof" json:"xla_test_all_output_layouts,omitempty"`
	// This is used by ClientLibraryTestBase::ComputeAndCompare*. If true, the
	// computation will run for all permunations of layouts of all input
	// arguments. For example, with 2 input arguments in 2D and 4D shapes, the
	// computation will run 2! * 4! times.
	XlaTestAllInputLayouts *bool `protobuf:"varint,91,opt,name=xla_test_all_input_layouts,json=xlaTestAllInputLayouts,proto3,oneof" json:"xla_test_all_input_layouts,omitempty"`
	// Assign colors based on sharding information when generating the Graphviz
	// HLO graph.
	XlaHloGraphShardingColor *bool `protobuf:"varint,92,opt,name=xla_hlo_graph_sharding_color,json=xlaHloGraphShardingColor,proto3,oneof" json:"xla_hlo_graph_sharding_color,omitempty"`
	// Call oneDNN thunks for matmul and convolution fusions in the CPU backend.
	XlaCpuUseOnednn *bool `protobuf:"varint,97,opt,name=xla_cpu_use_onednn,json=xlaCpuUseOnednn,proto3,oneof" json:"xla_cpu_use_onednn,omitempty"`
	// Allows xla to increase the output precision of floating point operations
	// and all floating-point conversions to be simplified, including those
	// that affect the numerics. The `FloatNormalization` pass inserts many
	// `f32 -> bf16 -> f32` conversion pairs. These are not removed by the
	// `AlgebraicSimplifier`, as that will only simplify conversions that are
	// no-ops, e.g. `bf16 -> f32 -> bf16`. Removing these improves accuracy.
	XlaAllowExcessPrecision *bool `protobuf:"varint,122,opt,name=xla_allow_excess_precision,json=xlaAllowExcessPrecision,proto3,oneof" json:"xla_allow_excess_precision,omitempty"`
	// Force the host platform to pretend that there are these many host
	// "devices".  All these devices are backed by the same threadpool.  Defaults
	// to 1.
	//
	// Setting this to anything other than 1 can increase overhead from context
	// switching but we let the user override this behavior to help run tests on
	// the host that run models in parallel across multiple devices.
	XlaForceHostPlatformDeviceCount *int32 `protobuf:"varint,102,opt,name=xla_force_host_platform_device_count,json=xlaForceHostPlatformDeviceCount,proto3,oneof" json:"xla_force_host_platform_device_count,omitempty"`
	// Enable fast math with eigen in the HLO evaluator.
	XlaHloEvaluatorUseFastPath *bool `protobuf:"varint,106,opt,name=xla_hlo_evaluator_use_fast_path,json=xlaHloEvaluatorUseFastPath,proto3,oneof" json:"xla_hlo_evaluator_use_fast_path,omitempty"`
	// Temporary option to allow support for both the R1 and the scalar index
	// versions of DynamicSlice and DynamicUpdateSlice. Only used for testing.
	XlaAllowScalarIndexDynamicOps *bool `protobuf:"varint,107,opt,name=xla_allow_scalar_index_dynamic_ops,json=xlaAllowScalarIndexDynamicOps,proto3,oneof" json:"xla_allow_scalar_index_dynamic_ops,omitempty"`
	// Option to emit a target-specific marker to indicate the start of a training
	// step. The location of the marker (if any) is determined by the option
	// value.
	XlaStepMarkerLocation *DebugOptions_StepMarkerLocation `protobuf:"varint,108,opt,name=xla_step_marker_location,json=xlaStepMarkerLocation,proto3,enum=xla.DebugOptions_StepMarkerLocation,oneof" json:"xla_step_marker_location,omitempty"`
	// Directory to dump into.
	XlaDumpTo     *string `protobuf:"bytes,109,opt,name=xla_dump_to,json=xlaDumpTo,proto3,oneof" json:"xla_dump_to,omitempty"`
	XlaFlagsReset *bool   `protobuf:"varint,364,opt,name=xla_flags_reset,json=xlaFlagsReset,proto3,oneof" json:"xla_flags_reset,omitempty"`
	// If specified, will only dump modules which match this regexp.
	XlaDumpHloModuleRe *string `protobuf:"bytes,110,opt,name=xla_dump_hlo_module_re,json=xlaDumpHloModuleRe,proto3,oneof" json:"xla_dump_hlo_module_re,omitempty"`
	// If this flag is specified, will also dump HLO before and after passes that
	// match this regular expression.  Set to .* to dump before/after all passes.
	XlaDumpHloPassRe *string `protobuf:"bytes,111,opt,name=xla_dump_hlo_pass_re,json=xlaDumpHloPassRe,proto3,oneof" json:"xla_dump_hlo_pass_re,omitempty"`
	// Specifies the format that HLO is dumped in.  Multiple of these may be
	// specified.
	XlaDumpHloAsText  *bool `protobuf:"varint,112,opt,name=xla_dump_hlo_as_text,json=xlaDumpHloAsText,proto3,oneof" json:"xla_dump_hlo_as_text,omitempty"`
	XlaDumpHloAsProto *bool `protobuf:"varint,113,opt,name=xla_dump_hlo_as_proto,json=xlaDumpHloAsProto,proto3,oneof" json:"xla_dump_hlo_as_proto,omitempty"`
	XlaDumpHloAsDot   *bool `protobuf:"varint,114,opt,name=xla_dump_hlo_as_dot,json=xlaDumpHloAsDot,proto3,oneof" json:"xla_dump_hlo_as_dot,omitempty"`
	XlaDumpHloAsUrl   *bool `protobuf:"varint,115,opt,name=xla_dump_hlo_as_url,json=xlaDumpHloAsUrl,proto3,oneof" json:"xla_dump_hlo_as_url,omitempty"`
	// Dump HLO graphs as an HTML (DOT -> SVG inlined in HTML)
	XlaDumpHloAsHtml *bool `protobuf:"varint,116,opt,name=xla_dump_hlo_as_html,json=xlaDumpHloAsHtml,proto3,oneof" json:"xla_dump_hlo_as_html,omitempty"`
	// Dump the visualization of the fusion progress.
	XlaDumpFusionVisualization *bool `protobuf:"varint,149,opt,name=xla_dump_fusion_visualization,json=xlaDumpFusionVisualization,proto3,oneof" json:"xla_dump_fusion_visualization,omitempty"`
	// If true, every time an HLO module is run, we will dump an HloSnapshot
	// (essentially, a serialized module plus its inputs) to the --xla_dump_to
	// directory.
	XlaDumpHloSnapshots *bool `protobuf:"varint,118,opt,name=xla_dump_hlo_snapshots,json=xlaDumpHloSnapshots,proto3,oneof" json:"xla_dump_hlo_snapshots,omitempty"`
	// Include a timestamp in the dumped filenames.
	XlaDumpIncludeTimestamp *bool `protobuf:"varint,131,opt,name=xla_dump_include_timestamp,json=xlaDumpIncludeTimestamp,proto3,oneof" json:"xla_dump_include_timestamp,omitempty"`
	// Max number of hlo module dumps in a directory. Set to < 0 for unbounded.
	XlaDumpMaxHloModules *int32 `protobuf:"varint,132,opt,name=xla_dump_max_hlo_modules,json=xlaDumpMaxHloModules,proto3,oneof" json:"xla_dump_max_hlo_modules,omitempty"`
	// Dump HloModuleMetadata as a text proto for each HLO module.
	XlaDumpModuleMetadata *bool `protobuf:"varint,144,opt,name=xla_dump_module_metadata,json=xlaDumpModuleMetadata,proto3,oneof" json:"xla_dump_module_metadata,omitempty"`
	// GZip-compress protos dumped via --xla_dump_hlo_as_proto.
	XlaDumpCompressProtos *bool `protobuf:"varint,151,opt,name=xla_dump_compress_protos,json=xlaDumpCompressProtos,proto3,oneof" json:"xla_dump_compress_protos,omitempty"`
	// Dump HLO in long text format. Ignored unless xla_dump_hlo_as_text is true.
	XlaDumpHloAsLongText *bool `protobuf:"varint,164,opt,name=xla_dump_hlo_as_long_text,json=xlaDumpHloAsLongText,proto3,oneof" json:"xla_dump_hlo_as_long_text,omitempty"`
	// Whether to dump mlir using pretty print form.
	XlaDumpEnableMlirPrettyForm *bool `protobuf:"varint,185,opt,name=xla_dump_enable_mlir_pretty_form,json=xlaDumpEnableMlirPrettyForm,proto3,oneof" json:"xla_dump_enable_mlir_pretty_form,omitempty"`
	// Whether to dump mlir using pretty print form.
	XlaDumpFullHloConfig *bool `protobuf:"varint,381,opt,name=xla_dump_full_hlo_config,json=xlaDumpFullHloConfig,proto3,oneof" json:"xla_dump_full_hlo_config,omitempty"`
	// Debug options that trigger execution errors when NaN or Inf are detected.
	XlaTpuDetectNan *bool `protobuf:"varint,135,opt,name=xla_tpu_detect_nan,json=xlaTpuDetectNan,proto3,oneof" json:"xla_tpu_detect_nan,omitempty"`
	XlaTpuDetectInf *bool `protobuf:"varint,136,opt,name=xla_tpu_detect_inf,json=xlaTpuDetectInf,proto3,oneof" json:"xla_tpu_detect_inf,omitempty"`
	// True if TraceMe annotations are enabled for XLA:CPU.
	XlaCpuEnableXprofTraceme *bool `protobuf:"varint,137,opt,name=xla_cpu_enable_xprof_traceme,json=xlaCpuEnableXprofTraceme,proto3,oneof" json:"xla_cpu_enable_xprof_traceme,omitempty"`
	// Per-heap size constraint. New heaps will be created if per-heap max size is
	// reached.
	XlaMultiheapSizeConstraintPerHeap *int32 `protobuf:"varint,142,opt,name=xla_multiheap_size_constraint_per_heap,json=xlaMultiheapSizeConstraintPerHeap,proto3,oneof" json:"xla_multiheap_size_constraint_per_heap,omitempty"`
	// Enable detailed logging into vlog. If this is disabled, no
	// compilation summary will be printed in the end of computation.
	XlaDetailedLogging *bool `protobuf:"varint,252,opt,name=xla_detailed_logging,json=xlaDetailedLogging,proto3,oneof" json:"xla_detailed_logging,omitempty"`
	// Enable HLO dumping. If this is disabled, no HLO modules will be dumped.
	XlaEnableDumping *bool `protobuf:"varint,253,opt,name=xla_enable_dumping,json=xlaEnableDumping,proto3,oneof" json:"xla_enable_dumping,omitempty"`
	// Whether to force inline before llvm module split to get a more balanced
	// splits for parallel compilation.
	XlaLlvmForceInlineBeforeSplit *bool `protobuf:"varint,300,opt,name=xla_llvm_force_inline_before_split,json=xlaLlvmForceInlineBeforeSplit,proto3,oneof" json:"xla_llvm_force_inline_before_split,omitempty"`
	// Disable dumping metadata in HLO dumps.
	XlaDumpDisableMetadata *bool `protobuf:"varint,153,opt,name=xla_dump_disable_metadata,json=xlaDumpDisableMetadata,proto3,oneof" json:"xla_dump_disable_metadata,omitempty"`
	// If this flag is specified, will only dump HLO before and after passes in
	// the pass pipeline that matches this regular expression. Default empty value
	// enables dumping in all pipelines.
	XlaDumpHloPipelineRe *string `protobuf:"bytes,154,opt,name=xla_dump_hlo_pipeline_re,json=xlaDumpHloPipelineRe,proto3,oneof" json:"xla_dump_hlo_pipeline_re,omitempty"`
	// Generate calls to Arm Compute Library in the CPU backend.
	XlaCpuUseAcl *bool `protobuf:"varint,174,opt,name=xla_cpu_use_acl,json=xlaCpuUseAcl,proto3,oneof" json:"xla_cpu_use_acl,omitempty"`
	// By default, XLA:CPU will run fp16 dot/conv as fp32, as this is generally
	// (much) faster on our hardware.  Set this flag to disable this behavior.
	XlaCpuStrictDotConvMath      *bool `protobuf:"varint,175,opt,name=xla_cpu_strict_dot_conv_math,json=xlaCpuStrictDotConvMath,proto3,oneof" json:"xla_cpu_strict_dot_conv_math,omitempty"`
	XlaDumpLatencyHidingSchedule *bool `protobuf:"varint,182,opt,name=xla_dump_latency_hiding_schedule,json=xlaDumpLatencyHidingSchedule,proto3,oneof" json:"xla_dump_latency_hiding_schedule,omitempty"`
	// The partitioning algorithm to be used in the PartitionAssignment pass.
	XlaPartitioningAlgorithm *DebugOptions_PartitioningAlgorithm `protobuf:"varint,187,opt,name=xla_partitioning_algorithm,json=xlaPartitioningAlgorithm,proto3,enum=xla.DebugOptions_PartitioningAlgorithm,oneof" json:"xla_partitioning_algorithm,omitempty"`
	// Maximum number of buffers to print when debugging buffer assignment.
	XlaDebugBufferAssignmentShowMax *int64 `protobuf:"varint,251,opt,name=xla_debug_buffer_assignment_show_max,json=xlaDebugBufferAssignmentShowMax,proto3,oneof" json:"xla_debug_buffer_assignment_show_max,omitempty"`
	// Whether to enable checks for unstable reductions in computations.
	XlaDetectUnstableReductions *DebugOptions_UnstableReductionDetectionMode `protobuf:"varint,403,opt,name=xla_detect_unstable_reductions,json=xlaDetectUnstableReductions,proto3,enum=xla.DebugOptions_UnstableReductionDetectionMode,oneof" json:"xla_detect_unstable_reductions,omitempty"`
	// If true, large constants will be printed out when dumping HLOs.
	XlaDumpLargeConstants *bool `protobuf:"varint,290,opt,name=xla_dump_large_constants,json=xlaDumpLargeConstants,proto3,oneof" json:"xla_dump_large_constants,omitempty"`
	// Base length to rewrite the reduce window to, no rewrite if set to 0.
	XlaReduceWindowRewriteBaseLength *int64 `protobuf:"varint,293,opt,name=xla_reduce_window_rewrite_base_length,json=xlaReduceWindowRewriteBaseLength,proto3,oneof" json:"xla_reduce_window_rewrite_base_length,omitempty"`
	// The command buffer trace cache size, increasing the cache size may
	// sometimes reduces the chances of doing command buffer tracing for
	// updating command buffer instance.
	XlaCmdBufferTraceCacheSize *int64 `protobuf:"varint,311,opt,name=xla_cmd_buffer_trace_cache_size,json=xlaCmdBufferTraceCacheSize,proto3,oneof" json:"xla_cmd_buffer_trace_cache_size,omitempty"`
	// Custom call targets with legacy registry API (non FFI API),
	// that support recording to command buffer custom command,
	// i.e., custom call target supports cuda-graph capturing for CUDA devices.
	// This flag is read if CUSTOM_CALL command type is recorded into
	// command buffer.
	LegacyCommandBufferCustomCallTargets []string `protobuf:"bytes,314,rep,name=legacy_command_buffer_custom_call_targets,json=legacyCommandBufferCustomCallTargets,proto3" json:"legacy_command_buffer_custom_call_targets,omitempty"`
	// This flag is used for controlling HLO dumping and NVTX marker. If turned
	// on, both HLO dumping and NVTX marker will use syntactic sugar wrappers
	// as op names, while the actual op names will be shown if turned off.
	//
	// Here is an example HLO excerpt with the flag off:
	//
	//	 async_computation {
	//	  param_0 = f32[1,4,8]{1,0,2} parameter(0)
	//	  ROOT all-to-all.3.1 = f32[1,4,8]{1,0,2} all-to-all(param_0),
	//	                        replica_groups={{0,1,2,3,4,5,6,7}}, dimensions={2}
	//	 }
	//	...
	//
	//	all-to-all-start =
	//	  ((f32[1,4,8]{1,0,2}), f32[1,4,8]{1,0,2}) async-start(bitcast.24.0),
	//	  calls=async_computation, backend_config={...}
	//	all-to-all-done = f32[1,4,8]{1,0,2} async-done(all-to-all-start)
	//
	// and with the flag on:
	//
	//	all-to-all-start = ((f32[1,4,8]{1,0,2}), f32[1,4,8]{1,0,2})
	//	                   all-to-all-start(bitcast.24.0),
	//	                   replica_groups={{0,1,2,3,4,5,6,7}}, dimensions={2},
	//	                   backend_config={...}
	//	all-to-all-done = f32[1,4,8]{1,0,2} all-to-all-done(all-to-all-start)
	XlaSyntaxSugarAsyncOps *bool `protobuf:"varint,315,opt,name=xla_syntax_sugar_async_ops,json=xlaSyntaxSugarAsyncOps,proto3,oneof" json:"xla_syntax_sugar_async_ops,omitempty"`
	// Allow launching command buffers while profiling active.
	// When disabled, execute in op-by-op mode.
	// TODO(b/355487968): Remove this option when validation complete.
	XlaEnableCommandBuffersDuringProfiling *bool `protobuf:"varint,317,opt,name=xla_enable_command_buffers_during_profiling,json=xlaEnableCommandBuffersDuringProfiling,proto3,oneof" json:"xla_enable_command_buffers_during_profiling,omitempty"`
	// Whether to ignore channel ids(including verifier channel id checks)
	// for collectives in the given HLO.
	XlaIgnoreChannelId          *bool `protobuf:"varint,330,opt,name=xla_ignore_channel_id,json=xlaIgnoreChannelId,proto3,oneof" json:"xla_ignore_channel_id,omitempty"`
	XlaPjrtAllowAutoLayoutInHlo *bool `protobuf:"varint,344,opt,name=xla_pjrt_allow_auto_layout_in_hlo,json=xlaPjrtAllowAutoLayoutInHlo,proto3,oneof" json:"xla_pjrt_allow_auto_layout_in_hlo,omitempty"`
	// If true, the test launched with ClientLibraryTestBase will also try to
	// use command buffer mode to run.
	XlaTestAddCommandBufferMode *bool `protobuf:"varint,373,opt,name=xla_test_add_command_buffer_mode,json=xlaTestAddCommandBufferMode,proto3,oneof" json:"xla_test_add_command_buffer_mode,omitempty"`
	// Path to experimental collective perf tables.
	XlaGpuExperimentalMatmulPerfTablePath *string `protobuf:"bytes,383,opt,name=xla_gpu_experimental_matmul_perf_table_path,json=xlaGpuExperimentalMatmulPerfTablePath,proto3,oneof" json:"xla_gpu_experimental_matmul_perf_table_path,omitempty"`
	// Exits the compilation after layout assignment and returns only the
	// layouts.
	XlaEarlyExitWithLayouts *bool `protobuf:"varint,397,opt,name=xla_early_exit_with_layouts,json=xlaEarlyExitWithLayouts,proto3,oneof" json:"xla_early_exit_with_layouts,omitempty"`
	// If true, the triton fusion emitter will ignore IsTritonSupportedInstruction
	// We need this to enable triton scaled dot emitter for testing.
	XlaGpuExperimentalScaledDotWithTriton *bool `protobuf:"varint,410,opt,name=xla_gpu_experimental_scaled_dot_with_triton,json=xlaGpuExperimentalScaledDotWithTriton,proto3,oneof" json:"xla_gpu_experimental_scaled_dot_with_triton,omitempty"`
	// If true, use third-party library raft::matrix::select_k to implement TopK.
	XlaGpuExperimentalUseRaftSelectK *bool `protobuf:"varint,413,opt,name=xla_gpu_experimental_use_raft_select_k,json=xlaGpuExperimentalUseRaftSelectK,proto3,oneof" json:"xla_gpu_experimental_use_raft_select_k,omitempty"`
	// Extra options to pass to the compilation backend (e.g. LLVM); specific
	// interpretation of these values is left to the backend.
	XlaBackendExtraOptions map[string]string `protobuf:"bytes,500,rep,name=xla_backend_extra_options,json=xlaBackendExtraOptions,proto3" json:"xla_backend_extra_options,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *DebugOptions) Reset() {
	*x = DebugOptions{}
	mi := &file_xla_xla_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DebugOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DebugOptions) ProtoMessage() {}

func (x *DebugOptions) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DebugOptions.ProtoReflect.Descriptor instead.
func (*DebugOptions) Descriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{1}
}

func (x *DebugOptions) GetXlaDisableAutomaticHostComputeOffload() bool {
	if x != nil && x.XlaDisableAutomaticHostComputeOffload != nil {
		return *x.XlaDisableAutomaticHostComputeOffload
	}
	return false
}

func (x *DebugOptions) GetXlaHloPassFixDetectCycles() bool {
	if x != nil && x.XlaHloPassFixDetectCycles != nil {
		return *x.XlaHloPassFixDetectCycles
	}
	return false
}

func (x *DebugOptions) GetXlaUnsupportedCrashOnHloPassFixMaxIterations() bool {
	if x != nil && x.XlaUnsupportedCrashOnHloPassFixMaxIterations != nil {
		return *x.XlaUnsupportedCrashOnHloPassFixMaxIterations
	}
	return false
}

func (x *DebugOptions) GetXlaUnsupportedCrashOnHloPassNoopChange() bool {
	if x != nil && x.XlaUnsupportedCrashOnHloPassNoopChange != nil {
		return *x.XlaUnsupportedCrashOnHloPassNoopChange
	}
	return false
}

func (x *DebugOptions) GetXlaUnsupportedCrashOnHloPassSilentHloChange() bool {
	if x != nil && x.XlaUnsupportedCrashOnHloPassSilentHloChange != nil {
		return *x.XlaUnsupportedCrashOnHloPassSilentHloChange
	}
	return false
}

func (x *DebugOptions) GetXlaCpuCopyInsertionUseRegionAnalysis() bool {
	if x != nil && x.XlaCpuCopyInsertionUseRegionAnalysis != nil {
		return *x.XlaCpuCopyInsertionUseRegionAnalysis
	}
	return false
}

func (x *DebugOptions) GetXlaCpuEmitterVerificationLevel() int32 {
	if x != nil && x.XlaCpuEmitterVerificationLevel != nil {
		return *x.XlaCpuEmitterVerificationLevel
	}
	return 0
}

func (x *DebugOptions) GetXlaCpuEnableConcurrencyOptimizedScheduler() bool {
	if x != nil && x.XlaCpuEnableConcurrencyOptimizedScheduler != nil {
		return *x.XlaCpuEnableConcurrencyOptimizedScheduler
	}
	return false
}

func (x *DebugOptions) GetXlaCpuEnableFastMath() bool {
	if x != nil && x.XlaCpuEnableFastMath != nil {
		return *x.XlaCpuEnableFastMath
	}
	return false
}

func (x *DebugOptions) GetXlaCpuEnableFastMinMax() bool {
	if x != nil && x.XlaCpuEnableFastMinMax != nil {
		return *x.XlaCpuEnableFastMinMax
	}
	return false
}

func (x *DebugOptions) GetXlaCpuExperimentalOnednnCustomCall() bool {
	if x != nil && x.XlaCpuExperimentalOnednnCustomCall != nil {
		return *x.XlaCpuExperimentalOnednnCustomCall
	}
	return false
}

func (x *DebugOptions) GetXlaCpuExperimentalOnednnFusionType() []DebugOptions_LibraryFusionType {
	if x != nil {
		return x.XlaCpuExperimentalOnednnFusionType
	}
	return nil
}

func (x *DebugOptions) GetXlaCpuExperimentalXnnFusionType() []DebugOptions_LibraryFusionType {
	if x != nil {
		return x.XlaCpuExperimentalXnnFusionType
	}
	return nil
}

func (x *DebugOptions) GetXlaCpuExperimentalXnnGraphFusionMode() DebugOptions_XnnGraphFusionMode {
	if x != nil && x.XlaCpuExperimentalXnnGraphFusionMode != nil {
		return *x.XlaCpuExperimentalXnnGraphFusionMode
	}
	return DebugOptions_XNN_GRAPH_FUSION_MODE_DISABLED
}

func (x *DebugOptions) GetXlaCpuFastMathHonorDivision() bool {
	if x != nil && x.XlaCpuFastMathHonorDivision != nil {
		return *x.XlaCpuFastMathHonorDivision
	}
	return false
}

func (x *DebugOptions) GetXlaCpuFastMathHonorFunctions() bool {
	if x != nil && x.XlaCpuFastMathHonorFunctions != nil {
		return *x.XlaCpuFastMathHonorFunctions
	}
	return false
}

func (x *DebugOptions) GetXlaCpuFastMathHonorInfs() bool {
	if x != nil && x.XlaCpuFastMathHonorInfs != nil {
		return *x.XlaCpuFastMathHonorInfs
	}
	return false
}

func (x *DebugOptions) GetXlaCpuFastMathHonorNans() bool {
	if x != nil && x.XlaCpuFastMathHonorNans != nil {
		return *x.XlaCpuFastMathHonorNans
	}
	return false
}

func (x *DebugOptions) GetXlaCpuGenerateUniqueCStyleKernelEntryPoints() bool {
	if x != nil && x.XlaCpuGenerateUniqueCStyleKernelEntryPoints != nil {
		return *x.XlaCpuGenerateUniqueCStyleKernelEntryPoints
	}
	return false
}

func (x *DebugOptions) GetXlaCpuMaxIsa() string {
	if x != nil && x.XlaCpuMaxIsa != nil {
		return *x.XlaCpuMaxIsa
	}
	return ""
}

func (x *DebugOptions) GetXlaCpuParallelCodegenSplitCount() int32 {
	if x != nil && x.XlaCpuParallelCodegenSplitCount != nil {
		return *x.XlaCpuParallelCodegenSplitCount
	}
	return 0
}

func (x *DebugOptions) GetXlaCpuPreferVectorWidth() int32 {
	if x != nil && x.XlaCpuPreferVectorWidth != nil {
		return *x.XlaCpuPreferVectorWidth
	}
	return 0
}

func (x *DebugOptions) GetXlaCpuUseFusionEmitters() bool {
	if x != nil && x.XlaCpuUseFusionEmitters != nil {
		return *x.XlaCpuUseFusionEmitters
	}
	return false
}

func (x *DebugOptions) GetXlaCpuUseXnnpack() bool {
	if x != nil && x.XlaCpuUseXnnpack != nil {
		return *x.XlaCpuUseXnnpack
	}
	return false
}

func (x *DebugOptions) GetXlaEnableFastMath() bool {
	if x != nil && x.XlaEnableFastMath != nil {
		return *x.XlaEnableFastMath
	}
	return false
}

func (x *DebugOptions) GetXlaDumpHloUnoptimizedSnapshots() bool {
	if x != nil && x.XlaDumpHloUnoptimizedSnapshots != nil {
		return *x.XlaDumpHloUnoptimizedSnapshots
	}
	return false
}

func (x *DebugOptions) GetXlaGpuAlgorithmDenylistPath() string {
	if x != nil && x.XlaGpuAlgorithmDenylistPath != nil {
		return *x.XlaGpuAlgorithmDenylistPath
	}
	return ""
}

func (x *DebugOptions) GetXlaGpuAllGatherCombineThresholdBytes() int64 {
	if x != nil && x.XlaGpuAllGatherCombineThresholdBytes != nil {
		return *x.XlaGpuAllGatherCombineThresholdBytes
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuAllReduceBlueconnectNumDevicesPerHost() int32 {
	if x != nil && x.XlaGpuAllReduceBlueconnectNumDevicesPerHost != nil {
		return *x.XlaGpuAllReduceBlueconnectNumDevicesPerHost
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuAllReduceCombineThresholdBytes() int64 {
	if x != nil && x.XlaGpuAllReduceCombineThresholdBytes != nil {
		return *x.XlaGpuAllReduceCombineThresholdBytes
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuAnalyticalLatencyEstimatorOptions() map[string]string {
	if x != nil {
		return x.XlaGpuAnalyticalLatencyEstimatorOptions
	}
	return nil
}

func (x *DebugOptions) GetXlaGpuAsyncDot() bool {
	if x != nil && x.XlaGpuAsyncDot != nil {
		return *x.XlaGpuAsyncDot
	}
	return false
}

func (x *DebugOptions) GetXlaGpuAutoSpmdPartitioningMemoryBudgetGb() int32 {
	if x != nil && x.XlaGpuAutoSpmdPartitioningMemoryBudgetGb != nil {
		return *x.XlaGpuAutoSpmdPartitioningMemoryBudgetGb
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuAutoSpmdPartitioningMemoryBudgetRatio() float32 {
	if x != nil && x.XlaGpuAutoSpmdPartitioningMemoryBudgetRatio != nil {
		return *x.XlaGpuAutoSpmdPartitioningMemoryBudgetRatio
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuAutotuneGemmRtol() float32 {
	if x != nil && x.XlaGpuAutotuneGemmRtol != nil {
		return *x.XlaGpuAutotuneGemmRtol
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuAutotuneLevel() int32 {
	if x != nil && x.XlaGpuAutotuneLevel != nil {
		return *x.XlaGpuAutotuneLevel
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuAutotuneMaxSolutions() int64 {
	if x != nil && x.XlaGpuAutotuneMaxSolutions != nil {
		return *x.XlaGpuAutotuneMaxSolutions
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuCollectCostModelStats() bool {
	if x != nil && x.XlaGpuCollectCostModelStats != nil {
		return *x.XlaGpuCollectCostModelStats
	}
	return false
}

func (x *DebugOptions) GetXlaGpuCollectiveInflationFactor() int32 {
	if x != nil && x.XlaGpuCollectiveInflationFactor != nil {
		return *x.XlaGpuCollectiveInflationFactor
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuCollectivePermuteCombineThresholdBytes() int64 {
	if x != nil && x.XlaGpuCollectivePermuteCombineThresholdBytes != nil {
		return *x.XlaGpuCollectivePermuteCombineThresholdBytes
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuCollectivePermuteDecomposerThreshold() int64 {
	if x != nil && x.XlaGpuCollectivePermuteDecomposerThreshold != nil {
		return *x.XlaGpuCollectivePermuteDecomposerThreshold
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuCollectivesUsePersistentCliques() bool {
	if x != nil && x.XlaGpuCollectivesUsePersistentCliques != nil {
		return *x.XlaGpuCollectivesUsePersistentCliques
	}
	return false
}

func (x *DebugOptions) GetXlaGpuCommandBufferSchedulingMode() DebugOptions_CommandBufferSchedulingMode {
	if x != nil && x.XlaGpuCommandBufferSchedulingMode != nil {
		return *x.XlaGpuCommandBufferSchedulingMode
	}
	return DebugOptions_SERIALIZE
}

func (x *DebugOptions) GetXlaGpuCommandBufferUnrollLoops() bool {
	if x != nil && x.XlaGpuCommandBufferUnrollLoops != nil {
		return *x.XlaGpuCommandBufferUnrollLoops
	}
	return false
}

func (x *DebugOptions) GetXlaGpuCopyInsertionUseRegionAnalysis() bool {
	if x != nil && x.XlaGpuCopyInsertionUseRegionAnalysis != nil {
		return *x.XlaGpuCopyInsertionUseRegionAnalysis
	}
	return false
}

func (x *DebugOptions) GetXlaGpuCrashOnVerificationFailures() bool {
	if x != nil && x.XlaGpuCrashOnVerificationFailures != nil {
		return *x.XlaGpuCrashOnVerificationFailures
	}
	return false
}

func (x *DebugOptions) GetXlaGpuCublasFallback() bool {
	if x != nil && x.XlaGpuCublasFallback != nil {
		return *x.XlaGpuCublasFallback
	}
	return false
}

func (x *DebugOptions) GetXlaGpuCudaDataDir() string {
	if x != nil && x.XlaGpuCudaDataDir != nil {
		return *x.XlaGpuCudaDataDir
	}
	return ""
}

func (x *DebugOptions) GetXlaGpuCudnnGemmFusionLevel() int32 {
	if x != nil && x.XlaGpuCudnnGemmFusionLevel != nil {
		return *x.XlaGpuCudnnGemmFusionLevel
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuCudnnGemmMaxPlans() int32 {
	if x != nil && x.XlaGpuCudnnGemmMaxPlans != nil {
		return *x.XlaGpuCudnnGemmMaxPlans
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuDeterministicOps() bool {
	if x != nil && x.XlaGpuDeterministicOps != nil {
		return *x.XlaGpuDeterministicOps
	}
	return false
}

func (x *DebugOptions) GetXlaGpuDisableAsyncCollectives() []DebugOptions_CollectiveOpType {
	if x != nil {
		return x.XlaGpuDisableAsyncCollectives
	}
	return nil
}

func (x *DebugOptions) GetXlaGpuDisableGpuasmOptimizations() bool {
	if x != nil && x.XlaGpuDisableGpuasmOptimizations != nil {
		return *x.XlaGpuDisableGpuasmOptimizations
	}
	return false
}

func (x *DebugOptions) GetXlaGpuDotMergerThresholdMb() int32 {
	if x != nil && x.XlaGpuDotMergerThresholdMb != nil {
		return *x.XlaGpuDotMergerThresholdMb
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuDumpAutotuneLogsTo() string {
	if x != nil && x.XlaGpuDumpAutotuneLogsTo != nil {
		return *x.XlaGpuDumpAutotuneLogsTo
	}
	return ""
}

func (x *DebugOptions) GetXlaGpuDumpAutotuneResultsTo() string {
	if x != nil && x.XlaGpuDumpAutotuneResultsTo != nil {
		return *x.XlaGpuDumpAutotuneResultsTo
	}
	return ""
}

func (x *DebugOptions) GetXlaGpuDumpAutotunedGemmFusions() bool {
	if x != nil && x.XlaGpuDumpAutotunedGemmFusions != nil {
		return *x.XlaGpuDumpAutotunedGemmFusions
	}
	return false
}

func (x *DebugOptions) GetXlaGpuDumpLlvmir() bool {
	if x != nil && x.XlaGpuDumpLlvmir != nil {
		return *x.XlaGpuDumpLlvmir
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableAllGatherCombineByDim() bool {
	if x != nil && x.XlaGpuEnableAllGatherCombineByDim != nil {
		return *x.XlaGpuEnableAllGatherCombineByDim
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableAnalyticalLatencyEstimator() bool {
	if x != nil && x.XlaGpuEnableAnalyticalLatencyEstimator != nil {
		return *x.XlaGpuEnableAnalyticalLatencyEstimator
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableAnalyticalSolLatencyEstimator() bool {
	if x != nil && x.XlaGpuEnableAnalyticalSolLatencyEstimator != nil {
		return *x.XlaGpuEnableAnalyticalSolLatencyEstimator
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableApproxCostlyCollectives() bool {
	if x != nil && x.XlaGpuEnableApproxCostlyCollectives != nil {
		return *x.XlaGpuEnableApproxCostlyCollectives
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableCommandBuffer() []DebugOptions_CommandBufferCmdType {
	if x != nil {
		return x.XlaGpuEnableCommandBuffer
	}
	return nil
}

func (x *DebugOptions) GetXlaGpuEnableCubRadixSort() bool {
	if x != nil && x.XlaGpuEnableCubRadixSort != nil {
		return *x.XlaGpuEnableCubRadixSort
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableCublaslt() bool {
	if x != nil && x.XlaGpuEnableCublaslt != nil {
		return *x.XlaGpuEnableCublaslt
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableCudnnInt8X32ConvolutionReordering() bool {
	if x != nil && x.XlaGpuEnableCudnnInt8X32ConvolutionReordering != nil {
		return *x.XlaGpuEnableCudnnInt8X32ConvolutionReordering
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableCudnnLayerNorm() bool {
	if x != nil && x.XlaGpuEnableCudnnLayerNorm != nil {
		return *x.XlaGpuEnableCudnnLayerNorm
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableDynamicSliceFusion() bool {
	if x != nil && x.XlaGpuEnableDynamicSliceFusion != nil {
		return *x.XlaGpuEnableDynamicSliceFusion
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableFastMinMax() bool {
	if x != nil && x.XlaGpuEnableFastMinMax != nil {
		return *x.XlaGpuEnableFastMinMax
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableHighestPriorityAsyncStream() bool {
	if x != nil && x.XlaGpuEnableHighestPriorityAsyncStream != nil {
		return *x.XlaGpuEnableHighestPriorityAsyncStream
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableHostMemoryOffloading() bool {
	if x != nil && x.XlaGpuEnableHostMemoryOffloading != nil {
		return *x.XlaGpuEnableHostMemoryOffloading
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableLatencyHidingScheduler() bool {
	if x != nil && x.XlaGpuEnableLatencyHidingScheduler != nil {
		return *x.XlaGpuEnableLatencyHidingScheduler
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableLibnvptxcompiler() bool {
	if x != nil && x.XlaGpuEnableLibnvptxcompiler != nil {
		return *x.XlaGpuEnableLibnvptxcompiler
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableLlvmModuleCompilationParallelism() bool {
	if x != nil && x.XlaGpuEnableLlvmModuleCompilationParallelism != nil {
		return *x.XlaGpuEnableLlvmModuleCompilationParallelism
	}
	return false
}

// Deprecated: Marked as deprecated in xla/xla.proto.
func (x *DebugOptions) GetXlaGpuEnableNcclCliqueOptimization() bool {
	if x != nil && x.XlaGpuEnableNcclCliqueOptimization != nil {
		return *x.XlaGpuEnableNcclCliqueOptimization
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableNcclCommSplitting() bool {
	if x != nil && x.XlaGpuEnableNcclCommSplitting != nil {
		return *x.XlaGpuEnableNcclCommSplitting
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableNcclUserBuffers() bool {
	if x != nil && x.XlaGpuEnableNcclUserBuffers != nil {
		return *x.XlaGpuEnableNcclUserBuffers
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnablePipelinedAllGather() bool {
	if x != nil && x.XlaGpuEnablePipelinedAllGather != nil {
		return *x.XlaGpuEnablePipelinedAllGather
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnablePipelinedAllReduce() bool {
	if x != nil && x.XlaGpuEnablePipelinedAllReduce != nil {
		return *x.XlaGpuEnablePipelinedAllReduce
	}
	return false
}

// Deprecated: Marked as deprecated in xla/xla.proto.
func (x *DebugOptions) GetXlaGpuEnablePipelinedCollectives() bool {
	if x != nil && x.XlaGpuEnablePipelinedCollectives != nil {
		return *x.XlaGpuEnablePipelinedCollectives
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnablePipelinedP2P() bool {
	if x != nil && x.XlaGpuEnablePipelinedP2P != nil {
		return *x.XlaGpuEnablePipelinedP2P
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnablePipelinedReduceScatter() bool {
	if x != nil && x.XlaGpuEnablePipelinedReduceScatter != nil {
		return *x.XlaGpuEnablePipelinedReduceScatter
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableReassociationForConvertedAr() bool {
	if x != nil && x.XlaGpuEnableReassociationForConvertedAr != nil {
		return *x.XlaGpuEnableReassociationForConvertedAr
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableReduceScatterCombineByDim() bool {
	if x != nil && x.XlaGpuEnableReduceScatterCombineByDim != nil {
		return *x.XlaGpuEnableReduceScatterCombineByDim
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableReductionEpilogueFusion() bool {
	if x != nil && x.XlaGpuEnableReductionEpilogueFusion != nil {
		return *x.XlaGpuEnableReductionEpilogueFusion
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableScatterDeterminismExpander() bool {
	if x != nil && x.XlaGpuEnableScatterDeterminismExpander != nil {
		return *x.XlaGpuEnableScatterDeterminismExpander
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableSharedConstants() bool {
	if x != nil && x.XlaGpuEnableSharedConstants != nil {
		return *x.XlaGpuEnableSharedConstants
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableSplitKAutotuning() bool {
	if x != nil && x.XlaGpuEnableSplitKAutotuning != nil {
		return *x.XlaGpuEnableSplitKAutotuning
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableTritonGemm() bool {
	if x != nil && x.XlaGpuEnableTritonGemm != nil {
		return *x.XlaGpuEnableTritonGemm
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableWhileLoopDoubleBuffering() bool {
	if x != nil && x.XlaGpuEnableWhileLoopDoubleBuffering != nil {
		return *x.XlaGpuEnableWhileLoopDoubleBuffering
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableWhileLoopReduceScatterCodeMotion() bool {
	if x != nil && x.XlaGpuEnableWhileLoopReduceScatterCodeMotion != nil {
		return *x.XlaGpuEnableWhileLoopReduceScatterCodeMotion
	}
	return false
}

func (x *DebugOptions) GetXlaGpuEnableWhileLoopUnrolling() DebugOptions_WhileLoopUnrolling {
	if x != nil && x.XlaGpuEnableWhileLoopUnrolling != nil {
		return *x.XlaGpuEnableWhileLoopUnrolling
	}
	return DebugOptions_WHILE_LOOP_UNROLLING_NO_UNROLL
}

func (x *DebugOptions) GetXlaGpuExcludeNondeterministicOps() bool {
	if x != nil && x.XlaGpuExcludeNondeterministicOps != nil {
		return *x.XlaGpuExcludeNondeterministicOps
	}
	return false
}

func (x *DebugOptions) GetXlaGpuExecutableTerminateTimeoutSeconds() int32 {
	if x != nil && x.XlaGpuExecutableTerminateTimeoutSeconds != nil {
		return *x.XlaGpuExecutableTerminateTimeoutSeconds
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuExecutableWarnStuckTimeoutSeconds() int32 {
	if x != nil && x.XlaGpuExecutableWarnStuckTimeoutSeconds != nil {
		return *x.XlaGpuExecutableWarnStuckTimeoutSeconds
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuExhaustiveTilingSearch() bool {
	if x != nil && x.XlaGpuExhaustiveTilingSearch != nil {
		return *x.XlaGpuExhaustiveTilingSearch
	}
	return false
}

func (x *DebugOptions) GetXlaGpuExperimentalAutotuneCacheMode() DebugOptions_AutotuneCacheMode {
	if x != nil && x.XlaGpuExperimentalAutotuneCacheMode != nil {
		return *x.XlaGpuExperimentalAutotuneCacheMode
	}
	return DebugOptions_AUTOTUNE_CACHE_MODE_UNSPECIFIED
}

func (x *DebugOptions) GetXlaGpuExperimentalAutotunerCacheDir() string {
	if x != nil && x.XlaGpuExperimentalAutotunerCacheDir != nil {
		return *x.XlaGpuExperimentalAutotunerCacheDir
	}
	return ""
}

func (x *DebugOptions) GetXlaGpuExperimentalCollectiveCseDistanceThreshold() int64 {
	if x != nil && x.XlaGpuExperimentalCollectiveCseDistanceThreshold != nil {
		return *x.XlaGpuExperimentalCollectiveCseDistanceThreshold
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuExperimentalCollectivePerfTablePath() string {
	if x != nil && x.XlaGpuExperimentalCollectivePerfTablePath != nil {
		return *x.XlaGpuExperimentalCollectivePerfTablePath
	}
	return ""
}

func (x *DebugOptions) GetXlaGpuExperimentalDisableBinaryLibraries() bool {
	if x != nil && x.XlaGpuExperimentalDisableBinaryLibraries != nil {
		return *x.XlaGpuExperimentalDisableBinaryLibraries
	}
	return false
}

func (x *DebugOptions) GetXlaGpuExperimentalDumpFdoProfiles() bool {
	if x != nil && x.XlaGpuExperimentalDumpFdoProfiles != nil {
		return *x.XlaGpuExperimentalDumpFdoProfiles
	}
	return false
}

func (x *DebugOptions) GetXlaGpuExperimentalEnableAlltoallWindowedEinsum() bool {
	if x != nil && x.XlaGpuExperimentalEnableAlltoallWindowedEinsum != nil {
		return *x.XlaGpuExperimentalEnableAlltoallWindowedEinsum
	}
	return false
}

func (x *DebugOptions) GetXlaGpuExperimentalEnableCommandBufferOnThunks() bool {
	if x != nil && x.XlaGpuExperimentalEnableCommandBufferOnThunks != nil {
		return *x.XlaGpuExperimentalEnableCommandBufferOnThunks
	}
	return false
}

func (x *DebugOptions) GetXlaGpuExperimentalEnableFusionAutotuner() bool {
	if x != nil && x.XlaGpuExperimentalEnableFusionAutotuner != nil {
		return *x.XlaGpuExperimentalEnableFusionAutotuner
	}
	return false
}

func (x *DebugOptions) GetXlaGpuExperimentalEnableFusionBlockLevelRewriter() bool {
	if x != nil && x.XlaGpuExperimentalEnableFusionBlockLevelRewriter != nil {
		return *x.XlaGpuExperimentalEnableFusionBlockLevelRewriter
	}
	return false
}

func (x *DebugOptions) GetXlaGpuExperimentalEnableHeuristicCollectiveCombining() bool {
	if x != nil && x.XlaGpuExperimentalEnableHeuristicCollectiveCombining != nil {
		return *x.XlaGpuExperimentalEnableHeuristicCollectiveCombining
	}
	return false
}

func (x *DebugOptions) GetXlaGpuExperimentalEnableNcclSymmetricBuffers() bool {
	if x != nil && x.XlaGpuExperimentalEnableNcclSymmetricBuffers != nil {
		return *x.XlaGpuExperimentalEnableNcclSymmetricBuffers
	}
	return false
}

func (x *DebugOptions) GetXlaGpuExperimentalEnableNvshmem() bool {
	if x != nil && x.XlaGpuExperimentalEnableNvshmem != nil {
		return *x.XlaGpuExperimentalEnableNvshmem
	}
	return false
}

func (x *DebugOptions) GetXlaGpuExperimentalEnableSplitKRewrite() bool {
	if x != nil && x.XlaGpuExperimentalEnableSplitKRewrite != nil {
		return *x.XlaGpuExperimentalEnableSplitKRewrite
	}
	return false
}

func (x *DebugOptions) GetXlaGpuExperimentalEnableSubchannelDequantisationFusion() bool {
	if x != nil && x.XlaGpuExperimentalEnableSubchannelDequantisationFusion != nil {
		return *x.XlaGpuExperimentalEnableSubchannelDequantisationFusion
	}
	return false
}

func (x *DebugOptions) GetXlaGpuExperimentalEnableTritonHerolessPriorityFusion() bool {
	if x != nil && x.XlaGpuExperimentalEnableTritonHerolessPriorityFusion != nil {
		return *x.XlaGpuExperimentalEnableTritonHerolessPriorityFusion
	}
	return false
}

func (x *DebugOptions) GetXlaGpuExperimentalEnableTritonTma() bool {
	if x != nil && x.XlaGpuExperimentalEnableTritonTma != nil {
		return *x.XlaGpuExperimentalEnableTritonTma
	}
	return false
}

func (x *DebugOptions) GetXlaGpuExperimentalPackDotOperandsAlongKDimension() bool {
	if x != nil && x.XlaGpuExperimentalPackDotOperandsAlongKDimension != nil {
		return *x.XlaGpuExperimentalPackDotOperandsAlongKDimension
	}
	return false
}

func (x *DebugOptions) GetXlaGpuExperimentalParallelCollectiveOverlapLimit() int32 {
	if x != nil && x.XlaGpuExperimentalParallelCollectiveOverlapLimit != nil {
		return *x.XlaGpuExperimentalParallelCollectiveOverlapLimit
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuExperimentalPipelineParallelismOptLevel() DebugOptions_PipelineParallelismOptLevel {
	if x != nil && x.XlaGpuExperimentalPipelineParallelismOptLevel != nil {
		return *x.XlaGpuExperimentalPipelineParallelismOptLevel
	}
	return DebugOptions_PIPELINE_PARALLELISM_OPT_LEVEL_DISABLE
}

func (x *DebugOptions) GetXlaGpuExperimentalStreamAnnotation() bool {
	if x != nil && x.XlaGpuExperimentalStreamAnnotation != nil {
		return *x.XlaGpuExperimentalStreamAnnotation
	}
	return false
}

func (x *DebugOptions) GetXlaGpuExperimentalUseAutotunerPass() bool {
	if x != nil && x.XlaGpuExperimentalUseAutotunerPass != nil {
		return *x.XlaGpuExperimentalUseAutotunerPass
	}
	return false
}

func (x *DebugOptions) GetXlaGpuExperimentalUseRaggedDotFusion() bool {
	if x != nil && x.XlaGpuExperimentalUseRaggedDotFusion != nil {
		return *x.XlaGpuExperimentalUseRaggedDotFusion
	}
	return false
}

func (x *DebugOptions) GetXlaGpuFailPtxCompilationOnRegisterSpilling() bool {
	if x != nil && x.XlaGpuFailPtxCompilationOnRegisterSpilling != nil {
		return *x.XlaGpuFailPtxCompilationOnRegisterSpilling
	}
	return false
}

func (x *DebugOptions) GetXlaGpuFilterKernelsSpillingRegistersOnAutotuning() bool {
	if x != nil && x.XlaGpuFilterKernelsSpillingRegistersOnAutotuning != nil {
		return *x.XlaGpuFilterKernelsSpillingRegistersOnAutotuning
	}
	return false
}

func (x *DebugOptions) GetXlaGpuFirstCollectiveCallTerminateTimeoutSeconds() int32 {
	if x != nil && x.XlaGpuFirstCollectiveCallTerminateTimeoutSeconds != nil {
		return *x.XlaGpuFirstCollectiveCallTerminateTimeoutSeconds
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuFirstCollectiveCallWarnStuckTimeoutSeconds() int32 {
	if x != nil && x.XlaGpuFirstCollectiveCallWarnStuckTimeoutSeconds != nil {
		return *x.XlaGpuFirstCollectiveCallWarnStuckTimeoutSeconds
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuForceCompilationParallelism() int32 {
	if x != nil && x.XlaGpuForceCompilationParallelism != nil {
		return *x.XlaGpuForceCompilationParallelism
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuForceConvNchw() bool {
	if x != nil && x.XlaGpuForceConvNchw != nil {
		return *x.XlaGpuForceConvNchw
	}
	return false
}

func (x *DebugOptions) GetXlaGpuForceConvNhwc() bool {
	if x != nil && x.XlaGpuForceConvNhwc != nil {
		return *x.XlaGpuForceConvNhwc
	}
	return false
}

func (x *DebugOptions) GetXlaGpuFtz() bool {
	if x != nil && x.XlaGpuFtz != nil {
		return *x.XlaGpuFtz
	}
	return false
}

func (x *DebugOptions) GetXlaGpuFusedAttentionUseCudnnRng() bool {
	if x != nil && x.XlaGpuFusedAttentionUseCudnnRng != nil {
		return *x.XlaGpuFusedAttentionUseCudnnRng
	}
	return false
}

func (x *DebugOptions) GetXlaGpuGemmRewriteSizeThreshold() int64 {
	if x != nil && x.XlaGpuGemmRewriteSizeThreshold != nil {
		return *x.XlaGpuGemmRewriteSizeThreshold
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuGenerateDebugInfo() bool {
	if x != nil && x.XlaGpuGenerateDebugInfo != nil {
		return *x.XlaGpuGenerateDebugInfo
	}
	return false
}

func (x *DebugOptions) GetXlaGpuGenerateLineInfo() bool {
	if x != nil && x.XlaGpuGenerateLineInfo != nil {
		return *x.XlaGpuGenerateLineInfo
	}
	return false
}

// Deprecated: Marked as deprecated in xla/xla.proto.
func (x *DebugOptions) GetXlaGpuGraphEnableConcurrentRegion() bool {
	if x != nil && x.XlaGpuGraphEnableConcurrentRegion != nil {
		return *x.XlaGpuGraphEnableConcurrentRegion
	}
	return false
}

func (x *DebugOptions) GetXlaGpuGraphMinGraphSize() int32 {
	if x != nil && x.XlaGpuGraphMinGraphSize != nil {
		return *x.XlaGpuGraphMinGraphSize
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuKernelCacheFile() string {
	if x != nil && x.XlaGpuKernelCacheFile != nil {
		return *x.XlaGpuKernelCacheFile
	}
	return ""
}

func (x *DebugOptions) GetXlaGpuLibnvjitlinkMode() DebugOptions_LibNvJitLinkMode {
	if x != nil && x.XlaGpuLibnvjitlinkMode != nil {
		return *x.XlaGpuLibnvjitlinkMode
	}
	return DebugOptions_LIB_NV_JIT_LINK_MODE_AUTO
}

func (x *DebugOptions) GetXlaGpuLlvmIrFile() []string {
	if x != nil {
		return x.XlaGpuLlvmIrFile
	}
	return nil
}

func (x *DebugOptions) GetXlaGpuLlvmVerificationLevel() int32 {
	if x != nil && x.XlaGpuLlvmVerificationLevel != nil {
		return *x.XlaGpuLlvmVerificationLevel
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuLoadAutotuneResultsFrom() string {
	if x != nil && x.XlaGpuLoadAutotuneResultsFrom != nil {
		return *x.XlaGpuLoadAutotuneResultsFrom
	}
	return ""
}

func (x *DebugOptions) GetXlaGpuMemoryLimitSlopFactor() int32 {
	if x != nil && x.XlaGpuMemoryLimitSlopFactor != nil {
		return *x.XlaGpuMemoryLimitSlopFactor
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuMockCustomCalls() bool {
	if x != nil && x.XlaGpuMockCustomCalls != nil {
		return *x.XlaGpuMockCustomCalls
	}
	return false
}

func (x *DebugOptions) GetXlaGpuMultiStreamedWindowedEinsum() bool {
	if x != nil && x.XlaGpuMultiStreamedWindowedEinsum != nil {
		return *x.XlaGpuMultiStreamedWindowedEinsum
	}
	return false
}

func (x *DebugOptions) GetXlaGpuNcclAsyncExecution() bool {
	if x != nil && x.XlaGpuNcclAsyncExecution != nil {
		return *x.XlaGpuNcclAsyncExecution
	}
	return false
}

func (x *DebugOptions) GetXlaGpuNcclBlockingCommunicators() bool {
	if x != nil && x.XlaGpuNcclBlockingCommunicators != nil {
		return *x.XlaGpuNcclBlockingCommunicators
	}
	return false
}

func (x *DebugOptions) GetXlaGpuNcclCollectiveMaxNchannels() int64 {
	if x != nil && x.XlaGpuNcclCollectiveMaxNchannels != nil {
		return *x.XlaGpuNcclCollectiveMaxNchannels
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuNcclInitMaxRankPerRootRatio() int64 {
	if x != nil && x.XlaGpuNcclInitMaxRankPerRootRatio != nil {
		return *x.XlaGpuNcclInitMaxRankPerRootRatio
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuNcclP2PMaxNchannels() int64 {
	if x != nil && x.XlaGpuNcclP2PMaxNchannels != nil {
		return *x.XlaGpuNcclP2PMaxNchannels
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuNcclTerminateOnError() bool {
	if x != nil && x.XlaGpuNcclTerminateOnError != nil {
		return *x.XlaGpuNcclTerminateOnError
	}
	return false
}

func (x *DebugOptions) GetXlaGpuNcclTerminationTimeoutSeconds() int64 {
	if x != nil && x.XlaGpuNcclTerminationTimeoutSeconds != nil {
		return *x.XlaGpuNcclTerminationTimeoutSeconds
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuOperandBytesThresholdForWindowedEinsum() int64 {
	if x != nil && x.XlaGpuOperandBytesThresholdForWindowedEinsum != nil {
		return *x.XlaGpuOperandBytesThresholdForWindowedEinsum
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuOverrideGemmAutotuner() string {
	if x != nil && x.XlaGpuOverrideGemmAutotuner != nil {
		return *x.XlaGpuOverrideGemmAutotuner
	}
	return ""
}

func (x *DebugOptions) GetXlaGpuPerFusionAutotuneCacheDir() string {
	if x != nil && x.XlaGpuPerFusionAutotuneCacheDir != nil {
		return *x.XlaGpuPerFusionAutotuneCacheDir
	}
	return ""
}

func (x *DebugOptions) GetXlaGpuPgleAccuracyChecker() DebugOptions_PGLEStrictnessLevel {
	if x != nil && x.XlaGpuPgleAccuracyChecker != nil {
		return *x.XlaGpuPgleAccuracyChecker
	}
	return DebugOptions_PGLE_STRICTNESS_LEVEL_OFF
}

func (x *DebugOptions) GetXlaGpuPgleProfileFileOrDirectoryPath() string {
	if x != nil && x.XlaGpuPgleProfileFileOrDirectoryPath != nil {
		return *x.XlaGpuPgleProfileFileOrDirectoryPath
	}
	return ""
}

func (x *DebugOptions) GetXlaGpuPtxFile() []string {
	if x != nil {
		return x.XlaGpuPtxFile
	}
	return nil
}

func (x *DebugOptions) GetXlaGpuReduceScatterCombineThresholdBytes() int64 {
	if x != nil && x.XlaGpuReduceScatterCombineThresholdBytes != nil {
		return *x.XlaGpuReduceScatterCombineThresholdBytes
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuRedzonePaddingBytes() int64 {
	if x != nil && x.XlaGpuRedzonePaddingBytes != nil {
		return *x.XlaGpuRedzonePaddingBytes
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuRequireCompleteAotAutotuneResults() bool {
	if x != nil && x.XlaGpuRequireCompleteAotAutotuneResults != nil {
		return *x.XlaGpuRequireCompleteAotAutotuneResults
	}
	return false
}

func (x *DebugOptions) GetXlaGpuRequireExclusiveLock() bool {
	if x != nil && x.XlaGpuRequireExclusiveLock != nil {
		return *x.XlaGpuRequireExclusiveLock
	}
	return false
}

func (x *DebugOptions) GetXlaGpuShapeChecks() DebugOptions_ShapeChecks {
	if x != nil && x.XlaGpuShapeChecks != nil {
		return *x.XlaGpuShapeChecks
	}
	return DebugOptions_IGNORE
}

func (x *DebugOptions) GetXlaGpuShardAutotuning() bool {
	if x != nil && x.XlaGpuShardAutotuning != nil {
		return *x.XlaGpuShardAutotuning
	}
	return false
}

func (x *DebugOptions) GetXlaGpuStrictConvAlgorithmPicker() bool {
	if x != nil && x.XlaGpuStrictConvAlgorithmPicker != nil {
		return *x.XlaGpuStrictConvAlgorithmPicker
	}
	return false
}

func (x *DebugOptions) GetXlaGpuTargetConfigFilename() string {
	if x != nil && x.XlaGpuTargetConfigFilename != nil {
		return *x.XlaGpuTargetConfigFilename
	}
	return ""
}

func (x *DebugOptions) GetXlaGpuTempBufferUseSeparateColor() bool {
	if x != nil && x.XlaGpuTempBufferUseSeparateColor != nil {
		return *x.XlaGpuTempBufferUseSeparateColor
	}
	return false
}

func (x *DebugOptions) GetXlaGpuThresholdForWindowedEinsumMib() int64 {
	if x != nil && x.XlaGpuThresholdForWindowedEinsumMib != nil {
		return *x.XlaGpuThresholdForWindowedEinsumMib
	}
	return 0
}

func (x *DebugOptions) GetXlaGpuTritonGemmAny() bool {
	if x != nil && x.XlaGpuTritonGemmAny != nil {
		return *x.XlaGpuTritonGemmAny
	}
	return false
}

func (x *DebugOptions) GetXlaGpuUnsafeFallbackToDriverOnPtxasNotFound() bool {
	if x != nil && x.XlaGpuUnsafeFallbackToDriverOnPtxasNotFound != nil {
		return *x.XlaGpuUnsafeFallbackToDriverOnPtxasNotFound
	}
	return false
}

func (x *DebugOptions) GetXlaGpuUnsupportedAnnotateWithEmitterLoc() bool {
	if x != nil && x.XlaGpuUnsupportedAnnotateWithEmitterLoc != nil {
		return *x.XlaGpuUnsupportedAnnotateWithEmitterLoc
	}
	return false
}

func (x *DebugOptions) GetXlaGpuUnsupportedEnableAllReduceDecomposer() bool {
	if x != nil && x.XlaGpuUnsupportedEnableAllReduceDecomposer != nil {
		return *x.XlaGpuUnsupportedEnableAllReduceDecomposer
	}
	return false
}

func (x *DebugOptions) GetXlaGpuUnsupportedEnableRaggedAllToAllDecomposer() bool {
	if x != nil && x.XlaGpuUnsupportedEnableRaggedAllToAllDecomposer != nil {
		return *x.XlaGpuUnsupportedEnableRaggedAllToAllDecomposer
	}
	return false
}

func (x *DebugOptions) GetXlaGpuUnsupportedEnableTritonGemm() bool {
	if x != nil && x.XlaGpuUnsupportedEnableTritonGemm != nil {
		return *x.XlaGpuUnsupportedEnableTritonGemm
	}
	return false
}

func (x *DebugOptions) GetXlaGpuUnsupportedEnableTritonMultiOutputFusion() bool {
	if x != nil && x.XlaGpuUnsupportedEnableTritonMultiOutputFusion != nil {
		return *x.XlaGpuUnsupportedEnableTritonMultiOutputFusion
	}
	return false
}

func (x *DebugOptions) GetXlaGpuUnsupportedGenericTritonEmitterFeatures() []DebugOptions_GenericTritonEmitterFeature {
	if x != nil {
		return x.XlaGpuUnsupportedGenericTritonEmitterFeatures
	}
	return nil
}

func (x *DebugOptions) GetXlaGpuUnsupportedUseAllReduceOneShotKernel() bool {
	if x != nil && x.XlaGpuUnsupportedUseAllReduceOneShotKernel != nil {
		return *x.XlaGpuUnsupportedUseAllReduceOneShotKernel
	}
	return false
}

func (x *DebugOptions) GetXlaGpuUnsupportedUseRaggedAllToAllOneShotKernel() bool {
	if x != nil && x.XlaGpuUnsupportedUseRaggedAllToAllOneShotKernel != nil {
		return *x.XlaGpuUnsupportedUseRaggedAllToAllOneShotKernel
	}
	return false
}

func (x *DebugOptions) GetXlaGpuUseInprocessLld() bool {
	if x != nil && x.XlaGpuUseInprocessLld != nil {
		return *x.XlaGpuUseInprocessLld
	}
	return false
}

func (x *DebugOptions) GetXlaGpuUseMemcpyLocalP2P() bool {
	if x != nil && x.XlaGpuUseMemcpyLocalP2P != nil {
		return *x.XlaGpuUseMemcpyLocalP2P
	}
	return false
}

func (x *DebugOptions) GetXlaGpuUseRuntimeFusion() bool {
	if x != nil && x.XlaGpuUseRuntimeFusion != nil {
		return *x.XlaGpuUseRuntimeFusion
	}
	return false
}

func (x *DebugOptions) GetXlaGpuVerifyTritonFusionNumerics() bool {
	if x != nil && x.XlaGpuVerifyTritonFusionNumerics != nil {
		return *x.XlaGpuVerifyTritonFusionNumerics
	}
	return false
}

func (x *DebugOptions) GetXlaHloGraphAddresses() bool {
	if x != nil && x.XlaHloGraphAddresses != nil {
		return *x.XlaHloGraphAddresses
	}
	return false
}

func (x *DebugOptions) GetXlaHloProfile() bool {
	if x != nil && x.XlaHloProfile != nil {
		return *x.XlaHloProfile
	}
	return false
}

func (x *DebugOptions) GetXlaDisableHloPasses() []string {
	if x != nil {
		return x.XlaDisableHloPasses
	}
	return nil
}

func (x *DebugOptions) GetXlaEnableHloPassesOnly() []string {
	if x != nil {
		return x.XlaEnableHloPassesOnly
	}
	return nil
}

func (x *DebugOptions) GetXlaDisableAllHloPasses() bool {
	if x != nil && x.XlaDisableAllHloPasses != nil {
		return *x.XlaDisableAllHloPasses
	}
	return false
}

func (x *DebugOptions) GetXlaBackendOptimizationLevel() int32 {
	if x != nil && x.XlaBackendOptimizationLevel != nil {
		return *x.XlaBackendOptimizationLevel
	}
	return 0
}

func (x *DebugOptions) GetXlaEmbedIrInExecutable() bool {
	if x != nil && x.XlaEmbedIrInExecutable != nil {
		return *x.XlaEmbedIrInExecutable
	}
	return false
}

func (x *DebugOptions) GetXlaEliminateHloImplicitBroadcast() bool {
	if x != nil && x.XlaEliminateHloImplicitBroadcast != nil {
		return *x.XlaEliminateHloImplicitBroadcast
	}
	return false
}

func (x *DebugOptions) GetXlaCpuMultiThreadEigen() bool {
	if x != nil && x.XlaCpuMultiThreadEigen != nil {
		return *x.XlaCpuMultiThreadEigen
	}
	return false
}

func (x *DebugOptions) GetXlaLlvmEnableAliasScopeMetadata() bool {
	if x != nil && x.XlaLlvmEnableAliasScopeMetadata != nil {
		return *x.XlaLlvmEnableAliasScopeMetadata
	}
	return false
}

func (x *DebugOptions) GetXlaLlvmEnableNoaliasMetadata() bool {
	if x != nil && x.XlaLlvmEnableNoaliasMetadata != nil {
		return *x.XlaLlvmEnableNoaliasMetadata
	}
	return false
}

func (x *DebugOptions) GetXlaLlvmEnableInvariantLoadMetadata() bool {
	if x != nil && x.XlaLlvmEnableInvariantLoadMetadata != nil {
		return *x.XlaLlvmEnableInvariantLoadMetadata
	}
	return false
}

func (x *DebugOptions) GetXlaLlvmDisableExpensivePasses() bool {
	if x != nil && x.XlaLlvmDisableExpensivePasses != nil {
		return *x.XlaLlvmDisableExpensivePasses
	}
	return false
}

func (x *DebugOptions) GetXlaTestAllOutputLayouts() bool {
	if x != nil && x.XlaTestAllOutputLayouts != nil {
		return *x.XlaTestAllOutputLayouts
	}
	return false
}

func (x *DebugOptions) GetXlaTestAllInputLayouts() bool {
	if x != nil && x.XlaTestAllInputLayouts != nil {
		return *x.XlaTestAllInputLayouts
	}
	return false
}

func (x *DebugOptions) GetXlaHloGraphShardingColor() bool {
	if x != nil && x.XlaHloGraphShardingColor != nil {
		return *x.XlaHloGraphShardingColor
	}
	return false
}

func (x *DebugOptions) GetXlaCpuUseOnednn() bool {
	if x != nil && x.XlaCpuUseOnednn != nil {
		return *x.XlaCpuUseOnednn
	}
	return false
}

func (x *DebugOptions) GetXlaAllowExcessPrecision() bool {
	if x != nil && x.XlaAllowExcessPrecision != nil {
		return *x.XlaAllowExcessPrecision
	}
	return false
}

func (x *DebugOptions) GetXlaForceHostPlatformDeviceCount() int32 {
	if x != nil && x.XlaForceHostPlatformDeviceCount != nil {
		return *x.XlaForceHostPlatformDeviceCount
	}
	return 0
}

func (x *DebugOptions) GetXlaHloEvaluatorUseFastPath() bool {
	if x != nil && x.XlaHloEvaluatorUseFastPath != nil {
		return *x.XlaHloEvaluatorUseFastPath
	}
	return false
}

func (x *DebugOptions) GetXlaAllowScalarIndexDynamicOps() bool {
	if x != nil && x.XlaAllowScalarIndexDynamicOps != nil {
		return *x.XlaAllowScalarIndexDynamicOps
	}
	return false
}

func (x *DebugOptions) GetXlaStepMarkerLocation() DebugOptions_StepMarkerLocation {
	if x != nil && x.XlaStepMarkerLocation != nil {
		return *x.XlaStepMarkerLocation
	}
	return DebugOptions_STEP_MARK_AT_ENTRY
}

func (x *DebugOptions) GetXlaDumpTo() string {
	if x != nil && x.XlaDumpTo != nil {
		return *x.XlaDumpTo
	}
	return ""
}

func (x *DebugOptions) GetXlaFlagsReset() bool {
	if x != nil && x.XlaFlagsReset != nil {
		return *x.XlaFlagsReset
	}
	return false
}

func (x *DebugOptions) GetXlaDumpHloModuleRe() string {
	if x != nil && x.XlaDumpHloModuleRe != nil {
		return *x.XlaDumpHloModuleRe
	}
	return ""
}

func (x *DebugOptions) GetXlaDumpHloPassRe() string {
	if x != nil && x.XlaDumpHloPassRe != nil {
		return *x.XlaDumpHloPassRe
	}
	return ""
}

func (x *DebugOptions) GetXlaDumpHloAsText() bool {
	if x != nil && x.XlaDumpHloAsText != nil {
		return *x.XlaDumpHloAsText
	}
	return false
}

func (x *DebugOptions) GetXlaDumpHloAsProto() bool {
	if x != nil && x.XlaDumpHloAsProto != nil {
		return *x.XlaDumpHloAsProto
	}
	return false
}

func (x *DebugOptions) GetXlaDumpHloAsDot() bool {
	if x != nil && x.XlaDumpHloAsDot != nil {
		return *x.XlaDumpHloAsDot
	}
	return false
}

func (x *DebugOptions) GetXlaDumpHloAsUrl() bool {
	if x != nil && x.XlaDumpHloAsUrl != nil {
		return *x.XlaDumpHloAsUrl
	}
	return false
}

func (x *DebugOptions) GetXlaDumpHloAsHtml() bool {
	if x != nil && x.XlaDumpHloAsHtml != nil {
		return *x.XlaDumpHloAsHtml
	}
	return false
}

func (x *DebugOptions) GetXlaDumpFusionVisualization() bool {
	if x != nil && x.XlaDumpFusionVisualization != nil {
		return *x.XlaDumpFusionVisualization
	}
	return false
}

func (x *DebugOptions) GetXlaDumpHloSnapshots() bool {
	if x != nil && x.XlaDumpHloSnapshots != nil {
		return *x.XlaDumpHloSnapshots
	}
	return false
}

func (x *DebugOptions) GetXlaDumpIncludeTimestamp() bool {
	if x != nil && x.XlaDumpIncludeTimestamp != nil {
		return *x.XlaDumpIncludeTimestamp
	}
	return false
}

func (x *DebugOptions) GetXlaDumpMaxHloModules() int32 {
	if x != nil && x.XlaDumpMaxHloModules != nil {
		return *x.XlaDumpMaxHloModules
	}
	return 0
}

func (x *DebugOptions) GetXlaDumpModuleMetadata() bool {
	if x != nil && x.XlaDumpModuleMetadata != nil {
		return *x.XlaDumpModuleMetadata
	}
	return false
}

func (x *DebugOptions) GetXlaDumpCompressProtos() bool {
	if x != nil && x.XlaDumpCompressProtos != nil {
		return *x.XlaDumpCompressProtos
	}
	return false
}

func (x *DebugOptions) GetXlaDumpHloAsLongText() bool {
	if x != nil && x.XlaDumpHloAsLongText != nil {
		return *x.XlaDumpHloAsLongText
	}
	return false
}

func (x *DebugOptions) GetXlaDumpEnableMlirPrettyForm() bool {
	if x != nil && x.XlaDumpEnableMlirPrettyForm != nil {
		return *x.XlaDumpEnableMlirPrettyForm
	}
	return false
}

func (x *DebugOptions) GetXlaDumpFullHloConfig() bool {
	if x != nil && x.XlaDumpFullHloConfig != nil {
		return *x.XlaDumpFullHloConfig
	}
	return false
}

func (x *DebugOptions) GetXlaTpuDetectNan() bool {
	if x != nil && x.XlaTpuDetectNan != nil {
		return *x.XlaTpuDetectNan
	}
	return false
}

func (x *DebugOptions) GetXlaTpuDetectInf() bool {
	if x != nil && x.XlaTpuDetectInf != nil {
		return *x.XlaTpuDetectInf
	}
	return false
}

func (x *DebugOptions) GetXlaCpuEnableXprofTraceme() bool {
	if x != nil && x.XlaCpuEnableXprofTraceme != nil {
		return *x.XlaCpuEnableXprofTraceme
	}
	return false
}

func (x *DebugOptions) GetXlaMultiheapSizeConstraintPerHeap() int32 {
	if x != nil && x.XlaMultiheapSizeConstraintPerHeap != nil {
		return *x.XlaMultiheapSizeConstraintPerHeap
	}
	return 0
}

func (x *DebugOptions) GetXlaDetailedLogging() bool {
	if x != nil && x.XlaDetailedLogging != nil {
		return *x.XlaDetailedLogging
	}
	return false
}

func (x *DebugOptions) GetXlaEnableDumping() bool {
	if x != nil && x.XlaEnableDumping != nil {
		return *x.XlaEnableDumping
	}
	return false
}

func (x *DebugOptions) GetXlaLlvmForceInlineBeforeSplit() bool {
	if x != nil && x.XlaLlvmForceInlineBeforeSplit != nil {
		return *x.XlaLlvmForceInlineBeforeSplit
	}
	return false
}

func (x *DebugOptions) GetXlaDumpDisableMetadata() bool {
	if x != nil && x.XlaDumpDisableMetadata != nil {
		return *x.XlaDumpDisableMetadata
	}
	return false
}

func (x *DebugOptions) GetXlaDumpHloPipelineRe() string {
	if x != nil && x.XlaDumpHloPipelineRe != nil {
		return *x.XlaDumpHloPipelineRe
	}
	return ""
}

func (x *DebugOptions) GetXlaCpuUseAcl() bool {
	if x != nil && x.XlaCpuUseAcl != nil {
		return *x.XlaCpuUseAcl
	}
	return false
}

func (x *DebugOptions) GetXlaCpuStrictDotConvMath() bool {
	if x != nil && x.XlaCpuStrictDotConvMath != nil {
		return *x.XlaCpuStrictDotConvMath
	}
	return false
}

func (x *DebugOptions) GetXlaDumpLatencyHidingSchedule() bool {
	if x != nil && x.XlaDumpLatencyHidingSchedule != nil {
		return *x.XlaDumpLatencyHidingSchedule
	}
	return false
}

func (x *DebugOptions) GetXlaPartitioningAlgorithm() DebugOptions_PartitioningAlgorithm {
	if x != nil && x.XlaPartitioningAlgorithm != nil {
		return *x.XlaPartitioningAlgorithm
	}
	return DebugOptions_PARTITIONING_ALGORITHM_NOOP
}

func (x *DebugOptions) GetXlaDebugBufferAssignmentShowMax() int64 {
	if x != nil && x.XlaDebugBufferAssignmentShowMax != nil {
		return *x.XlaDebugBufferAssignmentShowMax
	}
	return 0
}

func (x *DebugOptions) GetXlaDetectUnstableReductions() DebugOptions_UnstableReductionDetectionMode {
	if x != nil && x.XlaDetectUnstableReductions != nil {
		return *x.XlaDetectUnstableReductions
	}
	return DebugOptions_UNSTABLE_REDUCTION_DETECTION_MODE_NONE
}

func (x *DebugOptions) GetXlaDumpLargeConstants() bool {
	if x != nil && x.XlaDumpLargeConstants != nil {
		return *x.XlaDumpLargeConstants
	}
	return false
}

func (x *DebugOptions) GetXlaReduceWindowRewriteBaseLength() int64 {
	if x != nil && x.XlaReduceWindowRewriteBaseLength != nil {
		return *x.XlaReduceWindowRewriteBaseLength
	}
	return 0
}

func (x *DebugOptions) GetXlaCmdBufferTraceCacheSize() int64 {
	if x != nil && x.XlaCmdBufferTraceCacheSize != nil {
		return *x.XlaCmdBufferTraceCacheSize
	}
	return 0
}

func (x *DebugOptions) GetLegacyCommandBufferCustomCallTargets() []string {
	if x != nil {
		return x.LegacyCommandBufferCustomCallTargets
	}
	return nil
}

func (x *DebugOptions) GetXlaSyntaxSugarAsyncOps() bool {
	if x != nil && x.XlaSyntaxSugarAsyncOps != nil {
		return *x.XlaSyntaxSugarAsyncOps
	}
	return false
}

func (x *DebugOptions) GetXlaEnableCommandBuffersDuringProfiling() bool {
	if x != nil && x.XlaEnableCommandBuffersDuringProfiling != nil {
		return *x.XlaEnableCommandBuffersDuringProfiling
	}
	return false
}

func (x *DebugOptions) GetXlaIgnoreChannelId() bool {
	if x != nil && x.XlaIgnoreChannelId != nil {
		return *x.XlaIgnoreChannelId
	}
	return false
}

func (x *DebugOptions) GetXlaPjrtAllowAutoLayoutInHlo() bool {
	if x != nil && x.XlaPjrtAllowAutoLayoutInHlo != nil {
		return *x.XlaPjrtAllowAutoLayoutInHlo
	}
	return false
}

func (x *DebugOptions) GetXlaTestAddCommandBufferMode() bool {
	if x != nil && x.XlaTestAddCommandBufferMode != nil {
		return *x.XlaTestAddCommandBufferMode
	}
	return false
}

func (x *DebugOptions) GetXlaGpuExperimentalMatmulPerfTablePath() string {
	if x != nil && x.XlaGpuExperimentalMatmulPerfTablePath != nil {
		return *x.XlaGpuExperimentalMatmulPerfTablePath
	}
	return ""
}

func (x *DebugOptions) GetXlaEarlyExitWithLayouts() bool {
	if x != nil && x.XlaEarlyExitWithLayouts != nil {
		return *x.XlaEarlyExitWithLayouts
	}
	return false
}

func (x *DebugOptions) GetXlaGpuExperimentalScaledDotWithTriton() bool {
	if x != nil && x.XlaGpuExperimentalScaledDotWithTriton != nil {
		return *x.XlaGpuExperimentalScaledDotWithTriton
	}
	return false
}

func (x *DebugOptions) GetXlaGpuExperimentalUseRaftSelectK() bool {
	if x != nil && x.XlaGpuExperimentalUseRaftSelectK != nil {
		return *x.XlaGpuExperimentalUseRaftSelectK
	}
	return false
}

func (x *DebugOptions) GetXlaBackendExtraOptions() map[string]string {
	if x != nil {
		return x.XlaBackendExtraOptions
	}
	return nil
}

// Contains flags which affects the GPU compilation result.
// These flags are part of Debug Options as of now, and will be migrated to
// this proto.
type GpuCompilationEnvironment struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Temporary dummy flag is added to test the flow.
	// To be removed when we add flags here.
	DummyFlag     int64 `protobuf:"varint,1,opt,name=dummy_flag,json=dummyFlag,proto3" json:"dummy_flag,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GpuCompilationEnvironment) Reset() {
	*x = GpuCompilationEnvironment{}
	mi := &file_xla_xla_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GpuCompilationEnvironment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GpuCompilationEnvironment) ProtoMessage() {}

func (x *GpuCompilationEnvironment) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GpuCompilationEnvironment.ProtoReflect.Descriptor instead.
func (*GpuCompilationEnvironment) Descriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{2}
}

func (x *GpuCompilationEnvironment) GetDummyFlag() int64 {
	if x != nil {
		return x.DummyFlag
	}
	return 0
}

type ShardableValueUpdatePairProto struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	InputParameterNumber int64                  `protobuf:"varint,1,opt,name=input_parameter_number,json=inputParameterNumber,proto3" json:"input_parameter_number,omitempty"`
	ParameterShapeIndex  []int64                `protobuf:"varint,2,rep,packed,name=parameter_shape_index,json=parameterShapeIndex,proto3" json:"parameter_shape_index,omitempty"`
	OutputShapeIndex     []int64                `protobuf:"varint,3,rep,packed,name=output_shape_index,json=outputShapeIndex,proto3" json:"output_shape_index,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ShardableValueUpdatePairProto) Reset() {
	*x = ShardableValueUpdatePairProto{}
	mi := &file_xla_xla_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ShardableValueUpdatePairProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShardableValueUpdatePairProto) ProtoMessage() {}

func (x *ShardableValueUpdatePairProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShardableValueUpdatePairProto.ProtoReflect.Descriptor instead.
func (*ShardableValueUpdatePairProto) Descriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{3}
}

func (x *ShardableValueUpdatePairProto) GetInputParameterNumber() int64 {
	if x != nil {
		return x.InputParameterNumber
	}
	return 0
}

func (x *ShardableValueUpdatePairProto) GetParameterShapeIndex() []int64 {
	if x != nil {
		return x.ParameterShapeIndex
	}
	return nil
}

func (x *ShardableValueUpdatePairProto) GetOutputShapeIndex() []int64 {
	if x != nil {
		return x.OutputShapeIndex
	}
	return nil
}

// These settings control how XLA compiles and/or runs code.  Not all settings
// will have an effect on every platform.
//
// When adding new fields, keep in mind that boolean fields default to false.
// Next id: 29.
type ExecutionOptions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// This optional field's layout is used as a hint when storing the output of
	// this computation.  Subsequent transfers of this output array to the client
	// may be faster when using this layout.
	//
	// We use a Shape here to accommodate computations that return a tuple.
	ShapeWithOutputLayout *xla_data.ShapeProto `protobuf:"bytes,2,opt,name=shape_with_output_layout,json=shapeWithOutputLayout,proto3" json:"shape_with_output_layout,omitempty"`
	// Used to seed random-number generators used in this computation.  If this is
	// 0, we generate a seed ourselves.
	//
	// Changing the seed unnecessarily forces a recompilation.
	Seed         uint64        `protobuf:"varint,3,opt,name=seed,proto3" json:"seed,omitempty"`
	DebugOptions *DebugOptions `protobuf:"bytes,4,opt,name=debug_options,json=debugOptions,proto3" json:"debug_options,omitempty"`
	// This optional field specifies a particular set of devices to run the
	// computation on. The computation will be partitioned across these devices.
	// If not provided, the default device will be chosen.
	DeviceHandles []*xla_data.DeviceHandle `protobuf:"bytes,5,rep,name=device_handles,json=deviceHandles,proto3" json:"device_handles,omitempty"`
	// Number of replicas of the computation to run. If zero, uses the default
	// number of replicas for the XLA service.
	NumReplicas int32 `protobuf:"varint,6,opt,name=num_replicas,json=numReplicas,proto3" json:"num_replicas,omitempty"`
	// This optional field specifies the device assignment if known at compile
	// time.
	DeviceAssignment *xla_data.DeviceAssignmentProto `protobuf:"bytes,7,opt,name=device_assignment,json=deviceAssignment,proto3" json:"device_assignment,omitempty"`
	// Alias input and output buffers for parameters that are passed-through XLA
	// modules without being changed.
	AliasPassthroughParams bool `protobuf:"varint,8,opt,name=alias_passthrough_params,json=aliasPassthroughParams,proto3" json:"alias_passthrough_params,omitempty"`
	// Number of partitions of the computation to run (model parallelism).
	// If zero, uses the default number of partitions for the XLA service.
	NumPartitions int32 `protobuf:"varint,9,opt,name=num_partitions,json=numPartitions,proto3" json:"num_partitions,omitempty"`
	// Used to identify a set of programs that should be launch together.
	LaunchId int32 `protobuf:"varint,10,opt,name=launch_id,json=launchId,proto3" json:"launch_id,omitempty"`
	// Indicates whether to use SPMD (true) or MPMD (false) partitioning when
	// num_partitions > 1 and XLA is requested to partition the input program.
	UseSpmdPartitioning bool `protobuf:"varint,11,opt,name=use_spmd_partitioning,json=useSpmdPartitioning,proto3" json:"use_spmd_partitioning,omitempty"`
	// Whether to automatically generate XLA shardings for SPMD partitioner.
	UseAutoSpmdPartitioning bool `protobuf:"varint,15,opt,name=use_auto_spmd_partitioning,json=useAutoSpmdPartitioning,proto3" json:"use_auto_spmd_partitioning,omitempty"`
	// Device mesh shape used to create the sharding search space when
	// use_auto_spmd_partitioning=true.
	AutoSpmdPartitioningMeshShape []int64 `protobuf:"varint,16,rep,packed,name=auto_spmd_partitioning_mesh_shape,json=autoSpmdPartitioningMeshShape,proto3" json:"auto_spmd_partitioning_mesh_shape,omitempty"`
	// Device mesh ids compatible with the above mesh_shape used when
	// use_auto_spmd_partitioning=true.
	AutoSpmdPartitioningMeshIds []int64 `protobuf:"varint,17,rep,packed,name=auto_spmd_partitioning_mesh_ids,json=autoSpmdPartitioningMeshIds,proto3" json:"auto_spmd_partitioning_mesh_ids,omitempty"`
	// The amount of effort to spend on optimizing for minimizing program
	// execution time, as a value in [-1.0, +1.0]. The baseline is 0.0, which
	// strongly prioritizes execution time at the cost of longer compile times,
	// suitable for production workloads. A value of -0.5 would be appropriate for
	// research use cases that prefer faster compilations to iterate more quickly.
	// Positive values, on the other hand, might enable costly optimizations that
	// are off by default.
	// DEPRECATED: Use optimization_level instead.
	//
	// Deprecated: Marked as deprecated in xla/xla.proto.
	ExecTimeOptimizationEffort float32 `protobuf:"fixed32,25,opt,name=exec_time_optimization_effort,json=execTimeOptimizationEffort,proto3" json:"exec_time_optimization_effort,omitempty"`
	// The amount of effort to spend on making the program fit in memory (where
	// "fit in memory" here has a backend-dependent meaning), as a value in
	// [-1.0,+1.0]. The baseline is 0.0, which expends significant effort on
	// attempting to make the program fit. A value of -1.0 would be appropriate
	// for use cases that wish to spend minimal effort here and fail as quickly as
	// possible instead. Positive values, on the other hand, might enable costly
	// algorithms to reduce memory usage that are off by default.
	// DEPRECATED: Use memory_fitting_level instead.
	//
	// Deprecated: Marked as deprecated in xla/xla.proto.
	MemoryFittingEffort float32 `protobuf:"fixed32,26,opt,name=memory_fitting_effort,json=memoryFittingEffort,proto3" json:"memory_fitting_effort,omitempty"`
	// The amount of effort to spend on optimizing for minimizing program
	// execution time. As a general guideline, O2 strongly prioritizes execution
	// time, and is typically suitable for production workloads. O3 may enable
	// costly or experimental optimizations that may greatly increase compile
	// time.
	OptimizationLevel ExecutionOptions_EffortLevel `protobuf:"varint,27,opt,name=optimization_level,json=optimizationLevel,proto3,enum=xla.ExecutionOptions_EffortLevel" json:"optimization_level,omitempty"`
	// The amount of effort to spend on making the program fit in memory (where
	// "fit in memory" here has a backend-dependent meaning). As a general
	// guideline, O2 will expend significant effort on attempting to make the
	// program fit. O0 will spend minimal effort and fail as quickly as possible
	// instead. O3 might enable costly algorithms to reduce memory usage that may
	// greatly increase compile time.
	MemoryFittingLevel ExecutionOptions_EffortLevel `protobuf:"varint,28,opt,name=memory_fitting_level,json=memoryFittingLevel,proto3,enum=xla.ExecutionOptions_EffortLevel" json:"memory_fitting_level,omitempty"`
	// If set, deduplicate hlo into function calls to reduce binary size. Only
	// works on TPU.
	DeduplicateHlo bool `protobuf:"varint,12,opt,name=deduplicate_hlo,json=deduplicateHlo,proto3" json:"deduplicate_hlo,omitempty"`
	// Allows sharding propagation to propagate to the parameters. This changes
	// the input shape of the computation (which is undesirable), but it can be
	// used to allow to run partial compilation to determine what would be the
	// input sharding of a computation if XLA would be allowed to propagate the
	// sharding which can be used by higher level framework as a way to query
	// intermediate sharding of operations when multiple computation would be
	// chained and merged together.
	// This is a vector of bool, because the user can control which parameters can
	// have the sharding substituted. If only one boolean value is passed in the
	// vector that is interpreted as the value to be applied for every parameter.
	AllowSpmdShardingPropagationToParameters []bool `protobuf:"varint,23,rep,packed,name=allow_spmd_sharding_propagation_to_parameters,json=allowSpmdShardingPropagationToParameters,proto3" json:"allow_spmd_sharding_propagation_to_parameters,omitempty"`
	// Allows sharding propagation to propagate to the outputs. This changes the
	// output shape of the computation (which is undesirable), but it can be used
	// to allow to run partial compilation to determine what would be the output
	// sharding of a computation if XLA would be allowed to propagate the sharding
	// which can be used by higher level framework as a way to query intermediate
	// sharding of operations when multiple computation would be chained and
	// merged together.
	// This is a vector of bool, because the user can control (if the output of
	// the computation is a tuple) which elements of the tuple can have the
	// sharding substituted and which don't. If only one boolean value is passed
	// in the vector that's interpreted as the value to be applied for every
	// single element of the output tuple. One value per element of the tuple
	// means that each value is attached to one of the output elements.
	AllowSpmdShardingPropagationToOutput []bool `protobuf:"varint,14,rep,packed,name=allow_spmd_sharding_propagation_to_output,json=allowSpmdShardingPropagationToOutput,proto3" json:"allow_spmd_sharding_propagation_to_output,omitempty"`
	// Whether to broadcast args across all replicas. One entry per arg.
	ParamRequiresBroadcastViaCollectives []bool `protobuf:"varint,18,rep,packed,name=param_requires_broadcast_via_collectives,json=paramRequiresBroadcastViaCollectives,proto3" json:"param_requires_broadcast_via_collectives,omitempty"`
	// If enabled, the compiler may generate sharding and unsharding programs as
	// separate HLO modules, and modify the main program's input and output to
	// be sharded.
	AllowSeparateShardingPrograms bool `protobuf:"varint,19,opt,name=allow_separate_sharding_programs,json=allowSeparateShardingPrograms,proto3" json:"allow_separate_sharding_programs,omitempty"`
	// The list of input/output pairs in the main program that could be sharded.
	ShardableValueUpdatePairs []*ShardableValueUpdatePairProto `protobuf:"bytes,20,rep,name=shardable_value_update_pairs,json=shardableValueUpdatePairs,proto3" json:"shardable_value_update_pairs,omitempty"`
	// Profiling data for feedback directed optimizations. Note that this is not
	// the only way to feed FDO data into the compiler and individual backends
	// may choose to get FDO data by other means.
	FdoProfile []byte `protobuf:"bytes,21,opt,name=fdo_profile,json=fdoProfile,proto3" json:"fdo_profile,omitempty"`
	// Amount of device memory available for the executable to use.
	DeviceMemorySize int64 `protobuf:"varint,22,opt,name=device_memory_size,json=deviceMemorySize,proto3" json:"device_memory_size,omitempty"`
	// Use Shardy, a new partitioner, to replace the existing
	// ShardingPropagation and SpmdPartitioner. See go/xla-sdy-pipeline for
	// details.
	UseShardyPartitioner bool `protobuf:"varint,24,opt,name=use_shardy_partitioner,json=useShardyPartitioner,proto3" json:"use_shardy_partitioner,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ExecutionOptions) Reset() {
	*x = ExecutionOptions{}
	mi := &file_xla_xla_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExecutionOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionOptions) ProtoMessage() {}

func (x *ExecutionOptions) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionOptions.ProtoReflect.Descriptor instead.
func (*ExecutionOptions) Descriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{4}
}

func (x *ExecutionOptions) GetShapeWithOutputLayout() *xla_data.ShapeProto {
	if x != nil {
		return x.ShapeWithOutputLayout
	}
	return nil
}

func (x *ExecutionOptions) GetSeed() uint64 {
	if x != nil {
		return x.Seed
	}
	return 0
}

func (x *ExecutionOptions) GetDebugOptions() *DebugOptions {
	if x != nil {
		return x.DebugOptions
	}
	return nil
}

func (x *ExecutionOptions) GetDeviceHandles() []*xla_data.DeviceHandle {
	if x != nil {
		return x.DeviceHandles
	}
	return nil
}

func (x *ExecutionOptions) GetNumReplicas() int32 {
	if x != nil {
		return x.NumReplicas
	}
	return 0
}

func (x *ExecutionOptions) GetDeviceAssignment() *xla_data.DeviceAssignmentProto {
	if x != nil {
		return x.DeviceAssignment
	}
	return nil
}

func (x *ExecutionOptions) GetAliasPassthroughParams() bool {
	if x != nil {
		return x.AliasPassthroughParams
	}
	return false
}

func (x *ExecutionOptions) GetNumPartitions() int32 {
	if x != nil {
		return x.NumPartitions
	}
	return 0
}

func (x *ExecutionOptions) GetLaunchId() int32 {
	if x != nil {
		return x.LaunchId
	}
	return 0
}

func (x *ExecutionOptions) GetUseSpmdPartitioning() bool {
	if x != nil {
		return x.UseSpmdPartitioning
	}
	return false
}

func (x *ExecutionOptions) GetUseAutoSpmdPartitioning() bool {
	if x != nil {
		return x.UseAutoSpmdPartitioning
	}
	return false
}

func (x *ExecutionOptions) GetAutoSpmdPartitioningMeshShape() []int64 {
	if x != nil {
		return x.AutoSpmdPartitioningMeshShape
	}
	return nil
}

func (x *ExecutionOptions) GetAutoSpmdPartitioningMeshIds() []int64 {
	if x != nil {
		return x.AutoSpmdPartitioningMeshIds
	}
	return nil
}

// Deprecated: Marked as deprecated in xla/xla.proto.
func (x *ExecutionOptions) GetExecTimeOptimizationEffort() float32 {
	if x != nil {
		return x.ExecTimeOptimizationEffort
	}
	return 0
}

// Deprecated: Marked as deprecated in xla/xla.proto.
func (x *ExecutionOptions) GetMemoryFittingEffort() float32 {
	if x != nil {
		return x.MemoryFittingEffort
	}
	return 0
}

func (x *ExecutionOptions) GetOptimizationLevel() ExecutionOptions_EffortLevel {
	if x != nil {
		return x.OptimizationLevel
	}
	return ExecutionOptions_EFFORT_UNKNOWN
}

func (x *ExecutionOptions) GetMemoryFittingLevel() ExecutionOptions_EffortLevel {
	if x != nil {
		return x.MemoryFittingLevel
	}
	return ExecutionOptions_EFFORT_UNKNOWN
}

func (x *ExecutionOptions) GetDeduplicateHlo() bool {
	if x != nil {
		return x.DeduplicateHlo
	}
	return false
}

func (x *ExecutionOptions) GetAllowSpmdShardingPropagationToParameters() []bool {
	if x != nil {
		return x.AllowSpmdShardingPropagationToParameters
	}
	return nil
}

func (x *ExecutionOptions) GetAllowSpmdShardingPropagationToOutput() []bool {
	if x != nil {
		return x.AllowSpmdShardingPropagationToOutput
	}
	return nil
}

func (x *ExecutionOptions) GetParamRequiresBroadcastViaCollectives() []bool {
	if x != nil {
		return x.ParamRequiresBroadcastViaCollectives
	}
	return nil
}

func (x *ExecutionOptions) GetAllowSeparateShardingPrograms() bool {
	if x != nil {
		return x.AllowSeparateShardingPrograms
	}
	return false
}

func (x *ExecutionOptions) GetShardableValueUpdatePairs() []*ShardableValueUpdatePairProto {
	if x != nil {
		return x.ShardableValueUpdatePairs
	}
	return nil
}

func (x *ExecutionOptions) GetFdoProfile() []byte {
	if x != nil {
		return x.FdoProfile
	}
	return nil
}

func (x *ExecutionOptions) GetDeviceMemorySize() int64 {
	if x != nil {
		return x.DeviceMemorySize
	}
	return 0
}

func (x *ExecutionOptions) GetUseShardyPartitioner() bool {
	if x != nil {
		return x.UseShardyPartitioner
	}
	return false
}

// Serialization of HloModuleConfig. See the C++ class definition for
// descriptions of each field.
// There are no guarantees of backwards or forwards compatibility.
// Next id: 42.
type HloModuleConfigProto struct {
	state                                protoimpl.MessageState      `protogen:"open.v1"`
	EntryComputationLayout               *xla_data.ProgramShapeProto `protobuf:"bytes,1,opt,name=entry_computation_layout,json=entryComputationLayout,proto3" json:"entry_computation_layout,omitempty"`
	Seed                                 uint64                      `protobuf:"varint,2,opt,name=seed,proto3" json:"seed,omitempty"`
	LaunchId                             int32                       `protobuf:"varint,3,opt,name=launch_id,json=launchId,proto3" json:"launch_id,omitempty"`
	ReplicaCount                         int64                       `protobuf:"varint,4,opt,name=replica_count,json=replicaCount,proto3" json:"replica_count,omitempty"`
	NumPartitions                        int64                       `protobuf:"varint,5,opt,name=num_partitions,json=numPartitions,proto3" json:"num_partitions,omitempty"`
	ParamRequiresBroadcastViaCollectives []bool                      `protobuf:"varint,6,rep,packed,name=param_requires_broadcast_via_collectives,json=paramRequiresBroadcastViaCollectives,proto3" json:"param_requires_broadcast_via_collectives,omitempty"`
	UseSpmdPartitioning                  bool                        `protobuf:"varint,7,opt,name=use_spmd_partitioning,json=useSpmdPartitioning,proto3" json:"use_spmd_partitioning,omitempty"`
	UseAutoSpmdPartitioning              bool                        `protobuf:"varint,8,opt,name=use_auto_spmd_partitioning,json=useAutoSpmdPartitioning,proto3" json:"use_auto_spmd_partitioning,omitempty"`
	AutoSpmdPartitioningMeshShape        []int64                     `protobuf:"varint,9,rep,packed,name=auto_spmd_partitioning_mesh_shape,json=autoSpmdPartitioningMeshShape,proto3" json:"auto_spmd_partitioning_mesh_shape,omitempty"`
	AutoSpmdPartitioningMeshIds          []int64                     `protobuf:"varint,10,rep,packed,name=auto_spmd_partitioning_mesh_ids,json=autoSpmdPartitioningMeshIds,proto3" json:"auto_spmd_partitioning_mesh_ids,omitempty"`
	// Deprecated: Marked as deprecated in xla/xla.proto.
	ExecTimeOptimizationEffort float32 `protobuf:"fixed32,36,opt,name=exec_time_optimization_effort,json=execTimeOptimizationEffort,proto3" json:"exec_time_optimization_effort,omitempty"`
	// Deprecated: Marked as deprecated in xla/xla.proto.
	MemoryFittingEffort       float32                         `protobuf:"fixed32,37,opt,name=memory_fitting_effort,json=memoryFittingEffort,proto3" json:"memory_fitting_effort,omitempty"`
	OptimizationLevel         ExecutionOptions_EffortLevel    `protobuf:"varint,39,opt,name=optimization_level,json=optimizationLevel,proto3,enum=xla.ExecutionOptions_EffortLevel" json:"optimization_level,omitempty"`
	MemoryFittingLevel        ExecutionOptions_EffortLevel    `protobuf:"varint,40,opt,name=memory_fitting_level,json=memoryFittingLevel,proto3,enum=xla.ExecutionOptions_EffortLevel" json:"memory_fitting_level,omitempty"`
	DeduplicateHlo            bool                            `protobuf:"varint,11,opt,name=deduplicate_hlo,json=deduplicateHlo,proto3" json:"deduplicate_hlo,omitempty"`
	IntraOpParallelismThreads int64                           `protobuf:"varint,12,opt,name=intra_op_parallelism_threads,json=intraOpParallelismThreads,proto3" json:"intra_op_parallelism_threads,omitempty"`
	DeviceType                string                          `protobuf:"bytes,13,opt,name=device_type,json=deviceType,proto3" json:"device_type,omitempty"`
	DebugOptions              *DebugOptions                   `protobuf:"bytes,14,opt,name=debug_options,json=debugOptions,proto3" json:"debug_options,omitempty"`
	StaticDeviceAssignment    *xla_data.DeviceAssignmentProto `protobuf:"bytes,15,opt,name=static_device_assignment,json=staticDeviceAssignment,proto3" json:"static_device_assignment,omitempty"`
	// The original device assignment before being changed by a simulator.
	// Simulators, like HybridSim, may change the device assignment to a smaller
	// topology, to make simulation easier.
	PreSimulationDeviceAssignment            *xla_data.DeviceAssignmentProto             `protobuf:"bytes,35,opt,name=pre_simulation_device_assignment,json=preSimulationDeviceAssignment,proto3" json:"pre_simulation_device_assignment,omitempty"`
	AllowSeparateShardingPrograms            bool                                        `protobuf:"varint,30,opt,name=allow_separate_sharding_programs,json=allowSeparateShardingPrograms,proto3" json:"allow_separate_sharding_programs,omitempty"`
	ShardableValueUpdatePairs                []*ShardableValueUpdatePairProto            `protobuf:"bytes,16,rep,name=shardable_value_update_pairs,json=shardableValueUpdatePairs,proto3" json:"shardable_value_update_pairs,omitempty"`
	AliasPassthroughParams                   bool                                        `protobuf:"varint,17,opt,name=alias_passthrough_params,json=aliasPassthroughParams,proto3" json:"alias_passthrough_params,omitempty"`
	ContentAwareComputationSorting           bool                                        `protobuf:"varint,18,opt,name=content_aware_computation_sorting,json=contentAwareComputationSorting,proto3" json:"content_aware_computation_sorting,omitempty"`
	FusionConfigCollection                   HloModuleConfigProto_FusionConfigCollection `protobuf:"varint,19,opt,name=fusion_config_collection,json=fusionConfigCollection,proto3,enum=xla.HloModuleConfigProto_FusionConfigCollection" json:"fusion_config_collection,omitempty"`
	FusionConfig                             []*HloModuleConfigProto_BoolList            `protobuf:"bytes,20,rep,name=fusion_config,json=fusionConfig,proto3" json:"fusion_config,omitempty"`
	DotConfig                                map[string]*HloModuleConfigProto_Int64List  `protobuf:"bytes,21,rep,name=dot_config,json=dotConfig,proto3" json:"dot_config,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	LayoutConfig                             []*HloModuleConfigProto_Int64ListList       `protobuf:"bytes,22,rep,name=layout_config,json=layoutConfig,proto3" json:"layout_config,omitempty"`
	MemorySpaceAssignmentConfig              []uint64                                    `protobuf:"varint,23,rep,packed,name=memory_space_assignment_config,json=memorySpaceAssignmentConfig,proto3" json:"memory_space_assignment_config,omitempty"`
	PhaseOrderingConfig                      []*HloModuleConfigProto_BoolList            `protobuf:"bytes,24,rep,name=phase_ordering_config,json=phaseOrderingConfig,proto3" json:"phase_ordering_config,omitempty"`
	PhaseIndex                               int32                                       `protobuf:"varint,25,opt,name=phase_index,json=phaseIndex,proto3" json:"phase_index,omitempty"`
	AllowSpmdShardingPropagationToParameters []bool                                      `protobuf:"varint,33,rep,packed,name=allow_spmd_sharding_propagation_to_parameters,json=allowSpmdShardingPropagationToParameters,proto3" json:"allow_spmd_sharding_propagation_to_parameters,omitempty"`
	AllowSpmdShardingPropagationToOutput     []bool                                      `protobuf:"varint,27,rep,packed,name=allow_spmd_sharding_propagation_to_output,json=allowSpmdShardingPropagationToOutput,proto3" json:"allow_spmd_sharding_propagation_to_output,omitempty"`
	AnalysisAllowanceMap                     map[string]int64                            `protobuf:"bytes,28,rep,name=analysis_allowance_map,json=analysisAllowanceMap,proto3" json:"analysis_allowance_map,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	MatrixUnitOperandPrecision               xla_data.PrecisionConfig_Precision          `protobuf:"varint,29,opt,name=matrix_unit_operand_precision,json=matrixUnitOperandPrecision,proto3,enum=xla.PrecisionConfig_Precision" json:"matrix_unit_operand_precision,omitempty"`
	FdoProfile                               []byte                                      `protobuf:"bytes,31,opt,name=fdo_profile,json=fdoProfile,proto3" json:"fdo_profile,omitempty"`
	DeviceMemorySize                         int64                                       `protobuf:"varint,32,opt,name=device_memory_size,json=deviceMemorySize,proto3" json:"device_memory_size,omitempty"`
	UseShardyPartitioner                     bool                                        `protobuf:"varint,34,opt,name=use_shardy_partitioner,json=useShardyPartitioner,proto3" json:"use_shardy_partitioner,omitempty"`
	ShardingConfig                           *ShardingConfigProto                        `protobuf:"bytes,38,opt,name=sharding_config,json=shardingConfig,proto3" json:"sharding_config,omitempty"`
	ScheduleConfig                           *ScheduleConfigProto                        `protobuf:"bytes,41,opt,name=schedule_config,json=scheduleConfig,proto3" json:"schedule_config,omitempty"`
	unknownFields                            protoimpl.UnknownFields
	sizeCache                                protoimpl.SizeCache
}

func (x *HloModuleConfigProto) Reset() {
	*x = HloModuleConfigProto{}
	mi := &file_xla_xla_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HloModuleConfigProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HloModuleConfigProto) ProtoMessage() {}

func (x *HloModuleConfigProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HloModuleConfigProto.ProtoReflect.Descriptor instead.
func (*HloModuleConfigProto) Descriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{5}
}

func (x *HloModuleConfigProto) GetEntryComputationLayout() *xla_data.ProgramShapeProto {
	if x != nil {
		return x.EntryComputationLayout
	}
	return nil
}

func (x *HloModuleConfigProto) GetSeed() uint64 {
	if x != nil {
		return x.Seed
	}
	return 0
}

func (x *HloModuleConfigProto) GetLaunchId() int32 {
	if x != nil {
		return x.LaunchId
	}
	return 0
}

func (x *HloModuleConfigProto) GetReplicaCount() int64 {
	if x != nil {
		return x.ReplicaCount
	}
	return 0
}

func (x *HloModuleConfigProto) GetNumPartitions() int64 {
	if x != nil {
		return x.NumPartitions
	}
	return 0
}

func (x *HloModuleConfigProto) GetParamRequiresBroadcastViaCollectives() []bool {
	if x != nil {
		return x.ParamRequiresBroadcastViaCollectives
	}
	return nil
}

func (x *HloModuleConfigProto) GetUseSpmdPartitioning() bool {
	if x != nil {
		return x.UseSpmdPartitioning
	}
	return false
}

func (x *HloModuleConfigProto) GetUseAutoSpmdPartitioning() bool {
	if x != nil {
		return x.UseAutoSpmdPartitioning
	}
	return false
}

func (x *HloModuleConfigProto) GetAutoSpmdPartitioningMeshShape() []int64 {
	if x != nil {
		return x.AutoSpmdPartitioningMeshShape
	}
	return nil
}

func (x *HloModuleConfigProto) GetAutoSpmdPartitioningMeshIds() []int64 {
	if x != nil {
		return x.AutoSpmdPartitioningMeshIds
	}
	return nil
}

// Deprecated: Marked as deprecated in xla/xla.proto.
func (x *HloModuleConfigProto) GetExecTimeOptimizationEffort() float32 {
	if x != nil {
		return x.ExecTimeOptimizationEffort
	}
	return 0
}

// Deprecated: Marked as deprecated in xla/xla.proto.
func (x *HloModuleConfigProto) GetMemoryFittingEffort() float32 {
	if x != nil {
		return x.MemoryFittingEffort
	}
	return 0
}

func (x *HloModuleConfigProto) GetOptimizationLevel() ExecutionOptions_EffortLevel {
	if x != nil {
		return x.OptimizationLevel
	}
	return ExecutionOptions_EFFORT_UNKNOWN
}

func (x *HloModuleConfigProto) GetMemoryFittingLevel() ExecutionOptions_EffortLevel {
	if x != nil {
		return x.MemoryFittingLevel
	}
	return ExecutionOptions_EFFORT_UNKNOWN
}

func (x *HloModuleConfigProto) GetDeduplicateHlo() bool {
	if x != nil {
		return x.DeduplicateHlo
	}
	return false
}

func (x *HloModuleConfigProto) GetIntraOpParallelismThreads() int64 {
	if x != nil {
		return x.IntraOpParallelismThreads
	}
	return 0
}

func (x *HloModuleConfigProto) GetDeviceType() string {
	if x != nil {
		return x.DeviceType
	}
	return ""
}

func (x *HloModuleConfigProto) GetDebugOptions() *DebugOptions {
	if x != nil {
		return x.DebugOptions
	}
	return nil
}

func (x *HloModuleConfigProto) GetStaticDeviceAssignment() *xla_data.DeviceAssignmentProto {
	if x != nil {
		return x.StaticDeviceAssignment
	}
	return nil
}

func (x *HloModuleConfigProto) GetPreSimulationDeviceAssignment() *xla_data.DeviceAssignmentProto {
	if x != nil {
		return x.PreSimulationDeviceAssignment
	}
	return nil
}

func (x *HloModuleConfigProto) GetAllowSeparateShardingPrograms() bool {
	if x != nil {
		return x.AllowSeparateShardingPrograms
	}
	return false
}

func (x *HloModuleConfigProto) GetShardableValueUpdatePairs() []*ShardableValueUpdatePairProto {
	if x != nil {
		return x.ShardableValueUpdatePairs
	}
	return nil
}

func (x *HloModuleConfigProto) GetAliasPassthroughParams() bool {
	if x != nil {
		return x.AliasPassthroughParams
	}
	return false
}

func (x *HloModuleConfigProto) GetContentAwareComputationSorting() bool {
	if x != nil {
		return x.ContentAwareComputationSorting
	}
	return false
}

func (x *HloModuleConfigProto) GetFusionConfigCollection() HloModuleConfigProto_FusionConfigCollection {
	if x != nil {
		return x.FusionConfigCollection
	}
	return HloModuleConfigProto_OFF
}

func (x *HloModuleConfigProto) GetFusionConfig() []*HloModuleConfigProto_BoolList {
	if x != nil {
		return x.FusionConfig
	}
	return nil
}

func (x *HloModuleConfigProto) GetDotConfig() map[string]*HloModuleConfigProto_Int64List {
	if x != nil {
		return x.DotConfig
	}
	return nil
}

func (x *HloModuleConfigProto) GetLayoutConfig() []*HloModuleConfigProto_Int64ListList {
	if x != nil {
		return x.LayoutConfig
	}
	return nil
}

func (x *HloModuleConfigProto) GetMemorySpaceAssignmentConfig() []uint64 {
	if x != nil {
		return x.MemorySpaceAssignmentConfig
	}
	return nil
}

func (x *HloModuleConfigProto) GetPhaseOrderingConfig() []*HloModuleConfigProto_BoolList {
	if x != nil {
		return x.PhaseOrderingConfig
	}
	return nil
}

func (x *HloModuleConfigProto) GetPhaseIndex() int32 {
	if x != nil {
		return x.PhaseIndex
	}
	return 0
}

func (x *HloModuleConfigProto) GetAllowSpmdShardingPropagationToParameters() []bool {
	if x != nil {
		return x.AllowSpmdShardingPropagationToParameters
	}
	return nil
}

func (x *HloModuleConfigProto) GetAllowSpmdShardingPropagationToOutput() []bool {
	if x != nil {
		return x.AllowSpmdShardingPropagationToOutput
	}
	return nil
}

func (x *HloModuleConfigProto) GetAnalysisAllowanceMap() map[string]int64 {
	if x != nil {
		return x.AnalysisAllowanceMap
	}
	return nil
}

func (x *HloModuleConfigProto) GetMatrixUnitOperandPrecision() xla_data.PrecisionConfig_Precision {
	if x != nil {
		return x.MatrixUnitOperandPrecision
	}
	return xla_data.PrecisionConfig_Precision(0)
}

func (x *HloModuleConfigProto) GetFdoProfile() []byte {
	if x != nil {
		return x.FdoProfile
	}
	return nil
}

func (x *HloModuleConfigProto) GetDeviceMemorySize() int64 {
	if x != nil {
		return x.DeviceMemorySize
	}
	return 0
}

func (x *HloModuleConfigProto) GetUseShardyPartitioner() bool {
	if x != nil {
		return x.UseShardyPartitioner
	}
	return false
}

func (x *HloModuleConfigProto) GetShardingConfig() *ShardingConfigProto {
	if x != nil {
		return x.ShardingConfig
	}
	return nil
}

func (x *HloModuleConfigProto) GetScheduleConfig() *ScheduleConfigProto {
	if x != nil {
		return x.ScheduleConfig
	}
	return nil
}

type HloModuleProtoWithConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	HloModule     *hlo.HloModuleProto    `protobuf:"bytes,1,opt,name=hlo_module,json=hloModule,proto3" json:"hlo_module,omitempty"`
	Config        *HloModuleConfigProto  `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HloModuleProtoWithConfig) Reset() {
	*x = HloModuleProtoWithConfig{}
	mi := &file_xla_xla_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HloModuleProtoWithConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HloModuleProtoWithConfig) ProtoMessage() {}

func (x *HloModuleProtoWithConfig) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HloModuleProtoWithConfig.ProtoReflect.Descriptor instead.
func (*HloModuleProtoWithConfig) Descriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{6}
}

func (x *HloModuleProtoWithConfig) GetHloModule() *hlo.HloModuleProto {
	if x != nil {
		return x.HloModule
	}
	return nil
}

func (x *HloModuleProtoWithConfig) GetConfig() *HloModuleConfigProto {
	if x != nil {
		return x.Config
	}
	return nil
}

// A trace estimated by the Latency Hiding Scheduler.
type ScheduleProto struct {
	state                protoimpl.MessageState                    `protogen:"open.v1"`
	HloModule            *hlo.HloModuleProto                       `protobuf:"bytes,1,opt,name=hlo_module,json=hloModule,proto3" json:"hlo_module,omitempty"`
	ComputationSchedules []*ScheduleProto_ComputationScheduleProto `protobuf:"bytes,2,rep,name=computation_schedules,json=computationSchedules,proto3" json:"computation_schedules,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ScheduleProto) Reset() {
	*x = ScheduleProto{}
	mi := &file_xla_xla_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ScheduleProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScheduleProto) ProtoMessage() {}

func (x *ScheduleProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScheduleProto.ProtoReflect.Descriptor instead.
func (*ScheduleProto) Descriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{7}
}

func (x *ScheduleProto) GetHloModule() *hlo.HloModuleProto {
	if x != nil {
		return x.HloModule
	}
	return nil
}

func (x *ScheduleProto) GetComputationSchedules() []*ScheduleProto_ComputationScheduleProto {
	if x != nil {
		return x.ComputationSchedules
	}
	return nil
}

// Message that captures sharding configuration of an HLO op.
type NodeShardingConfigProto struct {
	state         protoimpl.MessageState     `protogen:"open.v1"`
	Sharding      *xla_data.OpSharding       `protobuf:"bytes,1,opt,name=sharding,proto3" json:"sharding,omitempty"` // For non-tuples.
	Nodes         []*NodeShardingConfigProto `protobuf:"bytes,2,rep,name=nodes,proto3" json:"nodes,omitempty"`       // For tuples.
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NodeShardingConfigProto) Reset() {
	*x = NodeShardingConfigProto{}
	mi := &file_xla_xla_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NodeShardingConfigProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NodeShardingConfigProto) ProtoMessage() {}

func (x *NodeShardingConfigProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NodeShardingConfigProto.ProtoReflect.Descriptor instead.
func (*NodeShardingConfigProto) Descriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{8}
}

func (x *NodeShardingConfigProto) GetSharding() *xla_data.OpSharding {
	if x != nil {
		return x.Sharding
	}
	return nil
}

func (x *NodeShardingConfigProto) GetNodes() []*NodeShardingConfigProto {
	if x != nil {
		return x.Nodes
	}
	return nil
}

// Message that captures sharding configuration of an HLO module.
type ShardingConfigProto struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Configuration for each HLO instruction.
	Nodes         []*NodeShardingConfigProto `protobuf:"bytes,1,rep,name=nodes,proto3" json:"nodes,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ShardingConfigProto) Reset() {
	*x = ShardingConfigProto{}
	mi := &file_xla_xla_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ShardingConfigProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShardingConfigProto) ProtoMessage() {}

func (x *ShardingConfigProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShardingConfigProto.ProtoReflect.Descriptor instead.
func (*ShardingConfigProto) Descriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{9}
}

func (x *ShardingConfigProto) GetNodes() []*NodeShardingConfigProto {
	if x != nil {
		return x.Nodes
	}
	return nil
}

// Message that captures schedule configuration of an HLO module.
type ScheduleConfigProto struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The schedule of the HLO module.
	Sequence      []*ScheduleConfigProto_Instruction `protobuf:"bytes,1,rep,name=sequence,proto3" json:"sequence,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ScheduleConfigProto) Reset() {
	*x = ScheduleConfigProto{}
	mi := &file_xla_xla_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ScheduleConfigProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScheduleConfigProto) ProtoMessage() {}

func (x *ScheduleConfigProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScheduleConfigProto.ProtoReflect.Descriptor instead.
func (*ScheduleConfigProto) Descriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{10}
}

func (x *ScheduleConfigProto) GetSequence() []*ScheduleConfigProto_Instruction {
	if x != nil {
		return x.Sequence
	}
	return nil
}

type HloModuleConfigProto_BoolList struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Vals          []bool                 `protobuf:"varint,1,rep,packed,name=vals,proto3" json:"vals,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HloModuleConfigProto_BoolList) Reset() {
	*x = HloModuleConfigProto_BoolList{}
	mi := &file_xla_xla_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HloModuleConfigProto_BoolList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HloModuleConfigProto_BoolList) ProtoMessage() {}

func (x *HloModuleConfigProto_BoolList) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HloModuleConfigProto_BoolList.ProtoReflect.Descriptor instead.
func (*HloModuleConfigProto_BoolList) Descriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{5, 0}
}

func (x *HloModuleConfigProto_BoolList) GetVals() []bool {
	if x != nil {
		return x.Vals
	}
	return nil
}

type HloModuleConfigProto_Int64List struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Vals          []int64                `protobuf:"varint,1,rep,packed,name=vals,proto3" json:"vals,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HloModuleConfigProto_Int64List) Reset() {
	*x = HloModuleConfigProto_Int64List{}
	mi := &file_xla_xla_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HloModuleConfigProto_Int64List) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HloModuleConfigProto_Int64List) ProtoMessage() {}

func (x *HloModuleConfigProto_Int64List) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HloModuleConfigProto_Int64List.ProtoReflect.Descriptor instead.
func (*HloModuleConfigProto_Int64List) Descriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{5, 1}
}

func (x *HloModuleConfigProto_Int64List) GetVals() []int64 {
	if x != nil {
		return x.Vals
	}
	return nil
}

type HloModuleConfigProto_Int64ListList struct {
	state         protoimpl.MessageState            `protogen:"open.v1"`
	Lists         []*HloModuleConfigProto_Int64List `protobuf:"bytes,1,rep,name=lists,proto3" json:"lists,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HloModuleConfigProto_Int64ListList) Reset() {
	*x = HloModuleConfigProto_Int64ListList{}
	mi := &file_xla_xla_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HloModuleConfigProto_Int64ListList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HloModuleConfigProto_Int64ListList) ProtoMessage() {}

func (x *HloModuleConfigProto_Int64ListList) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HloModuleConfigProto_Int64ListList.ProtoReflect.Descriptor instead.
func (*HloModuleConfigProto_Int64ListList) Descriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{5, 2}
}

func (x *HloModuleConfigProto_Int64ListList) GetLists() []*HloModuleConfigProto_Int64List {
	if x != nil {
		return x.Lists
	}
	return nil
}

type ScheduleProto_Instruction struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Instruction id (matches the id in HloInstructionProto).
	Id int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// Start and end timestamps in cycles.
	StartTimestampCycles float64 `protobuf:"fixed64,2,opt,name=start_timestamp_cycles,json=startTimestampCycles,proto3" json:"start_timestamp_cycles,omitempty"`
	EndTimestampCycles   float64 `protobuf:"fixed64,3,opt,name=end_timestamp_cycles,json=endTimestampCycles,proto3" json:"end_timestamp_cycles,omitempty"`
	MemoryUsageAfter     int64   `protobuf:"varint,5,opt,name=memory_usage_after,json=memoryUsageAfter,proto3" json:"memory_usage_after,omitempty"`
	PeakMemoryAfter      int64   `protobuf:"varint,6,opt,name=peak_memory_after,json=peakMemoryAfter,proto3" json:"peak_memory_after,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ScheduleProto_Instruction) Reset() {
	*x = ScheduleProto_Instruction{}
	mi := &file_xla_xla_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ScheduleProto_Instruction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScheduleProto_Instruction) ProtoMessage() {}

func (x *ScheduleProto_Instruction) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScheduleProto_Instruction.ProtoReflect.Descriptor instead.
func (*ScheduleProto_Instruction) Descriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{7, 0}
}

func (x *ScheduleProto_Instruction) GetId() int64 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *ScheduleProto_Instruction) GetStartTimestampCycles() float64 {
	if x != nil {
		return x.StartTimestampCycles
	}
	return 0
}

func (x *ScheduleProto_Instruction) GetEndTimestampCycles() float64 {
	if x != nil {
		return x.EndTimestampCycles
	}
	return 0
}

func (x *ScheduleProto_Instruction) GetMemoryUsageAfter() int64 {
	if x != nil {
		return x.MemoryUsageAfter
	}
	return 0
}

func (x *ScheduleProto_Instruction) GetPeakMemoryAfter() int64 {
	if x != nil {
		return x.PeakMemoryAfter
	}
	return 0
}

type ScheduleProto_SchedulerStatisticsProto struct {
	state                           protoimpl.MessageState `protogen:"open.v1"`
	AllGatherWastedCycles           float64                `protobuf:"fixed64,1,opt,name=all_gather_wasted_cycles,json=allGatherWastedCycles,proto3" json:"all_gather_wasted_cycles,omitempty"`
	AllReduceWastedCycles           float64                `protobuf:"fixed64,2,opt,name=all_reduce_wasted_cycles,json=allReduceWastedCycles,proto3" json:"all_reduce_wasted_cycles,omitempty"`
	CollectiveBroadcastWastedCycles float64                `protobuf:"fixed64,3,opt,name=collective_broadcast_wasted_cycles,json=collectiveBroadcastWastedCycles,proto3" json:"collective_broadcast_wasted_cycles,omitempty"`
	CollectivePermuteWastedCycles   float64                `protobuf:"fixed64,4,opt,name=collective_permute_wasted_cycles,json=collectivePermuteWastedCycles,proto3" json:"collective_permute_wasted_cycles,omitempty"`
	AllToAllWastedCycles            float64                `protobuf:"fixed64,5,opt,name=all_to_all_wasted_cycles,json=allToAllWastedCycles,proto3" json:"all_to_all_wasted_cycles,omitempty"`
	RaggedAllToAllWastedCycles      float64                `protobuf:"fixed64,6,opt,name=ragged_all_to_all_wasted_cycles,json=raggedAllToAllWastedCycles,proto3" json:"ragged_all_to_all_wasted_cycles,omitempty"`
	ReduceScatterWastedCycles       float64                `protobuf:"fixed64,7,opt,name=reduce_scatter_wasted_cycles,json=reduceScatterWastedCycles,proto3" json:"reduce_scatter_wasted_cycles,omitempty"`
	SendWastedCycles                float64                `protobuf:"fixed64,8,opt,name=send_wasted_cycles,json=sendWastedCycles,proto3" json:"send_wasted_cycles,omitempty"`
	RecvWastedCycles                float64                `protobuf:"fixed64,9,opt,name=recv_wasted_cycles,json=recvWastedCycles,proto3" json:"recv_wasted_cycles,omitempty"`
	TotalWastedCycles               float64                `protobuf:"fixed64,10,opt,name=total_wasted_cycles,json=totalWastedCycles,proto3" json:"total_wasted_cycles,omitempty"`
	TotalCycles                     float64                `protobuf:"fixed64,11,opt,name=total_cycles,json=totalCycles,proto3" json:"total_cycles,omitempty"`
	MemoryPressurePeak              int64                  `protobuf:"varint,12,opt,name=memory_pressure_peak,json=memoryPressurePeak,proto3" json:"memory_pressure_peak,omitempty"`
	unknownFields                   protoimpl.UnknownFields
	sizeCache                       protoimpl.SizeCache
}

func (x *ScheduleProto_SchedulerStatisticsProto) Reset() {
	*x = ScheduleProto_SchedulerStatisticsProto{}
	mi := &file_xla_xla_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ScheduleProto_SchedulerStatisticsProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScheduleProto_SchedulerStatisticsProto) ProtoMessage() {}

func (x *ScheduleProto_SchedulerStatisticsProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScheduleProto_SchedulerStatisticsProto.ProtoReflect.Descriptor instead.
func (*ScheduleProto_SchedulerStatisticsProto) Descriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{7, 1}
}

func (x *ScheduleProto_SchedulerStatisticsProto) GetAllGatherWastedCycles() float64 {
	if x != nil {
		return x.AllGatherWastedCycles
	}
	return 0
}

func (x *ScheduleProto_SchedulerStatisticsProto) GetAllReduceWastedCycles() float64 {
	if x != nil {
		return x.AllReduceWastedCycles
	}
	return 0
}

func (x *ScheduleProto_SchedulerStatisticsProto) GetCollectiveBroadcastWastedCycles() float64 {
	if x != nil {
		return x.CollectiveBroadcastWastedCycles
	}
	return 0
}

func (x *ScheduleProto_SchedulerStatisticsProto) GetCollectivePermuteWastedCycles() float64 {
	if x != nil {
		return x.CollectivePermuteWastedCycles
	}
	return 0
}

func (x *ScheduleProto_SchedulerStatisticsProto) GetAllToAllWastedCycles() float64 {
	if x != nil {
		return x.AllToAllWastedCycles
	}
	return 0
}

func (x *ScheduleProto_SchedulerStatisticsProto) GetRaggedAllToAllWastedCycles() float64 {
	if x != nil {
		return x.RaggedAllToAllWastedCycles
	}
	return 0
}

func (x *ScheduleProto_SchedulerStatisticsProto) GetReduceScatterWastedCycles() float64 {
	if x != nil {
		return x.ReduceScatterWastedCycles
	}
	return 0
}

func (x *ScheduleProto_SchedulerStatisticsProto) GetSendWastedCycles() float64 {
	if x != nil {
		return x.SendWastedCycles
	}
	return 0
}

func (x *ScheduleProto_SchedulerStatisticsProto) GetRecvWastedCycles() float64 {
	if x != nil {
		return x.RecvWastedCycles
	}
	return 0
}

func (x *ScheduleProto_SchedulerStatisticsProto) GetTotalWastedCycles() float64 {
	if x != nil {
		return x.TotalWastedCycles
	}
	return 0
}

func (x *ScheduleProto_SchedulerStatisticsProto) GetTotalCycles() float64 {
	if x != nil {
		return x.TotalCycles
	}
	return 0
}

func (x *ScheduleProto_SchedulerStatisticsProto) GetMemoryPressurePeak() int64 {
	if x != nil {
		return x.MemoryPressurePeak
	}
	return 0
}

type ScheduleProto_ComputationScheduleProto struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Computation id (matches the id in HloComputationProto).
	ComputationId        int64                                   `protobuf:"varint,1,opt,name=computation_id,json=computationId,proto3" json:"computation_id,omitempty"`
	Instructions         []*ScheduleProto_Instruction            `protobuf:"bytes,2,rep,name=instructions,proto3" json:"instructions,omitempty"`
	SchedulerStatistics  *ScheduleProto_SchedulerStatisticsProto `protobuf:"bytes,3,opt,name=scheduler_statistics,json=schedulerStatistics,proto3" json:"scheduler_statistics,omitempty"`
	CyclesPerMicrosecond int64                                   `protobuf:"varint,4,opt,name=cycles_per_microsecond,json=cyclesPerMicrosecond,proto3" json:"cycles_per_microsecond,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *ScheduleProto_ComputationScheduleProto) Reset() {
	*x = ScheduleProto_ComputationScheduleProto{}
	mi := &file_xla_xla_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ScheduleProto_ComputationScheduleProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScheduleProto_ComputationScheduleProto) ProtoMessage() {}

func (x *ScheduleProto_ComputationScheduleProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScheduleProto_ComputationScheduleProto.ProtoReflect.Descriptor instead.
func (*ScheduleProto_ComputationScheduleProto) Descriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{7, 2}
}

func (x *ScheduleProto_ComputationScheduleProto) GetComputationId() int64 {
	if x != nil {
		return x.ComputationId
	}
	return 0
}

func (x *ScheduleProto_ComputationScheduleProto) GetInstructions() []*ScheduleProto_Instruction {
	if x != nil {
		return x.Instructions
	}
	return nil
}

func (x *ScheduleProto_ComputationScheduleProto) GetSchedulerStatistics() *ScheduleProto_SchedulerStatisticsProto {
	if x != nil {
		return x.SchedulerStatistics
	}
	return nil
}

func (x *ScheduleProto_ComputationScheduleProto) GetCyclesPerMicrosecond() int64 {
	if x != nil {
		return x.CyclesPerMicrosecond
	}
	return 0
}

type ScheduleConfigProto_Instruction struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Instruction name.
	Name          string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ScheduleConfigProto_Instruction) Reset() {
	*x = ScheduleConfigProto_Instruction{}
	mi := &file_xla_xla_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ScheduleConfigProto_Instruction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScheduleConfigProto_Instruction) ProtoMessage() {}

func (x *ScheduleConfigProto_Instruction) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScheduleConfigProto_Instruction.ProtoReflect.Descriptor instead.
func (*ScheduleConfigProto_Instruction) Descriptor() ([]byte, []int) {
	return file_xla_xla_proto_rawDescGZIP(), []int{10, 0}
}

func (x *ScheduleConfigProto_Instruction) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_xla_xla_proto protoreflect.FileDescriptor

var file_xla_xla_proto_rawDesc = string([]byte{
	0x0a, 0x0d, 0x78, 0x6c, 0x61, 0x2f, 0x78, 0x6c, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x03, 0x78, 0x6c, 0x61, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x15, 0x78, 0x6c, 0x61, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2f, 0x68, 0x6c, 0x6f,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x12, 0x78, 0x6c, 0x61, 0x2f, 0x78, 0x6c, 0x61, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x58, 0x0a, 0x1c, 0x43, 0x6f,
	0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x38, 0x0a, 0x0c, 0x65, 0x6e,
	0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x41, 0x6e, 0x79, 0x52, 0x0c, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x22, 0x9b, 0x86, 0x02, 0x0a, 0x0c, 0x44, 0x65, 0x62, 0x75, 0x67, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5f, 0x0a, 0x2a, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x69,
	0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x5f,
	0x68, 0x6f, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x6f, 0x66, 0x66,
	0x6c, 0x6f, 0x61, 0x64, 0x18, 0x98, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x25, 0x78,
	0x6c, 0x61, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74,
	0x69, 0x63, 0x48, 0x6f, 0x73, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x4f, 0x66, 0x66,
	0x6c, 0x6f, 0x61, 0x64, 0x88, 0x01, 0x01, 0x12, 0x47, 0x0a, 0x1e, 0x78, 0x6c, 0x61, 0x5f, 0x68,
	0x6c, 0x6f, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x5f, 0x66, 0x69, 0x78, 0x5f, 0x64, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x5f, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x18, 0xf2, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x48, 0x01, 0x52, 0x19, 0x78, 0x6c, 0x61, 0x48, 0x6c, 0x6f, 0x50, 0x61, 0x73, 0x73, 0x46, 0x69,
	0x78, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x88, 0x01, 0x01,
	0x12, 0x70, 0x0a, 0x34, 0x78, 0x6c, 0x61, 0x5f, 0x75, 0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72,
	0x74, 0x65, 0x64, 0x5f, 0x63, 0x72, 0x61, 0x73, 0x68, 0x5f, 0x6f, 0x6e, 0x5f, 0x68, 0x6c, 0x6f,
	0x5f, 0x70, 0x61, 0x73, 0x73, 0x5f, 0x66, 0x69, 0x78, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x69, 0x74,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0xeb, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48,
	0x02, 0x52, 0x2c, 0x78, 0x6c, 0x61, 0x55, 0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65,
	0x64, 0x43, 0x72, 0x61, 0x73, 0x68, 0x4f, 0x6e, 0x48, 0x6c, 0x6f, 0x50, 0x61, 0x73, 0x73, 0x46,
	0x69, 0x78, 0x4d, 0x61, 0x78, 0x49, 0x74, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x88,
	0x01, 0x01, 0x12, 0x63, 0x0a, 0x2d, 0x78, 0x6c, 0x61, 0x5f, 0x75, 0x6e, 0x73, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x72, 0x61, 0x73, 0x68, 0x5f, 0x6f, 0x6e, 0x5f, 0x68,
	0x6c, 0x6f, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x5f, 0x6e, 0x6f, 0x6f, 0x70, 0x5f, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x18, 0xfb, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x03, 0x52, 0x26, 0x78, 0x6c,
	0x61, 0x55, 0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x43, 0x72, 0x61, 0x73,
	0x68, 0x4f, 0x6e, 0x48, 0x6c, 0x6f, 0x50, 0x61, 0x73, 0x73, 0x4e, 0x6f, 0x6f, 0x70, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x88, 0x01, 0x01, 0x12, 0x6e, 0x0a, 0x33, 0x78, 0x6c, 0x61, 0x5f, 0x75,
	0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x72, 0x61, 0x73, 0x68,
	0x5f, 0x6f, 0x6e, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x5f, 0x73, 0x69, 0x6c,
	0x65, 0x6e, 0x74, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x18, 0xfc,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x04, 0x52, 0x2b, 0x78, 0x6c, 0x61, 0x55, 0x6e, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x43, 0x72, 0x61, 0x73, 0x68, 0x4f, 0x6e, 0x48, 0x6c,
	0x6f, 0x50, 0x61, 0x73, 0x73, 0x53, 0x69, 0x6c, 0x65, 0x6e, 0x74, 0x48, 0x6c, 0x6f, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x88, 0x01, 0x01, 0x12, 0x5e, 0x0a, 0x2a, 0x78, 0x6c, 0x61, 0x5f, 0x63,
	0x70, 0x75, 0x5f, 0x63, 0x6f, 0x70, 0x79, 0x5f, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x18, 0xd1, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x05, 0x52, 0x24,
	0x78, 0x6c, 0x61, 0x43, 0x70, 0x75, 0x43, 0x6f, 0x70, 0x79, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74,
	0x69, 0x6f, 0x6e, 0x55, 0x73, 0x65, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x88, 0x01, 0x01, 0x12, 0x50, 0x0a, 0x22, 0x78, 0x6c, 0x61, 0x5f, 0x63,
	0x70, 0x75, 0x5f, 0x65, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x8b, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x48, 0x06, 0x52, 0x1e, 0x78, 0x6c, 0x61, 0x43, 0x70, 0x75, 0x45, 0x6d,
	0x69, 0x74, 0x74, 0x65, 0x72, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x67, 0x0a, 0x2e, 0x78, 0x6c, 0x61,
	0x5f, 0x63, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x65,
	0x64, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x18, 0xb3, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x07, 0x52, 0x29, 0x78, 0x6c, 0x61, 0x43, 0x70, 0x75, 0x45, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x4f, 0x70, 0x74,
	0x69, 0x6d, 0x69, 0x7a, 0x65, 0x64, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x88,
	0x01, 0x01, 0x12, 0x3b, 0x0a, 0x18, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x66, 0x61, 0x73, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x68, 0x18, 0x63,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x08, 0x52, 0x14, 0x78, 0x6c, 0x61, 0x43, 0x70, 0x75, 0x45, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x46, 0x61, 0x73, 0x74, 0x4d, 0x61, 0x74, 0x68, 0x88, 0x01, 0x01, 0x12,
	0x41, 0x0a, 0x1b, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x66, 0x61, 0x73, 0x74, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x6d, 0x61, 0x78, 0x18, 0x8c,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x09, 0x52, 0x16, 0x78, 0x6c, 0x61, 0x43, 0x70, 0x75, 0x45,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x61, 0x73, 0x74, 0x4d, 0x69, 0x6e, 0x4d, 0x61, 0x78, 0x88,
	0x01, 0x01, 0x12, 0x59, 0x0a, 0x27, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x65, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x6f, 0x6e, 0x65, 0x64, 0x6e,
	0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x18, 0x9c, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x0a, 0x52, 0x22, 0x78, 0x6c, 0x61, 0x43, 0x70, 0x75, 0x45, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x4f, 0x6e, 0x65, 0x64, 0x6e, 0x6e,
	0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x61, 0x6c, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x79, 0x0a,
	0x27, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x6f, 0x6e, 0x65, 0x64, 0x6e, 0x6e, 0x5f, 0x66, 0x75, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x8f, 0x03, 0x20, 0x03, 0x28, 0x0e, 0x32,
	0x23, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x44, 0x65, 0x62, 0x75, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x46, 0x75, 0x73, 0x69, 0x6f, 0x6e,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x22, 0x78, 0x6c, 0x61, 0x43, 0x70, 0x75, 0x45, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x4f, 0x6e, 0x65, 0x64, 0x6e, 0x6e, 0x46, 0x75,
	0x73, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x73, 0x0a, 0x24, 0x78, 0x6c, 0x61, 0x5f,
	0x63, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c,
	0x5f, 0x78, 0x6e, 0x6e, 0x5f, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x90, 0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x44, 0x65,
	0x62, 0x75, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4c, 0x69, 0x62, 0x72, 0x61,
	0x72, 0x79, 0x46, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x1f, 0x78, 0x6c,
	0x61, 0x43, 0x70, 0x75, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c,
	0x58, 0x6e, 0x6e, 0x46, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x84, 0x01,
	0x0a, 0x2a, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x78, 0x6e, 0x6e, 0x5f, 0x67, 0x72, 0x61, 0x70, 0x68,
	0x5f, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0xed, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x44, 0x65, 0x62, 0x75, 0x67, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x58, 0x6e, 0x6e, 0x47, 0x72, 0x61, 0x70, 0x68, 0x46,
	0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x48, 0x0b, 0x52, 0x24, 0x78, 0x6c, 0x61,
	0x43, 0x70, 0x75, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x58,
	0x6e, 0x6e, 0x47, 0x72, 0x61, 0x70, 0x68, 0x46, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64,
	0x65, 0x88, 0x01, 0x01, 0x12, 0x4a, 0x0a, 0x20, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f,
	0x66, 0x61, 0x73, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x68, 0x5f, 0x68, 0x6f, 0x6e, 0x6f, 0x72, 0x5f,
	0x64, 0x69, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x7e, 0x20, 0x01, 0x28, 0x08, 0x48, 0x0c,
	0x52, 0x1b, 0x78, 0x6c, 0x61, 0x43, 0x70, 0x75, 0x46, 0x61, 0x73, 0x74, 0x4d, 0x61, 0x74, 0x68,
	0x48, 0x6f, 0x6e, 0x6f, 0x72, 0x44, 0x69, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01,
	0x12, 0x4d, 0x0a, 0x21, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x66, 0x61, 0x73, 0x74,
	0x5f, 0x6d, 0x61, 0x74, 0x68, 0x5f, 0x68, 0x6f, 0x6e, 0x6f, 0x72, 0x5f, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x81, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x0d, 0x52, 0x1c,
	0x78, 0x6c, 0x61, 0x43, 0x70, 0x75, 0x46, 0x61, 0x73, 0x74, 0x4d, 0x61, 0x74, 0x68, 0x48, 0x6f,
	0x6e, 0x6f, 0x72, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12,
	0x42, 0x0a, 0x1c, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x66, 0x61, 0x73, 0x74, 0x5f,
	0x6d, 0x61, 0x74, 0x68, 0x5f, 0x68, 0x6f, 0x6e, 0x6f, 0x72, 0x5f, 0x69, 0x6e, 0x66, 0x73, 0x18,
	0x79, 0x20, 0x01, 0x28, 0x08, 0x48, 0x0e, 0x52, 0x17, 0x78, 0x6c, 0x61, 0x43, 0x70, 0x75, 0x46,
	0x61, 0x73, 0x74, 0x4d, 0x61, 0x74, 0x68, 0x48, 0x6f, 0x6e, 0x6f, 0x72, 0x49, 0x6e, 0x66, 0x73,
	0x88, 0x01, 0x01, 0x12, 0x42, 0x0a, 0x1c, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x66,
	0x61, 0x73, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x68, 0x5f, 0x68, 0x6f, 0x6e, 0x6f, 0x72, 0x5f, 0x6e,
	0x61, 0x6e, 0x73, 0x18, 0x78, 0x20, 0x01, 0x28, 0x08, 0x48, 0x0f, 0x52, 0x17, 0x78, 0x6c, 0x61,
	0x43, 0x70, 0x75, 0x46, 0x61, 0x73, 0x74, 0x4d, 0x61, 0x74, 0x68, 0x48, 0x6f, 0x6e, 0x6f, 0x72,
	0x4e, 0x61, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x6e, 0x0a, 0x33, 0x78, 0x6c, 0x61, 0x5f, 0x63,
	0x70, 0x75, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x75, 0x6e, 0x69, 0x71,
	0x75, 0x65, 0x5f, 0x63, 0x5f, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x5f, 0x6b, 0x65, 0x72, 0x6e, 0x65,
	0x6c, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x18, 0xf4,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x10, 0x52, 0x2b, 0x78, 0x6c, 0x61, 0x43, 0x70, 0x75, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x43, 0x53, 0x74,
	0x79, 0x6c, 0x65, 0x4b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x50, 0x6f,
	0x69, 0x6e, 0x74, 0x73, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f, 0x78, 0x6c, 0x61, 0x5f, 0x63,
	0x70, 0x75, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x69, 0x73, 0x61, 0x18, 0xcd, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x11, 0x52, 0x0c, 0x78, 0x6c, 0x61, 0x43, 0x70, 0x75, 0x4d, 0x61, 0x78, 0x49, 0x73,
	0x61, 0x88, 0x01, 0x01, 0x12, 0x53, 0x0a, 0x24, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f,
	0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x67, 0x65, 0x6e,
	0x5f, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0xc3, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x48, 0x12, 0x52, 0x1f, 0x78, 0x6c, 0x61, 0x43, 0x70, 0x75, 0x50, 0x61, 0x72,
	0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x67, 0x65, 0x6e, 0x53, 0x70, 0x6c, 0x69,
	0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x42, 0x0a, 0x1b, 0x78, 0x6c, 0x61,
	0x5f, 0x63, 0x70, 0x75, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x5f, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0xb4, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48,
	0x13, 0x52, 0x17, 0x78, 0x6c, 0x61, 0x43, 0x70, 0x75, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x56,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x57, 0x69, 0x64, 0x74, 0x68, 0x88, 0x01, 0x01, 0x12, 0x42, 0x0a,
	0x1b, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x66, 0x75, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x72, 0x73, 0x18, 0xf8, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x48, 0x14, 0x52, 0x17, 0x78, 0x6c, 0x61, 0x43, 0x70, 0x75, 0x55, 0x73, 0x65,
	0x46, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x72, 0x73, 0x88, 0x01,
	0x01, 0x12, 0x33, 0x0a, 0x13, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x75, 0x73, 0x65,
	0x5f, 0x78, 0x6e, 0x6e, 0x70, 0x61, 0x63, 0x6b, 0x18, 0xe7, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48,
	0x15, 0x52, 0x10, 0x78, 0x6c, 0x61, 0x43, 0x70, 0x75, 0x55, 0x73, 0x65, 0x58, 0x6e, 0x6e, 0x70,
	0x61, 0x63, 0x6b, 0x88, 0x01, 0x01, 0x12, 0x35, 0x0a, 0x14, 0x78, 0x6c, 0x61, 0x5f, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x66, 0x61, 0x73, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x68, 0x18, 0xcf,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x16, 0x52, 0x11, 0x78, 0x6c, 0x61, 0x45, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x46, 0x61, 0x73, 0x74, 0x4d, 0x61, 0x74, 0x68, 0x88, 0x01, 0x01, 0x12, 0x50, 0x0a,
	0x22, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x75, 0x6e,
	0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x73, 0x18, 0x95, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x17, 0x52, 0x1e, 0x78, 0x6c,
	0x61, 0x44, 0x75, 0x6d, 0x70, 0x48, 0x6c, 0x6f, 0x55, 0x6e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69,
	0x7a, 0x65, 0x64, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x88, 0x01, 0x01, 0x12,
	0x4a, 0x0a, 0x1f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x72,
	0x69, 0x74, 0x68, 0x6d, 0x5f, 0x64, 0x65, 0x6e, 0x79, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x80, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x18, 0x52, 0x1b, 0x78, 0x6c, 0x61,
	0x47, 0x70, 0x75, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x44, 0x65, 0x6e, 0x79,
	0x6c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x74, 0x68, 0x88, 0x01, 0x01, 0x12, 0x5e, 0x0a, 0x2a, 0x78,
	0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x67, 0x61, 0x74, 0x68, 0x65,
	0x72, 0x5f, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68,
	0x6f, 0x6c, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0xd4, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x48, 0x19, 0x52, 0x24, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x41, 0x6c, 0x6c, 0x47, 0x61, 0x74,
	0x68, 0x65, 0x72, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68,
	0x6f, 0x6c, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x6e, 0x0a, 0x33, 0x78,
	0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x64, 0x75, 0x63,
	0x65, 0x5f, 0x62, 0x6c, 0x75, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75,
	0x6d, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x68, 0x6f,
	0x73, 0x74, 0x18, 0x9f, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x1a, 0x52, 0x2b, 0x78, 0x6c, 0x61,
	0x47, 0x70, 0x75, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x64, 0x75, 0x63, 0x65, 0x42, 0x6c, 0x75, 0x65,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x4e, 0x75, 0x6d, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x50, 0x65, 0x72, 0x48, 0x6f, 0x73, 0x74, 0x88, 0x01, 0x01, 0x12, 0x5e, 0x0a, 0x2a, 0x78,
	0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x64, 0x75, 0x63,
	0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68,
	0x6f, 0x6c, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x9d, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x48, 0x1b, 0x52, 0x24, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x64,
	0x75, 0x63, 0x65, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68,
	0x6f, 0x6c, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x9e, 0x01, 0x0a, 0x2c,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x61, 0x6c, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x65, 0x73, 0x74, 0x69, 0x6d,
	0x61, 0x74, 0x6f, 0x72, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0xe5, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x44, 0x65, 0x62, 0x75, 0x67, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x58, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x45, 0x73,
	0x74, 0x69, 0x6d, 0x61, 0x74, 0x6f, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x27, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x61, 0x6c, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x45, 0x73, 0x74, 0x69,
	0x6d, 0x61, 0x74, 0x6f, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2f, 0x0a, 0x11,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x64, 0x6f,
	0x74, 0x18, 0xc1, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x1c, 0x52, 0x0e, 0x78, 0x6c, 0x61, 0x47,
	0x70, 0x75, 0x41, 0x73, 0x79, 0x6e, 0x63, 0x44, 0x6f, 0x74, 0x88, 0x01, 0x01, 0x12, 0x67, 0x0a,
	0x2f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x73, 0x70,
	0x6d, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f,
	0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x62,
	0x18, 0xe0, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x1d, 0x52, 0x28, 0x78, 0x6c, 0x61, 0x47, 0x70,
	0x75, 0x41, 0x75, 0x74, 0x6f, 0x53, 0x70, 0x6d, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x42, 0x75, 0x64, 0x67, 0x65,
	0x74, 0x47, 0x62, 0x88, 0x01, 0x01, 0x12, 0x6d, 0x0a, 0x32, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70,
	0x75, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x73, 0x70, 0x6d, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f,
	0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x18, 0xe1, 0x01, 0x20,
	0x01, 0x28, 0x02, 0x48, 0x1e, 0x52, 0x2b, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x41, 0x75, 0x74,
	0x6f, 0x53, 0x70, 0x6d, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e,
	0x67, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x52, 0x61, 0x74,
	0x69, 0x6f, 0x88, 0x01, 0x01, 0x12, 0x40, 0x0a, 0x1a, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75,
	0x5f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x5f, 0x67, 0x65, 0x6d, 0x6d, 0x5f, 0x72,
	0x74, 0x6f, 0x6c, 0x18, 0xbc, 0x02, 0x20, 0x01, 0x28, 0x02, 0x48, 0x1f, 0x52, 0x16, 0x78, 0x6c,
	0x61, 0x47, 0x70, 0x75, 0x41, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x47, 0x65, 0x6d, 0x6d,
	0x52, 0x74, 0x6f, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x38, 0x0a, 0x16, 0x78, 0x6c, 0x61, 0x5f, 0x67,
	0x70, 0x75, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x5f, 0x6c, 0x65, 0x76, 0x65,
	0x6c, 0x18, 0x7b, 0x20, 0x01, 0x28, 0x05, 0x48, 0x20, 0x52, 0x13, 0x78, 0x6c, 0x61, 0x47, 0x70,
	0x75, 0x41, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x88, 0x01,
	0x01, 0x12, 0x48, 0x0a, 0x1e, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x61, 0x75, 0x74,
	0x6f, 0x74, 0x75, 0x6e, 0x65, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0xa0, 0x02, 0x20, 0x01, 0x28, 0x03, 0x48, 0x21, 0x52, 0x1a, 0x78, 0x6c,
	0x61, 0x47, 0x70, 0x75, 0x41, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x4d, 0x61, 0x78, 0x53,
	0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x4b, 0x0a, 0x20, 0x78,
	0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x5f, 0x63,
	0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18,
	0xf0, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x22, 0x52, 0x1b, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75,
	0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x43, 0x6f, 0x73, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x88, 0x01, 0x01, 0x12, 0x52, 0x0a, 0x23, 0x78, 0x6c, 0x61, 0x5f,
	0x67, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x69,
	0x6e, 0x66, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x18,
	0xcd, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x23, 0x52, 0x1f, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75,
	0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x49, 0x6e, 0x66, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x88, 0x01, 0x01, 0x12, 0x6e, 0x0a, 0x32,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x62, 0x69,
	0x6e, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x5f, 0x62, 0x79, 0x74,
	0x65, 0x73, 0x18, 0xfa, 0x02, 0x20, 0x01, 0x28, 0x03, 0x48, 0x24, 0x52, 0x2c, 0x78, 0x6c, 0x61,
	0x47, 0x70, 0x75, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x50, 0x65, 0x72,
	0x6d, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73,
	0x68, 0x6f, 0x6c, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x69, 0x0a, 0x2f,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x64, 0x65, 0x63, 0x6f, 0x6d,
	0x70, 0x6f, 0x73, 0x65, 0x72, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18,
	0xed, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x25, 0x52, 0x2a, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75,
	0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x75, 0x74,
	0x65, 0x44, 0x65, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65, 0x72, 0x54, 0x68, 0x72, 0x65, 0x73,
	0x68, 0x6f, 0x6c, 0x64, 0x88, 0x01, 0x01, 0x12, 0x5f, 0x0a, 0x2a, 0x78, 0x6c, 0x61, 0x5f, 0x67,
	0x70, 0x75, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x73, 0x5f, 0x75,
	0x73, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6c,
	0x69, 0x71, 0x75, 0x65, 0x73, 0x18, 0xe2, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x26, 0x52, 0x25,
	0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x73, 0x55, 0x73, 0x65, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x43, 0x6c,
	0x69, 0x71, 0x75, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x86, 0x01, 0x0a, 0x26, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x62, 0x75, 0x66,
	0x66, 0x65, 0x72, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x6d,
	0x6f, 0x64, 0x65, 0x18, 0x94, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x78, 0x6c, 0x61,
	0x2e, 0x44, 0x65, 0x62, 0x75, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x43, 0x6f,
	0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x53, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x48, 0x27, 0x52, 0x21, 0x78, 0x6c, 0x61,
	0x47, 0x70, 0x75, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72,
	0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x51, 0x0a, 0x23, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x75, 0x6e, 0x72, 0x6f,
	0x6c, 0x6c, 0x5f, 0x6c, 0x6f, 0x6f, 0x70, 0x73, 0x18, 0x9b, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48,
	0x28, 0x52, 0x1e, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64,
	0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x55, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x4c, 0x6f, 0x6f, 0x70,
	0x73, 0x88, 0x01, 0x01, 0x12, 0x5e, 0x0a, 0x2a, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x63, 0x6f, 0x70, 0x79, 0x5f, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75,
	0x73, 0x65, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x18, 0xec, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x29, 0x52, 0x24, 0x78, 0x6c, 0x61,
	0x47, 0x70, 0x75, 0x43, 0x6f, 0x70, 0x79, 0x49, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x69, 0x6f, 0x6e,
	0x55, 0x73, 0x65, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x88, 0x01, 0x01, 0x12, 0x56, 0x0a, 0x26, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x63, 0x72, 0x61, 0x73, 0x68, 0x5f, 0x6f, 0x6e, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x73, 0x18, 0x65,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x2a, 0x52, 0x21, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x43, 0x72,
	0x61, 0x73, 0x68, 0x4f, 0x6e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x3b, 0x0a, 0x17,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x63, 0x75, 0x62, 0x6c, 0x61, 0x73, 0x5f, 0x66,
	0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x18, 0xf7, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x2b,
	0x52, 0x14, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x43, 0x75, 0x62, 0x6c, 0x61, 0x73, 0x46, 0x61,
	0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x88, 0x01, 0x01, 0x12, 0x35, 0x0a, 0x15, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x63, 0x75, 0x64, 0x61, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x64,
	0x69, 0x72, 0x18, 0x3d, 0x20, 0x01, 0x28, 0x09, 0x48, 0x2c, 0x52, 0x11, 0x78, 0x6c, 0x61, 0x47,
	0x70, 0x75, 0x43, 0x75, 0x64, 0x61, 0x44, 0x61, 0x74, 0x61, 0x44, 0x69, 0x72, 0x88, 0x01, 0x01,
	0x12, 0x49, 0x0a, 0x1f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x63, 0x75, 0x64, 0x6e,
	0x6e, 0x5f, 0x67, 0x65, 0x6d, 0x6d, 0x5f, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x65,
	0x76, 0x65, 0x6c, 0x18, 0x9d, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x2d, 0x52, 0x1a, 0x78, 0x6c,
	0x61, 0x47, 0x70, 0x75, 0x43, 0x75, 0x64, 0x6e, 0x6e, 0x47, 0x65, 0x6d, 0x6d, 0x46, 0x75, 0x73,
	0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x43, 0x0a, 0x1c, 0x78,
	0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x63, 0x75, 0x64, 0x6e, 0x6e, 0x5f, 0x67, 0x65, 0x6d,
	0x6d, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x73, 0x18, 0xbe, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x48, 0x2e, 0x52, 0x17, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x43, 0x75, 0x64, 0x6e,
	0x6e, 0x47, 0x65, 0x6d, 0x6d, 0x4d, 0x61, 0x78, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x88, 0x01, 0x01,
	0x12, 0x3f, 0x0a, 0x19, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x64, 0x65, 0x74, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x69, 0x63, 0x5f, 0x6f, 0x70, 0x73, 0x18, 0x94, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x2f, 0x52, 0x16, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x44, 0x65,
	0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x69, 0x63, 0x4f, 0x70, 0x73, 0x88, 0x01,
	0x01, 0x12, 0x6d, 0x0a, 0x21, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x64, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x73, 0x18, 0xa1, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x22, 0x2e,
	0x78, 0x6c, 0x61, 0x2e, 0x44, 0x65, 0x62, 0x75, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x4f, 0x70, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x1d, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x41, 0x73, 0x79, 0x6e, 0x63, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x73,
	0x12, 0x53, 0x0a, 0x24, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x64, 0x69, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x67, 0x70, 0x75, 0x61, 0x73, 0x6d, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6d,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x67, 0x20, 0x01, 0x28, 0x08, 0x48, 0x30,
	0x52, 0x20, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x47,
	0x70, 0x75, 0x61, 0x73, 0x6d, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x49, 0x0a, 0x1f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75,
	0x5f, 0x64, 0x6f, 0x74, 0x5f, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x72, 0x5f, 0x74, 0x68, 0x72, 0x65,
	0x73, 0x68, 0x6f, 0x6c, 0x64, 0x5f, 0x6d, 0x62, 0x18, 0xcb, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48,
	0x31, 0x52, 0x1a, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x44, 0x6f, 0x74, 0x4d, 0x65, 0x72, 0x67,
	0x65, 0x72, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x4d, 0x62, 0x88, 0x01, 0x01,
	0x12, 0x45, 0x0a, 0x1d, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x64, 0x75, 0x6d, 0x70,
	0x5f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x5f, 0x74,
	0x6f, 0x18, 0xa4, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x32, 0x52, 0x18, 0x78, 0x6c, 0x61, 0x47,
	0x70, 0x75, 0x44, 0x75, 0x6d, 0x70, 0x41, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x4c, 0x6f,
	0x67, 0x73, 0x54, 0x6f, 0x88, 0x01, 0x01, 0x12, 0x4b, 0x0a, 0x20, 0x78, 0x6c, 0x61, 0x5f, 0x67,
	0x70, 0x75, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x5f, 0x74, 0x6f, 0x18, 0xde, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x33, 0x52, 0x1b, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x44, 0x75, 0x6d, 0x70,
	0x41, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x54,
	0x6f, 0x88, 0x01, 0x01, 0x12, 0x51, 0x0a, 0x23, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x64, 0x75, 0x6d, 0x70, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x64, 0x5f, 0x67,
	0x65, 0x6d, 0x6d, 0x5f, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0xe8, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x34, 0x52, 0x1e, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x44, 0x75, 0x6d, 0x70,
	0x41, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x64, 0x47, 0x65, 0x6d, 0x6d, 0x46, 0x75, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a, 0x13, 0x78, 0x6c, 0x61, 0x5f, 0x67,
	0x70, 0x75, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x6c, 0x6c, 0x76, 0x6d, 0x69, 0x72, 0x18, 0x9b,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x35, 0x52, 0x10, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x44,
	0x75, 0x6d, 0x70, 0x4c, 0x6c, 0x76, 0x6d, 0x69, 0x72, 0x88, 0x01, 0x01, 0x12, 0x59, 0x0a, 0x28,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61,
	0x6c, 0x6c, 0x5f, 0x67, 0x61, 0x74, 0x68, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e,
	0x65, 0x5f, 0x62, 0x79, 0x5f, 0x64, 0x69, 0x6d, 0x18, 0xfe, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48,
	0x36, 0x52, 0x21, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41,
	0x6c, 0x6c, 0x47, 0x61, 0x74, 0x68, 0x65, 0x72, 0x43, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x42,
	0x79, 0x44, 0x69, 0x6d, 0x88, 0x01, 0x01, 0x12, 0x61, 0x0a, 0x2b, 0x78, 0x6c, 0x61, 0x5f, 0x67,
	0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x61, 0x6c, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x65, 0x73, 0x74,
	0x69, 0x6d, 0x61, 0x74, 0x6f, 0x72, 0x18, 0xff, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x37, 0x52,
	0x26, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x45, 0x73,
	0x74, 0x69, 0x6d, 0x61, 0x74, 0x6f, 0x72, 0x88, 0x01, 0x01, 0x12, 0x68, 0x0a, 0x2f, 0x78, 0x6c,
	0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x73, 0x6f, 0x6c, 0x5f, 0x6c, 0x61, 0x74, 0x65,
	0x6e, 0x63, 0x79, 0x5f, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x6f, 0x72, 0x18, 0xe4, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x38, 0x52, 0x29, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x53, 0x6f,
	0x6c, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x6f,
	0x72, 0x88, 0x01, 0x01, 0x12, 0x5b, 0x0a, 0x28, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x5f, 0x63, 0x6f,
	0x73, 0x74, 0x6c, 0x79, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x73,
	0x18, 0xb1, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x39, 0x52, 0x23, 0x78, 0x6c, 0x61, 0x47, 0x70,
	0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x43, 0x6f, 0x73,
	0x74, 0x6c, 0x79, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x73, 0x88, 0x01,
	0x01, 0x12, 0x69, 0x0a, 0x1d, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x62, 0x75, 0x66, 0x66,
	0x65, 0x72, 0x18, 0x82, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x78, 0x6c, 0x61, 0x2e,
	0x44, 0x65, 0x62, 0x75, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x43, 0x6f, 0x6d,
	0x6d, 0x61, 0x6e, 0x64, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x43, 0x6d, 0x64, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x19, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x12, 0x45, 0x0a, 0x1d,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63,
	0x75, 0x62, 0x5f, 0x72, 0x61, 0x64, 0x69, 0x78, 0x5f, 0x73, 0x6f, 0x72, 0x74, 0x18, 0x83, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x3a, 0x52, 0x18, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x43, 0x75, 0x62, 0x52, 0x61, 0x64, 0x69, 0x78, 0x53, 0x6f, 0x72, 0x74,
	0x88, 0x01, 0x01, 0x12, 0x3b, 0x0a, 0x17, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x75, 0x62, 0x6c, 0x61, 0x73, 0x6c, 0x74, 0x18, 0xa6,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x3b, 0x52, 0x14, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x75, 0x62, 0x6c, 0x61, 0x73, 0x6c, 0x74, 0x88, 0x01, 0x01,
	0x12, 0x70, 0x0a, 0x33, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x63, 0x75, 0x64, 0x6e, 0x6e, 0x5f, 0x69, 0x6e, 0x74, 0x38, 0x78, 0x33, 0x32,
	0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x18, 0xbd, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x3c,
	0x52, 0x2d, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x75,
	0x64, 0x6e, 0x6e, 0x49, 0x6e, 0x74, 0x38, 0x78, 0x33, 0x32, 0x43, 0x6f, 0x6e, 0x76, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x88,
	0x01, 0x01, 0x12, 0x49, 0x0a, 0x1f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x75, 0x64, 0x6e, 0x6e, 0x5f, 0x6c, 0x61, 0x79, 0x65, 0x72,
	0x5f, 0x6e, 0x6f, 0x72, 0x6d, 0x18, 0x86, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x3d, 0x52, 0x1a,
	0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x75, 0x64, 0x6e,
	0x6e, 0x4c, 0x61, 0x79, 0x65, 0x72, 0x4e, 0x6f, 0x72, 0x6d, 0x88, 0x01, 0x01, 0x12, 0x50, 0x0a,
	0x23, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x5f, 0x73, 0x6c, 0x69, 0x63, 0x65, 0x5f, 0x66, 0x75,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x69, 0x20, 0x01, 0x28, 0x08, 0x48, 0x3e, 0x52, 0x1e, 0x78, 0x6c,
	0x61, 0x47, 0x70, 0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x44, 0x79, 0x6e, 0x61, 0x6d, 0x69,
	0x63, 0x53, 0x6c, 0x69, 0x63, 0x65, 0x46, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12,
	0x40, 0x0a, 0x1b, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x66, 0x61, 0x73, 0x74, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x6d, 0x61, 0x78, 0x18, 0x64,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x3f, 0x52, 0x16, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x46, 0x61, 0x73, 0x74, 0x4d, 0x69, 0x6e, 0x4d, 0x61, 0x78, 0x88, 0x01,
	0x01, 0x12, 0x62, 0x0a, 0x2c, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x68, 0x69, 0x67, 0x68, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x72, 0x69, 0x6f,
	0x72, 0x69, 0x74, 0x79, 0x5f, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x18, 0xd8, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x40, 0x52, 0x26, 0x78, 0x6c, 0x61, 0x47,
	0x70, 0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x48, 0x69, 0x67, 0x68, 0x65, 0x73, 0x74, 0x50,
	0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x41, 0x73, 0x79, 0x6e, 0x63, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x88, 0x01, 0x01, 0x12, 0x55, 0x0a, 0x25, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75,
	0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x6d,
	0x6f, 0x72, 0x79, 0x5f, 0x6f, 0x66, 0x66, 0x6c, 0x6f, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x18, 0xa8,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x41, 0x52, 0x20, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x48, 0x6f, 0x73, 0x74, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x4f,
	0x66, 0x66, 0x6c, 0x6f, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x59, 0x0a, 0x27,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6c,
	0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x68, 0x69, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x18, 0xba, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x42,
	0x52, 0x22, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4c, 0x61,
	0x74, 0x65, 0x6e, 0x63, 0x79, 0x48, 0x69, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x4b, 0x0a, 0x1f, 0x78, 0x6c, 0x61, 0x5f, 0x67,
	0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6c, 0x69, 0x62, 0x6e, 0x76, 0x70,
	0x74, 0x78, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x72, 0x18, 0x8d, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x48, 0x43, 0x52, 0x1c, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x4c, 0x69, 0x62, 0x6e, 0x76, 0x70, 0x74, 0x78, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65,
	0x72, 0x88, 0x01, 0x01, 0x12, 0x6e, 0x0a, 0x32, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6c, 0x6c, 0x76, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70,
	0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x69, 0x73, 0x6d, 0x18, 0x8c, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x48, 0x44, 0x52, 0x2c, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x4c, 0x6c, 0x76, 0x6d, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x69,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x69, 0x73,
	0x6d, 0x88, 0x01, 0x01, 0x12, 0x5d, 0x0a, 0x27, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x63, 0x63, 0x6c, 0x5f, 0x63, 0x6c, 0x69, 0x71,
	0x75, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0xf4, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x48, 0x45, 0x52, 0x22, 0x78, 0x6c,
	0x61, 0x47, 0x70, 0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x63, 0x63, 0x6c, 0x43, 0x6c,
	0x69, 0x71, 0x75, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x88, 0x01, 0x01, 0x12, 0x4f, 0x0a, 0x22, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x63, 0x63, 0x6c, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x5f,
	0x73, 0x70, 0x6c, 0x69, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x90, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x48, 0x46, 0x52, 0x1d, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x4e, 0x63, 0x63, 0x6c, 0x43, 0x6f, 0x6d, 0x6d, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x88, 0x01, 0x01, 0x12, 0x4b, 0x0a, 0x20, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x63, 0x63, 0x6c, 0x5f, 0x75, 0x73, 0x65, 0x72,
	0x5f, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x73, 0x18, 0x8b, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48,
	0x47, 0x52, 0x1b, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4e,
	0x63, 0x63, 0x6c, 0x55, 0x73, 0x65, 0x72, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x73, 0x88, 0x01,
	0x01, 0x12, 0x51, 0x0a, 0x23, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x61, 0x6c,
	0x6c, 0x5f, 0x67, 0x61, 0x74, 0x68, 0x65, 0x72, 0x18, 0xe3, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48,
	0x48, 0x52, 0x1e, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x64, 0x41, 0x6c, 0x6c, 0x47, 0x61, 0x74, 0x68, 0x65,
	0x72, 0x88, 0x01, 0x01, 0x12, 0x51, 0x0a, 0x23, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x64,
	0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x64, 0x75, 0x63, 0x65, 0x18, 0xd9, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x49, 0x52, 0x1e, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x64, 0x41, 0x6c, 0x6c, 0x52, 0x65,
	0x64, 0x75, 0x63, 0x65, 0x88, 0x01, 0x01, 0x12, 0x58, 0x0a, 0x24, 0x78, 0x6c, 0x61, 0x5f, 0x67,
	0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x73, 0x18,
	0xef, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x48, 0x4a, 0x52, 0x20, 0x78, 0x6c,
	0x61, 0x47, 0x70, 0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x64, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x73, 0x88, 0x01,
	0x01, 0x12, 0x44, 0x0a, 0x1c, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x70, 0x32,
	0x70, 0x18, 0xf6, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x4b, 0x52, 0x18, 0x78, 0x6c, 0x61, 0x47,
	0x70, 0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x64, 0x50, 0x32, 0x70, 0x88, 0x01, 0x01, 0x12, 0x59, 0x0a, 0x27, 0x78, 0x6c, 0x61, 0x5f, 0x67,
	0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x64, 0x75, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x61, 0x74, 0x74,
	0x65, 0x72, 0x18, 0xe7, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x4c, 0x52, 0x22, 0x78, 0x6c, 0x61,
	0x47, 0x70, 0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x64, 0x52, 0x65, 0x64, 0x75, 0x63, 0x65, 0x53, 0x63, 0x61, 0x74, 0x74, 0x65, 0x72, 0x88,
	0x01, 0x01, 0x12, 0x64, 0x0a, 0x2d, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x66, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x65, 0x64,
	0x5f, 0x61, 0x72, 0x18, 0xd1, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x4d, 0x52, 0x27, 0x78, 0x6c,
	0x61, 0x47, 0x70, 0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x61, 0x73, 0x73, 0x6f,
	0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x74, 0x65, 0x64, 0x41, 0x72, 0x88, 0x01, 0x01, 0x12, 0x61, 0x0a, 0x2c, 0x78, 0x6c, 0x61, 0x5f,
	0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x64, 0x75, 0x63,
	0x65, 0x5f, 0x73, 0x63, 0x61, 0x74, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e,
	0x65, 0x5f, 0x62, 0x79, 0x5f, 0x64, 0x69, 0x6d, 0x18, 0x81, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48,
	0x4e, 0x52, 0x25, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x52,
	0x65, 0x64, 0x75, 0x63, 0x65, 0x53, 0x63, 0x61, 0x74, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6d, 0x62,
	0x69, 0x6e, 0x65, 0x42, 0x79, 0x44, 0x69, 0x6d, 0x88, 0x01, 0x01, 0x12, 0x5b, 0x0a, 0x28, 0x78,
	0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65,
	0x64, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x70, 0x69, 0x6c, 0x6f, 0x67, 0x75, 0x65,
	0x5f, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0xf3, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x4f,
	0x52, 0x23, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65,
	0x64, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x70, 0x69, 0x6c, 0x6f, 0x67, 0x75, 0x65, 0x46,
	0x75, 0x73, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x61, 0x0a, 0x2b, 0x78, 0x6c, 0x61, 0x5f,
	0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x63, 0x61, 0x74, 0x74,
	0x65, 0x72, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x6d, 0x5f, 0x65,
	0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x72, 0x18, 0xd9, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x50,
	0x52, 0x26, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x63,
	0x61, 0x74, 0x74, 0x65, 0x72, 0x44, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x6d,
	0x45, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x4a, 0x0a, 0x1f, 0x78,
	0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x73, 0x18, 0xa5,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x51, 0x52, 0x1b, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x68, 0x61, 0x72, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x74, 0x73, 0x88, 0x01, 0x01, 0x12, 0x4d, 0x0a, 0x21, 0x78, 0x6c, 0x61, 0x5f, 0x67,
	0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f,
	0x6b, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0xf1, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x48, 0x52, 0x52, 0x1c, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x4b, 0x41, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e,
	0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x40, 0x0a, 0x1a, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70,
	0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x72, 0x69, 0x74, 0x6f, 0x6e, 0x5f,
	0x67, 0x65, 0x6d, 0x6d, 0x18, 0xbc, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x53, 0x52, 0x16, 0x78,
	0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x72, 0x69, 0x74, 0x6f,
	0x6e, 0x47, 0x65, 0x6d, 0x6d, 0x88, 0x01, 0x01, 0x12, 0x5e, 0x0a, 0x2a, 0x78, 0x6c, 0x61, 0x5f,
	0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x77, 0x68, 0x69, 0x6c, 0x65,
	0x5f, 0x6c, 0x6f, 0x6f, 0x70, 0x5f, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x5f, 0x62, 0x75, 0x66,
	0x66, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x18, 0xf8, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x54, 0x52,
	0x24, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x57, 0x68, 0x69,
	0x6c, 0x65, 0x4c, 0x6f, 0x6f, 0x70, 0x44, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x42, 0x75, 0x66, 0x66,
	0x65, 0x72, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x70, 0x0a, 0x34, 0x78, 0x6c, 0x61, 0x5f,
	0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x77, 0x68, 0x69, 0x6c, 0x65,
	0x5f, 0x6c, 0x6f, 0x6f, 0x70, 0x5f, 0x72, 0x65, 0x64, 0x75, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x61,
	0x74, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0xcb, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x55, 0x52, 0x2c, 0x78, 0x6c, 0x61, 0x47, 0x70,
	0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x57, 0x68, 0x69, 0x6c, 0x65, 0x4c, 0x6f, 0x6f, 0x70,
	0x52, 0x65, 0x64, 0x75, 0x63, 0x65, 0x53, 0x63, 0x61, 0x74, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x64,
	0x65, 0x4d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x77, 0x0a, 0x23, 0x78, 0x6c,
	0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x77, 0x68, 0x69,
	0x6c, 0x65, 0x5f, 0x6c, 0x6f, 0x6f, 0x70, 0x5f, 0x75, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x69, 0x6e,
	0x67, 0x18, 0xa6, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x44,
	0x65, 0x62, 0x75, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x57, 0x68, 0x69, 0x6c,
	0x65, 0x4c, 0x6f, 0x6f, 0x70, 0x55, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x48, 0x56,
	0x52, 0x1e, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x57, 0x68,
	0x69, 0x6c, 0x65, 0x4c, 0x6f, 0x6f, 0x70, 0x55, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67,
	0x88, 0x01, 0x01, 0x12, 0x54, 0x0a, 0x24, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65,
	0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x6e, 0x6f, 0x6e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d,
	0x69, 0x6e, 0x69, 0x73, 0x74, 0x69, 0x63, 0x5f, 0x6f, 0x70, 0x73, 0x18, 0xa9, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x57, 0x52, 0x20, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x78, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x4e, 0x6f, 0x6e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x69, 0x73,
	0x74, 0x69, 0x63, 0x4f, 0x70, 0x73, 0x88, 0x01, 0x01, 0x12, 0x63, 0x0a, 0x2c, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75,
	0x74, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0xc8, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x48, 0x58, 0x52, 0x27, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x6f, 0x75, 0x74, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x88, 0x01, 0x01, 0x12, 0x64,
	0x0a, 0x2d, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x77, 0x61, 0x72, 0x6e, 0x5f, 0x73, 0x74, 0x75, 0x63, 0x6b, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18,
	0xc7, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x59, 0x52, 0x27, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x57, 0x61, 0x72, 0x6e, 0x53, 0x74,
	0x75, 0x63, 0x6b, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64,
	0x73, 0x88, 0x01, 0x01, 0x12, 0x4c, 0x0a, 0x20, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x65, 0x78, 0x68, 0x61, 0x75, 0x73, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x74, 0x69, 0x6c, 0x69, 0x6e,
	0x67, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x18, 0xdb, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48,
	0x5a, 0x52, 0x1c, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x78, 0x68, 0x61, 0x75, 0x73, 0x74,
	0x69, 0x76, 0x65, 0x54, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x88,
	0x01, 0x01, 0x12, 0x80, 0x01, 0x0a, 0x28, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x61, 0x75, 0x74, 0x6f,
	0x74, 0x75, 0x6e, 0x65, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18,
	0xc4, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x44, 0x65, 0x62,
	0x75, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x74, 0x75,
	0x6e, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x48, 0x5b, 0x52, 0x23, 0x78,
	0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x6c, 0x41, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x4d, 0x6f,
	0x64, 0x65, 0x88, 0x01, 0x01, 0x12, 0x5b, 0x0a, 0x28, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75,
	0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x61, 0x75,
	0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x64, 0x69,
	0x72, 0x18, 0x97, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x5c, 0x52, 0x23, 0x78, 0x6c, 0x61, 0x47,
	0x70, 0x75, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x41, 0x75,
	0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x72, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x69, 0x72, 0x88,
	0x01, 0x01, 0x12, 0x76, 0x0a, 0x36, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x73, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0xf6, 0x02, 0x20,
	0x01, 0x28, 0x03, 0x48, 0x5d, 0x52, 0x30, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x43, 0x73, 0x65, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x54, 0x68,
	0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x88, 0x01, 0x01, 0x12, 0x68, 0x0a, 0x2f, 0x78, 0x6c,
	0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x65,
	0x72, 0x66, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0xf9, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x5e, 0x52, 0x29, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x50, 0x65, 0x72, 0x66, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x61, 0x74,
	0x68, 0x88, 0x01, 0x01, 0x12, 0x65, 0x0a, 0x2d, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x64, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x5f, 0x6c, 0x69, 0x62, 0x72,
	0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0xc9, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x5f, 0x52, 0x28,
	0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x6c, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x4c,
	0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x57, 0x0a, 0x26, 0x78,
	0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x6c, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x66, 0x64, 0x6f, 0x5f, 0x70, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0xd2, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x60, 0x52, 0x21,
	0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x6c, 0x44, 0x75, 0x6d, 0x70, 0x46, 0x64, 0x6f, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x73, 0x88, 0x01, 0x01, 0x12, 0x72, 0x0a, 0x34, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x61, 0x6c, 0x6c, 0x74, 0x6f, 0x61, 0x6c, 0x6c, 0x5f, 0x77, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x65, 0x69, 0x6e, 0x73, 0x75, 0x6d, 0x18, 0xe8, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x48, 0x61, 0x52, 0x2e, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41,
	0x6c, 0x6c, 0x74, 0x6f, 0x61, 0x6c, 0x6c, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x65, 0x64, 0x45,
	0x69, 0x6e, 0x73, 0x75, 0x6d, 0x88, 0x01, 0x01, 0x12, 0x71, 0x0a, 0x34, 0x78, 0x6c, 0x61, 0x5f,
	0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c,
	0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x5f,
	0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x6f, 0x6e, 0x5f, 0x74, 0x68, 0x75, 0x6e, 0x6b, 0x73,
	0x18, 0x8a, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x62, 0x52, 0x2d, 0x78, 0x6c, 0x61, 0x47, 0x70,
	0x75, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x45, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72,
	0x4f, 0x6e, 0x54, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x88, 0x01, 0x01, 0x12, 0x63, 0x0a, 0x2c, 0x78,
	0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x6c, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x66, 0x75, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x72, 0x18, 0x99, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x63, 0x52, 0x27, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x75,
	0x73, 0x69, 0x6f, 0x6e, 0x41, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x72, 0x88, 0x01, 0x01,
	0x12, 0x77, 0x0a, 0x37, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x6c, 0x65, 0x76,
	0x65, 0x6c, 0x5f, 0x72, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x72, 0x18, 0xce, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x64, 0x52, 0x30, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x75,
	0x73, 0x69, 0x6f, 0x6e, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x65,
	0x77, 0x72, 0x69, 0x74, 0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x7e, 0x0a, 0x3a, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x6c, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x68, 0x65, 0x75, 0x72, 0x69, 0x73, 0x74,
	0x69, 0x63, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f,
	0x6d, 0x62, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0xee, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x65,
	0x52, 0x34, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x6c, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x48, 0x65, 0x75, 0x72, 0x69, 0x73,
	0x74, 0x69, 0x63, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6d,
	0x62, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x6e, 0x0a, 0x32, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x6c, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x63, 0x63, 0x6c, 0x5f, 0x73, 0x79,
	0x6d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x73, 0x18,
	0x96, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x66, 0x52, 0x2c, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75,
	0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x45, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x4e, 0x63, 0x63, 0x6c, 0x53, 0x79, 0x6d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x42,
	0x75, 0x66, 0x66, 0x65, 0x72, 0x73, 0x88, 0x01, 0x01, 0x12, 0x52, 0x0a, 0x23, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x6c, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x76, 0x73, 0x68, 0x6d, 0x65, 0x6d,
	0x18, 0x84, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x67, 0x52, 0x1f, 0x78, 0x6c, 0x61, 0x47, 0x70,
	0x75, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x45, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x4e, 0x76, 0x73, 0x68, 0x6d, 0x65, 0x6d, 0x88, 0x01, 0x01, 0x12, 0x60, 0x0a,
	0x2b, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x70, 0x6c,
	0x69, 0x74, 0x5f, 0x6b, 0x5f, 0x72, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x18, 0x82, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x48, 0x68, 0x52, 0x25, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53,
	0x70, 0x6c, 0x69, 0x74, 0x4b, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x82, 0x01, 0x0a, 0x3c, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x73, 0x75, 0x62, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x64, 0x65, 0x71, 0x75, 0x61,
	0x6e, 0x74, 0x69, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0xf0, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x69, 0x52, 0x36, 0x78, 0x6c, 0x61, 0x47, 0x70,
	0x75, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x45, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x53, 0x75, 0x62, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x44, 0x65, 0x71,
	0x75, 0x61, 0x6e, 0x74, 0x69, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x75, 0x73, 0x69, 0x6f,
	0x6e, 0x88, 0x01, 0x01, 0x12, 0x7f, 0x0a, 0x3b, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x74, 0x72, 0x69, 0x74, 0x6f, 0x6e, 0x5f, 0x68, 0x65, 0x72, 0x6f, 0x6c,
	0x65, 0x73, 0x73, 0x5f, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x66, 0x75, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0xd4, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x6a, 0x52, 0x34, 0x78, 0x6c,
	0x61, 0x47, 0x70, 0x75, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c,
	0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x72, 0x69, 0x74, 0x6f, 0x6e, 0x48, 0x65, 0x72, 0x6f,
	0x6c, 0x65, 0x73, 0x73, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x46, 0x75, 0x73, 0x69,
	0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x57, 0x0a, 0x26, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75,
	0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x72, 0x69, 0x74, 0x6f, 0x6e, 0x5f, 0x74, 0x6d, 0x61, 0x18,
	0xe3, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x6b, 0x52, 0x21, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75,
	0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x45, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x54, 0x72, 0x69, 0x74, 0x6f, 0x6e, 0x54, 0x6d, 0x61, 0x88, 0x01, 0x01, 0x12, 0x78,
	0x0a, 0x38, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x5f, 0x64, 0x6f, 0x74, 0x5f,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x5f, 0x61, 0x6c, 0x6f, 0x6e, 0x67, 0x5f, 0x6b,
	0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0xea, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x48, 0x6c, 0x52, 0x30, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x50, 0x61, 0x63, 0x6b, 0x44, 0x6f, 0x74, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x41, 0x6c, 0x6f, 0x6e, 0x67, 0x4b, 0x44, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x76, 0x0a, 0x36, 0x78, 0x6c, 0x61, 0x5f,
	0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x70, 0x5f, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x18, 0xd0, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x6d, 0x52, 0x30, 0x78, 0x6c, 0x61,
	0x47, 0x70, 0x75, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x50,
	0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x70, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x88, 0x01, 0x01,
	0x12, 0x9f, 0x01, 0x0a, 0x33, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x69, 0x73, 0x6d, 0x5f, 0x6f,
	0x70, 0x74, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0xdf, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2d, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x44, 0x65, 0x62, 0x75, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6c,
	0x6c, 0x65, 0x6c, 0x69, 0x73, 0x6d, 0x4f, 0x70, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x48, 0x6e,
	0x52, 0x2d, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x6c, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x50, 0x61, 0x72, 0x61,
	0x6c, 0x6c, 0x65, 0x6c, 0x69, 0x73, 0x6d, 0x4f, 0x70, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x88,
	0x01, 0x01, 0x12, 0x58, 0x0a, 0x26, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0xd6, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x48, 0x6f, 0x52, 0x22, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x59, 0x0a, 0x27,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e,
	0x65, 0x72, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x18, 0x8c, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x70,
	0x52, 0x22, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x6c, 0x55, 0x73, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x72,
	0x50, 0x61, 0x73, 0x73, 0x88, 0x01, 0x01, 0x12, 0x5e, 0x0a, 0x2a, 0x78, 0x6c, 0x61, 0x5f, 0x67,
	0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f,
	0x75, 0x73, 0x65, 0x5f, 0x72, 0x61, 0x67, 0x67, 0x65, 0x64, 0x5f, 0x64, 0x6f, 0x74, 0x5f, 0x66,
	0x75, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x91, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x71, 0x52, 0x24,
	0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x6c, 0x55, 0x73, 0x65, 0x52, 0x61, 0x67, 0x67, 0x65, 0x64, 0x44, 0x6f, 0x74, 0x46, 0x75,
	0x73, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x6b, 0x0a, 0x31, 0x78, 0x6c, 0x61, 0x5f, 0x67,
	0x70, 0x75, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x5f, 0x70, 0x74, 0x78, 0x5f, 0x63, 0x6f, 0x6d, 0x70,
	0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0xe1, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x48, 0x72, 0x52, 0x2a, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x46, 0x61, 0x69,
	0x6c, 0x50, 0x74, 0x78, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f,
	0x6e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x53, 0x70, 0x69, 0x6c, 0x6c, 0x69, 0x6e,
	0x67, 0x88, 0x01, 0x01, 0x12, 0x77, 0x0a, 0x37, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x5f, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x73, 0x5f, 0x73,
	0x70, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72,
	0x73, 0x5f, 0x6f, 0x6e, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x18,
	0xfa, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x73, 0x52, 0x30, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x4b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x73, 0x53, 0x70, 0x69,
	0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x73, 0x4f, 0x6e,
	0x41, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x77, 0x0a,
	0x37, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x66, 0x69, 0x72, 0x73, 0x74, 0x5f, 0x63,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x74,
	0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74,
	0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0x88, 0x03, 0x20, 0x01, 0x28, 0x05, 0x48,
	0x74, 0x52, 0x30, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x46, 0x69, 0x72, 0x73, 0x74, 0x43, 0x6f,
	0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x54, 0x65, 0x72, 0x6d,
	0x69, 0x6e, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x53, 0x65, 0x63, 0x6f,
	0x6e, 0x64, 0x73, 0x88, 0x01, 0x01, 0x12, 0x78, 0x0a, 0x38, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70,
	0x75, 0x5f, 0x66, 0x69, 0x72, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x77, 0x61, 0x72, 0x6e, 0x5f, 0x73, 0x74, 0x75,
	0x63, 0x6b, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x73, 0x18, 0x87, 0x03, 0x20, 0x01, 0x28, 0x05, 0x48, 0x75, 0x52, 0x30, 0x78, 0x6c, 0x61,
	0x47, 0x70, 0x75, 0x46, 0x69, 0x72, 0x73, 0x74, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x57, 0x61, 0x72, 0x6e, 0x53, 0x74, 0x75, 0x63, 0x6b, 0x54,
	0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x88, 0x01, 0x01,
	0x12, 0x56, 0x0a, 0x25, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x66, 0x6f, 0x72, 0x63,
	0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61,
	0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x69, 0x73, 0x6d, 0x18, 0x93, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x48, 0x76, 0x52, 0x21, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x46, 0x6f, 0x72, 0x63, 0x65, 0x43,
	0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6c, 0x6c,
	0x65, 0x6c, 0x69, 0x73, 0x6d, 0x88, 0x01, 0x01, 0x12, 0x39, 0x0a, 0x17, 0x78, 0x6c, 0x61, 0x5f,
	0x67, 0x70, 0x75, 0x5f, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x5f, 0x6e,
	0x63, 0x68, 0x77, 0x18, 0x7d, 0x20, 0x01, 0x28, 0x08, 0x48, 0x77, 0x52, 0x13, 0x78, 0x6c, 0x61,
	0x47, 0x70, 0x75, 0x46, 0x6f, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x4e, 0x63, 0x68, 0x77,
	0x88, 0x01, 0x01, 0x12, 0x3a, 0x0a, 0x17, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x66,
	0x6f, 0x72, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x5f, 0x6e, 0x68, 0x77, 0x63, 0x18, 0x92,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x78, 0x52, 0x13, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x46,
	0x6f, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x76, 0x4e, 0x68, 0x77, 0x63, 0x88, 0x01, 0x01, 0x12,
	0x23, 0x0a, 0x0b, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x66, 0x74, 0x7a, 0x18, 0x3e,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x79, 0x52, 0x09, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x46, 0x74,
	0x7a, 0x88, 0x01, 0x01, 0x12, 0x54, 0x0a, 0x25, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x66, 0x75, 0x73, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x75, 0x73, 0x65, 0x5f, 0x63, 0x75, 0x64, 0x6e, 0x6e, 0x5f, 0x72, 0x6e, 0x67, 0x18, 0xeb, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x7a, 0x52, 0x1f, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x46, 0x75,
	0x73, 0x65, 0x64, 0x41, 0x74, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x55, 0x73, 0x65, 0x43,
	0x75, 0x64, 0x6e, 0x6e, 0x52, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x51, 0x0a, 0x23, 0x78, 0x6c,
	0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x67, 0x65, 0x6d, 0x6d, 0x5f, 0x72, 0x65, 0x77, 0x72, 0x69,
	0x74, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c,
	0x64, 0x18, 0x9b, 0x02, 0x20, 0x01, 0x28, 0x03, 0x48, 0x7b, 0x52, 0x1e, 0x78, 0x6c, 0x61, 0x47,
	0x70, 0x75, 0x47, 0x65, 0x6d, 0x6d, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x88, 0x01, 0x01, 0x12, 0x42, 0x0a,
	0x1b, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x5f, 0x64, 0x65, 0x62, 0x75, 0x67, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0xdc, 0x02, 0x20,
	0x01, 0x28, 0x08, 0x48, 0x7c, 0x52, 0x17, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x44, 0x65, 0x62, 0x75, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x88, 0x01,
	0x01, 0x12, 0x40, 0x0a, 0x1a, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18,
	0xdd, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x7d, 0x52, 0x16, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6e, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x88, 0x01, 0x01, 0x12, 0x5b, 0x0a, 0x26, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x67,
	0x72, 0x61, 0x70, 0x68, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0xd7, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x48, 0x7e, 0x52, 0x21, 0x78, 0x6c, 0x61, 0x47,
	0x70, 0x75, 0x47, 0x72, 0x61, 0x70, 0x68, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6e,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01,
	0x12, 0x43, 0x0a, 0x1c, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x67, 0x72, 0x61, 0x70,
	0x68, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0xd0, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x7f, 0x52, 0x17, 0x78, 0x6c, 0x61, 0x47, 0x70,
	0x75, 0x47, 0x72, 0x61, 0x70, 0x68, 0x4d, 0x69, 0x6e, 0x47, 0x72, 0x61, 0x70, 0x68, 0x53, 0x69,
	0x7a, 0x65, 0x88, 0x01, 0x01, 0x12, 0x3f, 0x0a, 0x19, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75,
	0x5f, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x66, 0x69,
	0x6c, 0x65, 0x18, 0xb2, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x80, 0x01, 0x52, 0x15, 0x78, 0x6c,
	0x61, 0x47, 0x70, 0x75, 0x4b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x43, 0x61, 0x63, 0x68, 0x65, 0x46,
	0x69, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x64, 0x0a, 0x19, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70,
	0x75, 0x5f, 0x6c, 0x69, 0x62, 0x6e, 0x76, 0x6a, 0x69, 0x74, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6d,
	0x6f, 0x64, 0x65, 0x18, 0xd7, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x78, 0x6c, 0x61,
	0x2e, 0x44, 0x65, 0x62, 0x75, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4c, 0x69,
	0x62, 0x4e, 0x76, 0x4a, 0x69, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x4d, 0x6f, 0x64, 0x65, 0x48, 0x81,
	0x01, 0x52, 0x16, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x4c, 0x69, 0x62, 0x6e, 0x76, 0x6a, 0x69,
	0x74, 0x6c, 0x69, 0x6e, 0x6b, 0x4d, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2f, 0x0a, 0x14,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x6c, 0x6c, 0x76, 0x6d, 0x5f, 0x69, 0x72, 0x5f,
	0x66, 0x69, 0x6c, 0x65, 0x18, 0x96, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x78, 0x6c, 0x61,
	0x47, 0x70, 0x75, 0x4c, 0x6c, 0x76, 0x6d, 0x49, 0x72, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x4b, 0x0a,
	0x1f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x6c, 0x6c, 0x76, 0x6d, 0x5f, 0x76, 0x65,
	0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c,
	0x18, 0x80, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x82, 0x01, 0x52, 0x1b, 0x78, 0x6c, 0x61, 0x47,
	0x70, 0x75, 0x4c, 0x6c, 0x76, 0x6d, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x50, 0x0a, 0x22, 0x78, 0x6c,
	0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x74,
	0x75, 0x6e, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d,
	0x18, 0xdf, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x83, 0x01, 0x52, 0x1d, 0x78, 0x6c, 0x61, 0x47,
	0x70, 0x75, 0x4c, 0x6f, 0x61, 0x64, 0x41, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x88, 0x01, 0x01, 0x12, 0x4c, 0x0a, 0x20,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x6c,
	0x69, 0x6d, 0x69, 0x74, 0x5f, 0x73, 0x6c, 0x6f, 0x70, 0x5f, 0x66, 0x61, 0x63, 0x74, 0x6f, 0x72,
	0x18, 0x84, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x84, 0x01, 0x52, 0x1b, 0x78, 0x6c, 0x61, 0x47,
	0x70, 0x75, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x53, 0x6c, 0x6f,
	0x70, 0x46, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x88, 0x01, 0x01, 0x12, 0x3f, 0x0a, 0x19, 0x78, 0x6c,
	0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x6d, 0x6f, 0x63, 0x6b, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x73, 0x18, 0xf5, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x85,
	0x01, 0x52, 0x15, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x4d, 0x6f, 0x63, 0x6b, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x43, 0x61, 0x6c, 0x6c, 0x73, 0x88, 0x01, 0x01, 0x12, 0x58, 0x0a, 0x26, 0x78,
	0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x5f, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x65, 0x64, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x65,
	0x69, 0x6e, 0x73, 0x75, 0x6d, 0x18, 0x98, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x86, 0x01, 0x52,
	0x21, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x65, 0x64, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x65, 0x64, 0x45, 0x69, 0x6e, 0x73,
	0x75, 0x6d, 0x88, 0x01, 0x01, 0x12, 0x45, 0x0a, 0x1c, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75,
	0x5f, 0x6e, 0x63, 0x63, 0x6c, 0x5f, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x89, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x87, 0x01, 0x52,
	0x18, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x4e, 0x63, 0x63, 0x6c, 0x41, 0x73, 0x79, 0x6e, 0x63,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x53, 0x0a, 0x23,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x6e, 0x63, 0x63, 0x6c, 0x5f, 0x62, 0x6c, 0x6f,
	0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74,
	0x6f, 0x72, 0x73, 0x18, 0x86, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x88, 0x01, 0x52, 0x1f, 0x78,
	0x6c, 0x61, 0x47, 0x70, 0x75, 0x4e, 0x63, 0x63, 0x6c, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x88, 0x01,
	0x01, 0x12, 0x56, 0x0a, 0x25, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x6e, 0x63, 0x63,
	0x6c, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6d, 0x61, 0x78,
	0x5f, 0x6e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x18, 0x91, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x48, 0x89, 0x01, 0x52, 0x20, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x4e, 0x63, 0x63, 0x6c,
	0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x4d, 0x61, 0x78, 0x4e, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x88, 0x01, 0x01, 0x12, 0x5b, 0x0a, 0x29, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x6e, 0x63, 0x63, 0x6c, 0x5f, 0x69, 0x6e, 0x69, 0x74, 0x5f, 0x6d,
	0x61, 0x78, 0x5f, 0x72, 0x61, 0x6e, 0x6b, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x72, 0x6f, 0x6f, 0x74,
	0x5f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x18, 0x95, 0x02, 0x20, 0x01, 0x28, 0x03, 0x48, 0x8a, 0x01,
	0x52, 0x21, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x4e, 0x63, 0x63, 0x6c, 0x49, 0x6e, 0x69, 0x74,
	0x4d, 0x61, 0x78, 0x52, 0x61, 0x6e, 0x6b, 0x50, 0x65, 0x72, 0x52, 0x6f, 0x6f, 0x74, 0x52, 0x61,
	0x74, 0x69, 0x6f, 0x88, 0x01, 0x01, 0x12, 0x48, 0x0a, 0x1e, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70,
	0x75, 0x5f, 0x6e, 0x63, 0x63, 0x6c, 0x5f, 0x70, 0x32, 0x70, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x6e,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x18, 0x92, 0x02, 0x20, 0x01, 0x28, 0x03, 0x48,
	0x8b, 0x01, 0x52, 0x19, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x4e, 0x63, 0x63, 0x6c, 0x50, 0x32,
	0x70, 0x4d, 0x61, 0x78, 0x4e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x88, 0x01, 0x01,
	0x12, 0x4a, 0x0a, 0x1f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x6e, 0x63, 0x63, 0x6c,
	0x5f, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x5f, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x18, 0xad, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x8c, 0x01, 0x52, 0x1a, 0x78,
	0x6c, 0x61, 0x47, 0x70, 0x75, 0x4e, 0x63, 0x63, 0x6c, 0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61,
	0x74, 0x65, 0x4f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x88, 0x01, 0x01, 0x12, 0x5c, 0x0a, 0x28,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x6e, 0x63, 0x63, 0x6c, 0x5f, 0x74, 0x65, 0x72,
	0x6d, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74,
	0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x18, 0xa3, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48,
	0x8d, 0x01, 0x52, 0x23, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x4e, 0x63, 0x63, 0x6c, 0x54, 0x65,
	0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74,
	0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x88, 0x01, 0x01, 0x12, 0x70, 0x0a, 0x33, 0x78, 0x6c,
	0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x5f, 0x66, 0x6f,
	0x72, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x65, 0x69, 0x6e, 0x73, 0x75,
	0x6d, 0x18, 0xd3, 0x02, 0x20, 0x01, 0x28, 0x03, 0x48, 0x8e, 0x01, 0x52, 0x2c, 0x78, 0x6c, 0x61,
	0x47, 0x70, 0x75, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x6e, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x54,
	0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x46, 0x6f, 0x72, 0x57, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x65, 0x64, 0x45, 0x69, 0x6e, 0x73, 0x75, 0x6d, 0x88, 0x01, 0x01, 0x12, 0x4b, 0x0a, 0x1f,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65,
	0x5f, 0x67, 0x65, 0x6d, 0x6d, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x72, 0x18,
	0xa7, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x8f, 0x01, 0x52, 0x1b, 0x78, 0x6c, 0x61, 0x47, 0x70,
	0x75, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x47, 0x65, 0x6d, 0x6d, 0x41, 0x75, 0x74,
	0x6f, 0x74, 0x75, 0x6e, 0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x55, 0x0a, 0x25, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x61, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x64,
	0x69, 0x72, 0x18, 0xb6, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x90, 0x01, 0x52, 0x1f, 0x78, 0x6c,
	0x61, 0x47, 0x70, 0x75, 0x50, 0x65, 0x72, 0x46, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x75, 0x74,
	0x6f, 0x74, 0x75, 0x6e, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x44, 0x69, 0x72, 0x88, 0x01, 0x01,
	0x12, 0x6e, 0x0a, 0x1d, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x70, 0x67, 0x6c, 0x65,
	0x5f, 0x61, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x65,
	0x72, 0x18, 0xd5, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x44,
	0x65, 0x62, 0x75, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x50, 0x47, 0x4c, 0x45,
	0x53, 0x74, 0x72, 0x69, 0x63, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x48,
	0x91, 0x01, 0x52, 0x19, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x50, 0x67, 0x6c, 0x65, 0x41, 0x63,
	0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x65, 0x72, 0x88, 0x01, 0x01,
	0x12, 0x60, 0x0a, 0x2b, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x70, 0x67, 0x6c, 0x65,
	0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6f, 0x72,
	0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18,
	0xd2, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x92, 0x01, 0x52, 0x24, 0x78, 0x6c, 0x61, 0x47, 0x70,
	0x75, 0x50, 0x67, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x46, 0x69, 0x6c, 0x65,
	0x4f, 0x72, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x50, 0x61, 0x74, 0x68, 0x88,
	0x01, 0x01, 0x12, 0x27, 0x0a, 0x10, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x70, 0x74,
	0x78, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x7f, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x78, 0x6c,
	0x61, 0x47, 0x70, 0x75, 0x50, 0x74, 0x78, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x67, 0x0a, 0x2e, 0x78,
	0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x72, 0x65, 0x64, 0x75, 0x63, 0x65, 0x5f, 0x73, 0x63,
	0x61, 0x74, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x68,
	0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0xd5, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x48, 0x93, 0x01, 0x52, 0x28, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x52,
	0x65, 0x64, 0x75, 0x63, 0x65, 0x53, 0x63, 0x61, 0x74, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6d, 0x62,
	0x69, 0x6e, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x88, 0x01, 0x01, 0x12, 0x47, 0x0a, 0x1d, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x72, 0x65, 0x64, 0x7a, 0x6f, 0x6e, 0x65, 0x5f, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0xe4, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x94, 0x01, 0x52,
	0x19, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x52, 0x65, 0x64, 0x7a, 0x6f, 0x6e, 0x65, 0x50, 0x61,
	0x64, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x79, 0x74, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x65, 0x0a,
	0x2d, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
	0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x61, 0x6f, 0x74, 0x5f, 0x61, 0x75,
	0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x9c,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x95, 0x01, 0x52, 0x27, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75,
	0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x41,
	0x6f, 0x74, 0x41, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x88, 0x01, 0x01, 0x12, 0x49, 0x0a, 0x1e, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76,
	0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x6b, 0x18, 0xdb, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x96, 0x01,
	0x52, 0x1a, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x45,
	0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x4c, 0x6f, 0x63, 0x6b, 0x88, 0x01, 0x01, 0x12,
	0x55, 0x0a, 0x14, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x73, 0x68, 0x61, 0x70, 0x65,
	0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x18, 0xaa, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1d,
	0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x44, 0x65, 0x62, 0x75, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x53, 0x68, 0x61, 0x70, 0x65, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x48, 0x97, 0x01,
	0x52, 0x11, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x53, 0x68, 0x61, 0x70, 0x65, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x73, 0x88, 0x01, 0x01, 0x12, 0x3e, 0x0a, 0x18, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70,
	0x75, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x69,
	0x6e, 0x67, 0x18, 0xb0, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x98, 0x01, 0x52, 0x15, 0x78, 0x6c,
	0x61, 0x47, 0x70, 0x75, 0x53, 0x68, 0x61, 0x72, 0x64, 0x41, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e,
	0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x54, 0x0a, 0x24, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70,
	0x75, 0x5f, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x5f, 0x61, 0x6c,
	0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x5f, 0x70, 0x69, 0x63, 0x6b, 0x65, 0x72, 0x18, 0x9c,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x99, 0x01, 0x52, 0x1f, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75,
	0x53, 0x74, 0x72, 0x69, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69,
	0x74, 0x68, 0x6d, 0x50, 0x69, 0x63, 0x6b, 0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x49, 0x0a, 0x1e,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x85,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x9a, 0x01, 0x52, 0x1a, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x46, 0x69, 0x6c, 0x65,
	0x6e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x57, 0x0a, 0x26, 0x78, 0x6c, 0x61, 0x5f, 0x67,
	0x70, 0x75, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x5f, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x75,
	0x73, 0x65, 0x5f, 0x73, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x6f,
	0x72, 0x18, 0xb8, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x9b, 0x01, 0x52, 0x20, 0x78, 0x6c, 0x61,
	0x47, 0x70, 0x75, 0x54, 0x65, 0x6d, 0x70, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x55, 0x73, 0x65,
	0x53, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x88, 0x01, 0x01,
	0x12, 0x5d, 0x0a, 0x29, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x74, 0x68, 0x72, 0x65,
	0x73, 0x68, 0x6f, 0x6c, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77,
	0x65, 0x64, 0x5f, 0x65, 0x69, 0x6e, 0x73, 0x75, 0x6d, 0x5f, 0x6d, 0x69, 0x62, 0x18, 0x89, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x48, 0x9c, 0x01, 0x52, 0x23, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x54,
	0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x46, 0x6f, 0x72, 0x57, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x65, 0x64, 0x45, 0x69, 0x6e, 0x73, 0x75, 0x6d, 0x4d, 0x69, 0x62, 0x88, 0x01, 0x01, 0x12,
	0x3b, 0x0a, 0x17, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x74, 0x72, 0x69, 0x74, 0x6f,
	0x6e, 0x5f, 0x67, 0x65, 0x6d, 0x6d, 0x5f, 0x61, 0x6e, 0x79, 0x18, 0xbe, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x48, 0x9d, 0x01, 0x52, 0x13, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x54, 0x72, 0x69, 0x74,
	0x6f, 0x6e, 0x47, 0x65, 0x6d, 0x6d, 0x41, 0x6e, 0x79, 0x88, 0x01, 0x01, 0x12, 0x70, 0x0a, 0x34,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x75, 0x6e, 0x73, 0x61, 0x66, 0x65, 0x5f, 0x66,
	0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x74, 0x6f, 0x5f, 0x64, 0x72, 0x69, 0x76, 0x65,
	0x72, 0x5f, 0x6f, 0x6e, 0x5f, 0x70, 0x74, 0x78, 0x61, 0x73, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x66,
	0x6f, 0x75, 0x6e, 0x64, 0x18, 0x8a, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x9e, 0x01, 0x52, 0x2b,
	0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x55, 0x6e, 0x73, 0x61, 0x66, 0x65, 0x46, 0x61, 0x6c, 0x6c,
	0x62, 0x61, 0x63, 0x6b, 0x54, 0x6f, 0x44, 0x72, 0x69, 0x76, 0x65, 0x72, 0x4f, 0x6e, 0x50, 0x74,
	0x78, 0x61, 0x73, 0x4e, 0x6f, 0x74, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x88, 0x01, 0x01, 0x12, 0x65,
	0x0a, 0x2d, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x75, 0x6e, 0x73, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x77,
	0x69, 0x74, 0x68, 0x5f, 0x65, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x72, 0x5f, 0x6c, 0x6f, 0x63, 0x18,
	0xe6, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x9f, 0x01, 0x52, 0x27, 0x78, 0x6c, 0x61, 0x47, 0x70,
	0x75, 0x55, 0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x41, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x65, 0x57, 0x69, 0x74, 0x68, 0x45, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x72, 0x4c,
	0x6f, 0x63, 0x88, 0x01, 0x01, 0x12, 0x6b, 0x0a, 0x30, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75,
	0x5f, 0x75, 0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x64, 0x75, 0x63, 0x65, 0x5f, 0x64,
	0x65, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65, 0x72, 0x18, 0x80, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x48, 0xa0, 0x01, 0x52, 0x2a, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x55, 0x6e, 0x73, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x6c, 0x6c, 0x52,
	0x65, 0x64, 0x75, 0x63, 0x65, 0x44, 0x65, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65, 0x72, 0x88,
	0x01, 0x01, 0x12, 0x77, 0x0a, 0x37, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x75, 0x6e,
	0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x72, 0x61, 0x67, 0x67, 0x65, 0x64, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x74, 0x6f, 0x5f, 0x61,
	0x6c, 0x6c, 0x5f, 0x64, 0x65, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65, 0x72, 0x18, 0xde, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x48, 0xa1, 0x01, 0x52, 0x2f, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x55,
	0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x52, 0x61, 0x67, 0x67, 0x65, 0x64, 0x41, 0x6c, 0x6c, 0x54, 0x6f, 0x41, 0x6c, 0x6c, 0x44, 0x65,
	0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x58, 0x0a, 0x26, 0x78,
	0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x75, 0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x65, 0x64, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x72, 0x69, 0x74, 0x6f, 0x6e,
	0x5f, 0x67, 0x65, 0x6d, 0x6d, 0x18, 0xc2, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0xa2, 0x01, 0x52,
	0x21, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x55, 0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x65, 0x64, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x72, 0x69, 0x74, 0x6f, 0x6e, 0x47, 0x65,
	0x6d, 0x6d, 0x88, 0x01, 0x01, 0x12, 0x74, 0x0a, 0x35, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75,
	0x5f, 0x75, 0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x74, 0x72, 0x69, 0x74, 0x6f, 0x6e, 0x5f, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0xfe,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0xa3, 0x01, 0x52, 0x2e, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75,
	0x55, 0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x45, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x54, 0x72, 0x69, 0x74, 0x6f, 0x6e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x46, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x9a, 0x01, 0x0a, 0x33,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x75, 0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72,
	0x74, 0x65, 0x64, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x74, 0x72, 0x69, 0x74,
	0x6f, 0x6e, 0x5f, 0x65, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x72, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x73, 0x18, 0x8e, 0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x78, 0x6c, 0x61,
	0x2e, 0x44, 0x65, 0x62, 0x75, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x69, 0x63, 0x54, 0x72, 0x69, 0x74, 0x6f, 0x6e, 0x45, 0x6d, 0x69, 0x74, 0x74,
	0x65, 0x72, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x52, 0x2d, 0x78, 0x6c, 0x61, 0x47, 0x70,
	0x75, 0x55, 0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x69, 0x63, 0x54, 0x72, 0x69, 0x74, 0x6f, 0x6e, 0x45, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x72,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x12, 0x6d, 0x0a, 0x32, 0x78, 0x6c, 0x61, 0x5f,
	0x67, 0x70, 0x75, 0x5f, 0x75, 0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f,
	0x75, 0x73, 0x65, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x64, 0x75, 0x63, 0x65, 0x5f, 0x6f,
	0x6e, 0x65, 0x5f, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x18, 0x83,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0xa4, 0x01, 0x52, 0x2a, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75,
	0x55, 0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x55, 0x73, 0x65, 0x41, 0x6c,
	0x6c, 0x52, 0x65, 0x64, 0x75, 0x63, 0x65, 0x4f, 0x6e, 0x65, 0x53, 0x68, 0x6f, 0x74, 0x4b, 0x65,
	0x72, 0x6e, 0x65, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x79, 0x0a, 0x39, 0x78, 0x6c, 0x61, 0x5f, 0x67,
	0x70, 0x75, 0x5f, 0x75, 0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x75,
	0x73, 0x65, 0x5f, 0x72, 0x61, 0x67, 0x67, 0x65, 0x64, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x74, 0x6f,
	0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x6f, 0x6e, 0x65, 0x5f, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x6b, 0x65,
	0x72, 0x6e, 0x65, 0x6c, 0x18, 0xf7, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0xa5, 0x01, 0x52, 0x2f,
	0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x55, 0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65,
	0x64, 0x55, 0x73, 0x65, 0x52, 0x61, 0x67, 0x67, 0x65, 0x64, 0x41, 0x6c, 0x6c, 0x54, 0x6f, 0x41,
	0x6c, 0x6c, 0x4f, 0x6e, 0x65, 0x53, 0x68, 0x6f, 0x74, 0x4b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x88,
	0x01, 0x01, 0x12, 0x3f, 0x0a, 0x19, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x75, 0x73,
	0x65, 0x5f, 0x69, 0x6e, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x6c, 0x64, 0x18,
	0x85, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0xa6, 0x01, 0x52, 0x15, 0x78, 0x6c, 0x61, 0x47, 0x70,
	0x75, 0x55, 0x73, 0x65, 0x49, 0x6e, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x6c, 0x64,
	0x88, 0x01, 0x01, 0x12, 0x44, 0x0a, 0x1c, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x75,
	0x73, 0x65, 0x5f, 0x6d, 0x65, 0x6d, 0x63, 0x70, 0x79, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f,
	0x70, 0x32, 0x70, 0x18, 0x9f, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0xa7, 0x01, 0x52, 0x17, 0x78,
	0x6c, 0x61, 0x47, 0x70, 0x75, 0x55, 0x73, 0x65, 0x4d, 0x65, 0x6d, 0x63, 0x70, 0x79, 0x4c, 0x6f,
	0x63, 0x61, 0x6c, 0x50, 0x32, 0x70, 0x88, 0x01, 0x01, 0x12, 0x41, 0x0a, 0x1a, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0xb5, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0xa8,
	0x01, 0x52, 0x16, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x55, 0x73, 0x65, 0x52, 0x75, 0x6e, 0x74,
	0x69, 0x6d, 0x65, 0x46, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x56, 0x0a, 0x25,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x5f, 0x74,
	0x72, 0x69, 0x74, 0x6f, 0x6e, 0x5f, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x75, 0x6d,
	0x65, 0x72, 0x69, 0x63, 0x73, 0x18, 0xa3, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0xa9, 0x01, 0x52,
	0x20, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x54, 0x72, 0x69,
	0x74, 0x6f, 0x6e, 0x46, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63,
	0x73, 0x88, 0x01, 0x01, 0x12, 0x3b, 0x0a, 0x17, 0x78, 0x6c, 0x61, 0x5f, 0x68, 0x6c, 0x6f, 0x5f,
	0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0xaa, 0x01, 0x52, 0x14, 0x78, 0x6c, 0x61, 0x48, 0x6c, 0x6f,
	0x47, 0x72, 0x61, 0x70, 0x68, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x88, 0x01,
	0x01, 0x12, 0x2c, 0x0a, 0x0f, 0x78, 0x6c, 0x61, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x70, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x48, 0xab, 0x01, 0x52, 0x0d, 0x78,
	0x6c, 0x61, 0x48, 0x6c, 0x6f, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x33, 0x0a, 0x16, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x68,
	0x6c, 0x6f, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x65, 0x73, 0x18, 0x1e, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x13, 0x78, 0x6c, 0x61, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x48, 0x6c, 0x6f, 0x50, 0x61,
	0x73, 0x73, 0x65, 0x73, 0x12, 0x3a, 0x0a, 0x1a, 0x78, 0x6c, 0x61, 0x5f, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x65, 0x73, 0x5f, 0x6f, 0x6e,
	0x6c, 0x79, 0x18, 0x7c, 0x20, 0x03, 0x28, 0x09, 0x52, 0x16, 0x78, 0x6c, 0x61, 0x45, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x48, 0x6c, 0x6f, 0x50, 0x61, 0x73, 0x73, 0x65, 0x73, 0x4f, 0x6e, 0x6c, 0x79,
	0x12, 0x40, 0x0a, 0x1a, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x61, 0x6c, 0x6c, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x65, 0x73, 0x18, 0x68,
	0x20, 0x01, 0x28, 0x08, 0x48, 0xac, 0x01, 0x52, 0x16, 0x78, 0x6c, 0x61, 0x44, 0x69, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x41, 0x6c, 0x6c, 0x48, 0x6c, 0x6f, 0x50, 0x61, 0x73, 0x73, 0x65, 0x73, 0x88,
	0x01, 0x01, 0x12, 0x49, 0x0a, 0x1e, 0x78, 0x6c, 0x61, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e,
	0x64, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c,
	0x65, 0x76, 0x65, 0x6c, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x05, 0x48, 0xad, 0x01, 0x52, 0x1b, 0x78,
	0x6c, 0x61, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x40, 0x0a,
	0x1a, 0x78, 0x6c, 0x61, 0x5f, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x5f, 0x69, 0x72, 0x5f, 0x69, 0x6e,
	0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x21, 0x20, 0x01, 0x28,
	0x08, 0x48, 0xae, 0x01, 0x52, 0x16, 0x78, 0x6c, 0x61, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x49, 0x72,
	0x49, 0x6e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x54, 0x0a, 0x24, 0x78, 0x6c, 0x61, 0x5f, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65,
	0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x69, 0x6d, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x5f, 0x62, 0x72,
	0x6f, 0x61, 0x64, 0x63, 0x61, 0x73, 0x74, 0x18, 0x23, 0x20, 0x01, 0x28, 0x08, 0x48, 0xaf, 0x01,
	0x52, 0x20, 0x78, 0x6c, 0x61, 0x45, 0x6c, 0x69, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x48, 0x6c,
	0x6f, 0x49, 0x6d, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x42, 0x72, 0x6f, 0x61, 0x64, 0x63, 0x61,
	0x73, 0x74, 0x88, 0x01, 0x01, 0x12, 0x40, 0x0a, 0x1a, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75,
	0x5f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x65, 0x69,
	0x67, 0x65, 0x6e, 0x18, 0x3c, 0x20, 0x01, 0x28, 0x08, 0x48, 0xb0, 0x01, 0x52, 0x16, 0x78, 0x6c,
	0x61, 0x43, 0x70, 0x75, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x54, 0x68, 0x72, 0x65, 0x61, 0x64, 0x45,
	0x69, 0x67, 0x65, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x53, 0x0a, 0x24, 0x78, 0x6c, 0x61, 0x5f, 0x6c,
	0x6c, 0x76, 0x6d, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x6c, 0x69, 0x61, 0x73,
	0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x46, 0x20, 0x01, 0x28, 0x08, 0x48, 0xb1, 0x01, 0x52, 0x1f, 0x78, 0x6c, 0x61, 0x4c, 0x6c, 0x76,
	0x6d, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x53, 0x63, 0x6f, 0x70,
	0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x88, 0x01, 0x01, 0x12, 0x4c, 0x0a, 0x20,
	0x78, 0x6c, 0x61, 0x5f, 0x6c, 0x6c, 0x76, 0x6d, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x6e, 0x6f, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x47, 0x20, 0x01, 0x28, 0x08, 0x48, 0xb2, 0x01, 0x52, 0x1c, 0x78, 0x6c, 0x61, 0x4c, 0x6c,
	0x76, 0x6d, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x6f, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x88, 0x01, 0x01, 0x12, 0x59, 0x0a, 0x27, 0x78, 0x6c,
	0x61, 0x5f, 0x6c, 0x6c, 0x76, 0x6d, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6e,
	0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x48, 0x20, 0x01, 0x28, 0x08, 0x48, 0xb3, 0x01, 0x52, 0x22,
	0x78, 0x6c, 0x61, 0x4c, 0x6c, 0x76, 0x6d, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x76,
	0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x4c, 0x6f, 0x61, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x88, 0x01, 0x01, 0x12, 0x4e, 0x0a, 0x21, 0x78, 0x6c, 0x61, 0x5f, 0x6c, 0x6c, 0x76,
	0x6d, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x6e, 0x73,
	0x69, 0x76, 0x65, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x65, 0x73, 0x18, 0x49, 0x20, 0x01, 0x28, 0x08,
	0x48, 0xb4, 0x01, 0x52, 0x1d, 0x78, 0x6c, 0x61, 0x4c, 0x6c, 0x76, 0x6d, 0x44, 0x69, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x45, 0x78, 0x70, 0x65, 0x6e, 0x73, 0x69, 0x76, 0x65, 0x50, 0x61, 0x73, 0x73,
	0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x42, 0x0a, 0x1b, 0x78, 0x6c, 0x61, 0x5f, 0x74, 0x65, 0x73,
	0x74, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x6c, 0x61, 0x79,
	0x6f, 0x75, 0x74, 0x73, 0x18, 0x5a, 0x20, 0x01, 0x28, 0x08, 0x48, 0xb5, 0x01, 0x52, 0x17, 0x78,
	0x6c, 0x61, 0x54, 0x65, 0x73, 0x74, 0x41, 0x6c, 0x6c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x4c,
	0x61, 0x79, 0x6f, 0x75, 0x74, 0x73, 0x88, 0x01, 0x01, 0x12, 0x40, 0x0a, 0x1a, 0x78, 0x6c, 0x61,
	0x5f, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f,
	0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x73, 0x18, 0x5b, 0x20, 0x01, 0x28, 0x08, 0x48, 0xb6, 0x01,
	0x52, 0x16, 0x78, 0x6c, 0x61, 0x54, 0x65, 0x73, 0x74, 0x41, 0x6c, 0x6c, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x73, 0x88, 0x01, 0x01, 0x12, 0x44, 0x0a, 0x1c, 0x78,
	0x6c, 0x61, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x73, 0x68, 0x61,
	0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x18, 0x5c, 0x20, 0x01, 0x28,
	0x08, 0x48, 0xb7, 0x01, 0x52, 0x18, 0x78, 0x6c, 0x61, 0x48, 0x6c, 0x6f, 0x47, 0x72, 0x61, 0x70,
	0x68, 0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x88, 0x01,
	0x01, 0x12, 0x31, 0x0a, 0x12, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x75, 0x73, 0x65,
	0x5f, 0x6f, 0x6e, 0x65, 0x64, 0x6e, 0x6e, 0x18, 0x61, 0x20, 0x01, 0x28, 0x08, 0x48, 0xb8, 0x01,
	0x52, 0x0f, 0x78, 0x6c, 0x61, 0x43, 0x70, 0x75, 0x55, 0x73, 0x65, 0x4f, 0x6e, 0x65, 0x64, 0x6e,
	0x6e, 0x88, 0x01, 0x01, 0x12, 0x41, 0x0a, 0x1a, 0x78, 0x6c, 0x61, 0x5f, 0x61, 0x6c, 0x6c, 0x6f,
	0x77, 0x5f, 0x65, 0x78, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x7a, 0x20, 0x01, 0x28, 0x08, 0x48, 0xb9, 0x01, 0x52, 0x17, 0x78, 0x6c, 0x61,
	0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x45, 0x78, 0x63, 0x65, 0x73, 0x73, 0x50, 0x72, 0x65, 0x63, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x53, 0x0a, 0x24, 0x78, 0x6c, 0x61, 0x5f, 0x66,
	0x6f, 0x72, 0x63, 0x65, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x66, 0x20, 0x01, 0x28, 0x05, 0x48, 0xba, 0x01, 0x52, 0x1f, 0x78, 0x6c, 0x61, 0x46, 0x6f, 0x72,
	0x63, 0x65, 0x48, 0x6f, 0x73, 0x74, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x49, 0x0a, 0x1f,
	0x78, 0x6c, 0x61, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x6f,
	0x72, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x66, 0x61, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18,
	0x6a, 0x20, 0x01, 0x28, 0x08, 0x48, 0xbb, 0x01, 0x52, 0x1a, 0x78, 0x6c, 0x61, 0x48, 0x6c, 0x6f,
	0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x6f, 0x72, 0x55, 0x73, 0x65, 0x46, 0x61, 0x73, 0x74,
	0x50, 0x61, 0x74, 0x68, 0x88, 0x01, 0x01, 0x12, 0x4f, 0x0a, 0x22, 0x78, 0x6c, 0x61, 0x5f, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x73, 0x63, 0x61, 0x6c, 0x61, 0x72, 0x5f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x5f, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x5f, 0x6f, 0x70, 0x73, 0x18, 0x6b, 0x20,
	0x01, 0x28, 0x08, 0x48, 0xbc, 0x01, 0x52, 0x1d, 0x78, 0x6c, 0x61, 0x41, 0x6c, 0x6c, 0x6f, 0x77,
	0x53, 0x63, 0x61, 0x6c, 0x61, 0x72, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x44, 0x79, 0x6e, 0x61, 0x6d,
	0x69, 0x63, 0x4f, 0x70, 0x73, 0x88, 0x01, 0x01, 0x12, 0x63, 0x0a, 0x18, 0x78, 0x6c, 0x61, 0x5f,
	0x73, 0x74, 0x65, 0x70, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x6c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x78, 0x6c, 0x61,
	0x2e, 0x44, 0x65, 0x62, 0x75, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x53, 0x74,
	0x65, 0x70, 0x4d, 0x61, 0x72, 0x6b, 0x65, 0x72, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x48, 0xbd, 0x01, 0x52, 0x15, 0x78, 0x6c, 0x61, 0x53, 0x74, 0x65, 0x70, 0x4d, 0x61, 0x72, 0x6b,
	0x65, 0x72, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a,
	0x0b, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x74, 0x6f, 0x18, 0x6d, 0x20, 0x01,
	0x28, 0x09, 0x48, 0xbe, 0x01, 0x52, 0x09, 0x78, 0x6c, 0x61, 0x44, 0x75, 0x6d, 0x70, 0x54, 0x6f,
	0x88, 0x01, 0x01, 0x12, 0x2d, 0x0a, 0x0f, 0x78, 0x6c, 0x61, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x73,
	0x5f, 0x72, 0x65, 0x73, 0x65, 0x74, 0x18, 0xec, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0xbf, 0x01,
	0x52, 0x0d, 0x78, 0x6c, 0x61, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x52, 0x65, 0x73, 0x65, 0x74, 0x88,
	0x01, 0x01, 0x12, 0x38, 0x0a, 0x16, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x68,
	0x6c, 0x6f, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x18, 0x6e, 0x20, 0x01,
	0x28, 0x09, 0x48, 0xc0, 0x01, 0x52, 0x12, 0x78, 0x6c, 0x61, 0x44, 0x75, 0x6d, 0x70, 0x48, 0x6c,
	0x6f, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x65, 0x88, 0x01, 0x01, 0x12, 0x34, 0x0a, 0x14,
	0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x70, 0x61, 0x73,
	0x73, 0x5f, 0x72, 0x65, 0x18, 0x6f, 0x20, 0x01, 0x28, 0x09, 0x48, 0xc1, 0x01, 0x52, 0x10, 0x78,
	0x6c, 0x61, 0x44, 0x75, 0x6d, 0x70, 0x48, 0x6c, 0x6f, 0x50, 0x61, 0x73, 0x73, 0x52, 0x65, 0x88,
	0x01, 0x01, 0x12, 0x34, 0x0a, 0x14, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x68,
	0x6c, 0x6f, 0x5f, 0x61, 0x73, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x70, 0x20, 0x01, 0x28, 0x08,
	0x48, 0xc2, 0x01, 0x52, 0x10, 0x78, 0x6c, 0x61, 0x44, 0x75, 0x6d, 0x70, 0x48, 0x6c, 0x6f, 0x41,
	0x73, 0x54, 0x65, 0x78, 0x74, 0x88, 0x01, 0x01, 0x12, 0x36, 0x0a, 0x15, 0x78, 0x6c, 0x61, 0x5f,
	0x64, 0x75, 0x6d, 0x70, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x61, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x18, 0x71, 0x20, 0x01, 0x28, 0x08, 0x48, 0xc3, 0x01, 0x52, 0x11, 0x78, 0x6c, 0x61, 0x44,
	0x75, 0x6d, 0x70, 0x48, 0x6c, 0x6f, 0x41, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x88, 0x01, 0x01,
	0x12, 0x32, 0x0a, 0x13, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x68, 0x6c, 0x6f,
	0x5f, 0x61, 0x73, 0x5f, 0x64, 0x6f, 0x74, 0x18, 0x72, 0x20, 0x01, 0x28, 0x08, 0x48, 0xc4, 0x01,
	0x52, 0x0f, 0x78, 0x6c, 0x61, 0x44, 0x75, 0x6d, 0x70, 0x48, 0x6c, 0x6f, 0x41, 0x73, 0x44, 0x6f,
	0x74, 0x88, 0x01, 0x01, 0x12, 0x32, 0x0a, 0x13, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70,
	0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x61, 0x73, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x73, 0x20, 0x01, 0x28,
	0x08, 0x48, 0xc5, 0x01, 0x52, 0x0f, 0x78, 0x6c, 0x61, 0x44, 0x75, 0x6d, 0x70, 0x48, 0x6c, 0x6f,
	0x41, 0x73, 0x55, 0x72, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x34, 0x0a, 0x14, 0x78, 0x6c, 0x61, 0x5f,
	0x64, 0x75, 0x6d, 0x70, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x61, 0x73, 0x5f, 0x68, 0x74, 0x6d, 0x6c,
	0x18, 0x74, 0x20, 0x01, 0x28, 0x08, 0x48, 0xc6, 0x01, 0x52, 0x10, 0x78, 0x6c, 0x61, 0x44, 0x75,
	0x6d, 0x70, 0x48, 0x6c, 0x6f, 0x41, 0x73, 0x48, 0x74, 0x6d, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x48,
	0x0a, 0x1d, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x66, 0x75, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x95, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0xc7, 0x01, 0x52, 0x1a, 0x78, 0x6c, 0x61, 0x44, 0x75,
	0x6d, 0x70, 0x46, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x39, 0x0a, 0x16, 0x78, 0x6c, 0x61, 0x5f,
	0x64, 0x75, 0x6d, 0x70, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x73, 0x18, 0x76, 0x20, 0x01, 0x28, 0x08, 0x48, 0xc8, 0x01, 0x52, 0x13, 0x78, 0x6c, 0x61,
	0x44, 0x75, 0x6d, 0x70, 0x48, 0x6c, 0x6f, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73,
	0x88, 0x01, 0x01, 0x12, 0x42, 0x0a, 0x1a, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f,
	0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x18, 0x83, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0xc9, 0x01, 0x52, 0x17, 0x78, 0x6c, 0x61,
	0x44, 0x75, 0x6d, 0x70, 0x49, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x88, 0x01, 0x01, 0x12, 0x3d, 0x0a, 0x18, 0x78, 0x6c, 0x61, 0x5f, 0x64,
	0x75, 0x6d, 0x70, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x73, 0x18, 0x84, 0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0xca, 0x01, 0x52, 0x14, 0x78,
	0x6c, 0x61, 0x44, 0x75, 0x6d, 0x70, 0x4d, 0x61, 0x78, 0x48, 0x6c, 0x6f, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x3e, 0x0a, 0x18, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75,
	0x6d, 0x70, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x90, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0xcb, 0x01, 0x52, 0x15, 0x78, 0x6c,
	0x61, 0x44, 0x75, 0x6d, 0x70, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x88, 0x01, 0x01, 0x12, 0x3e, 0x0a, 0x18, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75,
	0x6d, 0x70, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x73, 0x18, 0x97, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0xcc, 0x01, 0x52, 0x15, 0x78, 0x6c,
	0x61, 0x44, 0x75, 0x6d, 0x70, 0x43, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x73, 0x88, 0x01, 0x01, 0x12, 0x3e, 0x0a, 0x19, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75,
	0x6d, 0x70, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x61, 0x73, 0x5f, 0x6c, 0x6f, 0x6e, 0x67, 0x5f, 0x74,
	0x65, 0x78, 0x74, 0x18, 0xa4, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0xcd, 0x01, 0x52, 0x14, 0x78,
	0x6c, 0x61, 0x44, 0x75, 0x6d, 0x70, 0x48, 0x6c, 0x6f, 0x41, 0x73, 0x4c, 0x6f, 0x6e, 0x67, 0x54,
	0x65, 0x78, 0x74, 0x88, 0x01, 0x01, 0x12, 0x4c, 0x0a, 0x20, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75,
	0x6d, 0x70, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6d, 0x6c, 0x69, 0x72, 0x5f, 0x70,
	0x72, 0x65, 0x74, 0x74, 0x79, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0xb9, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x48, 0xce, 0x01, 0x52, 0x1b, 0x78, 0x6c, 0x61, 0x44, 0x75, 0x6d, 0x70, 0x45, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x4d, 0x6c, 0x69, 0x72, 0x50, 0x72, 0x65, 0x74, 0x74, 0x79, 0x46, 0x6f, 0x72,
	0x6d, 0x88, 0x01, 0x01, 0x12, 0x3d, 0x0a, 0x18, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70,
	0x5f, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0xfd, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0xcf, 0x01, 0x52, 0x14, 0x78, 0x6c, 0x61, 0x44,
	0x75, 0x6d, 0x70, 0x46, 0x75, 0x6c, 0x6c, 0x48, 0x6c, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x88, 0x01, 0x01, 0x12, 0x32, 0x0a, 0x12, 0x78, 0x6c, 0x61, 0x5f, 0x74, 0x70, 0x75, 0x5f, 0x64,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x61, 0x6e, 0x18, 0x87, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x48, 0xd0, 0x01, 0x52, 0x0f, 0x78, 0x6c, 0x61, 0x54, 0x70, 0x75, 0x44, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x4e, 0x61, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x32, 0x0a, 0x12, 0x78, 0x6c, 0x61, 0x5f, 0x74,
	0x70, 0x75, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x18, 0x88, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x48, 0xd1, 0x01, 0x52, 0x0f, 0x78, 0x6c, 0x61, 0x54, 0x70, 0x75, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x88, 0x01, 0x01, 0x12, 0x45, 0x0a, 0x1c, 0x78,
	0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x78, 0x70,
	0x72, 0x6f, 0x66, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x18, 0x89, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x48, 0xd2, 0x01, 0x52, 0x18, 0x78, 0x6c, 0x61, 0x43, 0x70, 0x75, 0x45, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x58, 0x70, 0x72, 0x6f, 0x66, 0x54, 0x72, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x88,
	0x01, 0x01, 0x12, 0x58, 0x0a, 0x26, 0x78, 0x6c, 0x61, 0x5f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x68,
	0x65, 0x61, 0x70, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x68, 0x65, 0x61, 0x70, 0x18, 0x8e, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x48, 0xd3, 0x01, 0x52, 0x21, 0x78, 0x6c, 0x61, 0x4d, 0x75, 0x6c, 0x74, 0x69,
	0x68, 0x65, 0x61, 0x70, 0x53, 0x69, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x74, 0x50, 0x65, 0x72, 0x48, 0x65, 0x61, 0x70, 0x88, 0x01, 0x01, 0x12, 0x37, 0x0a, 0x14,
	0x78, 0x6c, 0x61, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x18, 0xfc, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0xd4, 0x01, 0x52, 0x12,
	0x78, 0x6c, 0x61, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x4c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a, 0x12, 0x78, 0x6c, 0x61, 0x5f, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x69, 0x6e, 0x67, 0x18, 0xfd, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x48, 0xd5, 0x01, 0x52, 0x10, 0x78, 0x6c, 0x61, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x44, 0x75, 0x6d, 0x70, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x50, 0x0a, 0x22, 0x78, 0x6c,
	0x61, 0x5f, 0x6c, 0x6c, 0x76, 0x6d, 0x5f, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x6c,
	0x69, 0x6e, 0x65, 0x5f, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x5f, 0x73, 0x70, 0x6c, 0x69, 0x74,
	0x18, 0xac, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0xd6, 0x01, 0x52, 0x1d, 0x78, 0x6c, 0x61, 0x4c,
	0x6c, 0x76, 0x6d, 0x46, 0x6f, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x42, 0x65,
	0x66, 0x6f, 0x72, 0x65, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x88, 0x01, 0x01, 0x12, 0x40, 0x0a, 0x19,
	0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x99, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x48, 0xd7, 0x01, 0x52, 0x16, 0x78, 0x6c, 0x61, 0x44, 0x75, 0x6d, 0x70, 0x44, 0x69, 0x73, 0x61,
	0x62, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x88, 0x01, 0x01, 0x12, 0x3d,
	0x0a, 0x18, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x72, 0x65, 0x18, 0x9a, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x48, 0xd8, 0x01, 0x52, 0x14, 0x78, 0x6c, 0x61, 0x44, 0x75, 0x6d, 0x70, 0x48, 0x6c, 0x6f,
	0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2c, 0x0a,
	0x0f, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x63, 0x6c,
	0x18, 0xae, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0xd9, 0x01, 0x52, 0x0c, 0x78, 0x6c, 0x61, 0x43,
	0x70, 0x75, 0x55, 0x73, 0x65, 0x41, 0x63, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x44, 0x0a, 0x1c, 0x78,
	0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x5f, 0x64, 0x6f,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x5f, 0x6d, 0x61, 0x74, 0x68, 0x18, 0xaf, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x48, 0xda, 0x01, 0x52, 0x17, 0x78, 0x6c, 0x61, 0x43, 0x70, 0x75, 0x53, 0x74, 0x72,
	0x69, 0x63, 0x74, 0x44, 0x6f, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x4d, 0x61, 0x74, 0x68, 0x88, 0x01,
	0x01, 0x12, 0x4d, 0x0a, 0x20, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x6c, 0x61,
	0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x68, 0x69, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0xb6, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0xdb, 0x01, 0x52,
	0x1c, 0x78, 0x6c, 0x61, 0x44, 0x75, 0x6d, 0x70, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x48,
	0x69, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x6c, 0x0a, 0x1a, 0x78, 0x6c, 0x61, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0xbb,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x44, 0x65, 0x62, 0x75,
	0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x48, 0xdc,
	0x01, 0x52, 0x18, 0x78, 0x6c, 0x61, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x69,
	0x6e, 0x67, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x88, 0x01, 0x01, 0x12, 0x54,
	0x0a, 0x24, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x65, 0x62, 0x75, 0x67, 0x5f, 0x62, 0x75, 0x66, 0x66,
	0x65, 0x72, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x68,
	0x6f, 0x77, 0x5f, 0x6d, 0x61, 0x78, 0x18, 0xfb, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0xdd, 0x01,
	0x52, 0x1f, 0x78, 0x6c, 0x61, 0x44, 0x65, 0x62, 0x75, 0x67, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72,
	0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x68, 0x6f, 0x77, 0x4d, 0x61,
	0x78, 0x88, 0x01, 0x01, 0x12, 0x7c, 0x0a, 0x1e, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x5f, 0x75, 0x6e, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x64, 0x75,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x93, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e,
	0x78, 0x6c, 0x61, 0x2e, 0x44, 0x65, 0x62, 0x75, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x55, 0x6e, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x64, 0x75, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x48,
	0xde, 0x01, 0x52, 0x1b, 0x78, 0x6c, 0x61, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x55, 0x6e, 0x73,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x88,
	0x01, 0x01, 0x12, 0x3e, 0x0a, 0x18, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x6c,
	0x61, 0x72, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x73, 0x18, 0xa2,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0xdf, 0x01, 0x52, 0x15, 0x78, 0x6c, 0x61, 0x44, 0x75, 0x6d,
	0x70, 0x4c, 0x61, 0x72, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x73, 0x88,
	0x01, 0x01, 0x12, 0x56, 0x0a, 0x25, 0x78, 0x6c, 0x61, 0x5f, 0x72, 0x65, 0x64, 0x75, 0x63, 0x65,
	0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x72, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f,
	0x62, 0x61, 0x73, 0x65, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0xa5, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x48, 0xe0, 0x01, 0x52, 0x20, 0x78, 0x6c, 0x61, 0x52, 0x65, 0x64, 0x75, 0x63, 0x65,
	0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x52, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x42, 0x61, 0x73,
	0x65, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x88, 0x01, 0x01, 0x12, 0x4a, 0x0a, 0x1f, 0x78, 0x6c,
	0x61, 0x5f, 0x63, 0x6d, 0x64, 0x5f, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x74, 0x72, 0x61,
	0x63, 0x65, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0xb7, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x48, 0xe1, 0x01, 0x52, 0x1a, 0x78, 0x6c, 0x61, 0x43, 0x6d, 0x64, 0x42,
	0x75, 0x66, 0x66, 0x65, 0x72, 0x54, 0x72, 0x61, 0x63, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x88, 0x01, 0x01, 0x12, 0x58, 0x0a, 0x29, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79,
	0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x5f,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x73, 0x18, 0xba, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x24, 0x6c, 0x65, 0x67, 0x61,
	0x63, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x61, 0x6c, 0x6c, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73,
	0x12, 0x41, 0x0a, 0x1a, 0x78, 0x6c, 0x61, 0x5f, 0x73, 0x79, 0x6e, 0x74, 0x61, 0x78, 0x5f, 0x73,
	0x75, 0x67, 0x61, 0x72, 0x5f, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x6f, 0x70, 0x73, 0x18, 0xbb,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0xe2, 0x01, 0x52, 0x16, 0x78, 0x6c, 0x61, 0x53, 0x79, 0x6e,
	0x74, 0x61, 0x78, 0x53, 0x75, 0x67, 0x61, 0x72, 0x41, 0x73, 0x79, 0x6e, 0x63, 0x4f, 0x70, 0x73,
	0x88, 0x01, 0x01, 0x12, 0x62, 0x0a, 0x2b, 0x78, 0x6c, 0x61, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72,
	0x73, 0x5f, 0x64, 0x75, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x69,
	0x6e, 0x67, 0x18, 0xbd, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0xe3, 0x01, 0x52, 0x26, 0x78, 0x6c,
	0x61, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x42, 0x75,
	0x66, 0x66, 0x65, 0x72, 0x73, 0x44, 0x75, 0x72, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x38, 0x0a, 0x15, 0x78, 0x6c, 0x61, 0x5f, 0x69,
	0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x64,
	0x18, 0xca, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0xe4, 0x01, 0x52, 0x12, 0x78, 0x6c, 0x61, 0x49,
	0x67, 0x6e, 0x6f, 0x72, 0x65, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x49, 0x64, 0x88, 0x01,
	0x01, 0x12, 0x4d, 0x0a, 0x21, 0x78, 0x6c, 0x61, 0x5f, 0x70, 0x6a, 0x72, 0x74, 0x5f, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x5f,
	0x69, 0x6e, 0x5f, 0x68, 0x6c, 0x6f, 0x18, 0xd8, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0xe5, 0x01,
	0x52, 0x1b, 0x78, 0x6c, 0x61, 0x50, 0x6a, 0x72, 0x74, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x41, 0x75,
	0x74, 0x6f, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x49, 0x6e, 0x48, 0x6c, 0x6f, 0x88, 0x01, 0x01,
	0x12, 0x4c, 0x0a, 0x20, 0x78, 0x6c, 0x61, 0x5f, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x61, 0x64, 0x64,
	0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x5f,
	0x6d, 0x6f, 0x64, 0x65, 0x18, 0xf5, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0xe6, 0x01, 0x52, 0x1b,
	0x78, 0x6c, 0x61, 0x54, 0x65, 0x73, 0x74, 0x41, 0x64, 0x64, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
	0x64, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x12, 0x61,
	0x0a, 0x2b, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x6d, 0x61, 0x74, 0x6d, 0x75, 0x6c, 0x5f, 0x70, 0x65,
	0x72, 0x66, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0xff, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x48, 0xe7, 0x01, 0x52, 0x25, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x4d, 0x61, 0x74, 0x6d, 0x75,
	0x6c, 0x50, 0x65, 0x72, 0x66, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x61, 0x74, 0x68, 0x88, 0x01,
	0x01, 0x12, 0x43, 0x0a, 0x1b, 0x78, 0x6c, 0x61, 0x5f, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x5f, 0x65,
	0x78, 0x69, 0x74, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x73,
	0x18, 0x8d, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0xe8, 0x01, 0x52, 0x17, 0x78, 0x6c, 0x61, 0x45,
	0x61, 0x72, 0x6c, 0x79, 0x45, 0x78, 0x69, 0x74, 0x57, 0x69, 0x74, 0x68, 0x4c, 0x61, 0x79, 0x6f,
	0x75, 0x74, 0x73, 0x88, 0x01, 0x01, 0x12, 0x61, 0x0a, 0x2b, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70,
	0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x73,
	0x63, 0x61, 0x6c, 0x65, 0x64, 0x5f, 0x64, 0x6f, 0x74, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x74,
	0x72, 0x69, 0x74, 0x6f, 0x6e, 0x18, 0x9a, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0xe9, 0x01, 0x52,
	0x25, 0x78, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x6c, 0x53, 0x63, 0x61, 0x6c, 0x65, 0x64, 0x44, 0x6f, 0x74, 0x57, 0x69, 0x74, 0x68,
	0x54, 0x72, 0x69, 0x74, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x57, 0x0a, 0x26, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x6c, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x72, 0x61, 0x66, 0x74, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x5f, 0x6b, 0x18, 0x9d, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0xea, 0x01, 0x52, 0x20, 0x78,
	0x6c, 0x61, 0x47, 0x70, 0x75, 0x45, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x6c, 0x55, 0x73, 0x65, 0x52, 0x61, 0x66, 0x74, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x4b, 0x88,
	0x01, 0x01, 0x12, 0x69, 0x0a, 0x19, 0x78, 0x6c, 0x61, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e,
	0x64, 0x5f, 0x65, 0x78, 0x74, 0x72, 0x61, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0xf4, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x44, 0x65, 0x62,
	0x75, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x58, 0x6c, 0x61, 0x42, 0x61, 0x63,
	0x6b, 0x65, 0x6e, 0x64, 0x45, 0x78, 0x74, 0x72, 0x61, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x16, 0x78, 0x6c, 0x61, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e,
	0x64, 0x45, 0x78, 0x74, 0x72, 0x61, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x5a, 0x0a,
	0x2c, 0x58, 0x6c, 0x61, 0x47, 0x70, 0x75, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x61,
	0x6c, 0x4c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x45, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x6f,
	0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x49, 0x0a, 0x1b, 0x58, 0x6c, 0x61,
	0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x45, 0x78, 0x74, 0x72, 0x61, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0xb3, 0x01, 0x0a, 0x10, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x4f, 0x70, 0x54, 0x79, 0x70, 0x65, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4f,
	0x50, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x4c, 0x4c, 0x52, 0x45, 0x44, 0x55, 0x43, 0x45,
	0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x4c, 0x4c, 0x47, 0x41, 0x54, 0x48, 0x45, 0x52, 0x10,
	0x02, 0x12, 0x11, 0x0a, 0x0d, 0x52, 0x45, 0x44, 0x55, 0x43, 0x45, 0x53, 0x43, 0x41, 0x54, 0x54,
	0x45, 0x52, 0x10, 0x03, 0x12, 0x17, 0x0a, 0x13, 0x43, 0x4f, 0x4c, 0x4c, 0x45, 0x43, 0x54, 0x49,
	0x56, 0x45, 0x42, 0x52, 0x4f, 0x41, 0x44, 0x43, 0x41, 0x53, 0x54, 0x10, 0x04, 0x12, 0x0c, 0x0a,
	0x08, 0x41, 0x4c, 0x4c, 0x54, 0x4f, 0x41, 0x4c, 0x4c, 0x10, 0x05, 0x12, 0x15, 0x0a, 0x11, 0x43,
	0x4f, 0x4c, 0x4c, 0x45, 0x43, 0x54, 0x49, 0x56, 0x45, 0x50, 0x45, 0x52, 0x4d, 0x55, 0x54, 0x45,
	0x10, 0x06, 0x12, 0x12, 0x0a, 0x0e, 0x52, 0x41, 0x47, 0x47, 0x45, 0x44, 0x41, 0x4c, 0x4c, 0x54,
	0x4f, 0x41, 0x4c, 0x4c, 0x10, 0x07, 0x12, 0x12, 0x0a, 0x0e, 0x41, 0x4c, 0x4c, 0x43, 0x4f, 0x4c,
	0x4c, 0x45, 0x43, 0x54, 0x49, 0x56, 0x45, 0x53, 0x10, 0x08, 0x22, 0xcb, 0x01, 0x0a, 0x14, 0x43,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x43, 0x6d, 0x64, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x00,
	0x12, 0x0a, 0x0a, 0x06, 0x46, 0x55, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06,
	0x43, 0x55, 0x42, 0x4c, 0x41, 0x53, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x43, 0x55, 0x44, 0x4e,
	0x4e, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x43, 0x4f, 0x4c, 0x4c, 0x45, 0x43, 0x54, 0x49, 0x56,
	0x45, 0x53, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x43, 0x4f, 0x4e, 0x44, 0x49, 0x54, 0x49, 0x4f,
	0x4e, 0x41, 0x4c, 0x10, 0x05, 0x12, 0x09, 0x0a, 0x05, 0x57, 0x48, 0x49, 0x4c, 0x45, 0x10, 0x06,
	0x12, 0x0f, 0x0a, 0x0b, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x5f, 0x43, 0x41, 0x4c, 0x4c, 0x10,
	0x07, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x55, 0x42, 0x4c, 0x41, 0x53, 0x4c, 0x54, 0x10, 0x08, 0x12,
	0x18, 0x0a, 0x14, 0x44, 0x59, 0x4e, 0x41, 0x4d, 0x49, 0x43, 0x5f, 0x53, 0x4c, 0x49, 0x43, 0x45,
	0x5f, 0x46, 0x55, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x09, 0x12, 0x1d, 0x0a, 0x19, 0x44, 0x59, 0x4e,
	0x41, 0x4d, 0x49, 0x43, 0x5f, 0x53, 0x4c, 0x49, 0x43, 0x45, 0x5f, 0x43, 0x4f, 0x50, 0x59, 0x5f,
	0x46, 0x55, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x0a, 0x22, 0x76, 0x0a, 0x10, 0x4c, 0x69, 0x62, 0x4e,
	0x76, 0x4a, 0x69, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1d, 0x0a, 0x19,
	0x4c, 0x49, 0x42, 0x5f, 0x4e, 0x56, 0x5f, 0x4a, 0x49, 0x54, 0x5f, 0x4c, 0x49, 0x4e, 0x4b, 0x5f,
	0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x41, 0x55, 0x54, 0x4f, 0x10, 0x00, 0x12, 0x21, 0x0a, 0x1d, 0x4c,
	0x49, 0x42, 0x5f, 0x4e, 0x56, 0x5f, 0x4a, 0x49, 0x54, 0x5f, 0x4c, 0x49, 0x4e, 0x4b, 0x5f, 0x4d,
	0x4f, 0x44, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x20,
	0x0a, 0x1c, 0x4c, 0x49, 0x42, 0x5f, 0x4e, 0x56, 0x5f, 0x4a, 0x49, 0x54, 0x5f, 0x4c, 0x49, 0x4e,
	0x4b, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x02,
	0x22, 0x75, 0x0a, 0x13, 0x50, 0x47, 0x4c, 0x45, 0x53, 0x74, 0x72, 0x69, 0x63, 0x74, 0x6e, 0x65,
	0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x1d, 0x0a, 0x19, 0x50, 0x47, 0x4c, 0x45, 0x5f,
	0x53, 0x54, 0x52, 0x49, 0x43, 0x54, 0x4e, 0x45, 0x53, 0x53, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c,
	0x5f, 0x4f, 0x46, 0x46, 0x10, 0x00, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x47, 0x4c, 0x45, 0x5f, 0x53,
	0x54, 0x52, 0x49, 0x43, 0x54, 0x4e, 0x45, 0x53, 0x53, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f,
	0x57, 0x41, 0x52, 0x4e, 0x10, 0x01, 0x12, 0x1f, 0x0a, 0x1b, 0x50, 0x47, 0x4c, 0x45, 0x5f, 0x53,
	0x54, 0x52, 0x49, 0x43, 0x54, 0x4e, 0x45, 0x53, 0x53, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f,
	0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x02, 0x22, 0x38, 0x0a, 0x0b, 0x53, 0x68, 0x61, 0x70, 0x65,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x12, 0x0a, 0x0a, 0x06, 0x49, 0x47, 0x4e, 0x4f, 0x52, 0x45,
	0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x01, 0x12,
	0x10, 0x0a, 0x0c, 0x43, 0x4f, 0x4d, 0x50, 0x49, 0x4c, 0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10,
	0x02, 0x22, 0xac, 0x01, 0x0a, 0x12, 0x57, 0x68, 0x69, 0x6c, 0x65, 0x4c, 0x6f, 0x6f, 0x70, 0x55,
	0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x12, 0x22, 0x0a, 0x1e, 0x57, 0x48, 0x49, 0x4c,
	0x45, 0x5f, 0x4c, 0x4f, 0x4f, 0x50, 0x5f, 0x55, 0x4e, 0x52, 0x4f, 0x4c, 0x4c, 0x49, 0x4e, 0x47,
	0x5f, 0x4e, 0x4f, 0x5f, 0x55, 0x4e, 0x52, 0x4f, 0x4c, 0x4c, 0x10, 0x00, 0x12, 0x26, 0x0a, 0x22,
	0x57, 0x48, 0x49, 0x4c, 0x45, 0x5f, 0x4c, 0x4f, 0x4f, 0x50, 0x5f, 0x55, 0x4e, 0x52, 0x4f, 0x4c,
	0x4c, 0x49, 0x4e, 0x47, 0x5f, 0x44, 0x4f, 0x55, 0x42, 0x4c, 0x45, 0x5f, 0x42, 0x55, 0x46, 0x46,
	0x45, 0x52, 0x10, 0x01, 0x12, 0x24, 0x0a, 0x20, 0x57, 0x48, 0x49, 0x4c, 0x45, 0x5f, 0x4c, 0x4f,
	0x4f, 0x50, 0x5f, 0x55, 0x4e, 0x52, 0x4f, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x5f, 0x46, 0x55, 0x4c,
	0x4c, 0x5f, 0x55, 0x4e, 0x52, 0x4f, 0x4c, 0x4c, 0x10, 0x02, 0x12, 0x24, 0x0a, 0x20, 0x57, 0x48,
	0x49, 0x4c, 0x45, 0x5f, 0x4c, 0x4f, 0x4f, 0x50, 0x5f, 0x55, 0x4e, 0x52, 0x4f, 0x4c, 0x4c, 0x49,
	0x4e, 0x47, 0x5f, 0x41, 0x55, 0x54, 0x4f, 0x5f, 0x55, 0x4e, 0x52, 0x4f, 0x4c, 0x4c, 0x10, 0x03,
	0x22, 0x92, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x46, 0x75, 0x73, 0x69,
	0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x4c, 0x49, 0x42, 0x52, 0x41, 0x52,
	0x59, 0x5f, 0x46, 0x55, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x49, 0x4e,
	0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x4c, 0x49, 0x42, 0x52, 0x41,
	0x52, 0x59, 0x5f, 0x46, 0x55, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44,
	0x4f, 0x54, 0x10, 0x01, 0x12, 0x1f, 0x0a, 0x1b, 0x4c, 0x49, 0x42, 0x52, 0x41, 0x52, 0x59, 0x5f,
	0x46, 0x55, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x45, 0x4c, 0x54, 0x57,
	0x49, 0x53, 0x45, 0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a, 0x4c, 0x49, 0x42, 0x52, 0x41, 0x52, 0x59,
	0x5f, 0x46, 0x55, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x44,
	0x55, 0x43, 0x45, 0x10, 0x03, 0x22, 0xb0, 0x01, 0x0a, 0x12, 0x58, 0x6e, 0x6e, 0x47, 0x72, 0x61,
	0x70, 0x68, 0x46, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x22, 0x0a, 0x1e,
	0x58, 0x4e, 0x4e, 0x5f, 0x47, 0x52, 0x41, 0x50, 0x48, 0x5f, 0x46, 0x55, 0x53, 0x49, 0x4f, 0x4e,
	0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x20, 0x0a, 0x1c, 0x58, 0x4e, 0x4e, 0x5f, 0x47, 0x52, 0x41, 0x50, 0x48, 0x5f, 0x46, 0x55,
	0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x47, 0x52, 0x45, 0x45, 0x44, 0x59,
	0x10, 0x01, 0x12, 0x27, 0x0a, 0x23, 0x58, 0x4e, 0x4e, 0x5f, 0x47, 0x52, 0x41, 0x50, 0x48, 0x5f,
	0x46, 0x55, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x47, 0x52, 0x45, 0x45,
	0x44, 0x59, 0x5f, 0x53, 0x4c, 0x49, 0x4e, 0x4b, 0x59, 0x10, 0x02, 0x12, 0x2b, 0x0a, 0x27, 0x58,
	0x4e, 0x4e, 0x5f, 0x47, 0x52, 0x41, 0x50, 0x48, 0x5f, 0x46, 0x55, 0x53, 0x49, 0x4f, 0x4e, 0x5f,
	0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x42, 0x59, 0x50, 0x41, 0x53, 0x53, 0x5f, 0x43, 0x4f, 0x53, 0x54,
	0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x10, 0x03, 0x22, 0x45, 0x0a, 0x1b, 0x43, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x45, 0x52, 0x49, 0x41,
	0x4c, 0x49, 0x5a, 0x45, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x4f, 0x4e, 0x43, 0x55, 0x52,
	0x52, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x4c, 0x48, 0x53, 0x10, 0x02, 0x22,
	0xcd, 0x02, 0x0a, 0x1b, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x54, 0x72, 0x69, 0x74, 0x6f,
	0x6e, 0x45, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x72, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12,
	0x26, 0x0a, 0x22, 0x47, 0x45, 0x4e, 0x45, 0x52, 0x49, 0x43, 0x5f, 0x54, 0x52, 0x49, 0x54, 0x4f,
	0x4e, 0x5f, 0x45, 0x4d, 0x49, 0x54, 0x54, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x2d, 0x0a, 0x29, 0x47, 0x45, 0x4e, 0x45, 0x52,
	0x49, 0x43, 0x5f, 0x54, 0x52, 0x49, 0x54, 0x4f, 0x4e, 0x5f, 0x45, 0x4d, 0x49, 0x54, 0x54, 0x45,
	0x52, 0x5f, 0x45, 0x4e, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x4e, 0x45, 0x53, 0x54, 0x45, 0x44, 0x5f,
	0x47, 0x45, 0x4d, 0x4d, 0x10, 0x01, 0x12, 0x2e, 0x0a, 0x2a, 0x47, 0x45, 0x4e, 0x45, 0x52, 0x49,
	0x43, 0x5f, 0x54, 0x52, 0x49, 0x54, 0x4f, 0x4e, 0x5f, 0x45, 0x4d, 0x49, 0x54, 0x54, 0x45, 0x52,
	0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x4c, 0x45, 0x47, 0x41, 0x43, 0x59, 0x5f,
	0x47, 0x45, 0x4d, 0x4d, 0x10, 0x02, 0x12, 0x37, 0x0a, 0x33, 0x47, 0x45, 0x4e, 0x45, 0x52, 0x49,
	0x43, 0x5f, 0x54, 0x52, 0x49, 0x54, 0x4f, 0x4e, 0x5f, 0x45, 0x4d, 0x49, 0x54, 0x54, 0x45, 0x52,
	0x5f, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x5f, 0x41, 0x4c, 0x4c, 0x5f, 0x4f, 0x50, 0x53, 0x5f, 0x49,
	0x4e, 0x5f, 0x47, 0x45, 0x4d, 0x4d, 0x5f, 0x46, 0x55, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x12,
	0x30, 0x0a, 0x2c, 0x47, 0x45, 0x4e, 0x45, 0x52, 0x49, 0x43, 0x5f, 0x54, 0x52, 0x49, 0x54, 0x4f,
	0x4e, 0x5f, 0x45, 0x4d, 0x49, 0x54, 0x54, 0x45, 0x52, 0x5f, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x5f,
	0x41, 0x4c, 0x4c, 0x5f, 0x47, 0x45, 0x4d, 0x4d, 0x5f, 0x53, 0x48, 0x41, 0x50, 0x45, 0x53, 0x10,
	0x04, 0x12, 0x3c, 0x0a, 0x38, 0x47, 0x45, 0x4e, 0x45, 0x52, 0x49, 0x43, 0x5f, 0x54, 0x52, 0x49,
	0x54, 0x4f, 0x4e, 0x5f, 0x45, 0x4d, 0x49, 0x54, 0x54, 0x45, 0x52, 0x5f, 0x4d, 0x55, 0x53, 0x54,
	0x5f, 0x41, 0x43, 0x43, 0x45, 0x50, 0x54, 0x5f, 0x41, 0x4c, 0x4c, 0x5f, 0x41, 0x55, 0x54, 0x4f,
	0x54, 0x55, 0x4e, 0x45, 0x52, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x53, 0x10, 0x05, 0x22,
	0x7a, 0x0a, 0x1b, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6c,
	0x6c, 0x65, 0x6c, 0x69, 0x73, 0x6d, 0x4f, 0x70, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x2a,
	0x0a, 0x26, 0x50, 0x49, 0x50, 0x45, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x50, 0x41, 0x52, 0x41, 0x4c,
	0x4c, 0x45, 0x4c, 0x49, 0x53, 0x4d, 0x5f, 0x4f, 0x50, 0x54, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c,
	0x5f, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x00, 0x12, 0x29, 0x0a, 0x25, 0x50, 0x49,
	0x50, 0x45, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x50, 0x41, 0x52, 0x41, 0x4c, 0x4c, 0x45, 0x4c, 0x49,
	0x53, 0x4d, 0x5f, 0x4f, 0x50, 0x54, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x45, 0x4e, 0x41,
	0x42, 0x4c, 0x45, 0x10, 0x01, 0x22, 0x04, 0x08, 0x02, 0x10, 0x02, 0x22, 0x91, 0x01, 0x0a, 0x12,
	0x53, 0x74, 0x65, 0x70, 0x4d, 0x61, 0x72, 0x6b, 0x65, 0x72, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x54, 0x45, 0x50, 0x5f, 0x4d, 0x41, 0x52, 0x4b, 0x5f,
	0x41, 0x54, 0x5f, 0x45, 0x4e, 0x54, 0x52, 0x59, 0x10, 0x00, 0x12, 0x25, 0x0a, 0x21, 0x53, 0x54,
	0x45, 0x50, 0x5f, 0x4d, 0x41, 0x52, 0x4b, 0x5f, 0x41, 0x54, 0x5f, 0x54, 0x4f, 0x50, 0x5f, 0x4c,
	0x45, 0x56, 0x45, 0x4c, 0x5f, 0x57, 0x48, 0x49, 0x4c, 0x45, 0x5f, 0x4c, 0x4f, 0x4f, 0x50, 0x10,
	0x01, 0x12, 0x28, 0x0a, 0x24, 0x53, 0x54, 0x45, 0x50, 0x5f, 0x4d, 0x41, 0x52, 0x4b, 0x5f, 0x41,
	0x54, 0x5f, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x57,
	0x48, 0x49, 0x4c, 0x45, 0x5f, 0x4c, 0x4f, 0x4f, 0x50, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x53,
	0x54, 0x45, 0x50, 0x5f, 0x4d, 0x41, 0x52, 0x4b, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x02, 0x22,
	0x9b, 0x01, 0x0a, 0x15, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67,
	0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x1f, 0x0a, 0x1b, 0x50, 0x41, 0x52,
	0x54, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x4c, 0x47, 0x4f, 0x52, 0x49,
	0x54, 0x48, 0x4d, 0x5f, 0x4e, 0x4f, 0x4f, 0x50, 0x10, 0x00, 0x12, 0x1f, 0x0a, 0x1b, 0x50, 0x41,
	0x52, 0x54, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x4c, 0x47, 0x4f, 0x52,
	0x49, 0x54, 0x48, 0x4d, 0x5f, 0x45, 0x58, 0x50, 0x30, 0x10, 0x01, 0x12, 0x1f, 0x0a, 0x1b, 0x50,
	0x41, 0x52, 0x54, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x4c, 0x47, 0x4f,
	0x52, 0x49, 0x54, 0x48, 0x4d, 0x5f, 0x45, 0x58, 0x50, 0x31, 0x10, 0x02, 0x12, 0x1f, 0x0a, 0x1b,
	0x50, 0x41, 0x52, 0x54, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x4c, 0x47,
	0x4f, 0x52, 0x49, 0x54, 0x48, 0x4d, 0x5f, 0x45, 0x58, 0x50, 0x32, 0x10, 0x03, 0x22, 0xa7, 0x01,
	0x0a, 0x1e, 0x55, 0x6e, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x64, 0x75, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x6f, 0x64, 0x65,
	0x12, 0x2a, 0x0a, 0x26, 0x55, 0x4e, 0x53, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x52, 0x45, 0x44,
	0x55, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x00, 0x12, 0x2d, 0x0a, 0x29,
	0x55, 0x4e, 0x53, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x52, 0x45, 0x44, 0x55, 0x43, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44,
	0x45, 0x5f, 0x57, 0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x2a, 0x0a, 0x26, 0x55,
	0x4e, 0x53, 0x54, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x52, 0x45, 0x44, 0x55, 0x43, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x44, 0x45, 0x54, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d, 0x4f, 0x44, 0x45,
	0x5f, 0x46, 0x41, 0x49, 0x4c, 0x10, 0x02, 0x22, 0x76, 0x0a, 0x11, 0x41, 0x75, 0x74, 0x6f, 0x74,
	0x75, 0x6e, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x23, 0x0a, 0x1f,
	0x41, 0x55, 0x54, 0x4f, 0x54, 0x55, 0x4e, 0x45, 0x5f, 0x43, 0x41, 0x43, 0x48, 0x45, 0x5f, 0x4d,
	0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x1e, 0x0a, 0x1a, 0x41, 0x55, 0x54, 0x4f, 0x54, 0x55, 0x4e, 0x45, 0x5f, 0x43, 0x41,
	0x43, 0x48, 0x45, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10,
	0x01, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x55, 0x54, 0x4f, 0x54, 0x55, 0x4e, 0x45, 0x5f, 0x43, 0x41,
	0x43, 0x48, 0x45, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x52, 0x45, 0x41, 0x44, 0x10, 0x02, 0x42,
	0x2d, 0x0a, 0x2b, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x63,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x6c, 0x6f, 0x61, 0x64, 0x42, 0x21,
	0x0a, 0x1f, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x5f,
	0x66, 0x69, 0x78, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x79, 0x63, 0x6c, 0x65,
	0x73, 0x42, 0x37, 0x0a, 0x35, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x75, 0x6e, 0x73, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x72, 0x61, 0x73, 0x68, 0x5f, 0x6f, 0x6e, 0x5f, 0x68,
	0x6c, 0x6f, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x5f, 0x66, 0x69, 0x78, 0x5f, 0x6d, 0x61, 0x78, 0x5f,
	0x69, 0x74, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x30, 0x0a, 0x2e, 0x5f, 0x78,
	0x6c, 0x61, 0x5f, 0x75, 0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x63,
	0x72, 0x61, 0x73, 0x68, 0x5f, 0x6f, 0x6e, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x70, 0x61, 0x73, 0x73,
	0x5f, 0x6e, 0x6f, 0x6f, 0x70, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x36, 0x0a, 0x34,
	0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x75, 0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64,
	0x5f, 0x63, 0x72, 0x61, 0x73, 0x68, 0x5f, 0x6f, 0x6e, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x70, 0x61,
	0x73, 0x73, 0x5f, 0x73, 0x69, 0x6c, 0x65, 0x6e, 0x74, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x63, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x42, 0x2d, 0x0a, 0x2b, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75,
	0x5f, 0x63, 0x6f, 0x70, 0x79, 0x5f, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x75, 0x73, 0x65, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x42, 0x25, 0x0a, 0x23, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f,
	0x65, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x42, 0x31, 0x0a, 0x2f, 0x5f, 0x78,
	0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69,
	0x7a, 0x65, 0x64, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x42, 0x1b, 0x0a,
	0x19, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x66, 0x61, 0x73, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x68, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x78,
	0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x66, 0x61,
	0x73, 0x74, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x6d, 0x61, 0x78, 0x42, 0x2a, 0x0a, 0x28, 0x5f, 0x78,
	0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x6c, 0x5f, 0x6f, 0x6e, 0x65, 0x64, 0x6e, 0x6e, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x42, 0x2d, 0x0a, 0x2b, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x63,
	0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f,
	0x78, 0x6e, 0x6e, 0x5f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x42, 0x23, 0x0a, 0x21, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70,
	0x75, 0x5f, 0x66, 0x61, 0x73, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x68, 0x5f, 0x68, 0x6f, 0x6e, 0x6f,
	0x72, 0x5f, 0x64, 0x69, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x24, 0x0a, 0x22, 0x5f, 0x78,
	0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x66, 0x61, 0x73, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x68,
	0x5f, 0x68, 0x6f, 0x6e, 0x6f, 0x72, 0x5f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x42, 0x1f, 0x0a, 0x1d, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x66, 0x61, 0x73,
	0x74, 0x5f, 0x6d, 0x61, 0x74, 0x68, 0x5f, 0x68, 0x6f, 0x6e, 0x6f, 0x72, 0x5f, 0x69, 0x6e, 0x66,
	0x73, 0x42, 0x1f, 0x0a, 0x1d, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x66, 0x61,
	0x73, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x68, 0x5f, 0x68, 0x6f, 0x6e, 0x6f, 0x72, 0x5f, 0x6e, 0x61,
	0x6e, 0x73, 0x42, 0x36, 0x0a, 0x34, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x5f, 0x63,
	0x5f, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x5f, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x5f, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x78,
	0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x69, 0x73, 0x61, 0x42, 0x27,
	0x0a, 0x25, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6c,
	0x6c, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x67, 0x65, 0x6e, 0x5f, 0x73, 0x70, 0x6c, 0x69,
	0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x78, 0x6c, 0x61, 0x5f,
	0x63, 0x70, 0x75, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x5f, 0x77, 0x69, 0x64, 0x74, 0x68, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x78, 0x6c, 0x61, 0x5f,
	0x63, 0x70, 0x75, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65,
	0x6d, 0x69, 0x74, 0x74, 0x65, 0x72, 0x73, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x78, 0x6c, 0x61, 0x5f,
	0x63, 0x70, 0x75, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x78, 0x6e, 0x6e, 0x70, 0x61, 0x63, 0x6b, 0x42,
	0x17, 0x0a, 0x15, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x66,
	0x61, 0x73, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x68, 0x42, 0x25, 0x0a, 0x23, 0x5f, 0x78, 0x6c, 0x61,
	0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x75, 0x6e, 0x6f, 0x70, 0x74, 0x69,
	0x6d, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x42,
	0x22, 0x0a, 0x20, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x61, 0x6c, 0x67, 0x6f,
	0x72, 0x69, 0x74, 0x68, 0x6d, 0x5f, 0x64, 0x65, 0x6e, 0x79, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x70,
	0x61, 0x74, 0x68, 0x42, 0x2d, 0x0a, 0x2b, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x61, 0x6c, 0x6c, 0x5f, 0x67, 0x61, 0x74, 0x68, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6d, 0x62, 0x69,
	0x6e, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x5f, 0x62, 0x79, 0x74,
	0x65, 0x73, 0x42, 0x36, 0x0a, 0x34, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x61,
	0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x64, 0x75, 0x63, 0x65, 0x5f, 0x62, 0x6c, 0x75, 0x65, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x42, 0x2d, 0x0a, 0x2b, 0x5f, 0x78,
	0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x64, 0x75, 0x63,
	0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68,
	0x6f, 0x6c, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x78, 0x6c,
	0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x64, 0x6f, 0x74, 0x42,
	0x32, 0x0a, 0x30, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x61, 0x75, 0x74, 0x6f,
	0x5f, 0x73, 0x70, 0x6d, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x69,
	0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74,
	0x5f, 0x67, 0x62, 0x42, 0x35, 0x0a, 0x33, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x61, 0x75, 0x74, 0x6f, 0x5f, 0x73, 0x70, 0x6d, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x62, 0x75,
	0x64, 0x67, 0x65, 0x74, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x42, 0x1d, 0x0a, 0x1b, 0x5f, 0x78,
	0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x5f,
	0x67, 0x65, 0x6d, 0x6d, 0x5f, 0x72, 0x74, 0x6f, 0x6c, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x78, 0x6c,
	0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x5f, 0x6c,
	0x65, 0x76, 0x65, 0x6c, 0x42, 0x21, 0x0a, 0x1f, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75,
	0x5f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x23, 0x0a, 0x21, 0x5f, 0x78, 0x6c, 0x61, 0x5f,
	0x67, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x73, 0x74,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x42, 0x26, 0x0a, 0x24,
	0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x61,
	0x63, 0x74, 0x6f, 0x72, 0x42, 0x35, 0x0a, 0x33, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75,
	0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x6d,
	0x75, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65,
	0x73, 0x68, 0x6f, 0x6c, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x42, 0x32, 0x0a, 0x30, 0x5f,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x64, 0x65, 0x63, 0x6f, 0x6d,
	0x70, 0x6f, 0x73, 0x65, 0x72, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x42,
	0x2d, 0x0a, 0x2b, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x6c, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x73, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x73,
	0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6c, 0x69, 0x71, 0x75, 0x65, 0x73, 0x42, 0x29,
	0x0a, 0x27, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x5f, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x42, 0x26, 0x0a, 0x24, 0x5f, 0x78, 0x6c,
	0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x62, 0x75,
	0x66, 0x66, 0x65, 0x72, 0x5f, 0x75, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x5f, 0x6c, 0x6f, 0x6f, 0x70,
	0x73, 0x42, 0x2d, 0x0a, 0x2b, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x63, 0x6f,
	0x70, 0x79, 0x5f, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x73, 0x65,
	0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x42, 0x29, 0x0a, 0x27, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x63, 0x72, 0x61,
	0x73, 0x68, 0x5f, 0x6f, 0x6e, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x73, 0x42, 0x1a, 0x0a, 0x18, 0x5f,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x63, 0x75, 0x62, 0x6c, 0x61, 0x73, 0x5f, 0x66,
	0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x78, 0x6c, 0x61, 0x5f,
	0x67, 0x70, 0x75, 0x5f, 0x63, 0x75, 0x64, 0x61, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x64, 0x69,
	0x72, 0x42, 0x22, 0x0a, 0x20, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x63, 0x75,
	0x64, 0x6e, 0x6e, 0x5f, 0x67, 0x65, 0x6d, 0x6d, 0x5f, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x6c, 0x65, 0x76, 0x65, 0x6c, 0x42, 0x1f, 0x0a, 0x1d, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70,
	0x75, 0x5f, 0x63, 0x75, 0x64, 0x6e, 0x6e, 0x5f, 0x67, 0x65, 0x6d, 0x6d, 0x5f, 0x6d, 0x61, 0x78,
	0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x73, 0x42, 0x1c, 0x0a, 0x1a, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67,
	0x70, 0x75, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x69, 0x63,
	0x5f, 0x6f, 0x70, 0x73, 0x42, 0x27, 0x0a, 0x25, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75,
	0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x67, 0x70, 0x75, 0x61, 0x73, 0x6d, 0x5f,
	0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x22, 0x0a,
	0x20, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x64, 0x6f, 0x74, 0x5f, 0x6d, 0x65,
	0x72, 0x67, 0x65, 0x72, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x5f, 0x6d,
	0x62, 0x42, 0x20, 0x0a, 0x1e, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x64, 0x75,
	0x6d, 0x70, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x5f, 0x6c, 0x6f, 0x67, 0x73,
	0x5f, 0x74, 0x6f, 0x42, 0x23, 0x0a, 0x21, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x64, 0x75, 0x6d, 0x70, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x5f, 0x74, 0x6f, 0x42, 0x26, 0x0a, 0x24, 0x5f, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75,
	0x6e, 0x65, 0x64, 0x5f, 0x67, 0x65, 0x6d, 0x6d, 0x5f, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x42, 0x16, 0x0a, 0x14, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x64, 0x75, 0x6d,
	0x70, 0x5f, 0x6c, 0x6c, 0x76, 0x6d, 0x69, 0x72, 0x42, 0x2b, 0x0a, 0x29, 0x5f, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x6c, 0x6c, 0x5f,
	0x67, 0x61, 0x74, 0x68, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x5f, 0x62,
	0x79, 0x5f, 0x64, 0x69, 0x6d, 0x42, 0x2e, 0x0a, 0x2c, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70,
	0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x61, 0x6c, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x65, 0x73, 0x74, 0x69,
	0x6d, 0x61, 0x74, 0x6f, 0x72, 0x42, 0x32, 0x0a, 0x30, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70,
	0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x61, 0x6c, 0x5f, 0x73, 0x6f, 0x6c, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f,
	0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x6f, 0x72, 0x42, 0x2b, 0x0a, 0x29, 0x5f, 0x78, 0x6c,
	0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x70, 0x70,
	0x72, 0x6f, 0x78, 0x5f, 0x63, 0x6f, 0x73, 0x74, 0x6c, 0x79, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x73, 0x42, 0x20, 0x0a, 0x1e, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67,
	0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x75, 0x62, 0x5f, 0x72, 0x61,
	0x64, 0x69, 0x78, 0x5f, 0x73, 0x6f, 0x72, 0x74, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x75, 0x62, 0x6c,
	0x61, 0x73, 0x6c, 0x74, 0x42, 0x36, 0x0a, 0x34, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75,
	0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x75, 0x64, 0x6e, 0x6e, 0x5f, 0x69, 0x6e,
	0x74, 0x38, 0x78, 0x33, 0x32, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x72, 0x65, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x42, 0x22, 0x0a, 0x20,
	0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x63, 0x75, 0x64, 0x6e, 0x6e, 0x5f, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x5f, 0x6e, 0x6f, 0x72, 0x6d,
	0x42, 0x26, 0x0a, 0x24, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x5f, 0x73, 0x6c, 0x69, 0x63,
	0x65, 0x5f, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x66, 0x61, 0x73, 0x74,
	0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x6d, 0x61, 0x78, 0x42, 0x2f, 0x0a, 0x2d, 0x5f, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x68, 0x69, 0x67, 0x68,
	0x65, 0x73, 0x74, 0x5f, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x61, 0x73, 0x79,
	0x6e, 0x63, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x42, 0x28, 0x0a, 0x26, 0x5f, 0x78, 0x6c,
	0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x68, 0x6f, 0x73,
	0x74, 0x5f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x6f, 0x66, 0x66, 0x6c, 0x6f, 0x61, 0x64,
	0x69, 0x6e, 0x67, 0x42, 0x2a, 0x0a, 0x28, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x68,
	0x69, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x42,
	0x22, 0x0a, 0x20, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x6c, 0x69, 0x62, 0x6e, 0x76, 0x70, 0x74, 0x78, 0x63, 0x6f, 0x6d, 0x70, 0x69,
	0x6c, 0x65, 0x72, 0x42, 0x35, 0x0a, 0x33, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6c, 0x6c, 0x76, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70,
	0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x69, 0x73, 0x6d, 0x42, 0x2a, 0x0a, 0x28, 0x5f, 0x78,
	0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x63,
	0x63, 0x6c, 0x5f, 0x63, 0x6c, 0x69, 0x71, 0x75, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x25, 0x0a, 0x23, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67,
	0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x63, 0x63, 0x6c, 0x5f, 0x63,
	0x6f, 0x6d, 0x6d, 0x5f, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x23, 0x0a,
	0x21, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x6e, 0x63, 0x63, 0x6c, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x62, 0x75, 0x66, 0x66, 0x65,
	0x72, 0x73, 0x42, 0x26, 0x0a, 0x24, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x64, 0x5f,
	0x61, 0x6c, 0x6c, 0x5f, 0x67, 0x61, 0x74, 0x68, 0x65, 0x72, 0x42, 0x26, 0x0a, 0x24, 0x5f, 0x78,
	0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x64, 0x75,
	0x63, 0x65, 0x42, 0x27, 0x0a, 0x25, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x64, 0x5f,
	0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x73, 0x42, 0x1f, 0x0a, 0x1d, 0x5f,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x70, 0x32, 0x70, 0x42, 0x2a, 0x0a, 0x28,
	0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x64, 0x75, 0x63, 0x65,
	0x5f, 0x73, 0x63, 0x61, 0x74, 0x74, 0x65, 0x72, 0x42, 0x30, 0x0a, 0x2e, 0x5f, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x73,
	0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x6f, 0x72, 0x5f, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x72, 0x42, 0x2f, 0x0a, 0x2d, 0x5f, 0x78,
	0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65,
	0x64, 0x75, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x61, 0x74, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6d,
	0x62, 0x69, 0x6e, 0x65, 0x5f, 0x62, 0x79, 0x5f, 0x64, 0x69, 0x6d, 0x42, 0x2b, 0x0a, 0x29, 0x5f,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72,
	0x65, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x70, 0x69, 0x6c, 0x6f, 0x67, 0x75,
	0x65, 0x5f, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x2e, 0x0a, 0x2c, 0x5f, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x63, 0x61, 0x74,
	0x74, 0x65, 0x72, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x6d, 0x5f,
	0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x65, 0x72, 0x42, 0x22, 0x0a, 0x20, 0x5f, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x68, 0x61, 0x72,
	0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x73, 0x42, 0x24, 0x0a, 0x22,
	0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f, 0x6b, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x69,
	0x6e, 0x67, 0x42, 0x1d, 0x0a, 0x1b, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x72, 0x69, 0x74, 0x6f, 0x6e, 0x5f, 0x67, 0x65, 0x6d,
	0x6d, 0x42, 0x2d, 0x0a, 0x2b, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x77, 0x68, 0x69, 0x6c, 0x65, 0x5f, 0x6c, 0x6f, 0x6f, 0x70, 0x5f,
	0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x5f, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0x42, 0x37, 0x0a, 0x35, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x77, 0x68, 0x69, 0x6c, 0x65, 0x5f, 0x6c, 0x6f, 0x6f, 0x70, 0x5f, 0x72,
	0x65, 0x64, 0x75, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x61, 0x74, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x5f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x26, 0x0a, 0x24, 0x5f, 0x78, 0x6c,
	0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x77, 0x68, 0x69,
	0x6c, 0x65, 0x5f, 0x6c, 0x6f, 0x6f, 0x70, 0x5f, 0x75, 0x6e, 0x72, 0x6f, 0x6c, 0x6c, 0x69, 0x6e,
	0x67, 0x42, 0x27, 0x0a, 0x25, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x6e, 0x6f, 0x6e, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69,
	0x6e, 0x69, 0x73, 0x74, 0x69, 0x63, 0x5f, 0x6f, 0x70, 0x73, 0x42, 0x2f, 0x0a, 0x2d, 0x5f, 0x78,
	0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x6f, 0x75, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x42, 0x30, 0x0a, 0x2e, 0x5f,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x77, 0x61, 0x72, 0x6e, 0x5f, 0x73, 0x74, 0x75, 0x63, 0x6b, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x42, 0x23, 0x0a,
	0x21, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x68, 0x61, 0x75, 0x73,
	0x74, 0x69, 0x76, 0x65, 0x5f, 0x74, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x42, 0x2b, 0x0a, 0x29, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65,
	0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x61, 0x75, 0x74, 0x6f,
	0x74, 0x75, 0x6e, 0x65, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x42,
	0x2b, 0x0a, 0x29, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e,
	0x65, 0x72, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x42, 0x39, 0x0a, 0x37,
	0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x63, 0x73, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x68,
	0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x42, 0x32, 0x0a, 0x30, 0x5f, 0x78, 0x6c, 0x61, 0x5f,
	0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c,
	0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x66,
	0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x42, 0x30, 0x0a, 0x2e, 0x5f,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x62, 0x69, 0x6e,
	0x61, 0x72, 0x79, 0x5f, 0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x42, 0x29, 0x0a,
	0x27, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x66, 0x64, 0x6f, 0x5f,
	0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x42, 0x37, 0x0a, 0x35, 0x5f, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x6c, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x6c, 0x6c, 0x74, 0x6f, 0x61, 0x6c,
	0x6c, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x65, 0x69, 0x6e, 0x73, 0x75,
	0x6d, 0x42, 0x37, 0x0a, 0x35, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72,
	0x5f, 0x6f, 0x6e, 0x5f, 0x74, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x42, 0x2f, 0x0a, 0x2d, 0x5f, 0x78,
	0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x6c, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x66, 0x75, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x72, 0x42, 0x3a, 0x0a, 0x38, 0x5f,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x66, 0x75, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x5f, 0x72,
	0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x72, 0x42, 0x3d, 0x0a, 0x3b, 0x5f, 0x78, 0x6c, 0x61, 0x5f,
	0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c,
	0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x68, 0x65, 0x75, 0x72, 0x69, 0x73, 0x74, 0x69,
	0x63, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x6d,
	0x62, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x42, 0x35, 0x0a, 0x33, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67,
	0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x63, 0x63, 0x6c, 0x5f, 0x73, 0x79, 0x6d, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x73, 0x42, 0x26, 0x0a,
	0x24, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x76,
	0x73, 0x68, 0x6d, 0x65, 0x6d, 0x42, 0x2e, 0x0a, 0x2c, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70,
	0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f, 0x6b, 0x5f, 0x72, 0x65,
	0x77, 0x72, 0x69, 0x74, 0x65, 0x42, 0x3f, 0x0a, 0x3d, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70,
	0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x75, 0x62, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x5f, 0x64, 0x65, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x3e, 0x0a, 0x3c, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67,
	0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x72, 0x69, 0x74, 0x6f, 0x6e, 0x5f, 0x68, 0x65,
	0x72, 0x6f, 0x6c, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x5f,
	0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x29, 0x0a, 0x27, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67,
	0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x72, 0x69, 0x74, 0x6f, 0x6e, 0x5f, 0x74, 0x6d,
	0x61, 0x42, 0x3b, 0x0a, 0x39, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x5f,
	0x64, 0x6f, 0x74, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x5f, 0x61, 0x6c, 0x6f,
	0x6e, 0x67, 0x5f, 0x6b, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x39,
	0x0a, 0x37, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c,
	0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6f, 0x76, 0x65, 0x72,
	0x6c, 0x61, 0x70, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x42, 0x36, 0x0a, 0x34, 0x5f, 0x78, 0x6c,
	0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x6c, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x61,
	0x6c, 0x6c, 0x65, 0x6c, 0x69, 0x73, 0x6d, 0x5f, 0x6f, 0x70, 0x74, 0x5f, 0x6c, 0x65, 0x76, 0x65,
	0x6c, 0x42, 0x29, 0x0a, 0x27, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78,
	0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x2a, 0x0a, 0x28,
	0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75,
	0x6e, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x42, 0x2d, 0x0a, 0x2b, 0x5f, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x6c, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x72, 0x61, 0x67, 0x67, 0x65, 0x64, 0x5f, 0x64, 0x6f, 0x74,
	0x5f, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x34, 0x0a, 0x32, 0x5f, 0x78, 0x6c, 0x61, 0x5f,
	0x67, 0x70, 0x75, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x5f, 0x70, 0x74, 0x78, 0x5f, 0x63, 0x6f, 0x6d,
	0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x42, 0x3a, 0x0a,
	0x38, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x5f, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x73, 0x5f, 0x73, 0x70, 0x69, 0x6c, 0x6c, 0x69, 0x6e,
	0x67, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x73, 0x5f, 0x6f, 0x6e, 0x5f, 0x61,
	0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x42, 0x3a, 0x0a, 0x38, 0x5f, 0x78, 0x6c,
	0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x66, 0x69, 0x72, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6c, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x74, 0x65, 0x72, 0x6d,
	0x69, 0x6e, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x73, 0x42, 0x3b, 0x0a, 0x39, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70,
	0x75, 0x5f, 0x66, 0x69, 0x72, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x77, 0x61, 0x72, 0x6e, 0x5f, 0x73, 0x74, 0x75,
	0x63, 0x6b, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e,
	0x64, 0x73, 0x42, 0x28, 0x0a, 0x26, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x66,
	0x6f, 0x72, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x69, 0x73, 0x6d, 0x42, 0x1a, 0x0a, 0x18,
	0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x76, 0x5f, 0x6e, 0x63, 0x68, 0x77, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x5f,
	0x6e, 0x68, 0x77, 0x63, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75,
	0x5f, 0x66, 0x74, 0x7a, 0x42, 0x28, 0x0a, 0x26, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75,
	0x5f, 0x66, 0x75, 0x73, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x75, 0x73, 0x65, 0x5f, 0x63, 0x75, 0x64, 0x6e, 0x6e, 0x5f, 0x72, 0x6e, 0x67, 0x42, 0x26,
	0x0a, 0x24, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x67, 0x65, 0x6d, 0x6d, 0x5f,
	0x72, 0x65, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x74, 0x68, 0x72,
	0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67,
	0x70, 0x75, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x65, 0x62, 0x75,
	0x67, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x42, 0x1d, 0x0a, 0x1b, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67,
	0x70, 0x75, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x65,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x42, 0x29, 0x0a, 0x27, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70,
	0x75, 0x5f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x42, 0x1f, 0x0a, 0x1d, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x67, 0x72, 0x61,
	0x70, 0x68, 0x5f, 0x6d, 0x69, 0x6e, 0x5f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x42, 0x1c, 0x0a, 0x1a, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x6b, 0x65,
	0x72, 0x6e, 0x65, 0x6c, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x42,
	0x1c, 0x0a, 0x1a, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x6c, 0x69, 0x62, 0x6e,
	0x76, 0x6a, 0x69, 0x74, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x42, 0x22, 0x0a,
	0x20, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x6c, 0x6c, 0x76, 0x6d, 0x5f, 0x76,
	0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x65, 0x76, 0x65,
	0x6c, 0x42, 0x25, 0x0a, 0x23, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x6c, 0x6f,
	0x61, 0x64, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x42, 0x23, 0x0a, 0x21, 0x5f, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x69, 0x6d, 0x69,
	0x74, 0x5f, 0x73, 0x6c, 0x6f, 0x70, 0x5f, 0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x1c, 0x0a,
	0x1a, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x6d, 0x6f, 0x63, 0x6b, 0x5f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x73, 0x42, 0x29, 0x0a, 0x27, 0x5f,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x5f, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x65, 0x64, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x65, 0x64, 0x5f,
	0x65, 0x69, 0x6e, 0x73, 0x75, 0x6d, 0x42, 0x1f, 0x0a, 0x1d, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67,
	0x70, 0x75, 0x5f, 0x6e, 0x63, 0x63, 0x6c, 0x5f, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x26, 0x0a, 0x24, 0x5f, 0x78, 0x6c, 0x61, 0x5f,
	0x67, 0x70, 0x75, 0x5f, 0x6e, 0x63, 0x63, 0x6c, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x69, 0x6e,
	0x67, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x42,
	0x28, 0x0a, 0x26, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x6e, 0x63, 0x63, 0x6c,
	0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6d, 0x61, 0x78, 0x5f,
	0x6e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x42, 0x2c, 0x0a, 0x2a, 0x5f, 0x78, 0x6c,
	0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x6e, 0x63, 0x63, 0x6c, 0x5f, 0x69, 0x6e, 0x69, 0x74, 0x5f,
	0x6d, 0x61, 0x78, 0x5f, 0x72, 0x61, 0x6e, 0x6b, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x72, 0x6f, 0x6f,
	0x74, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x42, 0x21, 0x0a, 0x1f, 0x5f, 0x78, 0x6c, 0x61, 0x5f,
	0x67, 0x70, 0x75, 0x5f, 0x6e, 0x63, 0x63, 0x6c, 0x5f, 0x70, 0x32, 0x70, 0x5f, 0x6d, 0x61, 0x78,
	0x5f, 0x6e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x42, 0x22, 0x0a, 0x20, 0x5f, 0x78,
	0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x6e, 0x63, 0x63, 0x6c, 0x5f, 0x74, 0x65, 0x72, 0x6d,
	0x69, 0x6e, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x42, 0x2b,
	0x0a, 0x29, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x6e, 0x63, 0x63, 0x6c, 0x5f,
	0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x6f, 0x75, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73, 0x42, 0x36, 0x0a, 0x34, 0x5f,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x6e, 0x64, 0x5f,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x5f,
	0x66, 0x6f, 0x72, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x65, 0x69, 0x6e,
	0x73, 0x75, 0x6d, 0x42, 0x22, 0x0a, 0x20, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x5f, 0x67, 0x65, 0x6d, 0x6d, 0x5f, 0x61, 0x75,
	0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x72, 0x42, 0x28, 0x0a, 0x26, 0x5f, 0x78, 0x6c, 0x61, 0x5f,
	0x67, 0x70, 0x75, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x61,
	0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e, 0x65, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x64, 0x69,
	0x72, 0x42, 0x20, 0x0a, 0x1e, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x70, 0x67,
	0x6c, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x5f, 0x63, 0x68, 0x65, 0x63,
	0x6b, 0x65, 0x72, 0x42, 0x2e, 0x0a, 0x2c, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x70, 0x67, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x6f, 0x72, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x70,
	0x61, 0x74, 0x68, 0x42, 0x31, 0x0a, 0x2f, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x72, 0x65, 0x64, 0x75, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x61, 0x74, 0x74, 0x65, 0x72, 0x5f, 0x63,
	0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64,
	0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x42, 0x20, 0x0a, 0x1e, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67,
	0x70, 0x75, 0x5f, 0x72, 0x65, 0x64, 0x7a, 0x6f, 0x6e, 0x65, 0x5f, 0x70, 0x61, 0x64, 0x64, 0x69,
	0x6e, 0x67, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x42, 0x30, 0x0a, 0x2e, 0x5f, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x61, 0x6f, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75,
	0x6e, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x42, 0x21, 0x0a, 0x1f, 0x5f, 0x78,
	0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x5f, 0x65,
	0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x6b, 0x42, 0x17, 0x0a,
	0x15, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x73, 0x68, 0x61, 0x70, 0x65, 0x5f,
	0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x42, 0x1b, 0x0a, 0x19, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67,
	0x70, 0x75, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x74, 0x75, 0x6e,
	0x69, 0x6e, 0x67, 0x42, 0x27, 0x0a, 0x25, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x5f, 0x61, 0x6c, 0x67, 0x6f,
	0x72, 0x69, 0x74, 0x68, 0x6d, 0x5f, 0x70, 0x69, 0x63, 0x6b, 0x65, 0x72, 0x42, 0x21, 0x0a, 0x1f,
	0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x42,
	0x29, 0x0a, 0x27, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x74, 0x65, 0x6d, 0x70,
	0x5f, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x70, 0x61,
	0x72, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x42, 0x2c, 0x0a, 0x2a, 0x5f, 0x78,
	0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64,
	0x5f, 0x66, 0x6f, 0x72, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x65, 0x69,
	0x6e, 0x73, 0x75, 0x6d, 0x5f, 0x6d, 0x69, 0x62, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x74, 0x72, 0x69, 0x74, 0x6f, 0x6e, 0x5f, 0x67, 0x65, 0x6d, 0x6d,
	0x5f, 0x61, 0x6e, 0x79, 0x42, 0x37, 0x0a, 0x35, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75,
	0x5f, 0x75, 0x6e, 0x73, 0x61, 0x66, 0x65, 0x5f, 0x66, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b,
	0x5f, 0x74, 0x6f, 0x5f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x5f, 0x6f, 0x6e, 0x5f, 0x70, 0x74,
	0x78, 0x61, 0x73, 0x5f, 0x6e, 0x6f, 0x74, 0x5f, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x42, 0x30, 0x0a,
	0x2e, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x75, 0x6e, 0x73, 0x75, 0x70, 0x70,
	0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x77,
	0x69, 0x74, 0x68, 0x5f, 0x65, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x72, 0x5f, 0x6c, 0x6f, 0x63, 0x42,
	0x33, 0x0a, 0x31, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x75, 0x6e, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61,
	0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x64, 0x75, 0x63, 0x65, 0x5f, 0x64, 0x65, 0x63, 0x6f, 0x6d, 0x70,
	0x6f, 0x73, 0x65, 0x72, 0x42, 0x3a, 0x0a, 0x38, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75,
	0x5f, 0x75, 0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x72, 0x61, 0x67, 0x67, 0x65, 0x64, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x74,
	0x6f, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x64, 0x65, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65, 0x72,
	0x42, 0x29, 0x0a, 0x27, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x75, 0x6e, 0x73,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x74, 0x72, 0x69, 0x74, 0x6f, 0x6e, 0x5f, 0x67, 0x65, 0x6d, 0x6d, 0x42, 0x38, 0x0a, 0x36, 0x5f,
	0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x75, 0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72,
	0x74, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x74, 0x72, 0x69, 0x74, 0x6f,
	0x6e, 0x5f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x66,
	0x75, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x35, 0x0a, 0x33, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70,
	0x75, 0x5f, 0x75, 0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x75, 0x73,
	0x65, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x64, 0x75, 0x63, 0x65, 0x5f, 0x6f, 0x6e, 0x65,
	0x5f, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x42, 0x3c, 0x0a, 0x3a,
	0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x75, 0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f,
	0x72, 0x74, 0x65, 0x64, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x72, 0x61, 0x67, 0x67, 0x65, 0x64, 0x5f,
	0x61, 0x6c, 0x6c, 0x5f, 0x74, 0x6f, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x6f, 0x6e, 0x65, 0x5f, 0x73,
	0x68, 0x6f, 0x74, 0x5f, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x42, 0x1c, 0x0a, 0x1a, 0x5f, 0x78,
	0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x69, 0x6e, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x6c, 0x64, 0x42, 0x1f, 0x0a, 0x1d, 0x5f, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x6d, 0x65, 0x6d, 0x63, 0x70, 0x79, 0x5f,
	0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x70, 0x32, 0x70, 0x42, 0x1d, 0x0a, 0x1b, 0x5f, 0x78, 0x6c,
	0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x28, 0x0a, 0x26, 0x5f, 0x78, 0x6c, 0x61,
	0x5f, 0x67, 0x70, 0x75, 0x5f, 0x76, 0x65, 0x72, 0x69, 0x66, 0x79, 0x5f, 0x74, 0x72, 0x69, 0x74,
	0x6f, 0x6e, 0x5f, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69,
	0x63, 0x73, 0x42, 0x1a, 0x0a, 0x18, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x67,
	0x72, 0x61, 0x70, 0x68, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x42, 0x12,
	0x0a, 0x10, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x42, 0x1d, 0x0a, 0x1b, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x65,
	0x73, 0x42, 0x21, 0x0a, 0x1f, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e,
	0x64, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c,
	0x65, 0x76, 0x65, 0x6c, 0x42, 0x1d, 0x0a, 0x1b, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x65, 0x6d, 0x62,
	0x65, 0x64, 0x5f, 0x69, 0x72, 0x5f, 0x69, 0x6e, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x42, 0x27, 0x0a, 0x25, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x65, 0x6c, 0x69, 0x6d,
	0x69, 0x6e, 0x61, 0x74, 0x65, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x69, 0x6d, 0x70, 0x6c, 0x69, 0x63,
	0x69, 0x74, 0x5f, 0x62, 0x72, 0x6f, 0x61, 0x64, 0x63, 0x61, 0x73, 0x74, 0x42, 0x1d, 0x0a, 0x1b,
	0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x5f, 0x74,
	0x68, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x65, 0x69, 0x67, 0x65, 0x6e, 0x42, 0x27, 0x0a, 0x25, 0x5f,
	0x78, 0x6c, 0x61, 0x5f, 0x6c, 0x6c, 0x76, 0x6d, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x61, 0x6c, 0x69, 0x61, 0x73, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x42, 0x23, 0x0a, 0x21, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x6c, 0x6c, 0x76,
	0x6d, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x6f, 0x61, 0x6c, 0x69, 0x61, 0x73,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x2a, 0x0a, 0x28, 0x5f, 0x78, 0x6c,
	0x61, 0x5f, 0x6c, 0x6c, 0x76, 0x6d, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6e,
	0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x24, 0x0a, 0x22, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x6c, 0x6c,
	0x76, 0x6d, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x6e,
	0x73, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x65, 0x73, 0x42, 0x1e, 0x0a, 0x1c, 0x5f,
	0x78, 0x6c, 0x61, 0x5f, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x5f, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x73, 0x42, 0x1d, 0x0a, 0x1b, 0x5f,
	0x78, 0x6c, 0x61, 0x5f, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x5f, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x73, 0x42, 0x1f, 0x0a, 0x1d, 0x5f, 0x78,
	0x6c, 0x61, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x5f, 0x73, 0x68, 0x61,
	0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x42, 0x15, 0x0a, 0x13, 0x5f,
	0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x6f, 0x6e, 0x65, 0x64,
	0x6e, 0x6e, 0x42, 0x1d, 0x0a, 0x1b, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x5f, 0x65, 0x78, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x42, 0x27, 0x0a, 0x25, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f,
	0x68, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x22, 0x0a, 0x20, 0x5f, 0x78,
	0x6c, 0x61, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x6f, 0x72,
	0x5f, 0x75, 0x73, 0x65, 0x5f, 0x66, 0x61, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x42, 0x25,
	0x0a, 0x23, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x73, 0x63, 0x61,
	0x6c, 0x61, 0x72, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69,
	0x63, 0x5f, 0x6f, 0x70, 0x73, 0x42, 0x1b, 0x0a, 0x19, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x73, 0x74,
	0x65, 0x70, 0x5f, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f,
	0x74, 0x6f, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x73,
	0x5f, 0x72, 0x65, 0x73, 0x65, 0x74, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x64,
	0x75, 0x6d, 0x70, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x72,
	0x65, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x68,
	0x6c, 0x6f, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x5f, 0x72, 0x65, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x78,
	0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x61, 0x73, 0x5f, 0x74,
	0x65, 0x78, 0x74, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70,
	0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x61, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x42, 0x16, 0x0a,
	0x14, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x61,
	0x73, 0x5f, 0x64, 0x6f, 0x74, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75,
	0x6d, 0x70, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x61, 0x73, 0x5f, 0x75, 0x72, 0x6c, 0x42, 0x17, 0x0a,
	0x15, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x61,
	0x73, 0x5f, 0x68, 0x74, 0x6d, 0x6c, 0x42, 0x20, 0x0a, 0x1e, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x64,
	0x75, 0x6d, 0x70, 0x5f, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x69, 0x73, 0x75, 0x61,
	0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x78, 0x6c, 0x61,
	0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x73, 0x42, 0x1d, 0x0a, 0x1b, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70,
	0x5f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x1b, 0x0a, 0x19, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f,
	0x6d, 0x61, 0x78, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x42,
	0x1b, 0x0a, 0x19, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x1b, 0x0a, 0x19,
	0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65,
	0x73, 0x73, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x42, 0x1c, 0x0a, 0x1a, 0x5f, 0x78, 0x6c,
	0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x61, 0x73, 0x5f, 0x6c, 0x6f,
	0x6e, 0x67, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x42, 0x23, 0x0a, 0x21, 0x5f, 0x78, 0x6c, 0x61, 0x5f,
	0x64, 0x75, 0x6d, 0x70, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6d, 0x6c, 0x69, 0x72,
	0x5f, 0x70, 0x72, 0x65, 0x74, 0x74, 0x79, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x1b, 0x0a, 0x19,
	0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x68,
	0x6c, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x78, 0x6c,
	0x61, 0x5f, 0x74, 0x70, 0x75, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x61, 0x6e,
	0x42, 0x15, 0x0a, 0x13, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x74, 0x70, 0x75, 0x5f, 0x64, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x42, 0x1f, 0x0a, 0x1d, 0x5f, 0x78, 0x6c, 0x61, 0x5f,
	0x63, 0x70, 0x75, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x78, 0x70, 0x72, 0x6f, 0x66,
	0x5f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x6d, 0x65, 0x42, 0x29, 0x0a, 0x27, 0x5f, 0x78, 0x6c, 0x61,
	0x5f, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x68, 0x65, 0x61, 0x70, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x68,
	0x65, 0x61, 0x70, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x42, 0x15, 0x0a, 0x13,
	0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x75, 0x6d, 0x70,
	0x69, 0x6e, 0x67, 0x42, 0x25, 0x0a, 0x23, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x6c, 0x6c, 0x76, 0x6d,
	0x5f, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x62, 0x65,
	0x66, 0x6f, 0x72, 0x65, 0x5f, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x42, 0x1c, 0x0a, 0x1a, 0x5f, 0x78,
	0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x1b, 0x0a, 0x19, 0x5f, 0x78, 0x6c, 0x61,
	0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x68, 0x6c, 0x6f, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x5f, 0x72, 0x65, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x70,
	0x75, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x63, 0x6c, 0x42, 0x1f, 0x0a, 0x1d, 0x5f, 0x78, 0x6c,
	0x61, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x5f, 0x64, 0x6f, 0x74,
	0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x5f, 0x6d, 0x61, 0x74, 0x68, 0x42, 0x23, 0x0a, 0x21, 0x5f, 0x78,
	0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x6c, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x5f,
	0x68, 0x69, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x42,
	0x1d, 0x0a, 0x1b, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x42, 0x27,
	0x0a, 0x25, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x65, 0x62, 0x75, 0x67, 0x5f, 0x62, 0x75, 0x66,
	0x66, 0x65, 0x72, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73,
	0x68, 0x6f, 0x77, 0x5f, 0x6d, 0x61, 0x78, 0x42, 0x21, 0x0a, 0x1f, 0x5f, 0x78, 0x6c, 0x61, 0x5f,
	0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x5f, 0x75, 0x6e, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x72, 0x65, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x1b, 0x0a, 0x19, 0x5f, 0x78,
	0x6c, 0x61, 0x5f, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x73, 0x42, 0x28, 0x0a, 0x26, 0x5f, 0x78, 0x6c, 0x61, 0x5f,
	0x72, 0x65, 0x64, 0x75, 0x63, 0x65, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x72, 0x65,
	0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74,
	0x68, 0x42, 0x22, 0x0a, 0x20, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x63, 0x6d, 0x64, 0x5f, 0x62, 0x75,
	0x66, 0x66, 0x65, 0x72, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x42, 0x1d, 0x0a, 0x1b, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x73, 0x79,
	0x6e, 0x74, 0x61, 0x78, 0x5f, 0x73, 0x75, 0x67, 0x61, 0x72, 0x5f, 0x61, 0x73, 0x79, 0x6e, 0x63,
	0x5f, 0x6f, 0x70, 0x73, 0x42, 0x2e, 0x0a, 0x2c, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x62, 0x75, 0x66, 0x66,
	0x65, 0x72, 0x73, 0x5f, 0x64, 0x75, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x69, 0x6e, 0x67, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x69, 0x67, 0x6e,
	0x6f, 0x72, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x42, 0x24,
	0x0a, 0x22, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x70, 0x6a, 0x72, 0x74, 0x5f, 0x61, 0x6c, 0x6c, 0x6f,
	0x77, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x5f, 0x69, 0x6e,
	0x5f, 0x68, 0x6c, 0x6f, 0x42, 0x23, 0x0a, 0x21, 0x5f, 0x78, 0x6c, 0x61, 0x5f, 0x74, 0x65, 0x73,
	0x74, 0x5f, 0x61, 0x64, 0x64, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x5f, 0x62, 0x75,
	0x66, 0x66, 0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x42, 0x2e, 0x0a, 0x2c, 0x5f, 0x78, 0x6c,
	0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x6c, 0x5f, 0x6d, 0x61, 0x74, 0x6d, 0x75, 0x6c, 0x5f, 0x70, 0x65, 0x72, 0x66, 0x5f, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x42, 0x1e, 0x0a, 0x1c, 0x5f, 0x78, 0x6c,
	0x61, 0x5f, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x5f, 0x65, 0x78, 0x69, 0x74, 0x5f, 0x77, 0x69, 0x74,
	0x68, 0x5f, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x73, 0x42, 0x2e, 0x0a, 0x2c, 0x5f, 0x78, 0x6c,
	0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x6c, 0x5f, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x64, 0x5f, 0x64, 0x6f, 0x74, 0x5f, 0x77, 0x69,
	0x74, 0x68, 0x5f, 0x74, 0x72, 0x69, 0x74, 0x6f, 0x6e, 0x42, 0x29, 0x0a, 0x27, 0x5f, 0x78, 0x6c,
	0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x6c, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x72, 0x61, 0x66, 0x74, 0x5f, 0x73, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x5f, 0x6b, 0x4a, 0x06, 0x08, 0xda, 0x02, 0x10, 0xdb, 0x02, 0x4a, 0x06, 0x08, 0xaa,
	0x02, 0x10, 0xab, 0x02, 0x4a, 0x06, 0x08, 0xa0, 0x01, 0x10, 0xa1, 0x01, 0x4a, 0x06, 0x08, 0xe0,
	0x02, 0x10, 0xe1, 0x02, 0x4a, 0x06, 0x08, 0xa7, 0x01, 0x10, 0xa8, 0x01, 0x4a, 0x06, 0x08, 0x8a,
	0x02, 0x10, 0x8b, 0x02, 0x4a, 0x06, 0x08, 0x94, 0x02, 0x10, 0x95, 0x02, 0x4a, 0x06, 0x08, 0xe2,
	0x01, 0x10, 0xe3, 0x01, 0x4a, 0x06, 0x08, 0x81, 0x03, 0x10, 0x82, 0x03, 0x4a, 0x06, 0x08, 0xef,
	0x02, 0x10, 0xf0, 0x02, 0x4a, 0x04, 0x08, 0x3f, 0x10, 0x40, 0x4a, 0x06, 0x08, 0x86, 0x01, 0x10,
	0x87, 0x01, 0x4a, 0x04, 0x08, 0x50, 0x10, 0x51, 0x4a, 0x04, 0x08, 0x5d, 0x10, 0x5e, 0x4a, 0x04,
	0x08, 0x5e, 0x10, 0x5f, 0x4a, 0x06, 0x08, 0xb1, 0x01, 0x10, 0xb2, 0x01, 0x4a, 0x04, 0x08, 0x62,
	0x10, 0x63, 0x4a, 0x06, 0x08, 0xcf, 0x01, 0x10, 0xd0, 0x01, 0x4a, 0x06, 0x08, 0xab, 0x01, 0x10,
	0xac, 0x01, 0x4a, 0x06, 0x08, 0xad, 0x01, 0x10, 0xae, 0x01, 0x4a, 0x06, 0x08, 0xb3, 0x01, 0x10,
	0xb4, 0x01, 0x4a, 0x06, 0x08, 0x82, 0x01, 0x10, 0x83, 0x01, 0x4a, 0x06, 0x08, 0x8d, 0x01, 0x10,
	0x8e, 0x01, 0x4a, 0x06, 0x08, 0x8f, 0x01, 0x10, 0x90, 0x01, 0x4a, 0x06, 0x08, 0x98, 0x01, 0x10,
	0x99, 0x01, 0x4a, 0x06, 0x08, 0x96, 0x02, 0x10, 0x97, 0x02, 0x4a, 0x06, 0x08, 0xb7, 0x01, 0x10,
	0xb8, 0x01, 0x4a, 0x06, 0x08, 0xc7, 0x01, 0x10, 0xc8, 0x01, 0x4a, 0x06, 0x08, 0xc8, 0x01, 0x10,
	0xc9, 0x01, 0x4a, 0x06, 0x08, 0xc9, 0x01, 0x10, 0xca, 0x01, 0x4a, 0x06, 0x08, 0xee, 0x01, 0x10,
	0xef, 0x01, 0x4a, 0x06, 0x08, 0x9e, 0x01, 0x10, 0x9f, 0x01, 0x4a, 0x06, 0x08, 0xab, 0x02, 0x10,
	0xac, 0x02, 0x4a, 0x06, 0x08, 0xa1, 0x01, 0x10, 0xa2, 0x01, 0x4a, 0x06, 0x08, 0xa2, 0x01, 0x10,
	0xa3, 0x01, 0x4a, 0x06, 0x08, 0xa9, 0x01, 0x10, 0xaa, 0x01, 0x4a, 0x06, 0x08, 0xe9, 0x01, 0x10,
	0xea, 0x01, 0x4a, 0x06, 0x08, 0xea, 0x01, 0x10, 0xeb, 0x01, 0x4a, 0x06, 0x08, 0xca, 0x01, 0x10,
	0xcb, 0x01, 0x4a, 0x06, 0x08, 0xe6, 0x01, 0x10, 0xe7, 0x01, 0x4a, 0x06, 0x08, 0xa8, 0x01, 0x10,
	0xa9, 0x01, 0x4a, 0x06, 0x08, 0xac, 0x01, 0x10, 0xad, 0x01, 0x4a, 0x06, 0x08, 0x87, 0x02, 0x10,
	0x88, 0x02, 0x4a, 0x06, 0x08, 0x88, 0x02, 0x10, 0x89, 0x02, 0x4a, 0x06, 0x08, 0x92, 0x03, 0x10,
	0x93, 0x03, 0x4a, 0x06, 0x08, 0xb8, 0x01, 0x10, 0xb9, 0x01, 0x4a, 0x06, 0x08, 0xc0, 0x01, 0x10,
	0xc1, 0x01, 0x4a, 0x06, 0x08, 0xbf, 0x01, 0x10, 0xc0, 0x01, 0x4a, 0x06, 0x08, 0xc3, 0x01, 0x10,
	0xc4, 0x01, 0x4a, 0x06, 0x08, 0xc4, 0x01, 0x10, 0xc5, 0x01, 0x4a, 0x06, 0x08, 0xc5, 0x01, 0x10,
	0xc6, 0x01, 0x4a, 0x06, 0x08, 0xc6, 0x01, 0x10, 0xc7, 0x01, 0x4a, 0x06, 0x08, 0xcc, 0x01, 0x10,
	0xcd, 0x01, 0x4a, 0x06, 0x08, 0xb9, 0x02, 0x10, 0xba, 0x02, 0x4a, 0x06, 0x08, 0xd3, 0x01, 0x10,
	0xd4, 0x01, 0x4a, 0x06, 0x08, 0xdc, 0x01, 0x10, 0xdd, 0x01, 0x4a, 0x06, 0x08, 0x9e, 0x02, 0x10,
	0x9f, 0x02, 0x4a, 0x06, 0x08, 0x93, 0x02, 0x10, 0x94, 0x02, 0x4a, 0x06, 0x08, 0x99, 0x02, 0x10,
	0x9a, 0x02, 0x4a, 0x06, 0x08, 0x9a, 0x02, 0x10, 0x9b, 0x02, 0x4a, 0x06, 0x08, 0xaf, 0x02, 0x10,
	0xb0, 0x02, 0x4a, 0x06, 0x08, 0xae, 0x02, 0x10, 0xaf, 0x02, 0x4a, 0x06, 0x08, 0xbf, 0x02, 0x10,
	0xc0, 0x02, 0x4a, 0x04, 0x08, 0x05, 0x10, 0x06, 0x4a, 0x04, 0x08, 0x75, 0x10, 0x76, 0x4a, 0x06,
	0x08, 0x85, 0x01, 0x10, 0x86, 0x01, 0x4a, 0x06, 0x08, 0x8b, 0x01, 0x10, 0x8c, 0x01, 0x4a, 0x06,
	0x08, 0xb0, 0x01, 0x10, 0xb1, 0x01, 0x4a, 0x06, 0x08, 0xb2, 0x01, 0x10, 0xb3, 0x01, 0x4a, 0x06,
	0x08, 0xb4, 0x01, 0x10, 0xb5, 0x01, 0x4a, 0x06, 0x08, 0xc1, 0x01, 0x10, 0xc2, 0x01, 0x4a, 0x06,
	0x08, 0xd6, 0x01, 0x10, 0xd7, 0x01, 0x4a, 0x06, 0x08, 0xc2, 0x01, 0x10, 0xc3, 0x01, 0x4a, 0x06,
	0x08, 0xdd, 0x01, 0x10, 0xde, 0x01, 0x4a, 0x06, 0x08, 0xf2, 0x01, 0x10, 0xf3, 0x01, 0x4a, 0x06,
	0x08, 0xce, 0x01, 0x10, 0xcf, 0x01, 0x4a, 0x06, 0x08, 0xc0, 0x02, 0x10, 0xc1, 0x02, 0x4a, 0x06,
	0x08, 0xc5, 0x02, 0x10, 0xc6, 0x02, 0x4a, 0x06, 0x08, 0xc6, 0x02, 0x10, 0xc7, 0x02, 0x4a, 0x06,
	0x08, 0xcc, 0x02, 0x10, 0xcd, 0x02, 0x4a, 0x06, 0x08, 0xe9, 0x02, 0x10, 0xea, 0x02, 0x4a, 0x06,
	0x08, 0x8e, 0x02, 0x10, 0x8f, 0x02, 0x4a, 0x06, 0x08, 0xe5, 0x01, 0x10, 0xe6, 0x01, 0x4a, 0x06,
	0x08, 0x8f, 0x02, 0x10, 0x90, 0x02, 0x4a, 0x06, 0x08, 0x97, 0x02, 0x10, 0x98, 0x02, 0x4a, 0x06,
	0x08, 0xda, 0x01, 0x10, 0xdb, 0x01, 0x4a, 0x06, 0x08, 0xf1, 0x02, 0x10, 0xf2, 0x02, 0x4a, 0x06,
	0x08, 0xf3, 0x02, 0x10, 0xf4, 0x02, 0x4a, 0x06, 0x08, 0xf9, 0x01, 0x10, 0xfa, 0x01, 0x4a, 0x06,
	0x08, 0xb5, 0x02, 0x10, 0xb6, 0x02, 0x52, 0x3b, 0x78, 0x6c, 0x61, 0x5f, 0x67, 0x70, 0x75, 0x5f,
	0x75, 0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x74, 0x72, 0x69, 0x74, 0x6f,
	0x6e, 0x5f, 0x65, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x72, 0x5f, 0x66, 0x6f, 0x72, 0x5f, 0x67, 0x65,
	0x6d, 0x6d, 0x73, 0x22, 0x3a, 0x0a, 0x19, 0x47, 0x70, 0x75, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x75, 0x6d, 0x6d, 0x79, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x64, 0x75, 0x6d, 0x6d, 0x79, 0x46, 0x6c, 0x61, 0x67, 0x22,
	0xb7, 0x01, 0x0a, 0x1d, 0x53, 0x68, 0x61, 0x72, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x61, 0x69, 0x72, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x34, 0x0a, 0x16, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x14, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x15, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x68, 0x61, 0x70, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x03, 0x52, 0x13, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x53, 0x68, 0x61, 0x70, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x2c, 0x0a, 0x12, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x68, 0x61, 0x70, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x18, 0x03, 0x20, 0x03, 0x28, 0x03, 0x52, 0x10, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53,
	0x68, 0x61, 0x70, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x22, 0xc6, 0x0d, 0x0a, 0x10, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x48,
	0x0a, 0x18, 0x73, 0x68, 0x61, 0x70, 0x65, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x5f, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x0f, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x53, 0x68, 0x61, 0x70, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x52, 0x15, 0x73, 0x68, 0x61, 0x70, 0x65, 0x57, 0x69, 0x74, 0x68, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x65, 0x65, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x73, 0x65, 0x65, 0x64, 0x12, 0x36, 0x0a, 0x0d,
	0x64, 0x65, 0x62, 0x75, 0x67, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x44, 0x65, 0x62, 0x75, 0x67, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0c, 0x64, 0x65, 0x62, 0x75, 0x67, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x38, 0x0a, 0x0e, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x68,
	0x61, 0x6e, 0x64, 0x6c, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x78,
	0x6c, 0x61, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x52,
	0x0d, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x73, 0x12, 0x21,
	0x0a, 0x0c, 0x6e, 0x75, 0x6d, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x6e, 0x75, 0x6d, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x73, 0x12, 0x47, 0x0a, 0x11, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x78,
	0x6c, 0x61, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x10, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x38, 0x0a, 0x18, 0x61, 0x6c,
	0x69, 0x61, 0x73, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x5f,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x61, 0x6c,
	0x69, 0x61, 0x73, 0x50, 0x61, 0x73, 0x73, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x6e, 0x75, 0x6d, 0x5f, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x6e, 0x75,
	0x6d, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x6c,
	0x61, 0x75, 0x6e, 0x63, 0x68, 0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x49, 0x64, 0x12, 0x32, 0x0a, 0x15, 0x75, 0x73, 0x65, 0x5f,
	0x73, 0x70, 0x6d, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e,
	0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x75, 0x73, 0x65, 0x53, 0x70, 0x6d, 0x64,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x3b, 0x0a, 0x1a,
	0x75, 0x73, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x73, 0x70, 0x6d, 0x64, 0x5f, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x17, 0x75, 0x73, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x53, 0x70, 0x6d, 0x64, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x48, 0x0a, 0x21, 0x61, 0x75, 0x74,
	0x6f, 0x5f, 0x73, 0x70, 0x6d, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x73, 0x68, 0x5f, 0x73, 0x68, 0x61, 0x70, 0x65, 0x18, 0x10,
	0x20, 0x03, 0x28, 0x03, 0x52, 0x1d, 0x61, 0x75, 0x74, 0x6f, 0x53, 0x70, 0x6d, 0x64, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x73, 0x68, 0x53, 0x68,
	0x61, 0x70, 0x65, 0x12, 0x44, 0x0a, 0x1f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x73, 0x70, 0x6d, 0x64,
	0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65,
	0x73, 0x68, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x03, 0x52, 0x1b, 0x61, 0x75,
	0x74, 0x6f, 0x53, 0x70, 0x6d, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x69,
	0x6e, 0x67, 0x4d, 0x65, 0x73, 0x68, 0x49, 0x64, 0x73, 0x12, 0x45, 0x0a, 0x1d, 0x65, 0x78, 0x65,
	0x63, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x66, 0x66, 0x6f, 0x72, 0x74, 0x18, 0x19, 0x20, 0x01, 0x28, 0x02,
	0x42, 0x02, 0x18, 0x01, 0x52, 0x1a, 0x65, 0x78, 0x65, 0x63, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x70,
	0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x66, 0x66, 0x6f, 0x72, 0x74,
	0x12, 0x36, 0x0a, 0x15, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x66, 0x69, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x5f, 0x65, 0x66, 0x66, 0x6f, 0x72, 0x74, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x02, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x13, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x46, 0x69, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x45, 0x66, 0x66, 0x6f, 0x72, 0x74, 0x12, 0x50, 0x0a, 0x12, 0x6f, 0x70, 0x74, 0x69,
	0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x1b,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x45, 0x66, 0x66, 0x6f,
	0x72, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x11, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x53, 0x0a, 0x14, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x66, 0x69, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x65, 0x76,
	0x65, 0x6c, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x45, 0x66, 0x66, 0x6f, 0x72, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x12, 0x6d, 0x65, 0x6d,
	0x6f, 0x72, 0x79, 0x46, 0x69, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12,
	0x27, 0x0a, 0x0f, 0x64, 0x65, 0x64, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x68,
	0x6c, 0x6f, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x64, 0x65, 0x64, 0x75, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x48, 0x6c, 0x6f, 0x12, 0x5f, 0x0a, 0x2d, 0x61, 0x6c, 0x6c, 0x6f,
	0x77, 0x5f, 0x73, 0x70, 0x6d, 0x64, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f,
	0x70, 0x72, 0x6f, 0x70, 0x61, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x5f, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x17, 0x20, 0x03, 0x28, 0x08, 0x52,
	0x28, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x53, 0x70, 0x6d, 0x64, 0x53, 0x68, 0x61, 0x72, 0x64, 0x69,
	0x6e, 0x67, 0x50, 0x72, 0x6f, 0x70, 0x61, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x57, 0x0a, 0x29, 0x61, 0x6c, 0x6c,
	0x6f, 0x77, 0x5f, 0x73, 0x70, 0x6d, 0x64, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67,
	0x5f, 0x70, 0x72, 0x6f, 0x70, 0x61, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x5f,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x08, 0x52, 0x24, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x53, 0x70, 0x6d, 0x64, 0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x50,
	0x72, 0x6f, 0x70, 0x61, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x12, 0x56, 0x0a, 0x28, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x5f, 0x72, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x73, 0x5f, 0x62, 0x72, 0x6f, 0x61, 0x64, 0x63, 0x61, 0x73, 0x74, 0x5f, 0x76,
	0x69, 0x61, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x73, 0x18, 0x12,
	0x20, 0x03, 0x28, 0x08, 0x52, 0x24, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x73, 0x42, 0x72, 0x6f, 0x61, 0x64, 0x63, 0x61, 0x73, 0x74, 0x56, 0x69, 0x61, 0x43,
	0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x73, 0x12, 0x47, 0x0a, 0x20, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x5f, 0x73, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x68, 0x61,
	0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x13,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x1d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x53, 0x65, 0x70, 0x61, 0x72,
	0x61, 0x74, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x67, 0x72,
	0x61, 0x6d, 0x73, 0x12, 0x63, 0x0a, 0x1c, 0x73, 0x68, 0x61, 0x72, 0x64, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x70, 0x61,
	0x69, 0x72, 0x73, 0x18, 0x14, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x78, 0x6c, 0x61, 0x2e,
	0x53, 0x68, 0x61, 0x72, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x50, 0x61, 0x69, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x19, 0x73,
	0x68, 0x61, 0x72, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x50, 0x61, 0x69, 0x72, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x64, 0x6f, 0x5f,
	0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x66,
	0x64, 0x6f, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x16, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x65, 0x6d,
	0x6f, 0x72, 0x79, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x75, 0x73, 0x65, 0x5f, 0x73,
	0x68, 0x61, 0x72, 0x64, 0x79, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x65,
	0x72, 0x18, 0x18, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x75, 0x73, 0x65, 0x53, 0x68, 0x61, 0x72,
	0x64, 0x79, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x72, 0x22, 0x5d, 0x0a,
	0x0b, 0x45, 0x66, 0x66, 0x6f, 0x72, 0x74, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x12, 0x0a, 0x0e,
	0x45, 0x46, 0x46, 0x4f, 0x52, 0x54, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00,
	0x12, 0x0d, 0x0a, 0x09, 0x45, 0x46, 0x46, 0x4f, 0x52, 0x54, 0x5f, 0x4f, 0x30, 0x10, 0x09, 0x12,
	0x0d, 0x0a, 0x09, 0x45, 0x46, 0x46, 0x4f, 0x52, 0x54, 0x5f, 0x4f, 0x31, 0x10, 0x13, 0x12, 0x0d,
	0x0a, 0x09, 0x45, 0x46, 0x46, 0x4f, 0x52, 0x54, 0x5f, 0x4f, 0x32, 0x10, 0x1d, 0x12, 0x0d, 0x0a,
	0x09, 0x45, 0x46, 0x46, 0x4f, 0x52, 0x54, 0x5f, 0x4f, 0x33, 0x10, 0x27, 0x4a, 0x04, 0x08, 0x0d,
	0x10, 0x0e, 0x22, 0xb0, 0x18, 0x0a, 0x14, 0x48, 0x6c, 0x6f, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x50, 0x0a, 0x18, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e,
	0x78, 0x6c, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x53, 0x68, 0x61, 0x70, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x16, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x73, 0x65, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x04, 0x73, 0x65, 0x65,
	0x64, 0x12, 0x1b, 0x0a, 0x09, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x49, 0x64, 0x12, 0x23,
	0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x6e, 0x75, 0x6d, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x6e, 0x75, 0x6d,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x56, 0x0a, 0x28, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x73, 0x5f, 0x62, 0x72, 0x6f,
	0x61, 0x64, 0x63, 0x61, 0x73, 0x74, 0x5f, 0x76, 0x69, 0x61, 0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x08, 0x52, 0x24, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x73, 0x42, 0x72, 0x6f, 0x61, 0x64,
	0x63, 0x61, 0x73, 0x74, 0x56, 0x69, 0x61, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x75, 0x73, 0x65, 0x5f, 0x73, 0x70, 0x6d, 0x64, 0x5f, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x13, 0x75, 0x73, 0x65, 0x53, 0x70, 0x6d, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x3b, 0x0a, 0x1a, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x75,
	0x74, 0x6f, 0x5f, 0x73, 0x70, 0x6d, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x69, 0x6e, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x17, 0x75, 0x73, 0x65, 0x41,
	0x75, 0x74, 0x6f, 0x53, 0x70, 0x6d, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x69, 0x6e, 0x67, 0x12, 0x48, 0x0a, 0x21, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x73, 0x70, 0x6d, 0x64,
	0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65,
	0x73, 0x68, 0x5f, 0x73, 0x68, 0x61, 0x70, 0x65, 0x18, 0x09, 0x20, 0x03, 0x28, 0x03, 0x52, 0x1d,
	0x61, 0x75, 0x74, 0x6f, 0x53, 0x70, 0x6d, 0x64, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x73, 0x68, 0x53, 0x68, 0x61, 0x70, 0x65, 0x12, 0x44, 0x0a,
	0x1f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x73, 0x70, 0x6d, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x73, 0x68, 0x5f, 0x69, 0x64, 0x73,
	0x18, 0x0a, 0x20, 0x03, 0x28, 0x03, 0x52, 0x1b, 0x61, 0x75, 0x74, 0x6f, 0x53, 0x70, 0x6d, 0x64,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x73, 0x68,
	0x49, 0x64, 0x73, 0x12, 0x45, 0x0a, 0x1d, 0x65, 0x78, 0x65, 0x63, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x66,
	0x66, 0x6f, 0x72, 0x74, 0x18, 0x24, 0x20, 0x01, 0x28, 0x02, 0x42, 0x02, 0x18, 0x01, 0x52, 0x1a,
	0x65, 0x78, 0x65, 0x63, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x66, 0x66, 0x6f, 0x72, 0x74, 0x12, 0x36, 0x0a, 0x15, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x66, 0x69, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x66, 0x66,
	0x6f, 0x72, 0x74, 0x18, 0x25, 0x20, 0x01, 0x28, 0x02, 0x42, 0x02, 0x18, 0x01, 0x52, 0x13, 0x6d,
	0x65, 0x6d, 0x6f, 0x72, 0x79, 0x46, 0x69, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x45, 0x66, 0x66, 0x6f,
	0x72, 0x74, 0x12, 0x50, 0x0a, 0x12, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x27, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21,
	0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x45, 0x66, 0x66, 0x6f, 0x72, 0x74, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x52, 0x11, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c,
	0x65, 0x76, 0x65, 0x6c, 0x12, 0x53, 0x0a, 0x14, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x66,
	0x69, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x28, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x21, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x45, 0x66, 0x66, 0x6f, 0x72, 0x74,
	0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x12, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x46, 0x69, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x27, 0x0a, 0x0f, 0x64, 0x65, 0x64,
	0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x68, 0x6c, 0x6f, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0e, 0x64, 0x65, 0x64, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x48,
	0x6c, 0x6f, 0x12, 0x3f, 0x0a, 0x1c, 0x69, 0x6e, 0x74, 0x72, 0x61, 0x5f, 0x6f, 0x70, 0x5f, 0x70,
	0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x69, 0x73, 0x6d, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x61,
	0x64, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x03, 0x52, 0x19, 0x69, 0x6e, 0x74, 0x72, 0x61, 0x4f,
	0x70, 0x50, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x69, 0x73, 0x6d, 0x54, 0x68, 0x72, 0x65,
	0x61, 0x64, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x36, 0x0a, 0x0d, 0x64, 0x65, 0x62, 0x75, 0x67, 0x5f, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x78, 0x6c,
	0x61, 0x2e, 0x44, 0x65, 0x62, 0x75, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0c,
	0x64, 0x65, 0x62, 0x75, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x54, 0x0a, 0x18,
	0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x73,
	0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x16, 0x73, 0x74, 0x61, 0x74,
	0x69, 0x63, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x63, 0x0a, 0x20, 0x70, 0x72, 0x65, 0x5f, 0x73, 0x69, 0x6d, 0x75, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x23, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x78,
	0x6c, 0x61, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x1d, 0x70, 0x72, 0x65, 0x53, 0x69, 0x6d,
	0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x73, 0x73,
	0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x47, 0x0a, 0x20, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x5f, 0x73, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x69,
	0x6e, 0x67, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x1e, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x1d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x53, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x65,
	0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x73,
	0x12, 0x63, 0x0a, 0x1c, 0x73, 0x68, 0x61, 0x72, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x70, 0x61, 0x69, 0x72, 0x73,
	0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x53, 0x68, 0x61,
	0x72, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x50, 0x61, 0x69, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x19, 0x73, 0x68, 0x61, 0x72,
	0x64, 0x61, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x50, 0x61, 0x69, 0x72, 0x73, 0x12, 0x38, 0x0a, 0x18, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x5f, 0x70,
	0x61, 0x73, 0x73, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x50, 0x61,
	0x73, 0x73, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12,
	0x49, 0x0a, 0x21, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x77, 0x61, 0x72, 0x65,
	0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f, 0x72,
	0x74, 0x69, 0x6e, 0x67, 0x18, 0x12, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1e, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x41, 0x77, 0x61, 0x72, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x6a, 0x0a, 0x18, 0x66, 0x75,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x63, 0x6f, 0x6c, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x78,
	0x6c, 0x61, 0x2e, 0x48, 0x6c, 0x6f, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x46, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x16,
	0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x43, 0x6f, 0x6c, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x47, 0x0a, 0x0d, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x14, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x78, 0x6c, 0x61, 0x2e, 0x48, 0x6c, 0x6f, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x4c, 0x69, 0x73,
	0x74, 0x52, 0x0c, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x47, 0x0a, 0x0a, 0x64, 0x6f, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x15, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x48, 0x6c, 0x6f, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x44,
	0x6f, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x09, 0x64,
	0x6f, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4c, 0x0a, 0x0d, 0x6c, 0x61, 0x79, 0x6f,
	0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x16, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x48, 0x6c, 0x6f, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34,
	0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x0c, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x43, 0x0a, 0x1e, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79,
	0x5f, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x17, 0x20, 0x03, 0x28, 0x04, 0x52, 0x1b,
	0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x53, 0x70, 0x61, 0x63, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x56, 0x0a, 0x15, 0x70,
	0x68, 0x61, 0x73, 0x65, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x18, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x78, 0x6c, 0x61,
	0x2e, 0x48, 0x6c, 0x6f, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x13,
	0x70, 0x68, 0x61, 0x73, 0x65, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x68, 0x61, 0x73, 0x65, 0x5f, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x18, 0x19, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x70, 0x68, 0x61, 0x73, 0x65, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x12, 0x5f, 0x0a, 0x2d, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x73, 0x70,
	0x6d, 0x64, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x72, 0x6f, 0x70,
	0x61, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x21, 0x20, 0x03, 0x28, 0x08, 0x52, 0x28, 0x61, 0x6c, 0x6c,
	0x6f, 0x77, 0x53, 0x70, 0x6d, 0x64, 0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x72,
	0x6f, 0x70, 0x61, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x57, 0x0a, 0x29, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x73,
	0x70, 0x6d, 0x64, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x72, 0x6f,
	0x70, 0x61, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x5f, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x18, 0x1b, 0x20, 0x03, 0x28, 0x08, 0x52, 0x24, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x53,
	0x70, 0x6d, 0x64, 0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x70, 0x61,
	0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x69,
	0x0a, 0x16, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x18, 0x1c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x48, 0x6c, 0x6f, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x61, 0x70, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x14, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x41, 0x6c, 0x6c,
	0x6f, 0x77, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x61, 0x70, 0x12, 0x61, 0x0a, 0x1d, 0x6d, 0x61, 0x74,
	0x72, 0x69, 0x78, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x6e, 0x64,
	0x5f, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x1e, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x50, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x1a, 0x6d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x55, 0x6e, 0x69, 0x74, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x6e, 0x64, 0x50, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b,
	0x66, 0x64, 0x6f, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x1f, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x0a, 0x66, 0x64, 0x6f, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x2c, 0x0a,
	0x12, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x20, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x75,
	0x73, 0x65, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x79, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x65, 0x72, 0x18, 0x22, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x75, 0x73, 0x65,
	0x53, 0x68, 0x61, 0x72, 0x64, 0x79, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x65,
	0x72, 0x12, 0x41, 0x0a, 0x0f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x26, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x78, 0x6c, 0x61,
	0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0e, 0x73, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x41, 0x0a, 0x0f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x29, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e,
	0x78, 0x6c, 0x61, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0e, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x1e, 0x0a, 0x08, 0x42, 0x6f, 0x6f, 0x6c, 0x4c,
	0x69, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x76, 0x61, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x08, 0x52, 0x04, 0x76, 0x61, 0x6c, 0x73, 0x1a, 0x1f, 0x0a, 0x09, 0x49, 0x6e, 0x74, 0x36, 0x34,
	0x4c, 0x69, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x76, 0x61, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x03, 0x52, 0x04, 0x76, 0x61, 0x6c, 0x73, 0x1a, 0x4a, 0x0a, 0x0d, 0x49, 0x6e, 0x74, 0x36,
	0x34, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x05, 0x6c, 0x69, 0x73,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x48,
	0x6c, 0x6f, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x05, 0x6c,
	0x69, 0x73, 0x74, 0x73, 0x1a, 0x61, 0x0a, 0x0e, 0x44, 0x6f, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x39, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x48, 0x6c,
	0x6f, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x47, 0x0a, 0x19, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x61, 0x70, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0x3d, 0x0a, 0x16, 0x46, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x07, 0x0a, 0x03, 0x4f, 0x46,
	0x46, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x45, 0x52, 0x5f, 0x45, 0x44, 0x47, 0x45, 0x10,
	0x01, 0x12, 0x0c, 0x0a, 0x08, 0x50, 0x45, 0x52, 0x5f, 0x4e, 0x4f, 0x44, 0x45, 0x10, 0x02, 0x4a,
	0x04, 0x08, 0x1a, 0x10, 0x1b, 0x22, 0x81, 0x01, 0x0a, 0x18, 0x48, 0x6c, 0x6f, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x57, 0x69, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x32, 0x0a, 0x0a, 0x68, 0x6c, 0x6f, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x48, 0x6c, 0x6f,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x09, 0x68, 0x6c, 0x6f,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x31, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x48, 0x6c, 0x6f,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xe9, 0x0a, 0x0a, 0x0d, 0x53, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x32, 0x0a, 0x0a, 0x68,
	0x6c, 0x6f, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x13, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x48, 0x6c, 0x6f, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x52, 0x09, 0x68, 0x6c, 0x6f, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x12,
	0x60, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x14, 0x63, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65,
	0x73, 0x1a, 0xdf, 0x01, 0x0a, 0x0b, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x34, 0x0a, 0x16, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x5f, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x01, 0x52, 0x14, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x65, 0x6e, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x12, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x6d, 0x65, 0x6d,
	0x6f, 0x72, 0x79, 0x5f, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x61, 0x66, 0x74, 0x65, 0x72, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x55, 0x73, 0x61,
	0x67, 0x65, 0x41, 0x66, 0x74, 0x65, 0x72, 0x12, 0x2a, 0x0a, 0x11, 0x70, 0x65, 0x61, 0x6b, 0x5f,
	0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x61, 0x66, 0x74, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0f, 0x70, 0x65, 0x61, 0x6b, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x41, 0x66,
	0x74, 0x65, 0x72, 0x1a, 0xc1, 0x05, 0x0a, 0x18, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65,
	0x72, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x37, 0x0a, 0x18, 0x61, 0x6c, 0x6c, 0x5f, 0x67, 0x61, 0x74, 0x68, 0x65, 0x72, 0x5f, 0x77,
	0x61, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x15, 0x61, 0x6c, 0x6c, 0x47, 0x61, 0x74, 0x68, 0x65, 0x72, 0x57, 0x61, 0x73,
	0x74, 0x65, 0x64, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x12, 0x37, 0x0a, 0x18, 0x61, 0x6c, 0x6c,
	0x5f, 0x72, 0x65, 0x64, 0x75, 0x63, 0x65, 0x5f, 0x77, 0x61, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63,
	0x79, 0x63, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x15, 0x61, 0x6c, 0x6c,
	0x52, 0x65, 0x64, 0x75, 0x63, 0x65, 0x57, 0x61, 0x73, 0x74, 0x65, 0x64, 0x43, 0x79, 0x63, 0x6c,
	0x65, 0x73, 0x12, 0x4b, 0x0a, 0x22, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x62, 0x72, 0x6f, 0x61, 0x64, 0x63, 0x61, 0x73, 0x74, 0x5f, 0x77, 0x61, 0x73, 0x74, 0x65,
	0x64, 0x5f, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x1f,
	0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x42, 0x72, 0x6f, 0x61, 0x64, 0x63,
	0x61, 0x73, 0x74, 0x57, 0x61, 0x73, 0x74, 0x65, 0x64, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x12,
	0x47, 0x0a, 0x20, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x65,
	0x72, 0x6d, 0x75, 0x74, 0x65, 0x5f, 0x77, 0x61, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x79, 0x63,
	0x6c, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01, 0x52, 0x1d, 0x63, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x75, 0x74, 0x65, 0x57, 0x61, 0x73, 0x74,
	0x65, 0x64, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x12, 0x36, 0x0a, 0x18, 0x61, 0x6c, 0x6c, 0x5f,
	0x74, 0x6f, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x77, 0x61, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x79,
	0x63, 0x6c, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x52, 0x14, 0x61, 0x6c, 0x6c, 0x54,
	0x6f, 0x41, 0x6c, 0x6c, 0x57, 0x61, 0x73, 0x74, 0x65, 0x64, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x73,
	0x12, 0x43, 0x0a, 0x1f, 0x72, 0x61, 0x67, 0x67, 0x65, 0x64, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x74,
	0x6f, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x77, 0x61, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x79, 0x63,
	0x6c, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x01, 0x52, 0x1a, 0x72, 0x61, 0x67, 0x67, 0x65,
	0x64, 0x41, 0x6c, 0x6c, 0x54, 0x6f, 0x41, 0x6c, 0x6c, 0x57, 0x61, 0x73, 0x74, 0x65, 0x64, 0x43,
	0x79, 0x63, 0x6c, 0x65, 0x73, 0x12, 0x3f, 0x0a, 0x1c, 0x72, 0x65, 0x64, 0x75, 0x63, 0x65, 0x5f,
	0x73, 0x63, 0x61, 0x74, 0x74, 0x65, 0x72, 0x5f, 0x77, 0x61, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63,
	0x79, 0x63, 0x6c, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x01, 0x52, 0x19, 0x72, 0x65, 0x64,
	0x75, 0x63, 0x65, 0x53, 0x63, 0x61, 0x74, 0x74, 0x65, 0x72, 0x57, 0x61, 0x73, 0x74, 0x65, 0x64,
	0x43, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x65, 0x6e, 0x64, 0x5f, 0x77,
	0x61, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x10, 0x73, 0x65, 0x6e, 0x64, 0x57, 0x61, 0x73, 0x74, 0x65, 0x64, 0x43, 0x79,
	0x63, 0x6c, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x65, 0x63, 0x76, 0x5f, 0x77, 0x61, 0x73,
	0x74, 0x65, 0x64, 0x5f, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x01,
	0x52, 0x10, 0x72, 0x65, 0x63, 0x76, 0x57, 0x61, 0x73, 0x74, 0x65, 0x64, 0x43, 0x79, 0x63, 0x6c,
	0x65, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x77, 0x61, 0x73, 0x74,
	0x65, 0x64, 0x5f, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x11, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x57, 0x61, 0x73, 0x74, 0x65, 0x64, 0x43, 0x79, 0x63, 0x6c,
	0x65, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x79, 0x63, 0x6c,
	0x65, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x43,
	0x79, 0x63, 0x6c, 0x65, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f,
	0x70, 0x72, 0x65, 0x73, 0x73, 0x75, 0x72, 0x65, 0x5f, 0x70, 0x65, 0x61, 0x6b, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x12, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x50, 0x72, 0x65, 0x73, 0x73,
	0x75, 0x72, 0x65, 0x50, 0x65, 0x61, 0x6b, 0x1a, 0x9b, 0x02, 0x0a, 0x18, 0x43, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x63, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x42, 0x0a, 0x0c, 0x69,
	0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x1e, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12,
	0x5e, 0x0a, 0x14, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x78, 0x6c, 0x61, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x69,
	0x73, 0x74, 0x69, 0x63, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x13, 0x73, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x12,
	0x34, 0x0a, 0x16, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6d, 0x69,
	0x63, 0x72, 0x6f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x14, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x50, 0x65, 0x72, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73,
	0x65, 0x63, 0x6f, 0x6e, 0x64, 0x22, 0x7a, 0x0a, 0x17, 0x4e, 0x6f, 0x64, 0x65, 0x53, 0x68, 0x61,
	0x72, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x2b, 0x0a, 0x08, 0x73, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x4f, 0x70, 0x53, 0x68, 0x61, 0x72, 0x64,
	0x69, 0x6e, 0x67, 0x52, 0x08, 0x73, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x32, 0x0a,
	0x05, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x78,
	0x6c, 0x61, 0x2e, 0x4e, 0x6f, 0x64, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x05, 0x6e, 0x6f, 0x64, 0x65,
	0x73, 0x22, 0x49, 0x0a, 0x13, 0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x32, 0x0a, 0x05, 0x6e, 0x6f, 0x64, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x4e, 0x6f,
	0x64, 0x65, 0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x05, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x22, 0x7a, 0x0a, 0x13,
	0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x40, 0x0a, 0x08, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x53, 0x63, 0x68, 0x65,
	0x64, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x73, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x65, 0x1a, 0x21, 0x0a, 0x0b, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var (
	file_xla_xla_proto_rawDescOnce sync.Once
	file_xla_xla_proto_rawDescData []byte
)

func file_xla_xla_proto_rawDescGZIP() []byte {
	file_xla_xla_proto_rawDescOnce.Do(func() {
		file_xla_xla_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_xla_xla_proto_rawDesc), len(file_xla_xla_proto_rawDesc)))
	})
	return file_xla_xla_proto_rawDescData
}

var file_xla_xla_proto_enumTypes = make([]protoimpl.EnumInfo, 17)
var file_xla_xla_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_xla_xla_proto_goTypes = []any{
	(DebugOptions_CollectiveOpType)(0),               // 0: xla.DebugOptions.CollectiveOpType
	(DebugOptions_CommandBufferCmdType)(0),           // 1: xla.DebugOptions.CommandBufferCmdType
	(DebugOptions_LibNvJitLinkMode)(0),               // 2: xla.DebugOptions.LibNvJitLinkMode
	(DebugOptions_PGLEStrictnessLevel)(0),            // 3: xla.DebugOptions.PGLEStrictnessLevel
	(DebugOptions_ShapeChecks)(0),                    // 4: xla.DebugOptions.ShapeChecks
	(DebugOptions_WhileLoopUnrolling)(0),             // 5: xla.DebugOptions.WhileLoopUnrolling
	(DebugOptions_LibraryFusionType)(0),              // 6: xla.DebugOptions.LibraryFusionType
	(DebugOptions_XnnGraphFusionMode)(0),             // 7: xla.DebugOptions.XnnGraphFusionMode
	(DebugOptions_CommandBufferSchedulingMode)(0),    // 8: xla.DebugOptions.CommandBufferSchedulingMode
	(DebugOptions_GenericTritonEmitterFeature)(0),    // 9: xla.DebugOptions.GenericTritonEmitterFeature
	(DebugOptions_PipelineParallelismOptLevel)(0),    // 10: xla.DebugOptions.PipelineParallelismOptLevel
	(DebugOptions_StepMarkerLocation)(0),             // 11: xla.DebugOptions.StepMarkerLocation
	(DebugOptions_PartitioningAlgorithm)(0),          // 12: xla.DebugOptions.PartitioningAlgorithm
	(DebugOptions_UnstableReductionDetectionMode)(0), // 13: xla.DebugOptions.UnstableReductionDetectionMode
	(DebugOptions_AutotuneCacheMode)(0),              // 14: xla.DebugOptions.AutotuneCacheMode
	(ExecutionOptions_EffortLevel)(0),                // 15: xla.ExecutionOptions.EffortLevel
	(HloModuleConfigProto_FusionConfigCollection)(0), // 16: xla.HloModuleConfigProto.FusionConfigCollection
	(*CompilationEnvironmentsProto)(nil),             // 17: xla.CompilationEnvironmentsProto
	(*DebugOptions)(nil),                             // 18: xla.DebugOptions
	(*GpuCompilationEnvironment)(nil),                // 19: xla.GpuCompilationEnvironment
	(*ShardableValueUpdatePairProto)(nil),            // 20: xla.ShardableValueUpdatePairProto
	(*ExecutionOptions)(nil),                         // 21: xla.ExecutionOptions
	(*HloModuleConfigProto)(nil),                     // 22: xla.HloModuleConfigProto
	(*HloModuleProtoWithConfig)(nil),                 // 23: xla.HloModuleProtoWithConfig
	(*ScheduleProto)(nil),                            // 24: xla.ScheduleProto
	(*NodeShardingConfigProto)(nil),                  // 25: xla.NodeShardingConfigProto
	(*ShardingConfigProto)(nil),                      // 26: xla.ShardingConfigProto
	(*ScheduleConfigProto)(nil),                      // 27: xla.ScheduleConfigProto
	nil,                                              // 28: xla.DebugOptions.XlaGpuAnalyticalLatencyEstimatorOptionsEntry
	nil,                                              // 29: xla.DebugOptions.XlaBackendExtraOptionsEntry
	(*HloModuleConfigProto_BoolList)(nil),            // 30: xla.HloModuleConfigProto.BoolList
	(*HloModuleConfigProto_Int64List)(nil),           // 31: xla.HloModuleConfigProto.Int64List
	(*HloModuleConfigProto_Int64ListList)(nil),       // 32: xla.HloModuleConfigProto.Int64ListList
	nil,                               // 33: xla.HloModuleConfigProto.DotConfigEntry
	nil,                               // 34: xla.HloModuleConfigProto.AnalysisAllowanceMapEntry
	(*ScheduleProto_Instruction)(nil), // 35: xla.ScheduleProto.Instruction
	(*ScheduleProto_SchedulerStatisticsProto)(nil), // 36: xla.ScheduleProto.SchedulerStatisticsProto
	(*ScheduleProto_ComputationScheduleProto)(nil), // 37: xla.ScheduleProto.ComputationScheduleProto
	(*ScheduleConfigProto_Instruction)(nil),        // 38: xla.ScheduleConfigProto.Instruction
	(*anypb.Any)(nil),                              // 39: google.protobuf.Any
	(*xla_data.ShapeProto)(nil),                    // 40: xla.ShapeProto
	(*xla_data.DeviceHandle)(nil),                  // 41: xla.DeviceHandle
	(*xla_data.DeviceAssignmentProto)(nil),         // 42: xla.DeviceAssignmentProto
	(*xla_data.ProgramShapeProto)(nil),             // 43: xla.ProgramShapeProto
	(xla_data.PrecisionConfig_Precision)(0),        // 44: xla.PrecisionConfig.Precision
	(*hlo.HloModuleProto)(nil),                     // 45: xla.HloModuleProto
	(*xla_data.OpSharding)(nil),                    // 46: xla.OpSharding
}
var file_xla_xla_proto_depIdxs = []int32{
	39, // 0: xla.CompilationEnvironmentsProto.environments:type_name -> google.protobuf.Any
	6,  // 1: xla.DebugOptions.xla_cpu_experimental_onednn_fusion_type:type_name -> xla.DebugOptions.LibraryFusionType
	6,  // 2: xla.DebugOptions.xla_cpu_experimental_xnn_fusion_type:type_name -> xla.DebugOptions.LibraryFusionType
	7,  // 3: xla.DebugOptions.xla_cpu_experimental_xnn_graph_fusion_mode:type_name -> xla.DebugOptions.XnnGraphFusionMode
	28, // 4: xla.DebugOptions.xla_gpu_analytical_latency_estimator_options:type_name -> xla.DebugOptions.XlaGpuAnalyticalLatencyEstimatorOptionsEntry
	8,  // 5: xla.DebugOptions.xla_gpu_command_buffer_scheduling_mode:type_name -> xla.DebugOptions.CommandBufferSchedulingMode
	0,  // 6: xla.DebugOptions.xla_gpu_disable_async_collectives:type_name -> xla.DebugOptions.CollectiveOpType
	1,  // 7: xla.DebugOptions.xla_gpu_enable_command_buffer:type_name -> xla.DebugOptions.CommandBufferCmdType
	5,  // 8: xla.DebugOptions.xla_gpu_enable_while_loop_unrolling:type_name -> xla.DebugOptions.WhileLoopUnrolling
	14, // 9: xla.DebugOptions.xla_gpu_experimental_autotune_cache_mode:type_name -> xla.DebugOptions.AutotuneCacheMode
	10, // 10: xla.DebugOptions.xla_gpu_experimental_pipeline_parallelism_opt_level:type_name -> xla.DebugOptions.PipelineParallelismOptLevel
	2,  // 11: xla.DebugOptions.xla_gpu_libnvjitlink_mode:type_name -> xla.DebugOptions.LibNvJitLinkMode
	3,  // 12: xla.DebugOptions.xla_gpu_pgle_accuracy_checker:type_name -> xla.DebugOptions.PGLEStrictnessLevel
	4,  // 13: xla.DebugOptions.xla_gpu_shape_checks:type_name -> xla.DebugOptions.ShapeChecks
	9,  // 14: xla.DebugOptions.xla_gpu_unsupported_generic_triton_emitter_features:type_name -> xla.DebugOptions.GenericTritonEmitterFeature
	11, // 15: xla.DebugOptions.xla_step_marker_location:type_name -> xla.DebugOptions.StepMarkerLocation
	12, // 16: xla.DebugOptions.xla_partitioning_algorithm:type_name -> xla.DebugOptions.PartitioningAlgorithm
	13, // 17: xla.DebugOptions.xla_detect_unstable_reductions:type_name -> xla.DebugOptions.UnstableReductionDetectionMode
	29, // 18: xla.DebugOptions.xla_backend_extra_options:type_name -> xla.DebugOptions.XlaBackendExtraOptionsEntry
	40, // 19: xla.ExecutionOptions.shape_with_output_layout:type_name -> xla.ShapeProto
	18, // 20: xla.ExecutionOptions.debug_options:type_name -> xla.DebugOptions
	41, // 21: xla.ExecutionOptions.device_handles:type_name -> xla.DeviceHandle
	42, // 22: xla.ExecutionOptions.device_assignment:type_name -> xla.DeviceAssignmentProto
	15, // 23: xla.ExecutionOptions.optimization_level:type_name -> xla.ExecutionOptions.EffortLevel
	15, // 24: xla.ExecutionOptions.memory_fitting_level:type_name -> xla.ExecutionOptions.EffortLevel
	20, // 25: xla.ExecutionOptions.shardable_value_update_pairs:type_name -> xla.ShardableValueUpdatePairProto
	43, // 26: xla.HloModuleConfigProto.entry_computation_layout:type_name -> xla.ProgramShapeProto
	15, // 27: xla.HloModuleConfigProto.optimization_level:type_name -> xla.ExecutionOptions.EffortLevel
	15, // 28: xla.HloModuleConfigProto.memory_fitting_level:type_name -> xla.ExecutionOptions.EffortLevel
	18, // 29: xla.HloModuleConfigProto.debug_options:type_name -> xla.DebugOptions
	42, // 30: xla.HloModuleConfigProto.static_device_assignment:type_name -> xla.DeviceAssignmentProto
	42, // 31: xla.HloModuleConfigProto.pre_simulation_device_assignment:type_name -> xla.DeviceAssignmentProto
	20, // 32: xla.HloModuleConfigProto.shardable_value_update_pairs:type_name -> xla.ShardableValueUpdatePairProto
	16, // 33: xla.HloModuleConfigProto.fusion_config_collection:type_name -> xla.HloModuleConfigProto.FusionConfigCollection
	30, // 34: xla.HloModuleConfigProto.fusion_config:type_name -> xla.HloModuleConfigProto.BoolList
	33, // 35: xla.HloModuleConfigProto.dot_config:type_name -> xla.HloModuleConfigProto.DotConfigEntry
	32, // 36: xla.HloModuleConfigProto.layout_config:type_name -> xla.HloModuleConfigProto.Int64ListList
	30, // 37: xla.HloModuleConfigProto.phase_ordering_config:type_name -> xla.HloModuleConfigProto.BoolList
	34, // 38: xla.HloModuleConfigProto.analysis_allowance_map:type_name -> xla.HloModuleConfigProto.AnalysisAllowanceMapEntry
	44, // 39: xla.HloModuleConfigProto.matrix_unit_operand_precision:type_name -> xla.PrecisionConfig.Precision
	26, // 40: xla.HloModuleConfigProto.sharding_config:type_name -> xla.ShardingConfigProto
	27, // 41: xla.HloModuleConfigProto.schedule_config:type_name -> xla.ScheduleConfigProto
	45, // 42: xla.HloModuleProtoWithConfig.hlo_module:type_name -> xla.HloModuleProto
	22, // 43: xla.HloModuleProtoWithConfig.config:type_name -> xla.HloModuleConfigProto
	45, // 44: xla.ScheduleProto.hlo_module:type_name -> xla.HloModuleProto
	37, // 45: xla.ScheduleProto.computation_schedules:type_name -> xla.ScheduleProto.ComputationScheduleProto
	46, // 46: xla.NodeShardingConfigProto.sharding:type_name -> xla.OpSharding
	25, // 47: xla.NodeShardingConfigProto.nodes:type_name -> xla.NodeShardingConfigProto
	25, // 48: xla.ShardingConfigProto.nodes:type_name -> xla.NodeShardingConfigProto
	38, // 49: xla.ScheduleConfigProto.sequence:type_name -> xla.ScheduleConfigProto.Instruction
	31, // 50: xla.HloModuleConfigProto.Int64ListList.lists:type_name -> xla.HloModuleConfigProto.Int64List
	31, // 51: xla.HloModuleConfigProto.DotConfigEntry.value:type_name -> xla.HloModuleConfigProto.Int64List
	35, // 52: xla.ScheduleProto.ComputationScheduleProto.instructions:type_name -> xla.ScheduleProto.Instruction
	36, // 53: xla.ScheduleProto.ComputationScheduleProto.scheduler_statistics:type_name -> xla.ScheduleProto.SchedulerStatisticsProto
	54, // [54:54] is the sub-list for method output_type
	54, // [54:54] is the sub-list for method input_type
	54, // [54:54] is the sub-list for extension type_name
	54, // [54:54] is the sub-list for extension extendee
	0,  // [0:54] is the sub-list for field type_name
}

func init() { file_xla_xla_proto_init() }
func file_xla_xla_proto_init() {
	if File_xla_xla_proto != nil {
		return
	}
	file_xla_xla_proto_msgTypes[1].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_xla_xla_proto_rawDesc), len(file_xla_xla_proto_rawDesc)),
			NumEnums:      17,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_xla_xla_proto_goTypes,
		DependencyIndexes: file_xla_xla_proto_depIdxs,
		EnumInfos:         file_xla_xla_proto_enumTypes,
		MessageInfos:      file_xla_xla_proto_msgTypes,
	}.Build()
	File_xla_xla_proto = out.File
	file_xla_xla_proto_goTypes = nil
	file_xla_xla_proto_depIdxs = nil
}
