// Copyright 2017 The OpenXLA Authors.
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//==============================================================================

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.4
// 	protoc        v3.21.12
// source: xla/xla_data.proto

package xla_data

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Primitive types are the individual values that can be held in rectangular
// multidimensional arrays. A description of the rectangular multidimensional
// array dimensions / primitive type is given by Shape, below.
//
// LINT.IfChange
type PrimitiveType int32

const (
	// Invalid primitive type to serve as default.
	PrimitiveType_PRIMITIVE_TYPE_INVALID PrimitiveType = 0
	// Predicates are two-state booleans.
	PrimitiveType_PRED PrimitiveType = 1
	// Signed integral values of fixed width.
	PrimitiveType_S1  PrimitiveType = 30
	PrimitiveType_S2  PrimitiveType = 26
	PrimitiveType_S4  PrimitiveType = 21
	PrimitiveType_S8  PrimitiveType = 2
	PrimitiveType_S16 PrimitiveType = 3
	PrimitiveType_S32 PrimitiveType = 4
	PrimitiveType_S64 PrimitiveType = 5
	// Unsigned integral values of fixed width.
	PrimitiveType_U1  PrimitiveType = 31
	PrimitiveType_U2  PrimitiveType = 27
	PrimitiveType_U4  PrimitiveType = 22
	PrimitiveType_U8  PrimitiveType = 6
	PrimitiveType_U16 PrimitiveType = 7
	PrimitiveType_U32 PrimitiveType = 8
	PrimitiveType_U64 PrimitiveType = 9
	// Floating-point values of fixed width.
	//
	// Note: if f16s are not natively supported on the device, they will be
	// converted to f16 from f32 at arbirary points in the computation.
	PrimitiveType_F16 PrimitiveType = 10
	PrimitiveType_F32 PrimitiveType = 11
	// Truncated 16 bit floating-point format. This is similar to IEEE's 16 bit
	// floating-point format, but uses 1 bit for the sign, 8 bits for the exponent
	// and 7 bits for the mantissa.
	PrimitiveType_BF16 PrimitiveType = 16
	PrimitiveType_F64  PrimitiveType = 12
	// FP8 dtypes, as described in this paper: https://arxiv.org/abs/2209.05433
	//
	// F8E5M2 has 5 exponent bits and 2 mantissa bits, and is similar to the
	// existing IEEE types.
	//
	// F8E4M3 has 4 exponent bits and 3 mantissa bits, and is similar to the
	// existing IEEE types.
	//
	// F8E4M3FN has 4 exponent bits and 3 mantissa bits. The "FN" means only
	// Finite and NaN values are supported. Unlike IEEE types, infinities are not
	// supported.  NaN is represented when the exponent and mantissa bits are all
	// 1s. All other values are finite.
	//
	// F8E4M3B11FNUZ has 4 exponent bits and 3 mantissa bits and a bias of 11. The
	// "FNUZ" means only Finite and NaN values are supported; zero is unsigned.
	// Unlike IEEE types, infinities are not supported.  NaN is represented when
	// the exponent and mantissa bits are all 0s with a sign bit of 1. All other
	// values are finite.
	//
	// F8E3M4 has 3 exponent bits and 4 mantissa bits, and is similar to the
	// existing IEEE types.
	//
	// Support for these dtypes is under development. They do not yet work
	// properly in most cases.
	// TODO(b/259609697): Fully support FP8.
	PrimitiveType_F8E5M2        PrimitiveType = 19
	PrimitiveType_F8E4M3        PrimitiveType = 28
	PrimitiveType_F8E4M3FN      PrimitiveType = 20
	PrimitiveType_F8E4M3B11FNUZ PrimitiveType = 23
	PrimitiveType_F8E3M4        PrimitiveType = 29
	// FP8 dtypes, as described in this paper: https://arxiv.org/abs/2206.02915
	//
	// F8E5M2FNUZ has 5 exponent bits and 2 mantissa bits.
	// F8E4M3FNUZ has 4 exponent bits and 3 mantissa bits.
	//
	// The "FNUZ" means only Finite and NaN values are supported; zero is
	// unsigned. Unlike IEEE types, infinities are not supported.  NaN is
	// represented when the exponent and mantissa bits are all 0s with a sign bit
	// of 1. All other values are finite.
	//
	// These differences mean there's an additional exponent value available. To
	// keep the same dynamic range as an IEEE-like FP8 type, the exponent is
	// biased one more than would be expected given the number of exponent bits
	// (8 for Float8E4M3FNUZ and 16 for Float8E5M2FNUZ).
	PrimitiveType_F8E5M2FNUZ PrimitiveType = 24
	PrimitiveType_F8E4M3FNUZ PrimitiveType = 25
	// MX float dtypes, as described in:
	// https://www.opencompute.org/documents/ocp-microscaling-formats-mx-v1-0-spec-final-pdf
	//
	// F4E2M1FN has 2 exponent bits and 1 mantissa bit.
	// F8E8M0FNU has 8 exponent bits, no mantissa and no sign.
	//
	// Only finite values are supported (hence "FN" suffix). Unlike IEEE types,
	// infinities and NaNs are not supported.
	PrimitiveType_F4E2M1FN  PrimitiveType = 32
	PrimitiveType_F8E8M0FNU PrimitiveType = 33
	// Complex values of fixed width.
	PrimitiveType_C64  PrimitiveType = 15 // Paired F32 (real, imag), as in std::complex<float>.
	PrimitiveType_C128 PrimitiveType = 18 // Paired F64 (real, imag), as in std::complex<double>.
	// A tuple is a polymorphic sequence; e.g. a shape that holds different
	// sub-shapes. They are used for things like returning multiple values from a
	// computation; e.g. a computation that returns weights and biases may have a
	// signature that results in a tuple like (f32[784x2000], f32[2000])
	//
	// If a shape proto has the tuple element type, it may not have any entries
	// in the dimensions field.
	PrimitiveType_TUPLE PrimitiveType = 13
	// An opaque type used for passing context-specific data to a custom
	// operation. Shapes of this primitive type will have empty dimensions and
	// tuple_shapes fields.
	//
	// (OPAQUE would be a better name for this identifier, but that conflicts with
	// a macro defined in windows.h.)
	PrimitiveType_OPAQUE_TYPE PrimitiveType = 14
	// A token type threaded between side-effecting operations. Shapes of this
	// primitive type will have empty dimensions and tuple_shapes fields.
	PrimitiveType_TOKEN PrimitiveType = 17
	// A buffer type. A shape of this primitive type has empty dimensions and
	// its underlying primitive type is in the tuple_shapes field.
	PrimitiveType_BUFFER PrimitiveType = 34
)

// Enum value maps for PrimitiveType.
var (
	PrimitiveType_name = map[int32]string{
		0:  "PRIMITIVE_TYPE_INVALID",
		1:  "PRED",
		30: "S1",
		26: "S2",
		21: "S4",
		2:  "S8",
		3:  "S16",
		4:  "S32",
		5:  "S64",
		31: "U1",
		27: "U2",
		22: "U4",
		6:  "U8",
		7:  "U16",
		8:  "U32",
		9:  "U64",
		10: "F16",
		11: "F32",
		16: "BF16",
		12: "F64",
		19: "F8E5M2",
		28: "F8E4M3",
		20: "F8E4M3FN",
		23: "F8E4M3B11FNUZ",
		29: "F8E3M4",
		24: "F8E5M2FNUZ",
		25: "F8E4M3FNUZ",
		32: "F4E2M1FN",
		33: "F8E8M0FNU",
		15: "C64",
		18: "C128",
		13: "TUPLE",
		14: "OPAQUE_TYPE",
		17: "TOKEN",
		34: "BUFFER",
	}
	PrimitiveType_value = map[string]int32{
		"PRIMITIVE_TYPE_INVALID": 0,
		"PRED":                   1,
		"S1":                     30,
		"S2":                     26,
		"S4":                     21,
		"S8":                     2,
		"S16":                    3,
		"S32":                    4,
		"S64":                    5,
		"U1":                     31,
		"U2":                     27,
		"U4":                     22,
		"U8":                     6,
		"U16":                    7,
		"U32":                    8,
		"U64":                    9,
		"F16":                    10,
		"F32":                    11,
		"BF16":                   16,
		"F64":                    12,
		"F8E5M2":                 19,
		"F8E4M3":                 28,
		"F8E4M3FN":               20,
		"F8E4M3B11FNUZ":          23,
		"F8E3M4":                 29,
		"F8E5M2FNUZ":             24,
		"F8E4M3FNUZ":             25,
		"F4E2M1FN":               32,
		"F8E8M0FNU":              33,
		"C64":                    15,
		"C128":                   18,
		"TUPLE":                  13,
		"OPAQUE_TYPE":            14,
		"TOKEN":                  17,
		"BUFFER":                 34,
	}
)

func (x PrimitiveType) Enum() *PrimitiveType {
	p := new(PrimitiveType)
	*p = x
	return p
}

func (x PrimitiveType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PrimitiveType) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_data_proto_enumTypes[0].Descriptor()
}

func (PrimitiveType) Type() protoreflect.EnumType {
	return &file_xla_xla_data_proto_enumTypes[0]
}

func (x PrimitiveType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PrimitiveType.Descriptor instead.
func (PrimitiveType) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{0}
}

// A DimLevelType indicates the encoding method for a dimension in an array.
// The semantics of this field are identical to those of the MLIR SparseTensor
// dialect.
// This should be kept in sync with the SparseTensor DimLevelType enum:
// https://github.com/llvm/llvm-project/blob/5674a3c88088e668b684326c2194a6282e8270ff/mlir/include/mlir/Dialect/SparseTensor/IR/SparseTensorAttrDefs.td#L86
type DimLevelType int32

const (
	// The corresponding dimension is Dense, every entry is stored.
	DimLevelType_DIM_DENSE DimLevelType = 0
	// The corresponding dimension is Compressed, only nonzeros are stored.
	DimLevelType_DIM_COMPRESSED DimLevelType = 1
	// The corresponding dimension contains a single coordinate, no sibling
	// elements for each parent.
	DimLevelType_DIM_SINGLETON DimLevelType = 2
	// The corresponding dimension is Compressed, but with potential trailing
	// zeros, thus an extra upper bound (high) is used to exclude those zeros.
	// E.g., indices = [1, 2, 0, 0, 3, 4, 0, 0], position = [(0, 2), (4, 6)].
	DimLevelType_DIM_LOOSE_COMPRESSED DimLevelType = 3
)

// Enum value maps for DimLevelType.
var (
	DimLevelType_name = map[int32]string{
		0: "DIM_DENSE",
		1: "DIM_COMPRESSED",
		2: "DIM_SINGLETON",
		3: "DIM_LOOSE_COMPRESSED",
	}
	DimLevelType_value = map[string]int32{
		"DIM_DENSE":            0,
		"DIM_COMPRESSED":       1,
		"DIM_SINGLETON":        2,
		"DIM_LOOSE_COMPRESSED": 3,
	}
)

func (x DimLevelType) Enum() *DimLevelType {
	p := new(DimLevelType)
	*p = x
	return p
}

func (x DimLevelType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DimLevelType) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_data_proto_enumTypes[1].Descriptor()
}

func (DimLevelType) Type() protoreflect.EnumType {
	return &file_xla_xla_data_proto_enumTypes[1]
}

func (x DimLevelType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DimLevelType.Descriptor instead.
func (DimLevelType) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{1}
}

// The type optimization profiles in use for Op-level optimizations.
type ProfileType int32

const (
	ProfileType_INVALID ProfileType = 0
	ProfileType_WINDOW  ProfileType = 1
	ProfileType_FLAG    ProfileType = 2
	ProfileType_INTEGER ProfileType = 3
)

// Enum value maps for ProfileType.
var (
	ProfileType_name = map[int32]string{
		0: "INVALID",
		1: "WINDOW",
		2: "FLAG",
		3: "INTEGER",
	}
	ProfileType_value = map[string]int32{
		"INVALID": 0,
		"WINDOW":  1,
		"FLAG":    2,
		"INTEGER": 3,
	}
)

func (x ProfileType) Enum() *ProfileType {
	p := new(ProfileType)
	*p = x
	return p
}

func (x ProfileType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProfileType) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_data_proto_enumTypes[2].Descriptor()
}

func (ProfileType) Type() protoreflect.EnumType {
	return &file_xla_xla_data_proto_enumTypes[2]
}

func (x ProfileType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProfileType.Descriptor instead.
func (ProfileType) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{2}
}

// The source of the optimization profile.
type ProfileSource int32

const (
	ProfileSource_PROFILE_SOURCE_UNKNOWN_SOURCE ProfileSource = 0
	ProfileSource_PROFILE_SOURCE_EMBEDDED       ProfileSource = 1
	ProfileSource_PROFILE_SOURCE_REMOTE         ProfileSource = 2
)

// Enum value maps for ProfileSource.
var (
	ProfileSource_name = map[int32]string{
		0: "PROFILE_SOURCE_UNKNOWN_SOURCE",
		1: "PROFILE_SOURCE_EMBEDDED",
		2: "PROFILE_SOURCE_REMOTE",
	}
	ProfileSource_value = map[string]int32{
		"PROFILE_SOURCE_UNKNOWN_SOURCE": 0,
		"PROFILE_SOURCE_EMBEDDED":       1,
		"PROFILE_SOURCE_REMOTE":         2,
	}
)

func (x ProfileSource) Enum() *ProfileSource {
	p := new(ProfileSource)
	*p = x
	return p
}

func (x ProfileSource) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProfileSource) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_data_proto_enumTypes[3].Descriptor()
}

func (ProfileSource) Type() protoreflect.EnumType {
	return &file_xla_xla_data_proto_enumTypes[3]
}

func (x ProfileSource) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProfileSource.Descriptor instead.
func (ProfileSource) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{3}
}

// The compilation event that triggered the use of the profile.
type CompilationEvent int32

const (
	CompilationEvent_COMPILATION_EVENT_UNKNOWN_EVENT     CompilationEvent = 0
	CompilationEvent_COMPILATION_EVENT_FIRST_COMPILATION CompilationEvent = 1
	CompilationEvent_COMPILATION_EVENT_RECOMPILATION     CompilationEvent = 2
)

// Enum value maps for CompilationEvent.
var (
	CompilationEvent_name = map[int32]string{
		0: "COMPILATION_EVENT_UNKNOWN_EVENT",
		1: "COMPILATION_EVENT_FIRST_COMPILATION",
		2: "COMPILATION_EVENT_RECOMPILATION",
	}
	CompilationEvent_value = map[string]int32{
		"COMPILATION_EVENT_UNKNOWN_EVENT":     0,
		"COMPILATION_EVENT_FIRST_COMPILATION": 1,
		"COMPILATION_EVENT_RECOMPILATION":     2,
	}
)

func (x CompilationEvent) Enum() *CompilationEvent {
	p := new(CompilationEvent)
	*p = x
	return p
}

func (x CompilationEvent) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CompilationEvent) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_data_proto_enumTypes[4].Descriptor()
}

func (CompilationEvent) Type() protoreflect.EnumType {
	return &file_xla_xla_data_proto_enumTypes[4]
}

func (x CompilationEvent) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CompilationEvent.Descriptor instead.
func (CompilationEvent) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{4}
}

// The type of profile generation strategy used to generate the profile.
type ProfileGenerationStrategy int32

const (
	ProfileGenerationStrategy_PROFILE_GENERATION_STRATEGY_UNKNOWN ProfileGenerationStrategy = 0
	ProfileGenerationStrategy_PROFILE_GENERATION_STRATEGY_GA      ProfileGenerationStrategy = 1
	ProfileGenerationStrategy_PROFILE_GENERATION_STRATEGY_FANTA   ProfileGenerationStrategy = 2
	ProfileGenerationStrategy_PROFILE_GENERATION_STRATEGY_CFO     ProfileGenerationStrategy = 3
	// The profile was generated using exhaustive search.
	ProfileGenerationStrategy_PROFILE_GENERATION_STRATEGY_EXHAUSTIVE ProfileGenerationStrategy = 4
	// The profile was generated using a learned cost model with a GNN
	// architecture.
	ProfileGenerationStrategy_PROFILE_GENERATION_STRATEGY_LCM_GNN ProfileGenerationStrategy = 5
	// The profile was generated using a learned cost model with a MOE
	// architecture.
	ProfileGenerationStrategy_PROFILE_GENERATION_STRATEGY_LCM_MOE ProfileGenerationStrategy = 6
)

// Enum value maps for ProfileGenerationStrategy.
var (
	ProfileGenerationStrategy_name = map[int32]string{
		0: "PROFILE_GENERATION_STRATEGY_UNKNOWN",
		1: "PROFILE_GENERATION_STRATEGY_GA",
		2: "PROFILE_GENERATION_STRATEGY_FANTA",
		3: "PROFILE_GENERATION_STRATEGY_CFO",
		4: "PROFILE_GENERATION_STRATEGY_EXHAUSTIVE",
		5: "PROFILE_GENERATION_STRATEGY_LCM_GNN",
		6: "PROFILE_GENERATION_STRATEGY_LCM_MOE",
	}
	ProfileGenerationStrategy_value = map[string]int32{
		"PROFILE_GENERATION_STRATEGY_UNKNOWN":    0,
		"PROFILE_GENERATION_STRATEGY_GA":         1,
		"PROFILE_GENERATION_STRATEGY_FANTA":      2,
		"PROFILE_GENERATION_STRATEGY_CFO":        3,
		"PROFILE_GENERATION_STRATEGY_EXHAUSTIVE": 4,
		"PROFILE_GENERATION_STRATEGY_LCM_GNN":    5,
		"PROFILE_GENERATION_STRATEGY_LCM_MOE":    6,
	}
)

func (x ProfileGenerationStrategy) Enum() *ProfileGenerationStrategy {
	p := new(ProfileGenerationStrategy)
	*p = x
	return p
}

func (x ProfileGenerationStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProfileGenerationStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_data_proto_enumTypes[5].Descriptor()
}

func (ProfileGenerationStrategy) Type() protoreflect.EnumType {
	return &file_xla_xla_data_proto_enumTypes[5]
}

func (x ProfileGenerationStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProfileGenerationStrategy.Descriptor instead.
func (ProfileGenerationStrategy) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{5}
}

type PaddingType int32

const (
	PaddingType_PADDING_INVALID PaddingType = 0
	PaddingType_PADDING_VALID   PaddingType = 1 // Only valid portion of the base are covered.
	PaddingType_PADDING_SAME    PaddingType = 2 // Extra is added to produce same output size as the input.
)

// Enum value maps for PaddingType.
var (
	PaddingType_name = map[int32]string{
		0: "PADDING_INVALID",
		1: "PADDING_VALID",
		2: "PADDING_SAME",
	}
	PaddingType_value = map[string]int32{
		"PADDING_INVALID": 0,
		"PADDING_VALID":   1,
		"PADDING_SAME":    2,
	}
)

func (x PaddingType) Enum() *PaddingType {
	p := new(PaddingType)
	*p = x
	return p
}

func (x PaddingType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PaddingType) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_data_proto_enumTypes[6].Descriptor()
}

func (PaddingType) Type() protoreflect.EnumType {
	return &file_xla_xla_data_proto_enumTypes[6]
}

func (x PaddingType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PaddingType.Descriptor instead.
func (PaddingType) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{6}
}

type FftType int32

const (
	FftType_FFT   FftType = 0 // Forward FFT; complex in, complex out.
	FftType_IFFT  FftType = 1 // Inverse FFT; complex in, complex out.
	FftType_RFFT  FftType = 2 // Forward real FFT; real in, fft_length / 2 + 1 complex out
	FftType_IRFFT FftType = 3 // Inverse real FFT; fft_length / 2 + 1 complex in,
)

// Enum value maps for FftType.
var (
	FftType_name = map[int32]string{
		0: "FFT",
		1: "IFFT",
		2: "RFFT",
		3: "IRFFT",
	}
	FftType_value = map[string]int32{
		"FFT":   0,
		"IFFT":  1,
		"RFFT":  2,
		"IRFFT": 3,
	}
)

func (x FftType) Enum() *FftType {
	p := new(FftType)
	*p = x
	return p
}

func (x FftType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FftType) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_data_proto_enumTypes[7].Descriptor()
}

func (FftType) Type() protoreflect.EnumType {
	return &file_xla_xla_data_proto_enumTypes[7]
}

func (x FftType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FftType.Descriptor instead.
func (FftType) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{7}
}

type RandomDistribution int32

const (
	RandomDistribution_RNG_INVALID RandomDistribution = 0
	// Creates a uniform-distribution-generated random number on the semi-open
	// interval [parameter[0], parameter[1]).
	RandomDistribution_RNG_UNIFORM RandomDistribution = 1
	// Creates a normal-distribution-generated random number with mean
	// parameter[0] and standard deviation parameter[1].
	RandomDistribution_RNG_NORMAL RandomDistribution = 2
)

// Enum value maps for RandomDistribution.
var (
	RandomDistribution_name = map[int32]string{
		0: "RNG_INVALID",
		1: "RNG_UNIFORM",
		2: "RNG_NORMAL",
	}
	RandomDistribution_value = map[string]int32{
		"RNG_INVALID": 0,
		"RNG_UNIFORM": 1,
		"RNG_NORMAL":  2,
	}
)

func (x RandomDistribution) Enum() *RandomDistribution {
	p := new(RandomDistribution)
	*p = x
	return p
}

func (x RandomDistribution) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RandomDistribution) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_data_proto_enumTypes[8].Descriptor()
}

func (RandomDistribution) Type() protoreflect.EnumType {
	return &file_xla_xla_data_proto_enumTypes[8]
}

func (x RandomDistribution) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RandomDistribution.Descriptor instead.
func (RandomDistribution) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{8}
}

type RandomAlgorithm int32

const (
	RandomAlgorithm_RNG_DEFAULT   RandomAlgorithm = 0 // Backend dependent default algorithm.
	RandomAlgorithm_RNG_THREE_FRY RandomAlgorithm = 1
	RandomAlgorithm_RNG_PHILOX    RandomAlgorithm = 2 // Next: 2
)

// Enum value maps for RandomAlgorithm.
var (
	RandomAlgorithm_name = map[int32]string{
		0: "RNG_DEFAULT",
		1: "RNG_THREE_FRY",
		2: "RNG_PHILOX",
	}
	RandomAlgorithm_value = map[string]int32{
		"RNG_DEFAULT":   0,
		"RNG_THREE_FRY": 1,
		"RNG_PHILOX":    2,
	}
)

func (x RandomAlgorithm) Enum() *RandomAlgorithm {
	p := new(RandomAlgorithm)
	*p = x
	return p
}

func (x RandomAlgorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RandomAlgorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_data_proto_enumTypes[9].Descriptor()
}

func (RandomAlgorithm) Type() protoreflect.EnumType {
	return &file_xla_xla_data_proto_enumTypes[9]
}

func (x RandomAlgorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RandomAlgorithm.Descriptor instead.
func (RandomAlgorithm) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{9}
}

type ChannelHandle_ChannelType int32

const (
	// Invalid primitive type to serve as default.
	ChannelHandle_CHANNEL_TYPE_INVALID ChannelHandle_ChannelType = 0
	// A channel for sending data between devices.
	ChannelHandle_DEVICE_TO_DEVICE ChannelHandle_ChannelType = 1
	// A channel for sending data from the device to the host. Can only be used
	// with a Send operation.
	ChannelHandle_DEVICE_TO_HOST ChannelHandle_ChannelType = 2
	// A channel for sending data from the host to the device. Can only be used
	// with a Recv operation.
	ChannelHandle_HOST_TO_DEVICE ChannelHandle_ChannelType = 3
)

// Enum value maps for ChannelHandle_ChannelType.
var (
	ChannelHandle_ChannelType_name = map[int32]string{
		0: "CHANNEL_TYPE_INVALID",
		1: "DEVICE_TO_DEVICE",
		2: "DEVICE_TO_HOST",
		3: "HOST_TO_DEVICE",
	}
	ChannelHandle_ChannelType_value = map[string]int32{
		"CHANNEL_TYPE_INVALID": 0,
		"DEVICE_TO_DEVICE":     1,
		"DEVICE_TO_HOST":       2,
		"HOST_TO_DEVICE":       3,
	}
)

func (x ChannelHandle_ChannelType) Enum() *ChannelHandle_ChannelType {
	p := new(ChannelHandle_ChannelType)
	*p = x
	return p
}

func (x ChannelHandle_ChannelType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ChannelHandle_ChannelType) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_data_proto_enumTypes[10].Descriptor()
}

func (ChannelHandle_ChannelType) Type() protoreflect.EnumType {
	return &file_xla_xla_data_proto_enumTypes[10]
}

func (x ChannelHandle_ChannelType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ChannelHandle_ChannelType.Descriptor instead.
func (ChannelHandle_ChannelType) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{12, 0}
}

// Should we transpose or use the adjoint of 'a'?
type TriangularSolveOptions_Transpose int32

const (
	TriangularSolveOptions_TRANSPOSE_INVALID TriangularSolveOptions_Transpose = 0
	TriangularSolveOptions_NO_TRANSPOSE      TriangularSolveOptions_Transpose = 1 // Don't transpose 'a'.
	TriangularSolveOptions_TRANSPOSE         TriangularSolveOptions_Transpose = 2 // Transpose 'a'.
	TriangularSolveOptions_ADJOINT           TriangularSolveOptions_Transpose = 3 // Complex conjugate and transpose 'a'.
)

// Enum value maps for TriangularSolveOptions_Transpose.
var (
	TriangularSolveOptions_Transpose_name = map[int32]string{
		0: "TRANSPOSE_INVALID",
		1: "NO_TRANSPOSE",
		2: "TRANSPOSE",
		3: "ADJOINT",
	}
	TriangularSolveOptions_Transpose_value = map[string]int32{
		"TRANSPOSE_INVALID": 0,
		"NO_TRANSPOSE":      1,
		"TRANSPOSE":         2,
		"ADJOINT":           3,
	}
)

func (x TriangularSolveOptions_Transpose) Enum() *TriangularSolveOptions_Transpose {
	p := new(TriangularSolveOptions_Transpose)
	*p = x
	return p
}

func (x TriangularSolveOptions_Transpose) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TriangularSolveOptions_Transpose) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_data_proto_enumTypes[11].Descriptor()
}

func (TriangularSolveOptions_Transpose) Type() protoreflect.EnumType {
	return &file_xla_xla_data_proto_enumTypes[11]
}

func (x TriangularSolveOptions_Transpose) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TriangularSolveOptions_Transpose.Descriptor instead.
func (TriangularSolveOptions_Transpose) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{22, 0}
}

type OpSharding_Type int32

const (
	// This sharding is replicated across all devices (implies maximal,
	// all other fields are unused).
	OpSharding_REPLICATED OpSharding_Type = 0
	// This sharding is maximal - one device runs the entire operation.
	OpSharding_MAXIMAL OpSharding_Type = 1
	// This sharding is a tuple - only the tuple_shardings field is valid.
	OpSharding_TUPLE OpSharding_Type = 2
	// None of the above; tile_shape and tile_assignment are both used.
	OpSharding_OTHER OpSharding_Type = 3
	// This op is manually sharded: the shapes are already partitioned and the
	// partitioner should not change this op.
	OpSharding_MANUAL OpSharding_Type = 4
	// This sharding is a placeholder sharding with lowest precedence, it can be
	// overwriten by any other shardings.
	OpSharding_UNKNOWN OpSharding_Type = 5
	// This op is unreduced: its outputs will not be combined via an all-reduce.
	OpSharding_UNREDUCED OpSharding_Type = 6
)

// Enum value maps for OpSharding_Type.
var (
	OpSharding_Type_name = map[int32]string{
		0: "REPLICATED",
		1: "MAXIMAL",
		2: "TUPLE",
		3: "OTHER",
		4: "MANUAL",
		5: "UNKNOWN",
		6: "UNREDUCED",
	}
	OpSharding_Type_value = map[string]int32{
		"REPLICATED": 0,
		"MAXIMAL":    1,
		"TUPLE":      2,
		"OTHER":      3,
		"MANUAL":     4,
		"UNKNOWN":    5,
		"UNREDUCED":  6,
	}
)

func (x OpSharding_Type) Enum() *OpSharding_Type {
	p := new(OpSharding_Type)
	*p = x
	return p
}

func (x OpSharding_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OpSharding_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_data_proto_enumTypes[12].Descriptor()
}

func (OpSharding_Type) Type() protoreflect.EnumType {
	return &file_xla_xla_data_proto_enumTypes[12]
}

func (x OpSharding_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OpSharding_Type.Descriptor instead.
func (OpSharding_Type) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{28, 0}
}

// Used to decide whether this op is to be sharded like some other ops, or to
// which other ops will be sharded like.
type OpSharding_ShardGroupType int32

const (
	// This op will be sharded exactly the same as the other op. (hard
	// restriction)
	OpSharding_AS OpSharding_ShardGroupType = 0
	// This op will try to allow sharding propagation within the same group even
	// there is no data dependencies among them, but there is no guarantee that
	// the final shardings within the same group will be exactly the same. (soft
	// restriction)
	OpSharding_LIKE OpSharding_ShardGroupType = 1
)

// Enum value maps for OpSharding_ShardGroupType.
var (
	OpSharding_ShardGroupType_name = map[int32]string{
		0: "AS",
		1: "LIKE",
	}
	OpSharding_ShardGroupType_value = map[string]int32{
		"AS":   0,
		"LIKE": 1,
	}
)

func (x OpSharding_ShardGroupType) Enum() *OpSharding_ShardGroupType {
	p := new(OpSharding_ShardGroupType)
	*p = x
	return p
}

func (x OpSharding_ShardGroupType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OpSharding_ShardGroupType) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_data_proto_enumTypes[13].Descriptor()
}

func (OpSharding_ShardGroupType) Type() protoreflect.EnumType {
	return &file_xla_xla_data_proto_enumTypes[13]
}

func (x OpSharding_ShardGroupType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OpSharding_ShardGroupType.Descriptor instead.
func (OpSharding_ShardGroupType) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{28, 1}
}

type ResultAccuracy_Mode int32

const (
	ResultAccuracy_DEFAULT ResultAccuracy_Mode = 0
	ResultAccuracy_HIGHEST ResultAccuracy_Mode = 1
)

// Enum value maps for ResultAccuracy_Mode.
var (
	ResultAccuracy_Mode_name = map[int32]string{
		0: "DEFAULT",
		1: "HIGHEST",
	}
	ResultAccuracy_Mode_value = map[string]int32{
		"DEFAULT": 0,
		"HIGHEST": 1,
	}
)

func (x ResultAccuracy_Mode) Enum() *ResultAccuracy_Mode {
	p := new(ResultAccuracy_Mode)
	*p = x
	return p
}

func (x ResultAccuracy_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ResultAccuracy_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_data_proto_enumTypes[14].Descriptor()
}

func (ResultAccuracy_Mode) Type() protoreflect.EnumType {
	return &file_xla_xla_data_proto_enumTypes[14]
}

func (x ResultAccuracy_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ResultAccuracy_Mode.Descriptor instead.
func (ResultAccuracy_Mode) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{33, 0}
}

type PrecisionConfig_Precision int32

const (
	PrecisionConfig_DEFAULT PrecisionConfig_Precision = 0
	PrecisionConfig_HIGH    PrecisionConfig_Precision = 1
	PrecisionConfig_HIGHEST PrecisionConfig_Precision = 2
)

// Enum value maps for PrecisionConfig_Precision.
var (
	PrecisionConfig_Precision_name = map[int32]string{
		0: "DEFAULT",
		1: "HIGH",
		2: "HIGHEST",
	}
	PrecisionConfig_Precision_value = map[string]int32{
		"DEFAULT": 0,
		"HIGH":    1,
		"HIGHEST": 2,
	}
)

func (x PrecisionConfig_Precision) Enum() *PrecisionConfig_Precision {
	p := new(PrecisionConfig_Precision)
	*p = x
	return p
}

func (x PrecisionConfig_Precision) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PrecisionConfig_Precision) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_data_proto_enumTypes[15].Descriptor()
}

func (PrecisionConfig_Precision) Type() protoreflect.EnumType {
	return &file_xla_xla_data_proto_enumTypes[15]
}

func (x PrecisionConfig_Precision) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PrecisionConfig_Precision.Descriptor instead.
func (PrecisionConfig_Precision) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{34, 0}
}

// The algorithm used to evaluate the instruction.
//
// The naming convention for the dot instruction is
// ALG_DOT_{A_TYPE}_{B_TYPE}_{ACCUM_TYPE}[_X{NUM_OPS}] where A_TYPE, B_TYPE
// and ACCUM_TYPE correspond to the types in the "primitive dot operations"
// (such as TensorCore operations) and NUM_OPS is the number of such
// operations used per "primitive tile". When the NUM_OPS
// field is skipped, it is assumed to be 1. The types mentioned in the name
// are independent of the storage types.
//
// In general ATYPE and BTYPE are the precisions that the LHS and RHS of the
// operation are rounded to and ACCUMTYPE is the accumulation type. If a
// backend does not support the given algorithm, an error is raised. The
// Algorithm enum is intended to eventually replace the Precision enum.
type PrecisionConfig_Algorithm int32

const (
	// If the algorithm is `ALG_UNSET`, we will decide the algorithm based on
	// the operand_precision values (for now).
	PrecisionConfig_ALG_UNSET PrecisionConfig_Algorithm = 0
	// The storage type can be any 8-bit floating point type.
	PrecisionConfig_ALG_DOT_ANY_F8_ANY_F8_F32 PrecisionConfig_Algorithm = 1
	// The storage type can be any 8-bit floating point type. Intermediate
	// results will not periodically be promoted to a higher precision. This
	// corresponds to CUBLASLT_MATMUL_DESC_FAST_ACCUM. Triton's
	// maxNumImpreciseAcc=32 setting may be similar.
	PrecisionConfig_ALG_DOT_ANY_F8_ANY_F8_F32_FAST_ACCUM PrecisionConfig_Algorithm = 2
	PrecisionConfig_ALG_DOT_F16_F16_F16                  PrecisionConfig_Algorithm = 3
	PrecisionConfig_ALG_DOT_F16_F16_F32                  PrecisionConfig_Algorithm = 4
	PrecisionConfig_ALG_DOT_BF16_BF16_BF16               PrecisionConfig_Algorithm = 5
	PrecisionConfig_ALG_DOT_BF16_BF16_F32                PrecisionConfig_Algorithm = 6
	// An algorithm which uses 3 BF16_BF16_F32 matmuls to achieve better
	// precision.
	PrecisionConfig_ALG_DOT_BF16_BF16_F32_X3 PrecisionConfig_Algorithm = 7
	// An algorithm which uses 6 BF16_BF16_F32 matmuls to achieve better
	// precision (similar to F32).
	PrecisionConfig_ALG_DOT_BF16_BF16_F32_X6 PrecisionConfig_Algorithm = 8
	PrecisionConfig_ALG_DOT_TF32_TF32_F32    PrecisionConfig_Algorithm = 9
	// An algorithm which uses 3 TF32_TF32_F32 matmuls to achieve better
	// precision (similar to F32).
	PrecisionConfig_ALG_DOT_TF32_TF32_F32_X3 PrecisionConfig_Algorithm = 10
	PrecisionConfig_ALG_DOT_F32_F32_F32      PrecisionConfig_Algorithm = 11
	PrecisionConfig_ALG_DOT_F64_F64_F64      PrecisionConfig_Algorithm = 12
	PrecisionConfig_ALG_DOT_BF16_BF16_F32_X9 PrecisionConfig_Algorithm = 13
)

// Enum value maps for PrecisionConfig_Algorithm.
var (
	PrecisionConfig_Algorithm_name = map[int32]string{
		0:  "ALG_UNSET",
		1:  "ALG_DOT_ANY_F8_ANY_F8_F32",
		2:  "ALG_DOT_ANY_F8_ANY_F8_F32_FAST_ACCUM",
		3:  "ALG_DOT_F16_F16_F16",
		4:  "ALG_DOT_F16_F16_F32",
		5:  "ALG_DOT_BF16_BF16_BF16",
		6:  "ALG_DOT_BF16_BF16_F32",
		7:  "ALG_DOT_BF16_BF16_F32_X3",
		8:  "ALG_DOT_BF16_BF16_F32_X6",
		9:  "ALG_DOT_TF32_TF32_F32",
		10: "ALG_DOT_TF32_TF32_F32_X3",
		11: "ALG_DOT_F32_F32_F32",
		12: "ALG_DOT_F64_F64_F64",
		13: "ALG_DOT_BF16_BF16_F32_X9",
	}
	PrecisionConfig_Algorithm_value = map[string]int32{
		"ALG_UNSET":                            0,
		"ALG_DOT_ANY_F8_ANY_F8_F32":            1,
		"ALG_DOT_ANY_F8_ANY_F8_F32_FAST_ACCUM": 2,
		"ALG_DOT_F16_F16_F16":                  3,
		"ALG_DOT_F16_F16_F32":                  4,
		"ALG_DOT_BF16_BF16_BF16":               5,
		"ALG_DOT_BF16_BF16_F32":                6,
		"ALG_DOT_BF16_BF16_F32_X3":             7,
		"ALG_DOT_BF16_BF16_F32_X6":             8,
		"ALG_DOT_TF32_TF32_F32":                9,
		"ALG_DOT_TF32_TF32_F32_X3":             10,
		"ALG_DOT_F32_F32_F32":                  11,
		"ALG_DOT_F64_F64_F64":                  12,
		"ALG_DOT_BF16_BF16_F32_X9":             13,
	}
)

func (x PrecisionConfig_Algorithm) Enum() *PrecisionConfig_Algorithm {
	p := new(PrecisionConfig_Algorithm)
	*p = x
	return p
}

func (x PrecisionConfig_Algorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PrecisionConfig_Algorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_xla_xla_data_proto_enumTypes[16].Descriptor()
}

func (PrecisionConfig_Algorithm) Type() protoreflect.EnumType {
	return &file_xla_xla_data_proto_enumTypes[16]
}

func (x PrecisionConfig_Algorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PrecisionConfig_Algorithm.Descriptor instead.
func (PrecisionConfig_Algorithm) EnumDescriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{34, 1}
}

// Describes the padding configuration for Pad operation. The padding amount on
// both edges as well as between the elements are specified for each dimension.
type PaddingConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The padding configuration for all dimensions.
	Dimensions    []*PaddingConfig_PaddingConfigDimension `protobuf:"bytes,1,rep,name=dimensions,proto3" json:"dimensions,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PaddingConfig) Reset() {
	*x = PaddingConfig{}
	mi := &file_xla_xla_data_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PaddingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PaddingConfig) ProtoMessage() {}

func (x *PaddingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PaddingConfig.ProtoReflect.Descriptor instead.
func (*PaddingConfig) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{0}
}

func (x *PaddingConfig) GetDimensions() []*PaddingConfig_PaddingConfigDimension {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

// Describes a tile used in tiling-based layout. Refer to
// g3doc/third_party/xla/docs/tiled_layout.md for details about tiling-based
// layout.
type TileProto struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Number of elements in each dimension of the tile. It's ordered from the
	// most major dimension of the tile to the most minor dimension of the tile.
	// The dimensions correspond to a suffix of the dimensions of the shape being
	// tiled.
	Dimensions    []int64 `protobuf:"varint,1,rep,packed,name=dimensions,proto3" json:"dimensions,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TileProto) Reset() {
	*x = TileProto{}
	mi := &file_xla_xla_data_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TileProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TileProto) ProtoMessage() {}

func (x *TileProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TileProto.ProtoReflect.Descriptor instead.
func (*TileProto) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{1}
}

func (x *TileProto) GetDimensions() []int64 {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

// Describes how data should be split between different memories.
type SplitConfigProto struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The dimension that is split.
	Dimension int64 `protobuf:"varint,1,opt,name=dimension,proto3" json:"dimension,omitempty"`
	// The indices where each split point occurs. For example, if the dimension
	// size is 1024, a split_indices value of {512} indicates a two-way split of
	// data through the middle.
	SplitIndices  []int64 `protobuf:"varint,2,rep,packed,name=split_indices,json=splitIndices,proto3" json:"split_indices,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SplitConfigProto) Reset() {
	*x = SplitConfigProto{}
	mi := &file_xla_xla_data_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SplitConfigProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SplitConfigProto) ProtoMessage() {}

func (x *SplitConfigProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SplitConfigProto.ProtoReflect.Descriptor instead.
func (*SplitConfigProto) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{2}
}

func (x *SplitConfigProto) GetDimension() int64 {
	if x != nil {
		return x.Dimension
	}
	return 0
}

func (x *SplitConfigProto) GetSplitIndices() []int64 {
	if x != nil {
		return x.SplitIndices
	}
	return nil
}

// A layout describes how the array is placed in (1D) memory space.  This
// includes the minor-to-major ordering of dimensions within a shape.
//
// Clients must specify the layouts of input Literals to the
// computation. Layouts specified in interior operations which take Shapes (for
// example, Convert) are ignored.
//
// See https://openxla.org/xla/shapes for more information on shapes and
// layouts.
//
// LINT.IfChange
type LayoutProto struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Sequence of dimension indices, from minor (fastest varying index) to major
	// (slowest varying index). The size of this field must equal the table's
	// rank.
	MinorToMajor []int64 `protobuf:"varint,1,rep,packed,name=minor_to_major,json=minorToMajor,proto3" json:"minor_to_major,omitempty"`
	// The dimension level type list for this array, specifying the way in which
	// each array dimension is represented in memory. If this list is empty, the
	// array is assumed to be dense.
	DimLevelTypes []DimLevelType `protobuf:"varint,9,rep,packed,name=dim_level_types,json=dimLevelTypes,proto3,enum=xla.DimLevelType" json:"dim_level_types,omitempty"`
	// Whether each dimension is unique or ordered.  Each of the following lists
	// must either be empty or have one entry for each entry of dim_level_types.
	// If either list is empty, all dimensions are assumed to be unique or
	// ordered, respectively.  Entries in this list may not be false for some
	// DimLevelType values (such as DIM_DENSE in particular).
	DimUnique  []bool `protobuf:"varint,13,rep,packed,name=dim_unique,json=dimUnique,proto3" json:"dim_unique,omitempty"`
	DimOrdered []bool `protobuf:"varint,14,rep,packed,name=dim_ordered,json=dimOrdered,proto3" json:"dim_ordered,omitempty"`
	// A sequence of tiles, starting from the tile that's applied first to the
	// Shape.
	//
	// TODO(b/119839262): implement tiling in each backend or add Unimplemented
	// error.
	Tiles []*TileProto `protobuf:"bytes,6,rep,name=tiles,proto3" json:"tiles,omitempty"`
	// The shape is padded at the end to the smallest multiple of, in terms of
	// number of elements, this value. This is useful when tiling does not bring
	// the shape to certain desired granules. Tiling effectively
	// pads/reshapes/transposes the shape to another shape. This field pads the
	// total number of elements of that new shape to a multiple of certain number
	// of elements. This is useful such as we want a layout which does not tile
	// the data but still requires it to be padded to certain number of elements.
	//
	// If omitted or set to 0, it's treated as 1.
	TailPaddingAlignmentInElements int64 `protobuf:"varint,16,opt,name=tail_padding_alignment_in_elements,json=tailPaddingAlignmentInElements,proto3" json:"tail_padding_alignment_in_elements,omitempty"`
	// (Optional) Bit size of each element. When unspecified or being 0, default
	// to ShapeUtil::ByteSizeOfPrimitiveType.
	ElementSizeInBits int64 `protobuf:"varint,7,opt,name=element_size_in_bits,json=elementSizeInBits,proto3" json:"element_size_in_bits,omitempty"`
	// Memory space where this array resides. The integer field is interpreted in
	// a backend-specific manner.
	MemorySpace int64 `protobuf:"varint,8,opt,name=memory_space,json=memorySpace,proto3" json:"memory_space,omitempty"`
	// The integer types to be used for indices and pointers.  These fields must
	// not be used unless the layout represents a sparse array.  The PrimitiveType
	// must correspond to an unsigned integer (U8, U16, U32, or U64).
	// If not provided, the compiler will use the largest unsigned integer
	// that is naturally supported by the target device (U32 or U64 in currently
	// supported devices).
	IndexPrimitiveType   PrimitiveType `protobuf:"varint,11,opt,name=index_primitive_type,json=indexPrimitiveType,proto3,enum=xla.PrimitiveType" json:"index_primitive_type,omitempty"`
	PointerPrimitiveType PrimitiveType `protobuf:"varint,12,opt,name=pointer_primitive_type,json=pointerPrimitiveType,proto3,enum=xla.PrimitiveType" json:"pointer_primitive_type,omitempty"`
	// The physical, on-device shape used to represent the shape this layout
	// belongs to. Only used for sparse arrays.
	// The layout(s) contained within the physical shape should not also contain
	// a physical shape.
	PhysicalShape *ShapeProto `protobuf:"bytes,10,opt,name=physical_shape,json=physicalShape,proto3" json:"physical_shape,omitempty"`
	// The dynamic shape metadata size in bytes in front of the shape data. The
	// field may be non-zero for a static shape whose associated buffer is for a
	// dynamic shape, e.g. a result of SliceToDynamic.
	DynamicShapeMetadataPrefixBytes int64 `protobuf:"varint,15,opt,name=dynamic_shape_metadata_prefix_bytes,json=dynamicShapeMetadataPrefixBytes,proto3" json:"dynamic_shape_metadata_prefix_bytes,omitempty"`
	// The split configurations which describe if/how the data is split between
	// different memories.
	SplitConfigs  []*SplitConfigProto `protobuf:"bytes,17,rep,name=split_configs,json=splitConfigs,proto3" json:"split_configs,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LayoutProto) Reset() {
	*x = LayoutProto{}
	mi := &file_xla_xla_data_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LayoutProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LayoutProto) ProtoMessage() {}

func (x *LayoutProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LayoutProto.ProtoReflect.Descriptor instead.
func (*LayoutProto) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{3}
}

func (x *LayoutProto) GetMinorToMajor() []int64 {
	if x != nil {
		return x.MinorToMajor
	}
	return nil
}

func (x *LayoutProto) GetDimLevelTypes() []DimLevelType {
	if x != nil {
		return x.DimLevelTypes
	}
	return nil
}

func (x *LayoutProto) GetDimUnique() []bool {
	if x != nil {
		return x.DimUnique
	}
	return nil
}

func (x *LayoutProto) GetDimOrdered() []bool {
	if x != nil {
		return x.DimOrdered
	}
	return nil
}

func (x *LayoutProto) GetTiles() []*TileProto {
	if x != nil {
		return x.Tiles
	}
	return nil
}

func (x *LayoutProto) GetTailPaddingAlignmentInElements() int64 {
	if x != nil {
		return x.TailPaddingAlignmentInElements
	}
	return 0
}

func (x *LayoutProto) GetElementSizeInBits() int64 {
	if x != nil {
		return x.ElementSizeInBits
	}
	return 0
}

func (x *LayoutProto) GetMemorySpace() int64 {
	if x != nil {
		return x.MemorySpace
	}
	return 0
}

func (x *LayoutProto) GetIndexPrimitiveType() PrimitiveType {
	if x != nil {
		return x.IndexPrimitiveType
	}
	return PrimitiveType_PRIMITIVE_TYPE_INVALID
}

func (x *LayoutProto) GetPointerPrimitiveType() PrimitiveType {
	if x != nil {
		return x.PointerPrimitiveType
	}
	return PrimitiveType_PRIMITIVE_TYPE_INVALID
}

func (x *LayoutProto) GetPhysicalShape() *ShapeProto {
	if x != nil {
		return x.PhysicalShape
	}
	return nil
}

func (x *LayoutProto) GetDynamicShapeMetadataPrefixBytes() int64 {
	if x != nil {
		return x.DynamicShapeMetadataPrefixBytes
	}
	return 0
}

func (x *LayoutProto) GetSplitConfigs() []*SplitConfigProto {
	if x != nil {
		return x.SplitConfigs
	}
	return nil
}

// A shape describes the number of dimensions in the array, the size of each
// dimension, and the primitive component type.
//
// Tuples are a special case in that they have rank zero and have tuple_shapes
// defined.
//
// See https://openxla.org/xla/shapes for more information on shapes and
// layouts.
//
// LINT.IfChange
type ShapeProto struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// If this is TUPLE/TOKEN/OPAQUE_TYPE, the shape is a tuple/token/opaque shape
	// respectively. Otherwise, the shape is an array shape and this is its
	// element type.
	ElementType PrimitiveType `protobuf:"varint,2,opt,name=element_type,json=elementType,proto3,enum=xla.PrimitiveType" json:"element_type,omitempty"`
	// Used only for an array shape.
	//
	// The size (number of elements) for each dimension, or an upper bound on the
	// size if the dimension is dynamic.  In XLA, dimensions are numbered from 0
	// to N-1 for an N-dimensional array. The first element of 'dimensions' is the
	// size of dimension 0, the second element is the size of dimension 1, and so
	// forth.  Empty list indicates a scalar.
	//
	// Each element in this list must be >= 0. In particular, 0 is a valid value
	// for a dimension size.
	//
	// If a dimension is dynamic (see `is_dynamic_dimension` below), its value
	// in this list is an upper bound on the size of the dimension.
	Dimensions []int64 `protobuf:"varint,3,rep,packed,name=dimensions,proto3" json:"dimensions,omitempty"`
	// Used only for an array shape.
	//
	// Indicates whether or not each dimension is dynamically-sized. If this list
	// is empty, all dimensions are statically-sized. Otherwise, this must have
	// the same size as 'dimensions' and the value at index i indicates whether
	// or not the dimension at index i is dynamically-sized.
	IsDynamicDimension []bool `protobuf:"varint,6,rep,packed,name=is_dynamic_dimension,json=isDynamicDimension,proto3" json:"is_dynamic_dimension,omitempty"`
	// For tuples only. The constituent shapes in the tuple.
	TupleShapes []*ShapeProto `protobuf:"bytes,4,rep,name=tuple_shapes,json=tupleShapes,proto3" json:"tuple_shapes,omitempty"`
	// The layout used to back this shape.
	Layout        *LayoutProto `protobuf:"bytes,5,opt,name=layout,proto3" json:"layout,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ShapeProto) Reset() {
	*x = ShapeProto{}
	mi := &file_xla_xla_data_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ShapeProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShapeProto) ProtoMessage() {}

func (x *ShapeProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShapeProto.ProtoReflect.Descriptor instead.
func (*ShapeProto) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{4}
}

func (x *ShapeProto) GetElementType() PrimitiveType {
	if x != nil {
		return x.ElementType
	}
	return PrimitiveType_PRIMITIVE_TYPE_INVALID
}

func (x *ShapeProto) GetDimensions() []int64 {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

func (x *ShapeProto) GetIsDynamicDimension() []bool {
	if x != nil {
		return x.IsDynamicDimension
	}
	return nil
}

func (x *ShapeProto) GetTupleShapes() []*ShapeProto {
	if x != nil {
		return x.TupleShapes
	}
	return nil
}

func (x *ShapeProto) GetLayout() *LayoutProto {
	if x != nil {
		return x.Layout
	}
	return nil
}

// Shape of the parameters and output of a computation (like a traditional
// function signature).
type ProgramShapeProto struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	Parameters     []*ShapeProto          `protobuf:"bytes,1,rep,name=parameters,proto3" json:"parameters,omitempty"`
	Result         *ShapeProto            `protobuf:"bytes,2,opt,name=result,proto3" json:"result,omitempty"`
	ParameterNames []string               `protobuf:"bytes,3,rep,name=parameter_names,json=parameterNames,proto3" json:"parameter_names,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *ProgramShapeProto) Reset() {
	*x = ProgramShapeProto{}
	mi := &file_xla_xla_data_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProgramShapeProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProgramShapeProto) ProtoMessage() {}

func (x *ProgramShapeProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProgramShapeProto.ProtoReflect.Descriptor instead.
func (*ProgramShapeProto) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{5}
}

func (x *ProgramShapeProto) GetParameters() []*ShapeProto {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *ProgramShapeProto) GetResult() *ShapeProto {
	if x != nil {
		return x.Result
	}
	return nil
}

func (x *ProgramShapeProto) GetParameterNames() []string {
	if x != nil {
		return x.ParameterNames
	}
	return nil
}

// Statistics of a computation.
type ComputationStats struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The number of floating point operations in the computation.
	FlopCount float64 `protobuf:"fixed64,1,opt,name=flop_count,json=flopCount,proto3" json:"flop_count,omitempty"`
	// The number of transcendental operations (e.g., exp) in the computation.
	TranscendentalCount float64 `protobuf:"fixed64,2,opt,name=transcendental_count,json=transcendentalCount,proto3" json:"transcendental_count,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *ComputationStats) Reset() {
	*x = ComputationStats{}
	mi := &file_xla_xla_data_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ComputationStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputationStats) ProtoMessage() {}

func (x *ComputationStats) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputationStats.ProtoReflect.Descriptor instead.
func (*ComputationStats) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{6}
}

func (x *ComputationStats) GetFlopCount() float64 {
	if x != nil {
		return x.FlopCount
	}
	return 0
}

func (x *ComputationStats) GetTranscendentalCount() float64 {
	if x != nil {
		return x.TranscendentalCount
	}
	return 0
}

// Symbolization metadata for HLO Instructions.
//
// This metadata is used for debugging XLA code generation, as well as
// performance profiling of XLA-generated executables.
type OpMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The framework op name that generated this XLA op.
	//
	// Frameworks that build on top of XLA should mirror the names of their ops
	// back to users by specifying the op_type. In this way, even if the
	// framework's "ops" are implemented as multiple XLA HLO Ops, they can be
	// grouped appropriately. (e.g. if a SoftMax layer is emitted into XLA as
	// multiple ops, then each op should have the op_type be "SoftMax".)
	OpType string `protobuf:"bytes,1,opt,name=op_type,json=opType,proto3" json:"op_type,omitempty"`
	// The user-specified name of the op.
	//
	// This name is often unique within a computation. Note: some frameworks
	// add auto-generated names if the user does not provide one.
	OpName string `protobuf:"bytes,2,opt,name=op_name,json=opName,proto3" json:"op_name,omitempty"`
	// Indicate a file and line that this op is associated to in a user's program.
	//
	// e.g. it could be the file and line of user code that generated the op.
	SourceFile      string `protobuf:"bytes,3,opt,name=source_file,json=sourceFile,proto3" json:"source_file,omitempty"`
	SourceLine      int32  `protobuf:"varint,4,opt,name=source_line,json=sourceLine,proto3" json:"source_line,omitempty"`
	SourceEndLine   int32  `protobuf:"varint,17,opt,name=source_end_line,json=sourceEndLine,proto3" json:"source_end_line,omitempty"`
	SourceColumn    int32  `protobuf:"varint,18,opt,name=source_column,json=sourceColumn,proto3" json:"source_column,omitempty"`
	SourceEndColumn int32  `protobuf:"varint,19,opt,name=source_end_column,json=sourceEndColumn,proto3" json:"source_end_column,omitempty"`
	// Deprecated, use [ProfileInfo][profile_type] instead.
	//
	// Deprecated: Marked as deprecated in xla/xla_data.proto.
	ProfileType []ProfileType `protobuf:"varint,5,rep,packed,name=profile_type,json=profileType,proto3,enum=xla.ProfileType" json:"profile_type,omitempty"`
	// The footprint of the generated code for the instruction.
	SizeOfGeneratedCodeInBytes int64 `protobuf:"varint,8,opt,name=size_of_generated_code_in_bytes,json=sizeOfGeneratedCodeInBytes,proto3" json:"size_of_generated_code_in_bytes,omitempty"`
	// The size of the working set, i.e., the amount of memory, used by the
	// instruction in a compiler-managed fast device memory.
	SizeOfMemoryWorkingSetInBytes int64 `protobuf:"varint,9,opt,name=size_of_memory_working_set_in_bytes,json=sizeOfMemoryWorkingSetInBytes,proto3" json:"size_of_memory_working_set_in_bytes,omitempty"`
	// Profile information for the Op.
	ProfileInfo *OpMetadata_ProfileInfo `protobuf:"bytes,10,opt,name=profile_info,json=profileInfo,proto3" json:"profile_info,omitempty"`
	// Deduplicated HLO name for this op. In some cases, we can have multiple
	// instructions (e.g. fusions) that are considered duplicates. We want to
	// group them together under the same name so that we can group them together
	// during analysis (e.g. HLO Op Profile tool in Xprof).
	// E.g. If we have fusion.1, fusion.2, and fusion.3 marked as duplicates,
	// fusion.2 and fusion.3 will have deduplicated_name = fusion.1
	DeduplicatedName string `protobuf:"bytes,12,opt,name=deduplicated_name,json=deduplicatedName,proto3" json:"deduplicated_name,omitempty"`
	// 1-based position of the frame in frames flat array.
	// Ids are 1-based to keep 0 value as representation of non-set property.
	StackFrameId int32 `protobuf:"varint,15,opt,name=stack_frame_id,json=stackFrameId,proto3" json:"stack_frame_id,omitempty"`
	// Instruction name available upon scheduling.
	SchedulingName string `protobuf:"bytes,16,opt,name=scheduling_name,json=schedulingName,proto3" json:"scheduling_name,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *OpMetadata) Reset() {
	*x = OpMetadata{}
	mi := &file_xla_xla_data_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpMetadata) ProtoMessage() {}

func (x *OpMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpMetadata.ProtoReflect.Descriptor instead.
func (*OpMetadata) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{7}
}

func (x *OpMetadata) GetOpType() string {
	if x != nil {
		return x.OpType
	}
	return ""
}

func (x *OpMetadata) GetOpName() string {
	if x != nil {
		return x.OpName
	}
	return ""
}

func (x *OpMetadata) GetSourceFile() string {
	if x != nil {
		return x.SourceFile
	}
	return ""
}

func (x *OpMetadata) GetSourceLine() int32 {
	if x != nil {
		return x.SourceLine
	}
	return 0
}

func (x *OpMetadata) GetSourceEndLine() int32 {
	if x != nil {
		return x.SourceEndLine
	}
	return 0
}

func (x *OpMetadata) GetSourceColumn() int32 {
	if x != nil {
		return x.SourceColumn
	}
	return 0
}

func (x *OpMetadata) GetSourceEndColumn() int32 {
	if x != nil {
		return x.SourceEndColumn
	}
	return 0
}

// Deprecated: Marked as deprecated in xla/xla_data.proto.
func (x *OpMetadata) GetProfileType() []ProfileType {
	if x != nil {
		return x.ProfileType
	}
	return nil
}

func (x *OpMetadata) GetSizeOfGeneratedCodeInBytes() int64 {
	if x != nil {
		return x.SizeOfGeneratedCodeInBytes
	}
	return 0
}

func (x *OpMetadata) GetSizeOfMemoryWorkingSetInBytes() int64 {
	if x != nil {
		return x.SizeOfMemoryWorkingSetInBytes
	}
	return 0
}

func (x *OpMetadata) GetProfileInfo() *OpMetadata_ProfileInfo {
	if x != nil {
		return x.ProfileInfo
	}
	return nil
}

func (x *OpMetadata) GetDeduplicatedName() string {
	if x != nil {
		return x.DeduplicatedName
	}
	return ""
}

func (x *OpMetadata) GetStackFrameId() int32 {
	if x != nil {
		return x.StackFrameId
	}
	return 0
}

func (x *OpMetadata) GetSchedulingName() string {
	if x != nil {
		return x.SchedulingName
	}
	return ""
}

// Profile data from the execution of a computation.
type ExecutionProfile struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Whether the executable was read from the compilation cache.
	CompilationCacheHit bool `protobuf:"varint,1,opt,name=compilation_cache_hit,json=compilationCacheHit,proto3" json:"compilation_cache_hit,omitempty"`
	// The time in milliseconds spent to compile the computation. This only set if
	// the executable was not read from the compilation cache
	// (compilation_cache_hit == false).
	CompileTimeMs int64 `protobuf:"varint,2,opt,name=compile_time_ms,json=compileTimeMs,proto3" json:"compile_time_ms,omitempty"`
	// The number of cycles spent for the computation. This does not include the
	// time taken for the data transfers between the host and the device. This is
	// a target-dependent field and only used for debugging purposes.
	ComputeCycleCount int64 `protobuf:"varint,3,opt,name=compute_cycle_count,json=computeCycleCount,proto3" json:"compute_cycle_count,omitempty"`
	// The time in nanoseconds spent for the computation, without data transfer.
	ComputeTimeNs int64 `protobuf:"varint,4,opt,name=compute_time_ns,json=computeTimeNs,proto3" json:"compute_time_ns,omitempty"`
	// The time in nanoseconds spent for the entire computation, including the
	// result data transfer time. Current implementation does not spend any cycles
	// for the input data transfer since the memory is initialized with the proper
	// values before the execution.
	ComputeAndTransferTimeNs int64 `protobuf:"varint,5,opt,name=compute_and_transfer_time_ns,json=computeAndTransferTimeNs,proto3" json:"compute_and_transfer_time_ns,omitempty"`
	// The size of the binary code in the executable.
	ExecutableSizeInBytes int64 `protobuf:"varint,6,opt,name=executable_size_in_bytes,json=executableSizeInBytes,proto3" json:"executable_size_in_bytes,omitempty"`
	// Whether this profile was drawn from a cache of profiles instead of from
	// execution on the hardware.
	ProfileCacheHit bool `protobuf:"varint,7,opt,name=profile_cache_hit,json=profileCacheHit,proto3" json:"profile_cache_hit,omitempty"`
	// Whether a warm-up run of the computation was executed before the
	// measured execution.
	WarmupRunExecuted bool `protobuf:"varint,8,opt,name=warmup_run_executed,json=warmupRunExecuted,proto3" json:"warmup_run_executed,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *ExecutionProfile) Reset() {
	*x = ExecutionProfile{}
	mi := &file_xla_xla_data_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExecutionProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionProfile) ProtoMessage() {}

func (x *ExecutionProfile) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionProfile.ProtoReflect.Descriptor instead.
func (*ExecutionProfile) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{8}
}

func (x *ExecutionProfile) GetCompilationCacheHit() bool {
	if x != nil {
		return x.CompilationCacheHit
	}
	return false
}

func (x *ExecutionProfile) GetCompileTimeMs() int64 {
	if x != nil {
		return x.CompileTimeMs
	}
	return 0
}

func (x *ExecutionProfile) GetComputeCycleCount() int64 {
	if x != nil {
		return x.ComputeCycleCount
	}
	return 0
}

func (x *ExecutionProfile) GetComputeTimeNs() int64 {
	if x != nil {
		return x.ComputeTimeNs
	}
	return 0
}

func (x *ExecutionProfile) GetComputeAndTransferTimeNs() int64 {
	if x != nil {
		return x.ComputeAndTransferTimeNs
	}
	return 0
}

func (x *ExecutionProfile) GetExecutableSizeInBytes() int64 {
	if x != nil {
		return x.ExecutableSizeInBytes
	}
	return 0
}

func (x *ExecutionProfile) GetProfileCacheHit() bool {
	if x != nil {
		return x.ProfileCacheHit
	}
	return false
}

func (x *ExecutionProfile) GetWarmupRunExecuted() bool {
	if x != nil {
		return x.WarmupRunExecuted
	}
	return false
}

// Handle given to a user that represents an execution that the user launched
// asynchronously on the device.
type ExecutionHandle struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Handle        int64                  `protobuf:"varint,1,opt,name=handle,proto3" json:"handle,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ExecutionHandle) Reset() {
	*x = ExecutionHandle{}
	mi := &file_xla_xla_data_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExecutionHandle) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionHandle) ProtoMessage() {}

func (x *ExecutionHandle) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionHandle.ProtoReflect.Descriptor instead.
func (*ExecutionHandle) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{9}
}

func (x *ExecutionHandle) GetHandle() int64 {
	if x != nil {
		return x.Handle
	}
	return 0
}

// Handle given to a user that represents a globally accessible allocation.
// Contrast this against a ComputationDataHandle, which is not globally
// accessible, since it only exists within a specific computation.
type GlobalDataHandle struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Handle        int64                  `protobuf:"varint,1,opt,name=handle,proto3" json:"handle,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GlobalDataHandle) Reset() {
	*x = GlobalDataHandle{}
	mi := &file_xla_xla_data_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GlobalDataHandle) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GlobalDataHandle) ProtoMessage() {}

func (x *GlobalDataHandle) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GlobalDataHandle.ProtoReflect.Descriptor instead.
func (*GlobalDataHandle) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{10}
}

func (x *GlobalDataHandle) GetHandle() int64 {
	if x != nil {
		return x.Handle
	}
	return 0
}

// Handle given to a user that represents a replicated virtual device. Each
// replicated device represents N physical devices for execution where N is the
// number of replicas.
type DeviceHandle struct {
	state  protoimpl.MessageState `protogen:"open.v1"`
	Handle int64                  `protobuf:"varint,1,opt,name=handle,proto3" json:"handle,omitempty"`
	// The number of model-parallel virtual devices that communicate via XLA
	// Send/Recv instructions.
	DeviceCount   int64 `protobuf:"varint,2,opt,name=device_count,json=deviceCount,proto3" json:"device_count,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeviceHandle) Reset() {
	*x = DeviceHandle{}
	mi := &file_xla_xla_data_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeviceHandle) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceHandle) ProtoMessage() {}

func (x *DeviceHandle) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceHandle.ProtoReflect.Descriptor instead.
func (*DeviceHandle) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{11}
}

func (x *DeviceHandle) GetHandle() int64 {
	if x != nil {
		return x.Handle
	}
	return 0
}

func (x *DeviceHandle) GetDeviceCount() int64 {
	if x != nil {
		return x.DeviceCount
	}
	return 0
}

// Handle given to a user to represent a channel between two computations
// via a Send and Recv instruction pair. Channels are unbuffered, so Send
// Send instructions will be blocked until the data is transferred.
type ChannelHandle struct {
	state         protoimpl.MessageState    `protogen:"open.v1"`
	Handle        int64                     `protobuf:"varint,1,opt,name=handle,proto3" json:"handle,omitempty"`
	Type          ChannelHandle_ChannelType `protobuf:"varint,2,opt,name=type,proto3,enum=xla.ChannelHandle_ChannelType" json:"type,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ChannelHandle) Reset() {
	*x = ChannelHandle{}
	mi := &file_xla_xla_data_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChannelHandle) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChannelHandle) ProtoMessage() {}

func (x *ChannelHandle) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChannelHandle.ProtoReflect.Descriptor instead.
func (*ChannelHandle) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{12}
}

func (x *ChannelHandle) GetHandle() int64 {
	if x != nil {
		return x.Handle
	}
	return 0
}

func (x *ChannelHandle) GetType() ChannelHandle_ChannelType {
	if x != nil {
		return x.Type
	}
	return ChannelHandle_CHANNEL_TYPE_INVALID
}

// DeviceAssignmentProto is a serialized form of DeviceAssignment class, which
// represents the device ids assigned to a set of replicated computations.
// See xla::DeviceAssignment class comment for more details.
type DeviceAssignmentProto struct {
	state              protoimpl.MessageState                     `protogen:"open.v1"`
	ReplicaCount       int32                                      `protobuf:"varint,1,opt,name=replica_count,json=replicaCount,proto3" json:"replica_count,omitempty"`
	ComputationCount   int32                                      `protobuf:"varint,2,opt,name=computation_count,json=computationCount,proto3" json:"computation_count,omitempty"`
	ComputationDevices []*DeviceAssignmentProto_ComputationDevice `protobuf:"bytes,3,rep,name=computation_devices,json=computationDevices,proto3" json:"computation_devices,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *DeviceAssignmentProto) Reset() {
	*x = DeviceAssignmentProto{}
	mi := &file_xla_xla_data_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeviceAssignmentProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceAssignmentProto) ProtoMessage() {}

func (x *DeviceAssignmentProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceAssignmentProto.ProtoReflect.Descriptor instead.
func (*DeviceAssignmentProto) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{13}
}

func (x *DeviceAssignmentProto) GetReplicaCount() int32 {
	if x != nil {
		return x.ReplicaCount
	}
	return 0
}

func (x *DeviceAssignmentProto) GetComputationCount() int32 {
	if x != nil {
		return x.ComputationCount
	}
	return 0
}

func (x *DeviceAssignmentProto) GetComputationDevices() []*DeviceAssignmentProto_ComputationDevice {
	if x != nil {
		return x.ComputationDevices
	}
	return nil
}

// Literals are used when the server and client need to exchange materialized
// data / results. Literals are also used to describe constants used in
// computations.
//
// Transfers to/from the client are encoded in literal form, and the structure
// of the repeated fields is implied by the shape.
type LiteralProto struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Shape         *ShapeProto            `protobuf:"bytes,1,opt,name=shape,proto3" json:"shape,omitempty"`
	Preds         []bool                 `protobuf:"varint,2,rep,packed,name=preds,proto3" json:"preds,omitempty"`
	S1S           []byte                 `protobuf:"bytes,30,opt,name=s1s,proto3" json:"s1s,omitempty"`
	S2S           []byte                 `protobuf:"bytes,26,opt,name=s2s,proto3" json:"s2s,omitempty"`
	S4S           []byte                 `protobuf:"bytes,21,opt,name=s4s,proto3" json:"s4s,omitempty"`
	S8S           []byte                 `protobuf:"bytes,15,opt,name=s8s,proto3" json:"s8s,omitempty"`
	U1S           []byte                 `protobuf:"bytes,31,opt,name=u1s,proto3" json:"u1s,omitempty"`
	U2S           []byte                 `protobuf:"bytes,27,opt,name=u2s,proto3" json:"u2s,omitempty"`
	U4S           []byte                 `protobuf:"bytes,22,opt,name=u4s,proto3" json:"u4s,omitempty"`
	U8S           []byte                 `protobuf:"bytes,3,opt,name=u8s,proto3" json:"u8s,omitempty"`
	S32S          []int32                `protobuf:"varint,4,rep,packed,name=s32s,proto3" json:"s32s,omitempty"`
	S64S          []int64                `protobuf:"varint,5,rep,packed,name=s64s,proto3" json:"s64s,omitempty"`
	U32S          []uint32               `protobuf:"varint,6,rep,packed,name=u32s,proto3" json:"u32s,omitempty"`
	U64S          []uint64               `protobuf:"varint,7,rep,packed,name=u64s,proto3" json:"u64s,omitempty"`
	F32S          []float32              `protobuf:"fixed32,8,rep,packed,name=f32s,proto3" json:"f32s,omitempty"`
	F64S          []float64              `protobuf:"fixed64,9,rep,packed,name=f64s,proto3" json:"f64s,omitempty"`
	C64S          []float32              `protobuf:"fixed32,12,rep,packed,name=c64s,proto3" json:"c64s,omitempty"`   // Stored as interleaved real, imag floats.
	C128S         []float64              `protobuf:"fixed64,18,rep,packed,name=c128s,proto3" json:"c128s,omitempty"` // Stored as interleaved real, imag doubles.
	TupleLiterals []*LiteralProto        `protobuf:"bytes,10,rep,name=tuple_literals,json=tupleLiterals,proto3" json:"tuple_literals,omitempty"`
	// The F16s, BF16s, U16s and S16s are encoded in little endian byte order
	F16S           []byte  `protobuf:"bytes,11,opt,name=f16s,proto3" json:"f16s,omitempty"`
	Bf16S          []byte  `protobuf:"bytes,13,opt,name=bf16s,proto3" json:"bf16s,omitempty"`
	U16S           []byte  `protobuf:"bytes,16,opt,name=u16s,proto3" json:"u16s,omitempty"`
	S16S           []byte  `protobuf:"bytes,17,opt,name=s16s,proto3" json:"s16s,omitempty"`
	F4E2M1Fns      []byte  `protobuf:"bytes,32,opt,name=f4e2m1fns,proto3" json:"f4e2m1fns,omitempty"`
	F8E3M4S        []byte  `protobuf:"bytes,29,opt,name=f8e3m4s,proto3" json:"f8e3m4s,omitempty"`
	F8E4M3B11Fnuzs []byte  `protobuf:"bytes,23,opt,name=f8e4m3b11fnuzs,proto3" json:"f8e4m3b11fnuzs,omitempty"`
	F8E4M3Fns      []byte  `protobuf:"bytes,20,opt,name=f8e4m3fns,proto3" json:"f8e4m3fns,omitempty"`
	F8E4M3Fnuzs    []byte  `protobuf:"bytes,25,opt,name=f8e4m3fnuzs,proto3" json:"f8e4m3fnuzs,omitempty"`
	F8E4M3S        []byte  `protobuf:"bytes,28,opt,name=f8e4m3s,proto3" json:"f8e4m3s,omitempty"`
	F8E5M2Fnuzs    []byte  `protobuf:"bytes,24,opt,name=f8e5m2fnuzs,proto3" json:"f8e5m2fnuzs,omitempty"`
	F8E5M2S        []byte  `protobuf:"bytes,19,opt,name=f8e5m2s,proto3" json:"f8e5m2s,omitempty"`
	F8E8M0Fnus     []byte  `protobuf:"bytes,33,opt,name=f8e8m0fnus,proto3" json:"f8e8m0fnus,omitempty"`
	SparseIndices  []int64 `protobuf:"varint,14,rep,packed,name=sparse_indices,json=sparseIndices,proto3" json:"sparse_indices,omitempty"` // Next = 34
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *LiteralProto) Reset() {
	*x = LiteralProto{}
	mi := &file_xla_xla_data_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LiteralProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LiteralProto) ProtoMessage() {}

func (x *LiteralProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LiteralProto.ProtoReflect.Descriptor instead.
func (*LiteralProto) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{14}
}

func (x *LiteralProto) GetShape() *ShapeProto {
	if x != nil {
		return x.Shape
	}
	return nil
}

func (x *LiteralProto) GetPreds() []bool {
	if x != nil {
		return x.Preds
	}
	return nil
}

func (x *LiteralProto) GetS1S() []byte {
	if x != nil {
		return x.S1S
	}
	return nil
}

func (x *LiteralProto) GetS2S() []byte {
	if x != nil {
		return x.S2S
	}
	return nil
}

func (x *LiteralProto) GetS4S() []byte {
	if x != nil {
		return x.S4S
	}
	return nil
}

func (x *LiteralProto) GetS8S() []byte {
	if x != nil {
		return x.S8S
	}
	return nil
}

func (x *LiteralProto) GetU1S() []byte {
	if x != nil {
		return x.U1S
	}
	return nil
}

func (x *LiteralProto) GetU2S() []byte {
	if x != nil {
		return x.U2S
	}
	return nil
}

func (x *LiteralProto) GetU4S() []byte {
	if x != nil {
		return x.U4S
	}
	return nil
}

func (x *LiteralProto) GetU8S() []byte {
	if x != nil {
		return x.U8S
	}
	return nil
}

func (x *LiteralProto) GetS32S() []int32 {
	if x != nil {
		return x.S32S
	}
	return nil
}

func (x *LiteralProto) GetS64S() []int64 {
	if x != nil {
		return x.S64S
	}
	return nil
}

func (x *LiteralProto) GetU32S() []uint32 {
	if x != nil {
		return x.U32S
	}
	return nil
}

func (x *LiteralProto) GetU64S() []uint64 {
	if x != nil {
		return x.U64S
	}
	return nil
}

func (x *LiteralProto) GetF32S() []float32 {
	if x != nil {
		return x.F32S
	}
	return nil
}

func (x *LiteralProto) GetF64S() []float64 {
	if x != nil {
		return x.F64S
	}
	return nil
}

func (x *LiteralProto) GetC64S() []float32 {
	if x != nil {
		return x.C64S
	}
	return nil
}

func (x *LiteralProto) GetC128S() []float64 {
	if x != nil {
		return x.C128S
	}
	return nil
}

func (x *LiteralProto) GetTupleLiterals() []*LiteralProto {
	if x != nil {
		return x.TupleLiterals
	}
	return nil
}

func (x *LiteralProto) GetF16S() []byte {
	if x != nil {
		return x.F16S
	}
	return nil
}

func (x *LiteralProto) GetBf16S() []byte {
	if x != nil {
		return x.Bf16S
	}
	return nil
}

func (x *LiteralProto) GetU16S() []byte {
	if x != nil {
		return x.U16S
	}
	return nil
}

func (x *LiteralProto) GetS16S() []byte {
	if x != nil {
		return x.S16S
	}
	return nil
}

func (x *LiteralProto) GetF4E2M1Fns() []byte {
	if x != nil {
		return x.F4E2M1Fns
	}
	return nil
}

func (x *LiteralProto) GetF8E3M4S() []byte {
	if x != nil {
		return x.F8E3M4S
	}
	return nil
}

func (x *LiteralProto) GetF8E4M3B11Fnuzs() []byte {
	if x != nil {
		return x.F8E4M3B11Fnuzs
	}
	return nil
}

func (x *LiteralProto) GetF8E4M3Fns() []byte {
	if x != nil {
		return x.F8E4M3Fns
	}
	return nil
}

func (x *LiteralProto) GetF8E4M3Fnuzs() []byte {
	if x != nil {
		return x.F8E4M3Fnuzs
	}
	return nil
}

func (x *LiteralProto) GetF8E4M3S() []byte {
	if x != nil {
		return x.F8E4M3S
	}
	return nil
}

func (x *LiteralProto) GetF8E5M2Fnuzs() []byte {
	if x != nil {
		return x.F8E5M2Fnuzs
	}
	return nil
}

func (x *LiteralProto) GetF8E5M2S() []byte {
	if x != nil {
		return x.F8E5M2S
	}
	return nil
}

func (x *LiteralProto) GetF8E8M0Fnus() []byte {
	if x != nil {
		return x.F8E8M0Fnus
	}
	return nil
}

func (x *LiteralProto) GetSparseIndices() []int64 {
	if x != nil {
		return x.SparseIndices
	}
	return nil
}

type WindowDimension struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The size of the window in this dimension. For a rectangle, this would be
	// the width or height.
	Size int64 `protobuf:"varint,1,opt,name=size,proto3" json:"size,omitempty"`
	// The stride at which the window moves across the base area in this
	// dimension. In other words, this is the spacing between different
	// positions of the window in this dimension.
	Stride int64 `protobuf:"varint,2,opt,name=stride,proto3" json:"stride,omitempty"`
	// If positive, means the amount of padding to add to the base area at the low
	// end of this dimension; if negative, its negative means the number of
	// elements removed from the low end of this dimension. For example, in the
	// horizontal dimension of a rectangle, this would be the number of padding
	// values to pad on the left, given that indices increase when going right.
	// The actual padding value depends upon the context. Convolution pads with
	// zeros. ReduceWindow and SelectAndScatter pads with the reduce function's
	// init value.
	PaddingLow int64 `protobuf:"varint,3,opt,name=padding_low,json=paddingLow,proto3" json:"padding_low,omitempty"`
	// As padding_low, but on the high end of this dimension. For example, in the
	// horizontal dimension of a rectangle, this would be the number of values to
	// pad on the right, given that indices increase when going right.
	PaddingHigh int64 `protobuf:"varint,4,opt,name=padding_high,json=paddingHigh,proto3" json:"padding_high,omitempty"`
	// Dilation factor of the sliding window in this dimension. A dilation factor
	// of 1 means no dilation. window_dilation - 1 no-op entries ("holes") are
	// implicitly placed between each kernel element. This value may not be less
	// than 1. See documentation for convolution.
	WindowDilation int64 `protobuf:"varint,5,opt,name=window_dilation,json=windowDilation,proto3" json:"window_dilation,omitempty"`
	// Dilation factor of the base area in this dimension. A dilation factor of 1
	// means no dilation. base_dilation - 1 no-op entries ("holes") are implicitly
	// placed between each base area element. This value may not be less than 1.
	// See documentation for convolution.
	BaseDilation int64 `protobuf:"varint,6,opt,name=base_dilation,json=baseDilation,proto3" json:"base_dilation,omitempty"`
	// Window reversal means that this dimension was logically reversed before the
	// operation.
	WindowReversal bool `protobuf:"varint,7,opt,name=window_reversal,json=windowReversal,proto3" json:"window_reversal,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *WindowDimension) Reset() {
	*x = WindowDimension{}
	mi := &file_xla_xla_data_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WindowDimension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WindowDimension) ProtoMessage() {}

func (x *WindowDimension) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WindowDimension.ProtoReflect.Descriptor instead.
func (*WindowDimension) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{15}
}

func (x *WindowDimension) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *WindowDimension) GetStride() int64 {
	if x != nil {
		return x.Stride
	}
	return 0
}

func (x *WindowDimension) GetPaddingLow() int64 {
	if x != nil {
		return x.PaddingLow
	}
	return 0
}

func (x *WindowDimension) GetPaddingHigh() int64 {
	if x != nil {
		return x.PaddingHigh
	}
	return 0
}

func (x *WindowDimension) GetWindowDilation() int64 {
	if x != nil {
		return x.WindowDilation
	}
	return 0
}

func (x *WindowDimension) GetBaseDilation() int64 {
	if x != nil {
		return x.BaseDilation
	}
	return 0
}

func (x *WindowDimension) GetWindowReversal() bool {
	if x != nil {
		return x.WindowReversal
	}
	return false
}

// Describes the windowing in an operation such as convolution.
//
// The window is moved across a base area and for each position of the
// window a computation is performed. The field below describes the
// window and the movement of the window across a base area.
type Window struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Dimensions    []*WindowDimension     `protobuf:"bytes,1,rep,name=dimensions,proto3" json:"dimensions,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Window) Reset() {
	*x = Window{}
	mi := &file_xla_xla_data_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Window) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Window) ProtoMessage() {}

func (x *Window) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Window.ProtoReflect.Descriptor instead.
func (*Window) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{16}
}

func (x *Window) GetDimensions() []*WindowDimension {
	if x != nil {
		return x.Dimensions
	}
	return nil
}

// Describes the dimension numbers for a gather operation.
//
// See https://www.tensorflow.org/performance/xla/operation_semantics#gather for
// more details.
type GatherDimensionNumbers struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// "Window indices" is a term for a set of indices that index into the
	// interior of a dynamic-slice from the input tensor, the starting indices for
	// which were computed from output_gather_dims (see the operation semantic for
	// how this is defined) and the start_indices tensor.
	//
	// The window indices for a specific output index Out is computed as:
	//
	//	i = 0
	//	for (k : [0, input_tensor_shape.rank))
	//	  window_indices[k] =
	//	    if k in collapsed_slice_dims
	//	    then 0
	//	    else Out[offset_dims[i++]]
	OffsetDims         []int64 `protobuf:"varint,1,rep,packed,name=offset_dims,json=offsetDims,proto3" json:"offset_dims,omitempty"`
	CollapsedSliceDims []int64 `protobuf:"varint,2,rep,packed,name=collapsed_slice_dims,json=collapsedSliceDims,proto3" json:"collapsed_slice_dims,omitempty"`
	// This is interpreted as a map from i to start_index_map[i]. It
	// transforms the gather index looked up from the start_indices tensor into
	// the starting index in the input space.
	StartIndexMap []int64 `protobuf:"varint,3,rep,packed,name=start_index_map,json=startIndexMap,proto3" json:"start_index_map,omitempty"`
	// The dimension in the start_indices input that contains the starting
	// indices.
	IndexVectorDim int64 `protobuf:"varint,4,opt,name=index_vector_dim,json=indexVectorDim,proto3" json:"index_vector_dim,omitempty"`
	// This is the batch dimensions in the operand.
	OperandBatchingDims []int64 `protobuf:"varint,5,rep,packed,name=operand_batching_dims,json=operandBatchingDims,proto3" json:"operand_batching_dims,omitempty"`
	// This is the batch dimensions in the index, and it should be the same size
	// as operand_batching_dims.
	StartIndicesBatchingDims []int64 `protobuf:"varint,6,rep,packed,name=start_indices_batching_dims,json=startIndicesBatchingDims,proto3" json:"start_indices_batching_dims,omitempty"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *GatherDimensionNumbers) Reset() {
	*x = GatherDimensionNumbers{}
	mi := &file_xla_xla_data_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GatherDimensionNumbers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatherDimensionNumbers) ProtoMessage() {}

func (x *GatherDimensionNumbers) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatherDimensionNumbers.ProtoReflect.Descriptor instead.
func (*GatherDimensionNumbers) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{17}
}

func (x *GatherDimensionNumbers) GetOffsetDims() []int64 {
	if x != nil {
		return x.OffsetDims
	}
	return nil
}

func (x *GatherDimensionNumbers) GetCollapsedSliceDims() []int64 {
	if x != nil {
		return x.CollapsedSliceDims
	}
	return nil
}

func (x *GatherDimensionNumbers) GetStartIndexMap() []int64 {
	if x != nil {
		return x.StartIndexMap
	}
	return nil
}

func (x *GatherDimensionNumbers) GetIndexVectorDim() int64 {
	if x != nil {
		return x.IndexVectorDim
	}
	return 0
}

func (x *GatherDimensionNumbers) GetOperandBatchingDims() []int64 {
	if x != nil {
		return x.OperandBatchingDims
	}
	return nil
}

func (x *GatherDimensionNumbers) GetStartIndicesBatchingDims() []int64 {
	if x != nil {
		return x.StartIndicesBatchingDims
	}
	return nil
}

// Describes the dimension numbers for a scatter operation.
//
// All the fields are similar to the corresponding fields in
// GatherDimensionNumbers. Differences are noted below.
type ScatterDimensionNumbers struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The set of dimensions in the updates shape that are window dimensions.
	UpdateWindowDims []int64 `protobuf:"varint,1,rep,packed,name=update_window_dims,json=updateWindowDims,proto3" json:"update_window_dims,omitempty"`
	// The set of window dimensions that must be inserted into the updates shape.
	InsertedWindowDims       []int64 `protobuf:"varint,2,rep,packed,name=inserted_window_dims,json=insertedWindowDims,proto3" json:"inserted_window_dims,omitempty"`
	ScatterDimsToOperandDims []int64 `protobuf:"varint,3,rep,packed,name=scatter_dims_to_operand_dims,json=scatterDimsToOperandDims,proto3" json:"scatter_dims_to_operand_dims,omitempty"`
	IndexVectorDim           int64   `protobuf:"varint,4,opt,name=index_vector_dim,json=indexVectorDim,proto3" json:"index_vector_dim,omitempty"`
	// This is the batch dimension in the input.
	InputBatchingDims []int64 `protobuf:"varint,5,rep,packed,name=input_batching_dims,json=inputBatchingDims,proto3" json:"input_batching_dims,omitempty"`
	// This is the batch dimension in the index.
	ScatterIndicesBatchingDims []int64 `protobuf:"varint,6,rep,packed,name=scatter_indices_batching_dims,json=scatterIndicesBatchingDims,proto3" json:"scatter_indices_batching_dims,omitempty"`
	unknownFields              protoimpl.UnknownFields
	sizeCache                  protoimpl.SizeCache
}

func (x *ScatterDimensionNumbers) Reset() {
	*x = ScatterDimensionNumbers{}
	mi := &file_xla_xla_data_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ScatterDimensionNumbers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScatterDimensionNumbers) ProtoMessage() {}

func (x *ScatterDimensionNumbers) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScatterDimensionNumbers.ProtoReflect.Descriptor instead.
func (*ScatterDimensionNumbers) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{18}
}

func (x *ScatterDimensionNumbers) GetUpdateWindowDims() []int64 {
	if x != nil {
		return x.UpdateWindowDims
	}
	return nil
}

func (x *ScatterDimensionNumbers) GetInsertedWindowDims() []int64 {
	if x != nil {
		return x.InsertedWindowDims
	}
	return nil
}

func (x *ScatterDimensionNumbers) GetScatterDimsToOperandDims() []int64 {
	if x != nil {
		return x.ScatterDimsToOperandDims
	}
	return nil
}

func (x *ScatterDimensionNumbers) GetIndexVectorDim() int64 {
	if x != nil {
		return x.IndexVectorDim
	}
	return 0
}

func (x *ScatterDimensionNumbers) GetInputBatchingDims() []int64 {
	if x != nil {
		return x.InputBatchingDims
	}
	return nil
}

func (x *ScatterDimensionNumbers) GetScatterIndicesBatchingDims() []int64 {
	if x != nil {
		return x.ScatterIndicesBatchingDims
	}
	return nil
}

type ConvolutionDimensionNumbers struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The number of the dimension that represents batch in the input.
	InputBatchDimension int64 `protobuf:"varint,7,opt,name=input_batch_dimension,json=inputBatchDimension,proto3" json:"input_batch_dimension,omitempty"`
	// The number of the dimension that represents features in the input.
	InputFeatureDimension int64 `protobuf:"varint,8,opt,name=input_feature_dimension,json=inputFeatureDimension,proto3" json:"input_feature_dimension,omitempty"`
	// The dimension numbers for the spatial dimensions that the window
	// moves through in the input.
	InputSpatialDimensions []int64 `protobuf:"varint,11,rep,packed,name=input_spatial_dimensions,json=inputSpatialDimensions,proto3" json:"input_spatial_dimensions,omitempty"`
	// The number of the dimension that represents input features in the
	// convolutional kernel (rhs).
	KernelInputFeatureDimension int64 `protobuf:"varint,3,opt,name=kernel_input_feature_dimension,json=kernelInputFeatureDimension,proto3" json:"kernel_input_feature_dimension,omitempty"`
	// The number of the dimension that represents output features in
	// the convolutional kernel (rhs).
	KernelOutputFeatureDimension int64 `protobuf:"varint,4,opt,name=kernel_output_feature_dimension,json=kernelOutputFeatureDimension,proto3" json:"kernel_output_feature_dimension,omitempty"`
	// The dimension numbers for the spatial dimensions that the window
	// moves through in the kernel (rhs). window.strides(0) is the
	// stride in the kernel_spatial_dimensions(0) dimension.
	KernelSpatialDimensions []int64 `protobuf:"varint,6,rep,packed,name=kernel_spatial_dimensions,json=kernelSpatialDimensions,proto3" json:"kernel_spatial_dimensions,omitempty"`
	// The number of the dimension that represents batch in the output.
	OutputBatchDimension int64 `protobuf:"varint,9,opt,name=output_batch_dimension,json=outputBatchDimension,proto3" json:"output_batch_dimension,omitempty"`
	// The number of the dimension that represents features in the output.
	OutputFeatureDimension int64 `protobuf:"varint,10,opt,name=output_feature_dimension,json=outputFeatureDimension,proto3" json:"output_feature_dimension,omitempty"`
	// The dimension numbers for the spatial dimensions that the window
	// moves through in the output.
	OutputSpatialDimensions []int64 `protobuf:"varint,12,rep,packed,name=output_spatial_dimensions,json=outputSpatialDimensions,proto3" json:"output_spatial_dimensions,omitempty"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *ConvolutionDimensionNumbers) Reset() {
	*x = ConvolutionDimensionNumbers{}
	mi := &file_xla_xla_data_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConvolutionDimensionNumbers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConvolutionDimensionNumbers) ProtoMessage() {}

func (x *ConvolutionDimensionNumbers) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConvolutionDimensionNumbers.ProtoReflect.Descriptor instead.
func (*ConvolutionDimensionNumbers) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{19}
}

func (x *ConvolutionDimensionNumbers) GetInputBatchDimension() int64 {
	if x != nil {
		return x.InputBatchDimension
	}
	return 0
}

func (x *ConvolutionDimensionNumbers) GetInputFeatureDimension() int64 {
	if x != nil {
		return x.InputFeatureDimension
	}
	return 0
}

func (x *ConvolutionDimensionNumbers) GetInputSpatialDimensions() []int64 {
	if x != nil {
		return x.InputSpatialDimensions
	}
	return nil
}

func (x *ConvolutionDimensionNumbers) GetKernelInputFeatureDimension() int64 {
	if x != nil {
		return x.KernelInputFeatureDimension
	}
	return 0
}

func (x *ConvolutionDimensionNumbers) GetKernelOutputFeatureDimension() int64 {
	if x != nil {
		return x.KernelOutputFeatureDimension
	}
	return 0
}

func (x *ConvolutionDimensionNumbers) GetKernelSpatialDimensions() []int64 {
	if x != nil {
		return x.KernelSpatialDimensions
	}
	return nil
}

func (x *ConvolutionDimensionNumbers) GetOutputBatchDimension() int64 {
	if x != nil {
		return x.OutputBatchDimension
	}
	return 0
}

func (x *ConvolutionDimensionNumbers) GetOutputFeatureDimension() int64 {
	if x != nil {
		return x.OutputFeatureDimension
	}
	return 0
}

func (x *ConvolutionDimensionNumbers) GetOutputSpatialDimensions() []int64 {
	if x != nil {
		return x.OutputSpatialDimensions
	}
	return nil
}

type DotDimensionNumbers struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The dimension numbers that represent the 'lhs' contracting dimensions.
	LhsContractingDimensions []int64 `protobuf:"varint,1,rep,packed,name=lhs_contracting_dimensions,json=lhsContractingDimensions,proto3" json:"lhs_contracting_dimensions,omitempty"`
	// The dimension numbers that represent the 'rhs' contracting dimensions.
	RhsContractingDimensions []int64 `protobuf:"varint,2,rep,packed,name=rhs_contracting_dimensions,json=rhsContractingDimensions,proto3" json:"rhs_contracting_dimensions,omitempty"`
	// The dimension numbers that represent the 'lhs' batch dimensions.
	LhsBatchDimensions []int64 `protobuf:"varint,3,rep,packed,name=lhs_batch_dimensions,json=lhsBatchDimensions,proto3" json:"lhs_batch_dimensions,omitempty"`
	// The dimension numbers that represent the 'rhs' batch dimensions.
	RhsBatchDimensions []int64 `protobuf:"varint,4,rep,packed,name=rhs_batch_dimensions,json=rhsBatchDimensions,proto3" json:"rhs_batch_dimensions,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *DotDimensionNumbers) Reset() {
	*x = DotDimensionNumbers{}
	mi := &file_xla_xla_data_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DotDimensionNumbers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DotDimensionNumbers) ProtoMessage() {}

func (x *DotDimensionNumbers) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DotDimensionNumbers.ProtoReflect.Descriptor instead.
func (*DotDimensionNumbers) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{20}
}

func (x *DotDimensionNumbers) GetLhsContractingDimensions() []int64 {
	if x != nil {
		return x.LhsContractingDimensions
	}
	return nil
}

func (x *DotDimensionNumbers) GetRhsContractingDimensions() []int64 {
	if x != nil {
		return x.RhsContractingDimensions
	}
	return nil
}

func (x *DotDimensionNumbers) GetLhsBatchDimensions() []int64 {
	if x != nil {
		return x.LhsBatchDimensions
	}
	return nil
}

func (x *DotDimensionNumbers) GetRhsBatchDimensions() []int64 {
	if x != nil {
		return x.RhsBatchDimensions
	}
	return nil
}

type RaggedDotDimensionNumbers struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The contracting and batch dimensions of the 'lhs' and 'rhs'.
	DotDimensionNumbers *DotDimensionNumbers `protobuf:"bytes,1,opt,name=dot_dimension_numbers,json=dotDimensionNumbers,proto3" json:"dot_dimension_numbers,omitempty"`
	// The dimension numbers that represent the 'lhs' ragged dimensions.
	LhsRaggedDimensions []int64 `protobuf:"varint,2,rep,packed,name=lhs_ragged_dimensions,json=lhsRaggedDimensions,proto3" json:"lhs_ragged_dimensions,omitempty"`
	// The dimension numbers that represent the 'rhs' group dimensions.
	RhsGroupDimensions []int64 `protobuf:"varint,3,rep,packed,name=rhs_group_dimensions,json=rhsGroupDimensions,proto3" json:"rhs_group_dimensions,omitempty"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *RaggedDotDimensionNumbers) Reset() {
	*x = RaggedDotDimensionNumbers{}
	mi := &file_xla_xla_data_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RaggedDotDimensionNumbers) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RaggedDotDimensionNumbers) ProtoMessage() {}

func (x *RaggedDotDimensionNumbers) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RaggedDotDimensionNumbers.ProtoReflect.Descriptor instead.
func (*RaggedDotDimensionNumbers) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{21}
}

func (x *RaggedDotDimensionNumbers) GetDotDimensionNumbers() *DotDimensionNumbers {
	if x != nil {
		return x.DotDimensionNumbers
	}
	return nil
}

func (x *RaggedDotDimensionNumbers) GetLhsRaggedDimensions() []int64 {
	if x != nil {
		return x.LhsRaggedDimensions
	}
	return nil
}

func (x *RaggedDotDimensionNumbers) GetRhsGroupDimensions() []int64 {
	if x != nil {
		return x.RhsGroupDimensions
	}
	return nil
}

type TriangularSolveOptions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// If true, solves ax = b. If false, solves xa = b.
	LeftSide bool `protobuf:"varint,1,opt,name=left_side,json=leftSide,proto3" json:"left_side,omitempty"`
	// If true, 'a' is lower triangular. If false, 'a' is upper triangular.
	Lower bool `protobuf:"varint,2,opt,name=lower,proto3" json:"lower,omitempty"`
	// If true, the diagonal elements of 'a' are assumed to be 1 and not accessed.
	UnitDiagonal  bool                             `protobuf:"varint,3,opt,name=unit_diagonal,json=unitDiagonal,proto3" json:"unit_diagonal,omitempty"`
	TransposeA    TriangularSolveOptions_Transpose `protobuf:"varint,4,opt,name=transpose_a,json=transposeA,proto3,enum=xla.TriangularSolveOptions_Transpose" json:"transpose_a,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TriangularSolveOptions) Reset() {
	*x = TriangularSolveOptions{}
	mi := &file_xla_xla_data_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TriangularSolveOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TriangularSolveOptions) ProtoMessage() {}

func (x *TriangularSolveOptions) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TriangularSolveOptions.ProtoReflect.Descriptor instead.
func (*TriangularSolveOptions) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{22}
}

func (x *TriangularSolveOptions) GetLeftSide() bool {
	if x != nil {
		return x.LeftSide
	}
	return false
}

func (x *TriangularSolveOptions) GetLower() bool {
	if x != nil {
		return x.Lower
	}
	return false
}

func (x *TriangularSolveOptions) GetUnitDiagonal() bool {
	if x != nil {
		return x.UnitDiagonal
	}
	return false
}

func (x *TriangularSolveOptions) GetTransposeA() TriangularSolveOptions_Transpose {
	if x != nil {
		return x.TransposeA
	}
	return TriangularSolveOptions_TRANSPOSE_INVALID
}

type CholeskyOptions struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// If true, uses the lower triangle of `a`. If false, uses the upper triangle
	// of `a`.
	Lower         bool `protobuf:"varint,1,opt,name=lower,proto3" json:"lower,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CholeskyOptions) Reset() {
	*x = CholeskyOptions{}
	mi := &file_xla_xla_data_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CholeskyOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CholeskyOptions) ProtoMessage() {}

func (x *CholeskyOptions) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CholeskyOptions.ProtoReflect.Descriptor instead.
func (*CholeskyOptions) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{23}
}

func (x *CholeskyOptions) GetLower() bool {
	if x != nil {
		return x.Lower
	}
	return false
}

// Attributes of the sort custom call (cub::DeviceRadixSort).
type SortOptions struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Descending    bool                   `protobuf:"varint,1,opt,name=descending,proto3" json:"descending,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SortOptions) Reset() {
	*x = SortOptions{}
	mi := &file_xla_xla_data_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SortOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SortOptions) ProtoMessage() {}

func (x *SortOptions) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SortOptions.ProtoReflect.Descriptor instead.
func (*SortOptions) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{24}
}

func (x *SortOptions) GetDescending() bool {
	if x != nil {
		return x.Descending
	}
	return false
}

// Generic map of attributes used to pass hints / configuration options from
// the Python frontend to the XLA backend.
type FrontendAttributes struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Map           map[string]string      `protobuf:"bytes,1,rep,name=map,proto3" json:"map,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *FrontendAttributes) Reset() {
	*x = FrontendAttributes{}
	mi := &file_xla_xla_data_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FrontendAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FrontendAttributes) ProtoMessage() {}

func (x *FrontendAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FrontendAttributes.ProtoReflect.Descriptor instead.
func (*FrontendAttributes) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{25}
}

func (x *FrontendAttributes) GetMap() map[string]string {
	if x != nil {
		return x.Map
	}
	return nil
}

// Represents a single statistic to track.
type Statistic struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Must be a single word consisting of any alphanumeric characters
	StatName string `protobuf:"bytes,1,opt,name=stat_name,json=statName,proto3" json:"stat_name,omitempty"`
	// Must be within a range of [0, 100], in order for the graph dumper to
	// properly render the statistic onto the graph.
	StatVal       float64 `protobuf:"fixed64,2,opt,name=stat_val,json=statVal,proto3" json:"stat_val,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Statistic) Reset() {
	*x = Statistic{}
	mi := &file_xla_xla_data_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Statistic) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Statistic) ProtoMessage() {}

func (x *Statistic) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Statistic.ProtoReflect.Descriptor instead.
func (*Statistic) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{26}
}

func (x *Statistic) GetStatName() string {
	if x != nil {
		return x.StatName
	}
	return ""
}

func (x *Statistic) GetStatVal() float64 {
	if x != nil {
		return x.StatVal
	}
	return 0
}

// Represents the information needed to visualize propagation statistics when
// rendering an HLO graph. This includes an array of statistics as well as the
// index of the statistic to render.
type StatisticsViz struct {
	state                protoimpl.MessageState `protogen:"open.v1"`
	StatIndexToVisualize int64                  `protobuf:"varint,1,opt,name=stat_index_to_visualize,json=statIndexToVisualize,proto3" json:"stat_index_to_visualize,omitempty"`
	Statistics           []*Statistic           `protobuf:"bytes,2,rep,name=statistics,proto3" json:"statistics,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *StatisticsViz) Reset() {
	*x = StatisticsViz{}
	mi := &file_xla_xla_data_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StatisticsViz) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatisticsViz) ProtoMessage() {}

func (x *StatisticsViz) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatisticsViz.ProtoReflect.Descriptor instead.
func (*StatisticsViz) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{27}
}

func (x *StatisticsViz) GetStatIndexToVisualize() int64 {
	if x != nil {
		return x.StatIndexToVisualize
	}
	return 0
}

func (x *StatisticsViz) GetStatistics() []*Statistic {
	if x != nil {
		return x.Statistics
	}
	return nil
}

// LINT.IfChange
type OpSharding struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	Type  OpSharding_Type        `protobuf:"varint,1,opt,name=type,proto3,enum=xla.OpSharding_Type" json:"type,omitempty"`
	// The shape of the sharded tile.
	TileShape *ShapeProto `protobuf:"bytes,2,opt,name=tile_shape,json=tileShape,proto3" json:"tile_shape,omitempty"`
	// The shape of the tile assignment tensor - this must be the same rank as
	// tile_shape and the product of its dimensions must equal
	// tile_assignment_devices.size().
	TileAssignmentDimensions []int64 `protobuf:"varint,3,rep,packed,name=tile_assignment_dimensions,json=tileAssignmentDimensions,proto3" json:"tile_assignment_dimensions,omitempty"`
	// Flattened list of device IDs. The order of flattening is the same as used
	// by IndexUtil::MultiToLinearIndex(tile_assignment_shape).
	// Only one of tile_assignment_devices and iota_dimensions shall be non-empty.
	TileAssignmentDevices []int64 `protobuf:"varint,4,rep,packed,name=tile_assignment_devices,json=tileAssignmentDevices,proto3" json:"tile_assignment_devices,omitempty"`
	// If type == TUPLE, the sub-shardings, one per leaf node in the tuple shape,
	// in pre-order. The tuple shape could be nested; here we store just a
	// flattened list of all leaves in the tuple shape. Note that the tuple shape
	// is not stored here; shardings do not store the shapes to which they are
	// applied, this is inferred from the instruction this sharding gets attached
	// to.
	TupleShardings []*OpSharding `protobuf:"bytes,5,rep,name=tuple_shardings,json=tupleShardings,proto3" json:"tuple_shardings,omitempty"`
	// Only used for OTHER type. If true, data is sharded according to other
	// dimensions of tile_assignment(), but replicated across devices along the
	// last dimension. (Experimental)
	ReplicateOnLastTileDim bool `protobuf:"varint,6,opt,name=replicate_on_last_tile_dim,json=replicateOnLastTileDim,proto3" json:"replicate_on_last_tile_dim,omitempty"`
	// This field is used to track the source of this sharding, usually derived
	// from instructions. Multple metadata may be populated if sharding is
	// combined with other shardings.  Metadata are to not be populated when
	// type == TUPLE and instead metadata should be set on individual tuple
	// elements.
	Metadata []*OpMetadata `protobuf:"bytes,7,rep,name=metadata,proto3" json:"metadata,omitempty"`
	// This field is used to represented the sharding type of each subgroup.
	// For example, sharding={devices=[2,2,2,2]0,1,2,...,15 last_tile_dims={
	// replicate, manual, unreduced}} means that each of the last 3 dimensions
	// in [2,2,2,2] represents a subgrouping in replicate, manual,
	// unreduced sharding type respectively.
	LastTileDims []OpSharding_Type `protobuf:"varint,8,rep,packed,name=last_tile_dims,json=lastTileDims,proto3,enum=xla.OpSharding_Type" json:"last_tile_dims,omitempty"`
	// Dimensions used to reshape the 1D iota array of device IDs.
	// Only one of tile_assignment_devices and iota_reshape_dims shall be
	// non-empty.
	IotaReshapeDims []int64 `protobuf:"varint,9,rep,packed,name=iota_reshape_dims,json=iotaReshapeDims,proto3" json:"iota_reshape_dims,omitempty"`
	// Dimension permutations to transposed the iota array reshaped to
	// iota_reshape_dims. This must have the same size as iota_reshape_dims.
	IotaTransposePerm []int32 `protobuf:"varint,10,rep,packed,name=iota_transpose_perm,json=iotaTransposePerm,proto3" json:"iota_transpose_perm,omitempty"`
	// This field decides whether this op is in a shard group.
	IsShardGroup bool `protobuf:"varint,11,opt,name=is_shard_group,json=isShardGroup,proto3" json:"is_shard_group,omitempty"`
	// This field is used to store the unique id of the shard group.
	ShardGroupId   int64                     `protobuf:"varint,12,opt,name=shard_group_id,json=shardGroupId,proto3" json:"shard_group_id,omitempty"`
	ShardGroupType OpSharding_ShardGroupType `protobuf:"varint,13,opt,name=shard_group_type,json=shardGroupType,proto3,enum=xla.OpSharding_ShardGroupType" json:"shard_group_type,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *OpSharding) Reset() {
	*x = OpSharding{}
	mi := &file_xla_xla_data_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpSharding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpSharding) ProtoMessage() {}

func (x *OpSharding) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpSharding.ProtoReflect.Descriptor instead.
func (*OpSharding) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{28}
}

func (x *OpSharding) GetType() OpSharding_Type {
	if x != nil {
		return x.Type
	}
	return OpSharding_REPLICATED
}

func (x *OpSharding) GetTileShape() *ShapeProto {
	if x != nil {
		return x.TileShape
	}
	return nil
}

func (x *OpSharding) GetTileAssignmentDimensions() []int64 {
	if x != nil {
		return x.TileAssignmentDimensions
	}
	return nil
}

func (x *OpSharding) GetTileAssignmentDevices() []int64 {
	if x != nil {
		return x.TileAssignmentDevices
	}
	return nil
}

func (x *OpSharding) GetTupleShardings() []*OpSharding {
	if x != nil {
		return x.TupleShardings
	}
	return nil
}

func (x *OpSharding) GetReplicateOnLastTileDim() bool {
	if x != nil {
		return x.ReplicateOnLastTileDim
	}
	return false
}

func (x *OpSharding) GetMetadata() []*OpMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *OpSharding) GetLastTileDims() []OpSharding_Type {
	if x != nil {
		return x.LastTileDims
	}
	return nil
}

func (x *OpSharding) GetIotaReshapeDims() []int64 {
	if x != nil {
		return x.IotaReshapeDims
	}
	return nil
}

func (x *OpSharding) GetIotaTransposePerm() []int32 {
	if x != nil {
		return x.IotaTransposePerm
	}
	return nil
}

func (x *OpSharding) GetIsShardGroup() bool {
	if x != nil {
		return x.IsShardGroup
	}
	return false
}

func (x *OpSharding) GetShardGroupId() int64 {
	if x != nil {
		return x.ShardGroupId
	}
	return 0
}

func (x *OpSharding) GetShardGroupType() OpSharding_ShardGroupType {
	if x != nil {
		return x.ShardGroupType
	}
	return OpSharding_AS
}

// Describes the replica groups in a cross replica op (e.g., all-reduce and
// all-to-all).
type ReplicaGroup struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The ids of the replicas that belongs to the same group. The ordering of the
	// ids matters in some ops (e.g., all-to-all).
	ReplicaIds    []int64 `protobuf:"varint,1,rep,packed,name=replica_ids,json=replicaIds,proto3" json:"replica_ids,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ReplicaGroup) Reset() {
	*x = ReplicaGroup{}
	mi := &file_xla_xla_data_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplicaGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicaGroup) ProtoMessage() {}

func (x *ReplicaGroup) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicaGroup.ProtoReflect.Descriptor instead.
func (*ReplicaGroup) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{29}
}

func (x *ReplicaGroup) GetReplicaIds() []int64 {
	if x != nil {
		return x.ReplicaIds
	}
	return nil
}

// Represents a list of replica groups (a list of list of devices) with
// reshaping and transposing an iota array (iota tile assignment). Can be used
// to represent certain common patterns of device lists in a compact, scalable
// format.
type IotaReplicaGroupListProto struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Number of replica groups.
	NumReplicaGroups int64 `protobuf:"varint,1,opt,name=num_replica_groups,json=numReplicaGroups,proto3" json:"num_replica_groups,omitempty"`
	// Number of devices per group.
	NumDevicesPerGroup int64 `protobuf:"varint,2,opt,name=num_devices_per_group,json=numDevicesPerGroup,proto3" json:"num_devices_per_group,omitempty"`
	// The dimensions used to reshape the 1D iota array of device IDs.
	IotaReshapeDims []int64 `protobuf:"varint,3,rep,packed,name=iota_reshape_dims,json=iotaReshapeDims,proto3" json:"iota_reshape_dims,omitempty"`
	// The dimension permutations to transposed the iota array reshaped to
	// iota_reshape_dims. This must have the same size as iota_reshape_dims.
	IotaTransposePerm []int32 `protobuf:"varint,4,rep,packed,name=iota_transpose_perm,json=iotaTransposePerm,proto3" json:"iota_transpose_perm,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *IotaReplicaGroupListProto) Reset() {
	*x = IotaReplicaGroupListProto{}
	mi := &file_xla_xla_data_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IotaReplicaGroupListProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IotaReplicaGroupListProto) ProtoMessage() {}

func (x *IotaReplicaGroupListProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IotaReplicaGroupListProto.ProtoReflect.Descriptor instead.
func (*IotaReplicaGroupListProto) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{30}
}

func (x *IotaReplicaGroupListProto) GetNumReplicaGroups() int64 {
	if x != nil {
		return x.NumReplicaGroups
	}
	return 0
}

func (x *IotaReplicaGroupListProto) GetNumDevicesPerGroup() int64 {
	if x != nil {
		return x.NumDevicesPerGroup
	}
	return 0
}

func (x *IotaReplicaGroupListProto) GetIotaReshapeDims() []int64 {
	if x != nil {
		return x.IotaReshapeDims
	}
	return nil
}

func (x *IotaReplicaGroupListProto) GetIotaTransposePerm() []int32 {
	if x != nil {
		return x.IotaTransposePerm
	}
	return nil
}

// Represents a series of devices participating in a collective operation (e.g.,
// all-reduce and all-to-all). While this directly translates to a list of
// replica groups, it may be used to represent these lists in a compact form.
type CollectiveDeviceListProto struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ReplicaGroupV1: List of replica groups. Legacy way of representing device
	// lists.
	ReplicaGroups []*ReplicaGroup `protobuf:"bytes,1,rep,name=replica_groups,json=replicaGroups,proto3" json:"replica_groups,omitempty"`
	// ReplicaGroupV2: Represents a list of replica groups with reshaping and
	// transposing an iota array.
	IotaReplicaGroupList *IotaReplicaGroupListProto `protobuf:"bytes,2,opt,name=iota_replica_group_list,json=iotaReplicaGroupList,proto3" json:"iota_replica_group_list,omitempty"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *CollectiveDeviceListProto) Reset() {
	*x = CollectiveDeviceListProto{}
	mi := &file_xla_xla_data_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CollectiveDeviceListProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CollectiveDeviceListProto) ProtoMessage() {}

func (x *CollectiveDeviceListProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CollectiveDeviceListProto.ProtoReflect.Descriptor instead.
func (*CollectiveDeviceListProto) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{31}
}

func (x *CollectiveDeviceListProto) GetReplicaGroups() []*ReplicaGroup {
	if x != nil {
		return x.ReplicaGroups
	}
	return nil
}

func (x *CollectiveDeviceListProto) GetIotaReplicaGroupList() *IotaReplicaGroupListProto {
	if x != nil {
		return x.IotaReplicaGroupList
	}
	return nil
}

// Describes the source target pair in the collective permute op.
type SourceTarget struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Source        int64                  `protobuf:"varint,1,opt,name=source,proto3" json:"source,omitempty"`
	Target        int64                  `protobuf:"varint,2,opt,name=target,proto3" json:"target,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SourceTarget) Reset() {
	*x = SourceTarget{}
	mi := &file_xla_xla_data_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SourceTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceTarget) ProtoMessage() {}

func (x *SourceTarget) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceTarget.ProtoReflect.Descriptor instead.
func (*SourceTarget) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{32}
}

func (x *SourceTarget) GetSource() int64 {
	if x != nil {
		return x.Source
	}
	return 0
}

func (x *SourceTarget) GetTarget() int64 {
	if x != nil {
		return x.Target
	}
	return 0
}

// Describes the types of accuracy the user can request for unary ops with
// multiple implementations.
type ResultAccuracy struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Specs:
	//
	//	*ResultAccuracy_Mode_
	//	*ResultAccuracy_Tolerance_
	Specs         isResultAccuracy_Specs `protobuf_oneof:"specs"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResultAccuracy) Reset() {
	*x = ResultAccuracy{}
	mi := &file_xla_xla_data_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResultAccuracy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResultAccuracy) ProtoMessage() {}

func (x *ResultAccuracy) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResultAccuracy.ProtoReflect.Descriptor instead.
func (*ResultAccuracy) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{33}
}

func (x *ResultAccuracy) GetSpecs() isResultAccuracy_Specs {
	if x != nil {
		return x.Specs
	}
	return nil
}

func (x *ResultAccuracy) GetMode() ResultAccuracy_Mode {
	if x != nil {
		if x, ok := x.Specs.(*ResultAccuracy_Mode_); ok {
			return x.Mode
		}
	}
	return ResultAccuracy_DEFAULT
}

func (x *ResultAccuracy) GetTolerance() *ResultAccuracy_Tolerance {
	if x != nil {
		if x, ok := x.Specs.(*ResultAccuracy_Tolerance_); ok {
			return x.Tolerance
		}
	}
	return nil
}

type isResultAccuracy_Specs interface {
	isResultAccuracy_Specs()
}

type ResultAccuracy_Mode_ struct {
	// Choose either DEFAULT or HIGHEST precision implementation.
	Mode ResultAccuracy_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=xla.ResultAccuracy_Mode,oneof"`
}

type ResultAccuracy_Tolerance_ struct {
	Tolerance *ResultAccuracy_Tolerance `protobuf:"bytes,2,opt,name=tolerance,proto3,oneof"`
}

func (*ResultAccuracy_Mode_) isResultAccuracy_Specs() {}

func (*ResultAccuracy_Tolerance_) isResultAccuracy_Specs() {}

// Used to indicate the precision configuration. It has backend specific
// meaning.
type PrecisionConfig struct {
	state            protoimpl.MessageState      `protogen:"open.v1"`
	OperandPrecision []PrecisionConfig_Precision `protobuf:"varint,1,rep,packed,name=operand_precision,json=operandPrecision,proto3,enum=xla.PrecisionConfig_Precision" json:"operand_precision,omitempty"`
	// Currently doesn't do anything, but we plan to support it for dot and
	// possibly more instructions.
	//
	// TODO(b/316147294): Support this on GPU and add this to StableHLO as well.
	//
	// If this is set, then `operand_precision` should be set to DEFAULT and it
	// will be ignored.
	Algorithm     PrecisionConfig_Algorithm `protobuf:"varint,2,opt,name=algorithm,proto3,enum=xla.PrecisionConfig_Algorithm" json:"algorithm,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PrecisionConfig) Reset() {
	*x = PrecisionConfig{}
	mi := &file_xla_xla_data_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrecisionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrecisionConfig) ProtoMessage() {}

func (x *PrecisionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrecisionConfig.ProtoReflect.Descriptor instead.
func (*PrecisionConfig) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{34}
}

func (x *PrecisionConfig) GetOperandPrecision() []PrecisionConfig_Precision {
	if x != nil {
		return x.OperandPrecision
	}
	return nil
}

func (x *PrecisionConfig) GetAlgorithm() PrecisionConfig_Algorithm {
	if x != nil {
		return x.Algorithm
	}
	return PrecisionConfig_ALG_UNSET
}

// Describes whether all data-parallelism replicas will receive the same
// parameter data at each buffer.
type ParameterReplication struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// A list of boolean values for the flattened leaf buffers. Each value
	// indicates whether the corresponding leaf buffer is replicated.
	//
	// If this field is empty, it means no buffer is replicated. Otherwise, the
	// number of elements in this field must match the number of leaf buffers in
	// the HLO instruction's shape.
	ReplicatedAtLeafBuffers []bool `protobuf:"varint,1,rep,packed,name=replicated_at_leaf_buffers,json=replicatedAtLeafBuffers,proto3" json:"replicated_at_leaf_buffers,omitempty"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *ParameterReplication) Reset() {
	*x = ParameterReplication{}
	mi := &file_xla_xla_data_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ParameterReplication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ParameterReplication) ProtoMessage() {}

func (x *ParameterReplication) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ParameterReplication.ProtoReflect.Descriptor instead.
func (*ParameterReplication) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{35}
}

func (x *ParameterReplication) GetReplicatedAtLeafBuffers() []bool {
	if x != nil {
		return x.ReplicatedAtLeafBuffers
	}
	return nil
}

// A backend-config for kWhile loops that stores the loop's trip count, if it is
// known.
//
// This is useful for backends that can implement a `for i in 0..N` loop more
// efficiently than a `while` loop.  For example, on GPUs, we can implement a
// `for i in 0..N` loop by enqueueing the kernels for the loop body N times,
// whereas implementing a `while` loop requires a host-device sync on each
// iteration.
type WhileLoopBackendConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// This indirection lets us distinguish between known-trip-count == 0 and
	// unknown-trip-count.
	KnownTripCount *WhileLoopBackendConfig_KnownTripCount `protobuf:"bytes,1,opt,name=known_trip_count,json=knownTripCount,proto3" json:"known_trip_count,omitempty"`
	// Independently from the known trip count, we may also know the start and
	// step of the induction variable.
	KnownInitStep *WhileLoopBackendConfig_KnownInitStep `protobuf:"bytes,2,opt,name=known_init_step,json=knownInitStep,proto3" json:"known_init_step,omitempty"`
	// This lets us distinguish between an unknown induction variable (or none)
	// and tuple index 0.
	KnownInductionVariable *WhileLoopBackendConfig_KnownInductionVariable `protobuf:"bytes,3,opt,name=known_induction_variable,json=knownInductionVariable,proto3" json:"known_induction_variable,omitempty"`
	unknownFields          protoimpl.UnknownFields
	sizeCache              protoimpl.SizeCache
}

func (x *WhileLoopBackendConfig) Reset() {
	*x = WhileLoopBackendConfig{}
	mi := &file_xla_xla_data_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WhileLoopBackendConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WhileLoopBackendConfig) ProtoMessage() {}

func (x *WhileLoopBackendConfig) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WhileLoopBackendConfig.ProtoReflect.Descriptor instead.
func (*WhileLoopBackendConfig) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{36}
}

func (x *WhileLoopBackendConfig) GetKnownTripCount() *WhileLoopBackendConfig_KnownTripCount {
	if x != nil {
		return x.KnownTripCount
	}
	return nil
}

func (x *WhileLoopBackendConfig) GetKnownInitStep() *WhileLoopBackendConfig_KnownInitStep {
	if x != nil {
		return x.KnownInitStep
	}
	return nil
}

func (x *WhileLoopBackendConfig) GetKnownInductionVariable() *WhileLoopBackendConfig_KnownInductionVariable {
	if x != nil {
		return x.KnownInductionVariable
	}
	return nil
}

// Specifies a pair of output/operand buffers that alias each other for
// kCustomCall and kFusion
type OutputOperandAliasing struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	OutputShapeIndex  []int64                `protobuf:"varint,1,rep,packed,name=output_shape_index,json=outputShapeIndex,proto3" json:"output_shape_index,omitempty"`
	OperandIndex      int64                  `protobuf:"varint,2,opt,name=operand_index,json=operandIndex,proto3" json:"operand_index,omitempty"`
	OperandShapeIndex []int64                `protobuf:"varint,3,rep,packed,name=operand_shape_index,json=operandShapeIndex,proto3" json:"operand_shape_index,omitempty"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *OutputOperandAliasing) Reset() {
	*x = OutputOperandAliasing{}
	mi := &file_xla_xla_data_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OutputOperandAliasing) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputOperandAliasing) ProtoMessage() {}

func (x *OutputOperandAliasing) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputOperandAliasing.ProtoReflect.Descriptor instead.
func (*OutputOperandAliasing) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{37}
}

func (x *OutputOperandAliasing) GetOutputShapeIndex() []int64 {
	if x != nil {
		return x.OutputShapeIndex
	}
	return nil
}

func (x *OutputOperandAliasing) GetOperandIndex() int64 {
	if x != nil {
		return x.OperandIndex
	}
	return 0
}

func (x *OutputOperandAliasing) GetOperandShapeIndex() []int64 {
	if x != nil {
		return x.OperandShapeIndex
	}
	return nil
}

type OriginalArrayProto struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	InstructionName string                 `protobuf:"bytes,1,opt,name=instruction_name,json=instructionName,proto3" json:"instruction_name,omitempty"`
	ShapeIndex      []int64                `protobuf:"varint,2,rep,packed,name=shape_index,json=shapeIndex,proto3" json:"shape_index,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *OriginalArrayProto) Reset() {
	*x = OriginalArrayProto{}
	mi := &file_xla_xla_data_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OriginalArrayProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OriginalArrayProto) ProtoMessage() {}

func (x *OriginalArrayProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OriginalArrayProto.ProtoReflect.Descriptor instead.
func (*OriginalArrayProto) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{38}
}

func (x *OriginalArrayProto) GetInstructionName() string {
	if x != nil {
		return x.InstructionName
	}
	return ""
}

func (x *OriginalArrayProto) GetShapeIndex() []int64 {
	if x != nil {
		return x.ShapeIndex
	}
	return nil
}

type OriginalValueElementProto struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ShapeIndex    []int64                `protobuf:"varint,1,rep,packed,name=shape_index,json=shapeIndex,proto3" json:"shape_index,omitempty"`
	OriginalArray *OriginalArrayProto    `protobuf:"bytes,2,opt,name=original_array,json=originalArray,proto3" json:"original_array,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OriginalValueElementProto) Reset() {
	*x = OriginalValueElementProto{}
	mi := &file_xla_xla_data_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OriginalValueElementProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OriginalValueElementProto) ProtoMessage() {}

func (x *OriginalValueElementProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OriginalValueElementProto.ProtoReflect.Descriptor instead.
func (*OriginalValueElementProto) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{39}
}

func (x *OriginalValueElementProto) GetShapeIndex() []int64 {
	if x != nil {
		return x.ShapeIndex
	}
	return nil
}

func (x *OriginalValueElementProto) GetOriginalArray() *OriginalArrayProto {
	if x != nil {
		return x.OriginalArray
	}
	return nil
}

type OriginalValueProto struct {
	state    protoimpl.MessageState       `protogen:"open.v1"`
	Elements []*OriginalValueElementProto `protobuf:"bytes,1,rep,name=elements,proto3" json:"elements,omitempty"`
	// If true, the annotated instruction is a synthetic call and elements should
	// be ignored.
	IsSyntheticCall bool `protobuf:"varint,2,opt,name=is_synthetic_call,json=isSyntheticCall,proto3" json:"is_synthetic_call,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *OriginalValueProto) Reset() {
	*x = OriginalValueProto{}
	mi := &file_xla_xla_data_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OriginalValueProto) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OriginalValueProto) ProtoMessage() {}

func (x *OriginalValueProto) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OriginalValueProto.ProtoReflect.Descriptor instead.
func (*OriginalValueProto) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{40}
}

func (x *OriginalValueProto) GetElements() []*OriginalValueElementProto {
	if x != nil {
		return x.Elements
	}
	return nil
}

func (x *OriginalValueProto) GetIsSyntheticCall() bool {
	if x != nil {
		return x.IsSyntheticCall
	}
	return false
}

type GemmPerfTableEntry struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	B     int64                  `protobuf:"varint,1,opt,name=b,proto3" json:"b,omitempty"`
	M     int64                  `protobuf:"varint,2,opt,name=m,proto3" json:"m,omitempty"`
	N     int64                  `protobuf:"varint,3,opt,name=n,proto3" json:"n,omitempty"`
	K     int64                  `protobuf:"varint,4,opt,name=k,proto3" json:"k,omitempty"`
	// We chose compact string representation to save on textproto size.
	// {lhs}x{rhs}x{acc}=>{peak_flops} (eg: key='bf16xbf16->bf16', val='12345')
	Flops         map[string]int64 `protobuf:"bytes,5,rep,name=flops,proto3" json:"flops,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GemmPerfTableEntry) Reset() {
	*x = GemmPerfTableEntry{}
	mi := &file_xla_xla_data_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GemmPerfTableEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GemmPerfTableEntry) ProtoMessage() {}

func (x *GemmPerfTableEntry) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GemmPerfTableEntry.ProtoReflect.Descriptor instead.
func (*GemmPerfTableEntry) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{41}
}

func (x *GemmPerfTableEntry) GetB() int64 {
	if x != nil {
		return x.B
	}
	return 0
}

func (x *GemmPerfTableEntry) GetM() int64 {
	if x != nil {
		return x.M
	}
	return 0
}

func (x *GemmPerfTableEntry) GetN() int64 {
	if x != nil {
		return x.N
	}
	return 0
}

func (x *GemmPerfTableEntry) GetK() int64 {
	if x != nil {
		return x.K
	}
	return 0
}

func (x *GemmPerfTableEntry) GetFlops() map[string]int64 {
	if x != nil {
		return x.Flops
	}
	return nil
}

type GemmPerfTableEntryValues struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Entries       []*GemmPerfTableEntry  `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GemmPerfTableEntryValues) Reset() {
	*x = GemmPerfTableEntryValues{}
	mi := &file_xla_xla_data_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GemmPerfTableEntryValues) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GemmPerfTableEntryValues) ProtoMessage() {}

func (x *GemmPerfTableEntryValues) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GemmPerfTableEntryValues.ProtoReflect.Descriptor instead.
func (*GemmPerfTableEntryValues) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{42}
}

func (x *GemmPerfTableEntryValues) GetEntries() []*GemmPerfTableEntry {
	if x != nil {
		return x.Entries
	}
	return nil
}

type GemmPerfTable struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// sm86 -> entry content.
	Entries       map[string]*GemmPerfTableEntryValues `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GemmPerfTable) Reset() {
	*x = GemmPerfTable{}
	mi := &file_xla_xla_data_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GemmPerfTable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GemmPerfTable) ProtoMessage() {}

func (x *GemmPerfTable) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GemmPerfTable.ProtoReflect.Descriptor instead.
func (*GemmPerfTable) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{43}
}

func (x *GemmPerfTable) GetEntries() map[string]*GemmPerfTableEntryValues {
	if x != nil {
		return x.Entries
	}
	return nil
}

// Describes the padding configuration for a dimension.
type PaddingConfig_PaddingConfigDimension struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Padding amount on the low-end (next to the index 0). May be negative.
	EdgePaddingLow int64 `protobuf:"varint,1,opt,name=edge_padding_low,json=edgePaddingLow,proto3" json:"edge_padding_low,omitempty"`
	// Padding amount on the high-end (next to the highest index). May be
	// negative.
	EdgePaddingHigh int64 `protobuf:"varint,2,opt,name=edge_padding_high,json=edgePaddingHigh,proto3" json:"edge_padding_high,omitempty"`
	// Padding amount between the elements. May not be negative.
	InteriorPadding int64 `protobuf:"varint,3,opt,name=interior_padding,json=interiorPadding,proto3" json:"interior_padding,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *PaddingConfig_PaddingConfigDimension) Reset() {
	*x = PaddingConfig_PaddingConfigDimension{}
	mi := &file_xla_xla_data_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PaddingConfig_PaddingConfigDimension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PaddingConfig_PaddingConfigDimension) ProtoMessage() {}

func (x *PaddingConfig_PaddingConfigDimension) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PaddingConfig_PaddingConfigDimension.ProtoReflect.Descriptor instead.
func (*PaddingConfig_PaddingConfigDimension) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{0, 0}
}

func (x *PaddingConfig_PaddingConfigDimension) GetEdgePaddingLow() int64 {
	if x != nil {
		return x.EdgePaddingLow
	}
	return 0
}

func (x *PaddingConfig_PaddingConfigDimension) GetEdgePaddingHigh() int64 {
	if x != nil {
		return x.EdgePaddingHigh
	}
	return 0
}

func (x *PaddingConfig_PaddingConfigDimension) GetInteriorPadding() int64 {
	if x != nil {
		return x.InteriorPadding
	}
	return 0
}

// Information about the optimization profile that this operation contains.
type OpMetadata_ProfileInfo struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The type of optimization profiles that this operation contains.
	ProfileType []ProfileType `protobuf:"varint,1,rep,packed,name=profile_type,json=profileType,proto3,enum=xla.ProfileType" json:"profile_type,omitempty"`
	// Speedup of tuned config compared to default config.
	// TODO(b/203817882) Set the relative_speedup.
	RelativeSpeedup float64 `protobuf:"fixed64,2,opt,name=relative_speedup,json=relativeSpeedup,proto3" json:"relative_speedup,omitempty"`
	// The source of the optimization profiles that this operation contains.
	ProfileSource ProfileSource `protobuf:"varint,3,opt,name=profile_source,json=profileSource,proto3,enum=xla.ProfileSource" json:"profile_source,omitempty"`
	// The compilation event that triggered the use of the profiles.
	CompilationEvent CompilationEvent `protobuf:"varint,4,opt,name=compilation_event,json=compilationEvent,proto3,enum=xla.CompilationEvent" json:"compilation_event,omitempty"`
	// The type of profile generation strategy used to generate the profile.
	ProfileGenerationStrategy ProfileGenerationStrategy `protobuf:"varint,5,opt,name=profile_generation_strategy,json=profileGenerationStrategy,proto3,enum=xla.ProfileGenerationStrategy" json:"profile_generation_strategy,omitempty"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *OpMetadata_ProfileInfo) Reset() {
	*x = OpMetadata_ProfileInfo{}
	mi := &file_xla_xla_data_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OpMetadata_ProfileInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OpMetadata_ProfileInfo) ProtoMessage() {}

func (x *OpMetadata_ProfileInfo) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OpMetadata_ProfileInfo.ProtoReflect.Descriptor instead.
func (*OpMetadata_ProfileInfo) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{7, 0}
}

func (x *OpMetadata_ProfileInfo) GetProfileType() []ProfileType {
	if x != nil {
		return x.ProfileType
	}
	return nil
}

func (x *OpMetadata_ProfileInfo) GetRelativeSpeedup() float64 {
	if x != nil {
		return x.RelativeSpeedup
	}
	return 0
}

func (x *OpMetadata_ProfileInfo) GetProfileSource() ProfileSource {
	if x != nil {
		return x.ProfileSource
	}
	return ProfileSource_PROFILE_SOURCE_UNKNOWN_SOURCE
}

func (x *OpMetadata_ProfileInfo) GetCompilationEvent() CompilationEvent {
	if x != nil {
		return x.CompilationEvent
	}
	return CompilationEvent_COMPILATION_EVENT_UNKNOWN_EVENT
}

func (x *OpMetadata_ProfileInfo) GetProfileGenerationStrategy() ProfileGenerationStrategy {
	if x != nil {
		return x.ProfileGenerationStrategy
	}
	return ProfileGenerationStrategy_PROFILE_GENERATION_STRATEGY_UNKNOWN
}

// Each logical computation runs on replica_count physical devices.
// ComputationDevice represents the device ids assinged to the replicas.
type DeviceAssignmentProto_ComputationDevice struct {
	state            protoimpl.MessageState `protogen:"open.v1"`
	ReplicaDeviceIds []int64                `protobuf:"varint,1,rep,packed,name=replica_device_ids,json=replicaDeviceIds,proto3" json:"replica_device_ids,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *DeviceAssignmentProto_ComputationDevice) Reset() {
	*x = DeviceAssignmentProto_ComputationDevice{}
	mi := &file_xla_xla_data_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeviceAssignmentProto_ComputationDevice) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceAssignmentProto_ComputationDevice) ProtoMessage() {}

func (x *DeviceAssignmentProto_ComputationDevice) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceAssignmentProto_ComputationDevice.ProtoReflect.Descriptor instead.
func (*DeviceAssignmentProto_ComputationDevice) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{13, 0}
}

func (x *DeviceAssignmentProto_ComputationDevice) GetReplicaDeviceIds() []int64 {
	if x != nil {
		return x.ReplicaDeviceIds
	}
	return nil
}

type ResultAccuracy_Tolerance struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Absolute error tolerance for unary instructions.
	Atol float64 `protobuf:"fixed64,1,opt,name=atol,proto3" json:"atol,omitempty"`
	// Relative error tolerance for unary instructions.
	Rtol float64 `protobuf:"fixed64,2,opt,name=rtol,proto3" json:"rtol,omitempty"`
	// The error in ulps (units in the last place) is relative to machine
	// precision.
	Ulps          int64 `protobuf:"varint,3,opt,name=ulps,proto3" json:"ulps,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ResultAccuracy_Tolerance) Reset() {
	*x = ResultAccuracy_Tolerance{}
	mi := &file_xla_xla_data_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResultAccuracy_Tolerance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResultAccuracy_Tolerance) ProtoMessage() {}

func (x *ResultAccuracy_Tolerance) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResultAccuracy_Tolerance.ProtoReflect.Descriptor instead.
func (*ResultAccuracy_Tolerance) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{33, 0}
}

func (x *ResultAccuracy_Tolerance) GetAtol() float64 {
	if x != nil {
		return x.Atol
	}
	return 0
}

func (x *ResultAccuracy_Tolerance) GetRtol() float64 {
	if x != nil {
		return x.Rtol
	}
	return 0
}

func (x *ResultAccuracy_Tolerance) GetUlps() int64 {
	if x != nil {
		return x.Ulps
	}
	return 0
}

type WhileLoopBackendConfig_KnownInitStep struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Init          int64                  `protobuf:"varint,1,opt,name=init,proto3" json:"init,omitempty"`
	Step          int64                  `protobuf:"varint,2,opt,name=step,proto3" json:"step,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WhileLoopBackendConfig_KnownInitStep) Reset() {
	*x = WhileLoopBackendConfig_KnownInitStep{}
	mi := &file_xla_xla_data_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WhileLoopBackendConfig_KnownInitStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WhileLoopBackendConfig_KnownInitStep) ProtoMessage() {}

func (x *WhileLoopBackendConfig_KnownInitStep) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WhileLoopBackendConfig_KnownInitStep.ProtoReflect.Descriptor instead.
func (*WhileLoopBackendConfig_KnownInitStep) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{36, 0}
}

func (x *WhileLoopBackendConfig_KnownInitStep) GetInit() int64 {
	if x != nil {
		return x.Init
	}
	return 0
}

func (x *WhileLoopBackendConfig_KnownInitStep) GetStep() int64 {
	if x != nil {
		return x.Step
	}
	return 0
}

type WhileLoopBackendConfig_KnownTripCount struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	N             int64                  `protobuf:"varint,1,opt,name=n,proto3" json:"n,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WhileLoopBackendConfig_KnownTripCount) Reset() {
	*x = WhileLoopBackendConfig_KnownTripCount{}
	mi := &file_xla_xla_data_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WhileLoopBackendConfig_KnownTripCount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WhileLoopBackendConfig_KnownTripCount) ProtoMessage() {}

func (x *WhileLoopBackendConfig_KnownTripCount) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WhileLoopBackendConfig_KnownTripCount.ProtoReflect.Descriptor instead.
func (*WhileLoopBackendConfig_KnownTripCount) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{36, 1}
}

func (x *WhileLoopBackendConfig_KnownTripCount) GetN() int64 {
	if x != nil {
		return x.N
	}
	return 0
}

type WhileLoopBackendConfig_KnownInductionVariable struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	TupleIndex    int64                  `protobuf:"varint,1,opt,name=tuple_index,json=tupleIndex,proto3" json:"tuple_index,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WhileLoopBackendConfig_KnownInductionVariable) Reset() {
	*x = WhileLoopBackendConfig_KnownInductionVariable{}
	mi := &file_xla_xla_data_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WhileLoopBackendConfig_KnownInductionVariable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WhileLoopBackendConfig_KnownInductionVariable) ProtoMessage() {}

func (x *WhileLoopBackendConfig_KnownInductionVariable) ProtoReflect() protoreflect.Message {
	mi := &file_xla_xla_data_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WhileLoopBackendConfig_KnownInductionVariable.ProtoReflect.Descriptor instead.
func (*WhileLoopBackendConfig_KnownInductionVariable) Descriptor() ([]byte, []int) {
	return file_xla_xla_data_proto_rawDescGZIP(), []int{36, 2}
}

func (x *WhileLoopBackendConfig_KnownInductionVariable) GetTupleIndex() int64 {
	if x != nil {
		return x.TupleIndex
	}
	return 0
}

var File_xla_xla_data_proto protoreflect.FileDescriptor

var file_xla_xla_data_proto_rawDesc = string([]byte{
	0x0a, 0x12, 0x78, 0x6c, 0x61, 0x2f, 0x78, 0x6c, 0x61, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x03, 0x78, 0x6c, 0x61, 0x22, 0xf6, 0x01, 0x0a, 0x0d, 0x50, 0x61,
	0x64, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x49, 0x0a, 0x0a, 0x64,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x50, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x50, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x64, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x99, 0x01, 0x0a, 0x16, 0x50, 0x61, 0x64, 0x64, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x28, 0x0a, 0x10, 0x65, 0x64, 0x67, 0x65, 0x5f, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e,
	0x67, 0x5f, 0x6c, 0x6f, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x65, 0x64, 0x67,
	0x65, 0x50, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x4c, 0x6f, 0x77, 0x12, 0x2a, 0x0a, 0x11, 0x65,
	0x64, 0x67, 0x65, 0x5f, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x68, 0x69, 0x67, 0x68,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x65, 0x64, 0x67, 0x65, 0x50, 0x61, 0x64, 0x64,
	0x69, 0x6e, 0x67, 0x48, 0x69, 0x67, 0x68, 0x12, 0x29, 0x0a, 0x10, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x69, 0x6f, 0x72, 0x5f, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x72, 0x50, 0x61, 0x64, 0x64, 0x69,
	0x6e, 0x67, 0x22, 0x2b, 0x0a, 0x09, 0x54, 0x69, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1e, 0x0a, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x03, 0x52, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22,
	0x55, 0x0a, 0x10, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x1c, 0x0a, 0x09, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x69, 0x63,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x03, 0x52, 0x0c, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x49,
	0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x22, 0x9d, 0x06, 0x0a, 0x0b, 0x4c, 0x61, 0x79, 0x6f, 0x75,
	0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x24, 0x0a, 0x0e, 0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x5f,
	0x74, 0x6f, 0x5f, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x03, 0x28, 0x03, 0x52, 0x0c,
	0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x54, 0x6f, 0x4d, 0x61, 0x6a, 0x6f, 0x72, 0x12, 0x39, 0x0a, 0x0f,
	0x64, 0x69, 0x6d, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18,
	0x09, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x11, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x44, 0x69, 0x6d, 0x4c,
	0x65, 0x76, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0d, 0x64, 0x69, 0x6d, 0x4c, 0x65, 0x76,
	0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x69, 0x6d, 0x5f, 0x75,
	0x6e, 0x69, 0x71, 0x75, 0x65, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x08, 0x52, 0x09, 0x64, 0x69, 0x6d,
	0x55, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x69, 0x6d, 0x5f, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x65, 0x64, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x08, 0x52, 0x0a, 0x64, 0x69, 0x6d,
	0x4f, 0x72, 0x64, 0x65, 0x72, 0x65, 0x64, 0x12, 0x24, 0x0a, 0x05, 0x74, 0x69, 0x6c, 0x65, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x54, 0x69, 0x6c,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x05, 0x74, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x4a, 0x0a,
	0x22, 0x74, 0x61, 0x69, 0x6c, 0x5f, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x6c,
	0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x5f, 0x65, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1e, 0x74, 0x61, 0x69, 0x6c, 0x50,
	0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x41, 0x6c, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x49,
	0x6e, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x2f, 0x0a, 0x14, 0x65, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x69, 0x6e, 0x5f, 0x62, 0x69, 0x74,
	0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x53, 0x69, 0x7a, 0x65, 0x49, 0x6e, 0x42, 0x69, 0x74, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0b, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x53, 0x70, 0x61, 0x63, 0x65, 0x12, 0x44, 0x0a,
	0x14, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x70, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e, 0x78, 0x6c,
	0x61, 0x2e, 0x50, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x12, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x50, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x48, 0x0a, 0x16, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x70,
	0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x50, 0x72, 0x69, 0x6d, 0x69, 0x74,
	0x69, 0x76, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x14, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x50, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x36, 0x0a,
	0x0e, 0x70, 0x68, 0x79, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x73, 0x68, 0x61, 0x70, 0x65, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x53, 0x68, 0x61, 0x70,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0d, 0x70, 0x68, 0x79, 0x73, 0x69, 0x63, 0x61, 0x6c,
	0x53, 0x68, 0x61, 0x70, 0x65, 0x12, 0x4c, 0x0a, 0x23, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63,
	0x5f, 0x73, 0x68, 0x61, 0x70, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x1f, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x53, 0x68, 0x61, 0x70, 0x65,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x42, 0x79,
	0x74, 0x65, 0x73, 0x12, 0x3a, 0x0a, 0x0d, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x78, 0x6c, 0x61,
	0x2e, 0x53, 0x70, 0x6c, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x52, 0x0c, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x4a,
	0x04, 0x08, 0x02, 0x10, 0x03, 0x4a, 0x04, 0x08, 0x03, 0x10, 0x04, 0x4a, 0x04, 0x08, 0x04, 0x10,
	0x05, 0x4a, 0x04, 0x08, 0x05, 0x10, 0x06, 0x52, 0x11, 0x70, 0x61, 0x64, 0x64, 0x65, 0x64, 0x5f,
	0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0d, 0x70, 0x61, 0x64, 0x64,
	0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x52, 0x13, 0x6d, 0x61, 0x78, 0x5f, 0x73, 0x70, 0x61, 0x72, 0x73, 0x65, 0x5f, 0x65, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22, 0xff, 0x01, 0x0a, 0x0a, 0x53, 0x68, 0x61, 0x70, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x35, 0x0a, 0x0c, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e, 0x78, 0x6c,
	0x61, 0x2e, 0x50, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0b, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x0a,
	0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x03,
	0x52, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x30, 0x0a, 0x14,
	0x69, 0x73, 0x5f, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x03, 0x28, 0x08, 0x52, 0x12, 0x69, 0x73, 0x44, 0x79,
	0x6e, 0x61, 0x6d, 0x69, 0x63, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x32,
	0x0a, 0x0c, 0x74, 0x75, 0x70, 0x6c, 0x65, 0x5f, 0x73, 0x68, 0x61, 0x70, 0x65, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x53, 0x68, 0x61, 0x70, 0x65,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x0b, 0x74, 0x75, 0x70, 0x6c, 0x65, 0x53, 0x68, 0x61, 0x70,
	0x65, 0x73, 0x12, 0x28, 0x0a, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x10, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x52, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x4a, 0x04, 0x08, 0x01,
	0x10, 0x02, 0x52, 0x04, 0x72, 0x61, 0x6e, 0x6b, 0x22, 0x96, 0x01, 0x0a, 0x11, 0x50, 0x72, 0x6f,
	0x67, 0x72, 0x61, 0x6d, 0x53, 0x68, 0x61, 0x70, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2f,
	0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x53, 0x68, 0x61, 0x70, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12,
	0x27, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x0f, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x53, 0x68, 0x61, 0x70, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0e, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65,
	0x73, 0x22, 0x64, 0x0a, 0x10, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x6c, 0x6f, 0x70, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x09, 0x66, 0x6c, 0x6f, 0x70, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x31, 0x0a, 0x14, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x65, 0x6e,
	0x64, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x13, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x74,
	0x61, 0x6c, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x98, 0x08, 0x0a, 0x0a, 0x4f, 0x70, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x17, 0x0a, 0x07, 0x6f, 0x70, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6f, 0x70, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x17, 0x0a, 0x07, 0x6f, 0x70, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x6f, 0x70, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x11, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x6e, 0x64, 0x4c, 0x69,
	0x6e, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x18, 0x12, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x12, 0x2a, 0x0a, 0x11, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x18, 0x13, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x0f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x6e, 0x64, 0x43, 0x6f, 0x6c,
	0x75, 0x6d, 0x6e, 0x12, 0x37, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x78, 0x6c, 0x61, 0x2e,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x02, 0x18, 0x01, 0x52,
	0x0b, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x43, 0x0a, 0x1f,
	0x73, 0x69, 0x7a, 0x65, 0x5f, 0x6f, 0x66, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x69, 0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1a, 0x73, 0x69, 0x7a, 0x65, 0x4f, 0x66, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x43, 0x6f, 0x64, 0x65, 0x49, 0x6e, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x12, 0x4a, 0x0a, 0x23, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x6f, 0x66, 0x5f, 0x6d, 0x65, 0x6d,
	0x6f, 0x72, 0x79, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x65, 0x74, 0x5f,
	0x69, 0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1d,
	0x73, 0x69, 0x7a, 0x65, 0x4f, 0x66, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x57, 0x6f, 0x72, 0x6b,
	0x69, 0x6e, 0x67, 0x53, 0x65, 0x74, 0x49, 0x6e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x3e, 0x0a,
	0x0c, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x4f, 0x70, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x0b, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2b, 0x0a,
	0x11, 0x64, 0x65, 0x64, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x64, 0x65, 0x64, 0x75, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x73, 0x74,
	0x61, 0x63, 0x6b, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x49, 0x64,
	0x12, 0x27, 0x0a, 0x0f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x69, 0x6e, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0xcc, 0x02, 0x0a, 0x0b, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x33, 0x0a, 0x0c, 0x70, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32,
	0x10, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x29,
	0x0a, 0x10, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x65, 0x64,
	0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0f, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x53, 0x70, 0x65, 0x65, 0x64, 0x75, 0x70, 0x12, 0x39, 0x0a, 0x0e, 0x70, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x12, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x42, 0x0a, 0x11, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x15, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x5e, 0x0a, 0x1b, 0x70, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e,
	0x78, 0x6c, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x52, 0x19, 0x70,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x4a, 0x04, 0x08, 0x06, 0x10, 0x07, 0x4a, 0x04,
	0x08, 0x07, 0x10, 0x08, 0x4a, 0x04, 0x08, 0x0b, 0x10, 0x0c, 0x4a, 0x04, 0x08, 0x0d, 0x10, 0x0e,
	0x4a, 0x04, 0x08, 0x0e, 0x10, 0x0f, 0x52, 0x10, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x70, 0x61, 0x73, 0x73, 0x5f, 0x69, 0x64, 0x52, 0x18, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61,
	0x6c, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x5f,
	0x69, 0x64, 0x22, 0x9b, 0x03, 0x0a, 0x10, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x32, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x70, 0x69,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x68, 0x69, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x61, 0x63, 0x68, 0x65, 0x48, 0x69, 0x74, 0x12, 0x26, 0x0a, 0x0f, 0x63,
	0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6d, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x4d, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x63,
	0x79, 0x63, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x11, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x26, 0x0a, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x63, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x4e, 0x73, 0x12, 0x3e, 0x0a, 0x1c, 0x63,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x61, 0x6e, 0x64, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x18, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x41, 0x6e, 0x64, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x54, 0x69, 0x6d, 0x65, 0x4e, 0x73, 0x12, 0x37, 0x0a, 0x18, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x69,
	0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x49, 0x6e, 0x42,
	0x79, 0x74, 0x65, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x63, 0x61, 0x63, 0x68, 0x65, 0x5f, 0x68, 0x69, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x43, 0x61, 0x63, 0x68, 0x65, 0x48, 0x69, 0x74,
	0x12, 0x2e, 0x0a, 0x13, 0x77, 0x61, 0x72, 0x6d, 0x75, 0x70, 0x5f, 0x72, 0x75, 0x6e, 0x5f, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x77,
	0x61, 0x72, 0x6d, 0x75, 0x70, 0x52, 0x75, 0x6e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x64,
	0x22, 0x29, 0x0a, 0x0f, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x61, 0x6e,
	0x64, 0x6c, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x06, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x22, 0x2a, 0x0a, 0x10, 0x47,
	0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12,
	0x16, 0x0a, 0x06, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x06, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x22, 0x49, 0x0a, 0x0c, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x61, 0x6e, 0x64, 0x6c,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12,
	0x21, 0x0a, 0x0c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x22, 0xc2, 0x01, 0x0a, 0x0d, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x48, 0x61,
	0x6e, 0x64, 0x6c, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x32, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x78, 0x6c, 0x61,
	0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x2e, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x22, 0x65, 0x0a, 0x0b, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x18, 0x0a, 0x14, 0x43, 0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x44, 0x45, 0x56,
	0x49, 0x43, 0x45, 0x5f, 0x54, 0x4f, 0x5f, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x10, 0x01, 0x12,
	0x12, 0x0a, 0x0e, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x54, 0x4f, 0x5f, 0x48, 0x4f, 0x53,
	0x54, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x48, 0x4f, 0x53, 0x54, 0x5f, 0x54, 0x4f, 0x5f, 0x44,
	0x45, 0x56, 0x49, 0x43, 0x45, 0x10, 0x03, 0x22, 0x8b, 0x02, 0x0a, 0x15, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x11, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x5d, 0x0a, 0x13, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x73, 0x73,
	0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x2e, 0x43, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x12,
	0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x1a, 0x41, 0x0a, 0x11, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x72, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x03, 0x52, 0x10, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x49, 0x64, 0x73, 0x22, 0xc6, 0x06, 0x0a, 0x0c, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61,
	0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x25, 0x0a, 0x05, 0x73, 0x68, 0x61, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x53, 0x68, 0x61, 0x70,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x05, 0x73, 0x68, 0x61, 0x70, 0x65, 0x12, 0x14, 0x0a,
	0x05, 0x70, 0x72, 0x65, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x08, 0x52, 0x05, 0x70, 0x72,
	0x65, 0x64, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x31, 0x73, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x03, 0x73, 0x31, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x32, 0x73, 0x18, 0x1a, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x03, 0x73, 0x32, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x34, 0x73, 0x18, 0x15,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x73, 0x34, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x38, 0x73,
	0x18, 0x0f, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x73, 0x38, 0x73, 0x12, 0x10, 0x0a, 0x03, 0x75,
	0x31, 0x73, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x75, 0x31, 0x73, 0x12, 0x10, 0x0a,
	0x03, 0x75, 0x32, 0x73, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x75, 0x32, 0x73, 0x12,
	0x10, 0x0a, 0x03, 0x75, 0x34, 0x73, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x75, 0x34,
	0x73, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x38, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03,
	0x75, 0x38, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x33, 0x32, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x05, 0x52, 0x04, 0x73, 0x33, 0x32, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x36, 0x34, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x03, 0x52, 0x04, 0x73, 0x36, 0x34, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x75,
	0x33, 0x32, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0d, 0x52, 0x04, 0x75, 0x33, 0x32, 0x73, 0x12,
	0x12, 0x0a, 0x04, 0x75, 0x36, 0x34, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x04, 0x52, 0x04, 0x75,
	0x36, 0x34, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x33, 0x32, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28,
	0x02, 0x52, 0x04, 0x66, 0x33, 0x32, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x36, 0x34, 0x73, 0x18,
	0x09, 0x20, 0x03, 0x28, 0x01, 0x52, 0x04, 0x66, 0x36, 0x34, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x63,
	0x36, 0x34, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x02, 0x52, 0x04, 0x63, 0x36, 0x34, 0x73, 0x12,
	0x14, 0x0a, 0x05, 0x63, 0x31, 0x32, 0x38, 0x73, 0x18, 0x12, 0x20, 0x03, 0x28, 0x01, 0x52, 0x05,
	0x63, 0x31, 0x32, 0x38, 0x73, 0x12, 0x38, 0x0a, 0x0e, 0x74, 0x75, 0x70, 0x6c, 0x65, 0x5f, 0x6c,
	0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e,
	0x78, 0x6c, 0x61, 0x2e, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x52, 0x0d, 0x74, 0x75, 0x70, 0x6c, 0x65, 0x4c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x73, 0x12,
	0x12, 0x0a, 0x04, 0x66, 0x31, 0x36, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x66,
	0x31, 0x36, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x62, 0x66, 0x31, 0x36, 0x73, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x05, 0x62, 0x66, 0x31, 0x36, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x31, 0x36,
	0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x75, 0x31, 0x36, 0x73, 0x12, 0x12, 0x0a,
	0x04, 0x73, 0x31, 0x36, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x73, 0x31, 0x36,
	0x73, 0x12, 0x1c, 0x0a, 0x09, 0x66, 0x34, 0x65, 0x32, 0x6d, 0x31, 0x66, 0x6e, 0x73, 0x18, 0x20,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x66, 0x34, 0x65, 0x32, 0x6d, 0x31, 0x66, 0x6e, 0x73, 0x12,
	0x18, 0x0a, 0x07, 0x66, 0x38, 0x65, 0x33, 0x6d, 0x34, 0x73, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x07, 0x66, 0x38, 0x65, 0x33, 0x6d, 0x34, 0x73, 0x12, 0x26, 0x0a, 0x0e, 0x66, 0x38, 0x65,
	0x34, 0x6d, 0x33, 0x62, 0x31, 0x31, 0x66, 0x6e, 0x75, 0x7a, 0x73, 0x18, 0x17, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x0e, 0x66, 0x38, 0x65, 0x34, 0x6d, 0x33, 0x62, 0x31, 0x31, 0x66, 0x6e, 0x75, 0x7a,
	0x73, 0x12, 0x1c, 0x0a, 0x09, 0x66, 0x38, 0x65, 0x34, 0x6d, 0x33, 0x66, 0x6e, 0x73, 0x18, 0x14,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x66, 0x38, 0x65, 0x34, 0x6d, 0x33, 0x66, 0x6e, 0x73, 0x12,
	0x20, 0x0a, 0x0b, 0x66, 0x38, 0x65, 0x34, 0x6d, 0x33, 0x66, 0x6e, 0x75, 0x7a, 0x73, 0x18, 0x19,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x66, 0x38, 0x65, 0x34, 0x6d, 0x33, 0x66, 0x6e, 0x75, 0x7a,
	0x73, 0x12, 0x18, 0x0a, 0x07, 0x66, 0x38, 0x65, 0x34, 0x6d, 0x33, 0x73, 0x18, 0x1c, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x07, 0x66, 0x38, 0x65, 0x34, 0x6d, 0x33, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x66,
	0x38, 0x65, 0x35, 0x6d, 0x32, 0x66, 0x6e, 0x75, 0x7a, 0x73, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x0b, 0x66, 0x38, 0x65, 0x35, 0x6d, 0x32, 0x66, 0x6e, 0x75, 0x7a, 0x73, 0x12, 0x18, 0x0a,
	0x07, 0x66, 0x38, 0x65, 0x35, 0x6d, 0x32, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07,
	0x66, 0x38, 0x65, 0x35, 0x6d, 0x32, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x66, 0x38, 0x65, 0x38, 0x6d,
	0x30, 0x66, 0x6e, 0x75, 0x73, 0x18, 0x21, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x66, 0x38, 0x65,
	0x38, 0x6d, 0x30, 0x66, 0x6e, 0x75, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x73, 0x70, 0x61, 0x72, 0x73,
	0x65, 0x5f, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x03, 0x52,
	0x0d, 0x73, 0x70, 0x61, 0x72, 0x73, 0x65, 0x49, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x22, 0xf8,
	0x01, 0x0a, 0x0f, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x72, 0x69, 0x64, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x73, 0x74, 0x72, 0x69, 0x64, 0x65, 0x12, 0x1f,
	0x0a, 0x0b, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x6f, 0x77, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0a, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x4c, 0x6f, 0x77, 0x12,
	0x21, 0x0a, 0x0c, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x68, 0x69, 0x67, 0x68, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x48, 0x69,
	0x67, 0x68, 0x12, 0x27, 0x0a, 0x0f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x64, 0x69, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x77, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x44, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x62,
	0x61, 0x73, 0x65, 0x5f, 0x64, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0c, 0x62, 0x61, 0x73, 0x65, 0x44, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x27, 0x0a, 0x0f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x72, 0x65, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x6c, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x77, 0x69, 0x6e, 0x64, 0x6f,
	0x77, 0x52, 0x65, 0x76, 0x65, 0x72, 0x73, 0x61, 0x6c, 0x22, 0x3e, 0x0a, 0x06, 0x57, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x12, 0x34, 0x0a, 0x0a, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x57, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x64,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xb0, 0x02, 0x0a, 0x16, 0x47, 0x61,
	0x74, 0x68, 0x65, 0x72, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x75, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x5f, 0x64,
	0x69, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x03, 0x52, 0x0a, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x44, 0x69, 0x6d, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x70, 0x73,
	0x65, 0x64, 0x5f, 0x73, 0x6c, 0x69, 0x63, 0x65, 0x5f, 0x64, 0x69, 0x6d, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x03, 0x52, 0x12, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x70, 0x73, 0x65, 0x64, 0x53, 0x6c,
	0x69, 0x63, 0x65, 0x44, 0x69, 0x6d, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x6d, 0x61, 0x70, 0x18, 0x03, 0x20, 0x03, 0x28, 0x03,
	0x52, 0x0d, 0x73, 0x74, 0x61, 0x72, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x4d, 0x61, 0x70, 0x12,
	0x28, 0x0a, 0x10, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x76, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f,
	0x64, 0x69, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0e, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x56, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x44, 0x69, 0x6d, 0x12, 0x32, 0x0a, 0x15, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x6e, 0x64, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x69,
	0x6d, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x03, 0x52, 0x13, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x6e,
	0x64, 0x42, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x44, 0x69, 0x6d, 0x73, 0x12, 0x3d, 0x0a,
	0x1b, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x5f, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x69, 0x6d, 0x73, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x03, 0x52, 0x18, 0x73, 0x74, 0x61, 0x72, 0x74, 0x49, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x44, 0x69, 0x6d, 0x73, 0x22, 0xd6, 0x02, 0x0a,
	0x17, 0x53, 0x63, 0x61, 0x74, 0x74, 0x65, 0x72, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x64, 0x69, 0x6d, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x03, 0x52, 0x10, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x44, 0x69, 0x6d, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74,
	0x65, 0x64, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x64, 0x69, 0x6d, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x03, 0x52, 0x12, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x65, 0x64, 0x57, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x44, 0x69, 0x6d, 0x73, 0x12, 0x3e, 0x0a, 0x1c, 0x73, 0x63, 0x61, 0x74,
	0x74, 0x65, 0x72, 0x5f, 0x64, 0x69, 0x6d, 0x73, 0x5f, 0x74, 0x6f, 0x5f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x6e, 0x64, 0x5f, 0x64, 0x69, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x03, 0x52, 0x18,
	0x73, 0x63, 0x61, 0x74, 0x74, 0x65, 0x72, 0x44, 0x69, 0x6d, 0x73, 0x54, 0x6f, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x6e, 0x64, 0x44, 0x69, 0x6d, 0x73, 0x12, 0x28, 0x0a, 0x10, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x5f, 0x76, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x64, 0x69, 0x6d, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0e, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x56, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x44,
	0x69, 0x6d, 0x12, 0x2e, 0x0a, 0x13, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x62, 0x61, 0x74, 0x63,
	0x68, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x69, 0x6d, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x03, 0x52,
	0x11, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x42, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x44, 0x69,
	0x6d, 0x73, 0x12, 0x41, 0x0a, 0x1d, 0x73, 0x63, 0x61, 0x74, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x6e,
	0x64, 0x69, 0x63, 0x65, 0x73, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x5f, 0x64,
	0x69, 0x6d, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x03, 0x52, 0x1a, 0x73, 0x63, 0x61, 0x74, 0x74,
	0x65, 0x72, 0x49, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x42, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e,
	0x67, 0x44, 0x69, 0x6d, 0x73, 0x22, 0xb7, 0x04, 0x0a, 0x1b, 0x43, 0x6f, 0x6e, 0x76, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x75,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x0a, 0x17, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x38, 0x0a, 0x18, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x70, 0x61, 0x74, 0x69,
	0x61, 0x6c, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0b, 0x20,
	0x03, 0x28, 0x03, 0x52, 0x16, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x70, 0x61, 0x74, 0x69, 0x61,
	0x6c, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x43, 0x0a, 0x1e, 0x6b,
	0x65, 0x72, 0x6e, 0x65, 0x6c, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x1b, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x45, 0x0a, 0x1f, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1c, 0x6b, 0x65, 0x72, 0x6e, 0x65,
	0x6c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x44, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x19, 0x6b, 0x65, 0x72, 0x6e, 0x65,
	0x6c, 0x5f, 0x73, 0x70, 0x61, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x03, 0x52, 0x17, 0x6b, 0x65, 0x72, 0x6e,
	0x65, 0x6c, 0x53, 0x70, 0x61, 0x74, 0x69, 0x61, 0x6c, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x62, 0x61,
	0x74, 0x63, 0x68, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x14, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x38, 0x0a, 0x18, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x64, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x03, 0x52, 0x16, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x19, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x70,
	0x61, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x0c, 0x20, 0x03, 0x28, 0x03, 0x52, 0x17, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x70,
	0x61, 0x74, 0x69, 0x61, 0x6c, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22,
	0xf5, 0x01, 0x0a, 0x13, 0x44, 0x6f, 0x74, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x12, 0x3c, 0x0a, 0x1a, 0x6c, 0x68, 0x73, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x03, 0x52, 0x18, 0x6c, 0x68, 0x73,
	0x43, 0x6f, 0x6e, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6e, 0x67, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3c, 0x0a, 0x1a, 0x72, 0x68, 0x73, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x03, 0x52, 0x18, 0x72, 0x68, 0x73, 0x43, 0x6f,
	0x6e, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6e, 0x67, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x6c, 0x68, 0x73, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68,
	0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x03, 0x52, 0x12, 0x6c, 0x68, 0x73, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x72, 0x68, 0x73, 0x5f, 0x62, 0x61, 0x74,
	0x63, 0x68, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x03, 0x52, 0x12, 0x72, 0x68, 0x73, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xcf, 0x01, 0x0a, 0x19, 0x52, 0x61, 0x67, 0x67,
	0x65, 0x64, 0x44, 0x6f, 0x74, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x75,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x12, 0x4c, 0x0a, 0x15, 0x64, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x44, 0x6f, 0x74, 0x44, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x52, 0x13,
	0x64, 0x6f, 0x74, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x6c, 0x68, 0x73, 0x5f, 0x72, 0x61, 0x67, 0x67, 0x65,
	0x64, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x03, 0x52, 0x13, 0x6c, 0x68, 0x73, 0x52, 0x61, 0x67, 0x67, 0x65, 0x64, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x30, 0x0a, 0x14, 0x72, 0x68, 0x73, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x03, 0x52, 0x12, 0x72, 0x68, 0x73, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x44,
	0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x8a, 0x02, 0x0a, 0x16, 0x54, 0x72,
	0x69, 0x61, 0x6e, 0x67, 0x75, 0x6c, 0x61, 0x72, 0x53, 0x6f, 0x6c, 0x76, 0x65, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x6c, 0x65, 0x66, 0x74, 0x5f, 0x73, 0x69, 0x64,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x6c, 0x65, 0x66, 0x74, 0x53, 0x69, 0x64,
	0x65, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x05, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x12, 0x23, 0x0a, 0x0d, 0x75, 0x6e, 0x69, 0x74, 0x5f,
	0x64, 0x69, 0x61, 0x67, 0x6f, 0x6e, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c,
	0x75, 0x6e, 0x69, 0x74, 0x44, 0x69, 0x61, 0x67, 0x6f, 0x6e, 0x61, 0x6c, 0x12, 0x46, 0x0a, 0x0b,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x73, 0x65, 0x5f, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x25, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6e, 0x67, 0x75, 0x6c,
	0x61, 0x72, 0x53, 0x6f, 0x6c, 0x76, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x73, 0x65, 0x52, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70,
	0x6f, 0x73, 0x65, 0x41, 0x22, 0x50, 0x0a, 0x09, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x73,
	0x65, 0x12, 0x15, 0x0a, 0x11, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x50, 0x4f, 0x53, 0x45, 0x5f, 0x49,
	0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x4e, 0x4f, 0x5f, 0x54,
	0x52, 0x41, 0x4e, 0x53, 0x50, 0x4f, 0x53, 0x45, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x54, 0x52,
	0x41, 0x4e, 0x53, 0x50, 0x4f, 0x53, 0x45, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x41, 0x44, 0x4a,
	0x4f, 0x49, 0x4e, 0x54, 0x10, 0x03, 0x22, 0x27, 0x0a, 0x0f, 0x43, 0x68, 0x6f, 0x6c, 0x65, 0x73,
	0x6b, 0x79, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x6f, 0x77,
	0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x22,
	0x2d, 0x0a, 0x0b, 0x53, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1e,
	0x0a, 0x0a, 0x64, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0a, 0x64, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x22, 0x80,
	0x01, 0x0a, 0x12, 0x46, 0x72, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x32, 0x0a, 0x03, 0x6d, 0x61, 0x70, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x20, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x46, 0x72, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x64, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x2e, 0x4d, 0x61, 0x70, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x03, 0x6d, 0x61, 0x70, 0x1a, 0x36, 0x0a, 0x08, 0x4d, 0x61, 0x70,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x43, 0x0a, 0x09, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x12, 0x1b,
	0x0a, 0x09, 0x73, 0x74, 0x61, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x73, 0x74, 0x61, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x73,
	0x74, 0x61, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x07, 0x73,
	0x74, 0x61, 0x74, 0x56, 0x61, 0x6c, 0x22, 0x76, 0x0a, 0x0d, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73,
	0x74, 0x69, 0x63, 0x73, 0x56, 0x69, 0x7a, 0x12, 0x35, 0x0a, 0x17, 0x73, 0x74, 0x61, 0x74, 0x5f,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x74, 0x6f, 0x5f, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69,
	0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x73, 0x74, 0x61, 0x74, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x54, 0x6f, 0x56, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x12, 0x2e,
	0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74,
	0x69, 0x63, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x22, 0xb4,
	0x06, 0x0a, 0x0a, 0x4f, 0x70, 0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x28, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x14, 0x2e, 0x78, 0x6c,
	0x61, 0x2e, 0x4f, 0x70, 0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x2e, 0x0a, 0x0a, 0x74, 0x69, 0x6c, 0x65, 0x5f,
	0x73, 0x68, 0x61, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x78, 0x6c,
	0x61, 0x2e, 0x53, 0x68, 0x61, 0x70, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x09, 0x74, 0x69,
	0x6c, 0x65, 0x53, 0x68, 0x61, 0x70, 0x65, 0x12, 0x3c, 0x0a, 0x1a, 0x74, 0x69, 0x6c, 0x65, 0x5f,
	0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x03, 0x52, 0x18, 0x74, 0x69, 0x6c,
	0x65, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x36, 0x0a, 0x17, 0x74, 0x69, 0x6c, 0x65, 0x5f, 0x61, 0x73,
	0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x03, 0x52, 0x15, 0x74, 0x69, 0x6c, 0x65, 0x41, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x38, 0x0a,
	0x0f, 0x74, 0x75, 0x70, 0x6c, 0x65, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x4f, 0x70, 0x53,
	0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x0e, 0x74, 0x75, 0x70, 0x6c, 0x65, 0x53, 0x68,
	0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3a, 0x0a, 0x1a, 0x72, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x5f, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x74, 0x69, 0x6c,
	0x65, 0x5f, 0x64, 0x69, 0x6d, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x72, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x4c, 0x61, 0x73, 0x74, 0x54, 0x69, 0x6c, 0x65,
	0x44, 0x69, 0x6d, 0x12, 0x2b, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x4f, 0x70, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x3a, 0x0a, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x74, 0x69, 0x6c, 0x65, 0x5f, 0x64, 0x69,
	0x6d, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x14, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x4f,
	0x70, 0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c,
	0x6c, 0x61, 0x73, 0x74, 0x54, 0x69, 0x6c, 0x65, 0x44, 0x69, 0x6d, 0x73, 0x12, 0x2a, 0x0a, 0x11,
	0x69, 0x6f, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x73, 0x68, 0x61, 0x70, 0x65, 0x5f, 0x64, 0x69, 0x6d,
	0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x03, 0x52, 0x0f, 0x69, 0x6f, 0x74, 0x61, 0x52, 0x65, 0x73,
	0x68, 0x61, 0x70, 0x65, 0x44, 0x69, 0x6d, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x69, 0x6f, 0x74, 0x61,
	0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x73, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x18,
	0x0a, 0x20, 0x03, 0x28, 0x05, 0x52, 0x11, 0x69, 0x6f, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x70, 0x6f, 0x73, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x12, 0x24, 0x0a, 0x0e, 0x69, 0x73, 0x5f, 0x73,
	0x68, 0x61, 0x72, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0c, 0x69, 0x73, 0x53, 0x68, 0x61, 0x72, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x24,
	0x0a, 0x0e, 0x73, 0x68, 0x61, 0x72, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x73, 0x68, 0x61, 0x72, 0x64, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x49, 0x64, 0x12, 0x48, 0x0a, 0x10, 0x73, 0x68, 0x61, 0x72, 0x64, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e,
	0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x4f, 0x70, 0x53, 0x68, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x2e,
	0x53, 0x68, 0x61, 0x72, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0e,
	0x73, 0x68, 0x61, 0x72, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x54, 0x79, 0x70, 0x65, 0x22, 0x61,
	0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43,
	0x41, 0x54, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x41, 0x58, 0x49, 0x4d, 0x41,
	0x4c, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x54, 0x55, 0x50, 0x4c, 0x45, 0x10, 0x02, 0x12, 0x09,
	0x0a, 0x05, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x4d, 0x41, 0x4e,
	0x55, 0x41, 0x4c, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e,
	0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09, 0x55, 0x4e, 0x52, 0x45, 0x44, 0x55, 0x43, 0x45, 0x44, 0x10,
	0x06, 0x22, 0x22, 0x0a, 0x0e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x06, 0x0a, 0x02, 0x41, 0x53, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4c,
	0x49, 0x4b, 0x45, 0x10, 0x01, 0x22, 0x2f, 0x0a, 0x0c, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x03, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x49, 0x64, 0x73, 0x22, 0xd8, 0x01, 0x0a, 0x19, 0x49, 0x6f, 0x74, 0x61, 0x52,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2c, 0x0a, 0x12, 0x6e, 0x75, 0x6d, 0x5f, 0x72, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x10, 0x6e, 0x75, 0x6d, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x12, 0x31, 0x0a, 0x15, 0x6e, 0x75, 0x6d, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x12, 0x6e, 0x75, 0x6d, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x50, 0x65, 0x72,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x2a, 0x0a, 0x11, 0x69, 0x6f, 0x74, 0x61, 0x5f, 0x72, 0x65,
	0x73, 0x68, 0x61, 0x70, 0x65, 0x5f, 0x64, 0x69, 0x6d, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x03,
	0x52, 0x0f, 0x69, 0x6f, 0x74, 0x61, 0x52, 0x65, 0x73, 0x68, 0x61, 0x70, 0x65, 0x44, 0x69, 0x6d,
	0x73, 0x12, 0x2e, 0x0a, 0x13, 0x69, 0x6f, 0x74, 0x61, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70,
	0x6f, 0x73, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x18, 0x04, 0x20, 0x03, 0x28, 0x05, 0x52, 0x11,
	0x69, 0x6f, 0x74, 0x61, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x73, 0x65, 0x50, 0x65, 0x72,
	0x6d, 0x22, 0xac, 0x01, 0x0a, 0x19, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x38, 0x0a, 0x0e, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x0d, 0x72, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x55, 0x0a, 0x17, 0x69, 0x6f, 0x74,
	0x61, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f,
	0x6c, 0x69, 0x73, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x78, 0x6c, 0x61,
	0x2e, 0x49, 0x6f, 0x74, 0x61, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x14, 0x69, 0x6f, 0x74, 0x61,
	0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4c, 0x69, 0x73, 0x74,
	0x22, 0x3e, 0x0a, 0x0c, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x12, 0x16, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x22, 0xf3, 0x01, 0x0a, 0x0e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x41, 0x63, 0x63, 0x75, 0x72,
	0x61, 0x63, 0x79, 0x12, 0x2e, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x18, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x41, 0x63,
	0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x48, 0x00, 0x52, 0x04, 0x6d,
	0x6f, 0x64, 0x65, 0x12, 0x3d, 0x0a, 0x09, 0x74, 0x6f, 0x6c, 0x65, 0x72, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x41, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x2e, 0x54, 0x6f, 0x6c, 0x65,
	0x72, 0x61, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x74, 0x6f, 0x6c, 0x65, 0x72, 0x61, 0x6e,
	0x63, 0x65, 0x1a, 0x47, 0x0a, 0x09, 0x54, 0x6f, 0x6c, 0x65, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x61, 0x74, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x04, 0x61,
	0x74, 0x6f, 0x6c, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x74, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x01, 0x52, 0x04, 0x72, 0x74, 0x6f, 0x6c, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x6c, 0x70, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x75, 0x6c, 0x70, 0x73, 0x22, 0x20, 0x0a, 0x04, 0x4d,
	0x6f, 0x64, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x00,
	0x12, 0x0b, 0x0a, 0x07, 0x48, 0x49, 0x47, 0x48, 0x45, 0x53, 0x54, 0x10, 0x01, 0x42, 0x07, 0x0a,
	0x05, 0x73, 0x70, 0x65, 0x63, 0x73, 0x22, 0xe1, 0x04, 0x0a, 0x0f, 0x50, 0x72, 0x65, 0x63, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b, 0x0a, 0x11, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x50, 0x72, 0x65, 0x63,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x72, 0x65, 0x63,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x6e, 0x64, 0x50, 0x72,
	0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x0a, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72,
	0x69, 0x74, 0x68, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1e, 0x2e, 0x78, 0x6c, 0x61,
	0x2e, 0x50, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x52, 0x09, 0x61, 0x6c, 0x67, 0x6f,
	0x72, 0x69, 0x74, 0x68, 0x6d, 0x22, 0x2f, 0x0a, 0x09, 0x50, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x00, 0x12,
	0x08, 0x0a, 0x04, 0x48, 0x49, 0x47, 0x48, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x48, 0x49, 0x47,
	0x48, 0x45, 0x53, 0x54, 0x10, 0x02, 0x22, 0x91, 0x03, 0x0a, 0x09, 0x41, 0x6c, 0x67, 0x6f, 0x72,
	0x69, 0x74, 0x68, 0x6d, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x4c, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x45,
	0x54, 0x10, 0x00, 0x12, 0x1d, 0x0a, 0x19, 0x41, 0x4c, 0x47, 0x5f, 0x44, 0x4f, 0x54, 0x5f, 0x41,
	0x4e, 0x59, 0x5f, 0x46, 0x38, 0x5f, 0x41, 0x4e, 0x59, 0x5f, 0x46, 0x38, 0x5f, 0x46, 0x33, 0x32,
	0x10, 0x01, 0x12, 0x28, 0x0a, 0x24, 0x41, 0x4c, 0x47, 0x5f, 0x44, 0x4f, 0x54, 0x5f, 0x41, 0x4e,
	0x59, 0x5f, 0x46, 0x38, 0x5f, 0x41, 0x4e, 0x59, 0x5f, 0x46, 0x38, 0x5f, 0x46, 0x33, 0x32, 0x5f,
	0x46, 0x41, 0x53, 0x54, 0x5f, 0x41, 0x43, 0x43, 0x55, 0x4d, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13,
	0x41, 0x4c, 0x47, 0x5f, 0x44, 0x4f, 0x54, 0x5f, 0x46, 0x31, 0x36, 0x5f, 0x46, 0x31, 0x36, 0x5f,
	0x46, 0x31, 0x36, 0x10, 0x03, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x4c, 0x47, 0x5f, 0x44, 0x4f, 0x54,
	0x5f, 0x46, 0x31, 0x36, 0x5f, 0x46, 0x31, 0x36, 0x5f, 0x46, 0x33, 0x32, 0x10, 0x04, 0x12, 0x1a,
	0x0a, 0x16, 0x41, 0x4c, 0x47, 0x5f, 0x44, 0x4f, 0x54, 0x5f, 0x42, 0x46, 0x31, 0x36, 0x5f, 0x42,
	0x46, 0x31, 0x36, 0x5f, 0x42, 0x46, 0x31, 0x36, 0x10, 0x05, 0x12, 0x19, 0x0a, 0x15, 0x41, 0x4c,
	0x47, 0x5f, 0x44, 0x4f, 0x54, 0x5f, 0x42, 0x46, 0x31, 0x36, 0x5f, 0x42, 0x46, 0x31, 0x36, 0x5f,
	0x46, 0x33, 0x32, 0x10, 0x06, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x4c, 0x47, 0x5f, 0x44, 0x4f, 0x54,
	0x5f, 0x42, 0x46, 0x31, 0x36, 0x5f, 0x42, 0x46, 0x31, 0x36, 0x5f, 0x46, 0x33, 0x32, 0x5f, 0x58,
	0x33, 0x10, 0x07, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x4c, 0x47, 0x5f, 0x44, 0x4f, 0x54, 0x5f, 0x42,
	0x46, 0x31, 0x36, 0x5f, 0x42, 0x46, 0x31, 0x36, 0x5f, 0x46, 0x33, 0x32, 0x5f, 0x58, 0x36, 0x10,
	0x08, 0x12, 0x19, 0x0a, 0x15, 0x41, 0x4c, 0x47, 0x5f, 0x44, 0x4f, 0x54, 0x5f, 0x54, 0x46, 0x33,
	0x32, 0x5f, 0x54, 0x46, 0x33, 0x32, 0x5f, 0x46, 0x33, 0x32, 0x10, 0x09, 0x12, 0x1c, 0x0a, 0x18,
	0x41, 0x4c, 0x47, 0x5f, 0x44, 0x4f, 0x54, 0x5f, 0x54, 0x46, 0x33, 0x32, 0x5f, 0x54, 0x46, 0x33,
	0x32, 0x5f, 0x46, 0x33, 0x32, 0x5f, 0x58, 0x33, 0x10, 0x0a, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x4c,
	0x47, 0x5f, 0x44, 0x4f, 0x54, 0x5f, 0x46, 0x33, 0x32, 0x5f, 0x46, 0x33, 0x32, 0x5f, 0x46, 0x33,
	0x32, 0x10, 0x0b, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x4c, 0x47, 0x5f, 0x44, 0x4f, 0x54, 0x5f, 0x46,
	0x36, 0x34, 0x5f, 0x46, 0x36, 0x34, 0x5f, 0x46, 0x36, 0x34, 0x10, 0x0c, 0x12, 0x1c, 0x0a, 0x18,
	0x41, 0x4c, 0x47, 0x5f, 0x44, 0x4f, 0x54, 0x5f, 0x42, 0x46, 0x31, 0x36, 0x5f, 0x42, 0x46, 0x31,
	0x36, 0x5f, 0x46, 0x33, 0x32, 0x5f, 0x58, 0x39, 0x10, 0x0d, 0x22, 0x53, 0x0a, 0x14, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x1a, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x61, 0x74, 0x5f, 0x6c, 0x65, 0x61, 0x66, 0x5f, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x08, 0x52, 0x17, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x41, 0x74, 0x4c, 0x65, 0x61, 0x66, 0x42, 0x75, 0x66, 0x66, 0x65, 0x72, 0x73, 0x22,
	0xc3, 0x03, 0x0a, 0x16, 0x57, 0x68, 0x69, 0x6c, 0x65, 0x4c, 0x6f, 0x6f, 0x70, 0x42, 0x61, 0x63,
	0x6b, 0x65, 0x6e, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x54, 0x0a, 0x10, 0x6b, 0x6e,
	0x6f, 0x77, 0x6e, 0x5f, 0x74, 0x72, 0x69, 0x70, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x57, 0x68, 0x69, 0x6c, 0x65,
	0x4c, 0x6f, 0x6f, 0x70, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x4b, 0x6e, 0x6f, 0x77, 0x6e, 0x54, 0x72, 0x69, 0x70, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x52, 0x0e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x54, 0x72, 0x69, 0x70, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x51, 0x0a, 0x0f, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x69, 0x6e, 0x69, 0x74, 0x5f, 0x73,
	0x74, 0x65, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x78, 0x6c, 0x61, 0x2e,
	0x57, 0x68, 0x69, 0x6c, 0x65, 0x4c, 0x6f, 0x6f, 0x70, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4b, 0x6e, 0x6f, 0x77, 0x6e, 0x49, 0x6e, 0x69, 0x74,
	0x53, 0x74, 0x65, 0x70, 0x52, 0x0d, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x49, 0x6e, 0x69, 0x74, 0x53,
	0x74, 0x65, 0x70, 0x12, 0x6c, 0x0a, 0x18, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x5f, 0x69, 0x6e, 0x64,
	0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x57, 0x68, 0x69, 0x6c,
	0x65, 0x4c, 0x6f, 0x6f, 0x70, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x4b, 0x6e, 0x6f, 0x77, 0x6e, 0x49, 0x6e, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x16, 0x6b, 0x6e, 0x6f, 0x77, 0x6e,
	0x49, 0x6e, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c,
	0x65, 0x1a, 0x37, 0x0a, 0x0d, 0x4b, 0x6e, 0x6f, 0x77, 0x6e, 0x49, 0x6e, 0x69, 0x74, 0x53, 0x74,
	0x65, 0x70, 0x12, 0x12, 0x0a, 0x04, 0x69, 0x6e, 0x69, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x04, 0x69, 0x6e, 0x69, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x74, 0x65, 0x70, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x73, 0x74, 0x65, 0x70, 0x1a, 0x1e, 0x0a, 0x0e, 0x4b, 0x6e,
	0x6f, 0x77, 0x6e, 0x54, 0x72, 0x69, 0x70, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x0c, 0x0a, 0x01,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x01, 0x6e, 0x1a, 0x39, 0x0a, 0x16, 0x4b, 0x6e,
	0x6f, 0x77, 0x6e, 0x49, 0x6e, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x72, 0x69,
	0x61, 0x62, 0x6c, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x75, 0x70, 0x6c, 0x65, 0x5f, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x74, 0x75, 0x70, 0x6c, 0x65,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x22, 0x9a, 0x01, 0x0a, 0x15, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x6e, 0x64, 0x41, 0x6c, 0x69, 0x61, 0x73, 0x69, 0x6e, 0x67, 0x12,
	0x2c, 0x0a, 0x12, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x68, 0x61, 0x70, 0x65, 0x5f,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x03, 0x28, 0x03, 0x52, 0x10, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x53, 0x68, 0x61, 0x70, 0x65, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x23, 0x0a,
	0x0d, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0c, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x6e, 0x64, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x12, 0x2e, 0x0a, 0x13, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x6e, 0x64, 0x5f, 0x73, 0x68,
	0x61, 0x70, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x03, 0x20, 0x03, 0x28, 0x03, 0x52,
	0x11, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x6e, 0x64, 0x53, 0x68, 0x61, 0x70, 0x65, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x22, 0x60, 0x0a, 0x12, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x41, 0x72,
	0x72, 0x61, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x29, 0x0a, 0x10, 0x69, 0x6e, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x68, 0x61, 0x70, 0x65, 0x5f, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x18, 0x02, 0x20, 0x03, 0x28, 0x03, 0x52, 0x0a, 0x73, 0x68, 0x61, 0x70, 0x65, 0x49,
	0x6e, 0x64, 0x65, 0x78, 0x22, 0x7c, 0x0a, 0x19, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x68, 0x61, 0x70, 0x65, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x03, 0x52, 0x0a, 0x73, 0x68, 0x61, 0x70, 0x65, 0x49, 0x6e, 0x64,
	0x65, 0x78, 0x12, 0x3e, 0x0a, 0x0e, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x61,
	0x72, 0x72, 0x61, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x78, 0x6c, 0x61,
	0x2e, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x41, 0x72, 0x72, 0x61, 0x79, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x52, 0x0d, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x41, 0x72, 0x72,
	0x61, 0x79, 0x22, 0x7c, 0x0a, 0x12, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x78, 0x6c, 0x61,
	0x2e, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x45, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x52, 0x08, 0x65, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x69, 0x73, 0x5f, 0x73, 0x79, 0x6e, 0x74, 0x68,
	0x65, 0x74, 0x69, 0x63, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x0f, 0x69, 0x73, 0x53, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x74, 0x69, 0x63, 0x43, 0x61, 0x6c, 0x6c,
	0x22, 0xc0, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x6d, 0x6d, 0x50, 0x65, 0x72, 0x66, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x0c, 0x0a, 0x01, 0x62, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x01, 0x62, 0x12, 0x0c, 0x0a, 0x01, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x01, 0x6d, 0x12, 0x0c, 0x0a, 0x01, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x01,
	0x6e, 0x12, 0x0c, 0x0a, 0x01, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x01, 0x6b, 0x12,
	0x38, 0x0a, 0x05, 0x66, 0x6c, 0x6f, 0x70, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22,
	0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x47, 0x65, 0x6d, 0x6d, 0x50, 0x65, 0x72, 0x66, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x46, 0x6c, 0x6f, 0x70, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x05, 0x66, 0x6c, 0x6f, 0x70, 0x73, 0x1a, 0x38, 0x0a, 0x0a, 0x46, 0x6c, 0x6f,
	0x70, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x4d, 0x0a, 0x18, 0x47, 0x65, 0x6d, 0x6d, 0x50, 0x65, 0x72, 0x66, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12,
	0x31, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x47, 0x65, 0x6d, 0x6d, 0x50, 0x65, 0x72, 0x66, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69,
	0x65, 0x73, 0x22, 0xa5, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x6d, 0x6d, 0x50, 0x65, 0x72, 0x66, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x12, 0x39, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x47, 0x65, 0x6d, 0x6d,
	0x50, 0x65, 0x72, 0x66, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x1a,
	0x59, 0x0a, 0x0c, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x33, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1d, 0x2e, 0x78, 0x6c, 0x61, 0x2e, 0x47, 0x65, 0x6d, 0x6d, 0x50, 0x65, 0x72, 0x66, 0x54,
	0x61, 0x62, 0x6c, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x2a, 0x98, 0x03, 0x0a, 0x0d, 0x50,
	0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16,
	0x50, 0x52, 0x49, 0x4d, 0x49, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x49,
	0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x50, 0x52, 0x45, 0x44,
	0x10, 0x01, 0x12, 0x06, 0x0a, 0x02, 0x53, 0x31, 0x10, 0x1e, 0x12, 0x06, 0x0a, 0x02, 0x53, 0x32,
	0x10, 0x1a, 0x12, 0x06, 0x0a, 0x02, 0x53, 0x34, 0x10, 0x15, 0x12, 0x06, 0x0a, 0x02, 0x53, 0x38,
	0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x53, 0x31, 0x36, 0x10, 0x03, 0x12, 0x07, 0x0a, 0x03, 0x53,
	0x33, 0x32, 0x10, 0x04, 0x12, 0x07, 0x0a, 0x03, 0x53, 0x36, 0x34, 0x10, 0x05, 0x12, 0x06, 0x0a,
	0x02, 0x55, 0x31, 0x10, 0x1f, 0x12, 0x06, 0x0a, 0x02, 0x55, 0x32, 0x10, 0x1b, 0x12, 0x06, 0x0a,
	0x02, 0x55, 0x34, 0x10, 0x16, 0x12, 0x06, 0x0a, 0x02, 0x55, 0x38, 0x10, 0x06, 0x12, 0x07, 0x0a,
	0x03, 0x55, 0x31, 0x36, 0x10, 0x07, 0x12, 0x07, 0x0a, 0x03, 0x55, 0x33, 0x32, 0x10, 0x08, 0x12,
	0x07, 0x0a, 0x03, 0x55, 0x36, 0x34, 0x10, 0x09, 0x12, 0x07, 0x0a, 0x03, 0x46, 0x31, 0x36, 0x10,
	0x0a, 0x12, 0x07, 0x0a, 0x03, 0x46, 0x33, 0x32, 0x10, 0x0b, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x46,
	0x31, 0x36, 0x10, 0x10, 0x12, 0x07, 0x0a, 0x03, 0x46, 0x36, 0x34, 0x10, 0x0c, 0x12, 0x0a, 0x0a,
	0x06, 0x46, 0x38, 0x45, 0x35, 0x4d, 0x32, 0x10, 0x13, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x38, 0x45,
	0x34, 0x4d, 0x33, 0x10, 0x1c, 0x12, 0x0c, 0x0a, 0x08, 0x46, 0x38, 0x45, 0x34, 0x4d, 0x33, 0x46,
	0x4e, 0x10, 0x14, 0x12, 0x11, 0x0a, 0x0d, 0x46, 0x38, 0x45, 0x34, 0x4d, 0x33, 0x42, 0x31, 0x31,
	0x46, 0x4e, 0x55, 0x5a, 0x10, 0x17, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x38, 0x45, 0x33, 0x4d, 0x34,
	0x10, 0x1d, 0x12, 0x0e, 0x0a, 0x0a, 0x46, 0x38, 0x45, 0x35, 0x4d, 0x32, 0x46, 0x4e, 0x55, 0x5a,
	0x10, 0x18, 0x12, 0x0e, 0x0a, 0x0a, 0x46, 0x38, 0x45, 0x34, 0x4d, 0x33, 0x46, 0x4e, 0x55, 0x5a,
	0x10, 0x19, 0x12, 0x0c, 0x0a, 0x08, 0x46, 0x34, 0x45, 0x32, 0x4d, 0x31, 0x46, 0x4e, 0x10, 0x20,
	0x12, 0x0d, 0x0a, 0x09, 0x46, 0x38, 0x45, 0x38, 0x4d, 0x30, 0x46, 0x4e, 0x55, 0x10, 0x21, 0x12,
	0x07, 0x0a, 0x03, 0x43, 0x36, 0x34, 0x10, 0x0f, 0x12, 0x08, 0x0a, 0x04, 0x43, 0x31, 0x32, 0x38,
	0x10, 0x12, 0x12, 0x09, 0x0a, 0x05, 0x54, 0x55, 0x50, 0x4c, 0x45, 0x10, 0x0d, 0x12, 0x0f, 0x0a,
	0x0b, 0x4f, 0x50, 0x41, 0x51, 0x55, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0x0e, 0x12, 0x09,
	0x0a, 0x05, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x10, 0x11, 0x12, 0x0a, 0x0a, 0x06, 0x42, 0x55, 0x46,
	0x46, 0x45, 0x52, 0x10, 0x22, 0x2a, 0x5e, 0x0a, 0x0c, 0x44, 0x69, 0x6d, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x49, 0x4d, 0x5f, 0x44, 0x45, 0x4e,
	0x53, 0x45, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x49, 0x4d, 0x5f, 0x43, 0x4f, 0x4d, 0x50,
	0x52, 0x45, 0x53, 0x53, 0x45, 0x44, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x44, 0x49, 0x4d, 0x5f,
	0x53, 0x49, 0x4e, 0x47, 0x4c, 0x45, 0x54, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x18, 0x0a, 0x14, 0x44,
	0x49, 0x4d, 0x5f, 0x4c, 0x4f, 0x4f, 0x53, 0x45, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x52, 0x45, 0x53,
	0x53, 0x45, 0x44, 0x10, 0x03, 0x2a, 0x3d, 0x0a, 0x0b, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x57, 0x49, 0x4e, 0x44, 0x4f, 0x57, 0x10, 0x01, 0x12, 0x08, 0x0a,
	0x04, 0x46, 0x4c, 0x41, 0x47, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x54, 0x45, 0x47,
	0x45, 0x52, 0x10, 0x03, 0x2a, 0x6a, 0x0a, 0x0d, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x21, 0x0a, 0x1d, 0x50, 0x52, 0x4f, 0x46, 0x49, 0x4c, 0x45,
	0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f,
	0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x50, 0x52, 0x4f, 0x46,
	0x49, 0x4c, 0x45, 0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x45, 0x4d, 0x42, 0x45, 0x44,
	0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x50, 0x52, 0x4f, 0x46, 0x49, 0x4c, 0x45,
	0x5f, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x52, 0x45, 0x4d, 0x4f, 0x54, 0x45, 0x10, 0x02,
	0x2a, 0x85, 0x01, 0x0a, 0x10, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x1f, 0x43, 0x4f, 0x4d, 0x50, 0x49, 0x4c, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f,
	0x57, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x10, 0x00, 0x12, 0x27, 0x0a, 0x23, 0x43, 0x4f,
	0x4d, 0x50, 0x49, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f,
	0x46, 0x49, 0x52, 0x53, 0x54, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x49, 0x4c, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x10, 0x01, 0x12, 0x23, 0x0a, 0x1f, 0x43, 0x4f, 0x4d, 0x50, 0x49, 0x4c, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x52, 0x45, 0x43, 0x4f, 0x4d, 0x50, 0x49,
	0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x2a, 0xb2, 0x02, 0x0a, 0x19, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x27, 0x0a, 0x23, 0x50, 0x52, 0x4f, 0x46, 0x49, 0x4c,
	0x45, 0x5f, 0x47, 0x45, 0x4e, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x52,
	0x41, 0x54, 0x45, 0x47, 0x59, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12,
	0x22, 0x0a, 0x1e, 0x50, 0x52, 0x4f, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x47, 0x45, 0x4e, 0x45, 0x52,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x52, 0x41, 0x54, 0x45, 0x47, 0x59, 0x5f, 0x47,
	0x41, 0x10, 0x01, 0x12, 0x25, 0x0a, 0x21, 0x50, 0x52, 0x4f, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x47,
	0x45, 0x4e, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x52, 0x41, 0x54, 0x45,
	0x47, 0x59, 0x5f, 0x46, 0x41, 0x4e, 0x54, 0x41, 0x10, 0x02, 0x12, 0x23, 0x0a, 0x1f, 0x50, 0x52,
	0x4f, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x47, 0x45, 0x4e, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x53, 0x54, 0x52, 0x41, 0x54, 0x45, 0x47, 0x59, 0x5f, 0x43, 0x46, 0x4f, 0x10, 0x03, 0x12,
	0x2a, 0x0a, 0x26, 0x50, 0x52, 0x4f, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x47, 0x45, 0x4e, 0x45, 0x52,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x52, 0x41, 0x54, 0x45, 0x47, 0x59, 0x5f, 0x45,
	0x58, 0x48, 0x41, 0x55, 0x53, 0x54, 0x49, 0x56, 0x45, 0x10, 0x04, 0x12, 0x27, 0x0a, 0x23, 0x50,
	0x52, 0x4f, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x47, 0x45, 0x4e, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x53, 0x54, 0x52, 0x41, 0x54, 0x45, 0x47, 0x59, 0x5f, 0x4c, 0x43, 0x4d, 0x5f, 0x47,
	0x4e, 0x4e, 0x10, 0x05, 0x12, 0x27, 0x0a, 0x23, 0x50, 0x52, 0x4f, 0x46, 0x49, 0x4c, 0x45, 0x5f,
	0x47, 0x45, 0x4e, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x52, 0x41, 0x54,
	0x45, 0x47, 0x59, 0x5f, 0x4c, 0x43, 0x4d, 0x5f, 0x4d, 0x4f, 0x45, 0x10, 0x06, 0x2a, 0x47, 0x0a,
	0x0b, 0x50, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x12, 0x13, 0x0a, 0x0f,
	0x50, 0x41, 0x44, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10,
	0x00, 0x12, 0x11, 0x0a, 0x0d, 0x50, 0x41, 0x44, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x56, 0x41, 0x4c,
	0x49, 0x44, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x41, 0x44, 0x44, 0x49, 0x4e, 0x47, 0x5f,
	0x53, 0x41, 0x4d, 0x45, 0x10, 0x02, 0x2a, 0x31, 0x0a, 0x07, 0x46, 0x66, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x07, 0x0a, 0x03, 0x46, 0x46, 0x54, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x49, 0x46,
	0x46, 0x54, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x52, 0x46, 0x46, 0x54, 0x10, 0x02, 0x12, 0x09,
	0x0a, 0x05, 0x49, 0x52, 0x46, 0x46, 0x54, 0x10, 0x03, 0x2a, 0x46, 0x0a, 0x12, 0x52, 0x61, 0x6e,
	0x64, 0x6f, 0x6d, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x0f, 0x0a, 0x0b, 0x52, 0x4e, 0x47, 0x5f, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x00,
	0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x4e, 0x47, 0x5f, 0x55, 0x4e, 0x49, 0x46, 0x4f, 0x52, 0x4d, 0x10,
	0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x4e, 0x47, 0x5f, 0x4e, 0x4f, 0x52, 0x4d, 0x41, 0x4c, 0x10,
	0x02, 0x2a, 0x45, 0x0a, 0x0f, 0x52, 0x61, 0x6e, 0x64, 0x6f, 0x6d, 0x41, 0x6c, 0x67, 0x6f, 0x72,
	0x69, 0x74, 0x68, 0x6d, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x4e, 0x47, 0x5f, 0x44, 0x45, 0x46, 0x41,
	0x55, 0x4c, 0x54, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x52, 0x4e, 0x47, 0x5f, 0x54, 0x48, 0x52,
	0x45, 0x45, 0x5f, 0x46, 0x52, 0x59, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x4e, 0x47, 0x5f,
	0x50, 0x48, 0x49, 0x4c, 0x4f, 0x58, 0x10, 0x02, 0x42, 0x03, 0xf8, 0x01, 0x01, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var (
	file_xla_xla_data_proto_rawDescOnce sync.Once
	file_xla_xla_data_proto_rawDescData []byte
)

func file_xla_xla_data_proto_rawDescGZIP() []byte {
	file_xla_xla_data_proto_rawDescOnce.Do(func() {
		file_xla_xla_data_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_xla_xla_data_proto_rawDesc), len(file_xla_xla_data_proto_rawDesc)))
	})
	return file_xla_xla_data_proto_rawDescData
}

var file_xla_xla_data_proto_enumTypes = make([]protoimpl.EnumInfo, 17)
var file_xla_xla_data_proto_msgTypes = make([]protoimpl.MessageInfo, 54)
var file_xla_xla_data_proto_goTypes = []any{
	(PrimitiveType)(0),                              // 0: xla.PrimitiveType
	(DimLevelType)(0),                               // 1: xla.DimLevelType
	(ProfileType)(0),                                // 2: xla.ProfileType
	(ProfileSource)(0),                              // 3: xla.ProfileSource
	(CompilationEvent)(0),                           // 4: xla.CompilationEvent
	(ProfileGenerationStrategy)(0),                  // 5: xla.ProfileGenerationStrategy
	(PaddingType)(0),                                // 6: xla.PaddingType
	(FftType)(0),                                    // 7: xla.FftType
	(RandomDistribution)(0),                         // 8: xla.RandomDistribution
	(RandomAlgorithm)(0),                            // 9: xla.RandomAlgorithm
	(ChannelHandle_ChannelType)(0),                  // 10: xla.ChannelHandle.ChannelType
	(TriangularSolveOptions_Transpose)(0),           // 11: xla.TriangularSolveOptions.Transpose
	(OpSharding_Type)(0),                            // 12: xla.OpSharding.Type
	(OpSharding_ShardGroupType)(0),                  // 13: xla.OpSharding.ShardGroupType
	(ResultAccuracy_Mode)(0),                        // 14: xla.ResultAccuracy.Mode
	(PrecisionConfig_Precision)(0),                  // 15: xla.PrecisionConfig.Precision
	(PrecisionConfig_Algorithm)(0),                  // 16: xla.PrecisionConfig.Algorithm
	(*PaddingConfig)(nil),                           // 17: xla.PaddingConfig
	(*TileProto)(nil),                               // 18: xla.TileProto
	(*SplitConfigProto)(nil),                        // 19: xla.SplitConfigProto
	(*LayoutProto)(nil),                             // 20: xla.LayoutProto
	(*ShapeProto)(nil),                              // 21: xla.ShapeProto
	(*ProgramShapeProto)(nil),                       // 22: xla.ProgramShapeProto
	(*ComputationStats)(nil),                        // 23: xla.ComputationStats
	(*OpMetadata)(nil),                              // 24: xla.OpMetadata
	(*ExecutionProfile)(nil),                        // 25: xla.ExecutionProfile
	(*ExecutionHandle)(nil),                         // 26: xla.ExecutionHandle
	(*GlobalDataHandle)(nil),                        // 27: xla.GlobalDataHandle
	(*DeviceHandle)(nil),                            // 28: xla.DeviceHandle
	(*ChannelHandle)(nil),                           // 29: xla.ChannelHandle
	(*DeviceAssignmentProto)(nil),                   // 30: xla.DeviceAssignmentProto
	(*LiteralProto)(nil),                            // 31: xla.LiteralProto
	(*WindowDimension)(nil),                         // 32: xla.WindowDimension
	(*Window)(nil),                                  // 33: xla.Window
	(*GatherDimensionNumbers)(nil),                  // 34: xla.GatherDimensionNumbers
	(*ScatterDimensionNumbers)(nil),                 // 35: xla.ScatterDimensionNumbers
	(*ConvolutionDimensionNumbers)(nil),             // 36: xla.ConvolutionDimensionNumbers
	(*DotDimensionNumbers)(nil),                     // 37: xla.DotDimensionNumbers
	(*RaggedDotDimensionNumbers)(nil),               // 38: xla.RaggedDotDimensionNumbers
	(*TriangularSolveOptions)(nil),                  // 39: xla.TriangularSolveOptions
	(*CholeskyOptions)(nil),                         // 40: xla.CholeskyOptions
	(*SortOptions)(nil),                             // 41: xla.SortOptions
	(*FrontendAttributes)(nil),                      // 42: xla.FrontendAttributes
	(*Statistic)(nil),                               // 43: xla.Statistic
	(*StatisticsViz)(nil),                           // 44: xla.StatisticsViz
	(*OpSharding)(nil),                              // 45: xla.OpSharding
	(*ReplicaGroup)(nil),                            // 46: xla.ReplicaGroup
	(*IotaReplicaGroupListProto)(nil),               // 47: xla.IotaReplicaGroupListProto
	(*CollectiveDeviceListProto)(nil),               // 48: xla.CollectiveDeviceListProto
	(*SourceTarget)(nil),                            // 49: xla.SourceTarget
	(*ResultAccuracy)(nil),                          // 50: xla.ResultAccuracy
	(*PrecisionConfig)(nil),                         // 51: xla.PrecisionConfig
	(*ParameterReplication)(nil),                    // 52: xla.ParameterReplication
	(*WhileLoopBackendConfig)(nil),                  // 53: xla.WhileLoopBackendConfig
	(*OutputOperandAliasing)(nil),                   // 54: xla.OutputOperandAliasing
	(*OriginalArrayProto)(nil),                      // 55: xla.OriginalArrayProto
	(*OriginalValueElementProto)(nil),               // 56: xla.OriginalValueElementProto
	(*OriginalValueProto)(nil),                      // 57: xla.OriginalValueProto
	(*GemmPerfTableEntry)(nil),                      // 58: xla.GemmPerfTableEntry
	(*GemmPerfTableEntryValues)(nil),                // 59: xla.GemmPerfTableEntryValues
	(*GemmPerfTable)(nil),                           // 60: xla.GemmPerfTable
	(*PaddingConfig_PaddingConfigDimension)(nil),    // 61: xla.PaddingConfig.PaddingConfigDimension
	(*OpMetadata_ProfileInfo)(nil),                  // 62: xla.OpMetadata.ProfileInfo
	(*DeviceAssignmentProto_ComputationDevice)(nil), // 63: xla.DeviceAssignmentProto.ComputationDevice
	nil,                              // 64: xla.FrontendAttributes.MapEntry
	(*ResultAccuracy_Tolerance)(nil), // 65: xla.ResultAccuracy.Tolerance
	(*WhileLoopBackendConfig_KnownInitStep)(nil),          // 66: xla.WhileLoopBackendConfig.KnownInitStep
	(*WhileLoopBackendConfig_KnownTripCount)(nil),         // 67: xla.WhileLoopBackendConfig.KnownTripCount
	(*WhileLoopBackendConfig_KnownInductionVariable)(nil), // 68: xla.WhileLoopBackendConfig.KnownInductionVariable
	nil, // 69: xla.GemmPerfTableEntry.FlopsEntry
	nil, // 70: xla.GemmPerfTable.EntriesEntry
}
var file_xla_xla_data_proto_depIdxs = []int32{
	61, // 0: xla.PaddingConfig.dimensions:type_name -> xla.PaddingConfig.PaddingConfigDimension
	1,  // 1: xla.LayoutProto.dim_level_types:type_name -> xla.DimLevelType
	18, // 2: xla.LayoutProto.tiles:type_name -> xla.TileProto
	0,  // 3: xla.LayoutProto.index_primitive_type:type_name -> xla.PrimitiveType
	0,  // 4: xla.LayoutProto.pointer_primitive_type:type_name -> xla.PrimitiveType
	21, // 5: xla.LayoutProto.physical_shape:type_name -> xla.ShapeProto
	19, // 6: xla.LayoutProto.split_configs:type_name -> xla.SplitConfigProto
	0,  // 7: xla.ShapeProto.element_type:type_name -> xla.PrimitiveType
	21, // 8: xla.ShapeProto.tuple_shapes:type_name -> xla.ShapeProto
	20, // 9: xla.ShapeProto.layout:type_name -> xla.LayoutProto
	21, // 10: xla.ProgramShapeProto.parameters:type_name -> xla.ShapeProto
	21, // 11: xla.ProgramShapeProto.result:type_name -> xla.ShapeProto
	2,  // 12: xla.OpMetadata.profile_type:type_name -> xla.ProfileType
	62, // 13: xla.OpMetadata.profile_info:type_name -> xla.OpMetadata.ProfileInfo
	10, // 14: xla.ChannelHandle.type:type_name -> xla.ChannelHandle.ChannelType
	63, // 15: xla.DeviceAssignmentProto.computation_devices:type_name -> xla.DeviceAssignmentProto.ComputationDevice
	21, // 16: xla.LiteralProto.shape:type_name -> xla.ShapeProto
	31, // 17: xla.LiteralProto.tuple_literals:type_name -> xla.LiteralProto
	32, // 18: xla.Window.dimensions:type_name -> xla.WindowDimension
	37, // 19: xla.RaggedDotDimensionNumbers.dot_dimension_numbers:type_name -> xla.DotDimensionNumbers
	11, // 20: xla.TriangularSolveOptions.transpose_a:type_name -> xla.TriangularSolveOptions.Transpose
	64, // 21: xla.FrontendAttributes.map:type_name -> xla.FrontendAttributes.MapEntry
	43, // 22: xla.StatisticsViz.statistics:type_name -> xla.Statistic
	12, // 23: xla.OpSharding.type:type_name -> xla.OpSharding.Type
	21, // 24: xla.OpSharding.tile_shape:type_name -> xla.ShapeProto
	45, // 25: xla.OpSharding.tuple_shardings:type_name -> xla.OpSharding
	24, // 26: xla.OpSharding.metadata:type_name -> xla.OpMetadata
	12, // 27: xla.OpSharding.last_tile_dims:type_name -> xla.OpSharding.Type
	13, // 28: xla.OpSharding.shard_group_type:type_name -> xla.OpSharding.ShardGroupType
	46, // 29: xla.CollectiveDeviceListProto.replica_groups:type_name -> xla.ReplicaGroup
	47, // 30: xla.CollectiveDeviceListProto.iota_replica_group_list:type_name -> xla.IotaReplicaGroupListProto
	14, // 31: xla.ResultAccuracy.mode:type_name -> xla.ResultAccuracy.Mode
	65, // 32: xla.ResultAccuracy.tolerance:type_name -> xla.ResultAccuracy.Tolerance
	15, // 33: xla.PrecisionConfig.operand_precision:type_name -> xla.PrecisionConfig.Precision
	16, // 34: xla.PrecisionConfig.algorithm:type_name -> xla.PrecisionConfig.Algorithm
	67, // 35: xla.WhileLoopBackendConfig.known_trip_count:type_name -> xla.WhileLoopBackendConfig.KnownTripCount
	66, // 36: xla.WhileLoopBackendConfig.known_init_step:type_name -> xla.WhileLoopBackendConfig.KnownInitStep
	68, // 37: xla.WhileLoopBackendConfig.known_induction_variable:type_name -> xla.WhileLoopBackendConfig.KnownInductionVariable
	55, // 38: xla.OriginalValueElementProto.original_array:type_name -> xla.OriginalArrayProto
	56, // 39: xla.OriginalValueProto.elements:type_name -> xla.OriginalValueElementProto
	69, // 40: xla.GemmPerfTableEntry.flops:type_name -> xla.GemmPerfTableEntry.FlopsEntry
	58, // 41: xla.GemmPerfTableEntryValues.entries:type_name -> xla.GemmPerfTableEntry
	70, // 42: xla.GemmPerfTable.entries:type_name -> xla.GemmPerfTable.EntriesEntry
	2,  // 43: xla.OpMetadata.ProfileInfo.profile_type:type_name -> xla.ProfileType
	3,  // 44: xla.OpMetadata.ProfileInfo.profile_source:type_name -> xla.ProfileSource
	4,  // 45: xla.OpMetadata.ProfileInfo.compilation_event:type_name -> xla.CompilationEvent
	5,  // 46: xla.OpMetadata.ProfileInfo.profile_generation_strategy:type_name -> xla.ProfileGenerationStrategy
	59, // 47: xla.GemmPerfTable.EntriesEntry.value:type_name -> xla.GemmPerfTableEntryValues
	48, // [48:48] is the sub-list for method output_type
	48, // [48:48] is the sub-list for method input_type
	48, // [48:48] is the sub-list for extension type_name
	48, // [48:48] is the sub-list for extension extendee
	0,  // [0:48] is the sub-list for field type_name
}

func init() { file_xla_xla_data_proto_init() }
func file_xla_xla_data_proto_init() {
	if File_xla_xla_data_proto != nil {
		return
	}
	file_xla_xla_data_proto_msgTypes[33].OneofWrappers = []any{
		(*ResultAccuracy_Mode_)(nil),
		(*ResultAccuracy_Tolerance_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_xla_xla_data_proto_rawDesc), len(file_xla_xla_data_proto_rawDesc)),
			NumEnums:      17,
			NumMessages:   54,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_xla_xla_data_proto_goTypes,
		DependencyIndexes: file_xla_xla_data_proto_depIdxs,
		EnumInfos:         file_xla_xla_data_proto_enumTypes,
		MessageInfos:      file_xla_xla_data_proto_msgTypes,
	}.Build()
	File_xla_xla_data_proto = out.File
	file_xla_xla_data_proto_goTypes = nil
	file_xla_xla_data_proto_depIdxs = nil
}
