/***** File generated by gopjrt/internal/cmd/xlabuilder_codegen, based on op_types.txt. Don't edit it directly. *****/

package xlabuilder_test

import (
	"fmt"
	"github.com/gomlx/gopjrt/dtypes"
	. "github.com/gomlx/gopjrt/xlabuilder"
	"github.com/stretchr/testify/require"
	"testing"
)

// TestSimpleOps simply concatenate all unary and then binary ops in a nonsensical computation, just to check
// that the HLO proto is actually generated -- and that all simple ops run.
func TestSimpleOps(t *testing.T) {
	builder := New("simple_ops_test")
	x, err := Parameter(builder, "x", 0, MakeShape(dtypes.F32)) // Scalar float32.
	i, err := Parameter(builder, "i", 1, MakeShape(dtypes.S32)) // Scalar int32.
	v, err := Parameter(builder, "v", 2, MakeShape(dtypes.F32, 2))

	// Unary ops:
	x, err = Abs(x)
	require.NoError(t, err, "Failed to build unary operation Abs")
	x, err = Neg(x)
	require.NoError(t, err, "Failed to build unary operation Neg")
	x, err = Exp(x)
	require.NoError(t, err, "Failed to build unary operation Exp")
	x, err = Expm1(x)
	require.NoError(t, err, "Failed to build unary operation Expm1")
	x, err = Floor(x)
	require.NoError(t, err, "Failed to build unary operation Floor")
	x, err = Ceil(x)
	require.NoError(t, err, "Failed to build unary operation Ceil")
	x, err = Round(x)
	require.NoError(t, err, "Failed to build unary operation Round")
	x, err = Log(x)
	require.NoError(t, err, "Failed to build unary operation Log")
	x, err = Log1p(x)
	require.NoError(t, err, "Failed to build unary operation Log1p")
	x, err = Logistic(x)
	require.NoError(t, err, "Failed to build unary operation Logistic")
	x, err = Sign(x)
	require.NoError(t, err, "Failed to build unary operation Sign")
	x, err = Cos(x)
	require.NoError(t, err, "Failed to build unary operation Cos")
	x, err = Sin(x)
	require.NoError(t, err, "Failed to build unary operation Sin")
	x, err = Tanh(x)
	require.NoError(t, err, "Failed to build unary operation Tanh")
	x, err = Sqrt(x)
	require.NoError(t, err, "Failed to build unary operation Sqrt")
	x, err = Rsqrt(x)
	require.NoError(t, err, "Failed to build unary operation Rsqrt")
	x, err = Erf(x)
	require.NoError(t, err, "Failed to build unary operation Erf")

	// Binary ops:
	x, err = Add(x, x)
	require.NoError(t, err, "Failed to build binary operation Add")
	x, err = Mul(x, x)
	require.NoError(t, err, "Failed to build binary operation Mul")
	x, err = Sub(x, x)
	require.NoError(t, err, "Failed to build binary operation Sub")
	x, err = Div(x, x)
	require.NoError(t, err, "Failed to build binary operation Div")
	x, err = Rem(x, x)
	require.NoError(t, err, "Failed to build binary operation Rem")
	x, err = Min(x, x)
	require.NoError(t, err, "Failed to build binary operation Min")
	x, err = Max(x, x)
	require.NoError(t, err, "Failed to build binary operation Max")
	x, err = Pow(x, x)
	require.NoError(t, err, "Failed to build binary operation Pow")
	x, err = ShiftLeft(x, x)
	require.NoError(t, err, "Failed to build binary operation ShiftLeft")
	x, err = ShiftRightArithmetic(x, x)
	require.NoError(t, err, "Failed to build binary operation ShiftRightArithmetic")
	x, err = ShiftRightLogical(x, x)
	require.NoError(t, err, "Failed to build binary operation ShiftRightLogical")

	// Binary-comparison op.
	var result, cmp *Op
	cmp, err = Equal(x, x)
	require.NoError(t, err, "Failed to build binary comparison operation Equal")
	if result == nil {
		result = cmp
	} else {
		result, err = LogicalAnd(result, cmp)
		require.NoError(t, err, "Failed to build logical And operation when aggregating the result from Equal")
	}
	cmp, err = NotEqual(x, x)
	require.NoError(t, err, "Failed to build binary comparison operation NotEqual")
	if result == nil {
		result = cmp
	} else {
		result, err = LogicalAnd(result, cmp)
		require.NoError(t, err, "Failed to build logical And operation when aggregating the result from NotEqual")
	}
	cmp, err = GreaterOrEqual(x, x)
	require.NoError(t, err, "Failed to build binary comparison operation GreaterOrEqual")
	if result == nil {
		result = cmp
	} else {
		result, err = LogicalAnd(result, cmp)
		require.NoError(t, err, "Failed to build logical And operation when aggregating the result from GreaterOrEqual")
	}
	cmp, err = GreaterThan(x, x)
	require.NoError(t, err, "Failed to build binary comparison operation GreaterThan")
	if result == nil {
		result = cmp
	} else {
		result, err = LogicalAnd(result, cmp)
		require.NoError(t, err, "Failed to build logical And operation when aggregating the result from GreaterThan")
	}
	cmp, err = LessOrEqual(x, x)
	require.NoError(t, err, "Failed to build binary comparison operation LessOrEqual")
	if result == nil {
		result = cmp
	} else {
		result, err = LogicalAnd(result, cmp)
		require.NoError(t, err, "Failed to build logical And operation when aggregating the result from LessOrEqual")
	}
	cmp, err = LessThan(x, x)
	require.NoError(t, err, "Failed to build binary comparison operation LessThan")
	if result == nil {
		result = cmp
	} else {
		result, err = LogicalAnd(result, cmp)
		require.NoError(t, err, "Failed to build logical And operation when aggregating the result from LessThan")
	}
	cmp, err = EqualTotalOrder(x, x)
	require.NoError(t, err, "Failed to build binary comparison operation EqualTotalOrder")
	if result == nil {
		result = cmp
	} else {
		result, err = LogicalAnd(result, cmp)
		require.NoError(t, err, "Failed to build logical And operation when aggregating the result from EqualTotalOrder")
	}
	cmp, err = NotEqualTotalOrder(x, x)
	require.NoError(t, err, "Failed to build binary comparison operation NotEqualTotalOrder")
	if result == nil {
		result = cmp
	} else {
		result, err = LogicalAnd(result, cmp)
		require.NoError(t, err, "Failed to build logical And operation when aggregating the result from NotEqualTotalOrder")
	}
	cmp, err = GreaterOrEqualTotalOrder(x, x)
	require.NoError(t, err, "Failed to build binary comparison operation GreaterOrEqualTotalOrder")
	if result == nil {
		result = cmp
	} else {
		result, err = LogicalAnd(result, cmp)
		require.NoError(t, err, "Failed to build logical And operation when aggregating the result from GreaterOrEqualTotalOrder")
	}
	cmp, err = GreaterThanTotalOrder(x, x)
	require.NoError(t, err, "Failed to build binary comparison operation GreaterThanTotalOrder")
	if result == nil {
		result = cmp
	} else {
		result, err = LogicalAnd(result, cmp)
		require.NoError(t, err, "Failed to build logical And operation when aggregating the result from GreaterThanTotalOrder")
	}
	cmp, err = LessOrEqualTotalOrder(x, x)
	require.NoError(t, err, "Failed to build binary comparison operation LessOrEqualTotalOrder")
	if result == nil {
		result = cmp
	} else {
		result, err = LogicalAnd(result, cmp)
		require.NoError(t, err, "Failed to build logical And operation when aggregating the result from LessOrEqualTotalOrder")
	}
	cmp, err = LessThanTotalOrder(x, x)
	require.NoError(t, err, "Failed to build binary comparison operation LessThanTotalOrder")
	if result == nil {
		result = cmp
	} else {
		result, err = LogicalAnd(result, cmp)
		require.NoError(t, err, "Failed to build logical And operation when aggregating the result from LessThanTotalOrder")
	}

	// Other ops not tested above.
	x, err = Dot(v, v)
	require.NoError(t, err, "Failed to build Dot operation")
	var c *Op
	c, err = Complex(x, x)
	require.NoError(t, err, "Failed to build Complex operation")
	imgV, err := Imag(c)
	require.NoError(t, err, "Failed to build Imag operation")
	realV, err := Real(c)
	require.NoError(t, err, "Failed to build Real operation")
	same, err := Equal(imgV, realV)
	require.NoError(t, err, "Failed to build Equal operation")
	result, err = LogicalAnd(result, same)
	require.NoError(t, err, "Failed to build And operation")

	result, err = IsFinite(x)
	require.NoError(t, err, "Failed to build IsFinite operation")
	require.Equal(t, dtypes.Bool, result.Shape.DType, "IsFinite should return booleans")

	require.NoError(t, err, "Failed to build And operation")
	i, err = Clz(i)
	require.NoError(t, err, "Failed to build Clz operation")

	i, err = PopulationCount(i)
	require.NoError(t, err, "Failed to build PopulationCount operation")
	same, err = Equal(i, i)
	require.NoError(t, err, "Failed to build Equal operation")

	result, err = BitwiseOr(result, same)
	require.NoError(t, err, "Failed to build Or operation")
	result, err = BitwiseAnd(result, same)
	require.NoError(t, err, "Failed to build And operation")
	result, err = BitwiseXor(result, same)
	require.NoError(t, err, "Failed to build Xor operation")
	i, err = BitwiseNot(i)
	require.NoError(t, err, "Failed to build unary operation BitwiseNot")

	result, err = LogicalOr(result, same)
	require.NoError(t, err, "Failed to build Or operation")
	result, err = LogicalAnd(result, same)
	require.NoError(t, err, "Failed to build And operation")
	result, err = LogicalXor(result, same)
	require.NoError(t, err, "Failed to build Xor operation")
	i, err = LogicalNot(i)
	require.NoError(t, err, "Failed to build unary operation LogicalNot")

	// Get computation created: result depends on all of them.
	comp, err := builder.Build(result)
	require.NoError(t, err, "Failed to build the computation after setting all the ops")
	fmt.Printf("HloModule proto:\n%s\n\n", comp.TextHLO())
}
