/*
 *  BEGIN_COPYRIGHT
 *
 *  Copyright (C) 2011-2013 deCODE genetics Inc.
 *  Copyright (C) 2013-2019 WuXi NextCode Inc.
 *  All Rights Reserved.
 *
 *  GORpipe is free software: you can redistribute it and/or modify
 *  it under the terms of the AFFERO GNU General Public License as published by
 *  the Free Software Foundation.
 *
 *  GORpipe is distributed "AS-IS" AND WITHOUT ANY WARRANTY OF ANY KIND,
 *  INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
 *  NON-INFRINGEMENT, OR FITNESS FOR A PARTICULAR PURPOSE. See
 *  the AFFERO GNU General Public License for the complete license terms.
 *
 *  You should have received a copy of the AFFERO GNU General Public License
 *  along with GORpipe.  If not, see <http://www.gnu.org/licenses/agpl-3.0.html>
 *
 *  END_COPYRIGHT
 */

package gorsat.Commands;

import gorsat.TestUtils;
import org.gorpipe.gor.util.ColumnCompressUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

import java.io.FileWriter;
import java.io.IOException;

public class UTestColumnDeflateInflate {

    @Rule
    public TemporaryFolder workDir = new TemporaryFolder();

    @Test
    public void testLargeAndSmallRows() throws IOException {
        var tmpFile = workDir.newFile("test.gor");
        var writer = new FileWriter(tmpFile);
        writer.write(
                "Chrom\tPOS\tdata\n" +
                        "chr1\t1\t123123123123\n" +
                        "chr1\t2\tlong_row_0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000\n"

        );
        writer.close();

        var query = "gor " + tmpFile + " | deflatecolumn data";
        var result = TestUtils.runGorPipeLines(query);

        Assert.assertEquals("Chrom\tPOS\tdata\n", result[0]);
        Assert.assertEquals("chr1\t1\t123123123123\n", result[1]);
        Assert.assertTrue(result[2].contains(ColumnCompressUtil.MAGIC));
    }

    @Test
    public void testLargeAndSmallRowsSmallMinimumSize() throws IOException {
        var tmpFile = workDir.newFile("test.gor");
        var writer = new FileWriter(tmpFile);
        writer.write(
                "Chrom\tPOS\tdata\n" +
                        "chr1\t1\t123123123123\n" +
                        "chr1\t2\tlong_row_0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000\n"

        );
        writer.close();

        var query = "gor " + tmpFile + " | deflatecolumn data -m 10";
        var result = TestUtils.runGorPipeLines(query);

        Assert.assertEquals("Chrom\tPOS\tdata\n", result[0]);
        Assert.assertTrue(result[1].contains(ColumnCompressUtil.MAGIC));
        Assert.assertTrue(result[2].contains(ColumnCompressUtil.MAGIC));
    }


}