package gorsat;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

public class UTestPrgtgenNonConverging {
    @Rule
    public TemporaryFolder workDir = new TemporaryFolder();

    @Test
    public void testNonConverging() throws IOException {
        Path pospath = workDir.getRoot().toPath().resolve("pos102664.gor");
        Files.writeString(pospath, pos);

        Path bucketspath = workDir.getRoot().toPath().resolve("buckets.tsv");
        Files.writeString(bucketspath, buck);

        Path covpath = workDir.getRoot().toPath().resolve("cov.gor");
        Files.writeString(covpath, cov);

        String query = "gor pos102664.gor|prgtgen -gc #3,#4 buckets.tsv cov.gor -th 0.9 -e 0.001";
        String result = TestUtils.runGorPipe(query, "-gorroot", workDir.getRoot().getAbsolutePath());
        Assert.assertEquals("Wrong result from prgtgen","CHROM\tPOS\tReference\tCall\tAF\tAN\tpAB\tpBB\tBucket\tValues\n" +
                "chr1\t102664\tA\tG\t0.50450\t305\t0.99093\t0.0090347\tbucket_1\t11111111111311111111111131111111111111111111111131111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111131111111111111111111111111111111111111111311111111111111111111111111111111111111311111113111111111111111111111111111111111111111111111111111111111111111\n",
                result);
    }

    String pos = "CHROM\tPOS\tReference\tCall\tCallCopies\tCallRatio\tDepth\tGL_Call\tFILTER\tFS\tformatZip\tPN\n" +
            "chr1\t102664\tA\tG\t1\t0.400\t10\t116\tPASS\t6.99\tAlt=G:GT=0/1,AD=6,4,DP=10,GQ=99,PL=116,0,156\tGD501770301\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t3\t19\tPASS\t0.0\tAlt=G:GT=0/1,AD=1,2,DP=3,GQ=19,PL=67,0,19\tGD501766401\n" +
            "chr1\t102664\tA\tG\t1\t0.600\t5\t41\tPASS\t10.0\tAlt=G:GT=0/1,AD=2,3,DP=5,GQ=41,PL=95,0,41\tGD501767301\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t8\t97\tPASS\t3.68\tAlt=G:GT=0/1,AD=4,4,DP=8,GQ=97,PL=108,0,97\tGD501765601\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t3\t9\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,3,DP=3,GQ=9,PL=100,9,0\tGD501768001\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t2\t6\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,2,DP=2,GQ=6,PL=73,6,0\tGD501768401\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t3\t9\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,3,DP=3,GQ=9,PL=112,9,0\tGD501766501\n" +
            "chr1\t102664\tA\tG\t1\t0.417\t12\t143\tPASS\t6.892\tAlt=G:GT=0/1,AD=7,5,DP=12,GQ=99,PL=143,0,182\tGD501768801\n" +
            "chr1\t102664\tA\tG\t1\t0.200\t15\t66\tPASS\t13.57\tAlt=G:GT=0/1,AD=12,3,DP=15,GQ=66,PL=66,0,341\tGD501766901\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t3\t18\tPASS\t4.771\tAlt=G:GT=0/1,AD=1,2,DP=3,GQ=18,PL=63,0,18\tGD501161901\n" +
            "chr1\t102664\tA\tG\t1\t0.400\t10\t113\tPASS\t3.31\tAlt=G:GT=0/1,AD=6,4,DP=10,GQ=99,PL=113,0,164\tGD501157301\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t6\t81\tPASS\t0.0\tAlt=G:GT=0/1,AD=3,3,DP=6,GQ=81,PL=89,0,81\tGD501153501\n" +
            "chr1\t102664\tA\tG\t1\t0.714\t7\t43\tPASS\t5.441\tAlt=G:GT=0/1,AD=2,5,DP=7,GQ=43,PL=144,0,43\tGD501161801\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t4\t45\tPASS\t0.0\tAlt=G:GT=0/1,AD=2,2,DP=4,GQ=45,PL=64,0,45\tGD501152301\n" +
            "chr1\t102664\tA\tG\t1\t0.167\t24\t75\tPASS\t10.073\tAlt=G:GT=0/1,AD=20,4,DP=24,GQ=75,PL=75,0,542\tGD501162901\n" +
            "chr1\t102664\tA\tG\t1\t0.800\t5\t12\tPASS\t6.99\tAlt=G:GT=0/1,AD=1,4,DP=5,GQ=12,PL=115,0,12\tGD501161601\n" +
            "chr1\t102664\tA\tG\t1\t0.300\t10\t77\tPASS\t3.233\tAlt=G:GT=0/1,AD=7,3,DP=10,GQ=77,PL=77,0,187\tGD501158601\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t2\t6\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,2,DP=2,GQ=6,PL=71,6,0\tGD501154801\n" +
            "chr1\t102664\tA\tG\t1\t0.125\t48\t64\tPASS\t14.703\tAlt=G:GT=0/1,AD=42,6,DP=48,GQ=64,PL=64,0,1240\tGD501159301\n" +
            "chr1\t102664\tA\tG\t1\t0.238\t21\t87\tPASS\t13.457\tAlt=G:GT=0/1,AD=16,5,DP=21,GQ=87,PL=87,0,432\tGD501252401\n" +
            "chr1\t102664\tA\tG\t1\t0.571\t7\t73\tPASS\t3.68\tAlt=G:GT=0/1,AD=3,4,DP=7,GQ=73,PL=116,0,73\tGD501246001\n" +
            "chr1\t102664\tA\tG\t1\t0.800\t5\t23\tPASS\t6.99\tAlt=G:GT=0/1,AD=1,4,DP=5,GQ=23,PL=123,0,23\tGD501249501\n" +
            "chr1\t102664\tA\tG\t1\t0.211\t19\t81\tPASS\t10.62\tAlt=G:GT=0/1,AD=15,4,DP=19,GQ=81,PL=81,0,415\tGD501250001\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t3\t19\tPASS\t4.771\tAlt=G:GT=0/1,AD=1,2,DP=3,GQ=19,PL=65,0,19\tGD501255001\n" +
            "chr1\t102664\tA\tG\t1\t0.400\t5\t60\tPASS\t0.0\tAlt=G:GT=0/1,AD=3,2,DP=5,GQ=60,PL=60,0,79\tGD501244901\n" +
            "chr1\t102664\tA\tG\t1\t0.182\t22\t67\tPASS\t2.671\tAlt=G:GT=0/1,AD=18,4,DP=22,GQ=67,PL=67,0,510\tGD501249001\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t2\t6\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,2,DP=2,GQ=6,PL=67,6,0\tGD501244301\n" +
            "chr1\t102664\tA\tG\t1\t0.188\t16\t60\tPASS\t12.041\tAlt=G:GT=0/1,AD=13,3,DP=16,GQ=60,PL=60,0,362\tGD501244801\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t3\t9\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,3,DP=3,GQ=9,PL=103,9,0\tGD501245501\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t10\t142\tPASS\t0.0\tAlt=G:GT=0/1,AD=5,5,DP=10,GQ=99,PL=144,0,142\tGD501249701\n" +
            "chr1\t102664\tA\tG\t1\t0.208\t24\t105\tPASS\t14.287\tAlt=G:GT=0/1,AD=19,5,DP=24,GQ=99,PL=105,0,561\tGD501250201\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t6\t82\tPASS\t0.0\tAlt=G:GT=0/1,AD=3,3,DP=6,GQ=82,PL=85,0,82\tGD501246901\n" +
            "chr1\t102664\tA\tG\t1\t0.214\t14\t61\tPASS\t12.601\tAlt=G:GT=0/1,AD=11,3,DP=14,GQ=61,PL=61,0,313\tGD501401901\n" +
            "chr1\t102664\tA\tG\t1\t0.429\t7\t89\tPASS\t0.0\tAlt=G:GT=0/1,AD=4,3,DP=7,GQ=89,PL=89,0,90\tGD501405701\n" +
            "chr1\t102664\tA\tG\t1\t0.194\t36\t128\tPASS\t8.105\tAlt=G:GT=0/1,AD=29,7,DP=36,GQ=99,PL=128,0,757\tGD501405301\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t6\t73\tPASS\t0.0\tAlt=G:GT=0/1,AD=3,3,DP=6,GQ=73,PL=73,0,82\tGD501403401\n" +
            "chr1\t102664\tA\tG\t1\t0.444\t9\t107\tPASS\t0.0\tAlt=G:GT=0/1,AD=5,4,DP=9,GQ=99,PL=124,0,107\tGD501399501\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t4\t42\tPASS\t4.771\tAlt=G:GT=0/1,AD=2,2,DP=4,GQ=42,PL=62,0,42\tGD501406801\n" +
            "chr1\t102664\tA\tG\t1\t0.750\t4\t16\tPASS\t0.0\tAlt=G:GT=0/1,AD=1,3,DP=4,GQ=16,PL=98,0,16\tGD501408301\n" +
            "chr1\t102664\tA\tG\t1\t0.250\t24\t132\tPASS\t11.781\tAlt=G:GT=0/1,AD=18,6,DP=24,GQ=99,PL=132,0,514\tGD501401601\n" +
            "chr1\t102664\tA\tG\t1\t0.700\t10\t64\tPASS\t5.229\tAlt=G:GT=0/1,AD=3,7,DP=10,GQ=64,PL=195,0,64\tGD501399001\n" +
            "chr1\t102664\tA\tG\t1\t0.455\t11\t135\tPASS\t7.404\tAlt=G:GT=0/1,AD=6,5,DP=11,GQ=99,PL=135,0,137\tGD501402701\n" +
            "chr1\t102664\tA\tG\t1\t0.267\t15\t90\tPASS\t6.368\tAlt=G:GT=0/1,AD=11,4,DP=15,GQ=90,PL=90,0,328\tGD501406501\n" +
            "chr1\t102664\tA\tG\t1\t0.429\t7\t73\tPASS\t15.441\tAlt=G:GT=0/1,AD=4,3,DP=7,GQ=73,PL=73,0,92\tGD501400001\n" +
            "chr1\t102664\tA\tG\t1\t0.429\t7\t79\tPASS\t0.0\tAlt=G:GT=0/1,AD=4,3,DP=7,GQ=79,PL=79,0,115\tGD501398301\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t3\t27\tPASS\t0.0\tAlt=G:GT=0/1,AD=1,2,DP=3,GQ=27,PL=66,0,27\tGD501400501\n" +
            "chr1\t102664\tA\tG\t1\t0.227\t22\t100\tPASS\t9.379\tAlt=G:GT=0/1,AD=17,5,DP=22,GQ=99,PL=100,0,510\tGD501400101\n" +
            "chr1\t102664\tA\tG\t1\t0.148\t27\t68\tPASS\t10.098\tAlt=G:GT=0/1,AD=23,4,DP=27,GQ=68,PL=68,0,712\tGD501401401\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t4\t12\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,4,DP=4,GQ=12,PL=149,12,0\tGD501407501\n" +
            "chr1\t102664\tA\tG\t1\t0.273\t11\t77\tPASS\t0.0\tAlt=G:GT=0/1,AD=8,3,DP=11,GQ=77,PL=77,0,236\tGD501399601\n" +
            "chr1\t102664\tA\tG\t1\t0.857\t7\t17\tPASS\t0.0\tAlt=G:GT=0/1,AD=1,6,DP=7,GQ=17,PL=170,0,17\tGD501400201\n" +
            "chr1\t102664\tA\tG\t1\t0.304\t23\t177\tPASS\t28.709\tAlt=G:GT=0/1,AD=16,7,DP=23,GQ=99,PL=177,0,425\tGD501404801\n" +
            "chr1\t102664\tA\tG\t1\t0.714\t7\t34\tPASS\t13.222\tAlt=G:GT=0/1,AD=2,5,DP=7,GQ=34,PL=158,0,34\tGD501406701\n" +
            "chr1\t102664\tA\tG\t1\t0.250\t12\t74\tPASS\t17.404\tAlt=G:GT=0/1,AD=9,3,DP=12,GQ=74,PL=74,0,282\tGD501406301\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t2\t6\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,2,DP=2,GQ=6,PL=74,6,0\tGD500750201\n" +
            "chr1\t102664\tA\tG\t1\t0.750\t4\t25\tPASS\t0.0\tAlt=G:GT=0/1,AD=1,3,DP=4,GQ=25,PL=96,0,25\tGD500752101\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t6\t66\tPASS\t10.0\tAlt=G:GT=0/1,AD=3,3,DP=6,GQ=66,PL=93,0,66\tGD500690101\n" +
            "chr1\t102664\tA\tG\t1\t0.429\t7\t80\tPASS\t8.451\tAlt=G:GT=0/1,AD=4,3,DP=7,GQ=80,PL=80,0,99\tGD500682201\n" +
            "chr1\t102664\tA\tG\t1\t0.231\t13\t62\tPASS\t0.0\tAlt=G:GT=0/1,AD=10,3,DP=13,GQ=62,PL=62,0,267\tGD500684501\n" +
            "chr1\t102664\tA\tG\t1\t0.429\t7\t87\tPASS\t0.0\tAlt=G:GT=0/1,AD=4,3,DP=7,GQ=87,PL=87,0,92\tGD500758701\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t3\t9\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,3,DP=3,GQ=9,PL=102,9,0\tGD500682801\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t6\t18\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,6,DP=6,GQ=18,PL=208,18,0\tGD500751401\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t3\t20\tPASS\t4.771\tAlt=G:GT=0/1,AD=1,2,DP=3,GQ=20,PL=65,0,20\tGD500682301\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t4\t51\tPASS\t0.0\tAlt=G:GT=0/1,AD=2,2,DP=4,GQ=51,PL=62,0,51\tGD500686901\n" +
            "chr1\t102664\tA\tG\t1\t0.190\t21\t87\tPASS\t0.0\tAlt=G:GT=0/1,AD=17,4,DP=21,GQ=87,PL=87,0,529\tGD500691101\n" +
            "chr1\t102664\tA\tG\t1\t0.417\t12\t119\tPASS\t10.925\tAlt=G:GT=0/1,AD=7,5,DP=12,GQ=99,PL=119,0,186\tGD500683201\n" +
            "chr1\t102664\tA\tG\t1\t0.375\t8\t78\tPASS\t7.068\tAlt=G:GT=0/1,AD=5,3,DP=8,GQ=78,PL=78,0,127\tGD500691201\n" +
            "chr1\t102664\tA\tG\t1\t0.800\t5\t13\tPASS\t0.0\tAlt=G:GT=0/1,AD=1,4,DP=5,GQ=13,PL=109,0,13\tGD500758901\n" +
            "chr1\t102664\tA\tG\t1\t0.250\t12\t69\tPASS\t2.932\tAlt=G:GT=0/1,AD=9,3,DP=12,GQ=69,PL=69,0,242\tGD500690901\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t3\t19\tPASS\t4.771\tAlt=G:GT=0/1,AD=1,2,DP=3,GQ=19,PL=61,0,19\tGD501176601\n" +
            "chr1\t102664\tA\tG\t1\t0.208\t24\t93\tPASS\t22.27\tAlt=G:GT=0/1,AD=19,5,DP=24,GQ=93,PL=93,0,533\tGD501179201\n" +
            "chr1\t102664\tA\tG\t1\t0.308\t13\t106\tPASS\t0.0\tAlt=G:GT=0/1,AD=9,4,DP=13,GQ=99,PL=106,0,247\tGD501175401\n" +
            "chr1\t102664\tA\tG\t1\t0.833\t6\t18\tPASS\t0.0\tAlt=G:GT=0/1,AD=1,5,DP=6,GQ=18,PL=147,0,18\tGD501177801\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t4\t52\tPASS\t0.0\tAlt=G:GT=0/1,AD=2,2,DP=4,GQ=52,PL=60,0,52\tGD501181101\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t9\t64\tPASS\t4.771\tAlt=G:GT=0/1,AD=3,6,DP=9,GQ=64,PL=187,0,64\tGD501183401\n" +
            "chr1\t102664\tA\tG\t1\t0.182\t22\t70\tPASS\t10.447\tAlt=G:GT=0/1,AD=18,4,DP=22,GQ=70,PL=70,0,510\tGD501176201\n" +
            "chr1\t102664\tA\tG\t1\t0.444\t9\t93\tPASS\t0.0\tAlt=G:GT=0/1,AD=5,4,DP=9,GQ=93,PL=93,0,132\tGD501182501\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t6\t46\tPASS\t4.771\tAlt=G:GT=0/1,AD=2,4,DP=6,GQ=46,PL=118,0,46\tGD501177601\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t3\t19\tPASS\t4.771\tAlt=G:GT=0/1,AD=1,2,DP=3,GQ=19,PL=62,0,19\tGD501179501\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t6\t47\tPASS\t11.761\tAlt=G:GT=0/1,AD=2,4,DP=6,GQ=47,PL=103,0,47\tGD501175801\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t4\t44\tPASS\t4.771\tAlt=G:GT=0/1,AD=2,2,DP=4,GQ=44,PL=59,0,44\tGD501176501\n" +
            "chr1\t102664\tA\tG\t1\t0.429\t7\t74\tPASS\t3.68\tAlt=G:GT=0/1,AD=4,3,DP=7,GQ=74,PL=82,0,74\tGD501178401\n" +
            "chr1\t102664\tA\tG\t1\t0.444\t9\t106\tPASS\t3.522\tAlt=G:GT=0/1,AD=5,4,DP=9,GQ=99,PL=106,0,140\tGD501108801\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t4\t41\tPASS\t0.0\tAlt=G:GT=0/1,AD=2,2,DP=4,GQ=41,PL=63,0,41\tGD501120801\n" +
            "chr1\t102664\tA\tG\t1\t0.429\t7\t65\tPASS\t15.441\tAlt=G:GT=0/1,AD=4,3,DP=7,GQ=65,PL=65,0,91\tGD501137901\n" +
            "chr1\t102664\tA\tG\t1\t0.364\t11\t110\tPASS\t12.175\tAlt=G:GT=0/1,AD=7,4,DP=11,GQ=99,PL=110,0,180\tGD501139001\n" +
            "chr1\t102664\tA\tG\t1\t0.750\t4\t24\tPASS\t0.0\tAlt=G:GT=0/1,AD=1,3,DP=4,GQ=24,PL=89,0,24\tGD501060501\n" +
            "chr1\t102664\tA\tG\t1\t0.300\t10\t64\tPASS\t7.782\tAlt=G:GT=0/1,AD=7,3,DP=10,GQ=64,PL=64,0,173\tGD501062401\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t4\t12\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,4,DP=4,GQ=12,PL=131,12,0\tGD501061601\n" +
            "chr1\t102664\tA\tG\t1\t0.308\t13\t98\tPASS\t11.553\tAlt=G:GT=0/1,AD=9,4,DP=13,GQ=98,PL=98,0,268\tGD501124801\n" +
            "chr1\t102664\tA\tG\t1\t0.179\t28\t94\tPASS\t8.418\tAlt=G:GT=0/1,AD=23,5,DP=28,GQ=94,PL=94,0,683\tGD501124001\n" +
            "chr1\t102664\tA\tG\t1\t0.444\t9\t109\tPASS\t0.0\tAlt=G:GT=0/1,AD=5,4,DP=9,GQ=99,PL=109,0,139\tGD501060601\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t2\t6\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,2,DP=2,GQ=6,PL=74,6,0\tGD501062001\n" +
            "chr1\t102664\tA\tG\t1\t0.333\t18\t147\tPASS\t14.236\tAlt=G:GT=0/1,AD=12,6,DP=18,GQ=99,PL=147,0,328\tGD501119901\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t6\t53\tPASS\t0.0\tAlt=G:GT=0/1,AD=2,4,DP=6,GQ=53,PL=118,0,53\tGD501124101\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t3\t9\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,3,DP=3,GQ=9,PL=109,9,0\tGD501059201\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t3\t1\tPASS\t0.0\tAlt=G:GT=0/1,AD=1,2,DP=3,GQ=1,PL=63,0,1\tGD501135901\n" +
            "chr1\t102664\tA\tG\t1\t0.375\t8\t86\tPASS\t3.332\tAlt=G:GT=0/1,AD=5,3,DP=8,GQ=86,PL=86,0,143\tGD501120701\n" +
            "chr1\t102664\tA\tG\t1\t0.357\t14\t122\tPASS\t5.88\tAlt=G:GT=0/1,AD=9,5,DP=14,GQ=99,PL=122,0,287\tGD501210601\n" +
            "chr1\t102664\tA\tG\t1\t0.750\t4\t16\tPASS\t6.021\tAlt=G:GT=0/1,AD=1,3,DP=4,GQ=16,PL=79,0,16\tGD501212901\n" +
            "chr1\t102664\tA\tG\t1\t0.375\t8\t79\tPASS\t8.451\tAlt=G:GT=0/1,AD=5,3,DP=8,GQ=79,PL=79,0,123\tGD501202301\n" +
            "chr1\t102664\tA\tG\t1\t0.375\t16\t156\tPASS\t6.317\tAlt=G:GT=0/1,AD=10,6,DP=16,GQ=99,PL=156,0,288\tGD501213201\n" +
            "chr1\t102664\tA\tG\t1\t0.200\t15\t63\tPASS\t2.963\tAlt=G:GT=0/1,AD=12,3,DP=15,GQ=63,PL=63,0,356\tGD501210701\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t3\t9\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,3,DP=3,GQ=9,PL=95,9,0\tGD501199501\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t3\t20\tPASS\t4.771\tAlt=G:GT=0/1,AD=1,2,DP=3,GQ=20,PL=64,0,20\tGD501199101\n" +
            "chr1\t102664\tA\tG\t1\t0.750\t8\t41\tPASS\t0.0\tAlt=G:GT=0/1,AD=2,6,DP=8,GQ=41,PL=191,0,41\tGD501196101\n" +
            "chr1\t102664\tA\tG\t1\t0.714\t7\t35\tPASS\t13.222\tAlt=G:GT=0/1,AD=2,5,DP=7,GQ=35,PL=142,0,35\tGD501195401\n" +
            "chr1\t102664\tA\tG\t1\t0.444\t9\t112\tPASS\t21.004\tAlt=G:GT=0/1,AD=5,4,DP=9,GQ=99,PL=112,0,117\tGD501197701\n" +
            "chr1\t102664\tA\tG\t1\t0.214\t14\t61\tPASS\t5.88\tAlt=G:GT=0/1,AD=11,3,DP=14,GQ=61,PL=61,0,335\tGD501197101\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t8\t87\tPASS\t0.0\tAlt=G:GT=0/1,AD=4,4,DP=8,GQ=87,PL=117,0,87\tGD501199401\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t3\t9\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,3,DP=3,GQ=9,PL=100,9,0\tGD501200601\n" +
            "chr1\t102664\tA\tG\t1\t0.222\t18\t81\tPASS\t9.234\tAlt=G:GT=0/1,AD=14,4,DP=18,GQ=81,PL=81,0,421\tGD501194901\n" +
            "chr1\t102664\tA\tG\t1\t0.179\t39\t114\tPASS\t19.082\tAlt=G:GT=0/1,AD=32,7,DP=39,GQ=99,PL=114,0,909\tGD501201801\n" +
            "chr1\t102664\tA\tG\t1\t0.263\t19\t108\tPASS\t14.88\tAlt=G:GT=0/1,AD=14,5,DP=19,GQ=99,PL=108,0,403\tGD501195701\n" +
            "chr1\t102664\tA\tG\t1\t0.300\t10\t63\tPASS\t3.233\tAlt=G:GT=0/1,AD=7,3,DP=10,GQ=63,PL=63,0,212\tGD501195301\n" +
            "chr1\t102664\tA\tG\t1\t0.212\t33\t146\tPASS\t15.754\tAlt=G:GT=0/1,AD=26,7,DP=33,GQ=99,PL=146,0,726\tGD501199901\n" +
            "chr1\t102664\tA\tG\t1\t0.300\t10\t69\tPASS\t0.0\tAlt=G:GT=0/1,AD=7,3,DP=10,GQ=69,PL=69,0,201\tGD501212601\n" +
            "chr1\t102664\tA\tG\t1\t0.250\t12\t74\tPASS\t3.09\tAlt=G:GT=0/1,AD=9,3,DP=12,GQ=74,PL=74,0,261\tGD501197601\n" +
            "chr1\t102664\tA\tG\t1\t0.182\t22\t64\tPASS\t15.42\tAlt=G:GT=0/1,AD=18,4,DP=22,GQ=64,PL=64,0,541\tGD501198201\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t8\t97\tPASS\t3.68\tAlt=G:GT=0/1,AD=4,4,DP=8,GQ=97,PL=108,0,97\tGD501164501\n" +
            "chr1\t102664\tA\tG\t1\t0.208\t24\t81\tPASS\t1.999\tAlt=G:GT=0/1,AD=19,5,DP=24,GQ=81,PL=81,0,545\tGD501164901\n" +
            "chr1\t102664\tA\tG\t1\t0.333\t9\t84\tPASS\t13.222\tAlt=G:GT=0/1,AD=6,3,DP=9,GQ=84,PL=84,0,145\tGD501170501\n" +
            "chr1\t102664\tA\tG\t1\t0.222\t18\t76\tPASS\t10.386\tAlt=G:GT=0/1,AD=14,4,DP=18,GQ=76,PL=76,0,407\tGD501168601\n" +
            "chr1\t102664\tA\tG\t1\t0.600\t5\t48\tPASS\t3.979\tAlt=G:GT=0/1,AD=2,3,DP=5,GQ=48,PL=92,0,48\tGD501171201\n" +
            "chr1\t102664\tA\tG\t1\t0.200\t20\t78\tPASS\t5.727\tAlt=G:GT=0/1,AD=16,4,DP=20,GQ=78,PL=78,0,452\tGD501167401\n" +
            "chr1\t102664\tA\tG\t1\t0.250\t12\t74\tPASS\t3.09\tAlt=G:GT=0/1,AD=9,3,DP=12,GQ=74,PL=74,0,235\tGD501169701\n" +
            "chr1\t102664\tA\tG\t1\t0.417\t12\t106\tPASS\t6.892\tAlt=G:GT=0/1,AD=7,5,DP=12,GQ=99,PL=106,0,194\tGD501170801\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t6\t51\tPASS\t0.0\tAlt=G:GT=0/1,AD=2,4,DP=6,GQ=51,PL=106,0,51\tGD501166601\n" +
            "chr1\t102664\tA\tG\t1\t0.750\t4\t16\tPASS\t6.021\tAlt=G:GT=0/1,AD=1,3,DP=4,GQ=16,PL=90,0,16\tGD501167801\n" +
            "chr1\t102664\tA\tG\t1\t0.714\t7\t44\tPASS\t0.0\tAlt=G:GT=0/1,AD=2,5,DP=7,GQ=44,PL=155,0,44\tGD501171101\n" +
            "chr1\t102664\tA\tG\t1\t0.158\t57\t144\tPASS\t20.387\tAlt=G:GT=0/1,AD=48,9,DP=57,GQ=99,PL=144,0,1409\tGD501169601\n" +
            "chr1\t102664\tA\tG\t1\t0.182\t22\t78\tPASS\t9.394\tAlt=G:GT=0/1,AD=18,4,DP=22,GQ=78,PL=78,0,489\tGD501169201\n" +
            "chr1\t102664\tA\tG\t1\t0.143\t28\t60\tPASS\t5.305\tAlt=G:GT=0/1,AD=24,4,DP=28,GQ=60,PL=60,0,721\tGD501165801\n" +
            "chr1\t102664\tA\tG\t1\t0.250\t20\t107\tPASS\t14.88\tAlt=G:GT=0/1,AD=15,5,DP=20,GQ=99,PL=107,0,435\tGD501163501\n" +
            "chr1\t102664\tA\tG\t1\t0.235\t17\t89\tPASS\t2.667\tAlt=G:GT=0/1,AD=13,4,DP=17,GQ=89,PL=89,0,341\tGD501173201\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t4\t52\tPASS\t0.0\tAlt=G:GT=0/1,AD=2,2,DP=4,GQ=52,PL=62,0,52\tGD501169101\n" +
            "chr1\t102664\tA\tG\t1\t0.156\t32\t69\tPASS\t8.609\tAlt=G:GT=0/1,AD=27,5,DP=32,GQ=69,PL=69,0,794\tGD501273101\n" +
            "chr1\t102664\tA\tG\t1\t0.250\t12\t70\tPASS\t7.404\tAlt=G:GT=0/1,AD=9,3,DP=12,GQ=70,PL=70,0,258\tGD501258101\n" +
            "chr1\t102664\tA\tG\t1\t0.250\t12\t61\tPASS\t7.404\tAlt=G:GT=0/1,AD=9,3,DP=12,GQ=61,PL=61,0,293\tGD501272801\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t3\t9\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,3,DP=3,GQ=9,PL=112,9,0\tGD501266701\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t3\t18\tPASS\t4.771\tAlt=G:GT=0/1,AD=1,2,DP=3,GQ=18,PL=65,0,18\tGD501264601\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t4\t12\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,4,DP=4,GQ=12,PL=140,12,0\tGD501264101\n" +
            "chr1\t102664\tA\tG\t1\t0.250\t16\t83\tPASS\t2.331\tAlt=G:GT=0/1,AD=12,4,DP=16,GQ=83,PL=83,0,345\tGD501265401\n" +
            "chr1\t102664\tA\tG\t1\t0.400\t5\t59\tPASS\t0.0\tAlt=G:GT=0/1,AD=3,2,DP=5,GQ=59,PL=59,0,88\tGD501261201\n" +
            "chr1\t102664\tA\tG\t1\t0.211\t19\t88\tPASS\t6.107\tAlt=G:GT=0/1,AD=15,4,DP=19,GQ=88,PL=88,0,453\tGD501263501\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t4\t45\tPASS\t0.0\tAlt=G:GT=0/1,AD=2,2,DP=4,GQ=45,PL=63,0,45\tGD501266501\n" +
            "chr1\t102664\tA\tG\t1\t0.250\t12\t73\tPASS\t7.404\tAlt=G:GT=0/1,AD=9,3,DP=12,GQ=73,PL=73,0,267\tGD501260601\n" +
            "chr1\t102664\tA\tG\t1\t0.400\t5\t60\tPASS\t3.979\tAlt=G:GT=0/1,AD=3,2,DP=5,GQ=60,PL=60,0,68\tGD501410101\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t2\t6\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,2,DP=2,GQ=6,PL=67,6,0\tGD501410501\n" +
            "chr1\t102664\tA\tG\t1\t0.750\t4\t18\tPASS\t6.021\tAlt=G:GT=0/1,AD=1,3,DP=4,GQ=18,PL=92,0,18\tGD501415901\n" +
            "chr1\t102664\tA\tG\t1\t0.333\t12\t115\tPASS\t3.09\tAlt=G:GT=0/1,AD=8,4,DP=12,GQ=99,PL=115,0,224\tGD501409201\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t4\t44\tPASS\t0.0\tAlt=G:GT=0/1,AD=2,2,DP=4,GQ=44,PL=62,0,44\tGD501414801\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t8\t107\tPASS\t0.0\tAlt=G:GT=0/1,AD=4,4,DP=8,GQ=99,PL=107,0,113\tGD501410601\n" +
            "chr1\t102664\tA\tG\t1\t0.217\t23\t119\tPASS\t9.132\tAlt=G:GT=0/1,AD=18,5,DP=23,GQ=99,PL=119,0,520\tGD501414001\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t4\t12\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,4,DP=4,GQ=12,PL=140,12,0\tGD501412101\n" +
            "chr1\t102664\tA\tG\t1\t0.176\t34\t121\tPASS\t26.511\tAlt=G:GT=0/1,AD=28,6,DP=34,GQ=99,PL=121,0,862\tGD501408801\n" +
            "chr1\t102664\tA\tG\t1\t0.400\t5\t59\tPASS\t3.979\tAlt=G:GT=0/1,AD=3,2,DP=5,GQ=59,PL=59,0,71\tGD501415701\n" +
            "chr1\t102664\tA\tG\t1\t0.192\t26\t74\tPASS\t4.925\tAlt=G:GT=0/1,AD=21,5,DP=26,GQ=74,PL=74,0,556\tGD501415301\n" +
            "chr1\t102664\tA\tG\t1\t0.375\t8\t76\tPASS\t3.332\tAlt=G:GT=0/1,AD=5,3,DP=8,GQ=76,PL=76,0,101\tGD501418401\n" +
            "chr1\t102664\tA\tG\t1\t0.333\t12\t83\tPASS\t10.925\tAlt=G:GT=0/1,AD=8,4,DP=12,GQ=83,PL=83,0,194\tGD501411201\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t3\t18\tPASS\t4.771\tAlt=G:GT=0/1,AD=1,2,DP=3,GQ=18,PL=59,0,18\tGD501415801\n" +
            "chr1\t102664\tA\tG\t1\t0.750\t4\t16\tPASS\t0.0\tAlt=G:GT=0/1,AD=1,3,DP=4,GQ=16,PL=82,0,16\tGD501415001\n" +
            "chr1\t102664\tA\tG\t1\t0.444\t9\t101\tPASS\t3.522\tAlt=G:GT=0/1,AD=5,4,DP=9,GQ=99,PL=101,0,131\tGD501233601\n" +
            "chr1\t102664\tA\tG\t1\t0.400\t5\t59\tPASS\t3.979\tAlt=G:GT=0/1,AD=3,2,DP=5,GQ=59,PL=59,0,69\tGD501237401\n" +
            "chr1\t102664\tA\tG\t1\t0.375\t8\t78\tPASS\t7.068\tAlt=G:GT=0/1,AD=5,3,DP=8,GQ=78,PL=78,0,99\tGD501235101\n" +
            "chr1\t102664\tA\tG\t1\t0.400\t10\t105\tPASS\t11.181\tAlt=G:GT=0/1,AD=6,4,DP=10,GQ=99,PL=105,0,155\tGD501241901\n" +
            "chr1\t102664\tA\tG\t1\t0.200\t20\t73\tPASS\t9.332\tAlt=G:GT=0/1,AD=16,4,DP=20,GQ=73,PL=73,0,454\tGD501243401\n" +
            "chr1\t102664\tA\tG\t1\t0.200\t15\t61\tPASS\t2.869\tAlt=G:GT=0/1,AD=12,3,DP=15,GQ=61,PL=61,0,367\tGD501235801\n" +
            "chr1\t102664\tA\tG\t1\t0.217\t23\t113\tPASS\t9.132\tAlt=G:GT=0/1,AD=18,5,DP=23,GQ=99,PL=113,0,503\tGD501235401\n" +
            "chr1\t102664\tA\tG\t1\t0.250\t16\t81\tPASS\t17.16\tAlt=G:GT=0/1,AD=12,4,DP=16,GQ=81,PL=81,0,339\tGD501236501\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t6\t65\tPASS\t3.979\tAlt=G:GT=0/1,AD=3,3,DP=6,GQ=65,PL=69,0,65\tGD501242401\n" +
            "chr1\t102664\tA\tG\t1\t0.375\t8\t76\tPASS\t8.451\tAlt=G:GT=0/1,AD=5,3,DP=8,GQ=76,PL=76,0,115\tGD501240101\n" +
            "chr1\t102664\tA\tG\t1\t0.174\t23\t63\tPASS\t2.682\tAlt=G:GT=0/1,AD=19,4,DP=23,GQ=63,PL=63,0,557\tGD501234101\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t3\t29\tPASS\t4.771\tAlt=G:GT=0/1,AD=1,2,DP=3,GQ=29,PL=63,0,29\tGD501236401\n" +
            "chr1\t102664\tA\tG\t1\t0.278\t18\t119\tPASS\t9.944\tAlt=G:GT=0/1,AD=13,5,DP=18,GQ=99,PL=119,0,350\tGD501243901\n" +
            "chr1\t102664\tA\tG\t1\t0.600\t5\t40\tPASS\t10.0\tAlt=G:GT=0/1,AD=2,3,DP=5,GQ=40,PL=87,0,40\tGD501242301\n" +
            "chr1\t102664\tA\tG\t1\t0.263\t19\t121\tPASS\t14.88\tAlt=G:GT=0/1,AD=14,5,DP=19,GQ=99,PL=121,0,395\tGD501234901\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t6\t73\tPASS\t3.979\tAlt=G:GT=0/1,AD=3,3,DP=6,GQ=73,PL=85,0,73\tGD501236301\n" +
            "chr1\t102664\tA\tG\t1\t0.750\t4\t15\tPASS\t6.021\tAlt=G:GT=0/1,AD=1,3,DP=4,GQ=15,PL=100,0,15\tGD501239401\n" +
            "chr1\t102664\tA\tG\t1\t0.714\t7\t34\tPASS\t13.222\tAlt=G:GT=0/1,AD=2,5,DP=7,GQ=34,PL=164,0,34\tGD501191301\n" +
            "chr1\t102664\tA\tG\t1\t0.750\t4\t15\tPASS\t6.021\tAlt=G:GT=0/1,AD=1,3,DP=4,GQ=15,PL=91,0,15\tGD501187401\n" +
            "chr1\t102664\tA\tG\t1\t0.132\t38\t65\tPASS\t13.341\tAlt=G:GT=0/1,AD=33,5,DP=38,GQ=65,PL=65,0,980\tGD501190001\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t2\t6\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,2,DP=2,GQ=6,PL=72,6,0\tGD501190401\n" +
            "chr1\t102664\tA\tG\t1\t0.800\t5\t13\tPASS\t6.99\tAlt=G:GT=0/1,AD=1,4,DP=5,GQ=13,PL=128,0,13\tGD501188601\n" +
            "chr1\t102664\tA\tG\t1\t0.200\t15\t62\tPASS\t13.57\tAlt=G:GT=0/1,AD=12,3,DP=15,GQ=62,PL=62,0,323\tGD501192201\n" +
            "chr1\t102664\tA\tG\t1\t0.190\t21\t72\tPASS\t8.822\tAlt=G:GT=0/1,AD=17,4,DP=21,GQ=72,PL=72,0,439\tGD501188501\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t6\t68\tPASS\t0.0\tAlt=G:GT=0/1,AD=3,3,DP=6,GQ=68,PL=92,0,68\tGD501193801\n" +
            "chr1\t102664\tA\tG\t1\t0.200\t15\t64\tPASS\t13.57\tAlt=G:GT=0/1,AD=12,3,DP=15,GQ=64,PL=64,0,329\tGD501191101\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t3\t9\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,3,DP=3,GQ=9,PL=101,9,0\tGD501186901\n" +
            "chr1\t102664\tA\tG\t1\t0.750\t4\t12\tPASS\t6.021\tAlt=G:GT=0/1,AD=1,3,DP=4,GQ=12,PL=82,0,12\tGD501192901\n" +
            "chr1\t102664\tA\tG\t1\t0.400\t5\t52\tPASS\t0.0\tAlt=G:GT=0/1,AD=3,2,DP=5,GQ=52,PL=60,0,52\tGD501186101\n" +
            "chr1\t102664\tA\tG\t1\t0.750\t4\t15\tPASS\t6.021\tAlt=G:GT=0/1,AD=1,3,DP=4,GQ=15,PL=88,0,15\tGD501191801\n" +
            "chr1\t102664\tA\tG\t1\t0.750\t4\t25\tPASS\t0.0\tAlt=G:GT=0/1,AD=1,3,DP=4,GQ=25,PL=80,0,25\tGD501437701\n" +
            "chr1\t102664\tA\tG\t1\t0.214\t14\t68\tPASS\t19.59\tAlt=G:GT=0/1,AD=11,3,DP=14,GQ=68,PL=68,0,338\tGD501436501\n" +
            "chr1\t102664\tA\tG\t1\t0.235\t17\t82\tPASS\t15.315\tAlt=G:GT=0/1,AD=13,4,DP=17,GQ=82,PL=82,0,354\tGD501430401\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t3\t9\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,3,DP=3,GQ=9,PL=103,9,0\tGD501436101\n" +
            "chr1\t102664\tA\tG\t1\t0.143\t35\t67\tPASS\t8.503\tAlt=G:GT=0/1,AD=30,5,DP=35,GQ=67,PL=67,0,864\tGD501430801\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t2\t6\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,2,DP=2,GQ=6,PL=76,6,0\tGD501431501\n" +
            "chr1\t102664\tA\tG\t1\t0.231\t13\t60\tPASS\t6.368\tAlt=G:GT=0/1,AD=10,3,DP=13,GQ=60,PL=60,0,298\tGD501436001\n" +
            "chr1\t102664\tA\tG\t1\t0.600\t5\t38\tPASS\t3.979\tAlt=G:GT=0/1,AD=2,3,DP=5,GQ=38,PL=91,0,38\tGD501437901\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t3\t9\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,3,DP=3,GQ=9,PL=102,9,0\tGD501438201\n" +
            "chr1\t102664\tA\tG\t1\t0.200\t20\t89\tPASS\t10.263\tAlt=G:GT=0/1,AD=16,4,DP=20,GQ=89,PL=89,0,419\tGD501438601\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t3\t19\tPASS\t0.0\tAlt=G:GT=0/1,AD=1,2,DP=3,GQ=19,PL=64,0,19\tGD501432901\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t4\t53\tPASS\t0.0\tAlt=G:GT=0/1,AD=2,2,DP=4,GQ=53,PL=62,0,53\tGD501437801\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t6\t76\tPASS\t3.979\tAlt=G:GT=0/1,AD=3,3,DP=6,GQ=76,PL=85,0,76\tGD501435501\n" +
            "chr1\t102664\tA\tG\t1\t0.800\t5\t19\tPASS\t0.0\tAlt=G:GT=0/1,AD=1,4,DP=5,GQ=19,PL=134,0,19\tGD501437401\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t3\t9\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,3,DP=3,GQ=9,PL=112,9,0\tGD501429401\n" +
            "chr1\t102664\tA\tG\t1\t0.214\t14\t61\tPASS\t6.803\tAlt=G:GT=0/1,AD=11,3,DP=14,GQ=61,PL=61,0,330\tGD501017901\n" +
            "chr1\t102664\tA\tG\t1\t0.833\t6\t9\tPASS\t7.782\tAlt=G:GT=0/1,AD=1,5,DP=6,GQ=9,PL=147,0,9\tGD501055101\n" +
            "chr1\t102664\tA\tG\t1\t0.313\t16\t121\tPASS\t6.117\tAlt=G:GT=0/1,AD=11,5,DP=16,GQ=99,PL=121,0,281\tGD501054801\n" +
            "chr1\t102664\tA\tG\t1\t0.375\t8\t83\tPASS\t7.068\tAlt=G:GT=0/1,AD=5,3,DP=8,GQ=83,PL=83,0,140\tGD500795001\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t6\t85\tPASS\t3.979\tAlt=G:GT=0/1,AD=3,3,DP=6,GQ=85,PL=92,0,85\tGD501054301\n" +
            "chr1\t102664\tA\tG\t1\t0.273\t11\t68\tPASS\t7.404\tAlt=G:GT=0/1,AD=8,3,DP=11,GQ=68,PL=68,0,218\tGD500929901\n" +
            "chr1\t102664\tA\tG\t1\t0.417\t12\t113\tPASS\t15.563\tAlt=G:GT=0/1,AD=7,5,DP=12,GQ=99,PL=113,0,149\tGD500796101\n" +
            "chr1\t102664\tA\tG\t1\t0.375\t8\t82\tPASS\t3.332\tAlt=G:GT=0/1,AD=5,3,DP=8,GQ=82,PL=82,0,133\tGD501017801\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t6\t44\tPASS\t4.771\tAlt=G:GT=0/1,AD=2,4,DP=6,GQ=44,PL=108,0,44\tGD500796901\n" +
            "chr1\t102664\tA\tG\t1\t0.417\t12\t152\tPASS\t3.282\tAlt=G:GT=0/1,AD=7,5,DP=12,GQ=99,PL=152,0,204\tGD500791101\n" +
            "chr1\t102664\tA\tG\t1\t0.429\t7\t91\tPASS\t8.451\tAlt=G:GT=0/1,AD=4,3,DP=7,GQ=91,PL=91,0,96\tGD500929801\n" +
            "chr1\t102664\tA\tG\t1\t0.600\t5\t48\tPASS\t3.979\tAlt=G:GT=0/1,AD=2,3,DP=5,GQ=48,PL=94,0,48\tGD501054601\n" +
            "chr1\t102664\tA\tG\t1\t0.375\t8\t67\tPASS\t8.451\tAlt=G:GT=0/1,AD=5,3,DP=8,GQ=67,PL=67,0,145\tGD501018001\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t6\t64\tPASS\t10.0\tAlt=G:GT=0/1,AD=3,3,DP=6,GQ=64,PL=85,0,64\tGD500927001\n" +
            "chr1\t102664\tA\tG\t1\t0.273\t22\t128\tPASS\t13.365\tAlt=G:GT=0/1,AD=16,6,DP=22,GQ=99,PL=128,0,482\tGD500796701\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t3\t9\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,3,DP=3,GQ=9,PL=92,9,0\tGD500931401\n" +
            "chr1\t102664\tA\tG\t1\t0.600\t5\t39\tPASS\t3.979\tAlt=G:GT=0/1,AD=2,3,DP=5,GQ=39,PL=96,0,39\tGD500984801\n" +
            "chr1\t102664\tA\tG\t1\t0.400\t5\t59\tPASS\t0.0\tAlt=G:GT=0/1,AD=3,2,DP=5,GQ=59,PL=59,0,88\tGD500929201\n" +
            "chr1\t102664\tA\tG\t1\t0.235\t17\t89\tPASS\t9.874\tAlt=G:GT=0/1,AD=13,4,DP=17,GQ=89,PL=89,0,340\tGD501607901\n" +
            "chr1\t102664\tA\tG\t1\t0.750\t4\t18\tPASS\t6.021\tAlt=G:GT=0/1,AD=1,3,DP=4,GQ=18,PL=83,0,18\tGD501567401\n" +
            "chr1\t102664\tA\tG\t1\t0.750\t4\t17\tPASS\t6.021\tAlt=G:GT=0/1,AD=1,3,DP=4,GQ=17,PL=100,0,17\tGD501442101\n" +
            "chr1\t102664\tA\tG\t1\t0.400\t5\t59\tPASS\t0.0\tAlt=G:GT=0/1,AD=3,2,DP=5,GQ=59,PL=59,0,86\tGD501440201\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t3\t20\tPASS\t0.0\tAlt=G:GT=0/1,AD=1,2,DP=3,GQ=20,PL=65,0,20\tGD501441301\n" +
            "chr1\t102664\tA\tG\t1\t0.231\t26\t124\tPASS\t11.977\tAlt=G:GT=0/1,AD=20,6,DP=26,GQ=99,PL=124,0,590\tGD501567101\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t3\t9\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,3,DP=3,GQ=9,PL=107,9,0\tGD501608301\n" +
            "chr1\t102664\tA\tG\t1\t0.600\t5\t41\tPASS\t3.979\tAlt=G:GT=0/1,AD=2,3,DP=5,GQ=41,PL=85,0,41\tGD501440101\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t6\t70\tPASS\t3.979\tAlt=G:GT=0/1,AD=3,3,DP=6,GQ=70,PL=83,0,70\tGD501440501\n" +
            "chr1\t102664\tA\tG\t1\t0.833\t6\t19\tPASS\t0.0\tAlt=G:GT=0/1,AD=1,5,DP=6,GQ=19,PL=161,0,19\tGD501442001\n" +
            "chr1\t102664\tA\tG\t1\t0.600\t5\t50\tPASS\t3.979\tAlt=G:GT=0/1,AD=2,3,DP=5,GQ=50,PL=89,0,50\tGD501567201\n" +
            "chr1\t102664\tA\tG\t1\t0.214\t14\t62\tPASS\t6.803\tAlt=G:GT=0/1,AD=11,3,DP=14,GQ=62,PL=62,0,319\tGD501440001\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t10\t133\tPASS\t3.522\tAlt=G:GT=0/1,AD=5,5,DP=10,GQ=99,PL=149,0,133\tGD501568001\n" +
            "chr1\t102664\tA\tG\t1\t0.211\t19\t83\tPASS\t14.88\tAlt=G:GT=0/1,AD=15,4,DP=19,GQ=83,PL=83,0,453\tGD501151301\n" +
            "chr1\t102664\tA\tG\t1\t0.192\t26\t99\tPASS\t5.557\tAlt=G:GT=0/1,AD=21,5,DP=26,GQ=99,PL=99,0,592\tGD501142701\n" +
            "chr1\t102664\tA\tG\t1\t0.333\t9\t81\tPASS\t3.01\tAlt=G:GT=0/1,AD=6,3,DP=9,GQ=81,PL=81,0,159\tGD501150101\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t6\t36\tPASS\t11.761\tAlt=G:GT=0/1,AD=2,4,DP=6,GQ=36,PL=115,0,36\tGD501150901\n" +
            "chr1\t102664\tA\tG\t1\t0.857\t7\t8\tPASS\t8.451\tAlt=G:GT=0/1,AD=1,6,DP=7,GQ=8,PL=174,0,8\tGD501150401\n" +
            "chr1\t102664\tA\tG\t1\t0.162\t37\t91\tPASS\t17.065\tAlt=G:GT=0/1,AD=31,6,DP=37,GQ=91,PL=91,0,918\tGD501145901\n" +
            "chr1\t102664\tA\tG\t1\t0.188\t16\t63\tPASS\t2.933\tAlt=G:GT=0/1,AD=13,3,DP=16,GQ=63,PL=63,0,326\tGD501141301\n" +
            "chr1\t102664\tA\tG\t1\t0.250\t12\t64\tPASS\t17.404\tAlt=G:GT=0/1,AD=9,3,DP=12,GQ=64,PL=64,0,218\tGD501141001\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t6\t46\tPASS\t0.0\tAlt=G:GT=0/1,AD=2,4,DP=6,GQ=46,PL=129,0,46\tGD501140701\n" +
            "chr1\t102664\tA\tG\t1\t0.750\t4\t24\tPASS\t0.0\tAlt=G:GT=0/1,AD=1,3,DP=4,GQ=24,PL=89,0,24\tGD501148701\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t3\t9\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,3,DP=3,GQ=9,PL=107,9,0\tGD501141501\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t3\t9\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,3,DP=3,GQ=9,PL=91,9,0\tGD501424901\n" +
            "chr1\t102664\tA\tG\t1\t0.214\t14\t68\tPASS\t15.611\tAlt=G:GT=0/1,AD=11,3,DP=14,GQ=68,PL=68,0,341\tGD501426401\n" +
            "chr1\t102664\tA\tG\t1\t0.833\t6\t11\tPASS\t7.782\tAlt=G:GT=0/1,AD=1,5,DP=6,GQ=11,PL=154,0,11\tGD501421901\n" +
            "chr1\t102664\tA\tG\t1\t0.273\t11\t69\tPASS\t6.264\tAlt=G:GT=0/1,AD=8,3,DP=11,GQ=69,PL=69,0,216\tGD501423401\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t2\t6\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,2,DP=2,GQ=6,PL=74,6,0\tGD501421501\n" +
            "chr1\t102664\tA\tG\t1\t0.231\t13\t73\tPASS\t2.774\tAlt=G:GT=0/1,AD=10,3,DP=13,GQ=73,PL=73,0,297\tGD501423801\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t8\t91\tPASS\t0.0\tAlt=G:GT=0/1,AD=4,4,DP=8,GQ=91,PL=126,0,91\tGD501425301\n" +
            "chr1\t102664\tA\tG\t1\t0.161\t31\t67\tPASS\t12.366\tAlt=G:GT=0/1,AD=26,5,DP=31,GQ=67,PL=67,0,763\tGD501424601\n" +
            "chr1\t102664\tA\tG\t1\t0.333\t9\t76\tPASS\t13.222\tAlt=G:GT=0/1,AD=6,3,DP=9,GQ=76,PL=76,0,140\tGD501419001\n" +
            "chr1\t102664\tA\tG\t1\t0.208\t24\t114\tPASS\t9.278\tAlt=G:GT=0/1,AD=19,5,DP=24,GQ=99,PL=114,0,528\tGD501423901\n" +
            "chr1\t102664\tA\tG\t1\t0.222\t18\t82\tPASS\t10.386\tAlt=G:GT=0/1,AD=14,4,DP=18,GQ=82,PL=82,0,380\tGD501420901\n" +
            "chr1\t102664\tA\tG\t1\t0.600\t5\t56\tPASS\t0.0\tAlt=G:GT=0/1,AD=2,3,DP=5,GQ=56,PL=87,0,56\tGD501422401\n" +
            "chr1\t102664\tA\tG\t1\t0.833\t6\t10\tPASS\t7.782\tAlt=G:GT=0/1,AD=1,5,DP=6,GQ=10,PL=144,0,10\tGD501419101\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t8\t104\tPASS\t0.0\tAlt=G:GT=0/1,AD=4,4,DP=8,GQ=99,PL=109,0,104\tGD501425101\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t6\t49\tPASS\t0.0\tAlt=G:GT=0/1,AD=2,4,DP=6,GQ=49,PL=120,0,49\tGD501419501\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t6\t35\tPASS\t11.761\tAlt=G:GT=0/1,AD=2,4,DP=6,GQ=35,PL=119,0,35\tGD501428601\n" +
            "chr1\t102664\tA\tG\t1\t0.600\t5\t41\tPASS\t10.0\tAlt=G:GT=0/1,AD=2,3,DP=5,GQ=41,PL=87,0,41\tGD501422101\n" +
            "chr1\t102664\tA\tG\t1\t0.235\t17\t85\tPASS\t5.842\tAlt=G:GT=0/1,AD=13,4,DP=17,GQ=85,PL=85,0,364\tGD501419201\n" +
            "chr1\t102664\tA\tG\t1\t0.250\t16\t85\tPASS\t2.869\tAlt=G:GT=0/1,AD=12,4,DP=16,GQ=85,PL=85,0,385\tGD500759701\n" +
            "chr1\t102664\tA\tG\t1\t0.375\t8\t70\tPASS\t7.068\tAlt=G:GT=0/1,AD=5,3,DP=8,GQ=70,PL=70,0,115\tGD500789801\n" +
            "chr1\t102664\tA\tG\t1\t0.250\t12\t64\tPASS\t7.404\tAlt=G:GT=0/1,AD=9,3,DP=12,GQ=64,PL=64,0,254\tGD500783301\n" +
            "chr1\t102664\tA\tG\t1\t0.750\t4\t17\tPASS\t6.021\tAlt=G:GT=0/1,AD=1,3,DP=4,GQ=17,PL=87,0,17\tGD500787501\n" +
            "chr1\t102664\tA\tG\t1\t0.211\t19\t81\tPASS\t2.754\tAlt=G:GT=0/1,AD=15,4,DP=19,GQ=81,PL=81,0,432\tGD500784001\n" +
            "chr1\t102664\tA\tG\t1\t0.250\t20\t96\tPASS\t9.442\tAlt=G:GT=0/1,AD=15,5,DP=20,GQ=96,PL=96,0,391\tGD500765401\n" +
            "chr1\t102664\tA\tG\t1\t0.200\t20\t80\tPASS\t10.263\tAlt=G:GT=0/1,AD=16,4,DP=20,GQ=80,PL=80,0,477\tGD500767001\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t4\t12\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,4,DP=4,GQ=12,PL=140,12,0\tGD500784701\n" +
            "chr1\t102664\tA\tG\t1\t0.429\t7\t89\tPASS\t0.0\tAlt=G:GT=0/1,AD=4,3,DP=7,GQ=89,PL=89,0,110\tGD500784301\n" +
            "chr1\t102664\tA\tG\t1\t0.273\t11\t67\tPASS\t6.264\tAlt=G:GT=0/1,AD=8,3,DP=11,GQ=67,PL=67,0,233\tGD500767901\n" +
            "chr1\t102664\tA\tG\t1\t0.800\t5\t12\tPASS\t6.99\tAlt=G:GT=0/1,AD=1,4,DP=5,GQ=12,PL=123,0,12\tGD500767501\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t3\t19\tPASS\t0.0\tAlt=G:GT=0/1,AD=1,2,DP=3,GQ=19,PL=63,0,19\tGD500783801\n" +
            "chr1\t102664\tA\tG\t1\t0.190\t21\t66\tPASS\t8.822\tAlt=G:GT=0/1,AD=17,4,DP=21,GQ=66,PL=66,0,469\tGD501229901\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t6\t68\tPASS\t0.0\tAlt=G:GT=0/1,AD=3,3,DP=6,GQ=68,PL=84,0,68\tGD501213601\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t6\t47\tPASS\t4.771\tAlt=G:GT=0/1,AD=2,4,DP=6,GQ=47,PL=114,0,47\tGD501220301\n" +
            "chr1\t102664\tA\tG\t1\t0.235\t17\t88\tPASS\t18.325\tAlt=G:GT=0/1,AD=13,4,DP=17,GQ=88,PL=88,0,333\tGD501221001\n" +
            "chr1\t102664\tA\tG\t1\t0.182\t22\t81\tPASS\t10.16\tAlt=G:GT=0/1,AD=18,4,DP=22,GQ=81,PL=81,0,473\tGD501230901\n" +
            "chr1\t102664\tA\tG\t1\t0.800\t5\t14\tPASS\t6.99\tAlt=G:GT=0/1,AD=1,4,DP=5,GQ=14,PL=106,0,14\tGD501230001\n" +
            "chr1\t102664\tA\tG\t1\t0.429\t7\t78\tPASS\t0.0\tAlt=G:GT=0/1,AD=4,3,DP=7,GQ=78,PL=78,0,102\tGD501214201\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t2\t6\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,2,DP=2,GQ=6,PL=71,6,0\tGD501231101\n" +
            "chr1\t102664\tA\tG\t1\t0.235\t17\t82\tPASS\t9.874\tAlt=G:GT=0/1,AD=13,4,DP=17,GQ=82,PL=82,0,397\tGD501222801\n" +
            "chr1\t102664\tA\tG\t1\t0.429\t7\t85\tPASS\t0.0\tAlt=G:GT=0/1,AD=4,3,DP=7,GQ=85,PL=85,0,114\tGD501221601\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t5\t15\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,5,DP=5,GQ=15,PL=168,15,0\tGD501223501\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t4\t53\tPASS\t0.0\tAlt=G:GT=0/1,AD=2,2,DP=4,GQ=53,PL=60,0,53\tGD501230201\n" +
            "chr1\t102664\tA\tG\t1\t0.750\t4\t16\tPASS\t6.021\tAlt=G:GT=0/1,AD=1,3,DP=4,GQ=16,PL=88,0,16\tGD501232101\n" +
            "chr1\t102664\tA\tG\t1\t0.148\t27\t62\tPASS\t13.9\tAlt=G:GT=0/1,AD=23,4,DP=27,GQ=62,PL=62,0,660\tGD501222301\n" +
            "chr1\t102664\tA\tG\t1\t0.714\t7\t41\tPASS\t5.441\tAlt=G:GT=0/1,AD=2,5,DP=7,GQ=41,PL=148,0,41\tGD501395801\n" +
            "chr1\t102664\tA\tG\t1\t0.214\t14\t60\tPASS\t5.88\tAlt=G:GT=0/1,AD=11,3,DP=14,GQ=60,PL=60,0,295\tGD501386601\n" +
            "chr1\t102664\tA\tG\t1\t0.750\t4\t16\tPASS\t6.021\tAlt=G:GT=0/1,AD=1,3,DP=4,GQ=16,PL=91,0,16\tGD501275501\n" +
            "chr1\t102664\tA\tG\t1\t0.600\t10\t71\tPASS\t0.0\tAlt=G:GT=0/1,AD=4,6,DP=10,GQ=71,PL=175,0,71\tGD501387701\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t4\t34\tPASS\t0.0\tAlt=G:GT=0/1,AD=2,2,DP=4,GQ=34,PL=62,0,34\tGD501276601\n" +
            "chr1\t102664\tA\tG\t1\t0.182\t33\t100\tPASS\t17.351\tAlt=G:GT=0/1,AD=27,6,DP=33,GQ=99,PL=100,0,782\tGD501386501\n" +
            "chr1\t102664\tA\tG\t2\t1.000\t2\t6\tPASS\t0.0\tAlt=G:GT=1/1,AD=0,2,DP=2,GQ=6,PL=64,6,0\tGD501275201\n" +
            "chr1\t102664\tA\tG\t1\t0.667\t3\t20\tPASS\t0.0\tAlt=G:GT=0/1,AD=1,2,DP=3,GQ=20,PL=65,0,20\tGD501385801\n" +
            "chr1\t102664\tA\tG\t1\t0.833\t6\t9\tPASS\t7.782\tAlt=G:GT=0/1,AD=1,5,DP=6,GQ=9,PL=139,0,9\tGD501387601\n" +
            "chr1\t102664\tA\tG\t1\t0.214\t14\t65\tPASS\t12.601\tAlt=G:GT=0/1,AD=11,3,DP=14,GQ=65,PL=65,0,297\tGD501276901\n" +
            "chr1\t102664\tA\tG\t1\t0.190\t21\t84\tPASS\t5.518\tAlt=G:GT=0/1,AD=17,4,DP=21,GQ=84,PL=84,0,479\tGD501274101\n" +
            "chr1\t102664\tA\tG\t1\t0.500\t4\t56\tPASS\t0.0\tAlt=G:GT=0/1,AD=2,2,DP=4,GQ=56,PL=61,0,56\tGD501396201\n";

    String cov = "#chrom\tbpStart\tbpStop\tdistance\tbpStartx\tbpStopx\tPN\tdepth\n" +
            "chr1\t102660\t102670\t0\t97119\t103259\tGD501199901\t10\n" +
            "chr1\t102660\t102670\t0\t98090\t105603\tGD501142701\t10\n" +
            "chr1\t102660\t102670\t0\t98464\t106522\tGD501145901\t10\n" +
            "chr1\t102660\t102670\t0\t98465\t102820\tGD501222301\t10\n" +
            "chr1\t102660\t102670\t0\t98473\t106493\tGD500765401\t10\n" +
            "chr1\t102660\t102670\t0\t98483\t104959\tGD501170801\t10\n" +
            "chr1\t102660\t102670\t0\t98900\t106480\tGD501273101\t10\n" +
            "chr1\t102660\t102670\t0\t99042\t103122\tGD501414001\t10\n" +
            "chr1\t102660\t102670\t0\t99046\t106087\tGD501164901\t10\n" +
            "chr1\t102660\t102670\t0\t99051\t106494\tGD501401401\t10\n" +
            "chr1\t102660\t102670\t0\t99054\t106481\tGD501260601\t10\n" +
            "chr1\t102660\t102670\t0\t99057\t103128\tGD501400101\t10\n" +
            "chr1\t102660\t102670\t0\t99057\t104072\tGD501210701\t10\n" +
            "chr1\t102660\t102670\t0\t99059\t106485\tGD501415301\t10\n" +
            "chr1\t102660\t102670\t0\t99060\t103126\tGD501386501\t10\n" +
            "chr1\t102660\t102670\t0\t99064\t102681\tGD501274101\t10\n" +
            "chr1\t102660\t102670\t0\t99064\t106479\tGD501173201\t10\n" +
            "chr1\t102660\t102670\t0\t99065\t103883\tGD501567101\t10\n" +
            "chr1\t102660\t102670\t0\t99065\t106496\tGD501197101\t10\n" +
            "chr1\t102660\t102670\t0\t99066\t106477\tGD501386601\t10\n" +
            "chr1\t102660\t102670\t0\t99068\t104064\tGD501201801\t10\n" +
            "chr1\t102660\t102670\t0\t99068\t106513\tGD501423401\t10\n" +
            "chr1\t102660\t102670\t0\t99069\t106145\tGD501423901\t10\n" +
            "chr1\t102660\t102670\t0\t99069\t106500\tGD501169201\t10\n" +
            "chr1\t102660\t102670\t0\t99070\t106484\tGD501766901\t10\n" +
            "chr1\t102660\t102670\t0\t99070\t106487\tGD501430401\t10\n" +
            "chr1\t102660\t102670\t0\t99071\t106491\tGD500767001\t10\n" +
            "chr1\t102660\t102670\t0\t99073\t106529\tGD501188501\t10\n" +
            "chr1\t102660\t102670\t0\t99075\t106510\tGD501438601\t10\n" +
            "chr1\t102660\t102670\t0\t99077\t106501\tGD501419201\t10\n" +
            "chr1\t102660\t102670\t0\t99078\t106499\tGD501235801\t10\n" +
            "chr1\t102660\t102670\t0\t99078\t106522\tGD501165801\t10\n" +
            "chr1\t102660\t102670\t0\t99089\t104073\tGD501192201\t10\n" +
            "chr1\t102660\t102670\t0\t99089\t104904\tGD501265401\t10\n" +
            "chr1\t102660\t102670\t0\t99090\t103136\tGD501406301\t10\n" +
            "chr1\t102660\t102670\t0\t99099\t103156\tGD500691101\t10\n" +
            "chr1\t102660\t102670\t0\t99102\t106522\tGD501119901\t10\n" +
            "chr1\t102660\t102670\t0\t99119\t106460\tGD500929901\t10\n" +
            "chr1\t102660\t102670\t0\t99151\t106516\tGD501423801\t10\n" +
            "chr1\t102660\t102670\t0\t99171\t106514\tGD501210601\t10\n" +
            "chr1\t102660\t102670\t0\t99222\t106486\tGD501405301\t10\n" +
            "chr1\t102660\t102670\t0\t99228\t106521\tGD501159301\t10\n" +
            "chr1\t102660\t102670\t0\t99239\t105976\tGD501250201\t10\n" +
            "chr1\t102660\t102670\t0\t99247\t104974\tGD501191101\t10\n" +
            "chr1\t102660\t102670\t0\t99247\t105983\tGD501236501\t10\n" +
            "chr1\t102660\t102670\t0\t99248\t104972\tGD501151301\t10\n" +
            "chr1\t102660\t102670\t0\t99257\t104960\tGD501406501\t10\n" +
            "chr1\t102660\t102670\t0\t99258\t104971\tGD501436501\t10\n" +
            "chr1\t102660\t102670\t0\t99259\t104960\tGD501607901\t10\n" +
            "chr1\t102660\t102670\t0\t99424\t103569\tGD501190001\t10\n" +
            "chr1\t102660\t102670\t0\t99558\t103389\tGD501198201\t10\n" +
            "chr1\t102660\t102670\t0\t99568\t106494\tGD501124801\t10\n" +
            "chr1\t102660\t102670\t0\t99628\t103910\tGD501124001\t10\n" +
            "chr1\t102660\t102670\t0\t99628\t106494\tGD501234901\t10\n" +
            "chr1\t102660\t102670\t0\t99643\t106488\tGD500784001\t10\n" +
            "chr1\t102660\t102670\t0\t99652\t103266\tGD501263501\t10\n" +
            "chr1\t102660\t102670\t0\t99652\t106488\tGD500690901\t10\n" +
            "chr1\t102660\t102670\t0\t99658\t106528\tGD501222801\t10\n" +
            "chr1\t102660\t102670\t0\t99661\t106508\tGD501054801\t10\n" +
            "chr1\t102660\t102670\t0\t100277\t104968\tGD501229901\t10\n" +
            "chr1\t102660\t102670\t0\t100281\t104965\tGD501162901\t10\n" +
            "chr1\t102660\t102670\t0\t100291\t105987\tGD501252401\t10\n" +
            "chr1\t102660\t102670\t0\t101151\t104061\tGD501194901\t10\n" +
            "chr1\t102660\t102670\t0\t101161\t104959\tGD500684501\t10\n" +
            "chr1\t102660\t102670\t0\t101162\t103856\tGD501402701\t10\n" +
            "chr1\t102660\t102670\t0\t101163\t103855\tGD501387701\t10\n" +
            "chr1\t102660\t102670\t0\t101165\t103147\tGD501017901\t10\n" +
            "chr1\t102660\t102670\t0\t101166\t103799\tGD501437801\t10\n" +
            "chr1\t102660\t102670\t0\t101166\t106454\tGD501243901\t10\n" +
            "chr1\t102660\t102670\t0\t101167\t106470\tGD500783301\t10\n" +
            "chr1\t102660\t102670\t0\t101168\t103832\tGD501406701\t10\n" +
            "chr1\t102660\t102670\t0\t101169\t103836\tGD501200601\t10\n" +
            "chr1\t102660\t102670\t0\t101170\t103854\tGD501440501\t10\n" +
            "chr1\t102660\t102670\t0\t101170\t106495\tGD501163501\t10\n" +
            "chr1\t102660\t102670\t0\t101171\t103848\tGD501120701\t10\n" +
            "chr1\t102660\t102670\t0\t101171\t106529\tGD501230901\t10\n" +
            "chr1\t102660\t102670\t0\t101172\t103845\tGD501235101\t10\n" +
            "chr1\t102660\t102670\t0\t101172\t106510\tGD501249001\t10\n" +
            "chr1\t102660\t102670\t0\t101174\t103822\tGD501410601\t10\n" +
            "chr1\t102660\t102670\t0\t101175\t103838\tGD501182501\t10\n" +
            "chr1\t102660\t102670\t0\t101176\t106473\tGD501243401\t10\n" +
            "chr1\t102660\t102670\t0\t101177\t106512\tGD500759701\t10\n" +
            "chr1\t102660\t102670\t0\t101177\t106530\tGD501176201\t10\n" +
            "chr1\t102660\t102670\t0\t101178\t103845\tGD501170501\t10\n" +
            "chr1\t102660\t102670\t0\t101181\t103828\tGD501419501\t10\n" +
            "chr1\t102660\t102670\t0\t101183\t103838\tGD501768801\t10\n" +
            "chr1\t102660\t102670\t0\t101183\t103839\tGD501425301\t10\n" +
            "chr1\t102660\t102670\t0\t101185\t103827\tGD500984801\t10\n" +
            "chr1\t102660\t102670\t0\t101187\t103837\tGD500686901\t10\n" +
            "chr1\t102660\t102670\t0\t101187\t106530\tGD501401601\t10\n" +
            "chr1\t102660\t102670\t0\t101188\t106547\tGD501424601\t10\n" +
            "chr1\t102660\t102670\t0\t101189\t103811\tGD500784301\t10\n" +
            "chr1\t102660\t102670\t0\t101189\t105989\tGD501276901\t10\n" +
            "chr1\t102660\t102670\t0\t101190\t104090\tGD501213201\t10\n" +
            "chr1\t102660\t102670\t0\t101192\t103808\tGD501261201\t10\n" +
            "chr1\t102660\t102670\t0\t101192\t103848\tGD501400501\t10\n" +
            "chr1\t102660\t102670\t0\t101201\t103833\tGD501398301\t10\n" +
            "chr1\t102660\t102670\t0\t101213\t104107\tGD501235401\t10\n" +
            "chr1\t102660\t102670\t0\t101215\t103819\tGD501415901\t10\n" +
            "chr1\t102660\t102670\t0\t101217\t104634\tGD500796701\t10\n" +
            "chr1\t102660\t102670\t0\t101429\t102987\tGD501404801\t10\n" +
            "chr1\t102660\t102670\t0\t101442\t106473\tGD501244801\t10\n" +
            "chr1\t102660\t102670\t0\t101535\t106519\tGD501430801\t10\n" +
            "chr1\t102660\t102670\t0\t101546\t106512\tGD501167401\t10\n" +
            "chr1\t102660\t102670\t0\t101550\t103130\tGD501179201\t10\n" +
            "chr1\t102660\t102670\t0\t101550\t106518\tGD501234101\t10\n" +
            "chr1\t102660\t102670\t0\t101551\t106468\tGD501141301\t10\n" +
            "chr1\t102660\t102670\t0\t101554\t106480\tGD501420901\t10\n" +
            "chr1\t102660\t102670\t0\t101554\t106525\tGD501250001\t10\n" +
            "chr1\t102660\t102670\t0\t101555\t106334\tGD501258101\t10\n" +
            "chr1\t102660\t102670\t0\t101558\t106540\tGD501195701\t10\n" +
            "chr1\t102660\t102670\t0\t101565\t103136\tGD501221001\t10\n" +
            "chr1\t102660\t102670\t0\t101566\t103148\tGD501408801\t10\n" +
            "chr1\t102660\t102670\t0\t101566\t106509\tGD501168601\t10\n" +
            "chr1\t102660\t102670\t0\t102087\t106392\tGD501158601\t10\n" +
            "chr1\t102660\t102670\t0\t102134\t104948\tGD501221601\t10\n" +
            "chr1\t102660\t102670\t0\t102135\t103822\tGD501060601\t10\n" +
            "chr1\t102660\t102670\t0\t102138\t103431\tGD500752101\t10\n" +
            "chr1\t102660\t102670\t0\t102138\t103837\tGD501399601\t10\n" +
            "chr1\t102660\t102670\t0\t102138\t103855\tGD501152301\t10\n" +
            "chr1\t102660\t102670\t0\t102139\t103856\tGD501249701\t10\n" +
            "chr1\t102660\t102670\t0\t102139\t104954\tGD500795001\t10\n" +
            "chr1\t102660\t102670\t0\t102140\t103850\tGD501233601\t10\n" +
            "chr1\t102660\t102670\t0\t102141\t103854\tGD501175401\t10\n" +
            "chr1\t102660\t102670\t0\t102142\t103851\tGD501193801\t10\n" +
            "chr1\t102660\t102670\t0\t102143\t103842\tGD501150101\t10\n" +
            "chr1\t102660\t102670\t0\t102144\t103855\tGD501770301\t10\n" +
            "chr1\t102660\t102670\t0\t102146\t103840\tGD501161901\t10\n" +
            "chr1\t102660\t102670\t0\t102147\t103806\tGD501237401\t10\n" +
            "chr1\t102660\t102670\t0\t102147\t104949\tGD501440001\t10\n" +
            "chr1\t102660\t102670\t0\t102148\t103828\tGD501139001\t10\n" +
            "chr1\t102660\t102670\t0\t102148\t103854\tGD501178401\t10\n" +
            "chr1\t102660\t102670\t0\t102149\t103832\tGD501186101\t10\n" +
            "chr1\t102660\t102670\t0\t102149\t103854\tGD501765601\t10\n" +
            "chr1\t102660\t102670\t0\t102150\t103853\tGD501197701\t10\n" +
            "chr1\t102660\t102670\t0\t102151\t103845\tGD501054301\t10\n" +
            "chr1\t102660\t102670\t0\t102151\t104947\tGD500683201\t10\n" +
            "chr1\t102660\t102670\t0\t102151\t105989\tGD501411201\t10\n" +
            "chr1\t102660\t102670\t0\t102152\t103850\tGD501157301\t10\n" +
            "chr1\t102660\t102670\t0\t102152\t104957\tGD501436001\t10\n" +
            "chr1\t102660\t102670\t0\t102153\t103839\tGD501396201\t10\n" +
            "chr1\t102660\t102670\t0\t102153\t103842\tGD501161801\t10\n" +
            "chr1\t102660\t102670\t0\t102153\t103844\tGD501246901\t10\n" +
            "chr1\t102660\t102670\t0\t102154\t103849\tGD501196101\t10\n" +
            "chr1\t102660\t102670\t0\t102155\t103843\tGD501171101\t10\n" +
            "chr1\t102660\t102670\t0\t102156\t103843\tGD501164501\t10\n" +
            "chr1\t102660\t102670\t0\t102157\t104941\tGD501272801\t10\n" +
            "chr1\t102660\t102670\t0\t102157\t104953\tGD500791101\t10\n" +
            "chr1\t102660\t102670\t0\t102158\t104971\tGD501401901\t10\n" +
            "chr1\t102660\t102670\t0\t102160\t102755\tGD501236401\t10\n" +
            "chr1\t102660\t102670\t0\t102160\t103852\tGD501418401\t10\n" +
            "chr1\t102660\t102670\t0\t102161\t103847\tGD501442101\t10\n" +
            "chr1\t102660\t102670\t0\t102162\t103836\tGD501415801\t10\n" +
            "chr1\t102660\t102670\t0\t102162\t103837\tGD501108801\t10\n" +
            "chr1\t102660\t102670\t0\t102162\t104971\tGD500758701\t10\n" +
            "chr1\t102660\t102670\t0\t102164\t104969\tGD501197601\t10\n" +
            "chr1\t102660\t102670\t0\t102166\t103833\tGD501212601\t10\n" +
            "chr1\t102660\t102670\t0\t102169\t103819\tGD500691201\t10\n" +
            "chr1\t102660\t102670\t0\t102169\t103848\tGD501177801\t10\n" +
            "chr1\t102660\t102670\t0\t102169\t103849\tGD501054601\t10\n" +
            "chr1\t102660\t102670\t0\t102178\t103830\tGD501440201\t10\n" +
            "chr1\t102660\t102670\t0\t102328\t103831\tGD501422401\t10\n" +
            "chr1\t102660\t102670\t0\t102334\t103834\tGD501124101\t10\n" +
            "chr1\t102660\t102670\t0\t102334\t105972\tGD500767901\t10\n" +
            "chr1\t102660\t102670\t0\t102335\t103837\tGD501435501\t10\n" +
            "chr1\t102660\t102670\t0\t102336\t103850\tGD501017801\t10\n" +
            "chr1\t102660\t102670\t0\t102337\t103831\tGD500796101\t10\n" +
            "chr1\t102660\t102670\t0\t102337\t104974\tGD501195301\t10\n" +
            "chr1\t102660\t102670\t0\t102340\t103852\tGD501421501\t10\n" +
            "chr1\t102660\t102670\t0\t102341\t103797\tGD500929801\t10\n" +
            "chr1\t102660\t102670\t0\t102341\t103844\tGD500929201\t10\n" +
            "chr1\t102660\t102670\t0\t102341\t103852\tGD501230201\t10\n" +
            "chr1\t102660\t102670\t0\t102344\t103845\tGD501276601\t10\n" +
            "chr1\t102660\t102670\t0\t102344\t106478\tGD501409201\t10\n" +
            "chr1\t102660\t102670\t0\t102346\t103826\tGD501062401\t10\n" +
            "chr1\t102660\t102670\t0\t102347\t103823\tGD501567201\t10\n" +
            "chr1\t102660\t102670\t0\t102347\t103827\tGD501419001\t10\n" +
            "chr1\t102660\t102670\t0\t102347\t103839\tGD501766401\t10\n" +
            "chr1\t102660\t102670\t0\t102348\t103847\tGD501187401\t10\n" +
            "chr1\t102660\t102670\t0\t102348\t103866\tGD501242301\t10\n" +
            "chr1\t102660\t102670\t0\t102349\t103909\tGD501432901\t10\n" +
            "chr1\t102660\t102670\t0\t102349\t104941\tGD501018001\t10\n" +
            "chr1\t102660\t102670\t0\t102350\t103868\tGD501166601\t10\n" +
            "chr1\t102660\t102670\t0\t102351\t103846\tGD501245501\t10\n" +
            "chr1\t102660\t102670\t0\t102353\t103839\tGD501150401\t10\n" +
            "chr1\t102660\t102670\t0\t102354\t103835\tGD501436101\t10\n" +
            "chr1\t102660\t102670\t0\t102354\t103855\tGD501199501\t10\n" +
            "chr1\t102660\t102670\t0\t102355\t102766\tGD501766501\t10\n" +
            "chr1\t102660\t102670\t0\t102355\t103840\tGD500690101\t10\n" +
            "chr1\t102660\t102670\t0\t102356\t103843\tGD501419101\t10\n" +
            "chr1\t102660\t102670\t0\t102357\t103848\tGD501385801\t10\n" +
            "chr1\t102660\t102670\t0\t102358\t103845\tGD501137901\t10\n" +
            "chr1\t102660\t102670\t0\t102360\t103853\tGD501399001\t10\n" +
            "chr1\t102660\t102670\t0\t102362\t103796\tGD500927001\t10\n" +
            "chr1\t102660\t102670\t0\t102362\t103843\tGD501176601\t10\n" +
            "chr1\t102660\t102670\t0\t102362\t103845\tGD501161601\t10\n" +
            "chr1\t102660\t102670\t0\t102363\t103805\tGD501179501\t10\n" +
            "chr1\t102660\t102670\t0\t102364\t103854\tGD501412101\t10\n" +
            "chr1\t102660\t102670\t0\t102366\t103820\tGD501213601\t10\n" +
            "chr1\t102660\t102670\t0\t102367\t103851\tGD501410101\t10\n" +
            "chr1\t102660\t102670\t0\t102368\t103830\tGD501438201\t10\n" +
            "chr1\t102660\t102670\t0\t102368\t103852\tGD501169701\t10\n" +
            "chr1\t102660\t102670\t0\t102369\t102766\tGD501230001\t10\n" +
            "chr1\t102660\t102670\t0\t102369\t103817\tGD501141501\t10\n" +
            "chr1\t102660\t102670\t0\t102369\t103837\tGD501141001\t10\n" +
            "chr1\t102660\t102670\t0\t102370\t102766\tGD501431501\t10\n" +
            "chr1\t102660\t102670\t0\t102370\t103805\tGD500682201\t10\n" +
            "chr1\t102660\t102670\t0\t102370\t103836\tGD501568001\t10\n" +
            "chr1\t102660\t102670\t0\t102370\t103838\tGD501424901\t10\n" +
            "chr1\t102660\t102670\t0\t102371\t102765\tGD501608301\t10\n" +
            "chr1\t102660\t102670\t0\t102371\t103809\tGD501768401\t10\n" +
            "chr1\t102660\t102670\t0\t102371\t103836\tGD501167801\t10\n" +
            "chr1\t102660\t102670\t0\t102371\t103844\tGD501199101\t10\n" +
            "chr1\t102660\t102670\t0\t102371\t103848\tGD501240101\t10\n" +
            "chr1\t102660\t102670\t0\t102372\t103828\tGD501767301\t10\n" +
            "chr1\t102660\t102670\t0\t102372\t103850\tGD501403401\t10\n" +
            "chr1\t102660\t102670\t0\t102373\t103844\tGD501441301\t10\n" +
            "chr1\t102660\t102670\t0\t102374\t103826\tGD501408301\t10\n" +
            "chr1\t102660\t102670\t0\t102375\t103828\tGD501410501\t10\n" +
            "chr1\t102660\t102670\t0\t102375\t103848\tGD501231101\t10\n" +
            "chr1\t102660\t102670\t0\t102376\t103838\tGD500758901\t10\n" +
            "chr1\t102660\t102670\t0\t102376\t103842\tGD501150901\t10\n" +
            "chr1\t102660\t102670\t0\t102378\t103851\tGD501406801\t10\n" +
            "chr1\t102660\t102670\t0\t102378\t103876\tGD501395801\t10\n" +
            "chr1\t102660\t102670\t0\t102379\t103823\tGD501191801\t10\n" +
            "chr1\t102660\t102670\t0\t102380\t102749\tGD501275201\t10\n" +
            "chr1\t102660\t102670\t0\t102380\t103832\tGD501249501\t10\n" +
            "chr1\t102660\t102670\t0\t102380\t103833\tGD501266701\t10\n" +
            "chr1\t102660\t102670\t0\t102380\t103842\tGD501437401\t10\n" +
            "chr1\t102660\t102670\t0\t102380\t103854\tGD501399501\t10\n" +
            "chr1\t102660\t102670\t0\t102381\t103839\tGD501177601\t10\n" +
            "chr1\t102660\t102670\t0\t102381\t103849\tGD501400201\t10\n" +
            "chr1\t102660\t102670\t0\t102383\t103848\tGD501415701\t10\n" +
            "chr1\t102660\t102670\t0\t102384\t102766\tGD501255001\t10\n" +
            "chr1\t102660\t102670\t0\t102384\t102790\tGD501246001\t10\n" +
            "chr1\t102660\t102670\t0\t102384\t103851\tGD501061601\t10\n" +
            "chr1\t102660\t102670\t0\t102385\t103816\tGD501387601\t10\n" +
            "chr1\t102660\t102670\t0\t102385\t103835\tGD500789801\t10\n" +
            "chr1\t102660\t102670\t0\t102386\t103846\tGD501236301\t10\n" +
            "chr1\t102660\t102670\t0\t102387\t102761\tGD501768001\t10\n" +
            "chr1\t102660\t102670\t0\t102387\t103836\tGD501183401\t10\n" +
            "chr1\t102660\t102670\t0\t102387\t103837\tGD501175801\t10\n" +
            "chr1\t102660\t102670\t0\t102387\t103846\tGD500750201\t10\n" +
            "chr1\t102660\t102670\t0\t102387\t103850\tGD501437901\t10\n" +
            "chr1\t102660\t102670\t0\t102389\t102768\tGD501191301\t10\n" +
            "chr1\t102660\t102670\t0\t102389\t103451\tGD501135901\t10\n" +
            "chr1\t102660\t102670\t0\t102390\t103823\tGD500784701\t10\n" +
            "chr1\t102660\t102670\t0\t102390\t103835\tGD501400001\t10\n" +
            "chr1\t102660\t102670\t0\t102392\t103841\tGD501212901\t10\n" +
            "chr1\t102660\t102670\t0\t102393\t103848\tGD501275501\t10\n" +
            "chr1\t102660\t102670\t0\t102393\t104953\tGD501241901\t10\n" +
            "chr1\t102660\t102670\t0\t102394\t103867\tGD501199401\t10\n" +
            "chr1\t102660\t102670\t0\t102395\t103833\tGD500787501\t10\n" +
            "chr1\t102660\t102670\t0\t102395\t103840\tGD501405701\t10\n" +
            "chr1\t102660\t102670\t0\t102397\t103826\tGD501202301\t10\n" +
            "chr1\t102660\t102670\t0\t102397\t103852\tGD501440101\t10\n" +
            "chr1\t102660\t102670\t0\t102399\t103847\tGD500751401\t10\n" +
            "chr1\t102660\t102670\t0\t102401\t103838\tGD501148701\t10\n" +
            "chr1\t102660\t102670\t0\t102401\t103852\tGD501414801\t10\n" +
            "chr1\t102660\t102670\t0\t102402\t103805\tGD501421901\t10\n" +
            "chr1\t102660\t102670\t0\t102403\t103820\tGD501055101\t10\n" +
            "chr1\t102660\t102670\t0\t102405\t103811\tGD500767501\t10\n" +
            "chr1\t102660\t102670\t0\t102405\t103829\tGD501214201\t10\n" +
            "chr1\t102660\t102670\t0\t102409\t102763\tGD501428601\t10\n" +
            "chr1\t102660\t102670\t0\t102410\t103837\tGD501195401\t10\n" +
            "chr1\t102660\t102670\t0\t102411\t102764\tGD501407501\t10\n" +
            "chr1\t102660\t102670\t0\t102411\t103451\tGD501176501\t10\n" +
            "chr1\t102660\t102670\t0\t102411\t103852\tGD501425101\t10\n" +
            "chr1\t102660\t102670\t0\t102412\t102767\tGD501154801\t10\n" +
            "chr1\t102660\t102670\t0\t102415\t103840\tGD501442001\t10\n" +
            "chr1\t102660\t102670\t0\t102416\t103833\tGD501220301\t10\n" +
            "chr1\t102660\t102670\t0\t102417\t103830\tGD501120801\t10\n" +
            "chr1\t102660\t102670\t0\t102418\t103842\tGD501171201\t10\n" +
            "chr1\t102660\t102670\t0\t102420\t103831\tGD501415001\t10\n" +
            "chr1\t102660\t102670\t0\t102423\t103849\tGD501140701\t10\n" +
            "chr1\t102660\t102670\t0\t102428\t103844\tGD501062001\t10\n" +
            "chr1\t102660\t102670\t0\t102429\t103801\tGD500682301\t10\n" +
            "chr1\t102660\t102670\t0\t102430\t103812\tGD501060501\t10\n" +
            "chr1\t102660\t102670\t0\t102431\t103448\tGD501223501\t10\n" +
            "chr1\t102660\t102670\t0\t102447\t103834\tGD501192901\t10\n" +
            "chr1\t102660\t102670\t0\t102449\t103830\tGD501190401\t10\n" +
            "chr1\t102660\t102670\t0\t102462\t103824\tGD500796901\t10\n" +
            "chr1\t102660\t102670\t0\t102463\t106524\tGD501426401\t10\n" +
            "chr1\t102660\t102670\t0\t102472\t103850\tGD501188601\t10\n" +
            "chr1\t102660\t102670\t0\t102481\t103851\tGD501242401\t10\n" +
            "chr1\t102660\t102670\t0\t102484\t103826\tGD501232101\t10\n" +
            "chr1\t102660\t102670\t0\t102512\t103821\tGD501266501\t10\n" +
            "chr1\t102660\t102670\t0\t102515\t103810\tGD501244301\t10\n" +
            "chr1\t102660\t102670\t0\t102534\t102758\tGD501264601\t10\n" +
            "chr1\t102660\t102670\t0\t102534\t102780\tGD500931401\t10\n" +
            "chr1\t102660\t102670\t0\t102535\t102767\tGD501264101\t10\n" +
            "chr1\t102660\t102670\t0\t102548\t103801\tGD501186901\t10\n" +
            "chr1\t102660\t102670\t0\t102548\t103812\tGD501181101\t10\n" +
            "chr1\t102660\t102670\t0\t102557\t103836\tGD500783801\t10\n" +
            "chr1\t102660\t102670\t0\t102562\t103326\tGD500682801\t10\n" +
            "chr1\t102660\t102670\t0\t102562\t103416\tGD501059201\t10\n" +
            "chr1\t102660\t102670\t0\t102563\t103438\tGD501244901\t10\n" +
            "chr1\t102660\t102670\t0\t102571\t103827\tGD501422101\t10\n" +
            "chr1\t102660\t102670\t0\t102579\t103844\tGD501153501\t10\n" +
            "chr1\t102660\t102670\t0\t102599\t102700\tGD501239401\t10\n" +
            "chr1\t102660\t102670\t0\t102600\t103806\tGD501429401\t10\n" +
            "chr1\t102660\t102670\t0\t102603\t103837\tGD501567401\t10\n" +
            "chr1\t102660\t102670\t0\t102604\t102762\tGD501169101\t10\n" +
            "chr1\t102660\t102670\t0\t102637\t103842\tGD501437701\t10\n" +
            "chr1\t102660\t102670\t0\t102651\t102819\tGD501169601\t10\n";

    String buck = "#PN\tbucket\n" +
            "GD500682201\tbucket_1\n" +
            "GD500682301\tbucket_1\n" +
            "GD500682801\tbucket_1\n" +
            "GD500683201\tbucket_1\n" +
            "GD500684501\tbucket_1\n" +
            "GD500686901\tbucket_1\n" +
            "GD500690101\tbucket_1\n" +
            "GD500690901\tbucket_1\n" +
            "GD500691101\tbucket_1\n" +
            "GD500691201\tbucket_1\n" +
            "GD500750201\tbucket_1\n" +
            "GD500751401\tbucket_1\n" +
            "GD500752101\tbucket_1\n" +
            "GD500758701\tbucket_1\n" +
            "GD500758901\tbucket_1\n" +
            "GD500759701\tbucket_1\n" +
            "GD500765401\tbucket_1\n" +
            "GD500767001\tbucket_1\n" +
            "GD500767501\tbucket_1\n" +
            "GD500767901\tbucket_1\n" +
            "GD500783301\tbucket_1\n" +
            "GD500783801\tbucket_1\n" +
            "GD500784001\tbucket_1\n" +
            "GD500784301\tbucket_1\n" +
            "GD500784701\tbucket_1\n" +
            "GD500787501\tbucket_1\n" +
            "GD500789801\tbucket_1\n" +
            "GD500791101\tbucket_1\n" +
            "GD500795001\tbucket_1\n" +
            "GD500796101\tbucket_1\n" +
            "GD500796701\tbucket_1\n" +
            "GD500796901\tbucket_1\n" +
            "GD500927001\tbucket_1\n" +
            "GD500929201\tbucket_1\n" +
            "GD500929801\tbucket_1\n" +
            "GD500929901\tbucket_1\n" +
            "GD500931401\tbucket_1\n" +
            "GD500984801\tbucket_1\n" +
            "GD501017801\tbucket_1\n" +
            "GD501017901\tbucket_1\n" +
            "GD501018001\tbucket_1\n" +
            "GD501054301\tbucket_1\n" +
            "GD501054601\tbucket_1\n" +
            "GD501054801\tbucket_1\n" +
            "GD501055101\tbucket_1\n" +
            "GD501059201\tbucket_1\n" +
            "GD501060501\tbucket_1\n" +
            "GD501060601\tbucket_1\n" +
            "GD501061601\tbucket_1\n" +
            "GD501062001\tbucket_1\n" +
            "GD501062401\tbucket_1\n" +
            "GD501108801\tbucket_1\n" +
            "GD501119901\tbucket_1\n" +
            "GD501120701\tbucket_1\n" +
            "GD501120801\tbucket_1\n" +
            "GD501124001\tbucket_1\n" +
            "GD501124101\tbucket_1\n" +
            "GD501124801\tbucket_1\n" +
            "GD501135901\tbucket_1\n" +
            "GD501137901\tbucket_1\n" +
            "GD501139001\tbucket_1\n" +
            "GD501140701\tbucket_1\n" +
            "GD501141001\tbucket_1\n" +
            "GD501141301\tbucket_1\n" +
            "GD501141501\tbucket_1\n" +
            "GD501142701\tbucket_1\n" +
            "GD501145901\tbucket_1\n" +
            "GD501148701\tbucket_1\n" +
            "GD501150101\tbucket_1\n" +
            "GD501150401\tbucket_1\n" +
            "GD501150901\tbucket_1\n" +
            "GD501151301\tbucket_1\n" +
            "GD501152301\tbucket_1\n" +
            "GD501153501\tbucket_1\n" +
            "GD501154801\tbucket_1\n" +
            "GD501157301\tbucket_1\n" +
            "GD501158601\tbucket_1\n" +
            "GD501159301\tbucket_1\n" +
            "GD501161601\tbucket_1\n" +
            "GD501161801\tbucket_1\n" +
            "GD501161901\tbucket_1\n" +
            "GD501162901\tbucket_1\n" +
            "GD501163501\tbucket_1\n" +
            "GD501164501\tbucket_1\n" +
            "GD501164901\tbucket_1\n" +
            "GD501165801\tbucket_1\n" +
            "GD501166601\tbucket_1\n" +
            "GD501167401\tbucket_1\n" +
            "GD501167801\tbucket_1\n" +
            "GD501168601\tbucket_1\n" +
            "GD501169101\tbucket_1\n" +
            "GD501169201\tbucket_1\n" +
            "GD501169601\tbucket_1\n" +
            "GD501169701\tbucket_1\n" +
            "GD501170501\tbucket_1\n" +
            "GD501170801\tbucket_1\n" +
            "GD501171101\tbucket_1\n" +
            "GD501171201\tbucket_1\n" +
            "GD501173201\tbucket_1\n" +
            "GD501175401\tbucket_1\n" +
            "GD501175801\tbucket_1\n" +
            "GD501176201\tbucket_1\n" +
            "GD501176501\tbucket_1\n" +
            "GD501176601\tbucket_1\n" +
            "GD501177601\tbucket_1\n" +
            "GD501177801\tbucket_1\n" +
            "GD501178401\tbucket_1\n" +
            "GD501179201\tbucket_1\n" +
            "GD501179501\tbucket_1\n" +
            "GD501181101\tbucket_1\n" +
            "GD501182501\tbucket_1\n" +
            "GD501183401\tbucket_1\n" +
            "GD501186101\tbucket_1\n" +
            "GD501186901\tbucket_1\n" +
            "GD501187401\tbucket_1\n" +
            "GD501188501\tbucket_1\n" +
            "GD501188601\tbucket_1\n" +
            "GD501190001\tbucket_1\n" +
            "GD501190401\tbucket_1\n" +
            "GD501191101\tbucket_1\n" +
            "GD501191301\tbucket_1\n" +
            "GD501191801\tbucket_1\n" +
            "GD501192201\tbucket_1\n" +
            "GD501192901\tbucket_1\n" +
            "GD501193801\tbucket_1\n" +
            "GD501194901\tbucket_1\n" +
            "GD501195301\tbucket_1\n" +
            "GD501195401\tbucket_1\n" +
            "GD501195701\tbucket_1\n" +
            "GD501196101\tbucket_1\n" +
            "GD501197101\tbucket_1\n" +
            "GD501197601\tbucket_1\n" +
            "GD501197701\tbucket_1\n" +
            "GD501198201\tbucket_1\n" +
            "GD501199101\tbucket_1\n" +
            "GD501199401\tbucket_1\n" +
            "GD501199501\tbucket_1\n" +
            "GD501199901\tbucket_1\n" +
            "GD501200601\tbucket_1\n" +
            "GD501201801\tbucket_1\n" +
            "GD501202301\tbucket_1\n" +
            "GD501210601\tbucket_1\n" +
            "GD501210701\tbucket_1\n" +
            "GD501212601\tbucket_1\n" +
            "GD501212901\tbucket_1\n" +
            "GD501213201\tbucket_1\n" +
            "GD501213601\tbucket_1\n" +
            "GD501214201\tbucket_1\n" +
            "GD501220301\tbucket_1\n" +
            "GD501221001\tbucket_1\n" +
            "GD501221601\tbucket_1\n" +
            "GD501222301\tbucket_1\n" +
            "GD501222801\tbucket_1\n" +
            "GD501223501\tbucket_1\n" +
            "GD501229901\tbucket_1\n" +
            "GD501230001\tbucket_1\n" +
            "GD501230201\tbucket_1\n" +
            "GD501230901\tbucket_1\n" +
            "GD501231101\tbucket_1\n" +
            "GD501232101\tbucket_1\n" +
            "GD501233601\tbucket_1\n" +
            "GD501234101\tbucket_1\n" +
            "GD501234901\tbucket_1\n" +
            "GD501235101\tbucket_1\n" +
            "GD501235401\tbucket_1\n" +
            "GD501235801\tbucket_1\n" +
            "GD501236301\tbucket_1\n" +
            "GD501236401\tbucket_1\n" +
            "GD501236501\tbucket_1\n" +
            "GD501237401\tbucket_1\n" +
            "GD501239401\tbucket_1\n" +
            "GD501240101\tbucket_1\n" +
            "GD501241901\tbucket_1\n" +
            "GD501242301\tbucket_1\n" +
            "GD501242401\tbucket_1\n" +
            "GD501243401\tbucket_1\n" +
            "GD501243901\tbucket_1\n" +
            "GD501244301\tbucket_1\n" +
            "GD501244801\tbucket_1\n" +
            "GD501244901\tbucket_1\n" +
            "GD501245501\tbucket_1\n" +
            "GD501246001\tbucket_1\n" +
            "GD501246901\tbucket_1\n" +
            "GD501249001\tbucket_1\n" +
            "GD501249501\tbucket_1\n" +
            "GD501249701\tbucket_1\n" +
            "GD501250001\tbucket_1\n" +
            "GD501250201\tbucket_1\n" +
            "GD501252401\tbucket_1\n" +
            "GD501255001\tbucket_1\n" +
            "GD501258101\tbucket_1\n" +
            "GD501260601\tbucket_1\n" +
            "GD501261201\tbucket_1\n" +
            "GD501263501\tbucket_1\n" +
            "GD501264101\tbucket_1\n" +
            "GD501264601\tbucket_1\n" +
            "GD501265401\tbucket_1\n" +
            "GD501266501\tbucket_1\n" +
            "GD501266701\tbucket_1\n" +
            "GD501272801\tbucket_1\n" +
            "GD501273101\tbucket_1\n" +
            "GD501274101\tbucket_1\n" +
            "GD501275201\tbucket_1\n" +
            "GD501275501\tbucket_1\n" +
            "GD501276601\tbucket_1\n" +
            "GD501276901\tbucket_1\n" +
            "GD501385801\tbucket_1\n" +
            "GD501386501\tbucket_1\n" +
            "GD501386601\tbucket_1\n" +
            "GD501387601\tbucket_1\n" +
            "GD501387701\tbucket_1\n" +
            "GD501395801\tbucket_1\n" +
            "GD501396201\tbucket_1\n" +
            "GD501398301\tbucket_1\n" +
            "GD501399001\tbucket_1\n" +
            "GD501399501\tbucket_1\n" +
            "GD501399601\tbucket_1\n" +
            "GD501400001\tbucket_1\n" +
            "GD501400101\tbucket_1\n" +
            "GD501400201\tbucket_1\n" +
            "GD501400501\tbucket_1\n" +
            "GD501401401\tbucket_1\n" +
            "GD501401601\tbucket_1\n" +
            "GD501401901\tbucket_1\n" +
            "GD501402701\tbucket_1\n" +
            "GD501403401\tbucket_1\n" +
            "GD501404801\tbucket_1\n" +
            "GD501405301\tbucket_1\n" +
            "GD501405701\tbucket_1\n" +
            "GD501406301\tbucket_1\n" +
            "GD501406501\tbucket_1\n" +
            "GD501406701\tbucket_1\n" +
            "GD501406801\tbucket_1\n" +
            "GD501407501\tbucket_1\n" +
            "GD501408301\tbucket_1\n" +
            "GD501408801\tbucket_1\n" +
            "GD501409201\tbucket_1\n" +
            "GD501410101\tbucket_1\n" +
            "GD501410501\tbucket_1\n" +
            "GD501410601\tbucket_1\n" +
            "GD501411201\tbucket_1\n" +
            "GD501412101\tbucket_1\n" +
            "GD501414001\tbucket_1\n" +
            "GD501414801\tbucket_1\n" +
            "GD501415001\tbucket_1\n" +
            "GD501415301\tbucket_1\n" +
            "GD501415701\tbucket_1\n" +
            "GD501415801\tbucket_1\n" +
            "GD501415901\tbucket_1\n" +
            "GD501418401\tbucket_1\n" +
            "GD501419001\tbucket_1\n" +
            "GD501419101\tbucket_1\n" +
            "GD501419201\tbucket_1\n" +
            "GD501419501\tbucket_1\n" +
            "GD501420901\tbucket_1\n" +
            "GD501421501\tbucket_1\n" +
            "GD501421901\tbucket_1\n" +
            "GD501422101\tbucket_1\n" +
            "GD501422401\tbucket_1\n" +
            "GD501423401\tbucket_1\n" +
            "GD501423801\tbucket_1\n" +
            "GD501423901\tbucket_1\n" +
            "GD501424601\tbucket_1\n" +
            "GD501424901\tbucket_1\n" +
            "GD501425101\tbucket_1\n" +
            "GD501425301\tbucket_1\n" +
            "GD501426401\tbucket_1\n" +
            "GD501428601\tbucket_1\n" +
            "GD501429401\tbucket_1\n" +
            "GD501430401\tbucket_1\n" +
            "GD501430801\tbucket_1\n" +
            "GD501431501\tbucket_1\n" +
            "GD501432901\tbucket_1\n" +
            "GD501435501\tbucket_1\n" +
            "GD501436001\tbucket_1\n" +
            "GD501436101\tbucket_1\n" +
            "GD501436501\tbucket_1\n" +
            "GD501437401\tbucket_1\n" +
            "GD501437701\tbucket_1\n" +
            "GD501437801\tbucket_1\n" +
            "GD501437901\tbucket_1\n" +
            "GD501438201\tbucket_1\n" +
            "GD501438601\tbucket_1\n" +
            "GD501440001\tbucket_1\n" +
            "GD501440101\tbucket_1\n" +
            "GD501440201\tbucket_1\n" +
            "GD501440501\tbucket_1\n" +
            "GD501441301\tbucket_1\n" +
            "GD501442001\tbucket_1\n" +
            "GD501442101\tbucket_1\n" +
            "GD501567101\tbucket_1\n" +
            "GD501567201\tbucket_1\n" +
            "GD501567401\tbucket_1\n" +
            "GD501568001\tbucket_1\n" +
            "GD501607901\tbucket_1\n" +
            "GD501608301\tbucket_1\n" +
            "GD501765601\tbucket_1\n" +
            "GD501766401\tbucket_1\n" +
            "GD501766501\tbucket_1\n" +
            "GD501766901\tbucket_1\n" +
            "GD501767301\tbucket_1\n" +
            "GD501768001\tbucket_1\n" +
            "GD501768401\tbucket_1\n" +
            "GD501768801\tbucket_1\n" +
            "GD501770301\tbucket_1\n";
}
