/*
 *  BEGIN_COPYRIGHT
 *
 *  Copyright (C) 2011-2013 deCODE genetics Inc.
 *  Copyright (C) 2013-2019 WuXi NextCode Inc.
 *  All Rights Reserved.
 *
 *  GORpipe is free software: you can redistribute it and/or modify
 *  it under the terms of the AFFERO GNU General Public License as published by
 *  the Free Software Foundation.
 *
 *  GORpipe is distributed "AS-IS" AND WITHOUT ANY WARRANTY OF ANY KIND,
 *  INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
 *  NON-INFRINGEMENT, OR FITNESS FOR A PARTICULAR PURPOSE. See
 *  the AFFERO GNU General Public License for the complete license terms.
 *
 *  You should have received a copy of the AFFERO GNU General Public License
 *  along with GORpipe.  If not, see <http://www.gnu.org/licenses/agpl-3.0.html>
 *
 *  END_COPYRIGHT
 */

package org.gorpipe.gor.driver.providers.stream.datatypes.parquet;

import org.apache.parquet.example.data.Group;
import org.apache.parquet.hadoop.ParquetReader;
import org.gorpipe.gor.model.ChromoLookup;
import org.gorpipe.gor.model.ParquetLine;
import org.gorpipe.gor.model.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.Iterator;
import java.util.function.Function;

public class ParquetRowReader implements Comparable<ParquetRowReader>, Iterator<Row>, AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ParquetRowReader.class);
    ParquetReader<Group> reader;
    Row row;
    String part;

    Function<Group, ParquetLine> lineProvider;

    public ParquetRowReader(ParquetReader<Group> reader, ChromoLookup lookup, String part) {
        this(reader, (Group group) -> new ParquetLine(group, lookup), part);
    }

    public ParquetRowReader(ParquetReader<Group> reader, Function<Group, ParquetLine> lineProvider, String part) {
        this.reader = reader;
        this.lineProvider = lineProvider;
        this.part = part;
        hasNext();
    }
    
    public String getPart() {
        return part;
    }

    @Override
    public boolean hasNext() {
        try {
            Group grp = reader.read();
            if (grp != null) {
                row = lineProvider.apply(grp);
                return true;
            }
        } catch (IOException e) {
            log.error(e.getMessage(), e);
        }
        return false;
    }

    @Override
    public Row next() {
        return row;
    }

    @Override
    public int compareTo(ParquetRowReader o) {
        return row.compareTo(o.row);
    }

    @Override
    public void close() {
        try {
            reader.close();
        } catch (IOException e) {
            // Dont care
        }
    }
}
