package org.gorpipe.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import org.junit.Assert;
import org.junit.Test;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * Test class for basi ctable and entry unit tests.
 * <p>
 * Created by gisli on 14/11/2016.
 */
public class UTestJsonUtils {

    private static final String query1 = "create ##dummy## = gor ##genes## | top 1; def ##ref## = ref_base/HG19-85-5-3; def ##genes## = ##ref##/rgenes.gorz; def ##exons## = ##ref##/refgenes/refgenes_exons.gorz; def ##hgmd## = ##ref##/hgmd/hgmd_hgmd.gorz; def ##gmap## = ##ref##/ensgenes/ensgenes.map; def ##clinicalvars## = ##ref##/clinical_variants.gorz; def ##clinicalvarsdetail## = ##ref##/clinical_variants_detail.gorz; def ##gdismap## = ##ref##/ensgenes/ensgenes_disease.map; def ##clinicalgenes## = ##ref##/clinical_genes.gorz; def ##CGDmap## = ##ref##/disgenes/CGD.map; def ##genepaneldiseases## = ##ref##/gene_panel_diseases.gorz; def ##dbsnpclin## = ##ref##/dbsnp/dbsnp_clinvar.gorz; def ##dbsnp## = ##ref##/dbsnp/dbsnp.gorz; def ##dbnsfpmax## = ##ref##/dbnsfp_max.gorz; def ##repeat_regions## = ##ref##/simplerepeats.gorz; def ##vepimpactmap## = ##ref##/VEP_impact.map; def ##ACMGset## = ##ref##/disgenes/ACMG_Minimum.set; def ##CHILDRECESSset## = ##ref##/disgenes/childhood_recessive.set; def ##CILIAset## = ref/disgenes/cilia.set; def ##defRmaxAf## = 0.03; def ##defRmaxGf## = 0.01; def ##defDmaxAf## = 0.01; def ##defMOI## = 'All'; def ##defVarCats## = 'Cat1,Cat1B,Cat1C,Cat1D,Cat2'; def ##freqmax## = ##ref##/freq_max.gorz;create ##varscope## = pgor #wesVars# -f 'IO_GIAB_INDEX' | merge <(gor #wesVars# -f 'IO_GIAB_FATHER','IO_GIAB_MOTHER') | select 1-4 | merge <(gor ##clinicalvars## | select 1-Alt,Disease,MaxClinImpact,DbSource | rename Disease var_diseases  | select 1-4 | rename #3 Reference | rename #4 Call) | distinct;create ##maxscore## = pgor ##dbnsfpmax## | varjoin -i [##varscope##] | calc Max_Score max(max(if(isfloat(Polyphen2_HDIV_score),Polyphen2_HDIV_score,0),if(isfloat(Polyphen2_HVAR_score),Polyphen2_HVAR_score,0)),if(isfloat(Sift_score),Sift_score,0)) | group 1 -gc #3,#4 -max -fc max_score | rename max_max_score Max_Score;create ##frequency_file## = pgor ##freqmax## | select 1-4,max_af | distinct; def ##VEP## = [##newvep##] | varjoin -r -l -e 0 <(gor ##clinicalvars## | select 1-Alt,Disease,MaxClinImpact,DbSource | rename Disease var_diseases  | select 1-4 | distinct | calc catone 1)   | where consequence in ('transcript_ablation','splice_acceptor_variant','splice_donor_variant','stop_gained','frameshift_variant','stop_lost','start_lost','transcript_amplification','inframe_insertion','inframe_deletion','missense_variant','protein_altering_variant','splice_region_variant','incomplete_terminal_codon_variant') or catone = 1 | varjoin -r -l -e 0.0 [##frequency_file##];create ##veprank## = nor -h ##vepimpactmap##  | rename so_term consequence | rename vep_rank rank_consequence | select consequence,rank_consequence;create ##veplocal_reduced_study## = gor source/anno/vep_v85/pn_vepref_multi_wgs.gord -s PN -f 'IO_GIAB_INDEX'  | where consequence in ('transcript_ablation','splice_acceptor_variant','splice_donor_variant','stop_gained','frameshift_variant','stop_lost','start_lost','transcript_amplification','inframe_insertion','inframe_deletion','missense_variant','protein_altering_variant','splice_region_variant','incomplete_terminal_codon_variant') | merge <(gor source/anno/vep_v85/pn_vepref_multi_wgs.gord -s PN -f 'IO_GIAB_FATHER','IO_GIAB_MOTHER'  | where consequence in ('transcript_ablation','splice_acceptor_variant','splice_donor_variant','stop_gained','frameshift_variant','stop_lost','start_lost','transcript_amplification','inframe_insertion','inframe_deletion','missense_variant','protein_altering_variant','splice_region_variant','incomplete_terminal_codon_variant')  ) | distinct;create ##global_reduced## = pgor source/anno/vep_v85/globalvep/global_vepref_multi_wgs.gord    -fs -f 'transcript_ablation','splice_acceptor_variant','splice_donor_variant','stop_gained','frameshift_variant','stop_lost','start_lost','transcript_amplification','inframe_insertion','inframe_deletion','missense_variant','protein_altering_variant','splice_region_variant','incomplete_terminal_codon_variant';create ##vep_clinical## = pgor source/anno/vep_v85/globalvep/global_vepref_multi_wgs.gord | merge ##ref##/disvariants/clinical_variants_vepref_multi.gorz | varjoin -i ##clinicalvars## | distinct;create ##vepglobal_reduced_study## = pgor [##global_reduced##] | varjoin -i [##varscope##];create ##newvep## = pgor [##veplocal_reduced_study##] | merge [##vepglobal_reduced_study##] | merge [##vep_clinical##] | distinct | select 1,2,Reference,Call,Max_Consequence,Gene_symbol,Feature,Consequence,Biotype,amino_acids,Protein_position,Protein_Size,EXON,INTRON,DISTANCE,HGVSc,HGVSp,Refgene | map -c consequence -m 100 -h [##veprank##] | map -m 'miss' -c gene_symbol -h [##preftranscript##] | replace rank_consequence if(containsany(refgene,Gene_DefTrans),rank_consequence-100,rank_consequence) | granno 1 -gc #3,#4,gene_symbol -min -ic rank_consequence | where rank_consequence = min_rank_consequence | hide rank_consequence,min_rank_consequence | calc ips if(isint(protein_size),int(protein_size),1) | granno 1 -gc reference,call,Gene_Symbol -max -ic ips | where ips = max_ips | rownum | granno 1 -gc reference,call,gene_symbol -max -ic rownum | where rownum = max_rownum | map -c consequence -h -m '?' <(nor ##vepimpactmap## | rename #1 consequence | rename #2 IMPACT) | rename IMPACT Max_Impact | select 1,2,Reference,Call,Max_Impact,max_consequence,Consequence,Gene_Symbol,Biotype,Feature,Amino_Acids,Protein_Position,Protein_Size,EXON,INTRON,DISTANCE,HGVSc,HGVSp,Refgene,HGMD_transcript,CLINVAR_transcript;create ##cat1## = pgor [##newvep##]  | varjoin <(gor ##clinicalvars## | select 1-Alt,Disease,MaxClinImpact,DbSource | rename Disease var_diseases  | where MaxClinImpact = 'Pathogenic' ) | select 1-4,gene_symbol,feature,amino_acids,protein_position,MaxClinImpact,var_diseases;create ##cat1d## = pgor [##newvep##]  | varjoin <(gor ##clinicalvars## | select 1-Alt,Disease,MaxClinImpact,DbSource | rename Disease var_diseases  | where NOT(MaxClinImpact = 'Pathogenic') ) | select 1-4,gene_symbol,feature,amino_acids,protein_position,MaxClinImpact,var_diseases;create ##cat1bc## = pgor [##newvep##] | select 1-4,gene_symbol,feature,protein_position,amino_acids | join -snpsnp -xl feature -xr feature -f 2 [##cat1##] | where not(pos = posx and reference = referencex and call = callx) and not(amino_acids in ('','.')) | calc CatOne if(amino_acids = amino_acidsx and protein_position = protein_positionx,'Cat1B',if(protein_position = protein_positionx,'Cat1C','')) | where CatOne != '' | select 1-4,gene_symbol,feature,amino_acids,protein_position,CatOne,MaxClinImpact,var_Diseases;create ##catone## = gor [##cat1##] | calc CatOne 'Cat1' | merge <(gor [##cat1d##] | calc CatOne 'Cat1D') | merge [##cat1bc##] | rownum | calc catrank mod(rownum,100)+if(CatOne='Cat1',100,if(CatOne='Cat1B',200,if(CatOne='Cat1C',300,400))) | granno 1 -gc #3,#4,feature -min -ic catrank  | where catrank = min_catrank | hide rownum-min_catrank;create ##preftranscript## = nor -h ref/disgenes/hgmd_clinvar_combined_transcripts.map | calc Gene_defTrans LISTDIST(if(HGMD_transcript!='',HGMD_transcript+if(CLINVAR_transcript!='',','+CLINVAR_transcript,''),CLINVAR_transcript)) | split Gene_defTrans | colsplit Gene_defTrans 2 PrefTRANS -s '\\.' | group -gc gene_symbol -set -sc 2- | rename set_(.*) #{1} | hide prefTrans_2,Gene_defTrans | rename PrefTRANS_1 Gene_defTrans;create #CGDcandgenes# = gor ##genes## | map ##gdismap## -c gene_symbol -h | replace gene_in_disease replace(gene_in_disease,',','') | map ##CGDmap## -c gene_symbol -h -m '' | select 1-3,gene_symbol,gene_in_disease,MANIFESTATION_CATEGORIES,INTERVENTION_RATIONALE,COMMENTS,INTERVENTION_CATEGORIES,REFERENCES,CONDITION,INHERITANCE,AGE_GROUP | rename Gene_in_disease GeneLists | prefix 5#- CGD | replace CGD_inheritance trim(CGD_inheritance) | where CGD_MANIFESTATION_CATEGORIES != '' or CGD_INHERITANCE != '' | select 1-3,gene_symbol;create ##theAliasCandidateGenes## = gor 'studies/Genome-In-A-Bottle-ACMG/candidate_genes.gor' | calc ep gene_candidate_phenotypes | split ep | map -c ep -h <(nor <(gor 'studies/Genome-In-A-Bottle-ACMG/candidate_genes.gor' | split gene_candidate_phenotypes | group genome -gc gene_candidate_phenotypes -dis -sc gene_symbol) | select GENE_candidate_Phenotypes,dis_GENE_symbol | calc pheno_significance 1.0/dis_GENE_symbol) | group 1 -gc 3-ep[-1] -sum -fc pheno_significance | rename sum_pheno_significance Gene_Cand_PhenoScore | map -c gene_symbol ##gmap## -n gene_aliases -m 'missing' | split gene_aliases | replace gene_symbol if(gene_aliases != 'missing',gene_aliases,gene_symbol) | hide gene_aliases;create #CGDtemp# = gor [#CGDcandgenes#] | select 1,2,gene_symbol,CGD* | distinct | map ##gmap## -c gene_symbol -n gene_paralogs | split gene_paralogs | rename gene_paralogs gene_paralog | where len(gene_paralog) > 1 | rename gene_symbol orig_gene | calc tempchrom  '1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,X,XY,Y,M' | split tempchrom | calc newchrom 'chr'+tempchrom | select newchrom,2,gene_paralog,orig_gene | rename newchrom chrom | sort genome | group chrom -gc gene_paralog,orig_gene;create #CGDclingenes# = gor [#CGDtemp#] | join -segseg -xl gene_paralog -xr gene_symbol ##genes## | select 1,gene_start-,orig_gene,CGD* | sort chrom | where gene_symbol != orig_gene | join -n -snpsnp -xl gene_symbol -xr gene_symbol [#CGDcandgenes#] | group 1 -gc 3-gene_symbol -len 10000 -set -sc orig_gene | rename set_orig_gene GENE_candidate_paralogs | rename set_(.*) #{1} | calc GENE_CandOrParalog 'p' | merge <(gor [#CGDcandgenes#] | calc GENE_CandOrParalog 'c') | calc GENE_candidate_Phenotypes '1:CGD' | columnsort 1,2,GENE_end,GENE_symbol,GENE_candidate_Phenotypes,GENE_candidate_paralogs,GENE_candORparalog;create ##pardiseases## = gor ##ClinicalGenes## | select 1-gene_diseases | map -c gene_symbol ##gmap## -m '' -n gene_paralogs | split gene_paralogs | map -c gene_paralogs -m '' <(nor ##ClinicalGenes## | select gene_symbol,gene_diseases) -h | rename gene_diseasesx par_diseases | group 1 -gc gene_end-gene_diseases -set -sc gene_paralogs,par_diseases -len 10000 | replace set_par_diseases listdist(listfilter(set_par_diseases,'not(containsany(gene_diseases,x))')) | rename set_par_diseases Gene_par_diseases | rename set_gene_paralogs Gene_paralogs | replace Gene_diseases,gene_par_diseases replace(#rc,',',', ') | replace Gene_paralogs listfilter(Gene_paralogs,'x!=\".\"');create ##coveragevars## = pgor  <(##allvars##)  | select 1-4 | rename #2 Pos | rename #3 Reference | rename #4 Call | merge <(gor #wesVars# -f 'IO_GIAB_FATHER','IO_GIAB_MOTHER' | group 1 -gc reference,call -sum -ic callcopies | where sum_callcopies >= 2 | select 1-4 ) | merge <(gor #wesVars# -f 'IO_GIAB_INDEX' | select 1-4) | varmerge reference call | distinct;create ##indexcov## = pgor [##coveragevars##] | select 1-4 | distinct | join -snpseg -r -l -e 0 -maxseg 10000 <(gor source/cov/segment_cov.gord -s PN -f 'IO_GIAB_INDEX') | rename Depth apprCovDepth | select 1,Pos,Reference,Call,apprCovDepth;create ##fathercov## = pgor [##coveragevars##] | select 1-4 | distinct | join -snpseg -r -l -e 0 -maxseg 10000 <(gor source/cov/segment_cov.gord -s PN -f 'IO_GIAB_FATHER') | rename Depth apprCovDepth | select 1,Pos,Reference,Call,apprCovDepth;create ##mothercov## = pgor [##coveragevars##] | select 1-4 | distinct | join -snpseg -r -l -e 0 -maxseg 10000 <(gor source/cov/segment_cov.gord -s PN -f 'IO_GIAB_MOTHER') | rename Depth apprCovDepth | select 1,Pos,Reference,Call,apprCovDepth;create ##VEPKNOWN## = pgor <(##VEP## | join -snpseg -f 10 -r -ic <(gor ##exons## ) | where OverlapCount > 0 or catone = 1 | calc Gene_RmaxAf ##defRmaxAf## | calc Gene_RmaxGf ##defRmaxGf## | calc Gene_DmaxAf ##defDmaxAf## | calc Gene_MOI ##defMOI## | where isfloat(max_Af) and float(max_Af) <= Gene_RmaxAf or ((catone = 1 or max_impact='HIGH') and float(max_Af) < 0.10) | select 1-4,Max_Impact,Max_Consequence,Consequence,Max_Af,Biotype,Gene_Symbol,Refgene,Amino_Acids,Protein_Position,HGVSc,HGVSp,Gene_RmaxAf,Gene_RmaxGf,Gene_DmaxAf,Gene_MOI,HGMD_transcript,CLINVAR_transcript | varjoin -l -r -xl gene_symbol -xr gene_symbol -rprefix KNOWN <(gor [##catone##]  | select 1-4,gene_symbol,CatOne,MaxClinImpact,var_diseases ) | replace KNOWN_var_diseases if(KNOWN_var_diseases = '' and KNOWN_MaxClinImpact != '','unspecified',KNOWN_var_diseases) | hide Known_Gene_Symbol | rename GENE_SYMBOL GENE ) | varjoin -l -e 0.0 -r [##maxscore##];create ##CLINVARHGMD## = gor ##clinicalvarsdetail## | select 1-4,variantType,source | rename variantType KNOWN_variantType |rename source KNOWN_source | varjoin -r -l <(gor ##hgmd##  | select 1,2,ref,allele,hgmdacc | rename hgmdacc KNOWN_HGMDacc) | varjoin -r -l <(gor ##dbsnpclin## | select 1,2,ref,alt,clnacc | rename CLNACC KNOWN_ClinVarAcc) | group 1 -gc ref,alt -set -sc known_* | rename set_(.*) #{1};;create ##ctrlvars## = pgor #wesVars# -f 'IO_GIAB_FATHER','IO_GIAB_MOTHER' | where Depth = -1 or FILTER != 'LowQual' and GL_Call >= 5 and  Depth >= 8 and (CallCopies = 2 and CallRatio >= 0.66 or CallCopies = 1 and CallRatio >= 0.2 and CallRatio <= 1.0-0.2) | varmerge reference call | calc hom IF(callCopies = 2,1,0) | group 1 -gc reference,call -sum -ic hom | rename sum_hom homCTRLs ; def ##allvars## = gor #wesVars# -f 'IO_GIAB_INDEX' | where Depth = -1 or FILTER != 'LowQual' and GL_Call >= 5 and  Depth >= 8 and (CallCopies = 2 and CallRatio >= 0.66 or CallCopies = 1 and CallRatio >= 0.2 and CallRatio <= 1.0-0.2) | select 1-4 | merge <(gor #wgsvars# -f 'IO_GIAB_INDEX' | select 1-4 | varjoin -i ##clinicalvars## ) | distinct | varjoin -r [##VEPKNOWN##] | varjoin -l -e 0 -r [##ctrlvars##] | calc Cat4 IF(homCTRLs > 0 or max_Af > 0.10,1,0) | calc Cat1 IF(Cat4 = 0 and KNOWN_CatOne = 'Cat1',1,0) | calc Cat1B IF(Cat4 = 0 and Cat1 = 0 and KNOWN_CatOne = 'Cat1B',1,0) | calc Cat1C IF(Cat4 = 0 and Cat1 = 0 and Cat1B = 0 and KNOWN_CatOne = 'Cat1C',1,0) | calc Cat1D IF(Cat4 = 0 and Cat1 = 0 and Cat1B = 0 and Cat1C = 0 and KNOWN_CatOne = 'Cat1D',1,0) | calc Cat2 IF(Cat4 = 0 and Cat1 = 0 and Cat1B = 0 and Cat1C = 0 and Cat1D = 0 and max_impact = 'HIGH',1,0) | calc Cat3A IF(Cat4 = 0 and Cat1 = 0 and Cat1B = 0 and Cat1C = 0 and Cat1D = 0 and Cat2=0 and (max_Consequence = 'missense_variant' and max_score >= 0.9),1,0) | calc Cat3B IF(Cat4 = 0 and Cat1 = 0 and Cat1B = 0 and Cat1C = 0 and Cat1D = 0 and Cat2=0 and Cat3A=0 and (max_impact = 'LOW' or (max_impact = 'MODERATE' and Cat3A = 0)),1,0) | calc Cat IF(Cat1>0,'Cat1',IF(Cat1B>0,'Cat1B',IF(Cat1C>0,'Cat1C',IF(Cat1D>0,'Cat1D',IF(Cat2>0,'Cat2',IF(Cat3A>0,'Cat3A',IF(Cat3B>0,'Cat3B','Cat4'))))))) | replace Cat4 IF(Cat = 'Cat4',1,0) | hide KNOWN_CatOne | hide Cat4,Cat1,Cat1B,Cat1C,Cat1D,Cat2,Cat3a,Cat3b,Known_MaxClinImpact,homCTRLs | rename Cat DIAG_ACMGcat;create ##indexvars## = pgor <(##allvars##) | varjoin -r -l -e 'NAN' <(gor #wgsvars#  -f 'IO_GIAB_INDEX' | calc hetORhom IF(callCopies = 2,'hom','het') ) | calc Carrier IF(hetORhom = 'NAN','false','true') | varjoin -l -rprefix FATHER -e 'NAN'  <(gor #wgsvars# -f 'IO_GIAB_FATHER' | select 1,2,reference,call,CallCopies,PN | calc hetORhom IF(callCopies = 2,'hom','het') ) | varjoin -l -rprefix MOTHER -e 'NAN'  <(gor #wgsvars# -f 'IO_GIAB_MOTHER' | select 1,2,reference,call,CallCopies,PN | calc hetORhom IF(callCopies = 2,'hom','het') ) | calc fromFather IF(hetORhom='hom' or FATHER_call!='NAN',1,0) | calc fromMother IF(hetORhom='hom' or MOTHER_call!='NAN',1,0) | calc IHEstatus IF(carrier = 'true' and ((hetORhom='hom' and (FATHER_call = 'NAN' or MOTHER_call = 'NAN')) or (hetORhom='het' and (FATHER_call = 'NAN' and MOTHER_call = 'NAN') ) or (hetORhom != 'hom' and FATHER_callcopies = '2' and MOTHER_callcopies = '2')),1,0) | granno gene -range -gc PN,GENE -ic fromFather,fromMother,IHEstatus -sum -count | calc GENE_CHZinGene IF(GENE != '-',IF(sum_fromFather>0 and sum_fromMother>0 and allCount>1,'1','0'),'NAN') | calc GENE_iheVarsInGene IF(GENE != '-',sum_IHEstatus,'NAN') | hide allCount,FATHER_pos,FATHER_PN,FATHER_reference,MOTHER_pos,MOTHER_PN,MOTHER_reference,fromFather,fromMother,sum_IHEstatus,sum_fromFather,sum_fromMother,FATHER_Callcopies-FATHER_PN,MOTHER_Callcopies-MOTHER_PN | replace FATHER_call IF(FATHER_call='NAN','Var_Absent',FATHER_call) | replace MOTHER_call IF(MOTHER_call='NAN','Var_Absent',MOTHER_call) | where carrier != 'false';create ##ccvar## = pgor #wesVars# -f 'IO_GIAB_FATHER','IO_GIAB_MOTHER' | varjoin -r <(gor [##VEPKNOWN##] | group 1 -gc reference,call -set -sc Known_MaxClinImpact ) | calc PNtype IF(PN = 'IO_GIAB_MOTHER','MOTHER',IF(PN = 'IO_GIAB_FATHER','FATHER','UNKNOWN')) | varmerge reference call | calc hetORhom IF(callCopies = 2,'hom','het') | calc hom IF(hetORhom = 'hom',1,0) | calc known IF(set_Known_MaxClinImpact != '',1,0) | group 1 -gc PNtype,reference,call -ic hom -sum -count | rename allCount withVar | rename sum_hom withHomoVar | pivot PNtype -gc reference,call -v FATHER,MOTHER -e 0;create ##ccgene## = pgor #wesVars# -f 'IO_GIAB_INDEX','IO_GIAB_FATHER','IO_GIAB_MOTHER' | varjoin -r <([##VEPKNOWN##] | select 1-4,MAX_IMPACT,MAX_CONSEQUENCE,Consequence,max_Af,max_score,GENE,KNOWN_CatOne,KNOWN_MaxClinImpact,Gene_RmaxAf,Gene_RmaxGf,Gene_DmaxAf,Gene_MOI,HGMD_transcript,CLINVAR_transcript ) | calc hetORhom IF(callCopies = 2,'hom','het') | calc hom IF(hetORhom = 'hom',1,0) | calc het IF(hetORhom = 'het',1,0) | rename max_score score | calc known IF(Known_MaxClinImpact != '',1,0) | join -varseg -f 10 -xl GENE -xr GENE_SYMBOL <(gor ##genes## | select 1-4) | group chrom -gc gene_Start,gene_End,PN,GENE -ic het,hom,known -fc score -sum | select 1,4- | sort chrom | calc CHZ IF(sum_het>1 or sum_hom>0,1,0) | calc WKV IF(sum_known>0,1,0) | calc PNtype IF(PN='IO_GIAB_INDEX','GENE',IF(PN = 'IO_GIAB_MOTHER','MOTHER',IF(PN = 'IO_GIAB_FATHER','FATHER','UNKNOWN')))  | calc VAR sum_het+sum_hom | calc WVIG IF(VAR>0,1,0) | group chrom -gc gene_Start,gene_End,PNtype,GENE -ic sum_hom,CHZ,WKV,VAR,WVIG,sum_known -sum | rename sum_WVIG subjWithVarInGene | select 1,4- | rename sum_sum_hom homozVarsInGene | rename sum_CHZ subjCompHeterInGene | rename sum_WKV subjWithKnownVarInGene | rename sum_Var varsInGene | rename sum_sum_known knownVarsInGene | sort chrom | pivot -gc gene_End,GENE PNtype -v GENE,FATHER,MOTHER -e 0 ; def ##autosomalreport## = gor [##indexvars##] | where not (Chrom in ('chrX','chrM') ) | varjoin -l -r -e 0 [##ccvar##] | join -varseg -f 10 -l -r -e 0 -xl GENE -xr GENE [##ccgene##] | replace GENE IF(GENE='0','OUTSIDE_GENES',GENE) | calc DIAG_HomRecess IF( Carrier = 'true' and hetORhom = 'hom' and ( FATHER_withHomoVar = 0 ) and ( MOTHER_withHomoVar = 0  ) , 'true', 'false') | calc DIAG_CHZ IF( Carrier = 'true' and (  GENE_CHZinGene = 1 ) and ( FATHER_withHomoVar = 0 ) and ( MOTHER_withHomoVar = 0 ) , 'true', 'false') | hide GENE_CHZinGene | calc DIAG_Dominant IF( Carrier = 'true' and max_Af <= Gene_DmaxAf and ( FATHER_withVar = 0 ) and ( MOTHER_withVar = 0 ) , 'true', 'false') | prefix CallRatio,CallCopies,Depth,GL_Call,FILTER GT | rename IHEstatus GT_IHEstatus | prefix Max_Impact-Max_Af,Max_Score,Protein_Position,Amino_Acids VEP | hide GENEx,GENE_subjWithKnownVarInGene,GENE_subjCompHeterInGene,GENE_subjWithVarInGene | rename GENE GENE_symbol;create ##exvars## = pgor ##genes## | select 1-3,gene_symbol | join -segvar -f 10 -xl gene_symbol -xr gene <( gor #wesVars# -f 'IO_GIAB_INDEX' | where Depth = -1 or FILTER != 'LowQual' and GL_Call >= 5 and  Depth >= 8 and (CallCopies = 2 and CallRatio >= 0.66 or CallCopies = 1 and CallRatio >= 0.2 and CallRatio <= 1.0-0.2) | join -varseg -f 10 -i ##exons## | calc hetORhom IF(callCopies = 2,'hom','het') | varjoin -l -e 'NAN' -rprefix FATHER <(gor #wesVars# -f 'IO_GIAB_FATHER' ) | varjoin -l -e 'NAN' -rprefix MOTHER <(gor #wesVars# -f 'IO_GIAB_MOTHER' ) | calc fromFather IF(hetORhom='hom' or FATHER_call!='NAN' and MOTHER_call='NAN',1,0) | calc fromMother IF(hetORhom='hom' or MOTHER_call!='NAN' and FATHER_call='NAN',1,0) | calc IHEstatus IF((hetORhom='hom' and (FATHER_call = 'NAN' or MOTHER_call = 'NAN')) or (hetORhom='het' and (FATHER_call = 'NAN' and MOTHER_call = 'NAN') ) or (hetORhom != 'hom' and FATHER_callcopies = '2' and MOTHER_callcopies = '2'),1,0) | varjoin -r <(gor [##VEPKNOWN##] | select 1-4,MAX_IMPACT,MAX_CONSEQUENCE,Consequence,max_Af,max_score,GENE,KNOWN_CatOne,KNOWN_MaxClinImpact,Gene_RmaxAf,Gene_RmaxGf,Gene_DmaxAf,Gene_MOI,HGMD_transcript,CLINVAR_transcript) | varjoin -l -e 0 -r [##ctrlvars##] | calc Cat4 IF(homCTRLs > 0 or max_Af > 0.10,1,0) | calc Cat1 IF(Cat4 = 0 and KNOWN_CatOne = 'Cat1',1,0) | calc Cat1B IF(Cat4 = 0 and Cat1 = 0 and KNOWN_CatOne = 'Cat1B',1,0) | calc Cat1C IF(Cat4 = 0 and Cat1 = 0 and Cat1B = 0 and KNOWN_CatOne = 'Cat1C',1,0) | calc Cat1D IF(Cat4 = 0 and Cat1 = 0 and Cat1B = 0 and Cat1C = 0 and KNOWN_CatOne = 'Cat1D',1,0) | calc Cat2 IF(Cat4 = 0 and Cat1 = 0 and Cat1B = 0 and Cat1C = 0 and Cat1D = 0 and max_impact = 'HIGH',1,0) | calc Cat3A IF(Cat4 = 0 and Cat1 = 0 and Cat1B = 0 and Cat1C = 0 and Cat1D = 0 and Cat2=0 and (max_Consequence = 'missense_variant' and max_score >= 0.9),1,0) | calc Cat3B IF(Cat4 = 0 and Cat1 = 0 and Cat1B = 0 and Cat1C = 0 and Cat1D = 0 and Cat2=0 and Cat3A=0 and (max_impact = 'LOW' or (max_impact = 'MODERATE' and Cat3A = 0)),1,0) | calc Cat IF(Cat1>0,'Cat1',IF(Cat1B>0,'Cat1B',IF(Cat1C>0,'Cat1C',IF(Cat1D>0,'Cat1D',IF(Cat2>0,'Cat2',IF(Cat3A>0,'Cat3A',IF(Cat3B>0,'Cat3B','Cat4'))))))) | replace Cat4 IF(Cat = 'Cat4',1,0) | hide KNOWN_CatOne ) | calc GT_phase IF(fromFather = 0 and fromMother = 0,'U',IF(fromFather = 1 and fromMother = 0,'F',IF(fromFather = 0 and fromMother = 1,'M','H'))) ; def ##CTRLexvars## = gor ##genes##  | select 1-3,gene_symbol | join -segvar -f 10 -xl Gene_Symbol -xr Gene <( gor #wesVars# -f 'IO_GIAB_FATHER','IO_GIAB_MOTHER' | varjoin -r [##VEPKNOWN##] )  | select chrom,gene_start,gene_symbol,reference,call,pos,PN,Callcopies;create ##chz## = pgor [##exvars##] | join -snpsnp [##exvars##] -xl PN,gene_symbol -xr PN,gene_symbol | where pos = posx and (hetORhom = 'hom' or call != callx) or pos != posx and (GT_phasex = 'H' or GT_Phasex = 'U' or GT_Phase != GT_Phasex) | calc GT_phases IF(hetORhom = 'hom','H',GT_phase+','+GT_phasex) | where max_Af*max_Afx <= Gene_RmaxGf | calc sum_Cat1 (Cat1+Cat1B+Cat1C)*IF(hetORhom='hom',2,1)+(Cat1x+Cat1Bx+Cat1Cx)*IF(pos != posx,1,0) | calc sum_Cat2 Cat2*IF(hetORhom='hom',2,1)+Cat2x*IF(pos != posx,1,0) | calc sum_Cat3a Cat3a*IF(hetORhom='hom',2,1)+Cat3ax*IF(pos != posx,1,0) | calc sum_Cat3b Cat3b*IF(hetORhom='hom',2,1)+Cat3bx*IF(pos != posx,1,0) | calc sum_Cat4 Cat4*IF(hetORhom='hom',2,1)+Cat4x*IF(pos != posx,1,0) | calc Diagnosis IF(sum_Cat1+sum_Cat2 > 1,'1:DxConsistent', IF(sum_Cat1+sum_cat2 > 0 and sum_Cat3a > 0,'2:DxLikely', IF(sum_Cat3a > 1 or (sum_Cat1+sum_Cat2+sum_Cat3a > 0 and sum_Cat3b > 0),'3:DxPossible', IF(sum_Cat3b > 1,'4:DxLessLikely', IF(sum_Cat1+sum_Cat2 > 0 and sum_Cat4 > 0,'5:DxIndeterminate', IF(sum_Cat3a+sum_Cat3b > 0 and sum_Cat4 > 0,'6:DxUnlikely','7:DxNegative')))))) | calc diag_order left(Diagnosis,1) | hide Cat4-Cat3B,sum_Cat1-sum_Cat4,Cat4x-Cat3Bx | select 1,pos,reference,call,hetorhom,PN,gene,posx,Cat,Catx,Diagnosis,Diag_order,GT_phases,referencex,callx | sort 3000000 | varjoin -n -xl posx,referencex,callx,gene -xr posx,referencex,callx,gene_symbol -maxseg 3000000 <(gor <(##CTRLexvars##) | join -snpsnp <(##CTRLexvars##) -xl PN,gene_symbol -xr PN,gene_symbol | where  pos != posx or pos = posx and (CallCopies = 2 or Call != Callx) | select chrom,pos,reference,call,posx,referencex,callx,gene_symbol,PN | sort 3000000 | group 1 -gc reference,call,posx,referencex,callx,gene_symbol -count | where allCount > 0) | rank 1 -gc reference,call,pn,gene diag_order -o asc | where rank_diag_order = 1 | group 1 -gc reference,call,hetorhom,PN,gene,Cat,Diagnosis -set -sc Catx,posx,GT_phases | rename set_GT_phases DIAG_compPhases | rename Cat ACMGcat | rename set_Catx otherACMGcat | rename set_posx otherPos | replace otherPos replace(replace(replace(otherPos,','+pos,''),pos+',',''),pos,'') | replace otherACMGcat IF(otherPos='','',otherACMGcat) | rename Diagnosis recessiveCat | prefix ACMGcat-otherACMGcat DIAG | hide hetORhom,PN | rename GENE GENE_symbol ; def ##CCexvars## = gor ##genes## | select 1-3,gene_symbol | join -segvar -f 10 -xl gene_symbol -xr gene <( gor #wesVars# -f 'IO_GIAB_FATHER','IO_GIAB_MOTHER' | calc hetORhom IF(callCopies = 2,'hom','het') | varjoin -r <(gor [##VEPKNOWN##] | select 1-4,MAX_IMPACT,MAX_CONSEQUENCE,Consequence,max_Af,max_score,GENE,KNOWN_CatOne,KNOWN_MaxClinImpact,Gene_RmaxAf,Gene_RmaxGf,Gene_DmaxAf,Gene_MOI,HGMD_transcript,CLINVAR_transcript) | calc Cat4 IF(max_Af > 0.10,1,0) | calc Cat1 IF(Cat4 = 0 and KNOWN_CatOne = 'Cat1',1,0) | calc Cat1B IF(Cat4 = 0 and Cat1 = 0 and KNOWN_CatOne = 'Cat1B',1,0) | calc Cat1C IF(Cat4 = 0 and Cat1 = 0 and Cat1B = 0 and KNOWN_CatOne = 'Cat1C',1,0) | calc Cat1D IF(Cat4 = 0 and Cat1 = 0 and Cat1B = 0 and Cat1C = 0 and KNOWN_CatOne = 'Cat1D',1,0) | calc Cat2 IF(Cat4 = 0 and Cat1 = 0 and Cat1B = 0 and Cat1C = 0 and Cat1D = 0 and max_impact = 'HIGH',1,0) | calc Cat3A IF(Cat4 = 0 and Cat1 = 0 and Cat1B = 0 and Cat1C = 0 and Cat1D = 0 and Cat2=0 and (max_Consequence = 'missense_variant' and max_score >= 0.9),1,0) | calc Cat3B IF(Cat4 = 0 and Cat1 = 0 and Cat1B = 0 and Cat1C = 0 and Cat1D = 0 and Cat2=0 and Cat3A=0 and (max_impact = 'LOW' or (max_impact = 'MODERATE' and Cat3A = 0)),1,0) | calc Cat IF(Cat1>0,'Cat1',IF(Cat1B>0,'Cat1B',IF(Cat1C>0,'Cat1C',IF(Cat1D>0,'Cat1D',IF(Cat2>0,'Cat2',IF(Cat3A>0,'Cat3A',IF(Cat3B>0,'Cat3B','Cat4'))))))) | replace Cat4 IF(Cat = 'Cat4',1,0) | hide KNOWN_CatOne );create ##CCchz## = pgor <(##CCexvars##) | join -snpsnp <(##CCexvars##) -xl PN,gene_symbol -xr PN,gene_symbol | where pos = posx and (hetORhom = 'hom' or call != callx) or pos != posx | where max_Af*max_Afx <= Gene_RmaxGf | calc sum_Cat1 (Cat1+Cat1B+Cat1C)*IF(hetORhom='hom',2,1)+(Cat1x+Cat1Bx+Cat1Cx)*IF(pos != posx,1,0) | calc sum_Cat2 Cat2*IF(hetORhom='hom',2,1)+Cat2x*IF(pos != posx,1,0) | calc sum_Cat3a Cat3a*IF(hetORhom='hom',2,1)+Cat3ax*IF(pos != posx,1,0) | calc sum_Cat3b Cat3b*IF(hetORhom='hom',2,1)+Cat3bx*IF(pos != posx,1,0) | calc sum_Cat4 Cat4*IF(hetORhom='hom',2,1)+Cat4x*IF(pos != posx,1,0) | calc Diagnosis IF(sum_Cat1+sum_Cat2 > 1,'1:DxConsistent', IF(sum_Cat1+sum_cat2 > 0 and sum_Cat3a > 0,'2:DxLikely', IF(sum_Cat3a > 1 or (sum_Cat1+sum_Cat2+sum_Cat3a > 0 and sum_Cat3b > 0),'3:DxPossible', IF(sum_Cat3b > 1,'4:DxLessLikely', IF(sum_Cat1+sum_Cat2 > 0 and sum_Cat4 > 0,'5:DxIndeterminate', IF(sum_Cat3a+sum_Cat3b > 0 and sum_Cat4 > 0,'6:DxUnlikely','7:DxNegative')))))) | calc diag_order left(Diagnosis,1) | select chrom,gene_start,gene_end,gene_symbol,PN,diag_order | calc d1 IF(diag_order = 1,1,0) | calc d2 IF(diag_order <= 2,1,0) | calc d3 IF(diag_order <= 3,1,0) | calc d4 IF(diag_order <= 4,1,0) | group chrom -gc gene_start,gene_end,gene_symbol,PN -max -ic d1,d2,d3,d4 | calc PNtype IF(PN = 'IO_GIAB_MOTHER','MOTHER',IF(PN = 'IO_GIAB_FATHER','FATHER','UNKNOWN')) | group chrom -gc gene_start,gene_end,gene_symbol,PNtype -sum -ic max_d1,max_d2,max_d3,max_d4 | rename sum_max_d1 DxConsInGene | rename sum_max_d2 DxLikeInGene | rename sum_max_d3 DxPossInGene | rename sum_max_d4 DxLessInGene | select 1,gene_start- | sort chrom | pivot -gc gene_End,GENE_symbol PNtype -v FATHER,MOTHER -e 0;create ##final## = pgor <(##autosomalreport##) | varjoin -l -r -xl gene_symbol -xr gene_symbol -rprefix DIAG -maxseg 3000000 <(gor [##exvars##] | select 1,pos,reference,call,gene_symbol | sort 3000000 | distinct) | hide DIAG_GENE_SYMBOL | varjoin -r -l -xl GENE_SYMBOL -xr GENE_SYMBOL [##chz##] | hide GENE_SYMBOLx,DIAG_ACMGcatx | join -varseg -l -e 0 -f 10 -r -xl GENE_SYMBOL -xr GENE_SYMBOL [##CCchz##] | hide GENE_SYMBOLx | replace DIAG_HomRecess IF(DIAG_recessiveCat = '','false',DIAG_HomRecess) | replace DIAG_CHZ IF(DIAG_recessiveCat = '','false',DIAG_CHZ) | calc DIAG_model = 'Autosomal' | calc recessive_score IF(hetORhom = 'hom',2,0)+IF(DIAG_recessiveCat='1:DxConsistent',4,IF(DIAG_recessiveCat='2:DxLikely',2,IF(DIAG_recessiveCat='3:DxPossible',1,0)))+ (-0.25*(FATHER_withHomoVar+FATHER_DxConsInGene+FATHER_DxLikeInGene+FATHER_DxPossInGene))+ (-0.25*(MOTHER_withHomoVar+MOTHER_DxConsInGene+MOTHER_DxLikeInGene+MOTHER_DxPossInGene))+ 0.0 | calc dominant_score 0.0+ IF(FATHER_withVar = 0,2,0)+ IF(MOTHER_withVar = 0,2,0)+ 0.0 | hide FATHER_DxConsInGene,FATHER_DxLessInGene,FATHER_DxLikeInGene,FATHER_DxPossInGene,FATHER_subjWithKnownVarInGene,FATHER_varsInGene | hide MOTHER_DxConsInGene,MOTHER_DxLessInGene,MOTHER_DxLikeInGene,MOTHER_DxPossInGene,MOTHER_subjWithKnownVarInGene,MOTHER_varsInGene | varjoin -l -r ##dbSNP## ; def ###xlinkedstartshere### = xxxxxxxxxxxxxxxxxxxxxxxxxxxx;create ##Xindexvars## = gor -p chrX <(##allvars##) | varjoin -r -l -e 'NAN' <(gor #wesVars# -f 'IO_GIAB_INDEX' | where Depth = -1 or FILTER != 'LowQual' and GL_Call >= 5 and  Depth >= 8 and (CallCopies = 2 and CallRatio >= 0.66 or CallCopies = 1 and CallRatio >= 0.2 and CallRatio <= 1.0-0.2) | calc hetORhom IF(callCopies = 2,'hom','het') ) | calc Carrier IF(hetORhom = 'NAN','false','true') | varjoin -l -rprefix FATHER -e 'NAN'  <(gor #wesVars# -f 'IO_GIAB_FATHER' | select 1,2,reference,call,CallCopies,PN | calc hetORhom IF(callCopies = 2,'hom','het') ) | varjoin -l -rprefix MOTHER -e 'NAN'  <(gor #wesVars# -f 'IO_GIAB_MOTHER' | select 1,2,reference,call,CallCopies,PN | calc hetORhom IF(callCopies = 2,'hom','het') ) | calc fromFather 0 | calc fromMother 1 | calc IHEstatus IF(MOTHER_call = 'NAN',1,0) | granno gene -range -gc PN,GENE -ic fromFather,fromMother,IHEstatus -sum | calc GENE_CHZinGene IF(GENE != '-',IF(sum_fromFather>0 and sum_fromMother>0,'1','0'),'NAN') | calc GENE_iheVarsInGene IF(GENE != '-',sum_IHEstatus,'NAN') | hide FATHER_pos,FATHER_PN,FATHER_reference,MOTHER_pos,MOTHER_PN,MOTHER_reference,fromFather,fromMother,sum_IHEstatus,sum_fromFather,sum_fromMother,FATHER_Callcopies-FATHER_PN,MOTHER_Callcopies-MOTHER_PN | replace FATHER_call IF(FATHER_call='NAN','Var_Absent',FATHER_call) | replace MOTHER_call IF(MOTHER_call='NAN','Var_Absent',MOTHER_call) | where carrier = 'true';create ##Xccvar## = gor -p chrX #wesVars# -f 'IO_GIAB_FATHER','IO_GIAB_MOTHER' | varjoin -r <(gor [##VEPKNOWN##] | group 1 -gc reference,call -set -sc Known_MaxClinImpact ) | calc PNtype IF(PN = 'IO_GIAB_MOTHER','MOTHER',IF(PN = 'IO_GIAB_FATHER','FATHER','UNKNOWN')) | varmerge reference call | calc hetORhom IF(callCopies = 2,'hom','het') | calc hom IF(hetORhom = 'hom',1,0) | calc known IF(set_Known_MaxClinImpact != '',1,0) | split PNtype | group 1 -gc PNtype,reference,call -ic hom -sum -count | rename allCount withVar | rename sum_hom withHomoVar | pivot PNtype -gc reference,call -v FATHER,MOTHER -e 0;create ##Xccgene## = gor -p chrX #wesVars# -f 'IO_GIAB_INDEX','IO_GIAB_FATHER','IO_GIAB_MOTHER' | varjoin -r <([##VEPKNOWN##] | select 1-4,MAX_IMPACT,MAX_CONSEQUENCE,Consequence,max_Af,max_score,GENE,KNOWN_CatOne,KNOWN_MaxClinImpact,Gene_RmaxAf,Gene_RmaxGf,Gene_DmaxAf,Gene_MOI,HGMD_transcript,CLINVAR_transcript ) | calc hetORhom IF(callCopies = 2,'hom','het') | calc hom IF(hetORhom = 'hom',1,0) | calc het IF(hetORhom = 'het',1,0) | rename max_score score | calc known IF(Known_MaxClinImpact != '',1,0) | join -varseg -f 10 -xl GENE -xr GENE_SYMBOL <(gor ##genes## | select 1-4) | group chrom -gc gene_Start,gene_End,PN,GENE -ic het,hom,known -fc score -sum | select 1,4- | sort chrom | calc CHZ IF(sum_het>1 or sum_hom>0,1,0) | calc WKV IF(sum_known>0,1,0) | calc PNtype IF(PN='IO_GIAB_INDEX','GENE',IF(PN = 'IO_GIAB_MOTHER','MOTHER',IF(PN = 'IO_GIAB_FATHER','FATHER','UNKNOWN')))  | calc VAR sum_het+sum_hom | calc WVIG IF(VAR>0,1,0) | split PNtype | group chrom -gc gene_Start,gene_End,PNtype,GENE -ic sum_hom,CHZ,WKV,VAR,WVIG,sum_known -sum | rename sum_WVIG subjWithVarInGene | select 1,4- | rename sum_sum_hom homozVarsInGene | rename sum_CHZ subjCompHeterInGene | rename sum_WKV subjWithKnownVarInGene | rename sum_Var varsInGene | rename sum_sum_known knownVarsInGene | sort chrom | pivot -gc gene_End,GENE PNtype -v GENE,FATHER,MOTHER -e 0 ; def ##Xlinkedreport## = gor -p chrX [##Xindexvars##] | varjoin -l -r -e 0 [##Xccvar##] | join -varseg -f 10 -l -r -e 0 -xl GENE -xr GENE [##Xccgene##] | replace GENE IF(GENE='0','OUTSIDE_GENES',GENE) | calc DIAG_HomRecess IF( Carrier = 'true' and 2=2 and ( FATHER_withVar = 0 ) and ( MOTHER_withHomoVar = 0  ) , 'true', 'false') | calc DIAG_CHZ IF( Carrier = 'true' and (GENE_varsInGene > 0) and ( FATHER_withVar = 0 ) and ( MOTHER_withHomoVar = 0 ) , 'true', 'false') | hide GENE_CHZinGene | calc DIAG_Dominant IF( Carrier = 'true' and max_Af <= Gene_DmaxAf  and ( Chrom = 'chrX' ) and ( FATHER_withVar = 0 ) and ( MOTHER_withVar = 0 ) , 'true', 'false') | prefix CallRatio,CallCopies,Depth,GL_Call,FILTER GT | rename IHEstatus GT_IHEstatus | prefix Max_Impact-Max_Af,Max_Score,Protein_Position,Amino_Acids VEP | hide GENEx,GENE_subjWithKnownVarInGene,GENE_subjCompHeterInGene,GENE_subjWithVarInGene | rename GENE GENE_symbol; def ##malectrlvars## = gor -p chrX #wesVars# -f 'IO_GIAB_FATHER' | varmerge reference call | calc hom 1 ; def ##femalectrlvars## = gor -p chrX #wesVars# -f 'IO_GIAB_MOTHER' | varmerge reference call | calc hom IF(callCopies = 2,1,0);create ##Xctrlvars## = gor <(##malectrlvars##) | merge <(##femalectrlvars##) | varmerge reference call | group 1 -gc reference,call -sum -ic hom | rename sum_hom homCTRLs;create ##Xexvars## = gor -p chrX ##genes## | select 1-3,gene_symbol | join -segvar -f 10 -xl gene_symbol -xr gene <( gor #wesVars# -f 'IO_GIAB_INDEX' | where Depth = -1 or FILTER != 'LowQual' and GL_Call >= 5 and  Depth >= 8 and (CallCopies = 2 and CallRatio >= 0.66 or CallCopies = 1 and CallRatio >= 0.2 and CallRatio <= 1.0-0.2) | join -varseg -f 10 -i ##exons## | calc hetORhom IF(callCopies = 2,'hom','het') | varjoin -l -e 'NAN' -rprefix FATHER <(gor #wesVars# -f 'IO_GIAB_FATHER' ) | varjoin -l -e 'NAN' -rprefix MOTHER <(gor #wesVars# -f 'IO_GIAB_MOTHER' ) | calc fromFather 0 | calc fromMother 1 | calc IHEstatus IF(MOTHER_call = 'NAN' ,1,0) | varjoin -r <(gor [##VEPKNOWN##] | select 1-4,MAX_IMPACT,MAX_CONSEQUENCE,Consequence,max_Af,max_score,GENE,KNOWN_CatOne,KNOWN_MaxClinImpact,Gene_RmaxAf,Gene_RmaxGf,Gene_DmaxAf,Gene_MOI,HGMD_transcript,CLINVAR_transcript) | varjoin -l -e 0 -r [##Xctrlvars##] | calc Cat4 IF(homCTRLs > 0 or max_Af > 0.10,1,0) | calc Cat1 IF(Cat4 = 0 and KNOWN_CatOne = 'Cat1',1,0) | calc Cat1B IF(Cat4 = 0 and Cat1 = 0 and KNOWN_CatOne = 'Cat1B',1,0) | calc Cat1C IF(Cat4 = 0 and Cat1 = 0 and Cat1B = 0 and KNOWN_CatOne = 'Cat1C',1,0) | calc Cat1D IF(Cat4 = 0 and Cat1 = 0 and Cat1B = 0 and Cat1C = 0 and KNOWN_CatOne = 'Cat1D',1,0) | calc Cat2 IF(Cat4 = 0 and Cat1 = 0 and Cat1B = 0 and Cat1C = 0 and Cat1D = 0 and max_impact = 'HIGH',1,0) | calc Cat3A IF(Cat4 = 0 and Cat1 = 0 and Cat1B = 0 and Cat1C = 0 and Cat1D = 0 and Cat2=0 and (max_Consequence = 'missense_variant' and max_score >= 0.9),1,0) | calc Cat3B IF(Cat4 = 0 and Cat1 = 0 and Cat1B = 0 and Cat1C = 0 and Cat1D = 0 and Cat2=0 and Cat3A=0 and (max_impact = 'LOW' or (max_impact = 'MODERATE' and Cat3A = 0)),1,0) | calc Cat IF(Cat1>0,'Cat1',IF(Cat1B>0,'Cat1B',IF(Cat1C>0,'Cat1C',IF(Cat1D>0,'Cat1D',IF(Cat2>0,'Cat2',IF(Cat3A>0,'Cat3A',IF(Cat3B>0,'Cat3B','Cat4'))))))) | replace Cat4 IF(Cat = 'Cat4',1,0) | hide KNOWN_CatOne ) | calc GT_phase IF(fromFather = 0 and fromMother = 0,'U',IF(fromFather = 1 and fromMother = 0,'F',IF(fromFather = 0 and fromMother = 1,'M','H'))) ; def ##maleCTRLexvars## = gor ##genes##  | select 1-3,gene_symbol | join -segvar -f 10 -xl Gene_Symbol -xr Gene <( gor #wesVars# -f 'IO_GIAB_FATHER' | varjoin -r [##VEPKNOWN##] )  | select chrom,gene_start,gene_symbol,reference,call,pos,PN,Callcopies ; def ##femaleCTRLexvars## = gor ##genes##  | select 1-3,gene_symbol | join -segvar -f 10 -xl Gene_Symbol -xr Gene <( gor #wesVars# -f 'IO_GIAB_MOTHER' | varjoin -r [##VEPKNOWN##] )  | select chrom,gene_start,gene_symbol,reference,call,pos,PN,Callcopies;create ##Xchz## = gor -p chrX [##Xexvars##] | join -snpsnp [##Xexvars##] -xl PN,gene_symbol -xr PN,gene_symbol | where pos = posx and (hetORhom = 'hom' or call != callx) or pos != posx | calc GT_phases IF(hetORhom = 'hom','H',GT_phase+','+GT_phasex) | where max_Af*max_Afx <= Gene_RmaxGf | calc sum_Cat1 (Cat1+Cat1B+Cat1C)*IF(hetORhom='hom',2,1)+(Cat1x+Cat1Bx+Cat1Cx)*IF(pos != posx,1,0) | calc sum_Cat2 Cat2*IF(hetORhom='hom',2,1)+Cat2x*IF(pos != posx,1,0) | calc sum_Cat3a Cat3a*IF(hetORhom='hom',2,1)+Cat3ax*IF(pos != posx,1,0) | calc sum_Cat3b Cat3b*IF(hetORhom='hom',2,1)+Cat3bx*IF(pos != posx,1,0) | calc sum_Cat4 Cat4*IF(hetORhom='hom',2,1)+Cat4x*IF(pos != posx,1,0) | calc Diagnosis IF(sum_Cat1+sum_Cat2 > 1,'1:DxConsistent', IF(sum_Cat1+sum_cat2 > 0 and sum_Cat3a > 0,'2:DxLikely', IF(sum_Cat3a > 1 or (sum_Cat1+sum_Cat2+sum_Cat3a > 0 and sum_Cat3b > 0),'3:DxPossible', IF(sum_Cat3b > 1,'4:DxLessLikely', IF(sum_Cat1+sum_Cat2 > 0 and sum_Cat4 > 0,'5:DxIndeterminate', IF(sum_Cat3a+sum_Cat3b > 0 and sum_Cat4 > 0,'6:DxUnlikely','7:DxNegative')))))) | calc diag_order left(Diagnosis,1) | hide Cat4-Cat3B,sum_Cat1-sum_Cat4,Cat4x-Cat3Bx | select 1,pos,reference,call,hetorhom,PN,gene,posx,Cat,Catx,Diagnosis,Diag_order,GT_phases,referencex,callx | sort 3000000 | varjoin -n -xl posx,referencex,callx,gene -xr posx,referencex,callx,gene_symbol -maxseg 3000000 <(gor <(##femaleCTRLexvars##) | join -snpsnp <(##femaleCTRLexvars##) -xl PN,gene_symbol -xr PN,gene_symbol | where  pos != posx or pos = posx and (CallCopies = 2 or Call != Callx) | select chrom,pos,reference,call,posx,referencex,callx,gene_symbol | sort 3000000 | group 1 -gc reference,call,posx,referencex,callx,gene_symbol -count | where allCount > 0) | varjoin -n -xl gene -xr gene_symbol <(##maleCTRLexvars## | group 1 -gc reference,call,gene_symbol -count | where allCount > 0) | rank 1 -gc reference,call,pn,gene diag_order -o asc | where rank_diag_order = 1 | group 1 -gc reference,call,hetorhom,PN,gene,Cat,Diagnosis -set -sc Catx,posx,GT_phases | rename set_GT_phases DIAG_compPhases | rename Cat ACMGcat | rename set_Catx otherACMGcat | rename set_posx otherPos | replace otherPos replace(replace(replace(otherPos,','+pos,''),pos+',',''),pos,'') | replace otherACMGcat IF(otherPos='','',otherACMGcat) | rename Diagnosis recessiveCat | prefix ACMGcat-otherACMGcat DIAG | hide hetORhom,PN | rename GENE GENE_symbol ; def ##XCCexvars## = gor ##genes## | select 1-3,gene_symbol | join -segvar -f 10 -xl gene_symbol -xr gene <( gor #wesVars# -f 'IO_GIAB_MOTHER' | calc hetORhom IF(callCopies = 2,'hom','het') | varjoin -r <(gor [##VEPKNOWN##] | select 1-4,MAX_IMPACT,MAX_CONSEQUENCE,Consequence,max_Af,max_score,GENE,KNOWN_CatOne,KNOWN_MaxClinImpact,Gene_RmaxAf,Gene_RmaxGf,Gene_DmaxAf,Gene_MOI,HGMD_transcript,CLINVAR_transcript) | calc Cat4 IF(max_Af > 0.10,1,0) | calc Cat1 IF(Cat4 = 0 and KNOWN_CatOne = 'Cat1',1,0) | calc Cat1B IF(Cat4 = 0 and Cat1 = 0 and KNOWN_CatOne = 'Cat1B',1,0) | calc Cat1C IF(Cat4 = 0 and Cat1 = 0 and Cat1B = 0 and KNOWN_CatOne = 'Cat1C',1,0) | calc Cat1D IF(Cat4 = 0 and Cat1 = 0 and Cat1B = 0 and Cat1C = 0 and KNOWN_CatOne = 'Cat1D',1,0) | calc Cat2 IF(Cat4 = 0 and Cat1 = 0 and Cat1B = 0 and Cat1C = 0 and Cat1D = 0 and max_impact = 'HIGH',1,0) | calc Cat3A IF(Cat4 = 0 and Cat1 = 0 and Cat1B = 0 and Cat1C = 0 and Cat1D = 0 and Cat2=0 and (max_Consequence = 'missense_variant' and max_score >= 0.9),1,0) | calc Cat3B IF(Cat4 = 0 and Cat1 = 0 and Cat1B = 0 and Cat1C = 0 and Cat1D = 0 and Cat2=0 and Cat3A=0 and (max_impact = 'LOW' or (max_impact = 'MODERATE' and Cat3A = 0)),1,0) | calc Cat IF(Cat1>0,'Cat1',IF(Cat1B>0,'Cat1B',IF(Cat1C>0,'Cat1C',IF(Cat1D>0,'Cat1D',IF(Cat2>0,'Cat2',IF(Cat3A>0,'Cat3A',IF(Cat3B>0,'Cat3B','Cat4'))))))) | replace Cat4 IF(Cat = 'Cat4',1,0) | hide KNOWN_CatOne );create ##XCCchz## = gor -p chrX <(##XCCexvars##) | join -snpsnp <(##XCCexvars##) -xl PN,gene_symbol -xr PN,gene_symbol | where pos = posx and (hetORhom = 'hom' or call != callx) or pos != posx | where max_Af*max_Afx <= Gene_RmaxGf | calc sum_Cat1 (Cat1+Cat1B+Cat1C)*IF(hetORhom='hom',2,1)+(Cat1x+Cat1Bx+Cat1Cx)*IF(pos != posx,1,0) | calc sum_Cat2 Cat2*IF(hetORhom='hom',2,1)+Cat2x*IF(pos != posx,1,0) | calc sum_Cat3a Cat3a*IF(hetORhom='hom',2,1)+Cat3ax*IF(pos != posx,1,0) | calc sum_Cat3b Cat3b*IF(hetORhom='hom',2,1)+Cat3bx*IF(pos != posx,1,0) | calc sum_Cat4 Cat4*IF(hetORhom='hom',2,1)+Cat4x*IF(pos != posx,1,0) | calc Diagnosis IF(sum_Cat1+sum_Cat2 > 1,'1:DxConsistent', IF(sum_Cat1+sum_cat2 > 0 and sum_Cat3a > 0,'2:DxLikely', IF(sum_Cat3a > 1 or (sum_Cat1+sum_Cat2+sum_Cat3a > 0 and sum_Cat3b > 0),'3:DxPossible', IF(sum_Cat3b > 1,'4:DxLessLikely', IF(sum_Cat1+sum_Cat2 > 0 and sum_Cat4 > 0,'5:DxIndeterminate', IF(sum_Cat3a+sum_Cat3b > 0 and sum_Cat4 > 0,'6:DxUnlikely','7:DxNegative')))))) | calc diag_order left(Diagnosis,1) | select chrom,gene_start,gene_end,gene_symbol,PN,diag_order | calc d1 IF(diag_order = 1,1,0) | calc d2 IF(diag_order <= 2,1,0) | calc d3 IF(diag_order <= 3,1,0) | calc d4 IF(diag_order <= 4,1,0) | group chrom -gc gene_start,gene_end,gene_symbol,PN -max -ic d1,d2,d3,d4 | calc PNtype IF(PN = 'IO_GIAB_MOTHER','MOTHER',IF(PN = 'IO_GIAB_FATHER','FATHER','UNKNOWN')) | split PNtype | where PNtype != 'FATHER' | group chrom -gc gene_start,gene_end,gene_symbol,PNtype -sum -ic max_d1,max_d2,max_d3,max_d4 | rename sum_max_d1 DxConsInGene | rename sum_max_d2 DxLikeInGene | rename sum_max_d3 DxPossInGene | rename sum_max_d4 DxLessInGene | select 1,gene_start- | sort chrom | pivot -gc gene_End,GENE_symbol PNtype -v FATHER,MOTHER -e 0;create ##Xfinal## = gor -p chrX <(##Xlinkedreport##) | varjoin -l -r -xl gene_symbol -xr gene_symbol -rprefix DIAG -maxseg 3000000 <(gor [##Xexvars##] | select 1,pos,reference,call,gene_symbol | sort 3000000 | distinct) | hide DIAG_GENE_SYMBOL | varjoin -r -l -xl GENE_SYMBOL -xr GENE_SYMBOL [##Xchz##] | hide GENE_SYMBOLx,DIAG_ACMGcatx | join -varseg -l -e 0 -f 10 -r -xl GENE_SYMBOL -xr GENE_SYMBOL [##XCCchz##] | hide GENE_SYMBOLx | replace DIAG_HomRecess IF(DIAG_recessiveCat = '','false',DIAG_HomRecess) | replace DIAG_CHZ IF(DIAG_recessiveCat = '','false',DIAG_CHZ) | calc DIAG_model = 'Xlinked' | calc recessive_score IF(hetORhom = 'hom',2,0)+IF(DIAG_recessiveCat='1:DxConsistent',4,IF(DIAG_recessiveCat='2:DxLikely',2,IF(DIAG_recessiveCat='3:DxPossible',1,0)))+ (-0.25*(MOTHER_withHomoVar+MOTHER_DxConsInGene+MOTHER_DxLikeInGene+MOTHER_DxPossInGene))+ 0.0 | calc dominant_score 0.0+ IF(FATHER_withVar = 0,2,0)+ IF(MOTHER_withVar = 0,2,0)+ 0.0 | hide FATHER_DxConsInGene,FATHER_DxLessInGene,FATHER_DxLikeInGene,FATHER_DxPossInGene,FATHER_subjWithKnownVarInGene,FATHER_varsInGene | hide MOTHER_DxConsInGene,MOTHER_DxLessInGene,MOTHER_DxLikeInGene,MOTHER_DxPossInGene,MOTHER_subjWithKnownVarInGene,MOTHER_varsInGene | varjoin -l -r ##dbSNP##;create ##uncommentedreport## = gor [##final##] | merge [##Xfinal##] | rank genome recessive_score -o desc | rank genome dominant_score -o desc | hide recessive_score,dominant_score | rename rank_recessive_score DIAG_rank_recessive | rename rank_dominant_score DIAG_rank_dominant | join -varseg -l -f 10 -r -xl gene_symbol -xr gene_symbol <(gor ##genes## | map ##gmap## -c gene_symbol -m ? -n GENE_Aliases,OMIM_IDs,OMIM_Descriptions,GENE_Paralogs,GO_IDs,GO_Descriptions) | hide gene_symbolx | varjoin -r -l -e 'NAN' -rprefix FATHER [##fathercov##] | varjoin -r -l -e 'NAN' -rprefix MOTHER [##mothercov##] | join -l -varseg -r -f 10 -xl gene_symbol -xr gene_symbol [##theAliasCandidateGenes##] | hide gene_symbolx | replace Gene_Cand_PhenoScore if(Gene_Cand_PhenoScore='','0',str(Gene_Cand_PhenoScore)) | calc varType if(len(reference)=len(call),'sub',if(len(call)<len(reference) and substr(reference,0,len(call)) = call,'del',if(len(call)>len(reference) and substr(call,0,len(reference)) = reference,'ins','indel') )) | calc Sequence_Variant chrom+':'+pos+Reference+'>'+Call+', ' + Gene_symbol + ', '+HGVSc + if(len(HGVSp)>1,' ('+ if(posof(HGVSp,':p.')>0,substr(HGVSp,1+posof(HGVSp,':p.'),1000),HGVSp)+')','') +', '+if(DIAG_ACMGcat != '',DIAG_ACMGcat+', ','') +if(hetORhom != 'NAN',hetORhom+'_','') +varType +', '+VEP_Consequence | varjoin -l -r <(gor ##hgmd## | select 1-4,pmid | rename pmid Known_pmid ) | join -varseg -l -f 10 -r -rprefix GENE -xl gene_symbol -xr gene_symbol <(gor source/cov/gene_cov_all_seg.gord -s PN -f 'IO_GIAB_INDEX' | map -c gene_symbol ##gmap## -n gene_aliases -m 'missing' | split gene_aliases | replace gene_symbol if(gene_aliases != 'missing',gene_aliases,gene_symbol) | hide gene_aliases) | join -varseg -l -f 10 -r -rprefix KNOWN -xl GENE_symbol -xr GENE_SYMBOL <(gor [##pardiseases##] | select 1-3,gene_symbol,gene_diseases,gene_par_diseases | replace gene_diseases if(listsize(#rc)>1,'\"'+replace(#rc,',','\", \"')+'\"',#rc) ) | hide GENE_gene_symbol,GENE_PN,KNOWN_GENE_SYMBOL | join -varseg -l -r -xl gene_symbol -xr gene_symbol <(gor ##genes## | map ##gdismap## -c gene_symbol -h -m '' | map ##CGDmap## -c gene_symbol -h -m '' | select 1-3,gene_symbol,gene_in_disease,MANIFESTATION_CATEGORIES,INTERVENTION_RATIONALE,COMMENTS,INTERVENTION_CATEGORIES,REFERENCES,CONDITION,INHERITANCE,AGE_GROUP | rename Gene_in_disease KNOWN_GeneLists | prefix 6#- CGD | replace CGD_inheritance trim(CGD_inheritance) | replace KNOWN_GeneLists listfilter(KNOWN_GeneLists,'len(x)>0') | join -segseg -r -l -xl gene_symbol -xr gene_symbol <(gor ##genepaneldiseases## | split diseases | rename panel panels | group 1 -gc #3,gene_symbol -len 10000 -set -dis -sc panels,diseases | replace set* if(listsize(#rc)>1,'\"'+replace(#rc,',','\", \"')+'\"',#rc) | rename set_(.*) EuroGenetest_#{1} | rename dis_(.*) EuroGenetest_NoOf#{1} ) ) | hide gene_symbolx,gene_symbolxx | calc KNOWN_InACMG IF(contains(KNOWN_GeneLists,'acmg'),'true','false') | varjoin -r -l [##CLINVARHGMD##] | columnsort 1,2,Reference,Call,hetORhom,PN,Gene_Symbol,Sequence_Variant,Carrier,DIAG*,VEP* | rename VEP_max_af VEP_Max_Af;create ##index_annotations## = variant_annotations -f 'IO_GIAB_INDEX' | where type='SampleAnnotation'  and study_id = '2' | hide mode_of_inheritance,variant_review_status,clinical_significance | varjoin -r -l -xl acmg_variant_annotation_id -xr id <(gor #ACMGannotations# | select 1-4,mode_of_inheritance,variant_review_status,acmg_classification,id | rename acmg_classification clinical_significance) | where '00000101000000' = '00000101000000';create ##project_annotations## = gor source/anno/approved_annotations_file.gor | verifyorder | where PN != 'IO_GIAB_INDEX' and type='SampleAnnotation' | hide mode_of_inheritance,variant_review_status,clinical_significance | varjoin -r -l -xl acmg_variant_annotation_id -xr id <(gor #ACMGannotations# | select 1-4,mode_of_inheritance,variant_review_status,acmg_classification,id | rename acmg_classification clinical_significance) | where variant_review_status = 'APPROVED_AND_CURRENT' | calc active_annotations 1 | select 1-4,active_annotations,gene_symbol;create ##ACMGannotations## = gor #ACMGannotations# | replace acmg_classification if(acmg_classification='','no classification',acmg_classification) | replace variant_review_status if(variant_review_status='','no status',variant_review_status) | calc status variant_review_status + '/' + acmg_classification | group 1 -gc #3,#4,gene_symbol -lis -sc ext_disease_id,transcript_feature,status | rename lis_(.*) #{1} | select 1-4,status,gene_symbol;create ##denovoreads## = pgor #wesVars# -f 'IO_GIAB_INDEX' | select 1,2,reference,call | distinct  | varjoin -r -l -e 0 <(gor source/var/candidate_variants.gord -f 'IO_GIAB_FATHER' ) | rename varCount FATHER_readsWithVar | varjoin -r -l -e 0 <(gor source/var/candidate_variants.gord -f 'IO_GIAB_MOTHER' ) | rename varCount MOTHER_readsWithVar;create ##thefinalreport## = pgor [##uncommentedreport##] | varjoin -r -l -e '-1' [##denovoreads##] | calc DIAG_deNovo IF(GT_IHEstatus = 1 and VEP_max_Af <= Gene_DmaxAf and int(FATHER_apprCovDepth) >= 8 and int(MOTHER_apprCovDepth) >= 8 and (FATHER_readsWithVar <= 1 or float(FATHER_readsWithVar)/int(FATHER_apprCovDepth) <= 0.1) and (MOTHER_readsWithVar <= 1 or float(MOTHER_readsWithVar)/int(MOTHER_apprCovDepth) <= 0.1),'true','false') | replace DIAG_Dominant IF(DIAG_deNovo = 'true' or not(int(FATHER_apprCovDepth) >= 8 and int(MOTHER_apprCovDepth) >= 8),'false',Diag_Dominant) | varjoin -r -l -e '' -xl gene_symbol -xr gene_symbol -rprefix COMM <(gor [##index_annotations##]) | varjoin -r -l -e '' -xl gene_symbol -xr gene_symbol -rprefix COMM_OTHER <(gor [##project_annotations##]) | varjoin -r -l -e '' -xl gene_symbol -xr gene_symbol -rprefix ACMG_ANNO <(gor [##ACMGannotations##]) | replace DIAG_HomRecess,DIAG_CHZ if(chrom = 'chrY','false',#rc) | calc Gene_cov if(isfloat(gene_lt5),'L:'+form(gene_lt5,4,2)+'M:'+form((gene_lt10-gene_lt5),4,2)+'H:'+form((1-gene_lt10),4,2),'NAN') | columnsort 1,2,Reference,Call,hetORhom,PN,Sequence_Variant,ACMG_ANNO_status,Carrier,DIAG*,CGD*,VEP*,GENE*;create part_49 = gor [##thefinalreport##]  | distinct;gor [part_49] ";
    private static final String query2 = "create ##a## = pgor #dbsnp# | top 100;\n" +
            "create ##b## = pgor #dbsnp# | top 101;\n" +
            "gor [##a##] | merge  <(gor [##b##])";

    @Test
    public void testJSONParse() throws JsonProcessingException {
        Map<String, String> stringMap = new HashMap<>();
        stringMap.put("query", query1);
        stringMap.put("projectname", "clinex85");
        stringMap.put("flags", "H");
        stringMap.put("securityContextKey", "5C5F5F9EC86B74AE1067C42AC0B01F44");
        stringMap.put("request-id", "a0f8acb5-afc3-4538-ba66-0b3a6f3e80e2");
        stringMap.put("userName", "system_admin");
        stringMap.put("querySource", "queryService");
        stringMap.put("fingerprint", "j77ipg5p14ia02nicl6eigf2f25");
        stringMap.put("originalQuery", query2);
        stringMap.put("time", "1538481250");
        stringMap.put("project-id", "2");

        Set<String> keys = new HashSet<>();
        keys.add("query");
        keys.add("originalQuery");

        Map<String, String> encodedStringMap = Base64Utils.base64Encode(stringMap, keys);
        String jsonString = JsonUtils.writeValueAsArrayString(encodedStringMap);
        Assert.assertTrue(JsonRead(jsonString));
    }

    private boolean JsonRead(String string) {
        try {
            JsonUtils.parseJsonArrayValue(string);
            return true;
        } catch (Exception e) {
            return false;
        }
    }
}