using System.Collections.Generic;
using Microsoft.Extensions.Options;
using Orleans.Runtime;

namespace Orleans.Configuration
{
    /// <summary>
    /// Settings which regulate the placement of grains across a cluster.
    /// </summary>
    public class GrainPlacementOptions
    {
        /// <summary>
        /// Default strategy used for placeing grains across a cluster.
        /// </summary>
        public string DefaultPlacementStrategy { get; set; } = DEFAULT_PLACEMENT_STRATEGY;
        public static readonly string DEFAULT_PLACEMENT_STRATEGY = nameof(RandomPlacement);

        /// <summary>
        /// Number of silos randomly selected for consideration when using activation count placement policy.
        /// Only used with Activation Count placement policy.
        /// </summary>
        public int ActivationCountPlacementChooseOutOf { get; set; } = DEFAULT_ACTIVATION_COUNT_PLACEMENT_CHOOSE_OUT_OF;
        public const int DEFAULT_ACTIVATION_COUNT_PLACEMENT_CHOOSE_OUT_OF = 2;
    }
}
