---
description: |
    The breakpoint provisioner will pause until the user presses "enter" to
    resume the build. This is intended for debugging purposes, and allows you
    to halt at a particular part of the provisioning process.
layout: docs
page_title: 'breakpoint - Provisioners'
sidebar_current: 'docs-provisioners-breakpoint'
---

# Breakpoint Provisioner

Type: `breakpoint`

The breakpoint provisioner will pause until the user presses "enter" to
resume the build. This is intended for debugging purposes, and allows you
to halt at a particular part of the provisioning process.

This is independent of the `-debug` flag, which will instead halt at every step
and between every provisioner.

## Basic Example

``` json
{
  "type": "breakpoint",
  "note": "foo bar baz"
}
```

## Configuration Reference

### Optional

-   `disable` (boolean) - If `true`, skip the breakpoint. Useful for when you
    have set multiple breakpoints and want to toggle them off or on.
    Default: `false`

-   `note` (string) - a string to include explaining the purpose or location of
    the breakpoint. For example, you may find it useful to number your
    breakpoints or label them with information about where in the build they
    occur

## Usage

Insert this provisioner wherever you want the build to pause. You'll see ui
output prompting you to press "enter" to continue the build when you are ready.

For example:

```
==> docker: Pausing at breakpoint provisioner with note "foo bar baz".
==> docker: Press enter to continue.
```

Once you press enter, the build will resume and run normally until it either
completes or errors.