/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.yamlbeans;

import com.esotericsoftware.yamlbeans.DeferredConstruction;
import com.esotericsoftware.yamlbeans.YamlConfig;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Beans {
    private Beans() {
    }

    public static boolean isScalar(Class clazz) {
        return clazz.isPrimitive() || clazz == String.class || clazz == Integer.class || clazz == Boolean.class || clazz == Float.class || clazz == Long.class || clazz == Double.class || clazz == Short.class || clazz == Byte.class || clazz == Character.class;
    }

    public static DeferredConstruction getDeferredConstruction(Class clazz, YamlConfig yamlConfig) {
        YamlConfig.ConstructorParameters constructorParameters = yamlConfig.readConfig.constructorParameters.get(clazz);
        if (constructorParameters != null) {
            return new DeferredConstruction(constructorParameters.constructor, constructorParameters.parameterNames);
        }
        try {
            Class<?> clazz2 = Class.forName("java.beans.ConstructorProperties");
            for (Constructor<?> constructor : clazz.getConstructors()) {
                Object obj = constructor.getAnnotation(clazz2);
                if (obj == null) continue;
                String[] stringArray = (String[])clazz2.getMethod("value", new Class[0]).invoke(obj, (Object[])null);
                return new DeferredConstruction(constructor, stringArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean canInitializeProperty(Class clazz, PropertyDescriptor propertyDescriptor, YamlConfig yamlConfig) {
        if (propertyDescriptor.getWriteMethod() != null) {
            return true;
        }
        DeferredConstruction deferredConstruction = Beans.getDeferredConstruction(clazz, yamlConfig);
        return deferredConstruction != null && deferredConstruction.hasParameter(propertyDescriptor.getName());
    }

    public static Object createObject(Class clazz, boolean bl) throws InvocationTargetException {
        Constructor<Object> constructor = null;
        for (Constructor<?> constructor2 : clazz.getConstructors()) {
            if (constructor2.getParameterTypes().length != 0) continue;
            constructor = constructor2;
            break;
        }
        if (constructor == null && bl) {
            try {
                constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (constructor == null) {
            try {
                if (List.class.isAssignableFrom(clazz)) {
                    constructor = ArrayList.class.getConstructor(new Class[0]);
                } else if (Set.class.isAssignableFrom(clazz)) {
                    constructor = HashSet.class.getConstructor(new Class[0]);
                } else if (Map.class.isAssignableFrom(clazz)) {
                    constructor = HashMap.class.getConstructor(new Class[0]);
                }
            }
            catch (Exception exception) {
                throw new InvocationTargetException(exception, "Error getting constructor for class: " + clazz.getName());
            }
        }
        if (constructor == null) {
            throw new InvocationTargetException(null, "Unable to find a no-arg constructor for class: " + clazz.getName());
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception, "Error constructing instance of class: " + clazz.getName());
        }
    }

    public static Set<Property> getProperties(Class clazz, boolean bl, boolean bl2, YamlConfig yamlConfig) throws IntrospectionException {
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        TreeSet<Property> treeSet = new TreeSet<Property>();
        if (bl) {
            for (PropertyDescriptor propertyDescriptor : Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
                if (propertyDescriptor.getReadMethod() == null || !Beans.canInitializeProperty(clazz, propertyDescriptor, yamlConfig)) continue;
                treeSet.add(new MethodProperty(clazz, propertyDescriptor));
            }
        }
        for (Field field : Beans.getAllFields(clazz)) {
            int n = field.getModifiers();
            if (Modifier.isStatic(n) || Modifier.isTransient(n)) continue;
            if (!Modifier.isPublic(n)) {
                if (!bl2) continue;
                field.setAccessible(true);
            }
            treeSet.add(new FieldProperty(field));
        }
        return treeSet;
    }

    public static Property getProperty(Class clazz, String string, boolean bl, boolean bl2, YamlConfig yamlConfig) throws IntrospectionException {
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("name cannot be null or empty.");
        }
        if (bl) {
            for (PropertyDescriptor propertyDescriptor : Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
                if (!propertyDescriptor.getName().equals(string)) continue;
                if (propertyDescriptor.getReadMethod() == null || !Beans.canInitializeProperty(clazz, propertyDescriptor, yamlConfig)) break;
                return new MethodProperty(clazz, propertyDescriptor);
            }
        }
        for (Field field : Beans.getAllFields(clazz)) {
            int n = field.getModifiers();
            if (Modifier.isStatic(n) || Modifier.isTransient(n)) continue;
            if (!Modifier.isPublic(n)) {
                if (!bl2) continue;
                field.setAccessible(true);
            }
            if (!field.getName().equals(string)) continue;
            return new FieldProperty(field);
        }
        return null;
    }

    private static ArrayList<Field> getAllFields(Class clazz) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Class clazz2 = clazz; clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
            Collections.addAll(arrayList, clazz2.getDeclaredFields());
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Property
    implements Comparable<Property> {
        private final Class declaringClass;
        private final String name;
        private final Class type;

        public Property(Class clazz, String string, Class clazz2) {
            this.declaringClass = clazz;
            this.name = string;
            this.type = clazz2;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.declaringClass == null ? 0 : this.declaringClass.hashCode());
            n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
            n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Property property = (Property)object;
            if (this.declaringClass == null ? property.declaringClass != null : !this.declaringClass.equals(property.declaringClass)) {
                return false;
            }
            if (this.name == null ? property.name != null : !this.name.equals(property.name)) {
                return false;
            }
            return !(this.type == null ? property.type != null : !this.type.equals(property.type));
        }

        public Class getDeclaringClass() {
            return this.declaringClass;
        }

        public Class getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(Property property) {
            int n = this.name.compareTo(property.name);
            if (n != 0) {
                if (this.name.equals("id")) {
                    return -1;
                }
                if (property.name.equals("id")) {
                    return 1;
                }
                if (this.name.equals("name")) {
                    return -1;
                }
                if (property.name.equals("name")) {
                    return 1;
                }
            }
            return n;
        }

        public abstract void set(Object var1, Object var2) throws Exception;

        public abstract Object get(Object var1) throws Exception;
    }

    public static class FieldProperty
    extends Property {
        private final Field field;

        public FieldProperty(Field field) {
            super(field.getDeclaringClass(), field.getName(), field.getType());
            this.field = field;
        }

        public void set(Object object, Object object2) throws Exception {
            if (object instanceof DeferredConstruction) {
                ((DeferredConstruction)object).storeProperty(this, object2);
                return;
            }
            this.field.set(object, object2);
        }

        public Object get(Object object) throws Exception {
            return this.field.get(object);
        }
    }

    public static class MethodProperty
    extends Property {
        private final PropertyDescriptor property;

        public MethodProperty(Class clazz, PropertyDescriptor propertyDescriptor) {
            super(clazz, propertyDescriptor.getName(), propertyDescriptor.getPropertyType());
            this.property = propertyDescriptor;
        }

        public void set(Object object, Object object2) throws Exception {
            if (object instanceof DeferredConstruction) {
                ((DeferredConstruction)object).storeProperty(this, object2);
                return;
            }
            this.property.getWriteMethod().invoke(object, object2);
        }

        public Object get(Object object) throws Exception {
            return this.property.getReadMethod().invoke(object, new Object[0]);
        }
    }
}

