/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.yamlbeans;

import com.esotericsoftware.yamlbeans.Beans;
import com.esotericsoftware.yamlbeans.YamlConfig;
import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.YamlReader;
import com.esotericsoftware.yamlbeans.emitter.Emitter;
import com.esotericsoftware.yamlbeans.emitter.EmitterException;
import com.esotericsoftware.yamlbeans.parser.AliasEvent;
import com.esotericsoftware.yamlbeans.parser.DocumentStartEvent;
import com.esotericsoftware.yamlbeans.parser.Event;
import com.esotericsoftware.yamlbeans.parser.MappingStartEvent;
import com.esotericsoftware.yamlbeans.parser.ScalarEvent;
import com.esotericsoftware.yamlbeans.parser.SequenceStartEvent;
import com.esotericsoftware.yamlbeans.scalar.ScalarSerializer;
import java.beans.IntrospectionException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class YamlWriter {
    private final YamlConfig config;
    private final Emitter emitter;
    private boolean started;
    private Map<Class, Object> defaultValuePrototypes = new IdentityHashMap<Class, Object>();
    private final List queuedObjects = new ArrayList();
    private final Map<Object, Integer> referenceCount = new IdentityHashMap<Object, Integer>();
    private final Map<Object, String> anchoredObjects = new HashMap<Object, String>();
    private int nextAnchor = 1;
    private boolean isRoot;

    public YamlWriter(Writer writer) {
        this(writer, new YamlConfig());
    }

    public YamlWriter(Writer writer, YamlConfig yamlConfig) {
        this.config = yamlConfig;
        this.emitter = new Emitter(writer, yamlConfig.writeConfig.emitterConfig);
    }

    public void write(Object object) throws YamlException {
        if (this.config.writeConfig.autoAnchor) {
            this.countObjectReferences(object);
            this.queuedObjects.add(object);
            return;
        }
        this.writeInternal(object);
    }

    public YamlConfig getConfig() {
        return this.config;
    }

    private void writeInternal(Object object) throws YamlException {
        try {
            if (!this.started) {
                this.emitter.emit(Event.STREAM_START);
                this.started = true;
            }
            this.emitter.emit(new DocumentStartEvent(this.config.writeConfig.explicitFirstDocument, null, null));
            this.isRoot = true;
            this.writeValue(object, this.config.writeConfig.writeRootTags ? null : object.getClass(), null, null);
            this.emitter.emit(Event.DOCUMENT_END_FALSE);
        }
        catch (EmitterException emitterException) {
            throw new YamlException("Error writing YAML.", emitterException);
        }
        catch (IOException iOException) {
            throw new YamlException("Error writing YAML.", iOException);
        }
    }

    public Emitter getEmitter() {
        return this.emitter;
    }

    public void clearAnchors() throws YamlException {
        for (Object e : this.queuedObjects) {
            this.writeInternal(e);
        }
        this.queuedObjects.clear();
        this.referenceCount.clear();
        this.nextAnchor = 1;
    }

    public void close() throws YamlException {
        this.clearAnchors();
        this.defaultValuePrototypes.clear();
        try {
            this.emitter.emit(Event.STREAM_END);
            this.emitter.close();
        }
        catch (EmitterException emitterException) {
            throw new YamlException(emitterException);
        }
        catch (IOException iOException) {
            throw new YamlException(iOException);
        }
    }

    private void writeValue(Object object, Class clazz, Class clazz2, Class clazz3) throws EmitterException, IOException, YamlException {
        Set<Beans.Property> set;
        Object object2;
        boolean bl;
        boolean bl2 = this.isRoot;
        this.isRoot = false;
        if (object == null) {
            this.emitter.emit(new ScalarEvent(null, null, new boolean[]{true, true}, null, '\u0000'));
            return;
        }
        Class<?> clazz4 = object.getClass();
        boolean bl3 = bl = clazz == null;
        if (bl) {
            clazz = clazz4;
        }
        if (Beans.isScalar(clazz4)) {
            this.emitter.emit(new ScalarEvent(null, null, new boolean[]{true, true}, String.valueOf(object), '\u0000'));
            return;
        }
        if (object instanceof Enum) {
            this.emitter.emit(new ScalarEvent(null, null, new boolean[]{true, true}, ((Enum)object).name(), '\u0000'));
            return;
        }
        String string = null;
        if (this.config.writeConfig.autoAnchor) {
            object2 = this.referenceCount.get(object);
            if (object2 == null) {
                this.emitter.emit(new AliasEvent(this.anchoredObjects.get(object)));
                return;
            }
            if ((Integer)object2 > 1) {
                this.referenceCount.remove(object);
                string = String.valueOf(this.nextAnchor++);
                this.anchoredObjects.put(object, string);
            }
        }
        object2 = null;
        boolean bl4 = false;
        if (bl || clazz4 != clazz || this.config.writeConfig.alwaysWriteClassName) {
            bl4 = true;
            if ((bl || clazz == List.class) && clazz4 == ArrayList.class) {
                bl4 = false;
            }
            if ((bl || clazz == Map.class) && clazz4 == HashMap.class) {
                bl4 = false;
            }
            if (clazz == Set.class && clazz4 == HashSet.class) {
                bl4 = false;
            }
            if (clazz4 == clazz3) {
                bl4 = false;
            }
            if (bl4 && (object2 = this.config.classNameToTag.get(clazz4.getName())) == null) {
                object2 = clazz4.getName();
            }
        }
        for (Map.Entry<Class, ScalarSerializer> entry2 : this.config.scalarSerializers.entrySet()) {
            if (!entry2.getKey().isAssignableFrom(clazz4)) continue;
            ScalarSerializer scalarSerializer = entry2.getValue();
            this.emitter.emit(new ScalarEvent(null, (String)object2, new boolean[]{object2 == null, object2 == null}, scalarSerializer.write(object), '\u0000'));
            return;
        }
        if (object instanceof Collection) {
            this.emitter.emit(new SequenceStartEvent(string, (String)object2, !bl4, false));
            for (Map.Entry<Class<Object>, ScalarSerializer<Object>> invocationTargetException : (Collection)object) {
                if (bl2 && !this.config.writeConfig.writeRootElementTags) {
                    clazz2 = invocationTargetException.getClass();
                }
                this.writeValue(invocationTargetException, clazz2, null, null);
            }
            this.emitter.emit(Event.SEQUENCE_END);
            return;
        }
        if (object instanceof Map) {
            this.emitter.emit(new MappingStartEvent(string, (String)object2, !bl4, false));
            for (Object e : ((Map)object).entrySet()) {
                Map.Entry entry = (Map.Entry)e;
                this.writeValue(entry.getKey(), null, null, null);
                if (bl2 && !this.config.writeConfig.writeRootElementTags) {
                    clazz2 = entry.getValue().getClass();
                }
                this.writeValue(entry.getValue(), clazz2, null, null);
            }
            this.emitter.emit(Event.MAPPING_END);
            return;
        }
        if (clazz.isArray()) {
            clazz2 = clazz.getComponentType();
            this.emitter.emit(new SequenceStartEvent(string, null, true, false));
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                this.writeValue(Array.get(object, i), clazz2, null, null);
            }
            this.emitter.emit(Event.SEQUENCE_END);
            return;
        }
        Object object3 = null;
        if (!this.config.writeConfig.writeDefaultValues && clazz4 != Class.class && (object3 = this.defaultValuePrototypes.get(clazz4)) == null && Beans.getDeferredConstruction(clazz4, this.config) == null) {
            try {
                object3 = Beans.createObject(clazz4, this.config.privateConstructors);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new YamlException("Error creating object prototype to determine default values.", invocationTargetException);
            }
            this.defaultValuePrototypes.put(clazz4, object3);
        }
        try {
            set = Beans.getProperties(clazz4, this.config.beanProperties, this.config.privateFields, this.config);
        }
        catch (IntrospectionException introspectionException) {
            throw new YamlException("Error inspecting class: " + clazz4.getName(), introspectionException);
        }
        this.emitter.emit(new MappingStartEvent(string, (String)object2, !bl4, false));
        for (Beans.Property property : set) {
            try {
                Object object4;
                Object object5 = property.get(object);
                if (object3 != null) {
                    object4 = property.get(object3);
                    if (object5 == null && object4 == null || object5 != null && object4 != null && object4.equals(object5)) continue;
                }
                this.emitter.emit(new ScalarEvent(null, null, new boolean[]{true, true}, property.getName(), '\u0000'));
                object4 = this.config.propertyToElementType.get(property);
                Class clazz5 = this.config.propertyToDefaultType.get(property);
                this.writeValue(object5, property.getType(), (Class)object4, clazz5);
            }
            catch (Exception exception) {
                throw new YamlException("Error getting property '" + property + "' on class: " + clazz4.getName(), exception);
            }
        }
        this.emitter.emit(Event.MAPPING_END);
    }

    private void countObjectReferences(Object object) throws YamlException {
        Set<Beans.Property> set;
        if (object == null || Beans.isScalar(object.getClass())) {
            return;
        }
        Integer n = this.referenceCount.get(object);
        if (n != null) {
            this.referenceCount.put(object, n + 1);
            return;
        }
        this.referenceCount.put(object, 1);
        if (object instanceof Collection) {
            for (Object e : (Collection)object) {
                this.countObjectReferences(e);
            }
            return;
        }
        if (object instanceof Map) {
            for (Object v : ((Map)object).values()) {
                this.countObjectReferences(v);
            }
            return;
        }
        if (object.getClass().isArray()) {
            int n2 = Array.getLength(object);
            for (int i = 0; i < n2; ++i) {
                this.countObjectReferences(Array.get(object, i));
            }
            return;
        }
        try {
            set = Beans.getProperties(object.getClass(), this.config.beanProperties, this.config.privateFields, this.config);
        }
        catch (IntrospectionException introspectionException) {
            throw new YamlException("Error inspecting class: " + object.getClass().getName(), introspectionException);
        }
        for (Beans.Property property : set) {
            Object object2;
            if (Beans.isScalar(property.getType())) continue;
            try {
                object2 = property.get(object);
            }
            catch (Exception exception) {
                throw new YamlException("Error getting property '" + property + "' on class: " + object.getClass().getName(), exception);
            }
            this.countObjectReferences(object2);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        YamlConfig yamlConfig = new YamlConfig();
        yamlConfig.writeConfig.setAutoAnchor(true);
        YamlReader yamlReader = new YamlReader(new FileReader("test/test.yml"));
        YamlWriter yamlWriter = new YamlWriter(new OutputStreamWriter(System.out));
        yamlWriter.write(yamlReader.read());
    }
}

