/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.app;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.program.indexdb.BioStore;
import org.biojava.bio.program.indexdb.IndexTools;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.utils.lsid.LifeScienceIdentifier;
import org.biojava.utils.lsid.LifeScienceIdentifierParseException;

public class BioFlatIndex {
    public static void main(String[] argv) throws Exception {
        Options opts = BioFlatIndex.createOptions();
        try {
            CommandLine cmd = new GnuParser().parse(opts, argv);
            String alphabet = "";
            String format = "";
            String dbName = "";
            String location = "";
            boolean create = cmd.hasOption('c');
            if (cmd.hasOption('h')) {
                BioFlatIndex.exitHelp(opts, 0);
            }
            location = cmd.hasOption('l') ? cmd.getOptionValue('l') : System.getProperty("user.dir");
            if (cmd.hasOption('d')) {
                dbName = cmd.getOptionValue('d');
            } else {
                BioFlatIndex.exitHelp(opts, 2, "No index name was specified");
            }
            String[] fileNames = cmd.getArgs();
            HashSet<File> seqFiles = new HashSet<File>();
            for (int i = 0; i < fileNames.length; ++i) {
                seqFiles.add(new File(fileNames[i]));
            }
            File index = new File(location, dbName);
            if (create) {
                if (!cmd.hasOption('a')) {
                    BioFlatIndex.exitHelp(opts, 2, "No sequence alphabet was specified");
                }
                if (!cmd.hasOption('f')) {
                    BioFlatIndex.exitHelp(opts, 2, "No sequence format was specified");
                }
                if (fileNames.length == 0) {
                    BioFlatIndex.exitHelp(opts, 2, "No sequence files were specified");
                }
                alphabet = cmd.getOptionValue('a');
                format = cmd.getOptionValue('f');
            } else {
                BioStore store = new BioStore(index, false);
                Annotation metaData = store.getMetaData();
                LifeScienceIdentifier formatSpec = BioFlatIndex.getFormatSpec(metaData);
                alphabet = formatSpec.getObjectId();
                format = formatSpec.getNamespaceId();
                List indexedFiles = BioFlatIndex.getIndexedFiles(metaData);
                seqFiles.addAll(indexedFiles);
            }
            int seqType = SeqIOTools.identifyFormat((String)format, (String)alphabet);
            if (seqType == 0) {
                BioFlatIndex.exitHelp(opts, 2, "Unknown format/alphabet combination: " + format + "/" + alphabet);
            }
            BioFlatIndex.doIndex(dbName, index, seqFiles, seqType);
        }
        catch (MissingOptionException moe) {
            BioFlatIndex.exitHelp(opts, 1, moe.getMessage());
        }
        catch (MissingArgumentException mae) {
            BioFlatIndex.exitHelp(opts, 1, mae.getMessage());
        }
        catch (UnrecognizedOptionException uoe) {
            BioFlatIndex.exitHelp(opts, 1, uoe.getMessage());
        }
        catch (Exception e) {
            BioFlatIndex.exitHelp(opts, 1, e.getMessage());
        }
    }

    private static LifeScienceIdentifier getFormatSpec(Annotation config) throws BioException {
        LifeScienceIdentifier format;
        try {
            String lsid = (String)config.getProperty((Object)"format");
            format = LifeScienceIdentifier.valueOf((String)lsid);
        }
        catch (NoSuchElementException nsee) {
            throw new BioException("Malformed OBDA index does not indicate sequence format", (Throwable)nsee);
        }
        catch (LifeScienceIdentifierParseException lse) {
            throw new BioException("Malformed OBDA index has a format identifier which is not a valid LSID", (Throwable)lse);
        }
        return format;
    }

    private static List getIndexedFiles(Annotation config) {
        ArrayList<File> files = new ArrayList<File>();
        for (String key : config.keys()) {
            if (!key.startsWith("fileid_")) continue;
            String val = (String)config.getProperty((Object)key);
            int tab = val.indexOf("\t");
            files.add(new File(val.substring(0, tab)));
        }
        return files;
    }

    private static void doIndex(String dbName, File index, Set seqFiles, int seqType) throws Exception {
        if (index.exists()) {
            File[] indexedFiles = index.listFiles();
            for (int i = 0; i < indexedFiles.length; ++i) {
                if (indexedFiles[i].canWrite()) {
                    throw new BioException("Unable to modify existing index. " + indexedFiles[i] + " is not writable");
                }
                indexedFiles[i].delete();
            }
            if (!index.canWrite()) {
                throw new BioException("Unable to modify existing index. " + index + " is not writable");
            }
            index.delete();
        }
        File[] files = seqFiles.toArray(new File[0]);
        int formatType = seqType & 0xFFFF;
        int alphaType = seqType & 0xFFFF0000;
        switch (formatType) {
            case 2: {
                IndexTools.indexFasta((String)dbName, (File)index, (File[])files, (int)alphaType);
                break;
            }
            case 10: {
                IndexTools.indexEmbl((String)dbName, (File)index, (File[])files, (int)alphaType);
                break;
            }
            case 12: {
                IndexTools.indexGenbank((String)dbName, (File)index, (File[])files, (int)alphaType);
                break;
            }
            case 524299: {
                IndexTools.indexSwissprot((String)dbName, (File)index, (File[])files);
                break;
            }
            default: {
                throw new IllegalArgumentException("Sequence format not supported");
            }
        }
    }

    private static Options createOptions() {
        Options opts = new Options();
        boolean hasArg = true;
        Option alphabet = new Option("a", "alphabet", hasArg, "Specifies the source file alphabet (required if creating an index)");
        alphabet.setRequired(false);
        Option create = new Option("c", "create", !hasArg, "Create a new index (optional)");
        create.setRequired(false);
        Option dbname = new Option("d", "dbname", hasArg, "Specifies the symbolic database name (used as the index directory name)");
        dbname.setRequired(false);
        Option format = new Option("f", "format", hasArg, "Specifies the source file format (required if creating an index)");
        format.setRequired(false);
        Option help = new Option("h", "help", !hasArg, "Command line help");
        help.setRequired(false);
        Option index = new Option("i", "index", hasArg, "Specifies the indexing scheme (optional, defaults to 'flat')");
        index.setRequired(false);
        Option location = new Option("l", "location", hasArg, "Path to the index root directory (optional, defaults to cwd)");
        location.setRequired(false);
        opts.addOption(alphabet);
        opts.addOption(create);
        opts.addOption(dbname);
        opts.addOption(format);
        opts.addOption(help);
        opts.addOption(index);
        opts.addOption(location);
        return opts;
    }

    private static void exitHelp(Options opts, int exitValue) {
        HelpFormatter help = new HelpFormatter();
        help.printHelp("java org.biojava.app.BioFlatIndex", opts);
        System.exit(exitValue);
    }

    private static void exitHelp(Options opts, int exitValue, String message) {
        if (exitValue == 0) {
            System.out.println(message);
        } else {
            System.err.println(message);
        }
        BioFlatIndex.exitHelp(opts, exitValue);
    }
}

