/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.app;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.db.IllegalIDException;
import org.biojava.bio.seq.db.SequenceDBLite;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.directory.Registry;
import org.biojava.directory.SystemRegistry;

public class BioGetSeq {
    public static void main(String[] argv) throws Exception {
        Options opts = BioGetSeq.createOptions();
        try {
            String namespace;
            CommandLine cmd = new GnuParser().parse(opts, argv);
            if (cmd.hasOption('h')) {
                BioGetSeq.exitHelp(opts, 0);
            }
            if (!(namespace = cmd.getOptionValue('n', "id")).equalsIgnoreCase("ID")) {
                BioGetSeq.exitHelp(opts, 1, "Only the 'ID' namespace is supported");
            }
            String dbname = cmd.getOptionValue('d', "embl");
            String format = cmd.getOptionValue('f', "fasta");
            Registry registry = SystemRegistry.instance();
            SequenceDBLite db = registry.getDatabase(dbname);
            String[] ids = cmd.getArgs();
            for (int i = 0; i < ids.length; ++i) {
                try {
                    Sequence seq = db.getSequence(ids[i]);
                    String alphabet = seq.getAlphabet().getName();
                    int seqType = SeqIOTools.identifyFormat((String)format, (String)alphabet);
                    SequenceFormat sf = SeqIOTools.getSequenceFormat((int)seqType);
                    sf.writeSequence(seq, System.out);
                    continue;
                }
                catch (IllegalIDException iie) {
                    System.err.println(iie.getMessage());
                }
            }
        }
        catch (MissingOptionException moe) {
            BioGetSeq.exitHelp(opts, 1, moe.getMessage());
        }
        catch (MissingArgumentException mae) {
            BioGetSeq.exitHelp(opts, 1, mae.getMessage());
        }
        catch (UnrecognizedOptionException uoe) {
            BioGetSeq.exitHelp(opts, 1, uoe.getMessage());
        }
        catch (Exception e) {
            BioGetSeq.exitHelp(opts, 1, e.getMessage());
        }
    }

    private static Options createOptions() {
        Options opts = new Options();
        boolean hasArg = true;
        Option dbname = new Option("d", "dbname", hasArg, "Specifies a symbolic data source");
        dbname.setRequired(true);
        Option format = new Option("f", "format", hasArg, "Specifies the output format (optional, defaults to 'fasta')");
        format.setRequired(false);
        Option help = new Option("h", "help", !hasArg, "Command line help");
        help.setRequired(false);
        Option namespace = new Option("n", "namespace", hasArg, "Specifies the namespace within which to search (optional, defaults to 'ID')");
        namespace.setRequired(false);
        opts.addOption(dbname);
        opts.addOption(format);
        opts.addOption(help);
        opts.addOption(namespace);
        return opts;
    }

    private static void exitHelp(Options opts, int exitValue) {
        HelpFormatter help = new HelpFormatter();
        help.printHelp("java org.biojava.app.BioGetSeq", opts);
        System.exit(exitValue);
    }

    private static void exitHelp(Options opts, int exitValue, String message) {
        if (exitValue == 0) {
            System.out.println(message);
        } else {
            System.err.println(message);
        }
        BioGetSeq.exitHelp(opts, exitValue);
    }
}

